<?php

class bt_bb_card extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts', array(
			'icon'      					=> '',
			'title'							=> '',
			'html_tag'      				=> 'h4',
			'url'    						=> '',
			'target' 						=> '',
			'icon_size'						=> 'huge',
			'background_color'   			=> '',
			'color_scheme' 					=> '',
			'padding'                		=> 'normal',
			'shape'							=> '',
			'shadow'						=> ''
			
		) ), $atts, $this->shortcode ) );
		
		$class = array( $this->shortcode );
		$data_override_class = array();

		$title = html_entity_decode( $title, ENT_QUOTES, 'UTF-8' );

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		if ( $url != '' ) {
			$class[] = 'btWithLink';
		}

		if ( $background_color != '' ) {
			$el_style = $el_style . 'background-color:' . $background_color . ';';
		}

		$this->responsive_data_override_class(
			$class, $data_override_class,
			array(
				'prefix' => $this->prefix,
				'param' => 'padding',
				'value' => $padding
			)
		);

		$color_scheme_id = NULL;
		if ( is_numeric ( $color_scheme ) ) {
			$color_scheme_id = $color_scheme;
		} else if ( $color_scheme != '' ) {
			$color_scheme_id = bt_bb_get_color_scheme_id( $color_scheme );
		}
		$color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $color_scheme_id - 1 );
		if ( $color_scheme_colors ) $el_style .= '; --card-primary-color:' . $color_scheme_colors[0] . '; --card-secondary-color:' . $color_scheme_colors[1] . ';';
		if ( $color_scheme != '' ) $class[] = $this->prefix . 'color_scheme_' .  $color_scheme_id;

		if ( $shape != '' ) {
			$class[] = $this->prefix . 'shape' . '_' . $shape;
		}

		if ( $shadow != '' ) {
			$class[] = $this->prefix . 'shadow' . '_' . $shadow;
		}

		$link = bt_bb_get_permalink_by_slug( $url );

		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		$class_attr = implode( ' ', $class );

		if ( $el_class != '' ) {
			$class_attr = $class_attr . ' ' . $el_class;
		}

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}

		$output = '<div' . $id_attr . ' class="' . esc_attr( $class_attr ) . '" ' . $style_attr . ' data-bt-override-class="' . htmlspecialchars( json_encode( $data_override_class, JSON_FORCE_OBJECT ), ENT_QUOTES, 'UTF-8' ) . '">';

			// LINK
			if ( $link != '' ) {
				$target_attr = ' target="_self" ';
				if ( $target != '' ) {
					$target_attr = ' ' . 'target="' . esc_attr( $target ) . '"';
				}
				$output .= '<a href="' . esc_url( $link ) . '" ' . $target_attr . ' class="btCardLink"></a>';
			}

			// ICON
			if ( $icon != '' ) $output .= '<div class="' . esc_attr( $this->shortcode . '_icon' ) . '">' . do_shortcode( '[bt_bb_icon icon="' . esc_attr( $icon ) . '" size="' . esc_attr( $icon_size ) . '" style="borderless" shape="square" ignore_fe_editor="true"]' ) . '</div>';

			// HEADLINE
			if ( $title != '' )	$output .= '<div class="' . esc_attr( $this->shortcode . '_title' ) . '">' . do_shortcode('[bt_bb_headline headline="' . esc_attr( $title ) . '" html_tag="'. esc_attr( $html_tag ) .'" size="extrasmall" ignore_fe_editor="true"]' ) . '</div>';

		$output .= '</div>';


		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}

	function map_shortcode() {
		
		$color_scheme_arr = bt_bb_get_color_scheme_param_array();

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Card', 'vivo' ), 'description' => esc_html__( 'Card with icon and text', 'vivo' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				
				array( 'param_name' => 'icon', 'type' => 'iconpicker', 'heading' => esc_html__( 'Icon', 'vivo' ), 'preview' => true ),
				array( 'param_name' => 'title', 'type' => 'textarea', 'heading' => esc_html__( 'Title', 'vivo' ), 'preview' => true ),
				array( 'param_name' => 'padding', 'type' => 'dropdown', 'heading' => esc_html__( 'Inner padding', 'vivo' ), 'preview' => true, 'responsive_override' => true,
					'value' => array(
						esc_html__( 'No padding', 'vivo' ) 	=> 'none',
						esc_html__( 'Normal', 'vivo' ) 		=> 'normal',
						esc_html__( 'Double', 'vivo' ) 		=> 'double',
						esc_html__( 'Text Indent', 'vivo' ) 	=> 'text_indent',
						esc_html__( '5px', 'vivo' ) 			=> '5px',
						esc_html__( '10px', 'vivo' ) 		=> '10px',
						esc_html__( '15px', 'vivo' ) 		=> '15px',
						esc_html__( '20px', 'vivo' ) 		=> '20px',
						esc_html__( '25px', 'vivo' ) 		=> '25px',
						esc_html__( '30px', 'vivo' ) 		=> '30px',
						esc_html__( '35px', 'vivo' ) 		=> '35px',
						esc_html__( '40px', 'vivo' ) 		=> '40px',
						esc_html__( '45px', 'vivo' ) 		=> '45px',
						esc_html__( '50px', 'vivo' ) 		=> '50px',
						esc_html__( '55px', 'vivo' ) 		=> '55px',
						esc_html__( '60px', 'vivo' ) 		=> '60px',
						esc_html__( '65px', 'vivo' ) 		=> '65px',
						esc_html__( '70px', 'vivo' ) 		=> '70px',
						esc_html__( '75px', 'vivo' ) 		=> '75px',
						esc_html__( '80px', 'vivo' ) 		=> '80px',
						esc_html__( '85px', 'vivo' ) 		=> '85px',
						esc_html__( '90px', 'vivo' ) 		=> '90px',
						esc_html__( '95px', 'vivo' ) 		=> '95px',
						esc_html__( '100px', 'vivo' ) 		=> '100px'
					)
				),
				array( 'param_name' => 'html_tag', 'type' => 'dropdown', 'default' => 'h4', 'heading' => esc_html__( 'HTML title tag', 'vivo' ),
					'value' => array(
						esc_html__( 'h1', 'vivo' ) 				=> 'h1',
						esc_html__( 'h2', 'vivo' )	 			=> 'h2',
						esc_html__( 'h3', 'vivo' ) 				=> 'h3',
						esc_html__( 'h4', 'vivo' ) 				=> 'h4',
						esc_html__( 'h5', 'vivo' ) 				=> 'h5',
						esc_html__( 'h6', 'vivo' ) 				=> 'h6'
				) ),
				

				array( 'param_name' => 'url', 'type' => 'link', 'heading' => esc_html__( 'URL', 'vivo' ), 'preview' => true, 'description' => esc_html__( 'Enter full or local URL (e.g. https://www.bold-themes.com or /pages/about-us), post slug (e.g. about-us), #lightbox to open current image in full size or search for existing content.', 'vivo' ), 'group' => esc_html__( 'URL', 'vivo' ) ),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'group' => esc_html__( 'URL', 'vivo' ), 'heading' => esc_html__( 'Target', 'vivo' ),
					'value' => array(
						esc_html__( 'Self (open in same tab)', 'vivo' ) 	=> '_self',
						esc_html__( 'Blank (open in new tab)', 'vivo' ) 	=> '_blank',
					)
				),
				
				array( 'param_name' => 'icon_size', 'type' => 'dropdown', 'default' => '', 'group' => esc_html__( 'Design', 'vivo' ), 'default' => 'huge', 'heading' => esc_html__( 'Icon size', 'vivo' ),
					'value' => array(
						esc_html__( 'Extra small', 'vivo' ) 		=> 'xsmall',
						esc_html__( 'Small', 'vivo' ) 			=> 'small',
						esc_html__( 'Normal', 'vivo' ) 			=> 'normal',
						esc_html__( 'Medium', 'vivo' ) 			=> 'medium',
						esc_html__( 'Large', 'vivo' ) 			=> 'large',
						esc_html__( 'Extra large', 'vivo' ) 		=> 'xlarge',
						esc_html__( 'Huge', 'vivo' ) 			=> 'huge',
						esc_html__( 'Extra huge', 'vivo' ) 		=> 'xhuge'
					)
				),
				array( 'param_name' => 'background_color', 'preview' => true, 'type' => 'colorpicker', 'heading' => esc_html__( 'Background color', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ) ),
				array( 'param_name' => 'color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Color scheme', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ), 'value' => $color_scheme_arr, 'preview' => true ),
				array( 'param_name' => 'shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Shape', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ),
					'value' => array(
						esc_html__( 'Square', 'vivo' ) 			=> 'square',
						esc_html__( 'Soft Rounded', 'vivo' ) 	=> 'soft_rounded',
						esc_html__( 'Medium Rounded', 'vivo' ) 	=> 'medium_rounded',
						esc_html__( 'Hard Rounded', 'vivo' ) 	=> 'hard_rounded'
					)
				),
				array( 'param_name' => 'shadow', 'type' => 'dropdown', 'heading' => esc_html__( 'Shadow', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ),
					'value' => array(
						esc_html__( 'Show', 'vivo' ) 			=> '',
						esc_html__( 'Show on hover', 'vivo' ) 	=> 'on_hover',
						esc_html__( 'Hide', 'vivo' ) 			=> 'hide'
					)
				),
				)
			)
		);
	}
}