<?php

/**
 * Color schemes
 */

if ( ! function_exists( 'vivo_color_schemes' ) ) {
	function vivo_color_schemes( $color_scheme_arr ) {

		$theme_color_schemes = array();
		
		$theme_color_schemes[] = 'accent-light;Accent color, Light color;var(--accent-color);var(--light-color)';
		$theme_color_schemes[] = 'accent-dark;Accent color, Dark color;var(--accent-color);var(--dark-color)';
		
		$theme_color_schemes[] = 'light-accent;Light color, Accent color;var(--light-color);var(--accent-color)';
		$theme_color_schemes[] = 'dark-accent;Dark color, Accent color;var(--dark-color);var(--accent-color)';
		
		$theme_color_schemes[] = 'alternate-light;Alternate color, Light color;var(--alternate-color);var(--light-color)';
		$theme_color_schemes[] = 'alternate-dark;Alternate color, Dark color;var(--alternate-color);var(--dark-color)';
		
		$theme_color_schemes[] = 'light-alternate;Light color, Alternate color;var(--light-color);var(--alternate-color)';
		$theme_color_schemes[] = 'dark-alternate;Dark color, Alternate color;var(--dark-color);var(--alternate-color)';
		
		$theme_color_schemes[] = 'light-dark;Light color, Dark color;var(--light-color);var(--dark-color)';
		$theme_color_schemes[] = 'dark-light;Dark color, Light color;var(--dark-color);var(--light-color)';
		
		$theme_color_schemes[] = 'light-transparent;Light color, Transparent;var(--light-color);var(--transparent-color)';
		$theme_color_schemes[] = 'dark-transparent;Dark color, Transparent;var(--dark-color);var(--transparent-color)';

		$theme_color_schemes[] = 'dark-gray;Dark color, Gray color;var(--dark-color);var(--gray-color)';
		$theme_color_schemes[] = 'dark-light-gray;Dark color, Light gray color;var(--dark-color);var(--light-gray-color)';
		$theme_color_schemes[] = 'dark-dark-gray;Dark color, Dark gray color;var(--dark-color);var(--dark-gray-color)';

		$theme_color_schemes[] = 'accent-alternate;Accent color, Alternate color;var(--accent-color);var(--alternate-color)';
		$theme_color_schemes[] = 'alternate-accent;Alternate color, Accent color;var(--alternate-color);var(--accent-color)';

		$theme_color_schemes[] = 'navy-light-blue;Navy blue color, Light blue color;var(--navy-blue-color);var(--light-blue-color)';
		$theme_color_schemes[] = 'light-navy-blue;Light color, Navy blue color;var(--light-color);var(--navy-blue-color)';
		$theme_color_schemes[] = 'navy-blue-accent;Navy blue color, Accent color;var(--navy-blue-color);var(--accent-color)';

		$theme_color_schemes[] = 'dark-second-gray;Dark color, Gray (second) color;var(--dark-color);var(--gray-second-color)';

		return array_merge( $theme_color_schemes, $color_scheme_arr );
	}
}

add_filter( 'bt_bb_color_scheme_arr', 'vivo_color_schemes' );


/**
* Content responsive table; bt_bb_timetale element
* add_action( 'mptt_shortcode_template_content', 'bt_bb_mptt_shortcode_responsive_content_callback', 30 );
* original file: /plugins/mp-timetable/template-functions/action-shortcode-functions.php
*/
if ( ! function_exists( 'bt_bb_mptt_shortcode_responsive_content_callback' ) ) {
	function bt_bb_mptt_shortcode_responsive_content_callback() {
		global $mptt_shortcode_data;
		if ( $mptt_shortcode_data[ 'params' ][ 'responsive' ] ) { ?>
			<div class="<?php echo esc_attr( apply_filters( 'mptt_shortcode_list_view_class', 'mptt-shortcode-list' ) ) . ' ' . esc_attr( $mptt_shortcode_data[ 'params' ][ 'custom_class' ] ); ?>">		
				<?php if ( ! empty( $mptt_shortcode_data[ 'events_data' ] ) ):
					foreach ( $mptt_shortcode_data[ 'events_data' ][ 'column' ] as $column ): ?>
						<div class="mptt-column">
							<h3 class="mptt-column-title"><?php echo esc_html( $column->post_title ); ?></h3>
							<ul class="mptt-events-list">
								<?php if ( ! empty( $mptt_shortcode_data[ 'events_data' ][ 'column_events' ][ $column->ID ] ) ):
									foreach ( $mptt_shortcode_data[ 'events_data' ][ 'column_events' ][ $column->ID ] as $event ) : ?>
										<li class="mptt-list-event" data-event-id="<?php echo esc_attr( $event->post->post_name ); ?>"
											<?php if ( ! empty( $event->post->color ) ) {
												echo 'style="border-left-color:' . esc_attr( $event->post->color ) . ';"';
											} ?>>
											<div class="mptt-event-details-wrapper">
											<?php if ( $mptt_shortcode_data[ 'params' ][ 'title' ] ):
												$disable_url = (bool) $event->post->timetable_disable_url || (bool) $mptt_shortcode_data[ 'params' ][ 'disable_event_url' ];
												if ( ! $disable_url ) { 
													
													$href_url =   ( $event->post->timetable_custom_url != "" ) ? esc_url( $event->post->timetable_custom_url ) : get_permalink( $event->event_id );
													
													?>
													<a title="<?php echo esc_attr( $event->post->post_title ); ?>" href="<?php echo esc_url( $href_url ); ?>" class="mptt-event-title">
												<?php }
												echo esc_html( $event->post->post_title );
												
												if ( ! $disable_url ) { ?>
													</a>
												<?php }
											
											endif;
											if ( $mptt_shortcode_data[ 'params' ][ 'time' ] ): ?>
												<p class="timeslot">
													<time datetime="<?php echo esc_attr( $event->event_start ); ?>" class="timeslot-start"><?php
														echo esc_html( date( get_option( 'time_format' ), strtotime( $event->event_start ) ) ); ?></time>
													<span class="timeslot-delimiter"><?php echo apply_filters( 'mptt_timeslot_delimiter', ' - ' ); ?></span>
													<time datetime="<?php echo esc_attr( $event->event_end ); ?>" class="timeslot-end"><?php
														echo esc_html( date( get_option( 'time_format' ), strtotime( $event->event_end ) ) ); ?></time>
												</p>
											<?php endif;
											if ( $mptt_shortcode_data[ 'params' ][ 'sub-title' ] && ! empty( $event->post->sub_title ) ): ?>
												<p class="event-subtitle"><?php echo wp_kses_post( $event->post->sub_title ); ?></p>
											<?php endif;
											if ( $mptt_shortcode_data[ 'params' ][ 'description' ] ): ?>
												<p class="event-description"><?php
													echo wp_kses_post( stripslashes( $event->description ) );
												?></p>
											<?php endif; ?>
											</div>
					
											<?php apply_filters( 'bt_bb_mpt_custom_content_event' , $event ); 

											if ( $mptt_shortcode_data[ 'params' ][ 'user' ] && ( $event->user_id != '-1' ) ): ?>
												<p class="event-user"><?php $user_info = get_userdata( $event->user_id );
													if ( $user_info ) {
														echo get_avatar( $event->user_id, apply_filters( 'mptt-event-user-avatar-size', 24 ), '', $user_info->data->display_name ) . ' ';
														echo esc_html( $user_info->data->display_name );
													} ?></p>
											<?php endif; ?>
										</li>
									<?php endforeach;
								endif; ?>
							</ul>
						</div>
					<?php endforeach;
				endif; ?>
			</div>
		<?php }
	}
}