<?php

/**
 * Returns share icons HTML
 *
 * @return string
 */
if ( ! function_exists( 'bt_bb_get_share_html' ) ) {
	function bt_bb_get_share_html( $permalink, $type = 'blog' ) {
		$share_html = '';
		if ( function_exists( 'boldthemes_share_html' ) && function_exists( 'boldthemes_get_option' ) && function_exists( 'boldthemes_get_prefix' ) ) { 
			$prefix			= boldthemes_get_prefix();			
			if ( $prefix !== '' ) {
				$share_slug		= is_single() ? $prefix . '_single_share' : $prefix . '_list_share';
				$size			= boldthemes_get_option( $share_slug . '_size' );
				$style			= boldthemes_get_option( $share_slug . '_style' );
				$shape			= boldthemes_get_option( $share_slug . '_shape' );
				$color_scheme	= boldthemes_get_option( $share_slug . '_color_scheme' );
				$args			= array( 'size' => $size, 'style' => $style, 'shape' => $shape, 'color_scheme' => $color_scheme);
				
				$share_html		.= boldthemes_share_html( boldthemes_get_option( $share_slug ), $args );
				return $share_html;
			}
		}			
		
		if ( function_exists( 'boldthemes_get_option' ) && class_exists( 'BoldThemes_Customize_Default' ) ) {		
			$share_facebook = isset( BoldThemes_Customize_Default::$data[ $type . '_share_facebook' ] ) ? boldthemes_get_option( $type . '_share_facebook' ) : false;
			$share_twitter = isset( BoldThemes_Customize_Default::$data[ $type . '_share_twitter' ] ) ? boldthemes_get_option( $type . '_share_twitter' ) : false;
			$share_linkedin = isset( BoldThemes_Customize_Default::$data[ $type . '_share_linkedin' ] ) ? boldthemes_get_option( $type . '_share_linkedin' ) : false;
			$share_vk = isset( BoldThemes_Customize_Default::$data[ $type . '_share_vk' ] ) ? boldthemes_get_option( $type . '_share_vk' ) : false;
			$share_whatsapp = isset( BoldThemes_Customize_Default::$data[ $type . '_share_whatsapp' ] ) ? boldthemes_get_option( $type . '_share_whatsapp' ) : false;
		} else {
			$share_facebook = true;
			$share_twitter	= true;
			$share_linkedin = true;
			$share_vk		= true;
			$share_whatsapp = true;
		}

		if ( $share_facebook || $share_twitter || $share_linkedin || $share_vk || $share_whatsapp ) {

			if ( $share_facebook ) {
				if ( function_exists( 'boldthemes_get_option' ) ) {
					$share_html .= boldthemes_get_icon_html( array( 'icon' => 'fa_f09a', 'url' => $share_url, 'el_class' => 'bt_facebook' ) );
				} else {
					$share_html .= do_shortcode( '[bt_bb_icon icon="fa_f09a" url="' . esc_url( $share_url ) . '"]' );
				}
			}
			if ( $share_twitter ) {
				if ( function_exists( 'boldthemes_get_option' ) ) {
					$share_html .= boldthemes_get_icon_html( array( 'icon' => 'fa_f099', 'url' => esc_url( $share_url ), 'el_class' => 'bt_twitter' ) );
				} else {
					$share_html .= do_shortcode( '[bt_bb_icon icon="fa_f099" url="' . esc_url( $share_url ) . '"]' );
				}
			}
			if ( $share_linkedin ) {
				if ( function_exists( 'boldthemes_get_option' ) ) {
					$share_html .= boldthemes_get_icon_html( array( 'icon' => 'fa_f0e1', 'url' => esc_url( $share_url ), 'el_class' => 'bt_linkedin' ) );
				} else {
					$share_html .= do_shortcode( '[bt_bb_icon icon="fa_f0e1" url="' . esc_url( $share_url ) . '"]' );
				}
			}
			if ( $share_vk ) {
				if ( function_exists( 'boldthemes_get_option' ) ) {
					$share_html .= boldthemes_get_icon_html( array( 'icon' => 'fa_f189', 'url' => esc_url( $share_url ), 'el_class' => 'bt_vk' ) );
				} else {
					$share_html .= do_shortcode( '[bt_bb_icon icon="fa_f189" url="' . esc_url( $share_url ) . '"]' );
				}
			}
			if ( $share_whatsapp ) {
				if ( function_exists( 'boldthemes_get_option' ) ) {
					$share_html .= boldthemes_get_icon_html( array( 'icon' => 'fa_f232', 'url' => $share_url, 'el_class' => 'bt_whatsapp' ) );
				} else {
					$share_html .= do_shortcode( '[bt_bb_icon icon="fa_f232" url="' . esc_url( $share_url ) . '"]' );
				}
			}
		}
		
		return $share_html;
	}
}

// COLOR SCHEME
if ( is_file( dirname(__FILE__) . '/../../../../../plugins/bold-page-builder/content_elements_misc/misc.php' ) ) {
	require_once( dirname(__FILE__) . '/../../../../../plugins/bold-page-builder/content_elements_misc/misc.php' );
}

if ( function_exists('bt_bb_get_color_scheme_param_array') ) {
	$color_scheme_arr = bt_bb_get_color_scheme_param_array();
} else {
	$color_scheme_arr = array();
}



// SECTION - NEGATIVE TOP MARGIN, MAX WIDTH, SHAPE
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_section', 'background_overlay' );
}


if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_section', array(
		array( 'param_name' => 'background_overlay', 'type' => 'dropdown', 'heading' => esc_html__( 'Background overlay', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ), 
			'value' => array(
				esc_html__( 'No overlay', 'vivo' )    		=> '',
				esc_html__( 'Light stripes', 'vivo' ) 		=> 'light_stripes',
				esc_html__( 'Dark stripes', 'vivo' )  		=> 'dark_stripes',
				esc_html__( 'Light solid', 'vivo' )	  		=> 'light_solid',
				esc_html__( 'Dark solid', 'vivo' )	  		=> 'dark_solid',
				esc_html__( 'Light gradient', 'vivo' )	 	=> 'light_gradient',
				esc_html__( 'Dark gradient', 'vivo' )	 	=> 'dark_gradient',
				esc_html__( 'Light top gradient', 'vivo' )	=> 'light_top_gradient',
				esc_html__( 'Light bottom gradient', 'vivo' )	=> 'light_bottom_gradient'
			)
		),
		array( 'param_name' => 'negative_margin', 'type' => 'dropdown', 'default' => '', 'heading' => esc_html__( 'Negative margin', 'vivo' ), 'responsive_override' => true,
			'value' => array(
				esc_html__( 'No margin', 'vivo' ) 		=> 'none',
				esc_html__( 'Extra small', 'vivo' ) 		=> 'extra_small',
				esc_html__( 'Small', 'vivo' ) 			=> 'small',		
				esc_html__( 'Normal', 'vivo' ) 			=> 'normal',
				esc_html__( 'Medium', 'vivo' ) 			=> 'medium',
				esc_html__( 'Large', 'vivo' ) 			=> 'large',
				esc_html__( 'Extra large', 'vivo' ) 		=> 'extra_large'
			)
		),
		array( 'param_name' => 'max_width', 'type' => 'dropdown', 'default' => '', 'heading' => esc_html__( 'Max section width', 'vivo' ), 'description' => 'Maximum section width',
			'value' => array(
				esc_html__( 'Inherit', 'vivo' ) 			=> '',
				esc_html__( '1600px', 'vivo' ) 			=> '1600'
			)
		),
		array( 'param_name' => 'shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Shape', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ),
			'value' => array(
				esc_html__( 'Square', 'vivo' ) 			=> '',
				esc_html__( 'Soft Rounded', 'vivo' ) 	=> 'soft-rounded',
				esc_html__( 'Hard Rounded', 'vivo' ) 	=> 'hard-rounded'
			)
		),
		array( 'param_name' => 'allow_content_outside', 'type' => 'dropdown', 'heading' => esc_html__( 'Top & Bottom Coverage Images position', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ),
			'value' => array(
				esc_html__( 'Top & Bottom Coverage Image above content', 'vivo' ) 			=> '',
				esc_html__( 'Top & Bottom Coverage Image under content', 'vivo' ) 			=> 'under'
			)
		),
	));
}

add_filter( 'bt_bb_section_extra_responsive_data_override_param', function( $params ) { 
	$params[] = 'negative_margin';
	return $params;
});


function vivo_bt_bb_section_class( $class, $atts ) {
	if ( isset( $atts['max_width'] ) && $atts['max_width'] != '' ) {
		$class[] = 'bt_bb_max_width' . '_' . $atts['max_width'];
	}
	if ( isset( $atts['shape'] ) && $atts['shape'] != '' ) {
		$class[] = 'bt_bb_shape' . '_' . $atts['shape'];
	}
	if ( isset( $atts['allow_content_outside'] ) && $atts['allow_content_outside'] != '' ) {
		$class[] = 'bt_bb_allow_content_outside' . '_' . $atts['allow_content_outside'];
	}
	return $class;
}

add_filter( 'bt_bb_section_class', 'vivo_bt_bb_section_class', 10, 2 );




// ROW - SHAPE, BACKGROUND IMAGE
if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_row', array(
		array( 'param_name' => 'background_image', 'type' => 'attach_image',  'preview' => true, 'heading' => esc_html__( 'Background image', 'vivo' ), 'group' => esc_html__( 'General', 'vivo' ) ),
		array( 'param_name' => 'shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Shape', 'vivo' ), 'preview' => true, 'group' => esc_html__( 'Design', 'vivo' ),
			'value' => array(
				esc_html__( 'Square', 'vivo' ) 					=> '',
				esc_html__( 'Soft Rounded', 'vivo' ) 			=> 'soft-rounded',
				esc_html__( 'Hard Rounded', 'vivo' ) 			=> 'hard-rounded'
			)
		),
	));
}

function vivo_bt_bb_row_class( $class, $atts ) {
	if ( isset( $atts['shape'] ) && $atts['shape'] != '' ) {
		$class[] = 'bt_bb_shape' . '_' . $atts['shape'];
	}
	if ( isset( $atts['background_image'] ) && $atts['background_image'] != '' ) {
		$class[] = 'bt_bb_row_with_bg_image';
	}
	return $class;
}

function vivo_bt_bb_row_style( $style_attr, $atts ) {
	if ( isset( $atts['background_image'] ) && $atts['background_image'] != '' ) {
		$background_image = wp_get_attachment_image_src( $atts['background_image'], 'full' );
		$background_image_url = $background_image[0];
		$background_image_style = 'background-image:url("' . $background_image_url . '");';
		$style_attr .= $background_image_style;
	}
	return $style_attr;
}

add_filter( 'bt_bb_row_class', 'vivo_bt_bb_row_class', 10, 2 );
add_filter( 'bt_bb_row_style', 'vivo_bt_bb_row_style', 10, 2 );



// INNER ROW - COLOR SCHEME, SHAPE
if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_row_inner', array(
		array( 'param_name' => 'color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Color scheme', 'vivo' ), 'value' => $color_scheme_arr ),
		array( 'param_name' => 'shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Shape', 'vivo' ), 'preview' => true,
			'value' => array(
				esc_html__( 'Square', 'vivo' ) 					=> '',
				esc_html__( 'Soft Rounded', 'vivo' ) 			=> 'soft-rounded',
				esc_html__( 'Hard Rounded', 'vivo' ) 			=> 'hard-rounded'
			)
		),
	));
}

function vivo_bt_bb_row_inner_class( $class, $atts ) {
	if ( isset( $atts['color_scheme'] ) && $atts['color_scheme'] != '' ) {
		$class[] = 'bt_bb_color_scheme' . '_' . bt_bb_get_color_scheme_id( $atts['color_scheme'] );
	}
	if ( isset( $atts['shape'] ) && $atts['shape'] != '' ) {
		$class[] = 'bt_bb_shape' . '_' . $atts['shape'];
	}
	return $class;
}

function vivo_bt_bb_row_inner_style( $style, $atts ) {
	if ( isset( $atts['color_scheme'] ) && $atts['color_scheme'] != '' ) {
	
		$color_scheme_id = NULL;
		if ( is_numeric ( $atts['color_scheme'] ) ) {
			$color_scheme_id = $atts['color_scheme'];
		} else if ( $atts['color_scheme'] != '' ) {
			$color_scheme_id = bt_bb_get_color_scheme_id( $atts['color_scheme'] );
		}
		$color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $color_scheme_id - 1 );
		if ( $color_scheme_colors ) $style .= '; --primary-color:' . $color_scheme_colors[0] . '; --secondary-color:' . $color_scheme_colors[1] . ';';
	}
	return $style;
}

add_filter( 'bt_bb_row_inner_class', 'vivo_bt_bb_row_inner_class', 10, 2 );
add_filter( 'bt_bb_row_inner_style', 'vivo_bt_bb_row_inner_style', 10, 2 );




// COLUMN - SHADOW, SHAPE, BORDER
if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_column', array(
		array( 'param_name' => 'shadow', 'type' => 'dropdown', 'heading' => esc_html__( 'Shadow', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ),
			'value' => array(
				esc_html__( 'No', 'vivo' ) 						=> '',
				esc_html__( 'Yes', 'vivo' ) 						=> 'show'
			)
		),
		array( 'param_name' => 'shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Shape', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ), 'preview' => true,
			'value' => array(
				esc_html__( 'Square', 'vivo' ) 					=> '',
				esc_html__( 'Soft Rounded', 'vivo' ) 			=> 'soft-rounded',
				esc_html__( 'Hard Rounded', 'vivo' ) 			=> 'hard-rounded'
			)
		),
		array( 'param_name' => 'inner_border', 'type' => 'dropdown', 'heading' => esc_html__( 'Inner Border', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ), 'preview' => true,
			'value' => array(
				esc_html__( 'No', 'vivo' ) 						=> '',
				esc_html__( 'Light border', 'vivo' ) 			=> 'light',
				esc_html__( 'Dark border', 'vivo' ) 				=> 'dark',
				esc_html__( 'Accent border', 'vivo' ) 			=> 'accent',
				esc_html__( 'Alternate border', 'vivo' ) 		=> 'alternate',
				esc_html__( 'Light blue border', 'vivo' ) 		=> 'light_blue'
			)
		),
		array( 'param_name' => 'border_thickness', 'type' => 'dropdown', 'default' => '2px', 'heading' => esc_html__( 'Border tickness', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ),
			'value' => array(
				esc_html__( '1px', 'vivo' ) 	=> '1px',
				esc_html__( '2px', 'vivo' ) 	=> '2px',
				esc_html__( '3px', 'vivo' ) 	=> '3px',
				esc_html__( '4px', 'vivo' ) 	=> '4px',
				esc_html__( '5px', 'vivo' )	=> '5px',
				esc_html__( '6px', 'vivo' ) 	=> '6px',
				esc_html__( '7px', 'vivo' ) 	=> '7px',
				esc_html__( '8px', 'vivo' ) 	=> '8px',
				esc_html__( '9px', 'vivo' ) 	=> '9px',
				esc_html__( '10px', 'vivo' ) => '10px'
			)
		),
	));
}

function vivo_bt_bb_column_class( $class, $atts ) {
	if ( isset( $atts['shadow'] ) && $atts['shadow'] != '' ) {
		$class[] = 'bt_bb_shadow' . '_' . $atts['shadow'];
	}
	if ( isset( $atts['shape'] ) && $atts['shape'] != '' ) {
		$class[] = 'bt_bb_shape' . '_' . $atts['shape'];
	}
	if ( isset( $atts['inner_border'] ) && $atts['inner_border'] != '' ) {
		$class[] = 'bt_bb_inner_border' . '_' . $atts['inner_border'];
	}
	if ( isset( $atts['border_thickness'] ) && $atts['border_thickness'] != '' ) {
		$class[] = 'bt_bb_border_thickness' . '_' . $atts['border_thickness'];
	}
	return $class;
}

add_filter( 'bt_bb_column_class', 'vivo_bt_bb_column_class', 10, 2 );




// INNER COLUMN - SHADOW, SHAPE
if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_column_inner', array(
		array( 'param_name' => 'shadow', 'type' => 'dropdown', 'heading' => esc_html__( 'Shadow', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ),
			'value' => array(
				esc_html__( 'No', 'vivo' ) 						=> '',
				esc_html__( 'Yes', 'vivo' ) 						=> 'show'
			)
		),
		array( 'param_name' => 'shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Shape', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ), 'preview' => true,
			'value' => array(
				esc_html__( 'Square', 'vivo' ) 					=> '',
				esc_html__( 'Soft Rounded', 'vivo' ) 			=> 'soft-rounded',
				esc_html__( 'Hard Rounded', 'vivo' ) 			=> 'hard-rounded'
			)
		),
	));
}

function vivo_bt_bb_column_inner_class( $class, $atts ) {
	if ( isset( $atts['shadow'] ) && $atts['shadow'] != '' ) {
		$class[] = 'bt_bb_shadow' . '_' . $atts['shadow'];
	}
	if ( isset( $atts['shape'] ) && $atts['shape'] != '' ) {
		$class[] = 'bt_bb_shape' . '_' . $atts['shape'];
	}
	return $class;
}

add_filter( 'bt_bb_column_inner_class', 'vivo_bt_bb_column_inner_class', 10, 2 );


// SEPARATOR
if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_separator', array(
		array( 'param_name' => 'opacity', 'type' => 'dropdown', 'heading' => esc_html__( 'Opacity', 'vivo' ), 
			'value' => array(
				esc_html__( 'Inherit', 'vivo' ) 					=> '',
				esc_html__( 'Solid', 'vivo' ) 					=> 'solid'
			)
		),
	));
}

function vivo_bt_bb_separator_class( $class, $atts ) {
	if ( isset( $atts['opacity'] ) && $atts['opacity'] != '' ) {
		$class[] = 'bt_bb_opacity' . '_' . $atts['opacity'];
	}
	return $class;
}

add_filter( 'bt_bb_separator_class', 'vivo_bt_bb_separator_class', 10, 2 );




// HEADLINE - SIZE, SUPERTITLE COLOR
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_headline', 'size' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_headline', array(
		array( 'param_name' => 'size', 'type' => 'dropdown', 'preview' => true, 'heading' => esc_html__( 'Size', 'vivo' ), 'description' => 'Predefined heading sizes, independent of html tag', 'responsive_override' => true,
			'value' => array(
				esc_html__( 'Inherit', 'vivo' ) 				=> 'inherit',
				esc_html__( 'Extra small', 'vivo' ) 			=> 'extrasmall',
				esc_html__( 'Small', 'vivo' ) 				=> 'small',
				esc_html__( 'Medium', 'vivo' ) 				=> 'medium',
				esc_html__( 'Normal', 'vivo' ) 				=> 'normal',
				esc_html__( 'Large', 'vivo' ) 				=> 'large',
				esc_html__( 'Extra large', 'vivo' ) 			=> 'extralarge',
				esc_html__( 'Huge', 'vivo' ) 				=> 'huge',
				esc_html__( 'Extra huge', 'vivo' ) 			=> 'extrahuge'
			)
		),
		array( 'param_name' => 'supertitle_color', 'type' => 'dropdown', 'heading' => esc_html__( 'Supertitle color', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ),
			'value' => array(
				esc_html__( 'Inherit', 'vivo' ) 					=> '',
				esc_html__( 'Accent color', 'vivo' ) 			=> 'accent',
				esc_html__( 'Alternate color', 'vivo' ) 			=> 'alternate',
				esc_html__( 'Light color', 'vivo' ) 				=> 'light',
				esc_html__( 'Dark color', 'vivo' ) 				=> 'dark'
			)
		),
		array( 'param_name' => 'dash_color', 'type' => 'dropdown', 'heading' => esc_html__( 'Dash color', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ),
			'value' => array(
				esc_html__( 'Inherit', 'vivo' ) 					=> '',
				esc_html__( 'Accent color', 'vivo' ) 			=> 'accent',
				esc_html__( 'Alternate color', 'vivo' ) 			=> 'alternate',
				esc_html__( 'Light color', 'vivo' ) 				=> 'light',
				esc_html__( 'Dark color', 'vivo' ) 				=> 'dark'
			)
		),
	));
}

function vivo_bt_bb_headline_class( $class, $atts ) {
	if ( isset( $atts['headline'] ) && $atts['headline'] == '' ) {
		$class[] = 'btNoHeadline';
	}
	if ( isset( $atts['supertitle_color'] ) && $atts['supertitle_color'] != '' ) {
		$class[] = 'bt_bb_supertitle_color' . '_' . $atts['supertitle_color'];
	}
	if ( isset( $atts['dash_color'] ) && $atts['dash_color'] != '' ) {
		$class[] = 'bt_bb_dash_color' . '_' . $atts['dash_color'];
	}
	return $class;
}
add_filter( 'bt_bb_headline_class', 'vivo_bt_bb_headline_class', 10, 2 );




// ICON - SIZE, NEGATIVE MARGIN TOP, LEFT, RIGHT, BOTTOM, TEXT SIZE
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_icon', 'size' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_icon', array(
		array( 'param_name' => 'size', 'type' => 'dropdown', 'default' => 'small', 'heading' => esc_html__( 'Size', 'vivo' ), 'preview' => true, 'group' => esc_html__( 'Design', 'vivo' ), 'responsive_override' => true,
			'value' => array(
				esc_html__( 'Extra small', 'vivo' ) 		=> 'xsmall',
				esc_html__( 'Small', 'vivo' ) 			=> 'small',
				esc_html__( 'Normal', 'vivo' ) 			=> 'normal',
				esc_html__( 'Medium', 'vivo' ) 			=> 'medium',
				esc_html__( 'Large', 'vivo' ) 			=> 'large',
				esc_html__( 'Extra large', 'vivo' ) 		=> 'xlarge',
				esc_html__( 'Huge', 'vivo' ) 			=> 'huge',
				esc_html__( 'Extra huge', 'vivo' ) 		=> 'xhuge',
				esc_html__( 'Extra extra huge', 'vivo' ) => 'xxhuge',
				esc_html__( 'Very huge', 'vivo' ) 		=> 'veryhuge'
			)
		),
		array( 'param_name' => 'text_size', 'type' => 'dropdown', 'heading' => esc_html__( 'Text size', 'vivo' ),
			'value' => array(
				esc_html__( 'Default', 'vivo' ) 				=> '',
				esc_html__( '12px', 'vivo' ) 				=> '12px',
				esc_html__( '13px', 'vivo' ) 				=> '13px',
				esc_html__( '14px', 'vivo' ) 				=> '14px',
				esc_html__( '15px', 'vivo' ) 				=> '15px',
				esc_html__( '16px', 'vivo' ) 				=> '16px',
				esc_html__( '17px', 'vivo' ) 				=> '17px'
			)
		),
		array( 'param_name' => 'negative_margin', 'type' => 'dropdown', 'group' => esc_html__( 'Margin', 'vivo' ), 'default' => '', 'heading' => esc_html__( 'Negative top margin', 'vivo' ), 'responsive_override' => true,
			'value' => array(
				esc_html__( 'None', 'vivo' ) 		=> 'none',
				esc_html__( '5px', 'vivo' ) 			=> '5px',
				esc_html__( '10px', 'vivo' ) 		=> '10px',
				esc_html__( '15px', 'vivo' ) 		=> '15px',
				esc_html__( '20px', 'vivo' ) 		=> '20px',
				esc_html__( '25px', 'vivo' ) 		=> '25px',
				esc_html__( '30px', 'vivo' ) 		=> '30px',
				esc_html__( '35px', 'vivo' ) 		=> '35px',
				esc_html__( '40px', 'vivo' ) 		=> '40px',
				esc_html__( '45px', 'vivo' ) 		=> '45px',
				esc_html__( '50px', 'vivo' ) 		=> '50px'
			)
		),
		array( 'param_name' => 'negative_left_margin', 'type' => 'dropdown', 'group' => esc_html__( 'Margin', 'vivo' ), 'default' => '', 'heading' => esc_html__( 'Negative left margin', 'vivo' ), 'responsive_override' => true,
			'value' => array(
				esc_html__( 'None', 'vivo' ) 		=> 'none',
				esc_html__( '5px', 'vivo' ) 			=> '5px',
				esc_html__( '10px', 'vivo' ) 		=> '10px',
				esc_html__( '15px', 'vivo' ) 		=> '15px',
				esc_html__( '20px', 'vivo' ) 		=> '20px',
				esc_html__( '25px', 'vivo' ) 		=> '25px',
				esc_html__( '30px', 'vivo' ) 		=> '30px',
				esc_html__( '35px', 'vivo' ) 		=> '35px',
				esc_html__( '40px', 'vivo' ) 		=> '40px',
				esc_html__( '45px', 'vivo' ) 		=> '45px',
				esc_html__( '50px', 'vivo' ) 		=> '50px'
			)
		),
		array( 'param_name' => 'negative_right_margin', 'type' => 'dropdown', 'group' => esc_html__( 'Margin', 'vivo' ), 'default' => '', 'heading' => esc_html__( 'Negative right margin', 'vivo' ), 'responsive_override' => true,
			'value' => array(
				esc_html__( 'None', 'vivo' ) 		=> 'none',
				esc_html__( '5px', 'vivo' ) 			=> '5px',
				esc_html__( '10px', 'vivo' ) 		=> '10px',
				esc_html__( '15px', 'vivo' ) 		=> '15px',
				esc_html__( '20px', 'vivo' ) 		=> '20px',
				esc_html__( '25px', 'vivo' ) 		=> '25px',
				esc_html__( '30px', 'vivo' ) 		=> '30px',
				esc_html__( '35px', 'vivo' ) 		=> '35px',
				esc_html__( '40px', 'vivo' ) 		=> '40px',
				esc_html__( '45px', 'vivo' ) 		=> '45px',
				esc_html__( '50px', 'vivo' ) 		=> '50px'
			)
		),
		array( 'param_name' => 'negative_bottom_margin', 'type' => 'dropdown', 'group' => esc_html__( 'Margin', 'vivo' ), 'default' => '', 'heading' => esc_html__( 'Negative bottom margin', 'vivo' ), 'responsive_override' => true,
			'value' => array(
				esc_html__( 'None', 'vivo' ) 		=> 'none',
				esc_html__( '5px', 'vivo' ) 			=> '5px',
				esc_html__( '10px', 'vivo' ) 		=> '10px',
				esc_html__( '15px', 'vivo' ) 		=> '15px',
				esc_html__( '20px', 'vivo' ) 		=> '20px',
				esc_html__( '25px', 'vivo' ) 		=> '25px',
				esc_html__( '30px', 'vivo' ) 		=> '30px',
				esc_html__( '35px', 'vivo' ) 		=> '35px',
				esc_html__( '40px', 'vivo' ) 		=> '40px',
				esc_html__( '45px', 'vivo' ) 		=> '45px',
				esc_html__( '50px', 'vivo' ) 		=> '50px'
			)
		),

	));
}

add_filter( 'bt_bb_icon_extra_responsive_data_override_param', function( $params ) { 
	$params[] = 'negative_margin';
	return $params;
});

add_filter( 'bt_bb_icon_extra_responsive_data_override_param', function( $params ) { 
	$params[] = 'negative_left_margin';
	return $params;
});

add_filter( 'bt_bb_icon_extra_responsive_data_override_param', function( $params ) { 
	$params[] = 'negative_right_margin';
	return $params;
});

add_filter( 'bt_bb_icon_extra_responsive_data_override_param', function( $params ) { 
	$params[] = 'negative_bottom_margin';
	return $params;
});


function vivo_bt_bb_icon_class( $class, $atts ) {
	if ( isset( $atts['text_size'] ) && $atts['text_size'] != '' ) {
		$class[] = 'bt_bb_text_size' . '_' . $atts['text_size'];
	}
	return $class;
}
add_filter( 'bt_bb_icon_class', 'vivo_bt_bb_icon_class', 10, 2 );



// BUTTON - STYLE
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_button', 'style' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_button', array(
		array( 'param_name' => 'style', 'type' => 'dropdown', 'heading' => esc_html__( 'Style', 'vivo' ), 'preview' => true, 'weight' => 2, 'group' => esc_html__( 'Design', 'vivo' ),
			'value' => array(
				esc_html__( 'Outline', 'vivo' ) 			=> 'outline',
				esc_html__( 'Filled', 'vivo' ) 			=> 'filled',
				esc_html__( 'Filled gradient', 'vivo' ) 	=> 'filled_gradient',
				esc_html__( 'Clean', 'vivo' ) 			=> 'clean',
				esc_html__( 'With line', 'vivo' ) 		=> 'line'
			)
		),
	));
}


// SLIDER - NAVIGATION POSITION, ARROWS COLOR SCHEME, LINES POSITION, LINES COLOR SCHEME, NEGATIVE MARGIN
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_content_slider', 'arrows_size' );
}

if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_content_slider', 'show_dots' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_content_slider', array(
		array( 'param_name' => 'navigation_position', 'type' => 'dropdown', 'heading' => esc_html__( 'Arrows navigation position', 'vivo' ), 'group' => esc_html__( 'Navigation', 'vivo' ),
			'value' => array(
				esc_html__( 'On side', 'vivo' ) 					=> '',
				esc_html__( 'Outside the slider', 'vivo' ) 		=> 'outside'
			)
		),
		array( 'param_name' => 'arrows_size', 'type' => 'dropdown', 'preview' => true, 'group' => esc_html__( 'Navigation', 'vivo' ), 'default' => 'normal', 'heading' => esc_html__( 'Arrows navigation size', 'vivo' ),
			'value' => array(
				esc_html__( 'No arrows', 'vivo' ) 	=> 'no_arrows',
				esc_html__( 'Small', 'vivo' ) 		=> 'small',
				esc_html__( 'Normal', 'vivo' ) 		=> 'normal',
				esc_html__( 'Large', 'vivo' ) 		=> 'large'
			)
		),
		array( 'param_name' => 'arrows_color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Arrows navigation color scheme', 'vivo' ), 'group' => esc_html__( 'Navigation', 'vivo' ), 'value' => $color_scheme_arr ),
		array( 'param_name' => 'show_dots', 'type' => 'dropdown', 'heading' => esc_html__( 'Lines navigation position', 'vivo' ), 'group' => esc_html__( 'Navigation', 'vivo' ),
			'value' => array(
				esc_html__( 'Lines on middle bottom (arrows on side)', 'vivo' ) 		=> 'bottom',
				esc_html__( 'Lines below bottom (arrows on side)', 'vivo' ) 			=> 'below',
				esc_html__( 'Lines on bottom left (arows on right)', 'vivo' ) 		=> 'left',
				esc_html__( 'Lines on bottom right (arrows on left)', 'vivo' ) 		=> 'right',
				esc_html__( 'Lines on top left (arows on right)', 'vivo' ) 			=> 'top_left',
				esc_html__( 'Lines on top right (arrows on left)', 'vivo' ) 			=> 'top_right',
				esc_html__( 'Lines on top right (arrows on side)', 'vivo' ) 			=> 'top_right_side',
				esc_html__( 'Lines on top left (arrows on side)', 'vivo' ) 			=> 'top_left_side',
				esc_html__( 'Hide lines', 'vivo' ) 									=> 'hide'
			)
		),
		array( 'param_name' => 'navigation_color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Lines navigation color scheme', 'vivo' ), 'group' => esc_html__( 'Navigation', 'vivo' ), 'value' => $color_scheme_arr ),
		array( 'param_name' => 'negative_top_margin', 'type' => 'dropdown', 'default' => '', 'heading' => esc_html__( 'Negative top margin', 'vivo' ), 'responsive_override' => true,
			'value' => array(
				esc_html__( 'None', 'vivo' ) 		=> 'none',
				esc_html__( '5px', 'vivo' ) 			=> '5px',
				esc_html__( '10px', 'vivo' ) 		=> '10px',
				esc_html__( '15px', 'vivo' ) 		=> '15px',
				esc_html__( '20px', 'vivo' ) 		=> '20px',
				esc_html__( '25px', 'vivo' ) 		=> '25px',
				esc_html__( '30px', 'vivo' ) 		=> '30px',
				esc_html__( '35px', 'vivo' ) 		=> '35px',
				esc_html__( '40px', 'vivo' ) 		=> '40px',
				esc_html__( '45px', 'vivo' ) 		=> '45px',
				esc_html__( '50px', 'vivo' ) 		=> '50px'
			)
		),
	));
}

add_filter( 'bt_bb_content_slider_extra_responsive_data_override_param', function( $params ) { 
	$params[] = 'negative_top_margin';
	return $params;
});

function vivo_bt_bb_content_slider_class( $class, $atts ) {
	if ( isset( $atts['navigation_position'] ) && $atts['navigation_position'] != '' ) {
		$class[] = 'bt_bb_navigation_position' . '_' . $atts['navigation_position'];
	}
	if ( isset( $atts['navigation_color_scheme'] ) && $atts['navigation_color_scheme'] != '' ) {
		$class[] = 'bt_bb_navigation_color_scheme' . '_' . bt_bb_get_color_scheme_id( $atts['navigation_color_scheme'] );
	}
	if ( isset( $atts['arrows_color_scheme'] ) && $atts['arrows_color_scheme'] != '' ) {
		$class[] = 'bt_bb_arrows_color_scheme' . '_' . bt_bb_get_color_scheme_id( $atts['arrows_color_scheme'] );
	}
	return $class;
}

function vivo_bt_bb_content_slider_style( $style, $atts ) {
	if ( isset( $atts['navigation_color_scheme'] ) && $atts['navigation_color_scheme'] != '' ) {
	
		$navigation_color_scheme_id = NULL;
		if ( is_numeric ( $atts['navigation_color_scheme'] ) ) {
			$navigation_color_scheme_id = $atts['navigation_color_scheme'];
		} else if ( $atts['navigation_color_scheme'] != '' ) {
			$navigation_color_scheme_id = bt_bb_get_color_scheme_id( $atts['navigation_color_scheme'] );
		}
		$navigation_color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $navigation_color_scheme_id - 1 );
		if ( $navigation_color_scheme_colors ) $style .= '; --navigation-primary-color:' . $navigation_color_scheme_colors[0] . '; --navigation-secondary-color:' . $navigation_color_scheme_colors[1] . ';';
	}

	if ( isset( $atts['arrows_color_scheme'] ) && $atts['arrows_color_scheme'] != '' ) {
	
		$arrows_color_scheme_id = NULL;
		if ( is_numeric ( $atts['arrows_color_scheme'] ) ) {
			$arrows_color_scheme_id = $atts['arrows_color_scheme'];
		} else if ( $atts['arrows_color_scheme'] != '' ) {
			$arrows_color_scheme_id = bt_bb_get_color_scheme_id( $atts['arrows_color_scheme'] );
		}
		$arrows_color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $arrows_color_scheme_id - 1 );
		if ( $arrows_color_scheme_colors ) $style .= '; --arrows-primary-color:' . $arrows_color_scheme_colors[0] . '; --arrows-secondary-color:' . $arrows_color_scheme_colors[1] . ';';
	}
	return $style;
}

add_filter( 'bt_bb_content_slider_class', 'vivo_bt_bb_content_slider_class', 10, 2 );
add_filter( 'bt_bb_content_slider_style', 'vivo_bt_bb_content_slider_style', 10, 2 );




// CONTACT FORM 7 - BUTTON COLOR SCHEME AND STYLE, INPUT STYLE, PLACEHOLDER STYLE
if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_contact_form_7', array(
		array( 'param_name' => 'color_scheme', 'preview' => true, 'type' => 'dropdown', 'heading' => esc_html__( 'Button color scheme', 'vivo' ), 'value' => $color_scheme_arr ),
		array( 'param_name' => 'button_style', 'type' => 'dropdown', 'heading' => esc_html__( 'Submit button style', 'vivo' ), 
			'value' => array(
				esc_html__( 'Filled', 'vivo' ) 			=> '',
				esc_html__( 'Filled gradient', 'vivo' ) 	=> 'filled_gradient',
				esc_html__( 'Outline', 'vivo' ) 			=> 'outline',
				esc_html__( 'Clean', 'vivo' ) 			=> 'clean'
			)
		),
		array( 'param_name' => 'input_style', 'type' => 'dropdown', 'heading' => esc_html__( 'Input style', 'vivo' ), 
			'value' => array(
				esc_html__( 'Filled (gray background)', 'vivo' ) 	=> '',
				esc_html__( 'Filled (light background)', 'vivo' ) 	=> 'light',
				esc_html__( 'Outline/underline', 'vivo' ) 			=> 'outline'
			)
		),
		array( 'param_name' => 'placeholder_style', 'type' => 'dropdown', 'heading' => esc_html__( 'Placeholder style', 'vivo' ), 
			'value' => array(
				esc_html__( 'Semi transparent', 'vivo' ) 			=> 'semitransparent',
				esc_html__( 'Full visibility', 'vivo' ) 				=> 'full',
				esc_html__( 'Advanced semi transparent', 'vivo' ) 	=> 'advanced_semitransparent',
				esc_html__( 'Advanced full visibility', 'vivo' ) 	=> 'advanced_full',
			)
		),
		array( 'param_name' => 'button_font_weight', 'type' => 'dropdown', 'heading' => esc_html__( 'Button font weight', 'vivo' ), 
			'value' => array(
				esc_html__( 'Default', 'vivo' ) 		=> '',
				esc_html__( 'Normal', 'vivo' ) 		=> 'normal',
				esc_html__( 'Bold', 'vivo' ) 		=> 'bold',
				esc_html__( 'Bolder', 'vivo' ) 		=> 'bolder',
				esc_html__( 'Lighter', 'vivo' ) 		=> 'lighter',
				esc_html__( 'Light', 'vivo' ) 		=> 'light',
				esc_html__( 'Thin', 'vivo' ) 		=> 'thin',
				esc_html__( '100', 'vivo' ) 			=> '100',
				esc_html__( '200', 'vivo' ) 			=> '200',
				esc_html__( '300', 'vivo' ) 			=> '300',
				esc_html__( '400', 'vivo' ) 			=> '400',
				esc_html__( '500', 'vivo' ) 			=> '500',
				esc_html__( '600', 'vivo' ) 			=> '600',
				esc_html__( '700', 'vivo' ) 			=> '700',
				esc_html__( '800', 'vivo' ) 			=> '800',
				esc_html__( '900', 'vivo' ) 			=> '900'
			)
		),
	));
}

function vivo_bt_bb_contact_form_7_class( $class, $atts ) {
	if ( isset( $atts['color_scheme'] ) && $atts['color_scheme'] != '' ) {
		$class[] = 'bt_bb_color_scheme' . '_' . bt_bb_get_color_scheme_id( $atts['color_scheme'] );
	}
	if ( isset( $atts['button_style'] ) && $atts['button_style'] != '' ) {
		$class[] = 'bt_bb_button_style' . '_' . $atts['button_style'];
	}
	if ( isset( $atts['button_font_weight'] ) && $atts['button_font_weight'] != '' ) {
		$class[] = 'bt_bb_button_font_weight' . '_' . $atts['button_font_weight'];
	}
	if ( isset( $atts['input_style'] ) && $atts['input_style'] != '' ) {
		$class[] = 'bt_bb_input_style' . '_' . $atts['input_style'];
	}
	if ( isset( $atts['placeholder_style'] ) && $atts['placeholder_style'] != '' ) {
		switch ( $atts['placeholder_style'] ) {
			case 'full':
				$class[] = 'bt_bb_placeholder_style_full';
				break;
			case 'semitransparent':
				$class[] = 'bt_bb_placeholder_style_semitransparent';
				break;
			case 'advanced_full':
				$class[] = 'bt_bb_placeholder_style_full';
				$class[] = 'bt_bb_cf7_advanced_placeholders';
				break;
			case 'advanced_semitransparent':
				$class[] = 'bt_bb_placeholder_style_semitransparent';
				$class[] = 'bt_bb_cf7_advanced_placeholders';
				break;
		}
		$class[] = 'bt_bb_placeholder_style' . '_' . $atts['placeholder_style'];
	}
	return $class;
}

function vivo_bt_bb_contact_form_7_style( $style, $atts ) {
	if ( isset( $atts['color_scheme'] ) && $atts['color_scheme'] != '' ) {
	
		$color_scheme_id = NULL;
		if ( is_numeric ( $atts['color_scheme'] ) ) {
			$color_scheme_id = $atts['color_scheme'];
		} else if ( $atts['color_scheme'] != '' ) {
			$color_scheme_id = bt_bb_get_color_scheme_id( $atts['color_scheme'] );
		}
		$color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $color_scheme_id - 1 );
		if ( $color_scheme_colors ) $style .= '; --primary-color:' . $color_scheme_colors[0] . '; --secondary-color:' . $color_scheme_colors[1] . ';';
	}
	return $style;
}

add_filter( 'bt_bb_contact_form_7_class', 'vivo_bt_bb_contact_form_7_class', 10, 2 );
add_filter( 'bt_bb_contact_form_7_style', 'vivo_bt_bb_contact_form_7_style', 10, 2 );



// ACCORDION - TRIGGER COLOR. TITLE SIZE, TITLE WEIGHT
if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_accordion', array(
		array( 'param_name' => 'trigger_color', 'type' => 'dropdown', 'heading' => esc_html__( 'Trigger color', 'vivo' ), 'preview' => true,
			'value' => array(
				esc_html__( 'Dark', 'vivo' )				=> 'dark',
				esc_html__( 'Light', 'vivo' )			=> 'light',
				esc_html__( 'Accent', 'vivo' )			=> 'accent',
				esc_html__( 'Alternate', 'vivo' )		=> 'alternate'
			)
		),
		array( 'param_name' => 'title_size', 'type' => 'dropdown', 'heading' => esc_html__( 'Title size', 'vivo' ), 
			'value' => array(
				esc_html__( 'Small', 'vivo' )			=> '',
				esc_html__( 'Normal', 'vivo' )			=> 'normal',
				esc_html__( 'Large', 'vivo' )			=> 'large'
			)
		),
		array( 'param_name' => 'font_weight', 'type' => 'dropdown', 'heading' => esc_html__( 'Title font weight', 'vivo' ), 
			'value' => array(
				esc_html__( 'Default', 'vivo' ) 		=> '',
				esc_html__( 'Normal', 'vivo' ) 		=> 'normal',
				esc_html__( 'Bold', 'vivo' ) 		=> 'bold',
				esc_html__( 'Bolder', 'vivo' ) 		=> 'bolder',
				esc_html__( 'Lighter', 'vivo' ) 		=> 'lighter',
				esc_html__( 'Light', 'vivo' ) 		=> 'light',
				esc_html__( 'Thin', 'vivo' ) 		=> 'thin',
				esc_html__( '100', 'vivo' ) 			=> '100',
				esc_html__( '200', 'vivo' ) 			=> '200',
				esc_html__( '300', 'vivo' ) 			=> '300',
				esc_html__( '400', 'vivo' ) 			=> '400',
				esc_html__( '500', 'vivo' ) 			=> '500',
				esc_html__( '600', 'vivo' ) 			=> '600',
				esc_html__( '700', 'vivo' ) 			=> '700',
				esc_html__( '800', 'vivo' ) 			=> '800',
				esc_html__( '900', 'vivo' ) 			=> '900'
			)
		),
	));
}

function vivo_bt_bb_accordion_class( $class, $atts ) {
	if ( isset( $atts['trigger_color'] ) && $atts['trigger_color'] != '' ) {
		$class[] = 'bt_bb_trigger_color' . '_' . $atts['trigger_color'];
	}
	if ( isset( $atts['title_size'] ) && $atts['title_size'] != '' ) {
		$class[] = 'bt_bb_title_size' . '_' . $atts['title_size'];
	}
	if ( isset( $atts['font_weight'] ) && $atts['font_weight'] != '' ) {
		$class[] = 'bt_bb_font_weight' . '_' . $atts['font_weight'];
	}
	return $class;
}
add_filter( 'bt_bb_accordion_class', 'vivo_bt_bb_accordion_class', 10, 2 );



// TABS - ICON COLOR
if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_tabs', array(
		array( 'param_name' => 'icon_color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon color scheme', 'vivo' ), 'value' => $color_scheme_arr ),
		array( 'param_name' => 'shadow', 'type' => 'dropdown', 'heading' => esc_html__( 'Shadow', 'vivo' ), 
			'value' => array(
				esc_html__( 'No', 'vivo' ) 			=> '',
				esc_html__( 'Yes', 'vivo' ) 			=> 'show'
			)
		),
	));
}

function vivo_bt_bb_tabs_class( $class, $atts ) {
	if ( isset( $atts['icon_color_scheme'] ) && $atts['icon_color_scheme'] != '' ) {
		$class[] = 'bt_bb_icon_color_scheme' . '_' . bt_bb_get_color_scheme_id( $atts['icon_color_scheme'] );
	}
	if ( isset( $atts['shadow'] ) && $atts['shadow'] != '' ) {
		$class[] = 'bt_bb_shadow' . '_' . $atts['shadow'];
	}
	return $class;
}

function vivo_bt_bb_tabs_style( $style, $atts ) {
	if ( isset( $atts['icon_color_scheme'] ) && $atts['icon_color_scheme'] != '' ) {
	
		$icon_color_scheme_id = NULL;
		if ( is_numeric ( $atts['icon_color_scheme'] ) ) {
			$icon_color_scheme_id = $atts['icon_color_scheme'];
		} else if ( $atts['icon_color_scheme'] != '' ) {
			$icon_color_scheme_id = bt_bb_get_color_scheme_id( $atts['icon_color_scheme'] );
		}
		$icon_color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $icon_color_scheme_id - 1 );
		if ( $icon_color_scheme_colors ) $style .= '; --icon-tab-primary-color:' . $icon_color_scheme_colors[0] . '; --icon-tab-secondary-color:' . $icon_color_scheme_colors[1] . ';';
	}
	return $style;
}

add_filter( 'bt_bb_tabs_class', 'vivo_bt_bb_tabs_class', 10, 2 );
add_filter( 'bt_bb_tabs_style', 'vivo_bt_bb_tabs_style', 10, 2 );



// CUSTOM MENU - WEIGHT, FONT SIZE, TEXT DECORATION, COLOR SCHEME
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_custom_menu', 'font_weight' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_custom_menu', array(
		array( 'param_name' => 'weight', 'type' => 'dropdown', 'heading' => esc_html__( 'Font weight', 'vivo' ),
			'value' => array(
				esc_html__( 'Default', 'vivo' ) 		=> '',
				esc_html__( 'Normal', 'vivo' ) 		=> 'normal',
				esc_html__( 'Bold', 'vivo' ) 		=> 'bold',
				esc_html__( 'Bolder', 'vivo' ) 		=> 'bolder',
				esc_html__( 'Lighter', 'vivo' ) 		=> 'lighter',
				esc_html__( 'Light', 'vivo' ) 		=> 'light',
				esc_html__( 'Thin', 'vivo' ) 		=> 'thin',
				esc_html__( '100', 'vivo' ) 			=> '100',
				esc_html__( '200', 'vivo' ) 			=> '200',
				esc_html__( '300', 'vivo' ) 			=> '300',
				esc_html__( '400', 'vivo' ) 			=> '400',
				esc_html__( '500', 'vivo' ) 			=> '500',
				esc_html__( '600', 'vivo' ) 			=> '600',
				esc_html__( '700', 'vivo' ) 			=> '700',
				esc_html__( '800', 'vivo' ) 			=> '800',
				esc_html__( '900', 'vivo' ) 			=> '900'
			)
		),
		array( 'param_name' => 'font_size', 'type' => 'dropdown', 'default' => '', 'heading' => esc_html__( 'Font size', 'vivo' ),
			'value' => array(
				esc_html__( 'Default', 'vivo' ) 				=> '',
				esc_html__( '12px', 'vivo' ) 				=> '12px',
				esc_html__( '13px', 'vivo' ) 				=> '13px',
				esc_html__( '14px', 'vivo' ) 				=> '14px',
				esc_html__( '15px', 'vivo' ) 				=> '15px',
				esc_html__( '16px', 'vivo' ) 				=> '16px',
				esc_html__( '17px', 'vivo' ) 				=> '17px'
			)
		),
		array( 'param_name' => 'text_decoration', 'type' => 'dropdown', 'heading' => esc_html__( 'Links decoration', 'vivo' ),
			'value' => array(
				esc_html__( 'None', 'vivo' ) 				=> '',
				esc_html__( 'Underline', 'vivo' ) 			=> 'underline'
			)
		),
		array( 'param_name' => 'color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Color scheme', 'vivo' ), 'value' => $color_scheme_arr ),
	));
}

function vivo_bt_bb_custom_menu_class( $class, $atts ) {
	if ( isset( $atts['weight'] ) && $atts['weight'] != '' ) {
		$class[] = 'bt_bb_font_weight' . '_' . $atts['weight'];
	}
	if ( isset( $atts['font_size'] ) && $atts['font_size'] != '' ) {
		$class[] = 'bt_bb_font_size' . '_' . $atts['font_size'];
	}
	if ( isset( $atts['style'] ) && $atts['style'] != '' ) {
		$class[] = 'bt_bb_style' . '_' . $atts['style'];
	}
	if ( isset( $atts['text_decoration'] ) && $atts['text_decoration'] != '' ) {
		$class[] = 'bt_bb_text_decoration' . '_' . $atts['text_decoration'];
	}
	if ( isset( $atts['color_scheme'] ) && $atts['color_scheme'] != '' ) {
		$class[] = 'bt_bb_color_scheme' . '_' . bt_bb_get_color_scheme_id( $atts['color_scheme'] );
	}
	return $class;
}

function vivo_bt_bb_custom_menu_style( $style, $atts ) {
	if ( isset( $atts['color_scheme'] ) && $atts['color_scheme'] != '' ) {
	
		$color_scheme_id = NULL;
		if ( is_numeric ( $atts['color_scheme'] ) ) {
			$color_scheme_id = $atts['color_scheme'];
		} else if ( $atts['color_scheme'] != '' ) {
			$color_scheme_id = bt_bb_get_color_scheme_id( $atts['color_scheme'] );
		}
		$color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $color_scheme_id - 1 );
		if ( $color_scheme_colors ) $style .= '; --custom-menu-primary-color:' . $color_scheme_colors[0] . '; --custom-menu-secondary-color:' . $color_scheme_colors[1] . ';';
	}
	return $style;
}


add_filter( 'bt_bb_custom_menu_class', 'vivo_bt_bb_custom_menu_class', 10, 2 );
add_filter( 'bt_bb_custom_menu_style', 'vivo_bt_bb_custom_menu_style', 10, 2 );



// TEXT - FONT SIZE
if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_text', array(
		array( 'param_name' => 'font_size', 'type' => 'dropdown', 'preview' => true, 'heading' => esc_html__( 'Font size', 'vivo' ),
			'value' => array(
				esc_html__( 'Default', 'vivo' ) 				=> '',
				esc_html__( '12px', 'vivo' ) 				=> '12px',
				esc_html__( '13px', 'vivo' ) 				=> '13px',
				esc_html__( '14px', 'vivo' ) 				=> '14px',
				esc_html__( '15px', 'vivo' ) 				=> '15px',
				esc_html__( '16px', 'vivo' ) 				=> '16px',
				esc_html__( '17px', 'vivo' ) 				=> '17px'
			)
		),
	));
}

function vivo_bt_bb_text_class( $class, $atts ) {
	if ( isset( $atts['font_size'] ) && $atts['font_size'] != '' ) {
		$class[] = 'bt_bb_font_size' . '_' . $atts['font_size'];
	}
	return $class;
}

add_filter( 'bt_bb_text_class', 'vivo_bt_bb_text_class', 10, 2 );




// GOOGLE MAPS - SHAPE
if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_google_maps', array(
		array( 'param_name' => 'shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Shape', 'vivo' ), 'preview' => true, 
			'value' => array(
				esc_html__( 'Square', 'vivo' ) 					=> '',
				esc_html__( 'Soft Rounded', 'vivo' ) 			=> 'soft-rounded',
				esc_html__( 'Hard Rounded', 'vivo' ) 			=> 'hard-rounded'
			)
		),
		array( 'param_name' => 'shadow', 'type' => 'dropdown', 'heading' => esc_html__( 'Shadow', 'vivo' ), 
			'value' => array(
				esc_html__( 'Yes', 'vivo' ) 			=> '',
				esc_html__( 'No', 'vivo' ) 			=> 'hide'
			)
		),
	));
}

function vivo_bt_bb_google_maps_class( $class, $atts ) {
	if ( isset( $atts['shape'] ) && $atts['shape'] != '' ) {
		$class[] = 'bt_bb_shape' . '_' . $atts['shape'];
	}
	if ( isset( $atts['shadow'] ) && $atts['shadow'] != '' ) {
		$class[] = 'bt_bb_shadow' . '_' . $atts['shadow'];
	}
	return $class;
}

add_filter( 'bt_bb_google_maps_class', 'vivo_bt_bb_google_maps_class', 10, 2 );



/* FRONT END 
---------------------------------------------------------- */

/* OLD ELEMENTS */
function bt_bb_fe_new_params( $elements_array) {
	$elements_array[ 'bt_bb_icon' ][ 'params' ][ 'text_size' ] = array( 'ajax_filter' => array( 'class' ) );
	$elements_array[ 'bt_bb_icon' ][ 'params' ][ 'negative_margin' ] = array( 'ajax_filter' => array( 'class', 'data-bt-override-class' ) );
	$elements_array[ 'bt_bb_icon' ][ 'params' ][ 'negative_bottom_margin' ] = array( 'ajax_filter' => array( 'class', 'data-bt-override-class' ) );
	$elements_array[ 'bt_bb_icon' ][ 'params' ][ 'negative_right_margin' ] = array( 'ajax_filter' => array( 'class', 'data-bt-override-class' ) );
	$elements_array[ 'bt_bb_icon' ][ 'params' ][ 'negative_left_margin' ] = array( 'ajax_filter' => array( 'class', 'data-bt-override-class' ) );


	$elements_array[ 'bt_bb_progress_bar' ][ 'params' ][ 'shadow' ] = array( 'ajax_filter' => array( 'class' ) );

	$elements_array[ 'bt_bb_service' ][ 'params' ][ 'supertitle' ] = array( 'js_handler'  => array( 'target_selector' => '.bt_bb_service_content .bt_bb_service_content_supertitle', 'type' => 'inner_html' ) );
	$elements_array[ 'bt_bb_service' ][ 'params' ][ 'title_weight' ] = array( 'ajax_filter' => array( 'class' ) );

	$elements_array[ 'bt_bb_headline' ][ 'params' ][ 'supertitle_color' ] = array( 'ajax_filter' => array( 'class' ) );
	$elements_array[ 'bt_bb_headline' ][ 'params' ][ 'dash_color' ] = array( 'ajax_filter' => array( 'class' ) );

    return $elements_array;
}
add_filter( 'bt_bb_fe_elements', 'bt_bb_fe_new_params' );


/* NEW ELEMENTS */
function vivo_bt_bb_fe( $elements ) {

	$elements[ 'bt_bb_call_to_action' ] = array(
		'edit_box_selector' => '',
		'params' => array(
			'icon'						=> array(),
			'supertitle' 				=> array(),
			'title' 					=> array(),
			'url'						=> array( 'js_handler' => array( 'target_selector' => 'a', 'type' => 'attr', 'attr' => 'href' ) ),
			'target' 					=> array( 'js_handler' => array( 'target_selector' => 'a', 'type' => 'attr', 'attr' => 'target' ) ),
			'color_scheme'				=> array( 'ajax_filter' => array( 'class', 'style' ) ), 
			'shape'						=> array( 'ajax_filter' => array( 'class' ) ),
		),
	);
	
	$elements[ 'bt_bb_card' ] = array(
		'edit_box_selector' => '',
		'params' => array(
			'icon'						=> array(),
			'title' 					=> array(),
			'url'						=> array( 'js_handler' => array( 'target_selector' => 'a', 'type' => 'attr', 'attr' => 'href' ) ),
			'target' 					=> array( 'js_handler' => array( 'target_selector' => 'a', 'type' => 'attr', 'attr' => 'target' ) ),
			'padding'         			=> array( 'ajax_filter' => array( 'class', 'data-bt-override-class' ) ),
			'shape'         			=> array( 'ajax_filter' => array( 'class' ) ),
			'shadow'         			=> array( 'ajax_filter' => array( 'class' ) ),
			'color_scheme'				=> array( 'ajax_filter' => array( 'class', 'style' ) ), 
		),
	);

	$elements[ 'bt_bb_css_post_grid' ] = array(
		'edit_box_selector' => '',
		'params' => array(
			'initial_items_number'		=> array(),
			'columns'					=> array( 'ajax_filter' => array( 'class' ) ),
			'gap'						=> array( 'ajax_filter' => array( 'class' ) ),
			'shape'						=> array( 'ajax_filter' => array( 'class' ) ),
		),
	);

	$elements[ 'bt_bb_dropdown' ] = array(
		'edit_box_selector' => '',
		'params' => array(
			'title'						=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_dropdown_list .bt_bb_dropdown_title span', 'type' => 'inner_html' ) ),
			'field_color_scheme'		=> array( 'ajax_filter' => array( 'class' ) ),
			'button_style'				=> array( 'ajax_filter' => array( 'class' ) ),
			'button_color_scheme'		=> array( 'ajax_filter' => array( 'class', 'style' ) ), 
		),
	);

	$elements[ 'bt_bb_prices' ] = array(
		'edit_box_selector' => '',
		'params' => array(
			'wh_content'    			=> array(),
		),
	);

	$elements[ 'bt_bb_progress_bar_advanced' ] = array(
		'edit_box_selector' => '',
		'ajax_trigger_scroll' => true,
		'params' => array(
			'type'        				=> array(),
			'percentage'        		=> array(),
			'duration'     	   			=> array(),
			'easing'       	 			=> array(),
			'text'        				=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_progress_bar_advanced_text', 'type' => 'inner_html' ) ),
			'icon'						=> array(),
			'url'						=> array( 'js_handler' => array( 'target_selector' => 'a', 'type' => 'attr', 'attr' => 'href' ) ),
			'target' 					=> array( 'js_handler' => array( 'target_selector' => 'a', 'type' => 'attr', 'attr' => 'target' ) ),
			'size'         				=> array( 'ajax_filter' => array( 'class' ) ),
		),
	);

	$elements[ 'bt_bb_quote' ] = array(
		'edit_box_selector' => '',
		'params' => array(
			'text'						=> array( 'js_handler'  => array( 'target_selector' => '.bt_bb_quote_text span', 'type' => 'inner_html' ) ),
			'image'						=> array(),
			'name'						=> array( 'js_handler'  => array( 'target_selector' => '.bt_bb_quote_author .bt_bb_quote_content .bt_bb_quote_name', 'type' => 'inner_html' ) ),
			'details'					=> array( 'js_handler'  => array( 'target_selector' => '.bt_bb_quote_author .bt_bb_quote_content .bt_bb_quote_details', 'type' => 'inner_html' ) ),
			'text_size'					=> array( 'ajax_filter' => array( 'class' ) ),
			'text_style'				=> array( 'ajax_filter' => array( 'class' ) ),
			'quote_font_weight'         => array( 'ajax_filter' => array( 'class' ) ),
			'quote_icon_color' 			=> array( 'ajax_filter' => array( 'class' ) ),
			'quote_icon_size'         	=> array( 'ajax_filter' => array( 'class' ) ),
			'quote_icon_font_weight'    => array( 'ajax_filter' => array( 'class' ) ),
			'top_border'         		=> array( 'ajax_filter' => array( 'class' ) ),
			'bottom_border'        		=> array( 'ajax_filter' => array( 'class' ) ),
		),
	);

	$elements[ 'bt_bb_working_hours' ] = array(
		'edit_box_selector' => '',
		'params' => array(
			'wh_content'    			=> array(),
			'button_style'         		=> array( 'ajax_filter' => array( 'class' ) ),
			'button_shape'         		=> array( 'ajax_filter' => array( 'class' ) ),
			'color_scheme'				=> array( 'ajax_filter' => array( 'class', 'style' ) ), 
		),
	);

	$elements[ 'bt_bb_search' ] = array(
		'edit_box_selector' => '',
		'params' => array(
			'button_style'    			=> array( 'ajax_filter' => array( 'class' ) ),
			'button_font_weight'        => array( 'ajax_filter' => array( 'class' ) ),
			'icon'						=> array(),
			'color_scheme'				=> array( 'ajax_filter' => array( 'class', 'style' ) ), 
			'input_style'        		=> array( 'ajax_filter' => array( 'class' ) ),
			'placeholder_style'        	=> array( 'ajax_filter' => array( 'class' ) ),
		),
	);

	$elements[ 'bt_bb_post_slider' ] = array(
		'edit_box_selector' => '',
		'params' => array(
			'gap'    				=> array( 'ajax_filter' => array( 'class' ) ),
			'arrows_size'    		=> array( 'ajax_filter' => array( 'class' ) ),
			'title_lines'    		=> array( 'ajax_filter' => array( 'class' ) ),
			'title_font_weight'    	=> array( 'ajax_filter' => array( 'class' ) ),
			'excerpt_lines'    		=> array( 'ajax_filter' => array( 'class' ) ),
			'post_details_color'    => array( 'ajax_filter' => array( 'class' ) ),
			'date_color_scheme'		=> array( 'ajax_filter' => array( 'class', 'style' ) ), 
			'item_color_scheme'		=> array( 'ajax_filter' => array( 'class', 'style' ) ), 
			'shape'    				=> array( 'ajax_filter' => array( 'class' ) ),
			'shadow'    			=> array( 'ajax_filter' => array( 'class' ) ),
			'negative_margin'       => array( 'ajax_filter' => array( 'class', 'data-bt-override-class' ) ),
		),
	);

	return $elements;
}

add_filter( 'bt_bb_fe_elements', 'vivo_bt_bb_fe' );