<?php
/* VIVO THEME CUSTOMIZER PARAMETERS
------------------------------------*/

if ( ! function_exists( 'boldthemes_get_button_styles_vivo' ) ) {
	function boldthemes_get_button_styles_vivo() {
		$button_styles = array(
			'outline'			=> esc_html__( 'Outline', 'vivo' ),
			'filled'			=> esc_html__( 'Filled', 'vivo' ),
			'filled_gradient'	=> esc_html__( 'Filled gradient', 'vivo' ),
			'clean'				=> esc_html__( 'Clean', 'vivo' ),
		);
		return $button_styles;
	}
}


/* TYPO SECTION
-------------------------------------------------------------- */

// BUTTON STYLE

if ( ! function_exists( 'boldthemes_customize_button_style_vivo' ) ) {
	function boldthemes_customize_button_style_vivo( $wp_customize ) {

		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[button_style]', array(
			'default'           => urlencode( BoldThemes_Customize_Default::$data['button_style'] ),
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_select',
			'transport'         => 'postMessage'
		));
		$wp_customize->add_control( 'button_style', array(
			'label'     => esc_html__( 'Button style', 'vivo' ),
			'section'   => BoldThemesFramework::$pfx . '_typo_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[button_style]',
			'priority'  => 350,
			'type'      => 'select',
			'choices'   => boldthemes_get_button_styles_vivo()
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_button_style_vivo' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_button_style_vivo' );

/* BLOG  SECTION 
-------------------------------------------------------------- */

// BLOG LIST READ MORE STYLE

if ( ! function_exists( 'boldthemes_customize_blog_list_read_more_style_vivo' ) ) {
	function boldthemes_customize_blog_list_read_more_style_vivo( $wp_customize ) {

		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[blog_list_read_more_style]', array(
			'default'           => BoldThemes_Customize_Default::$data['blog_list_read_more_style'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_select',
			'transport'         => 'postMessage'
		));
		$wp_customize->add_control( 'blog_list_read_more_style', array(
			'label'     => esc_html__( 'Read more button style', 'vivo' ),
			'section'   => BoldThemesFramework::$pfx . '_blog_list_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[blog_list_read_more_style]',
			'priority'  => 130,
			'type'      => 'select',
			'choices'   => boldthemes_get_button_styles_vivo(),
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_blog_list_read_more_style_vivo' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_blog_list_read_more_style_vivo' );

/* PORTFOLIO  SECTION 
-------------------------------------------------------------- */

// PORTFOLIO LIST READ MORE STYLE

if ( ! function_exists( 'boldthemes_customize_pf_list_read_more_style_vivo' ) ) {
	function boldthemes_customize_pf_list_read_more_style_vivo( $wp_customize ) {

		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[pf_list_read_more_style]', array(
			'default'           => BoldThemes_Customize_Default::$data['pf_list_read_more_style'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_select',
			'transport'         => 'postMessage'
		));
		$wp_customize->add_control( 'pf_list_read_more_style', array(
			'label'     => esc_html__( 'Read more button style', 'vivo' ),
			'section'   => BoldThemesFramework::$pfx . '_pf_list_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[pf_list_read_more_style]',
			'priority'  => 130,
			'type'      => 'select',
			'choices'   => boldthemes_get_button_styles_vivo(),
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_pf_list_read_more_style_vivo' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_pf_list_read_more_style_vivo' );

/* SEARCH  SECTION 
-------------------------------------------------------------- */

// SEARCH LIST READ MORE STYLE

if ( ! function_exists( 'boldthemes_customize_search_list_read_more_style_vivo' ) ) {
	function boldthemes_customize_search_list_read_more_style_vivo( $wp_customize ) {

		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[search_list_read_more_style]', array(
			'default'           => BoldThemes_Customize_Default::$data['search_list_read_more_style'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_select',
			'transport'         => 'postMessage'
		));
		$wp_customize->add_control( 'search_list_read_more_style', array(
			'label'     => esc_html__( 'Read more button style', 'vivo' ),
			'section'   => BoldThemesFramework::$pfx . '_search_list_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[search_list_read_more_style]',
			'priority'  => 140,
			'type'      => 'select',
			'choices'   => boldthemes_get_button_styles_vivo(),
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_search_list_read_more_style_vivo' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_search_list_read_more_style_vivo' );

/* WooCommerce SHOP GENERAL SECTION
-------------------------------------------------------------- */

// SHOP SINGLE BUTTON STYLE

if ( ! function_exists( 'boldthemes_customize_shop_button_style_vivo' ) ) {
	function boldthemes_customize_shop_button_style_vivo( $wp_customize ) {

		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[shop_button_style]', array(
			'default'           => BoldThemes_Customize_Default::$data['shop_button_style'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_select',
			'transport'         => 'postMessage'
		));
		$wp_customize->add_control( 'shop_button_style', array(
			'label'     => esc_html__( 'Button style', 'vivo' ),
			'section'   => BoldThemesFramework::$pfx . '_shop_general_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[shop_button_style]',
			'priority'  => 60,
			'type'      => 'select',
			'choices'   => boldthemes_get_button_styles_vivo(),
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_shop_button_style_vivo' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_shop_button_style_vivo' );
