<?php
// Widgets for Vivo theme by BoldThemes

function vivo_register_widgets() {
    register_widget( 'BT_Divider_Widget' );
}
add_action( 'widgets_init', 'vivo_register_widgets' );


// BT_Divider_Widget
if ( ! class_exists( 'BT_Divider_Widget' ) ) {
	class BT_Divider_Widget extends WP_Widget {

		function __construct() {
			parent::__construct(
				'bt_divider_widget', // Base ID
				__( 'BT Divider', 'bt_plugin' ), // Name
				array( 'description' => __( 'Divider Widget, used as a vertical divider with border.', 'bt_plugin' ) ) // Args
			);
			
			$this->prefix = 'boldthemes_divider_widget';
		}
		
		public function widget( $args, $instance ) {
			$spacing_round = ! empty( $instance['spacing_round'] ) ? $instance['spacing_round'] : '';

			$div_class = array( '' );

			

			$class = array( ); 

			if ( $spacing_round != '' ) {
				$class[] = esc_attr( $this->prefix . '_spacing_round_' . $spacing_round );
			}

			$args['before_widget'] = '<div class="widget_' . $this->prefix . ' ' . implode( ' ', $div_class ) . '">';
			echo $args['before_widget'];
			echo '<span class="widget_' . $this->prefix . ' ' . implode( ' ', $class ) . '"></span>';
			echo $args['after_widget'];
		}

		public function form( $instance ) {

			$spacing_round = ! empty( $instance['spacing_round'] ) ? $instance['spacing_round'] : '';
			
			?>
			
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'spacing_round' ) ); ?>"><?php _e( 'Spacing Round:', 'bt_plugin' ); ?></label> 
				<select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'spacing_round' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'spacing_round' ) ); ?>">
					<?php
					$style_arr = array("Small" => "small", "Normal" => "normal", "Medium" => "medium", "Large" => "large");
					foreach( $style_arr as $key => $value ) {
						if ( $value == $spacing_round ) {
							echo '<option value="' . $value . '" selected>' . $key . '</option>';
						} else {
							echo '<option value="' . $value . '">' . $key . '</option>';
						}
					}
					?>
				</select>
			</p>
			
			<?php
		}

		public function update( $new_instance, $old_instance ) {
			$instance = array();

			$instance['spacing_round'] = ( ! empty( $new_instance['spacing_round'] ) ) ? strip_tags( $new_instance['spacing_round'] ) : '';
			
			return $instance;
		}
	}
}
