<?php

/**
 * Plugin Name: Vivo Plugin
 * Description: Shortcodes and widgets by BoldThemes.
 * Version: 1.0.7
 * Author: BoldThemes
 * Author URI: http://bold-themes.com
 * Text Domain: bt_plugin 
 */
 
 /* Button shapes override */

if ( ! function_exists( 'bt_get_button_widget_styles' ) ) {
	function bt_get_button_widget_styles() {
		return array(
			esc_html__( 'Outline', 'bt_plugin' ) 			=> 'outline',
			esc_html__( 'Filled', 'bt_plugin' ) 			=> 'filled',
			esc_html__( 'Filled gradient', 'bt_plugin' ) 	=> 'filled_gradient',
			esc_html__( 'Clean', 'bt_plugin' ) 			=> 'clean',
			esc_html__( 'With line', 'bt_plugin' ) 		=> 'line'
		);
	}
}

/* Icon sizes override */

if ( ! function_exists( 'bt_get_icon_widget_sizes' ) ) {
	function bt_get_icon_widget_sizes() {
		return array(
			esc_html__( 'Extra small', 'bt_plugin' ) => 'xsmall',
			esc_html__( 'Small', 'bt_plugin' ) => 'small',
			esc_html__( 'Normal', 'bt_plugin' ) => 'normal',
			esc_html__( 'Medium', 'bt_plugin' ) => 'medium',
			esc_html__( 'Large', 'bt_plugin' ) => 'large',
			esc_html__( 'Extra large', 'bt_plugin' ) => 'xlarge'
		);
	}
}

/* Load framework */

require_once( 'framework_bt_plugin/framework.php' );

/* Etc */

$bt_plugin_dir = plugin_dir_path( __FILE__ );

function bt_load_plugin_textdomain() {

	$domain = 'bt_plugin';
	$locale = apply_filters( 'plugin_locale', get_locale(), $domain );

	load_plugin_textdomain( $domain, false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );

}
add_action( 'plugins_loaded', 'bt_load_plugin_textdomain' );

/* Additional widgets */

require_once( 'widgets/widgets.php' );