<?php

if ( ! class_exists( 'Boldthemes_Icon_Widget' ) ) {

	class Boldthemes_Icon_Widget extends WP_Widget {

		function __construct() {
			parent::__construct(
				'boldthemes_icon_widget', // Base ID
				esc_html__( 'BT Icon', 'bold-builder' ), // Name
				array( 'description' => esc_html__( 'Icon with text and link.', 'bold-builder' ) ) // Args
			);
		}

		public function widget( $args, $instance ) {
		
			$icon = ! empty( $instance['icon'] ) ? $instance['icon'] : '';
			$text = ! empty( $instance['text'] ) ? $instance['text'] : '';
			$style = ! empty( $instance['style'] ) ? $instance['style'] : 'filled';
			$shape = ! empty( $instance['shape'] ) ? $instance['shape'] : 'circle';
			$size = ! empty( $instance['size'] ) ? $instance['size'] : 'xsmall';
			$color_scheme = ! empty( $instance['color_scheme'] ) ? $instance['color_scheme'] : '';
			$url = ! empty( $instance['url'] ) ? $instance['url'] : '';
			$target = ! empty( $instance['target'] ) ? $instance['target'] : '_self';
			$extra_class = ! empty( $instance['extra_class'] ) ? $instance['extra_class'] : '';
			
			echo $args['before_widget'];

			if ( shortcode_exists( 'bt_bb_icon' ) ) {
				echo do_shortcode( '[bt_bb_icon icon="' . $icon . '" text="' . $text . '" url="' . $url . '" target="' . $target . '" size="' . $size . '" style="' . $style . '" color_scheme="' . $color_scheme . '" shape="' . $shape . '" el_class="' . $extra_class . '"]' );
			}
			
			echo $args['after_widget'];
		}

		public function form( $instance ) {
			$icon = ! empty( $instance['icon'] ) ? $instance['icon'] : '';
			$text = ! empty( $instance['text'] ) ? $instance['text'] : '';
			$style = ! empty( $instance['style'] ) ? $instance['style'] : 'filled';
			$shape = ! empty( $instance['shape'] ) ? $instance['shape'] : 'circle';
			$size = ! empty( $instance['size'] ) ? $instance['size'] : 'xsmall';
			$color_scheme = ! empty( $instance['color_scheme'] ) ? $instance['color_scheme'] : '';
			$url = ! empty( $instance['url'] ) ? $instance['url'] : '';
			$target = ! empty( $instance['target'] ) ? $instance['target'] : '_self';
			$extra_class = ! empty( $instance['extra_class'] ) ? $instance['extra_class'] : '';

			?>		
			<div class="bt_bb_iconpicker_widget_container">
				<label for="<?php echo esc_attr( $this->get_field_id( 'icon' ) ); ?>"><?php _e( 'Icon:', 'bold-builder' ); ?></label>
				<input type="hidden" id="<?php echo esc_attr( $this->get_field_id( 'icon' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'icon' ) ); ?>" value="<?php echo esc_attr( $icon ); ?>">
				<input type="hidden" name="<?php echo esc_attr( $this->get_field_name( 'bt_bb_iconpicker' ) ); ?>">
				<div class="bt_bb_iconpicker_widget_placeholder" data-icon="<?php echo esc_attr( $icon ); ?>"></div>
			</div>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'text' ) ); ?>"><?php _e( 'Text:', 'bold-builder' ); ?></label> 
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'text' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'text' ) ); ?>" type="text" value="<?php echo esc_attr( $text ); ?>">
			</p>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>"><?php _e( 'Style:', 'bold-builder' ); ?></label> 
				<select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'style' ) ); ?>">
					
					<?php
					// $style_arr = array("Outline" => "outline", "Filled" => "filled", "Borderless" => "borderless");
					$style_arr = function_exists( 'bt_get_icon_widget_styles' )? bt_get_icon_widget_styles() : array("Outline" => "outline", "Filled" => "filled", "Borderless" => "borderless");
					foreach( $style_arr as $key => $value ) {
						if ( $value == $style ) {
							echo '<option value="' . esc_attr( $value ) . '" selected>' . $key . '</option>';
						} else {
							echo '<option value="' . esc_attr( $value ) . '">' . $key . '</option>';
						}
					}
					?>
				</select>
			</p>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'shape' ) ); ?>"><?php _e( 'Shape:', 'bold-builder' ); ?></label> 
				<select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'shape' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'shape' ) ); ?>">
					
					<?php
					// $shape_arr = array("Circle" => "circle", "Square" => "square", "Round" => "round");
					$shape_arr = function_exists( 'bt_get_icon_widget_shapes' ) ? bt_get_icon_widget_shapes() : array( "Circle" => "circle", "Square" => "square", "Round" => "round" );
					foreach( $shape_arr as $key => $value ) {
						if ( $value == $shape ) {
							echo '<option value="' . esc_attr( $value ) . '" selected>' . $key . '</option>';
						} else {
							echo '<option value="' . esc_attr( $value ) . '">' . $key . '</option>';
						}
					}
					?>
				</select>
			</p>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'size' ) ); ?>"><?php _e( 'Size:', 'bold-builder' ); ?></label> 
				<select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'size' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'size' ) ); ?>">
					
					<?php
					// $size_arr = bt_get_icon_widget_sizes();
					$size_arr = function_exists( 'bt_get_icon_widget_sizes' ) ? bt_get_icon_widget_sizes() : array( "Small" => "small", "Normal" => "normal", "Large" => "large" );
					foreach( $size_arr as $key => $value ) {
						if ( $value == $size ) {
							echo '<option value="' . esc_attr( $value ) . '" selected>' . $key . '</option>';
						} else {
							echo '<option value="' . esc_attr( $value ) . '">' . $key . '</option>';
						}
					}
					?>
				</select>
			</p>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'color_scheme' ) ); ?>"><?php _e( 'Color scheme:', 'bold-builder' ); ?></label> 
				<select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'color_scheme' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'color_scheme' ) ); ?>">
					
					<?php
					$color_schemes = boldthemes_get_color_schemes();
					foreach( $color_schemes as $key => $value ) {
						if ( $key == $color_scheme ) {
							echo '<option value="' . esc_attr( $key ) . '" selected>' . $value . '</option>';
						} else {
							echo '<option value="' . esc_attr( $key ) . '">' . $value . '</option>';
						}
					}
					?>
				</select>
			</p>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'url' ) ); ?>"><?php _e( 'URL:', 'bold-builder' ); ?></label> 
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'url' ) ); ?>" type="text" value="<?php echo esc_attr( $url ); ?>">
			</p>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'target' ) ); ?>"><?php _e( 'Target:', 'bold-builder' ); ?></label> 
				<select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'target' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'target' ) ); ?>">
					
					<?php
					$target_arr = array("Self" => "_self", "Blank" => "_blank", "Parent" => "_parent", "Top" => "_top");
					foreach( $target_arr as $key => $value ) {
						if ( $value == $target ) {
							echo '<option value="' . esc_attr( $value ) . '" selected>' . $key . '</option>';
						} else {
							echo '<option value="' . esc_attr( $value ) . '">' . $key . '</option>';
						}
					}
					?>
				</select>
			</p>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'extra_class' ) ); ?>"><?php _e( 'CSS extra class:', 'bold-builder' ); ?></label> 
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'extra_class' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'extra_class' ) ); ?>" type="text" value="<?php echo esc_attr( $extra_class ); ?>">
			</p>
			<?php 
		}

		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['icon'] = ( ! empty( $new_instance['icon'] ) ) ? strip_tags( $new_instance['icon'] ) : '';
			$instance['text'] = ( ! empty( $new_instance['text'] ) ) ? strip_tags( $new_instance['text'] ) : '';
			$instance['style'] = ( ! empty( $new_instance['style'] ) ) ? strip_tags( $new_instance['style'] ) : 'filled';
			$instance['shape'] = ( ! empty( $new_instance['shape'] ) ) ? strip_tags( $new_instance['shape'] ) : 'circle';
			$instance['size'] = ( ! empty( $new_instance['size'] ) ) ? strip_tags( $new_instance['size'] ) : 'xsmall';
			$instance['color_scheme'] = ( ! empty( $new_instance['color_scheme'] ) ) ? strip_tags( $new_instance['color_scheme'] ) : '';
			$instance['url'] = ( ! empty( $new_instance['url'] ) ) ? strip_tags( $new_instance['url'] ) : '';
			$instance['target'] = ( ! empty( $new_instance['target'] ) ) ? strip_tags( $new_instance['target'] ) : '_self';
			$instance['extra_class'] = ( ! empty( $new_instance['extra_class'] ) ) ? strip_tags( $new_instance['extra_class'] ) : '';

			return $instance;
		}
	}	
}