<?php

if ( ! function_exists( 'boldthemes_remove_icon_widget' ) ) {
	function boldthemes_remove_icon_widget() {
		unregister_widget( 'BB_Icon_Widget' );
	}
}
add_action( 'widgets_init', 'boldthemes_remove_icon_widget', 11 );

if ( ! function_exists( 'boldthemes_register_bb_widgets' ) ) {
	function boldthemes_register_bb_widgets() {
		require_once 'widgets/Boldthemes_Icon_Widget.php';
		require_once 'widgets/Boldthemes_Button_Widget.php';
		require_once 'widgets/Boldthemes_Service_Widget.php';
		register_widget( 'Boldthemes_Icon_Widget' );
		register_widget( 'Boldthemes_Button_Widget' );
		register_widget( 'Boldthemes_Service_Widget' );
	}
}
add_action( 'widgets_init', 'boldthemes_register_bb_widgets', 11 );

/* Init widget areas */
if ( ! function_exists( 'bt_widget_areas' ) ) {
	function bt_widget_areas() {
		register_sidebar( array (
			'name' 			=> esc_html__( 'Header Left Widgets', 'bt_plugin' ),
			'id' 			=> 'header_left_widgets',
			'before_widget' => '<div class="header_left_widgets %2$s" id="%1$s">', 
			'after_widget' 	=> '</div>'
		));
		register_sidebar( array (
			'name' 			=> esc_html__( 'Header Right Widgets', 'bt_plugin' ),
			'id' 			=> 'header_right_widgets',
			'before_widget' => '<div class="header_right_widgets %2$s" id="%1$s">',
			'after_widget' 	=> '</div>'
		));
		register_sidebar( array (
			'name' 			=> esc_html__( 'Header Menu Widgets', 'bt_plugin' ),
			'id' 			=> 'header_menu_widgets',
			'before_widget' => '<div class="%2$s" id="%1$s">',
			'after_widget' 	=> '</div>'
		));
		register_sidebar( array (
			'name' 			=> esc_html__( 'Header Logo Widgets', 'bt_plugin' ),
			'id' 			=> 'header_logo_widgets',
			'before_widget' => '<div class="%2$s" id="%1$s">',
			'after_widget' 	=> '</div>'
		));
		register_sidebar( array (
			'name' 			=> esc_html__( 'Header Logo Responsive Widgets', 'bt_plugin' ),
			'id' 			=> 'header_logo_responsive_widgets',
			'before_widget' => '<div class="%2$s" id="%1$s">',
			'after_widget' 	=> '</div>'
		));
		register_sidebar( array (
			'name' 			=> esc_html__( 'Responsive Menu Widgets', 'bt_plugin' ),
			'id' 			=> 'menu_responsive_widgets',
			'before_widget' => '<div class="%2$s" id="%1$s">',
			'after_widget' 	=> '</div>'
		));
	}
}
add_action( 'widgets_init', 'bt_widget_areas', 30 );

/* ------------- */
/* -- Icons ---- */
/* ------------- */

/* Icon sizes */
if ( ! function_exists( 'bt_get_icon_widget_sizes' ) ) {
	function bt_get_icon_widget_sizes() {
		return array(
			esc_html__( 'Extra small', 'bt_plugin' ) 		=> 'xsmall',
			esc_html__( 'Small', 'bt_plugin' ) 			=> 'small',
			esc_html__( 'Normal', 'bt_plugin' ) 			=> 'normal',
			esc_html__( 'Large', 'bt_plugin' ) 			=> 'large',
			esc_html__( 'Extra large', 'bt_plugin' ) 		=> 'xlarge'
		);
	}
}

/* Icon shapes */
if ( ! function_exists( 'bt_get_icon_widget_shapes' ) ) {
	function bt_get_icon_widget_shapes() {
		return array(
			esc_html__( 'Circle', 'bt_plugin' ) 			=> 'circle',
			esc_html__( 'Square', 'bt_plugin' ) 			=> 'square',
			esc_html__( 'Round', 'bt_plugin' ) 			=> 'round',
		);
	}
}

/* Icon styles */
if ( ! function_exists( 'bt_get_icon_widget_styles' ) ) {
	function bt_get_icon_widget_styles() {
		return array(
			esc_html__( 'Outline', 'bt_plugin' ) 			=> 'outline',
			esc_html__( 'Filled', 'bt_plugin' ) 			=> 'filled',
			esc_html__( 'Borderless', 'bt_plugin' ) 		=> 'borderless',
		);
	}
}

/* ------------- */
/* -- Services - */
/* ------------- */

/* Service sizes */
if ( ! function_exists( 'bt_get_service_widget_sizes' ) ) {
	function bt_get_service_widget_sizes() {
		return array(
			esc_html__( 'Extra small', 'bt_plugin' ) => 'xsmall',
			esc_html__( 'Small', 'bt_plugin' ) => 'small',
			esc_html__( 'Normal', 'bt_plugin' ) => 'normal',
			esc_html__( 'Large', 'bt_plugin' ) => 'large',
			esc_html__( 'Extra large', 'bt_plugin' ) => 'xlarge'
		);
	}
}

/* Service shapes */
if ( ! function_exists( 'bt_get_service_widget_shapes' ) ) {
	function bt_get_service_widget_shapes() {
		return array(
			esc_html__( 'Circle', 'bt_plugin' ) 			=> 'circle',
			esc_html__( 'Square', 'bt_plugin' ) 			=> 'square',
			esc_html__( 'Round', 'bt_plugin' ) 			=> 'round',
		);
	}
}

/* Service styles */
if ( ! function_exists( 'bt_get_service_widget_styles' ) ) {
	function bt_get_service_widget_styles() {
		return array(
			esc_html__( 'Outline', 'bt_plugin' ) 			=> 'outline',
			esc_html__( 'Filled', 'bt_plugin' ) 			=> 'filled',
			esc_html__( 'Borderless', 'bt_plugin' ) 		=> 'borderless',
		);
	}
}

/* ------------- */
/* -- Buttons -- */
/* ------------- */

/* Button styles */
if ( ! function_exists( 'bt_get_button_widget_styles' ) ) {
	function bt_get_button_widget_styles() {
		return array(
			esc_html__( 'Outline', 'bt_plugin' ) 			=> 'outline',
			esc_html__( 'Filled', 'bt_plugin' ) 			=> 'filled',
			esc_html__( 'Clean', 'bt_plugin' ) 				=> 'clean',
		);
	}
	
}
/* Button shapes */

/* Widget additional params */
/* ------------------------ */

class BT_Widgets_Additional_Params {

	function __construct() {
		// Hook in all the right places.
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action( 'in_widget_form', array( $this, 'add_settings' ), 10, 3 );
		add_filter( 'widget_update_callback', array( $this, 'save_settings' ), 10, 4 );
		add_filter( 'widget_display_callback', array( $this, 'frontend_settings' ), 10, 3 );
	}
	
	public function enqueue_scripts() {
		// Register a dummy style handle. We'll use this to enqueue our dynamic styles.
		wp_register_style( 'bt-widget-additional-front', false );
	}

	protected function is_supported ( WP_Widget $widget ) {
		if ( in_array( $widget->id_base, $this->widgets, true ) ) {
			return true;
		}

		return false;
	}	
}

if ( ! function_exists( 'bt_get_button_widget_shapes' ) ) {
	function bt_get_button_widget_shapes() {
		return array(
			esc_html__( 'Square', 'bt_plugin' ) 			=> 'square',
			esc_html__( 'Rounded', 'bt_plugin' ) 			=> 'rounded',
			esc_html__( 'Round', 'bt_plugin' ) 			=> 'round',
		);
	}
}

/* Button sizes */
if ( ! function_exists( 'bt_get_button_widget_sizes' ) ) {
	function bt_get_button_widget_sizes() {
		return array(
			esc_html__( 'Small', 'bt_plugin' ) 			=> 'small',
			esc_html__( 'Medium', 'bt_plugin' ) 			=> 'medium',
			esc_html__( 'Normal', 'bt_plugin' ) 			=> 'normal',
			esc_html__( 'Large', 'bt_plugin' ) 			=> 'large',
		);
	}
}

/* Widget color scheme */
class BT_Widgets_Color_Scheme extends BT_Widgets_Additional_Params {

	protected $defaults = array(
		'widget_color_scheme' 	=> '',
		'extra_class' 			=> '',
	);

	protected $widgets = array(
		'recent-posts',
		'woocommerce_widget_cart',
		'block',
		'search',
	);

	/**
	 * Adds the custom settings to all widgets' forms.
	 *
	 * @param WP_Widget $widget   An instance of a WP_Widget derived subclass.
	 * @param mixed     $return   Return null if new fields are added.
	 * @param array     $instance An array of the widget's settings.
	 */
	public function add_settings( $widget, $return, $instance ) {
		if ( ! $this->is_supported( $widget ) ) {
			return null;
		}

		// Make sure $instance contains at least our default values.
		$instance = wp_parse_args( $instance, $this->defaults );
		$widget_color_scheme = $instance['widget_color_scheme'];
		?>
		<p>
			<label for="<?php echo esc_attr( $widget->get_field_id( 'widget_color_scheme' ) ); ?>"><?php _e( 'Color scheme:', 'bold-builder' ); ?></label> 
			<select class="widefat" id="<?php echo esc_attr( $widget->get_field_id( 'widget_color_scheme' ) ); ?>" name="<?php echo esc_attr( $widget->get_field_name( 'widget_color_scheme' ) ); ?>">
				
				<?php
				$widget_color_schemes = boldthemes_get_color_schemes();
				foreach( $widget_color_schemes as $key => $value ) {
					if ( $key == $widget_color_scheme ) {
						echo '<option value="' . esc_attr( $key ) . '" selected>' . $value . '</option>';
					} else {
						echo '<option value="' . esc_attr( $key ) . '">' . $value . '</option>';
					}
				}
				?>
			</select>
		</p>
		<?php
	}

	/**
	 * Saves the custom settings.
	 *
	 * @param array     $instance     The current widget instance's settings.
	 * @param array     $new_instance Array of new widget settings.
	 * @param array     $old_instance Array of old widget settings.
	 * @param WP_Widget $widget       The current widget instance.
	 *
	 * @return array The widget instance's settings to get saved.
	 */
	public function save_settings( $instance, $new_instance, $old_instance, $widget ) {
		if ( ! $this->is_supported( $widget ) ) {
			return $instance;
		}

		// Make sure $instance contains at least our default values.
		$instance = wp_parse_args( $instance, $this->defaults );

		// Now check that a value is actually present, and assign it sanitized.
		if ( isset( $new_instance['widget_color_scheme'] ) ) {
			$instance['widget_color_scheme'] = intval( $new_instance['widget_color_scheme'] ) > 0 ? intval( $new_instance['widget_color_scheme'] ) : '';
		}

		return $instance;
	}

	/**
	 * Include our settings in the display callback's instance array.
	 *
	 * @param array     $instance The current widget instance's settings.
	 * @param WP_Widget $widget   The current widget instance.
	 * @param array     $args     An array of default widget arguments.
	 *
	 * @return array
	 */
	public function frontend_settings( $instance, $widget, $args ) {
		if ( ! $this->is_supported( $widget ) ) {
			return $instance;
		}

		// Make sure $instance contains at least our default values.
		// Widget may be displayed before save_settings() had a change to save our settings.
		
		$instance = wp_parse_args( $instance, $this->defaults );

		if ( isset( $instance['widget_color_scheme'] ) && intval( $instance['widget_color_scheme'] ) > 0 ) {

			$widget_color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $instance['widget_color_scheme'] - 1 );
			if ( $widget_color_scheme_colors ) {
				$style = '--widget-primary-color: ' . $widget_color_scheme_colors[0] . '; --widget-secondary-color: ' . $widget_color_scheme_colors[1] . ';';
				$style = sprintf( '#%s { ' . $style . ' }' . PHP_EOL, $args['widget_id'] );
				wp_enqueue_style( 'bt-widget-additional-front' );
				wp_add_inline_style( 'bt-widget-additional-front', $style );	
				if ( isset( $instance['extra_class'] ) ) $instance['extra_class'] .= ' bt_bb_has_widget_color_scheme';
			}
		}

		return $instance;
	}
}

/* Widget sticky color scheme */
class BT_Widgets_Sticky_Color_Scheme extends BT_Widgets_Additional_Params {

	protected $defaults = array(
		'widget_sticky_color_scheme' 	=> '',
		'extra_class' 					=> '',
	);

	protected $widgets = array(
		'recent-posts',
		'woocommerce_widget_cart',
		'block',
		'search',
		'boldthemes_button_widget',
		'boldthemes_icon_widget',
		'boldthemes_service_widget',
	);

	/**
	 * Adds the custom settings to all widgets' forms.
	 *
	 * @param WP_Widget $widget   An instance of a WP_Widget derived subclass.
	 * @param mixed     $return   Return null if new fields are added.
	 * @param array     $instance An array of the widget's settings.
	 */
	public function add_settings( $widget, $return, $instance ) {
		if ( ! $this->is_supported( $widget ) ) {
			return null;
		}

		// Make sure $instance contains at least our default values.
		$instance = wp_parse_args( $instance, $this->defaults );
		$widget_sticky_color_scheme = $instance['widget_sticky_color_scheme'];
		?>
		<p>
			<label for="<?php echo esc_attr( $widget->get_field_id( 'widget_sticky_color_scheme' ) ); ?>"><?php _e( 'Sticky color scheme:', 'bold-builder' ); ?></label> 
			<select class="widefat" id="<?php echo esc_attr( $widget->get_field_id( 'widget_sticky_color_scheme' ) ); ?>" name="<?php echo esc_attr( $widget->get_field_name( 'widget_sticky_color_scheme' ) ); ?>">
				
				<?php
				$widget_sticky_color_schemes = boldthemes_get_color_schemes();
				foreach( $widget_sticky_color_schemes as $key => $value ) {
					if ( $key == $widget_sticky_color_scheme ) {
						echo '<option value="' . esc_attr( $key ) . '" selected>' . $value . '</option>';
					} else {
						echo '<option value="' . esc_attr( $key ) . '">' . $value . '</option>';
					}
				}
				?>
			</select>
		</p>
		<?php
	}

	/**
	 * Saves the custom settings.
	 *
	 * @param array     $instance     The current widget instance's settings.
	 * @param array     $new_instance Array of new widget settings.
	 * @param array     $old_instance Array of old widget settings.
	 * @param WP_Widget $widget       The current widget instance.
	 *
	 * @return array The widget instance's settings to get saved.
	 */
	public function save_settings( $instance, $new_instance, $old_instance, $widget ) {
		if ( ! $this->is_supported( $widget ) ) {
			return $instance;
		}

		// Make sure $instance contains at least our default values.
		$instance = wp_parse_args( $instance, $this->defaults );

		// Now check that a value is actually present, and assign it sanitized.
		if ( isset( $new_instance['widget_sticky_color_scheme'] ) ) {
			$instance['widget_sticky_color_scheme'] = intval( $new_instance['widget_sticky_color_scheme'] ) > 0 ? intval( $new_instance['widget_sticky_color_scheme'] ) : '';
		}

		return $instance;
	}

	/**
	 * Include our settings in the display callback's instance array.
	 *
	 * @param array     $instance The current widget instance's settings.
	 * @param WP_Widget $widget   The current widget instance.
	 * @param array     $args     An array of default widget arguments.
	 *
	 * @return array
	 */
	public function frontend_settings( $instance, $widget, $args ) {
		if ( ! $this->is_supported( $widget ) ) {
			return $instance;
		}

		// Make sure $instance contains at least our default values.
		// Widget may be displayed before save_settings() had a change to save our settings.
		
		$instance = wp_parse_args( $instance, $this->defaults );

		if ( isset( $instance['widget_sticky_color_scheme'] ) && intval( $instance['widget_sticky_color_scheme'] ) > 0 ) {

			$widget_sticky_color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $instance['widget_sticky_color_scheme'] - 1 );
			if ( $widget_sticky_color_scheme_colors ) {
				$style = '--widget-sticky-primary-color: ' . $widget_sticky_color_scheme_colors[0] . '; --widget-sticky-secondary-color: ' . $widget_sticky_color_scheme_colors[1] . ';';
				$style = sprintf( '#%s { ' . $style . ' }' . PHP_EOL, $args['widget_id'] );
				wp_enqueue_style( 'bt-widget-additional-front' );
				wp_add_inline_style( 'bt-widget-additional-front', $style );	
				if ( isset( $instance['extra_class'] ) ) $instance['extra_class'] .= ' bt_bb_has_widget_sticky_color_scheme';
			}
		}

		return $instance;
	}
}

/* Widget full screen option */
class BT_Widgets_Full_Screen_Option extends BT_Widgets_Additional_Params {

	protected $defaults = array(
		'widget_enable_full_screen' 	=> '',
	);

	protected $widgets = array(
		'search',
	);

	/**
	 * Adds the custom settings to all widgets' forms.
	 *
	 * @param WP_Widget $widget   An instance of a WP_Widget derived subclass.
	 * @param mixed     $return   Return null if new fields are added.
	 * @param array     $instance An array of the widget's settings.
	 */
	public function add_settings( $widget, $return, $instance ) {
		if ( ! $this->is_supported( $widget ) ) {
			return null;
		}

		// Make sure $instance contains at least our default values.
		$instance = wp_parse_args( $instance, $this->defaults );
		$widget_enable_full_screen = $instance['widget_enable_full_screen'];
		?>
		<p>
			
			<input type="checkbox" class="widefat" id="<?php echo esc_attr( $widget->get_field_id( 'widget_enable_full_screen' ) ); ?>" name="<?php echo esc_attr( $widget->get_field_name( 'widget_enable_full_screen' ) ); ?>" <?php checked( $instance[ 'widget_enable_full_screen' ], 'on' ); ?>>
			<label for="<?php echo esc_attr( $widget->get_field_id( 'widget_enable_full_screen' ) ); ?>"><?php _e( 'Enable full screen ', 'bold-builder' ); ?></label> 
		</p>
		<?php
	}

	/**
	 * Saves the custom settings.
	 *
	 * @param array     $instance     The current widget instance's settings.
	 * @param array     $new_instance Array of new widget settings.
	 * @param array     $old_instance Array of old widget settings.
	 * @param WP_Widget $widget       The current widget instance.
	 *
	 * @return array The widget instance's settings to get saved.
	 */
	public function save_settings( $instance, $new_instance, $old_instance, $widget ) {
		if ( ! $this->is_supported( $widget ) ) {
			return $instance;
		}

		// Make sure $instance contains at least our default values.
		$instance = wp_parse_args( $instance, $this->defaults );

		// Now check that a value is actually present, and assign it sanitized.
		if ( isset( $new_instance['widget_enable_full_screen'] ) && $new_instance['widget_enable_full_screen'] == 'on' ) {
				$instance['widget_enable_full_screen'] = 'on';
		} else {
			$instance['widget_enable_full_screen'] = 'off';
		}

		return $instance;
	}

	/**
	 * Include our settings in the display callback's instance array.
	 *
	 * @param array     $instance The current widget instance's settings.
	 * @param WP_Widget $widget   The current widget instance.
	 * @param array     $args     An array of default widget arguments.
	 *
	 * @return array
	 */
	public function frontend_settings( $instance, $widget, $args ) {
		if ( ! $this->is_supported( $widget ) ) {
			return $instance;
		}

		// Make sure $instance contains at least our default values.
		// Widget may be displayed before save_settings() had a change to save our settings.
		
		$instance = wp_parse_args( $instance, $this->defaults );
		// var_dump( $instance );
		// var_dump( $args );
		// var_dump( $instance );
		if ( isset( $instance['widget_enable_full_screen'] ) && $instance['widget_enable_full_screen'] == 'on' ) {
			$style = '--widget-full-screen-enabled: on;';
		} else {
			$style = '--widget-full-screen-enabled: off;';
		}
		$style = sprintf( '#%s { ' . $style . ' }' . PHP_EOL, $args['widget_id'] );
		wp_enqueue_style( 'bt-widget-additional-front' );
		wp_add_inline_style( 'bt-widget-additional-front', $style );	
		return $instance;
	}
}

new BT_Widgets_Color_Scheme();
new BT_Widgets_Sticky_Color_Scheme();
new BT_Widgets_Full_Screen_Option();
