<?php

class Triply_Merlin_Config {

	private $config = [];
	private $wizard;

	public function __construct() {
		$this->init();
		add_action( 'merlin_import_files', [ $this, 'setup_ba_tour' ], 1);
		add_action( 'merlin_import_files', [ $this, 'import_files' ], 10);
		add_action( 'merlin_after_all_import', [ $this, 'after_import_setup' ], 10, 1 );
		add_filter( 'merlin_generate_child_functions_php', [ $this, 'render_child_functions_php' ] );


		add_action( 'admin_post_custom_setup_data', [ $this, 'custom_setup_data' ] );
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ), 10 );

		add_action( 'admin_menu', array( $this, 'add_plugin_page' ) );

		add_action('import_start', function () {
            add_filter('wxr_importer.pre_process.post_meta', [$this, 'fiximport_elementor'], 10, 1);
        });
	}

	public function fiximport_elementor($post_meta) {
        if ('_elementor_data' === $post_meta['key']) {
            $post_meta['value'] = wp_slash($post_meta['value']);
        }

        return $post_meta;
    }

	public function admin_scripts() {
		global $triply_version;
		wp_enqueue_script( 'triply-admin-script', get_template_directory_uri() . '/assets/js/admin/admin.js', array( 'jquery' ), $triply_version, true );
	}

	private function init() {
		$this->wizard = new Merlin(
			$config = array(
				// Location / directory where Merlin WP is placed in your theme.
				'merlin_url'         => 'merlin',
				// The wp-admin page slug where Merlin WP loads.
				'parent_slug'        => 'themes.php',
				// The wp-admin parent page slug for the admin menu item.
				'capability'         => 'manage_options',
				// The capability required for this menu to be displayed to the user.
				'dev_mode'           => true,
				// Enable development mode for testing.
				'license_step'       => false,
				// EDD license activation step.
				'license_required'   => false,
				// Require the license activation step.
				'license_help_url'   => '',
				// URL for the 'license-tooltip'.
				'edd_remote_api_url' => '',
				'directory'          => 'inc/merlin',
				// EDD_Theme_Updater_Admin remote_api_url.
				'edd_item_name'      => '',
				// EDD_Theme_Updater_Admin item_name.
				'edd_theme_slug'     => '',
				// EDD_Theme_Updater_Admin item_slug.
			),
			$strings = array(
				'admin-menu'          => esc_html__( 'Theme Setup', 'triply' ),

				/* translators: 1: Title Tag 2: Theme Name 3: Closing Title Tag */
				'title%s%s%s%s'       => esc_html__( '%1$s%2$s Themes &lsaquo; Theme Setup: %3$s%4$s', 'triply' ),
				'return-to-dashboard' => esc_html__( 'Return to the dashboard', 'triply' ),
				'ignore'              => esc_html__( 'Disable this wizard', 'triply' ),

				'btn-skip'                 => esc_html__( 'Skip', 'triply' ),
				'btn-next'                 => esc_html__( 'Next', 'triply' ),
				'btn-start'                => esc_html__( 'Start', 'triply' ),
				'btn-no'                   => esc_html__( 'Cancel', 'triply' ),
				'btn-plugins-install'      => esc_html__( 'Install', 'triply' ),
				'btn-child-install'        => esc_html__( 'Install', 'triply' ),
				'btn-content-install'      => esc_html__( 'Install', 'triply' ),
				'btn-import'               => esc_html__( 'Import', 'triply' ),
				'btn-license-activate'     => esc_html__( 'Activate', 'triply' ),
				'btn-license-skip'         => esc_html__( 'Later', 'triply' ),

				/* translators: Theme Name */
				'license-header%s'         => esc_html__( 'Activate %s', 'triply' ),
				/* translators: Theme Name */
				'license-header-success%s' => esc_html__( '%s is Activated', 'triply' ),
				/* translators: Theme Name */
				'license%s'                => esc_html__( 'Enter your license key to enable remote updates and theme support.', 'triply' ),
				'license-label'            => esc_html__( 'License key', 'triply' ),
				'license-success%s'        => esc_html__( 'The theme is already registered, so you can go to the next step!', 'triply' ),
				'license-json-success%s'   => esc_html__( 'Your theme is activated! Remote updates and theme support are enabled.', 'triply' ),
				'license-tooltip'          => esc_html__( 'Need help?', 'triply' ),

				/* translators: Theme Name */
				'welcome-header%s'         => esc_html__( 'Welcome to %s', 'triply' ),
				'welcome-header-success%s' => esc_html__( 'Hi. Welcome back', 'triply' ),
				'welcome%s'                => esc_html__( 'This wizard will set up your theme, install plugins, and import content. It is optional & should take only a few minutes.', 'triply' ),
				'welcome-success%s'        => esc_html__( 'You may have already run this theme setup wizard. If you would like to proceed anyway, click on the "Start" button below.', 'triply' ),

				'child-header'         => esc_html__( 'Install Child Theme', 'triply' ),
				'child-header-success' => esc_html__( 'You\'re good to go!', 'triply' ),
				'child'                => esc_html__( 'Let\'s build & activate a child theme so you may easily make theme changes.', 'triply' ),
				'child-success%s'      => esc_html__( 'Your child theme has already been installed and is now activated, if it wasn\'t already.', 'triply' ),
				'child-action-link'    => esc_html__( 'Learn about child themes', 'triply' ),
				'child-json-success%s' => esc_html__( 'Awesome. Your child theme has already been installed and is now activated.', 'triply' ),
				'child-json-already%s' => esc_html__( 'Awesome. Your child theme has been created and is now activated.', 'triply' ),

				'plugins-header'         => esc_html__( 'Install Plugins', 'triply' ),
				'plugins-header-success' => esc_html__( 'You\'re up to speed!', 'triply' ),
				'plugins'                => esc_html__( 'Let\'s install some essential WordPress plugins to get your site up to speed.', 'triply' ),
				'plugins-success%s'      => esc_html__( 'The required WordPress plugins are all installed and up to date. Press "Next" to continue the setup wizard.', 'triply' ),
				'plugins-action-link'    => esc_html__( 'Advanced', 'triply' ),

				'import-header'      => esc_html__( 'Import Content', 'triply' ),
				'import'             => esc_html__( 'Let\'s import content to your website, to help you get familiar with the theme.', 'triply' ),
				'import-action-link' => esc_html__( 'Advanced', 'triply' ),

				'ready-header'      => esc_html__( 'All done. Have fun!', 'triply' ),

				/* translators: Theme Author */
				'ready%s'           => esc_html__( 'Your theme has been all set up. Enjoy your new theme by %s.', 'triply' ),
				'ready-action-link' => esc_html__( 'Extras', 'triply' ),
				'ready-big-button'  => esc_html__( 'View your website', 'triply' ),
				'ready-link-1'      => sprintf( '<a href="%1$s" target="_blank">%2$s</a>', 'https://wordpress.org/support/', esc_html__( 'Explore WordPress', 'triply' ) ),
				'ready-link-2'      => sprintf( '<a href="%1$s" target="_blank">%2$s</a>', 'https://themebeans.com/contact/', esc_html__( 'Get Theme Support', 'triply' ) ),
				'ready-link-3'      => sprintf( '<a href="%1$s">%2$s</a>', admin_url( 'customize.php' ), esc_html__( 'Start Customizing', 'triply' ) ),
			)
		);

		add_action( 'widgets_init', [ $this, 'widgets_init' ] );
	}

	public function setup_ba_tour(){
	    $check_oneclick  = get_option( 'triply_check_oneclick', [] );
	    if(triply_is_ba_booking_activated() && !isset($check_oneclick['before_setup_ba'])){
            BABE_Install::setup_ages();
			BABE_Install::setup_tax_features();
			BABE_Install::setup_posts_places();
			BABE_Install::setup_rules();
			BABE_Install::setup_categories();
            $this->register_locations();
            $this->register_types();
            $this->register_amenities();
            $this->register_language();
            $check_oneclick['before_setup_ba'] = true;

		}
		update_option('triply_check_oneclick', $check_oneclick);
	}

	public function import_files(){
            return array(
            array(
                'import_file_name'           => 'home 1',
                'home'                       => 'home-1',
                'local_import_file'          => get_theme_file_path('/dummy-data/content.xml'),
                'local_import_widget_file'   => get_theme_file_path('/dummy-data/widgets.json'),
                'import_preview_image_url'   => get_theme_file_uri('/assets/images/oneclick/home_1.jpg'),
                'preview_url'                => 'https://demo2.pavothemes.com/triply/home-1',
            ),

            array(
                'import_file_name'           => 'home 2',
                'home'                       => 'home-2',
                'local_import_file'          => get_theme_file_path('/dummy-data/content.xml'),
                'local_import_widget_file'   => get_theme_file_path('/dummy-data/widgets.json'),
                'import_preview_image_url'   => get_theme_file_uri('/assets/images/oneclick/home_2.jpg'),
                'preview_url'                => 'https://demo2.pavothemes.com/triply/home-2',
            ),

            array(
                'import_file_name'           => 'home 3',
                'home'                       => 'home-3',
                'local_import_file'          => get_theme_file_path('/dummy-data/content.xml'),
                'local_import_widget_file'   => get_theme_file_path('/dummy-data/widgets.json'),
                'import_preview_image_url'   => get_theme_file_uri('/assets/images/oneclick/home_3.jpg'),
                'preview_url'                => 'https://demo2.pavothemes.com/triply/home-3',
            ),

            array(
                'import_file_name'           => 'home 4',
                'home'                       => 'home-4',
                'local_import_file'          => get_theme_file_path('/dummy-data/content.xml'),
                'local_import_widget_file'   => get_theme_file_path('/dummy-data/widgets.json'),
                'import_preview_image_url'   => get_theme_file_uri('/assets/images/oneclick/home_4.jpg'),
                'preview_url'                => 'https://demo2.pavothemes.com/triply/home-4',
            ),

            array(
                'import_file_name'           => 'home 5',
                'home'                       => 'home-5',
                'local_import_file'          => get_theme_file_path('/dummy-data/content.xml'),
                'local_import_widget_file'   => get_theme_file_path('/dummy-data/widgets.json'),
                'import_preview_image_url'   => get_theme_file_uri('/assets/images/oneclick/home_5.jpg'),
                'preview_url'                => 'https://demo2.pavothemes.com/triply/home-5',
            ),

            array(
                'import_file_name'           => 'home 6',
                'home'                       => 'home-6',
                'local_import_file'          => get_theme_file_path('/dummy-data/content.xml'),
                'local_import_widget_file'   => get_theme_file_path('/dummy-data/widgets.json'),
                'import_preview_image_url'   => get_theme_file_uri('/assets/images/oneclick/home_6.jpg'),
                'preview_url'                => 'https://demo2.pavothemes.com/triply/home-6',
            ),

            array(
                'import_file_name'           => 'home 7',
                'home'                       => 'home-7',
                'local_import_file'          => get_theme_file_path('/dummy-data/content.xml'),
                'local_import_widget_file'   => get_theme_file_path('/dummy-data/widgets.json'),
                'import_preview_image_url'   => get_theme_file_uri('/assets/images/oneclick/home_7.jpg'),
                'preview_url'                => 'https://demo2.pavothemes.com/triply/home-7',
            ),

            array(
                'import_file_name'           => 'home 8',
                'home'                       => 'home-8',
                'local_import_file'          => get_theme_file_path('/dummy-data/content.xml'),
                'local_import_widget_file'   => get_theme_file_path('/dummy-data/widgets.json'),
                'import_preview_image_url'   => get_theme_file_uri('/assets/images/oneclick/home_8.jpg'),
                'preview_url'                => 'https://demo2.pavothemes.com/triply/home-8',
            ),
            );           
        }

	public function after_import_setup( $selected_import ) {
		$selected_import = ( $this->import_files() )[ $selected_import ];
		$check_oneclick  = get_option( 'triply_check_oneclick', [] );

		$this->set_demo_menus();

		wp_delete_post( 1, true );

        if (!isset($check_oneclick[$selected_import['home']])) {
            $this->wizard->importer->import(get_parent_theme_file_path('dummy-data/homepage/' . $selected_import['home'] . '.xml'));
            $check_oneclick[$selected_import['home']] = true;
        }
		// setup Home page
		$home = get_page_by_path( $selected_import['home'] );

		if ( $home ) {
			update_option( 'show_on_front', 'page' );
			update_option( 'page_on_front', $home->ID );
		}

		// Setup Options
		$options = $this->get_all_options();
		// Elementor
		$active_kit_id = Elementor\Plugin::$instance->kits_manager->get_active_id();
		update_post_meta( $active_kit_id, '_elementor_page_settings', $options['elementor'] );

		foreach ( $options['options'] as $key => $option ) {
			update_option($key, $option);
		}

//		if ( ! isset( $check_oneclick['elementor'] ) ) {
//			$this->fixelementor();
//			$check_oneclick['elementor'] = true;
//		}

		$this->setup_header_footer( $selected_import['home'] );
		\Elementor\Plugin::$instance->files_manager->clear_cache();

		if ( ! isset( $check_oneclick['logo'] ) ) {
			set_theme_mod('custom_logo', 371);
			$check_oneclick['logo'] = true;
		}

		if ( ! isset( $check_oneclick['booking']) && triply_is_ba_booking_activated() ) {
		    $this->update_location_data();
		    $this->update_types_data();
		    $this->update_features_data();
		    $this->update_booking_tour();
		    $ba_settings = wp_parse_args($options['babe'], get_option('babe_settings',[]));
		    update_option('babe_settings', $ba_settings);
		    $check_oneclick['booking'] = true;
		}

		update_option( 'triply_check_oneclick', $check_oneclick );
	}

	public function render_child_functions_php() {
		$output
			= "<?php
/**
 * Theme functions and definitions.
 */
";

		return $output;
	}

	public function widgets_init() {
		require_once get_parent_theme_file_path( '/inc/merlin/includes/recent-post.php' );
		register_widget( 'Triply_WP_Widget_Recent_Posts' );
		require_once get_parent_theme_file_path( '/inc/merlin/includes/categories.php' );
		register_widget( 'Triply_WP_Widget_Categories' );
	}

	private function setup_header_footer( $id ) {
		$this->reset_header_footer();
		$options = ( $this->get_all_header_footer() )[ $id ];

		foreach ( $options['header'] as $header_options ) {
			$header = get_page_by_path( $header_options['slug'], OBJECT, 'elementor_library' );
			if ( $header ) {
				update_post_meta( $header->ID, '_elementor_conditions', $header_options['conditions'] );
			}
		}

		foreach ( $options['footer'] as $footer_options ) {
			$footer = get_page_by_path( $footer_options['slug'], OBJECT, 'elementor_library' );
			if ( $footer ) {
				update_post_meta( $footer->ID, '_elementor_conditions', $footer_options['conditions'] );
			}
		}

		$cache = new ElementorPro\Modules\ThemeBuilder\Classes\Conditions_Cache();
		$cache->regenerate();
	}

	 //// register tax Locations
    public function register_locations() {

	    global $triply;

        $new_tax_slug = BABE_Post_types::$attr_tax_pref . $triply->locations;
        $name = esc_html__('Booking Locations', 'triply');

        if(!taxonomy_exists( $new_tax_slug )){
            //// Locations insert term
            $inserted_term = wp_insert_term($name,   // the term
                BABE_Post_types::$taxonomies_list_tax, // the taxonomy
                array(
                    'description' => $name,
                    'slug'        => $triply->locations,
                )
            );

            if (!is_wp_error($inserted_term)){
                BABE_Post_types::init_taxonomies_list();
                update_term_meta($inserted_term['term_id'], 'gmap_active', 0);
                update_term_meta($inserted_term['term_id'], 'select_mode', 'multi_checkbox');
                update_term_meta($inserted_term['term_id'], 'frontend_style', 'col_3');
            }

            $labels = array(
                'name'              => $name,
                'singular_name'     => $name,
                'search_items'      => sprintf(__( 'Search %s', 'triply' ), $name),
                'all_items'         => sprintf(__( 'All %s', 'triply' ), $name),
                'parent_item'       => sprintf(__( 'Parent %s', 'triply' ), $name),
                'parent_item_colon' => sprintf(__( 'Parent %s:', 'triply' ), $name),
                'edit_item'         => sprintf(__( 'Edit %s', 'triply' ), $name),
                'update_itm'        => sprintf(__( 'Update %s', 'triply' ), $name),
                'add_new_item'      => sprintf(__( 'Add New %s', 'triply' ), $name),
                'new_item_name'     => sprintf(__( 'New %s', 'triply' ), $name),
                'menu_name'         => sprintf(__( '%s', 'triply' ), $name),
            );

            register_taxonomy( $new_tax_slug, BABE_Post_types::$booking_obj_post_type, array(
                'labels'            => $labels,
                'hierarchical'      => true,
                'query_var'         => $new_tax_slug,
                'public'            => true,
                'show_ui'           => true,
                'show_in_nav_menus'   => true,
                'show_admin_column' => true,
                'show_in_menu' => true,
                'show_in_rest' => true,
            ) );
        }
    }

    //// register tax Types
    public function register_types() {

	    global $triply;
        $name = esc_html__('Booking Types', 'triply');
        $new_tax_slug = BABE_Post_types::$attr_tax_pref .$triply->types;

        //// Types insert term
        if(!taxonomy_exists( $new_tax_slug )){
            //// Locations insert term
            $inserted_term = wp_insert_term($name,   // the term
                BABE_Post_types::$taxonomies_list_tax, // the taxonomy
                array(
                    'description' => $name,
                    'slug'        => $triply->types,
                )
            );

            if (!is_wp_error($inserted_term)){
                BABE_Post_types::init_taxonomies_list();
                update_term_meta($inserted_term['term_id'], 'gmap_active', 0);
                update_term_meta($inserted_term['term_id'], 'select_mode', 'multi_checkbox');
                update_term_meta($inserted_term['term_id'], 'frontend_style', 'col_3');
            }

            $labels = array(
                'name'              => $name,
                'singular_name'     => $name,
                'search_items'      => sprintf(__( 'Search %s', 'triply' ), $name),
                'all_items'         => sprintf(__( 'All %s', 'triply' ), $name),
                'parent_item'       => sprintf(__( 'Parent %s', 'triply' ), $name),
                'parent_item_colon' => sprintf(__( 'Parent %s:', 'triply' ), $name),
                'edit_item'         => sprintf(__( 'Edit %s', 'triply' ), $name),
                'update_itm'        => sprintf(__( 'Update %s', 'triply' ), $name),
                'add_new_item'      => sprintf(__( 'Add New %s', 'triply' ), $name),
                'new_item_name'     => sprintf(__( 'New %s', 'triply' ), $name),
                'menu_name'         => sprintf(__( '%s', 'triply' ), $name),
            );

            register_taxonomy( $new_tax_slug, BABE_Post_types::$booking_obj_post_type, array(
                'labels'            => $labels,
                'hierarchical'      => true,
                'query_var'         => $new_tax_slug,
                'public'            => true,
                'show_ui'           => true,
                'show_in_nav_menus'   => true,
                'show_admin_column' => true,
                'show_in_menu' => true,
                'show_in_rest' => true,
            ) );
        }

    }


    //// register tax Types
    public function register_amenities() {

        global $triply;
	    $name = esc_html__('Amenities', 'triply');
        $new_tax_slug = BABE_Post_types::$attr_tax_pref . $triply->amenities;

        //// Types insert term
        if(!taxonomy_exists( $new_tax_slug )){
            //// Locations insert term
            $inserted_term = wp_insert_term($name,   // the term
                BABE_Post_types::$taxonomies_list_tax, // the taxonomy
                array(
                    'description' => $name,
                    'slug'        => $triply->amenities,
                )
            );

            if (!is_wp_error($inserted_term)){
                BABE_Post_types::init_taxonomies_list();
                update_term_meta($inserted_term['term_id'], 'gmap_active', 0);
                update_term_meta($inserted_term['term_id'], 'select_mode', 'multi_checkbox');
                update_term_meta($inserted_term['term_id'], 'frontend_style', 'col_3');
            }

            $labels = array(
                'name'              => $name,
                'singular_name'     => $name,
                'search_items'      => sprintf(__( 'Search %s', 'triply' ), $name),
                'all_items'         => sprintf(__( 'All %s', 'triply' ), $name),
                'parent_item'       => sprintf(__( 'Parent %s', 'triply' ), $name),
                'parent_item_colon' => sprintf(__( 'Parent %s:', 'triply' ), $name),
                'edit_item'         => sprintf(__( 'Edit %s', 'triply' ), $name),
                'update_itm'        => sprintf(__( 'Update %s', 'triply' ), $name),
                'add_new_item'      => sprintf(__( 'Add New %s', 'triply' ), $name),
                'new_item_name'     => sprintf(__( 'New %s', 'triply' ), $name),
                'menu_name'         => sprintf(__( '%s', 'triply' ), $name),
            );

            register_taxonomy( $new_tax_slug, BABE_Post_types::$booking_obj_post_type, array(
                'labels'            => $labels,
                'hierarchical'      => true,
                'query_var'         => $new_tax_slug,
                'public'            => true,
                'show_ui'           => true,
                'show_in_nav_menus'   => true,
                'show_admin_column' => true,
                'show_in_menu' => true,
                'show_in_rest' => true,
            ) );
        }

    }


     //// register tax Types
    public function register_language() {

	    global $triply;
        $name = esc_html__('Language', 'triply');
        $new_tax_slug = BABE_Post_types::$attr_tax_pref . $triply->language;

        //// Types insert term
        if(!taxonomy_exists( $new_tax_slug )){
            //// Locations insert term
            $inserted_term = wp_insert_term($name,   // the term
                BABE_Post_types::$taxonomies_list_tax, // the taxonomy
                array(
                    'description' => $name,
                    'slug'        => $triply->language,
                )
            );

            if (!is_wp_error($inserted_term)){
                BABE_Post_types::init_taxonomies_list();
                update_term_meta($inserted_term['term_id'], 'gmap_active', 0);
                update_term_meta($inserted_term['term_id'], 'select_mode', 'multi_checkbox');
                update_term_meta($inserted_term['term_id'], 'frontend_style', 'col_3');
            }

            $labels = array(
                'name'              => $name,
                'singular_name'     => $name,
                'search_items'      => sprintf(__( 'Search %s', 'triply' ), $name),
                'all_items'         => sprintf(__( 'All %s', 'triply' ), $name),
                'parent_item'       => sprintf(__( 'Parent %s', 'triply' ), $name),
                'parent_item_colon' => sprintf(__( 'Parent %s:', 'triply' ), $name),
                'edit_item'         => sprintf(__( 'Edit %s', 'triply' ), $name),
                'update_itm'        => sprintf(__( 'Update %s', 'triply' ), $name),
                'add_new_item'      => sprintf(__( 'Add New %s', 'triply' ), $name),
                'new_item_name'     => sprintf(__( 'New %s', 'triply' ), $name),
                'menu_name'         => sprintf(__( '%s', 'triply' ), $name),
            );

            register_taxonomy( $new_tax_slug, BABE_Post_types::$booking_obj_post_type, array(
                'labels'            => $labels,
                'hierarchical'      => true,
                'query_var'         => $new_tax_slug,
                'public'            => true,
                'show_ui'           => true,
                'show_in_nav_menus'   => true,
                'show_admin_column' => true,
                'show_in_menu' => true,
                'show_in_rest' => true,
            ) );
        }

    }

    public function update_location_data(){
	    global $triply;

	    $location_taxonomy =  BABE_Post_types::$attr_tax_pref . $triply->locations;

        $taxonomies = get_terms( array(
            'taxonomy'   => $location_taxonomy,
            'hide_empty' => false

        ) );

        $data_info   = array(
            'Country'           => '',
            'Visa Requirements' => 'Visa in not needed for EU citizens. Everyone else need a visa.',
            'Languages spoken'  => 'English',
            'Currency used'     => 'USD',
            'Area (km2)'        => '300,000 km2'
        );

        $post_thumbnail = 286;


        if ( ! is_wp_error( $taxonomies ) ) {
            foreach ( $taxonomies as $taxonomy ) {
                $data_info['Country'] = $taxonomy->name;
                $data                 = [];
                foreach ( $data_info as $title => $value ) {
                    $data[] = [
                        'triply_title'       => $title,
                        'triply_description' => $value
                    ];
                }

                update_term_meta( $taxonomy->term_id, 'taxonomy_info', $data );
                update_term_meta($taxonomy->term_id, 'triply_location_image', wp_get_attachment_url( $post_thumbnail ));

            }
        }
    }

    public function update_types_data(){

	    global $triply;

	    $types_taxonomy =  BABE_Post_types::$attr_tax_pref . $triply->types;

        $taxonomies = get_terms( array(
            'taxonomy'   => $types_taxonomy,
            'hide_empty' => false

        ) );

        $data_info   = array('triply-icon-ticket-alt', 'triply-icon-citytours', 'triply-icon-cruise', 'triply-icon-historical', 'triply-icon-hiking', 'triply-icon-museum');
        if ( ! is_wp_error( $taxonomies ) ) {
            foreach ( $taxonomies as $key=>$taxonomy ) {
                foreach ( $data_info as $k => $value ) {
                    if($key == $k){
                        update_term_meta( $taxonomy->term_id, 'fa_class', $value );
                    }
                }
            }
        }
	}

	public function update_features_data(){

	    global $triply;

	    $features_taxonomy =  BABE_Post_types::$attr_tax_pref . $triply->features;

        $taxonomies = get_terms( array(
            'taxonomy'   => $features_taxonomy,
            'hide_empty' => false

        ) );


        $data_info   = array('triply-icon-beaches', 'triply-icon-camera-alt', 'triply-icon-utensils-alt', 'triply-icon-wine-glass-alt');
        if ( ! is_wp_error( $taxonomies ) ) {
            foreach ( $taxonomies as $key=>$taxonomy ) {
                foreach ( $data_info as $k => $value ) {
                    if($key == $k){
                        update_term_meta( $taxonomy->term_id, 'fa_class', $value );
                    }
                }
            }
        }
	}


    public function update_booking_tour() {
        $params = array(
            'posts_per_page' => - 1,
            'post_type'      => BABE_Post_types::$booking_obj_post_type,
        );
        $query  = new WP_Query( $params );
        if ( $query->have_posts() ) {
            while ( $query->have_posts() ):
                $query->the_post();
                $this->add_start_date(get_the_ID());
                $this->add_end_date(get_the_ID());
                $this->add_slider_image(get_the_ID());
                $this->add_steps_tour(get_the_ID());
                $this->add_rate_tour(get_the_ID());
            endwhile;
        }
    }

    private function add_steps_tour($post_id) {
        $slug = 'tour';

        $data_steps = array(
            [
                'title'      => 'Day 1',
                'attraction' => 'Eum eu sumo albucius perfecto, commodo torquatos consequuntur pro ut, id posse splendide ius. Cu nisl putent omittantur usu, mutat atomorum ex pro, ius nibh nonumy id. Nam at eius dissentias disputando, molestie mnesarchum complectitur per te. In commune pericula mediocritatem per. Cu audiam dolorum appareat per, id habeo suavitate argumentum vel. Te his eros ludus tibique.'
            ],
            [
                'title'      => 'Day 2',
                'attraction' => 'Aenean eu leo quam pellentesque ornare. Sem lacinia quam venenatis vestibulum. Donec ullamcorper nulla non metus auctor fringilla. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nullam quis risus eget urna mollis ornare vel eu leo.'
            ],
            [
                'title'      => 'Day 3',
                'attraction' => 'Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source.'
            ],
            [
                'title'      => 'Day 4',
                'attraction' => 'Lorem ipsum dolor sit amet, utinam munere antiopam vel ad. Qui eros iusto te. Nec ad feugiat honestatis. Quo illum detraxit an. Ius eius quodsi molestiae at, nostrum definitiones his cu. Discere referrentur mea id, an pri novum possim deterruisset.'
            ]
        );


        update_post_meta( $post_id, 'steps_' . $slug, $data_steps );
    }

    public function add_rate_tour($post_id) {

	    $category_slug  = 'tour';

        $price_arr = array( 0 => rand( 100, 200 ) );
        $rules     = BABE_Booking_Rules::get_rule_by_cat_slug( $category_slug );
        if ( $rules && isset($rules['ages'] ) ) {
            $ages = BABE_Post_types::get_ages_arr();
            $i    = 1;
            foreach ( $ages as $age_arr ) {
                $price_arr[ $age_arr['age_id'] ] = $i <= 2 ? floatval( $price_arr[0] - $i * 10 ) : floatval( 0 );
                $i ++;
            }

            unset( $price_arr[0] );

        }

        $days_arr  = BABE_Calendar_functions::get_week_days_arr();
        $rate_days_arr = array();
        foreach ( $days_arr as $day_num => $day_title ) {
            $rate_days_arr[ $day_num ] = $day_num;
        }

        //// create and save rates
         $rate_arr = array(
             'post_id' => $post_id,
             'cat_slug' => $category_slug,
             'apply_days' => $rate_days_arr,
             'start_days' => $rate_days_arr,
             '_price_general' => $price_arr,
             '_price_from' => '',
             '_prices_conditional' => array(),
             '_rate_min_booking' => '',
             '_rate_max_booking' => '',
             '_rate_title' => esc_html__('Default Price', 'triply'),
             '_rate_date_from' => '',
             '_rate_date_to' => '',
          );

        BABE_Prices::save_rate( $rate_arr );

        BABE_CMB2_admin::update_booking_obj_post($post_id, [], (object)array());
    }

    private function add_start_date($post_id) {
        $date_from_obj = new DateTime( '-3 days' );
        update_post_meta( $post_id, 'start_date', BABE_Calendar_functions::date_from_sql( $date_from_obj->format( 'Y-m-d' ) ) );
    }

    private function add_end_date($post_id) {
        $date_to_obj = new DateTime( '+1 year' );
        update_post_meta( $post_id, 'end_date', BABE_Calendar_functions::date_from_sql( $date_to_obj->format( 'Y-m-d' ) ) );
    }

    private function add_slider_image($post_id) {
        $post_thumbnail = 286;
        $images_slider = [];

        for ( $i = 1; $i <= 5; $i ++ ) {
            $images_slider[] = array(
                'image_id'    => $post_thumbnail,
                'image'       => wp_get_attachment_url( $post_thumbnail ),
                'description' => get_the_title($post_id) . ' - Image ' . $i,
            );
        }
        update_post_meta( $post_id, 'images', $images_slider );
    }


	private function get_all_header_footer() {
		return [
			'home-1' => [
				'header' => [
					[
						'slug'       => 'headerbuilder',
						'conditions' => [ 'include/general' ],
					]
				],
				'footer' => [
					[
						'slug'       => 'footerbuilder-1',
						'conditions' => [ 'include/general' ],
					]
				]
			],
			'home-2' => [
				'header' => [
					[
						'slug'       => 'headerbuilder',
						'conditions' => [ 'include/general' ],
					]
				],
				'footer' => [
					[
						'slug'       => 'footerbuilder-1',
						'conditions' => [ 'include/general' ],
					]
				]
			],
			'home-3' => [
				'header' => [
					[
						'slug'       => 'headerbuilder',
						'conditions' => [ 'include/general' ],
					]
				],
				'footer' => [
					[
						'slug'       => 'footerbuilder-2',
						'conditions' => [ 'include/general' ],
					]
				]
			],
			'home-4' => [
				'header' => [
					[
						'slug'       => 'headerbuilder',
						'conditions' => [ 'include/general' ],
					]
				],
				'footer' => [
					[
						'slug'       => 'footerbuilder-2',
						'conditions' => [ 'include/general' ],
					]
				]
			],
			'home-5' => [
				'header' => [
					[
						'slug'       => 'headerbuilder-3',
						'conditions' => [ 'include/general' ],
					]
				],
				'footer' => [
					[
						'slug'       => 'footerbuilder-2',
						'conditions' => [ 'include/general' ],
					]
				]
			],
			'home-6' => [
				'header' => [
					[
						'slug'       => 'headerbuilder-3',
						'conditions' => [ 'include/general' ],
					]
				],
				'footer' => [
					[
						'slug'       => 'footerbuilder-4',
						'conditions' => [ 'include/general' ],
					]
				]
			],
			'home-7' => [
				'header' => [
					[
						'slug'       => 'headerbuilder-4',
						'conditions' => [ 'include/general' ],
					]
				],
				'footer' => [
					[
						'slug'       => 'footerbuilder-4',
						'conditions' => [ 'include/general' ],
					]
				]
			],
			'home-8' => [
				'header' => [
					[
						'slug'       => 'headerbuilder-5',
						'conditions' => [ 'include/general' ],
					]
				],
				'footer' => [
					[
						'slug'       => 'footerbuilder-4',
						'conditions' => [ 'include/general' ],
					]
				]
			],
		];
	}

	private function reset_header_footer() {
		$footer_args = array(
			'post_type'      => 'elementor_library',
			'posts_per_page' => - 1,
			'meta_query'     => array(
				array(
					'key'     => '_elementor_template_type',
					'compare' => 'IN',
					'value'   => [ 'footer', 'header' ]
				),
			)
		);
		$footer      = new WP_Query( $footer_args );
		while ( $footer->have_posts() ) : $footer->the_post();
			update_post_meta( get_the_ID(), '_elementor_conditions', [] );
		endwhile;
		wp_reset_postdata();
	}

	private function fixelementor() {
		$datas = $this->get_data_elementor();
		$query = new WP_Query( array(
			'post_type'      => [
				'page',
				'elementor_library',
			],
			'posts_per_page' => - 1
		) );
		while ( $query->have_posts() ): $query->the_post();
			global $post;
			$postid = get_the_ID();
			if ( get_post_meta( $post->ID, '_elementor_edit_mode', true ) === 'builder' ) {
				$data = json_decode( get_post_meta( $postid, '_elementor_data', true ) );
				if ( ! boolval( $data ) ) {
					if ( isset( $datas[ $post->post_name ] ) ) {
						update_post_meta( $postid, '_elementor_data', wp_slash( wp_json_encode( $datas[ $post->post_name ] ) ) );
					}
				}
			}
		endwhile;
		wp_reset_postdata();
	}

	public function set_demo_menus() {
		$main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );

		set_theme_mod(
			'nav_menu_locations',
			array(
				'primary'  => $main_menu->term_id,
				'handheld' => $main_menu->term_id,
			)
		);
	}

	private function delete_duplicate_hf() {
		global $wpdb, $table_prefix;
		$active_kit_id = Elementor\Plugin::$instance->kits_manager->get_active_id();
		$kit           = get_page_by_title( 'Default Kit', OBJECT, 'elementor_library' );
		if ( $kit ) {
			if ( absint( $active_kit_id ) !== $kit->ID ) {
				wp_delete_post( $kit->ID, true );
			}
		}

		$sql = "DELETE bad_rows.* from " . $table_prefix . "posts as bad_rows inner join ( select post_title, MIN(id) as min_id from " . $table_prefix . "posts where post_type = 'elementor_library' group by post_title having count(*) > 1 ) as good_rows on good_rows.post_title = bad_rows.post_title and good_rows.min_id <> bad_rows.id";

		return $wpdb->get_results( $sql );
	}

	 /**
     * Add options page
     */
    public function add_plugin_page() {
        // This page will be under "Settings"
            add_options_page(
            'Custom Setup Theme',
            'Custom Setup Theme',
            'manage_options',
            'custom-setup-settings',
            array( $this, 'create_admin_page' )
        );
    }

    /**
     * Options page callback
     */
    public function create_admin_page() {
        // Set class property
        $this->options = get_option('triply_options_setup');

        $header_data = $this->get_data_elementor_template('header');
        $footer_data = $this->get_data_elementor_template('footer');
        $tour_data = $this->get_data_elementor_template('single-post');

        $profile = $this->get_all_header_footer();

        $homepage = [];
        foreach ($profile as $key=>$value){
            $homepage[$key] = ucfirst( str_replace('-', ' ', $key) );
        }
        ?>
        <div class="wrap">
        <h1><?php esc_html_e('Custom Setup Themes', 'triply') ?></h1>
        <form method="post" action="<?php echo admin_url('admin-post.php'); ?>">
            <table class="form-table">
                <tr>
                    <th>
                        <label><?php esc_html_e('Setup Themes', 'triply') ?></label>
                    </th>
                    <td>
                        <fieldset>
                            <ul>
                                <li>
                                    <label><?php esc_html_e('Setup Theme', 'triply') ?>:
                                        <select name="setup-theme">
                                            <option value="profile" selected><?php esc_html_e('Select Profile', 'triply') ?></option>
                                             <option value="custom_theme"><?php esc_html_e('Custom Header and Footer', 'triply') ?></option>
                                        </select>
                                    </label>
                                </li>
                                <li class="profile setup-theme">
                                    <label><?php esc_html_e('Profile', 'triply') ?>:
                                        <select name="opal-data-home">
                                            <option value="" selected> <?php esc_html_e('Select home page profile', 'triply') ?></option>
                                            <?php foreach ($homepage as $id => $home) { ?>
                                                <option value="<?php echo esc_attr($id); ?>">
                                                    <?php echo esc_attr($home); ?>
                                                </option>
                                            <?php } ?>
                                        </select>
                                    </label>
                                </li>
                                <li class="custom_theme setup-theme">
                                    <label><?php esc_html_e('Header', 'triply') ?>:
                                        <select name="header">
                                            <option value="" selected><?php esc_html_e('Select header', 'triply') ?></option>
                                            <?php foreach ($header_data as $id => $header) { ?>
                                                <option value="<?php echo esc_attr($id); ?>">
                                                    <?php echo esc_attr($header); ?>
                                                </option>
                                            <?php } ?>
                                        </select>
                                    </label>
                                </li>
                                <li class="custom_theme setup-theme">
                                    <label><?php esc_html_e('Footer', 'triply') ?>:
                                        <select name="footer">
                                            <option value="" selected ><?php esc_html_e('Select Footer', 'triply') ?></option>
                                            <?php foreach ($footer_data as $id => $footer) { ?>
                                                <option value="<?php echo esc_attr($id); ?>">
                                                    <?php echo esc_attr($footer); ?>
                                                </option>
                                            <?php } ?>
                                        </select>
                                    </label>
                                </li>
                                <li class="setup-template">
                                    <label><?php esc_html_e('Tour detail template', 'triply') ?>:
                                        <select name="tour-template">
                                            <option value="" selected ><?php esc_html_e('Select Tour Template', 'triply') ?></option>
                                            <?php foreach ($tour_data as $id => $tour) { ?>
                                                <option value="<?php echo esc_attr($id); ?>">
                                                    <?php echo esc_attr($tour); ?>
                                                </option>
                                            <?php } ?>
                                        </select>
                                    </label>
                                </li>
                                <li>
                                    <input type="checkbox" id="update_elementor_content" name="opal-setup-data-elementor" value="1">
                                    <label><?php esc_html_e('Update Elementor Content', 'triply') ?></label>
                                </li>
                                <li>
                                    <input type="checkbox" id="update_elementor_options" name="opal-setup-data-elementor-options" value="1">
                                    <label><?php esc_html_e('Update Elementor Options', 'triply') ?></label>
                                </li>
                                 <li>
                                    <input type="checkbox" id="update_data_booking" name="opal-setup-data-booking" value="1">
                                    <label><?php esc_html_e('Update Data Booking', 'triply') ?></label>
                                </li>
                            </ul>
                        </fieldset>
                    </td>
                </tr>
            </table>
            <input type="hidden" name="action" value="custom_setup_data">
            <?php submit_button(esc_html('Setup Now!')); ?>
        </form>
        <?php  if (isset($_GET['saved'])) { ?>
            <div class="updated">
                <p><?php esc_html_e('Success! Have been setup for your website', 'triply'); ?></p>
            </div>
        <?php }
    }

    private function get_data_elementor_template($type){
        $args = array(
            'post_type'      => 'elementor_library',
            'posts_per_page' => -1,
            'meta_query'     => array(
                array(
                    'key'     => '_elementor_template_type',
                    'compare' => '=',
                    'value'   => $type
                ),
            )
        );
        $data = new WP_Query($args);
        $select_data = [];
        while ($data->have_posts()): $data->the_post();
            $select_data[get_the_ID()] = get_the_title();
        endwhile;
        wp_reset_postdata();

        return $select_data;
    }

    private function reset_elementor_conditions($type) {
		$args = array(
			'post_type'      => 'elementor_library',
			'posts_per_page' => -1,
			'meta_query'     => array(
				array(
					'key'     => '_elementor_template_type',
					'compare' => '=',
					'value'   => $type
				),
			)
		);
		$query = new WP_Query($args);
		while ($query->have_posts()) : $query->the_post();
			update_post_meta(get_the_ID(), '_elementor_conditions', []);
		endwhile;
		wp_reset_postdata();
	}

    public function custom_setup_data(){
        if(isset($_POST)){
            if(isset($_POST['setup-theme'])){
                if( $_POST['setup-theme'] == 'profile'){
                    if (isset($_POST['opal-data-home']) && !empty($_POST['opal-data-home'])) {
                        $home = (isset($_POST['opal-data-home']) && $_POST['opal-data-home']) ? $_POST['opal-data-home'] : 'home-1';
                        $this->reset_elementor_conditions('header');
                        $this->reset_elementor_conditions('footer');
                        $this->setup_header_footer($home);
                    }
                }else{

                     if(isset($_POST['header']) && !empty($_POST['header'])){
                        $header = $_POST['header'];
                        $this->reset_elementor_conditions('header');
                        update_post_meta($header, '_elementor_conditions', ['include/general']);

                    }

                    if(isset($_POST['footer']) && !empty($_POST['footer'])){
                        $footer= $_POST['footer'];
                        $this->reset_elementor_conditions('footer');
                        update_post_meta($footer, '_elementor_conditions', ['include/general']);
                    }
                }
            }

            if(isset($_POST['tour-template']) && !empty($_POST['tour-template'])){
                $tour_template= $_POST['tour-template'];
                $this->reset_elementor_conditions('single-post');
                update_post_meta($tour_template, '_elementor_conditions', ['include/to_book']);
            }


//            if (isset($_POST['opal-setup-data-elementor'])) {
//                $this->fixelementor();
//            }

            if (isset($_POST['opal-setup-data-elementor-options'])) {
                $options = $this->get_all_options();
                // Elementor
                $active_kit_id = Elementor\Plugin::$instance->kits_manager->get_active_id();
                update_post_meta($active_kit_id, '_elementor_page_settings', $options['elementor']);
            }

            if (isset($_POST['opal-setup-data-booking'])) {
                $check_oneclick['booking'] = false;
                if ( !( $check_oneclick['booking']) && triply_is_ba_booking_activated() ) {
                    $this->update_location_data();
                    $this->update_types_data();
                    $this->update_features_data();
                    $this->update_booking_tour();
                    $ba_settings = wp_parse_args($options['babe'], get_option('babe_settings',[]));
                    update_option('babe_settings', $ba_settings);
                    $check_oneclick['booking'] = true;
                }
            }

            if (isset($_POST['opal-setup-data-elementor']) || isset($_POST['opal-setup-data-elementor-options'])) {

                $cache = new ElementorPro\Modules\ThemeBuilder\Classes\Conditions_Cache();
                $cache->regenerate();

                Elementor\Plugin::$instance->files_manager->clear_cache();
            }

            wp_redirect(admin_url('options-general.php?page=custom-setup-settings&saved=1'));
            exit;
        }
    }

    public function get_all_options(){
            $options = [];
            $options['elementor'] = json_decode('{"system_colors":[{"_id":"primary","title":"Primary","color":"#dc834e"},{"_id":"primary_hover","title":"Primary Hover","color":"#9E5D36"},{"_id":"secondary","title":"Secondary","color":"#202F59"},{"_id":"secondary_hover","title":"Secondary Hover","color":"#121D39"},{"_id":"text","title":"Text","color":"#666666"},{"_id":"accent","title":"Heading","color":"#000000"},{"_id":"lighter","title":"Lighter","color":"#999999"},{"_id":"border","title":"Border","color":"#e5e5e5"}],"custom_colors":[],"system_typography":[{"_id":"primary","title":"Primary","typography_typography":"custom"},{"_id":"secondary","title":"Secondary","typography_typography":"custom"},{"_id":"text","title":"Text","typography_typography":"custom"},{"_id":"accent","title":"Accent","typography_typography":"custom"}],"custom_typography":[],"default_generic_fonts":"Sans-serif","site_name":"Triply","site_description":"Just another WordPress site","page_title_selector":"h1.entry-title","activeItemIndex":1,"container_width":{"unit":"px","size":1290,"sizes":[]},"stretched_section_container":"body","default_page_template":"elementor_header_footer","button_typography_typography":"custom","button_typography_font_size":{"unit":"px","size":14,"sizes":[]},"button_typography_font_weight":"700","button_typography_text_transform":"capitalize","button_typography_line_height":{"unit":"px","size":20,"sizes":[]},"button_text_color":"#FFFFFF","button_border_radius":{"unit":"px","top":"5","right":"5","bottom":"5","left":"5","isLinked":true},"button_padding":{"unit":"px","top":"15","right":"30","bottom":"15","left":"30","isLinked":false},"__globals__":{"button_background_color":"globals/colors?id=primary","button_hover_background_color":"globals/colors?id=primary_hover"},"viewport_mobile":"","viewport_tablet":""}', true);
            $options['options'] = json_decode('[]', true);
            $options['babe'] = json_decode('{"date_format":"d/m/Y","booking_obj_post_slug":"to_book","booking_obj_post_name":"Booking Object","booking_obj_post_name_general":"Booking Objects","booking_obj_menu_name":"BA Book Everything","mpoints_active":0,"content_in_tabs":0,"reviews_in_tabs":0,"reviews_comment_template":"","view_only_uploaded_images":0,"results_per_page":12,"posts_per_taxonomy_page":12,"max_guests_select":12,"av_calendar_max_months":12,"results_view":"grid","google_api":"AIzaSyBidqZRRPexq_TJ3hJ8nPqh6EA5fs3ftZ4","google_map_start_lat":"-33.8688","google_map_start_lng":"151.2195","google_map_zoom":7,"google_map_active":1,"google_map_marker":1,"currency":"USD","currency_place":"left","price_thousand_separator":"","price_decimal_separator":".","price_decimals":2,"price_from_label":"From %s","order_availability_confirm":"auto","order_payment_processing_waiting":30,"unitegallery_remove":0,"av_calendar_remove":0,"google_map_remove":0,"services_to_booking_form":1,"message_av_confirmation":"Your order is waiting for the availability confirmation, you will be notified by email when it\'s ready. Thank you!","message_not_available":"Sorry, but your selected items are not available for selected dates/times. Please, search another dates/times or items and create new order.","message_payment_deferred":"Your order is completed and received, and a confirmation email was sent to you. You will pay the full amount later. Thank you!","message_payment_expected":"Your order is confirmed, but not completed. To complete your order, please, click the link below to make a payment.","message_payment_processing":"Your order has been confirmed and your payment is being processed. Thank you!","message_payment_received":"Your order is completed, your payment has been received, and a confirmation email was sent to you. Thank you!","email_admin_new_order_subject":"New order #%s","email_admin_new_order_title":"New order","email_admin_new_order_message":"You have new order. Please, find details below.","email_admin_new_order_av_confirm_subject":"Availability request","email_admin_new_order_av_confirm_title":"New Order is waiting for confirmation","email_admin_new_order_av_confirm_message":"Please, confirm or reject this Order.","email_new_order_av_confirm_subject":"Your order #%s","email_new_order_av_confirm_title":"New Order created","email_new_order_av_confirm_message":"Hello, %s\r\n\r\nThank you for booking! Your Order is waiting for availability confirmation. We will send you a confirmation letter as soon as possible.","email_new_order_subject":"Your order #%s","email_new_order_title":"Your order has been received","email_new_order_message":"Hello, %1$s\r\n\r\nThank you for booking! Your order has been received.","email_new_order_to_pay_subject":"Your order is waiting for payment","email_new_order_to_pay_title":"Your order is waiting for payment","email_new_order_to_pay_message":"Hello, %1$s\r\n\r\nYour order is confirmed, but not completed. To complete your order, click the link below to make a payment. Amount to pay is %2$s.","email_order_rejected_subject":"Selected items are not available","email_order_rejected_title":"Selected items are not available","email_order_rejected_message":"Hello, %s\r\n\r\nSorry, but your selected items are not available for selected dates/times. You could search another dates/times or items and create new Order.","email_new_customer_created_subject":"Your account details","email_new_customer_created_title":"Your account details","email_new_customer_created_message":"Hello, %s\r\n\r\nThank you for booking with us! You could use this login/password to manage your bookings:","email_password_reseted_subject":"Your password has been reset","email_password_reseted_title":"Your password has been reset.","email_password_reseted_message":"Hello, %s\r\n            \r\nYour password has been reset. You could use this new password to manage your account:","email_admin_order_canceled_subject":"Order # %1$s was canceled","email_admin_order_canceled_title":"Order has been canceled","email_admin_order_canceled_message":"The order has been canceled:","email_order_canceled_subject":"Your order was canceled","email_order_canceled_title":"Your order has been canceled","email_order_canceled_message":"Hello, %1$s\r\n\r\nYour order has been canceled:","email_logo":"","email_header_image":"","email_footer_message":"","email_footer_credit":"","email_color_font":"#000000","email_color_background":"#EAECED","email_color_title":"#ff4800","email_color_link":"#039be5","email_color_button":"#ff4800","email_color_button_yes":"#9acd32","email_color_button_no":"#F64020","payment_methods":["cash","paypal"],"use_extended_wp_import":"1","coupons_active":0,"coupons_expire_days":0,"paypal_email":"ducphamtien-facilitator@gmail.com","paypal_sandbox":1,"paypal_live_client_id":"","paypal_live_secret":"","paypal_test_client_id":"ARIGtnaC3DsPrxza4WTWXEcaNcJRhwGaHOVaN3S-vFV-lZuT_8ze_x_fCLioclMRviCwBaxuxiVK52xP","paypal_test_secret":"EJrYReDGzvxxr0U5RVP4BHbFcIGph-F5XfPsqY1Zz4lzoco4ZvHs89GWkY6-ZzOrTPrq6t-YyIqlshpE","stripe_live_public_key":"","stripe_live_secret_key":"","stripe_test_public_key":"","stripe_test_secret_key":"","stripe_country":"","stripe_sandbox":0,"braintree_live_public_key":"","braintree_live_private_key":"","braintree_live_merchant_id":"","braintree_sandbox_public_key":"","braintree_sandbox_private_key":"","braintree_sandbox_merchant_id":"","braintree_sandbox":0,"triply_booking_google_map_style":"light_grey_and_blue","locations_slug":"","types_slug":"","features_slug":"","amenities_slug":"","languages_slug":"","wishlist_active":"1","wishlist_page":"374","wishlist_icon":"triply-icon-heart","wishlist_added":"Tour added to wishlist!"}', true);
            
            return $options;
        }

    private function get_data_elementor(){
        return json_decode('{"headerbuilder-5":[{"id":"ffd6021","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":50,"sizes":[]},"content_position":"middle","structure":"20","background_background":"classic","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"10","right":"15","bottom":"15","left":"15","isLinked":false},"__globals__":{"background_color":"globals\/colors?id=primary"},"html_tag":"div"},"elements":[{"id":"6e61f66","elType":"column","settings":{"_column_size":50,"_inline_size":70,"_inline_size_tablet":100,"align_tablet":"center","align_mobile":"center","space_between_widgets":0},"elements":[{"id":"2e733da","elType":"widget","settings":{"editor":"<strong>Deals of The Week:<\/strong> Book your world wonder!<strong>\u00a0Up to 50% OFF<\/strong>","align_mobile":"center","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"5","right":"5","bottom":"5","left":"5","isLinked":true},"_element_width":"auto"},"elements":[],"widgetType":"text-editor"},{"id":"f563c37","elType":"widget","settings":{"due_date":"2023-03-25 09:10","label_display":"inline","custom_labels":"yes","label_days":"d","label_hours":"h","label_minutes":"m","label_seconds":"s","expire_actions":[],"box_background_color":"#DC834E00","box_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"digits_typography_typography":"custom","digits_typography_font_size":{"unit":"px","size":14,"sizes":[]},"digits_typography_font_weight":"700","digits_typography_line_height":{"unit":"px","size":"","sizes":[]},"digits_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"digits_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"label_typography_typography":"custom","label_typography_font_size":{"unit":"px","size":14,"sizes":[]},"label_typography_font_weight":"400","_margin_mobile":{"unit":"px","top":"0","right":"5","bottom":"0","left":"5","isLinked":false},"_padding":{"unit":"px","top":"5","right":"20","bottom":"5","left":"20","isLinked":false},"_element_width":"auto","_background_background":"classic","_background_color":"#00000024","_border_radius":{"unit":"px","top":"50","right":"50","bottom":"50","left":"50","isLinked":true},"__globals__":{"box_background_color":"","digits_color":"","_background_color":""}},"elements":[],"widgetType":"countdown"}],"isInner":false},{"id":"d7fcaf0","elType":"column","settings":{"_column_size":50,"_inline_size":30,"align":"flex-end","space_between_widgets":0,"hide_tablet":"hidden-tablet","hide_mobile":"hidden-mobile"},"elements":[{"id":"2d32d24","elType":"widget","settings":{"_element_width":"auto","hide_tablet":"hidden-tablet","hide_mobile":"hidden-mobile","__globals__":{"icon_color_hover":""},"layout_style":"2","login_title":"Log In","separator":"\/","register_title":"Register","login_color":"#FFFFFF","login_color_hover":"#FFFFFF","register_color":"#FFFFFF","register_color_hover":"#FFFFFF","separator_color":"#FFFFFF"},"elements":[],"widgetType":"triply-login"}],"isInner":false}],"isInner":false},{"id":"6234979","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":100,"sizes":[]},"custom_height_tablet":{"unit":"px","size":0,"sizes":[]},"structure":"20","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"6d82efb","elType":"column","settings":{"_column_size":50,"_inline_size":40,"_inline_size_tablet":100,"content_position":"center","align_tablet":"space-between","space_between_widgets":0,"border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"border_width_tablet":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"border_color":"#E8E0DA","padding_tablet":{"unit":"px","top":"20","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[{"id":"0e927e0","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-bars","library":"triply-icon"},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"size":{"unit":"px","size":20,"sizes":[]},"_element_width":"auto","hide_desktop":"hidden-desktop","__globals__":{"primary_color":"globals\/colors?id=accent","hover_primary_color":"globals\/colors?id=primary"},"__dynamic__":{"link":"[elementor-tag id=\"f8c3747\" name=\"popup\" settings=\"%7B%22popup%22%3A%221209%22%7D\"]"},"_padding":{"unit":"px","top":"6","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"icon"},{"id":"1b5470f","elType":"widget","settings":{"__dynamic__":{"image":"[elementor-tag id=\"\" name=\"site-logo\" settings=\"%7B%7D\"]","link":"[elementor-tag id=\"\" name=\"site-url\" settings=\"%7B%7D\"]"},"align":"left","width":{"unit":"px","size":130,"sizes":[]},"_element_width":"auto","_css_classes":"logo"},"elements":[],"widgetType":"theme-site-logo"},{"id":"da5a680","elType":"widget","settings":{"_element_width":"auto","hide_desktop":"hidden-desktop","__globals__":{"icon_color_hover":""},"login_title":"Log In","separator":"\/","register_title":"Register"},"elements":[],"widgetType":"triply-login"}],"isInner":false},{"id":"63d09ee","elType":"column","settings":{"_column_size":50,"_inline_size":60,"_inline_size_mobile":40,"content_position_tablet":"center","align":"flex-end","space_between_widgets":0,"border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"border_width_tablet":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"border_color":"#E8E0DA","padding_tablet":{"unit":"px","top":"20","right":"0","bottom":"20","left":"0","isLinked":false},"hide_tablet":"hidden-tablet","hide_mobile":"hidden-mobile"},"elements":[{"id":"6b781a2","elType":"widget","settings":{"nav_menu_aligrment":"right","nav_menu_typography_font_weight":"500","hide_tablet":"hidden-tablet","hide_mobile":"hidden-mobile","_margin":{"unit":"px","top":"0","right":"-23","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"triply-nav-menu"}],"isInner":false}],"isInner":false}],"headerbuilder-4":[{"id":"02c3c48","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":"","sizes":[]},"structure":"20","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"hide_tablet":"hidden-tablet","hide_mobile":"hidden-mobile","html_tag":"div"},"elements":[{"id":"033ea6b","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center","space_between_widgets":0,"border_border":"solid","border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"border_color":"#E8E0DA","padding":{"unit":"px","top":"10","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[{"id":"5e3bd39","elType":"widget","settings":{"icon_list":[{"text":"1800 - 333 5578","selected_icon":{"value":"triply-icon- triply-icon-phone-1","library":"triply-icon"},"_id":"566c539","link":{"url":"tel:1800 - 333 5578","is_external":"","nofollow":"","custom_attributes":""}}],"icon_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_font_weight":"500","_element_width":"auto","__globals__":{"text_color":"globals\/colors?id=accent","text_color_hover":"globals\/colors?id=primary"},"hide_mobile":"hidden-phone","icon_typography_line_height":{"unit":"px","size":"","sizes":[]},"icon_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"icon_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"0027313","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center","align":"flex-end","space_between_widgets":0,"border_border":"solid","border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"border_color":"#E8E0DA","padding":{"unit":"px","top":"10","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[{"id":"00ca3ff","elType":"widget","settings":{"view":"inline","icon_list":[{"text":"","selected_icon":{"value":"fab fa-facebook","library":"fa-brands"},"_id":"bdaabaf","link":{"url":"https:\/\/www.facebook.com\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"","selected_icon":{"value":"fab fa-twitter","library":"fa-brands"},"link":{"url":"https:\/\/www.twitter.com\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"8c902f0"},{"text":"","selected_icon":{"value":"fab fa-instagram","library":"fa-brands"},"link":{"url":"https:\/\/www.instagram.com\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"1d36e30"}],"space_between":{"unit":"px","size":20,"sizes":[]},"icon_align":"right","icon_size":{"unit":"px","size":18,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"25","bottom":"0","left":"0","isLinked":false},"_element_width":"auto","__globals__":{"icon_color_hover":"globals\/colors?id=primary","icon_color":"globals\/colors?id=lighter"}},"elements":[],"widgetType":"icon-list"},{"id":"5ffe076","elType":"widget","settings":{"_element_width":"auto","__globals__":{"icon_color":"","icon_color_hover":""},"layout_style":"2","login_title":"Log In","separator":"\/","register_title":"Register"},"elements":[],"widgetType":"triply-login"}],"isInner":false}],"isInner":false},{"id":"d67de41","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":100,"sizes":[]},"custom_height_tablet":{"unit":"px","size":0,"sizes":[]},"structure":"20","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div","sticky_effects_offset":100},"elements":[{"id":"6c82dd2","elType":"column","settings":{"_column_size":50,"_inline_size":40,"_inline_size_mobile":60,"content_position":"center","space_between_widgets":0,"border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"border_width_tablet":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"border_color":"#E8E0DA","padding_tablet":{"unit":"px","top":"20","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[{"id":"f70d2f3","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-bars","library":"triply-icon"},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"size":{"unit":"px","size":20,"sizes":[]},"_element_width":"auto","hide_desktop":"hidden-desktop","__globals__":{"primary_color":"globals\/colors?id=accent","hover_primary_color":"globals\/colors?id=primary"},"__dynamic__":{"link":"[elementor-tag id=\"f8c3747\" name=\"popup\" settings=\"%7B%22popup%22%3A%221209%22%7D\"]"},"_padding":{"unit":"px","top":"6","right":"20","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"6","right":"10","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"icon"},{"id":"3103b55","elType":"widget","settings":{"__dynamic__":{"image":"[elementor-tag id=\"\" name=\"site-logo\" settings=\"%7B%7D\"]","link":"[elementor-tag id=\"\" name=\"site-url\" settings=\"%7B%7D\"]"},"align":"left","width":{"unit":"px","size":130,"sizes":[]},"_element_width":"auto","_css_classes":"logo"},"elements":[],"widgetType":"theme-site-logo"}],"isInner":false},{"id":"0933680","elType":"column","settings":{"_column_size":50,"_inline_size":60,"_inline_size_mobile":40,"content_position_tablet":"center","align":"flex-end","space_between_widgets":0,"border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"border_width_tablet":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"border_color":"#E8E0DA","padding_tablet":{"unit":"px","top":"20","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[{"id":"9e9aa6d","elType":"widget","settings":{"nav_menu_aligrment":"right","nav_menu_typography_font_weight":"500","hide_tablet":"hidden-tablet","hide_mobile":"hidden-mobile","_margin":{"unit":"px","top":"0","right":"-23","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"triply-nav-menu"},{"id":"dd3c4ee","elType":"widget","settings":{"icon_list":[{"text":"1800 - 333 5578","selected_icon":{"value":"triply-icon- triply-icon-phone-1","library":"triply-icon"},"_id":"566c539","link":{"url":"tel:1800 - 333 5578","is_external":"","nofollow":"","custom_attributes":""}}],"icon_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_font_weight":"700","_element_width":"auto","__globals__":{"text_color":"globals\/colors?id=accent","text_color_hover":"globals\/colors?id=primary"},"hide_mobile":"hidden-phone","hide_desktop":"hidden-desktop"},"elements":[],"widgetType":"icon-list"},{"id":"814f63f","elType":"widget","settings":{"width":{"unit":"px","size":1,"sizes":[]},"text":"Divider","color":"#00000030","weight":{"unit":"px","size":20,"sizes":[]},"gap":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"_element_width":"auto","hide_mobile":"hidden-phone","hide_desktop":"hidden-desktop"},"elements":[],"widgetType":"divider"},{"id":"a4e47ed","elType":"widget","settings":{"size":{"unit":"px","size":18,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"_element_width":"auto","hide_desktop":"hidden-desktop","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"login_title":"Log In","separator":"\/","register_title":"Register"},"elements":[],"widgetType":"triply-login"},{"id":"b91b8d5","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-menu","library":"triply-icon"},"size":{"unit":"px","size":18,"sizes":[]},"_element_width":"auto","__dynamic__":{"link":"[elementor-tag id=\"99d614e\" name=\"popup\" settings=\"%7B%22popup%22%3A%221589%22%7D\"]"},"__globals__":{"primary_color":"globals\/colors?id=accent","hover_primary_color":"globals\/colors?id=primary"},"_padding":{"unit":"px","top":"6","right":"0","bottom":"0","left":"0","isLinked":false},"primary_color":"#000000","hide_desktop":"hidden-desktop","_padding_tablet":{"unit":"px","top":"6","right":"0","bottom":"0","left":"15","isLinked":false},"_padding_mobile":{"unit":"px","top":"6","right":"0","bottom":"0","left":"10","isLinked":false}},"elements":[],"widgetType":"icon"}],"isInner":false}],"isInner":false}],"headerbuilder-3":[{"id":"f841dc6","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","height":"min-height","custom_height":{"unit":"px","size":100,"sizes":[]},"custom_height_tablet":{"unit":"px","size":80,"sizes":[]},"structure":"30","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div","custom_css":"header{\n    position: absolute !important;\n    z-index: 99;\n    width: 100%;\n}\n","sticky_effects_offset":120},"elements":[{"id":"a397307","elType":"column","settings":{"_column_size":33,"_inline_size":25,"_inline_size_tablet":50,"content_position":"center","align_mobile":"space-between","space_between_widgets":0},"elements":[{"id":"3b5a735","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-bars","library":"triply-icon"},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"size":{"unit":"px","size":20,"sizes":[]},"_element_width":"auto","hide_desktop":"hidden-desktop","__globals__":{"primary_color":"globals\/colors?id=accent","hover_primary_color":"globals\/colors?id=primary"},"__dynamic__":{"link":"[elementor-tag id=\"f8c3747\" name=\"popup\" settings=\"%7B%22popup%22%3A%221209%22%7D\"]"},"_padding":{"unit":"px","top":"6","right":"20","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"6","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"icon"},{"id":"ac136bd","elType":"widget","settings":{"__dynamic__":{"image":"[elementor-tag id=\"\" name=\"site-logo\" settings=\"%7B%7D\"]","link":"[elementor-tag id=\"\" name=\"site-url\" settings=\"%7B%7D\"]"},"align":"left","width":{"unit":"px","size":130,"sizes":[]},"_element_width":"auto","_css_classes":"logo"},"elements":[],"widgetType":"theme-site-logo"},{"id":"af31075","elType":"widget","settings":{"_element_width":"auto","hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet","login_title":"Log In","separator":"\/","register_title":"Register"},"elements":[],"widgetType":"triply-login"}],"isInner":false},{"id":"31abc9a","elType":"column","settings":{"_column_size":33,"_inline_size":49.332999999999998408384271897375583648681640625,"space_between_widgets":0,"hide_tablet":"hidden-tablet","hide_mobile":"hidden-mobile"},"elements":[{"id":"436e1d7","elType":"widget","settings":{"nav_menu_aligrment":"left","hide_tablet":"hidden-tablet","hide_mobile":"hidden-mobile","__globals__":{"menu_title_color_hover":"","menu_item_color_hover":"","menu_title_color":""}},"elements":[],"widgetType":"triply-nav-menu"}],"isInner":false},{"id":"781b0c5","elType":"column","settings":{"_column_size":33,"_inline_size":25,"_inline_size_tablet":50,"content_position":"center","align":"flex-end","space_between_widgets":0,"hide_mobile":"hidden-mobile"},"elements":[{"id":"cb71e70","elType":"widget","settings":{"layout_style":"3","login_title":"Log In","separator":"\/","register_title":"Create Account","login_color":"#202F59","_element_width":"auto","__globals__":{"login_color_hover":"globals\/colors?id=primary"}},"elements":[],"widgetType":"triply-login"}],"isInner":false}],"isInner":false}],"headerbuilder-2":[{"id":"f909722","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":100,"sizes":[]},"custom_height_tablet":{"unit":"px","size":80,"sizes":[]},"structure":"30","background_background":"classic","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"__globals__":{"background_color":""},"stretch_section":"section-stretched","html_tag":"div","sticky_effects_offset":120,"custom_css":"header{\n    position: absolute !important;\n    z-index: 99;\n    width: 100%;\n}"},"elements":[{"id":"7b655a6","elType":"column","settings":{"_column_size":33,"_inline_size":16.5,"_inline_size_tablet":100,"content_position":"center","align":"space-between","space_between_widgets":0},"elements":[{"id":"99d3a41","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-bars","library":"triply-icon"},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"size":{"unit":"px","size":20,"sizes":[]},"_element_width":"auto","hide_desktop":"hidden-desktop","__globals__":{"primary_color":"","hover_primary_color":"globals\/colors?id=primary"},"__dynamic__":{"link":"[elementor-tag id=\"f8c3747\" name=\"popup\" settings=\"%7B%22popup%22%3A%221209%22%7D\"]"},"_padding":{"unit":"px","top":"6","right":"0","bottom":"0","left":"0","isLinked":false},"primary_color":"#FFFFFF","hover_primary_color":"#dc834e"},"elements":[],"widgetType":"icon"},{"id":"1330e88","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/logo-white.svg","id":1414},"library":"svg"},"size":{"unit":"px","size":130,"sizes":[]},"size_mobile":{"unit":"px","size":140,"sizes":[]},"_element_width":"auto","custom_css":"selector i, selector svg{\n    height: auto;\n}","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/","is_external":"","nofollow":"","custom_attributes":""},"align_laptop":"","align_tablet_extra":"","align_mobile_extra":"","size_laptop":{"unit":"px","size":"","sizes":[]},"size_tablet_extra":{"unit":"px","size":"","sizes":[]},"size_mobile_extra":{"unit":"px","size":"","sizes":[]},"icon_padding":{"unit":"px","top":"","right":"","bottom":"","left":"","isLinked":true,"size":"","sizes":[]},"rotate_laptop":{"unit":"px","size":"","sizes":[]},"rotate_tablet_extra":{"unit":"px","size":"","sizes":[]},"rotate_mobile_extra":{"unit":"px","size":"","sizes":[]},"icon_height":{"unit":"px","size":"","sizes":[]},"_margin_laptop":{"unit":"px","top":"","right":"","bottom":"","left":"","isLinked":true},"_margin_tablet_extra":{"unit":"px","top":"","right":"","bottom":"","left":"","isLinked":true},"_margin_mobile_extra":{"unit":"px","top":"","right":"","bottom":"","left":"","isLinked":true},"_padding_laptop":{"unit":"px","top":"","right":"","bottom":"","left":"","isLinked":true},"_padding_tablet_extra":{"unit":"px","top":"","right":"","bottom":"","left":"","isLinked":true},"_padding_mobile_extra":{"unit":"px","top":"","right":"","bottom":"","left":"","isLinked":true},"_element_width_laptop":"","_element_width_tablet_extra":"","_element_width_mobile_extra":"","_element_custom_width_laptop":{"unit":"px","size":"","sizes":[]},"_element_custom_width_tablet_extra":{"unit":"px","size":"","sizes":[]},"_element_custom_width_mobile_extra":{"unit":"px","size":"","sizes":[]},"_element_vertical_align_laptop":"","_element_vertical_align_tablet_extra":"","_element_vertical_align_mobile_extra":"","_offset_x_laptop":{"unit":"px","size":"","sizes":[]},"_offset_x_tablet_extra":{"unit":"px","size":"","sizes":[]},"_offset_x_mobile_extra":{"unit":"px","size":"","sizes":[]},"_offset_x_end_laptop":{"unit":"px","size":"","sizes":[]},"_offset_x_end_tablet_extra":{"unit":"px","size":"","sizes":[]},"_offset_x_end_mobile_extra":{"unit":"px","size":"","sizes":[]},"_offset_y_laptop":{"unit":"px","size":"","sizes":[]},"_offset_y_tablet_extra":{"unit":"px","size":"","sizes":[]},"_offset_y_mobile_extra":{"unit":"px","size":"","sizes":[]},"_offset_y_end_laptop":{"unit":"px","size":"","sizes":[]},"_offset_y_end_tablet_extra":{"unit":"px","size":"","sizes":[]},"_offset_y_end_mobile_extra":{"unit":"px","size":"","sizes":[]},"_z_index_laptop":"","_z_index_tablet_extra":"","_z_index_mobile_extra":"","sticky_on":["desktop","laptop","tablet_extra","tablet","mobile_extra","mobile"],"sticky_offset_laptop":"","sticky_offset_tablet_extra":"","sticky_offset_mobile_extra":"","sticky_effects_offset_laptop":"","sticky_effects_offset_tablet_extra":"","sticky_effects_offset_mobile_extra":"","_animation_laptop":"","_animation_tablet_extra":"","_animation_mobile_extra":"","_transform_rotateZ_effect_laptop":{"unit":"px","size":"","sizes":[]},"_transform_rotateZ_effect_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_rotateZ_effect_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_rotateX_effect_laptop":{"unit":"px","size":"","sizes":[]},"_transform_rotateX_effect_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_rotateX_effect_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_rotateY_effect_laptop":{"unit":"px","size":"","sizes":[]},"_transform_rotateY_effect_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_rotateY_effect_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_perspective_effect_laptop":{"unit":"px","size":"","sizes":[]},"_transform_perspective_effect_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_perspective_effect_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_laptop":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateY_effect_laptop":{"unit":"px","size":"","sizes":[]},"_transform_translateY_effect_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateY_effect_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_scale_effect_laptop":{"unit":"px","size":"","sizes":[]},"_transform_scale_effect_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_scale_effect_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_scaleX_effect_laptop":{"unit":"px","size":"","sizes":[]},"_transform_scaleX_effect_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_scaleX_effect_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_scaleY_effect_laptop":{"unit":"px","size":"","sizes":[]},"_transform_scaleY_effect_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_scaleY_effect_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_skewX_effect_laptop":{"unit":"px","size":"","sizes":[]},"_transform_skewX_effect_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_skewX_effect_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_skewY_effect_laptop":{"unit":"px","size":"","sizes":[]},"_transform_skewY_effect_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_skewY_effect_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_rotateZ_effect_hover_laptop":{"unit":"px","size":"","sizes":[]},"_transform_rotateZ_effect_hover_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_rotateZ_effect_hover_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_rotateX_effect_hover_laptop":{"unit":"px","size":"","sizes":[]},"_transform_rotateX_effect_hover_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_rotateX_effect_hover_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_rotateY_effect_hover_laptop":{"unit":"px","size":"","sizes":[]},"_transform_rotateY_effect_hover_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_rotateY_effect_hover_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_perspective_effect_hover_laptop":{"unit":"px","size":"","sizes":[]},"_transform_perspective_effect_hover_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_perspective_effect_hover_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_hover_laptop":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_hover_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateX_effect_hover_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateY_effect_hover_laptop":{"unit":"px","size":"","sizes":[]},"_transform_translateY_effect_hover_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_translateY_effect_hover_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_scale_effect_hover_laptop":{"unit":"px","size":"","sizes":[]},"_transform_scale_effect_hover_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_scale_effect_hover_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_scaleX_effect_hover_laptop":{"unit":"px","size":"","sizes":[]},"_transform_scaleX_effect_hover_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_scaleX_effect_hover_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_scaleY_effect_hover_laptop":{"unit":"px","size":"","sizes":[]},"_transform_scaleY_effect_hover_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_scaleY_effect_hover_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_skewX_effect_hover_laptop":{"unit":"px","size":"","sizes":[]},"_transform_skewX_effect_hover_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_skewX_effect_hover_mobile_extra":{"unit":"px","size":"","sizes":[]},"_transform_skewY_effect_hover_laptop":{"unit":"px","size":"","sizes":[]},"_transform_skewY_effect_hover_tablet_extra":{"unit":"px","size":"","sizes":[]},"_transform_skewY_effect_hover_mobile_extra":{"unit":"px","size":"","sizes":[]},"motion_fx_transform_x_anchor_point_laptop":"","motion_fx_transform_x_anchor_point_tablet_extra":"","motion_fx_transform_x_anchor_point_mobile_extra":"","motion_fx_transform_y_anchor_point_laptop":"","motion_fx_transform_y_anchor_point_tablet_extra":"","motion_fx_transform_y_anchor_point_mobile_extra":"","_background_image_laptop":{"url":"","id":""},"_background_image_tablet_extra":{"url":"","id":""},"_background_image_mobile_extra":{"url":"","id":""},"_background_position_laptop":"","_background_position_tablet_extra":"","_background_position_mobile_extra":"","_background_xpos_laptop":{"unit":"px","size":"","sizes":[]},"_background_xpos_tablet_extra":{"unit":"px","size":"","sizes":[]},"_background_xpos_mobile_extra":{"unit":"px","size":"","sizes":[]},"_background_ypos_laptop":{"unit":"px","size":"","sizes":[]},"_background_ypos_tablet_extra":{"unit":"px","size":"","sizes":[]},"_background_ypos_mobile_extra":{"unit":"px","size":"","sizes":[]},"_background_repeat_laptop":"","_background_repeat_tablet_extra":"","_background_repeat_mobile_extra":"","_background_size_laptop":"","_background_size_tablet_extra":"","_background_size_mobile_extra":"","_background_bg_width_laptop":{"unit":"px","size":"","sizes":[]},"_background_bg_width_tablet_extra":{"unit":"px","size":"","sizes":[]},"_background_bg_width_mobile_extra":{"unit":"px","size":"","sizes":[]},"_background_slideshow_background_size_laptop":"","_background_slideshow_background_size_tablet_extra":"","_background_slideshow_background_size_mobile_extra":"","_background_slideshow_background_position_laptop":"","_background_slideshow_background_position_tablet_extra":"","_background_slideshow_background_position_mobile_extra":"","_background_hover_image_laptop":{"url":"","id":""},"_background_hover_image_tablet_extra":{"url":"","id":""},"_background_hover_image_mobile_extra":{"url":"","id":""},"_background_hover_position_laptop":"","_background_hover_position_tablet_extra":"","_background_hover_position_mobile_extra":"","_background_hover_xpos_laptop":{"unit":"px","size":"","sizes":[]},"_background_hover_xpos_tablet_extra":{"unit":"px","size":"","sizes":[]},"_background_hover_xpos_mobile_extra":{"unit":"px","size":"","sizes":[]},"_background_hover_ypos_laptop":{"unit":"px","size":"","sizes":[]},"_background_hover_ypos_tablet_extra":{"unit":"px","size":"","sizes":[]},"_background_hover_ypos_mobile_extra":{"unit":"px","size":"","sizes":[]},"_background_hover_repeat_laptop":"","_background_hover_repeat_tablet_extra":"","_background_hover_repeat_mobile_extra":"","_background_hover_size_laptop":"","_background_hover_size_tablet_extra":"","_background_hover_size_mobile_extra":"","_background_hover_bg_width_laptop":{"unit":"px","size":"","sizes":[]},"_background_hover_bg_width_tablet_extra":{"unit":"px","size":"","sizes":[]},"_background_hover_bg_width_mobile_extra":{"unit":"px","size":"","sizes":[]},"_background_hover_slideshow_background_size_laptop":"","_background_hover_slideshow_background_size_tablet_extra":"","_background_hover_slideshow_background_size_mobile_extra":"","_background_hover_slideshow_background_position_laptop":"","_background_hover_slideshow_background_position_tablet_extra":"","_background_hover_slideshow_background_position_mobile_extra":"","_border_width_laptop":{"unit":"px","top":"","right":"","bottom":"","left":"","isLinked":true},"_border_width_tablet_extra":{"unit":"px","top":"","right":"","bottom":"","left":"","isLinked":true},"_border_width_mobile_extra":{"unit":"px","top":"","right":"","bottom":"","left":"","isLinked":true},"_border_radius_laptop":{"unit":"px","top":"","right":"","bottom":"","left":"","isLinked":true},"_border_radius_tablet_extra":{"unit":"px","top":"","right":"","bottom":"","left":"","isLinked":true},"_border_radius_mobile_extra":{"unit":"px","top":"","right":"","bottom":"","left":"","isLinked":true},"_border_hover_width_laptop":{"unit":"px","top":"","right":"","bottom":"","left":"","isLinked":true},"_border_hover_width_tablet_extra":{"unit":"px","top":"","right":"","bottom":"","left":"","isLinked":true},"_border_hover_width_mobile_extra":{"unit":"px","top":"","right":"","bottom":"","left":"","isLinked":true},"_border_radius_hover_laptop":{"unit":"px","top":"","right":"","bottom":"","left":"","isLinked":true},"_border_radius_hover_tablet_extra":{"unit":"px","top":"","right":"","bottom":"","left":"","isLinked":true},"_border_radius_hover_mobile_extra":{"unit":"px","top":"","right":"","bottom":"","left":"","isLinked":true},"_mask_size_laptop":"","_mask_size_tablet_extra":"","_mask_size_mobile_extra":"","_mask_size_scale_laptop":{"unit":"px","size":"","sizes":[]},"_mask_size_scale_tablet_extra":{"unit":"px","size":"","sizes":[]},"_mask_size_scale_mobile_extra":{"unit":"px","size":"","sizes":[]},"_mask_position_laptop":"","_mask_position_tablet_extra":"","_mask_position_mobile_extra":"","_mask_position_x_laptop":{"unit":"px","size":"","sizes":[]},"_mask_position_x_tablet_extra":{"unit":"px","size":"","sizes":[]},"_mask_position_x_mobile_extra":{"unit":"px","size":"","sizes":[]},"_mask_position_y_laptop":{"unit":"px","size":"","sizes":[]},"_mask_position_y_tablet_extra":{"unit":"px","size":"","sizes":[]},"_mask_position_y_mobile_extra":{"unit":"px","size":"","sizes":[]},"_mask_repeat_laptop":"","_mask_repeat_tablet_extra":"","_mask_repeat_mobile_extra":"","hide_laptop":"","hide_tablet_extra":"","hide_mobile_extra":""},"elements":[],"widgetType":"icon"},{"id":"a093487","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-menu","library":"triply-icon"},"size":{"unit":"px","size":18,"sizes":[]},"_element_width":"auto","__dynamic__":{"link":"[elementor-tag id=\"99d614e\" name=\"popup\" settings=\"%7B%22popup%22%3A%221589%22%7D\"]"},"__globals__":{"primary_color":"","hover_primary_color":"globals\/colors?id=primary"},"primary_color":"#FFFFFF","hover_primary_color":"#dc834e","hide_desktop":"hidden-desktop"},"elements":[],"widgetType":"icon"}],"isInner":false},{"id":"6084ab6","elType":"column","settings":{"_column_size":33,"_inline_size":62.5,"space_between_widgets":0,"hide_tablet":"hidden-tablet","hide_mobile":"hidden-mobile"},"elements":[{"id":"a0ef335","elType":"widget","settings":{"nav_menu_aligrment":"","menu_title_color":"#FFFFFF","hide_tablet":"hidden-tablet","hide_mobile":"hidden-mobile","__globals__":{"menu_title_color_hover":"","menu_item_color_hover":"","menu_title_color_action":"globals\/colors?id=primary"}},"elements":[],"widgetType":"triply-nav-menu"}],"isInner":false},{"id":"0c090fa","elType":"column","settings":{"_column_size":33,"_inline_size":20.553999999999998493649400188587605953216552734375,"content_position":"center","space_between_widgets":0,"hide_tablet":"hidden-tablet","hide_mobile":"hidden-mobile"},"elements":[{"id":"260c5cf","elType":"widget","settings":{"view":"inline","icon_list":[{"text":"","selected_icon":{"value":"fab fa-facebook","library":"fa-brands"},"_id":"bdaabaf","link":{"url":"https:\/\/www.facebook.com\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"","selected_icon":{"value":"fab fa-twitter","library":"fa-brands"},"link":{"url":"https:\/\/www.twitter.com\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"8c902f0"},{"text":"","selected_icon":{"value":"fab fa-instagram","library":"fa-brands"},"link":{"url":"https:\/\/www.instagram.com\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"1d36e30"}],"space_between":{"unit":"px","size":20,"sizes":[]},"icon_align":"right","icon_color":"#FFFFFF","icon_size":{"unit":"px","size":18,"sizes":[]},"hide_tablet":"hidden-tablet","hide_mobile":"hidden-mobile","__globals__":{"icon_color_hover":"globals\/colors?id=primary"}},"elements":[],"widgetType":"icon-list"}],"isInner":false}],"isInner":false}],"footerbuilder-4":[{"id":"0c11f7d","elType":"section","settings":{"gap":"no","structure":"40","padding":{"unit":"px","top":"100","right":"30","bottom":"0","left":"30","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"90","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"35","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"15","bottom":"0","left":"15","isLinked":false},"border_border":"solid","border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"border_color":"globals\/colors?id=border"},"padding_tablet":{"unit":"px","top":"60","right":"30","bottom":"0","left":"30","isLinked":false},"html_tag":"div"},"elements":[{"id":"b086e17","elType":"column","settings":{"_column_size":25,"_inline_size":42.5,"space_between_widgets":0,"_inline_size_tablet":55,"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"40","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"a2f8d79","elType":"widget","settings":{"__dynamic__":{"image":"[elementor-tag id=\"\" name=\"site-logo\" settings=\"%7B%7D\"]","link":"[elementor-tag id=\"\" name=\"site-url\" settings=\"%7B%7D\"]"},"align":"left","width":{"unit":"px","size":130,"sizes":[]},"_element_width":"auto","_css_classes":"logo","_padding":{"unit":"px","top":"0","right":"0","bottom":"35","left":"0","isLinked":false}},"elements":[],"widgetType":"theme-site-logo"},{"id":"f67b2c0","elType":"widget","settings":{"editor":"<p>Nisi ut aliquip ex ea commodo consequatute irure dolor in reprehenderit in voluptatevelit esse cillum dolore eu fugiat nulla excepteur pariatur.<\/p>","_padding":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"_element_width":"initial","_element_width_mobile":"inherit","_element_custom_width":{"unit":"px","size":410,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"1e9245b","elType":"widget","settings":{"title":"Sign up for our newsletter","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"ca94b46","elType":"widget","settings":{"form_name":"New Form","form_fields":[{"custom_id":"email","field_type":"email","required":"true","field_label":"Email","placeholder":"johndoe@example.com","width":"66","_id":"6f021ad","width_mobile":"60","width_tablet":"60"}],"show_labels":"","button_width":"33","step_next_label":"Next","step_previous_label":"Previous","button_text":"Subscribe","email_to":"admin@admin.com","email_subject":"New message from \"Triply\"","email_content":"[all-fields]","email_from":"email@dev.wpopal.com","email_from_name":"Triply","email_to_2":"admin@admin.com","email_subject_2":"New message from \"Triply\"","email_content_2":"[all-fields]","email_from_2":"email@dev.wpopal.com","email_from_name_2":"Triply","email_reply_to_2":"admin@admin.com","mailchimp_fields_map":[],"drip_fields_map":[],"activecampaign_fields_map":[],"getresponse_fields_map":[],"convertkit_fields_map":[],"mailerlite_fields_map":[],"success_message":"The form was sent successfully.","error_message":"An error occurred.","required_field_message":"This field is required.","invalid_message":"There\'s something wrong. The form is invalid.","field_typography_typography":"custom","field_typography_line_height":{"unit":"px","size":24,"sizes":[]},"field_background_color":"","field_border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"field_border_radius":{"unit":"px","top":"5","right":"5","bottom":"5","left":"5","isLinked":true},"__globals__":{"field_border_color":"","button_background_color":"","field_border_color_focus":"globals\/colors?id=primary","label_color":"globals\/colors?id=lighter","html_color":"globals\/colors?id=lighter","field_text_color":"globals\/colors?id=lighter","field_background_color":"","textarea_color":""},"field_text_color":"#999999","field_typography_font_size":{"unit":"px","size":16,"sizes":[]},"field_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"button_typography_typography":"custom","button_typography_font_size":{"unit":"px","size":14,"sizes":[]},"button_typography_line_height":{"unit":"px","size":20,"sizes":[]},"button_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"button_border_radius":{"unit":"px","top":"5","right":"5","bottom":"5","left":"5","isLinked":true},"button_width_mobile":"40","field_text_padding":{"unit":"px","top":"13","right":"20","bottom":"13","left":"20","isLinked":false},"button_background_color_style_2_mobile":{"unit":"px","top":"15","right":"8","bottom":"15","left":"8","isLinked":false},"_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":550,"sizes":[]},"selected_button_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"button_icon_align":"right","button_icon_indent":{"unit":"px","size":10,"sizes":[]},"column_gap":{"unit":"px","size":"","sizes":[]},"row_gap":{"unit":"px","size":"","sizes":[]},"label_color":"#999999","html_color":"#999999","field_border_color_focus":"#dc834e","button_background_color_style_2":{"unit":"px","top":"15","right":"20","bottom":"15","left":"20","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":410,"sizes":[]},"button_width_tablet":"40","custom_css":"selector.elementor-element.elementor-element-ca94b46 .elementor-field-group:not(.elementor-field-type-upload):not(.elementor-field-type-recaptcha_v3):not(.elementor-field-type-recaptcha) .elementor-field:not(.elementor-select-wrapper){\n    box-shadow: 0px 0px 30px rgba(0, 0, 0, 0.05);\n}"},"elements":[],"widgetType":"form"},{"id":"d0e096c","elType":"widget","settings":{"social_icon_list":[{"social_icon":{"value":"fab fa-facebook","library":"fa-brands"},"_id":"dbf57e9","link":{"url":"https:\/\/www.facebook.com\/","is_external":"true","nofollow":"","custom_attributes":""},"item_icon_color":"custom","item_icon_secondary_color":"#1877F2"},{"social_icon":{"value":"fab fa-twitter","library":"fa-brands"},"_id":"94455d3","link":{"url":"https:\/\/www.twitter.com\/","is_external":"true","nofollow":"","custom_attributes":""},"item_icon_color":"custom","item_icon_secondary_color":"#1DA1F2"},{"social_icon":{"value":"fab fa-instagram","library":"fa-brands"},"link":{"url":"https:\/\/www.instagram.com\/","is_external":"true","nofollow":"","custom_attributes":""},"item_icon_color":"custom","item_icon_secondary_color":"#000100","_id":"9a9e1c2"},{"social_icon":{"value":"fab fa-linkedin","library":"fa-brands"},"link":{"url":"https:\/\/www.linkedin.com\/","is_external":"true","nofollow":"","custom_attributes":""},"item_icon_color":"custom","item_icon_secondary_color":"#0A66C2","_id":"751faff"}],"shape":"circle","align":"left","icon_color":"custom","icon_primary_color":"#02010100","icon_padding":{"unit":"em","size":0,"sizes":[]},"icon_spacing":{"unit":"px","size":30,"sizes":[]},"__globals__":{"hover_secondary_color":"globals\/colors?id=primary"}},"elements":[],"widgetType":"social-icons"}],"isInner":false},{"id":"67b588a","elType":"column","settings":{"_column_size":25,"_inline_size":20,"space_between_widgets":0,"_inline_size_tablet":45,"padding":{"unit":"px","top":"5","right":"15","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"5","right":"0","bottom":"0","left":"15","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"ffa0ce8","elType":"widget","settings":{"title":"TOP DESTINATIONS","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":18,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_text_transform":"uppercase","_padding":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"f26e40f","elType":"widget","settings":{"icon_list":[{"text":"Europe","selected_icon":{"value":"","library":""},"_id":"1e7336a","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/argentina\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":" Middle East","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/asia\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"743da1e"},{"text":"Africa","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/africa\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"bdb01c6"},{"text":" South America","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/americas\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"2488e9d"},{"text":" Central America","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/americas\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"ce3390a"},{"text":"Asian","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/asia\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"1939073"},{"text":"South East Asian ","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/asia\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"0c1805c"},{"text":"Pacific","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/cambodia\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"f30085c"},{"text":" Americas ","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/americas\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"34a2799"},{"text":"South Africa","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/africa\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"b0fcfae"}],"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_font_weight":"500","icon_typography_line_height":{"unit":"px","size":30,"sizes":[]},"icon_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"icon_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color_hover":"globals\/colors?id=primary","text_color":"globals\/colors?id=text"}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"05e8b51","elType":"column","settings":{"_column_size":25,"_inline_size":20.5,"space_between_widgets":0,"_inline_size_tablet":55,"padding":{"unit":"px","top":"5","right":"15","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"cd0e55a","elType":"widget","settings":{"title":"Popular cities","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":18,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_text_transform":"uppercase","_padding":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"26ba651","elType":"widget","settings":{"icon_list":[{"text":"Las Vegas ","selected_icon":{"value":"","library":""},"_id":"1e7336a","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/cambodia\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":" New York City","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/canada\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"743da1e"},{"text":" San Francisco","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/africa\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"bdb01c6"},{"text":" Hawaii","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/americas\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"2488e9d"},{"text":" Boston","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/argentina\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"ce3390a"},{"text":"Seattle","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/to_book\/7-days-in-costa-rica-classic-self-drive\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"d096c52"},{"text":" Chicago","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/to_book\/yellowstone-and-grand-teton-adventure-6-day\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"a6b8a0a"},{"text":" Arizona ","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/to_book\/essence-of-vietnam-south-to-north\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"0eb41ef"},{"text":"Houston","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/to_book\/landmannalaugar-trek\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"2d38470"},{"text":" New Orleans","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/to_book\/serrania-de-la-macarena-jungle-tour\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"057ba04"}],"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_font_weight":"500","icon_typography_line_height":{"unit":"px","size":30,"sizes":[]},"icon_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"icon_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color_hover":"globals\/colors?id=primary","text_color":"globals\/colors?id=text"}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"e489a1b","elType":"column","settings":{"_column_size":25,"_inline_size":16.629000000000001335820343228988349437713623046875,"space_between_widgets":0,"_inline_size_tablet":45,"padding":{"unit":"px","top":"5","right":"15","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"9d0de62","elType":"widget","settings":{"title":"Company","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":18,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_text_transform":"uppercase","_padding":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"8999394","elType":"widget","settings":{"icon_list":[{"text":"About Us","selected_icon":{"value":"","library":""},"_id":"1e7336a","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/about-us\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Contact Us","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/contact\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"743da1e"},{"text":" Travel Guides","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"bdb01c6"},{"text":" Cookie Policy","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"ce3390a"}],"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_font_weight":"500","icon_typography_line_height":{"unit":"px","size":30,"sizes":[]},"icon_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"icon_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color_hover":"globals\/colors?id=primary","text_color":"globals\/colors?id=text"},"_padding":{"unit":"px","top":"0","right":"0","bottom":"25","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[],"widgetType":"icon-list"},{"id":"9334f75","elType":"widget","settings":{"title":"Quick Links","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":18,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_text_transform":"uppercase","_padding":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"6969b2d","elType":"widget","settings":{"icon_list":[{"text":"Become Affiliate Partner","selected_icon":{"value":"","library":""},"_id":"1e7336a","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":" Become Host ","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"743da1e"},{"text":"Associations","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"bdb01c6"},{"text":" Press","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"2488e9d"}],"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_font_weight":"500","icon_typography_line_height":{"unit":"px","size":30,"sizes":[]},"icon_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"icon_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color_hover":"globals\/colors?id=primary","text_color":"globals\/colors?id=text"}},"elements":[],"widgetType":"icon-list"}],"isInner":false}],"isInner":false},{"id":"b72c20b","elType":"section","settings":{"gap":"no","structure":"20","margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"margin_tablet":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding":{"unit":"px","top":"0","right":"30","bottom":"55","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"40","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"30","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"0d53c0e","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[{"id":"8efbb43","elType":"widget","settings":{"editor":"<div>Copyright \u00a9 2022 <a href=\"http:\/\/https:\/\/demo2wpopal.b-cdn.net\/triply\/\">Triply<\/a>. All Rights Reserved.<\/div>","text_color":"#000000","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":"","sizes":[]},"align_mobile":"left","align_tablet":"left","typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent","typography_typography":""}},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"6de15f0","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"a6eeab9","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/footer_2-image-1.png","id":504},"image_size":"full","align":"right","align_tablet":"right","align_mobile":"left"},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false}],"footerbuilder-3":[{"id":"c4cd834","elType":"section","settings":{"gap":"no","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"40","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"c3e7139","elType":"column","settings":{"_column_size":100,"_inline_size":null,"align":"center","space_between_widgets":0,"align_mobile":"flex-start"},"elements":[{"id":"fc5fbcb","elType":"widget","settings":{"title":"Sign up for our newsletter","align":"center","title_color":"#000000","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_line_height":{"unit":"px","size":46,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":40,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","typography_typography":""},"align_mobile":"left","typography_font_size_mobile":{"unit":"px","size":35,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"2b6e3ed","elType":"widget","settings":{"editor":"<p>Save up to 50% on tours and trips. Get instant access to lower prices.<\/p>","align":"center","_padding":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"align_mobile":"left"},"elements":[],"widgetType":"text-editor"},{"id":"6be5e67","elType":"widget","settings":{"form_name":"New Form","form_fields":[{"custom_id":"email","field_type":"email","required":"true","field_label":"Email","placeholder":"johndoe@example.com","width":"75","_id":"6f021ad","width_mobile":"60"}],"show_labels":"","button_width":"25","step_next_label":"Next","step_previous_label":"Previous","button_text":"Subscribe","email_to":"admin@admin.com","email_subject":"New message from \"Triply\"","email_content":"[all-fields]","email_from":"email@dev.wpopal.com","email_from_name":"Triply","email_to_2":"admin@admin.com","email_subject_2":"New message from \"Triply\"","email_content_2":"[all-fields]","email_from_2":"email@dev.wpopal.com","email_from_name_2":"Triply","email_reply_to_2":"admin@admin.com","mailchimp_fields_map":[],"drip_fields_map":[],"activecampaign_fields_map":[],"getresponse_fields_map":[],"convertkit_fields_map":[],"mailerlite_fields_map":[],"success_message":"The form was sent successfully.","error_message":"An error occurred.","required_field_message":"This field is required.","invalid_message":"There\'s something wrong. The form is invalid.","field_typography_typography":"custom","field_typography_line_height":{"unit":"px","size":24,"sizes":[]},"field_background_color":"","field_border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"field_border_radius":{"unit":"px","top":"5","right":"5","bottom":"5","left":"5","isLinked":true},"__globals__":{"field_border_color":"","button_background_color":"","field_border_color_focus":"globals\/colors?id=primary","label_color":"globals\/colors?id=lighter","html_color":"globals\/colors?id=lighter","field_text_color":"globals\/colors?id=lighter","field_background_color":"","textarea_color":""},"field_text_color":"#999999","field_typography_font_size":{"unit":"px","size":16,"sizes":[]},"field_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"button_typography_typography":"custom","button_typography_font_size":{"unit":"px","size":14,"sizes":[]},"button_typography_line_height":{"unit":"px","size":20,"sizes":[]},"button_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"button_border_radius":{"unit":"px","top":"5","right":"5","bottom":"5","left":"5","isLinked":true},"button_width_mobile":"40","field_text_padding":{"unit":"px","top":"18","right":"20","bottom":"18","left":"20","isLinked":false},"button_background_color_style_2_mobile":{"unit":"px","top":"20","right":"8","bottom":"20","left":"8","isLinked":false},"_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":550,"sizes":[]},"selected_button_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"button_icon_align":"right","button_icon_indent":{"unit":"px","size":10,"sizes":[]},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"column_gap":{"unit":"px","size":"","sizes":[]},"row_gap":{"unit":"px","size":"","sizes":[]},"label_color":"#999999","html_color":"#999999","field_border_color_focus":"#dc834e","button_background_color_style_2":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"_element_width":"initial","_element_custom_width":{"unit":"px","size":630,"sizes":[]},"custom_css":"selector.elementor-element.elementor-element-6be5e67 .elementor-field-group:not(.elementor-field-type-upload):not(.elementor-field-type-recaptcha_v3):not(.elementor-field-type-recaptcha) .elementor-field:not(.elementor-select-wrapper){\n    box-shadow: 0px 0px 30px rgba(0, 0, 0, 0.05)\n}"},"elements":[],"widgetType":"form"}],"isInner":false}],"isInner":false},{"id":"566c962","elType":"section","settings":{"gap":"no","structure":"50","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"95665b1","elType":"column","settings":{"_column_size":20,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_inline_size_tablet":40,"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"cab45ef","elType":"widget","settings":{"title":"TOP DESTINATIONS","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":18,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_text_transform":"uppercase","_padding":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"b73baed","elType":"widget","settings":{"icon_list":[{"text":"Europe","selected_icon":{"value":"","library":""},"_id":"1e7336a","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/argentina\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":" Middle East","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/asia\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"743da1e"},{"text":"Africa","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/africa\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"bdb01c6"},{"text":" South America","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/americas\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"2488e9d"},{"text":" Central America","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/americas\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"ce3390a"}],"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_font_weight":"500","icon_typography_line_height":{"unit":"px","size":30,"sizes":[]},"icon_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"icon_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color_hover":"globals\/colors?id=primary_hover","text_color":"globals\/colors?id=text"}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"7d62b8a","elType":"column","settings":{"_column_size":20,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_inline_size_tablet":60},"elements":[{"id":"e6c1ba9","elType":"widget","settings":{"title":"Popular cities","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":18,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_text_transform":"uppercase","_padding":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"7178c3d","elType":"widget","settings":{"icon_list":[{"text":"Las Vegas ","selected_icon":{"value":"","library":""},"_id":"1e7336a","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/cambodia\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":" New York City","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/canada\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"743da1e"},{"text":" San Francisco","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/africa\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"bdb01c6"},{"text":" Hawaii","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/americas\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"2488e9d"},{"text":" Boston","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/ba_locations\/argentina\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"ce3390a"}],"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_font_weight":"500","icon_typography_line_height":{"unit":"px","size":30,"sizes":[]},"icon_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"icon_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color_hover":"globals\/colors?id=primary_hover","text_color":"globals\/colors?id=text"}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"a7f8765","elType":"column","settings":{"_column_size":20,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_inline_size_tablet":40},"elements":[{"id":"450d692","elType":"widget","settings":{"title":"Popular Attractions","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":18,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_text_transform":"uppercase","_padding":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"ff58b63","elType":"widget","settings":{"icon_list":[{"text":"Antelop Canyon ","selected_icon":{"value":"","library":""},"_id":"1e7336a","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/to_book\/7-days-in-costa-rica-classic-self-drive\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"British Museum","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/to_book\/yellowstone-and-grand-teton-adventure-6-day\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"743da1e"},{"text":" Safari Park","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/to_book\/essence-of-vietnam-south-to-north\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"bdb01c6"},{"text":" Stonehenge","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/to_book\/landmannalaugar-trek\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"2488e9d"},{"text":" Historic District","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/to_book\/serrania-de-la-macarena-jungle-tour\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"ce3390a"}],"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_font_weight":"500","icon_typography_line_height":{"unit":"px","size":30,"sizes":[]},"icon_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"icon_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color_hover":"globals\/colors?id=primary_hover","text_color":"globals\/colors?id=text"}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"840b144","elType":"column","settings":{"_column_size":20,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_inline_size_tablet":30},"elements":[{"id":"b3bb9c9","elType":"widget","settings":{"title":"Company","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":18,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_text_transform":"uppercase","_padding":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"fe46379","elType":"widget","settings":{"icon_list":[{"text":"About Us","selected_icon":{"value":"","library":""},"_id":"1e7336a","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Contact Us","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"743da1e"},{"text":" Travel Guides","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"bdb01c6"},{"text":" Data Policy","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"2488e9d"},{"text":" Cookie Policy","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"ce3390a"}],"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_font_weight":"500","icon_typography_line_height":{"unit":"px","size":30,"sizes":[]},"icon_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"icon_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color_hover":"globals\/colors?id=primary_hover","text_color":"globals\/colors?id=text"}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"fb65a2f","elType":"column","settings":{"_column_size":20,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"_inline_size_tablet":30},"elements":[{"id":"9ed5a9e","elType":"widget","settings":{"title":"Quick Links","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":18,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_text_transform":"uppercase","_padding":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"dd0f2d7","elType":"widget","settings":{"icon_list":[{"text":"Become Affiliate Partner","selected_icon":{"value":"","library":""},"_id":"1e7336a","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":" Become Host ","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"743da1e"},{"text":"Associations","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"bdb01c6"},{"text":" Press","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"2488e9d"}],"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_font_weight":"500","icon_typography_line_height":{"unit":"px","size":30,"sizes":[]},"icon_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"icon_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color_hover":"globals\/colors?id=primary_hover","text_color":"globals\/colors?id=text"}},"elements":[],"widgetType":"icon-list"}],"isInner":false}],"isInner":false},{"id":"eac25f0","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":"","sizes":[]},"structure":"20","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/footer3_bg.png","id":7550,"alt":"","source":"library"},"background_position":"bottom center","background_repeat":"no-repeat","margin_mobile":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding":{"unit":"px","top":"0","right":"30","bottom":"320","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"200","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"200","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"fad81a2","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"border_border":"solid","border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"border_color":"#E8E0DA","padding":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"de774b2","elType":"widget","settings":{"editor":"<div>Copyright \u00a9 2022 <a href=\"http:\/\/https:\/\/demo2wpopal.b-cdn.net\/triply\/\">Triply<\/a>. All Rights Reserved.<\/div>","text_color":"#000000","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":"","sizes":[]},"align_mobile":"left","align_tablet":"left","typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent","typography_typography":""}},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"aebb014","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"border_border":"solid","border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"border_width_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"border_color":"#E8E0DA","padding":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"15","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"3aacd25","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/footer_2-image-1.png","id":504},"image_size":"full","align":"right","align_tablet":"right","align_mobile":"left"},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false}],"home-8":[{"id":"54d28ab","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color":"#F9F4F0","padding":{"unit":"px","top":"30","right":"30","bottom":"60","left":"30","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"15","bottom":"60","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"4931711","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"55ba4c2","elType":"widget","settings":{"destinations_title":"Destinations","destinations_subtitle":"Where are you going?","activity_title":"Activity","activity_subtitle":"All Activity","date_title":"When","guests_title":"Guests","search_title":"Search","taxonomy_search":[{"_id":"667a46b","taxonomy_slug":"locations","taxonomy_title":"Destinations","taxonomy_subtitle":"Where are you going?","taxonomy_icon":{"value":"triply-icon- triply-icon-map-marker-rounded","library":"triply-icon"}},{"_id":"202a807","taxonomy_slug":"types","taxonomy_title":"Activity","taxonomy_subtitle":"All Activity","taxonomy_icon":{"value":"triply-icon- triply-icon-activity","library":"triply-icon"}}],"search":"","_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-search-form"},{"id":"b9a1ea8","elType":"section","settings":{"structure":"20","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_bg2.png","id":8688,"alt":"","source":"library"},"background_repeat":"no-repeat","border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"background_size":"cover","html_tag":"div"},"elements":[{"id":"c29adfd","elType":"column","settings":{"_column_size":50,"_inline_size":null,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_bg1.png","id":8683,"alt":"","source":"library"},"background_repeat":"no-repeat","background_overlay_background":"classic","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_vector1.png","id":8704,"alt":"","source":"library"},"background_overlay_position":"bottom left","background_overlay_repeat":"no-repeat","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"padding":{"unit":"px","top":"70","right":"0","bottom":"70","left":"110","isLinked":false},"border_radius":{"unit":"px","top":"20","right":"0","bottom":"0","left":"20","isLinked":false},"background_size":"cover","padding_tablet":{"unit":"px","top":"30","right":"30","bottom":"30","left":"30","isLinked":true},"_inline_size_tablet":50,"border_radius_mobile":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true}},"elements":[{"id":"68f1a7d","elType":"widget","settings":{"title":"Explore our Wondersome Adventures","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_line_height":{"unit":"px","size":62,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":40,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"typography_font_size_tablet":{"unit":"px","size":40,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":30,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"ff5d07c","elType":"widget","settings":{"editor":"<span style=\"font-weight:700;\">Save up to 50%<\/span> - book your dream trip now!","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"d3d12ce","elType":"widget","settings":{"text":"book now","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","background_color":"#FFFFFF","__globals__":{"button_text_color":"globals\/colors?id=secondary","button_icon_color":"globals\/colors?id=primary","button_background_hover_color":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/tours-list-view\/","is_external":"","nofollow":"","custom_attributes":""},"button_text_color":"#202F59","button_icon_color":"#dc834e","align_mobile":"center"},"elements":[],"widgetType":"button"}],"isInner":true},{"id":"466de6e","elType":"column","settings":{"_column_size":50,"_inline_size":null,"hide_mobile":"hidden-mobile"},"elements":[],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"598d3d1","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"8186176","elType":"column","settings":{"_column_size":50,"_inline_size":30,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"content_position":"center","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"z_index":1},"elements":[{"id":"c179850","elType":"widget","settings":{"title":"Trending<br> Attractions","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_weight":"700","typography_line_height":{"unit":"px","size":54,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":40,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_font_size_tablet":{"unit":"px","size":40,"sizes":[]},"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"f8c16af","elType":"widget","settings":{"editor":"<p>Book your trip when it is perfectly designed and customized, just for you.<\/p>","align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"687b1a5","elType":"widget","settings":{"text":"all destination","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","align_mobile":"center","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/destination-list\/","is_external":"","nofollow":"","custom_attributes":""}},"elements":[],"widgetType":"button"}],"isInner":false},{"id":"233ec32","elType":"column","settings":{"_column_size":50,"_inline_size":70,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"130","isLinked":false},"_title":"Column","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"align_mobile":"center"},"elements":[{"id":"576ab0d","elType":"widget","settings":{"taxonomy_array":[{"_id":"5483f49","taxonomy_slug":"attractions","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_img.jpg","id":8766,"alt":"","source":"library"},"locations_id":"americas","attractions_id":"colosseum"},{"_id":"9d9887e","taxonomy_slug":"attractions","types_id":"beaches","features_id":"feature-3","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_img1.jpg","id":8765,"alt":"","source":"library"},"attractions_id":"eiffel-tower"},{"_id":"4075145","taxonomy_slug":"attractions","types_id":"cruises","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_img2.jpg","id":8764,"alt":"","source":"library"},"attractions_id":"statue-of-liberty"},{"_id":"a1b4d3d","taxonomy_slug":"attractions","types_id":"hiking","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_img3.jpg","id":8763,"alt":"","source":"library"},"attractions_id":"niagara-falls"},{"_id":"1992160","taxonomy_slug":"attractions","locations_id":"europe","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_img2.jpg","id":8764,"alt":"","source":"library"},"attractions_id":"statue-of-liberty"},{"taxonomy_slug":"attractions","locations_id":"france","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_img1.jpg","id":8765,"alt":"","source":"library"},"_id":"edfae42","attractions_id":"eiffel-tower"},{"taxonomy_slug":"attractions","locations_id":"iceland","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_img3.jpg","id":8763,"alt":"","source":"library"},"_id":"9c1f582","attractions_id":"niagara-falls"}],"column":"4","enable_carousel":"yes","navigation":"none","visibility":"","column_mobile":"1","_element_width":"initial","_element_width_tablet":"inherit","_element_width_mobile":"initial","_element_custom_width":{"unit":"px","size":1200,"sizes":[]},"_element_custom_width_mobile":{"unit":"px","size":300,"sizes":[]}},"elements":[],"widgetType":"taxonomy-array"}],"isInner":false}],"isInner":false},{"id":"6c3c2ac","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":600,"sizes":[]},"structure":"20","background_background":"classic","background_color":"#F9F4F0","background_overlay_background":"classic","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_vector.png","id":7564,"alt":"","source":"library"},"background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"padding":{"unit":"px","top":"40","right":"80","bottom":"40","left":"80","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"80","right":"30","bottom":"80","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"15","bottom":"60","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"e884aeb","elType":"column","settings":{"_column_size":50,"_inline_size":null,"margin":{"unit":"px","top":"0","right":"45","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"bc2f0d3","elType":"section","settings":{"gap":"no","structure":"20","margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"40","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"a666048","elType":"column","settings":{"_column_size":50,"_inline_size":null,"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"6ab10e4","elType":"widget","settings":{"title_text":"154","description_text":"Destinations","title_typography_typography":"custom","_padding":{"unit":"px","top":"30","right":"65","bottom":"30","left":"65","isLinked":false},"_border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"_box_shadow_box_shadow_type":"yes","_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":30,"spread":0,"color":"rgba(0, 0, 0, 0.05)"},"title_typography_font_size":{"unit":"px","size":50,"sizes":[]},"title_typography_line_height":{"unit":"px","size":54,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"selected_icon":{"value":"triply-icon- triply-icon-destination","library":"triply-icon"},"icon_size":{"unit":"px","size":80,"sizes":[]},"__globals__":{"primary_color":"globals\/colors?id=accent"},"title_bottom_space":{"unit":"px","size":5,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"1f50490","elType":"column","settings":{"_column_size":50,"_inline_size":null,"margin":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"df78935","elType":"widget","settings":{"title_text":"2547","description_text":"Amazing Tours","title_typography_typography":"custom","_padding":{"unit":"px","top":"30","right":"55","bottom":"30","left":"55","isLinked":false},"_border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"_box_shadow_box_shadow_type":"yes","_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":30,"spread":0,"color":"rgba(0, 0, 0, 0.05)"},"title_typography_font_size":{"unit":"px","size":50,"sizes":[]},"title_typography_line_height":{"unit":"px","size":54,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"selected_icon":{"value":"triply-icon- triply-icon-tours","library":"triply-icon"},"icon_size":{"unit":"px","size":80,"sizes":[]},"__globals__":{"primary_color":"globals\/colors?id=accent"},"title_bottom_space":{"unit":"px","size":5,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":true}],"isInner":true},{"id":"c37f229","elType":"section","settings":{"gap":"no","structure":"20","margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"91dbd25","elType":"column","settings":{"_column_size":50,"_inline_size":null,"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"0a98e0b","elType":"widget","settings":{"title_text":"98","description_text":"Tour Types","title_typography_typography":"custom","_padding":{"unit":"px","top":"30","right":"65","bottom":"30","left":"65","isLinked":false},"_border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"_box_shadow_box_shadow_type":"yes","_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":30,"spread":0,"color":"rgba(0, 0, 0, 0.05)"},"title_typography_font_size":{"unit":"px","size":50,"sizes":[]},"title_typography_line_height":{"unit":"px","size":54,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"selected_icon":{"value":"triply-icon- triply-icon-types","library":"triply-icon"},"icon_size":{"unit":"px","size":80,"sizes":[]},"__globals__":{"primary_color":"globals\/colors?id=accent"},"title_bottom_space":{"unit":"px","size":5,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"3dd5b54","elType":"column","settings":{"_column_size":50,"_inline_size":null,"margin":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"5cf61ed","elType":"widget","settings":{"title_text":"11,577","description_text":"Happy Customer","title_typography_typography":"custom","_padding":{"unit":"px","top":"30","right":"50","bottom":"30","left":"50","isLinked":false},"_border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"_box_shadow_box_shadow_type":"yes","_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":30,"spread":0,"color":"rgba(0, 0, 0, 0.05)"},"title_typography_font_size":{"unit":"px","size":50,"sizes":[]},"title_typography_line_height":{"unit":"px","size":54,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"selected_icon":{"value":"triply-icon- triply-icon-happy","library":"triply-icon"},"icon_size":{"unit":"px","size":80,"sizes":[]},"__globals__":{"primary_color":"globals\/colors?id=accent"},"title_bottom_space":{"unit":"px","size":5,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"e005d1e","elType":"column","settings":{"_column_size":50,"_inline_size":null,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"45","isLinked":false},"content_position":"center","_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"834c092","elType":"widget","settings":{"title":"We make world<br> travel easy","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_weight":"700","typography_line_height":{"unit":"px","size":54,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"19893cf","elType":"widget","settings":{"editor":"<p>Traveling under your own power and at your own pace, you\'ll connect more meaningfully with your destination and have more fun!<\/p>","align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"94b7761","elType":"widget","settings":{"text":"explore our tours","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","align_mobile":"center","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/tours-list-view\/","is_external":"","nofollow":"","custom_attributes":""}},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false},{"id":"2e68ac7","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"40","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"afd5a0a","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"c45a24e","elType":"widget","settings":{"title":"Popular Tours","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_weight":"700","typography_line_height":{"unit":"px","size":54,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"align":"center","typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"d42ae38","elType":"widget","settings":{"editor":"<p>Popular tours and trip packages. View them by travel style.<\/p>","align":"center","__globals__":{"text_color":"globals\/colors?id=lighter"}},"elements":[],"widgetType":"text-editor"},{"id":"aef8df2","elType":"widget","settings":{"per_page":"6","column":"3"},"elements":[],"widgetType":"babe-all-items"}],"isInner":false}],"isInner":false},{"id":"c95e1e1","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"cd978b9","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"d009162","elType":"widget","settings":{"title":"Why book with Triply?","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_weight":"700","typography_line_height":{"unit":"px","size":54,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"align":"center","typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"ac42ff6","elType":"widget","settings":{"editor":"<p>More than 20 Years of Experience, Best Deals and Personalised Services.<\/p>","align":"center","__globals__":{"text_color":"globals\/colors?id=lighter"}},"elements":[],"widgetType":"text-editor"},{"id":"add8f03","elType":"section","settings":{"gap":"no","structure":"40","html_tag":"div"},"elements":[{"id":"e799b8c","elType":"column","settings":{"_column_size":25,"_inline_size":null,"padding":{"unit":"px","top":"0","right":"50","bottom":"0","left":"35","isLinked":false},"_inline_size_tablet":50,"padding_tablet":{"unit":"px","top":"0","right":"25","bottom":"40","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"3e97288","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/calendar-add.svg","id":7828},"library":"svg"},"view":"stacked","title_text":"Flexible bookings","description_text":"Avoid fees and frustration with cancellations up to 56 days before departure on eligible trips and easy deposit transfer.","primary_color":"#FFFFFF","icon_size":{"unit":"px","size":55,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":28,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"custom_css":"selector .elementor-icon{\n    box-shadow: 0 0 30px 0 rgb(0, 0, 0 , 0.05);\n}","__globals__":{"title_color":"globals\/colors?id=accent"},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":24,"sizes":[]},"description_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"description_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"5a56086","elType":"column","settings":{"_column_size":25,"_inline_size":null,"padding":{"unit":"px","top":"0","right":"50","bottom":"0","left":"50","isLinked":false},"_inline_size_tablet":50,"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"25","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"9b4f92c","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/shield-tick.svg","id":7830},"library":"svg"},"view":"stacked","title_text":"Safe travels","description_text":"Your health and wellbeing are our number one priority \u2013 we\u2019ve got the latest COVID-19 Health & Safety Guidelines.","primary_color":"#FFFFFF","icon_size":{"unit":"px","size":55,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":28,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"custom_css":"selector .elementor-icon{\n    box-shadow: 0 0 30px 0 rgb(0, 0, 0 , 0.05);\n}","__globals__":{"title_color":"globals\/colors?id=accent"},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":24,"sizes":[]},"description_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"description_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"1941bcf","elType":"column","settings":{"_column_size":25,"padding":{"unit":"px","top":"0","right":"50","bottom":"0","left":"50","isLinked":false},"_inline_size_tablet":50,"padding_tablet":{"unit":"px","top":"0","right":"25","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"cc5ec2b","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/map.svg","id":7829},"library":"svg"},"view":"stacked","title_text":"The right trip for you","description_text":"Whether near or far from home, your trip will be local led and full of unforgettable experiences,  taken care of.","primary_color":"#FFFFFF","icon_size":{"unit":"px","size":55,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":28,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"custom_css":"selector .elementor-icon{\n    box-shadow: 0 0 30px 0 rgb(0, 0, 0 , 0.05);\n}","__globals__":{"title_color":"globals\/colors?id=accent"},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":24,"sizes":[]},"description_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"description_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"c1113d4","elType":"column","settings":{"_column_size":25,"_inline_size":null,"padding":{"unit":"px","top":"0","right":"35","bottom":"0","left":"50","isLinked":false},"_inline_size_tablet":50,"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"25","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"eb3ecf7","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/arrow-square.svg","id":7827},"library":"svg"},"view":"stacked","title_text":"Locally based guides","description_text":"Our Chief Experience Officers are all locally based, meaning they know the area you\u2019re exploring.","primary_color":"#FFFFFF","icon_size":{"unit":"px","size":55,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":28,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"custom_css":"selector .elementor-icon{\n    box-shadow: 0 0 30px 0 rgb(0, 0, 0 , 0.05);\n}","__globals__":{"title_color":"globals\/colors?id=accent"},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":24,"sizes":[]},"description_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"description_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"f1cc3cb","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"100","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"60","left":"15","isLinked":false},"html_tag":"div","background_image":{"url":"","id":"","alt":"","source":"library"},"background_overlay_background":"classic","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_bg.png","id":7855,"alt":"","source":"library"},"background_overlay_position":"bottom center","background_overlay_repeat":"no-repeat","background_overlay_opacity":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"background_overlay_size":"contain"},"elements":[{"id":"02b3b95","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"7849f07","elType":"widget","settings":{"title":"Popular Destinations","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"334b4e1","elType":"section","settings":{"gap":"no","structure":"30","margin":{"unit":"px","top":"0","right":0,"bottom":"20","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div","layout":"full_width"},"elements":[{"id":"882a838","elType":"column","settings":{"_column_size":33,"_inline_size":24.699999999999999289457264239899814128875732421875,"space_between_widgets":0,"align_mobile":"center","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"custom_css":"@media(max-width: 1024px) {\n    selector{\n        order: -1;\n    }\n}"},"elements":[{"id":"7b5f898","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"europe","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_destination.jpg","id":7930,"alt":"","source":"library"},"count_tour":"yes","custom_text":"From <span>100$<\/span>","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":410,"sizes":[]},"image_opacity":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"custom_css":"selector .content-location{\n    position: absolute;\n    top:70%;\n    left: 40px;\n    transform: translate(0,0);\n     text-align: left\n}\nselector .thumbnail-location{\n    width: 100%;\n}\nselector .thumbnail-location img{\n    width: 100%;\n    object-fit: cover;\n}\n"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":true},{"id":"f3e7bb8","elType":"column","settings":{"_column_size":33,"_inline_size":50.15400000000000346744855050928890705108642578125,"space_between_widgets":0,"align_mobile":"center","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"hide_mobile":"hidden-mobile"},"elements":[{"id":"8fe0955","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"americas","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_destination1.jpg","id":7931,"alt":"","source":"library"},"count_tour":"yes","custom_text":"From <span>100$<\/span>","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":410,"sizes":[]},"image_opacity":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"custom_css":"selector .content-location{\n    position: absolute;\n    top:70%;\n    left: 40px;\n    transform: translate(0,0);\n     text-align: left\n}\nselector .thumbnail-location{\n    width: 100%;\n}\nselector .thumbnail-location img{\n    width: 100%;\n    object-fit: cover;\n}\n"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":true},{"id":"06f4ebe","elType":"column","settings":{"_column_size":33,"_inline_size":24.699999999999999289457264239899814128875732421875,"space_between_widgets":0,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"25","left":"15","isLinked":false},"custom_css":"@media(max-width: 1024px) {\n    selector{\n        order: -1;\n    }\n}","padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"957f2fd","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"viet-nam","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_destination2.jpg","id":7932,"alt":"","source":"library"},"count_tour":"yes","custom_text":"From <span>100$<\/span>","img_location_radius":{"unit":"%","top":"","right":"","bottom":"","left":"","isLinked":true},"image_opacity":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"custom_css":"selector .content-location{\n    position: absolute;\n    top:70%;\n    left: 40px;\n    transform: translate(0,0);\n     text-align: left\n}\nselector .thumbnail-location{\n    width: 100%;\n}\nselector .thumbnail-location img{\n    width: 100%;\n    object-fit: cover;\n}\n"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":true}],"isInner":true},{"id":"5614b58","elType":"section","settings":{"gap":"no","structure":"30","html_tag":"div","layout":"full_width"},"elements":[{"id":"a483d8c","elType":"column","settings":{"_column_size":33,"_inline_size":50.15400000000000346744855050928890705108642578125,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"25","left":"0","isLinked":false},"hide_mobile":"hidden-mobile"},"elements":[{"id":"17cb7dc","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"costa-rica","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_destination3.jpg","id":7933,"alt":"","source":"library"},"count_tour":"yes","custom_text":"From <span>100$<\/span>","image_opacity":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"custom_css":"selector .content-location{\n    position: absolute;\n    top:70%;\n    left: 40px;\n    transform: translate(0,0);\n     text-align: left\n}\nselector .thumbnail-location{\n    width: 100%;\n}\nselector .thumbnail-location img{\n    width: 100%;\n    object-fit: cover;\n}\n","_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"taxonomy-item"}],"isInner":true},{"id":"cdf370f","elType":"column","settings":{"_column_size":33,"_inline_size":24.76200000000000045474735088646411895751953125,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"63021bf","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"africa","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_destination4.jpg","id":7934,"alt":"","source":"library"},"count_tour":"yes","custom_text":"From <span>100$<\/span>","image_opacity":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"custom_css":"selector .content-location{\n    position: absolute;\n    top:70%;\n    left: 40px;\n    transform: translate(0,0);\n     text-align: left\n}\nselector .thumbnail-location{\n    width: 100%;\n}\nselector .thumbnail-location img{\n    width: 100%;\n    object-fit: cover;\n}\n"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":true},{"id":"0b30b5a","elType":"column","settings":{"_column_size":33,"_inline_size":24.75,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"8093cf3","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"colombia","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_destination5.jpg","id":7935,"alt":"","source":"library"},"count_tour":"yes","custom_text":"From <span>100$<\/span>","image_opacity":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"custom_css":"selector .content-location{\n    position: absolute;\n    top:70%;\n    left: 40px;\n    transform: translate(0,0);\n     text-align: left\n}\nselector .thumbnail-location{\n    width: 100%;\n}\nselector .thumbnail-location img{\n    width: 100%;\n    object-fit: cover;\n}\n"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"bdfe820","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"21408cf","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"f92ec2c","elType":"widget","settings":{"title":"Trusted by all the<br> largest travel brands","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"c6bee5a","elType":"widget","settings":{"carousel":[{"id":8560,"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_brand5.jpg"},{"id":8561,"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_brand4.jpg"},{"id":8562,"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_brand3.jpg"},{"id":8563,"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_brand2.jpg"},{"id":8564,"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_brand1.jpg"},{"id":8565,"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_brand.jpg"}],"navigation":"none","thumbnail_size":"full","slides_to_show":"6","slides_to_show_tablet":"4","slides_to_show_mobile":"2"},"elements":[],"widgetType":"image-carousel"}],"isInner":false}],"isInner":false},{"id":"ebef322","elType":"section","settings":{"stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin":{"unit":"px","top":"90","right":0,"bottom":"90","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"70","right":0,"bottom":"70","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"60","right":0,"bottom":"60","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"1328c30","elType":"column","settings":{"_column_size":100,"_inline_size":null,"background_background":"classic","background_color":"#F9F4F0","background_overlay_background":"classic","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_vector.png","id":7564,"alt":"","source":"library"},"background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"padding":{"unit":"px","top":"100","right":"60","bottom":"100","left":"60","isLinked":false},"align":"center","padding_mobile":{"unit":"px","top":"60","right":"15","bottom":"60","left":"15","isLinked":false}},"elements":[{"id":"d5abd42","elType":"widget","settings":{"testimonials":[{"_id":"42df068","testimonial_content":"\u201cAbsolutely awesome!! The knowledge our guides had was amazing. What we saw and how we were treated was incredible.\u201d","testimonial_name":"John Doe - Yellowstone National Park","testimonial_job":"Design"},{"_id":"a1477d7","testimonial_content":"\u201cSix days of cycling on and off road, tough but super enjoyable and interesting. Lucky to have a great group and tour guide, Alfonso.\u201d","testimonial_name":"Catherine Bannatyne - Yellowstone National Park","testimonial_job":"Design"},{"_id":"94b1a18","testimonial_content":"\u201cMy first visit to Croatia and I wasn\u2019t disappointed. The coastline are beautiful, lovely blue clear waters and great weather.\u201d","testimonial_name":"Sean Pearson - Yellowstone National Park","testimonial_job":"Design"},{"_id":"68d20ab","testimonial_content":"\u201cWe had an absolutely amazing trip and I can\'t wait to come back! Everyone was helpful and patiently answered all of my questions.\u201d","testimonial_name":"Amy Woods - Yellowstone National Park","testimonial_job":"Design"}],"column":"1","layout_style":"5","enable_carousel":"yes","navigation":"both","next_horizontal":"right","next_horizontal_value":{"unit":"%","size":-16,"sizes":[]},"next_horizontal_value_tablet":{"unit":"%","size":"","sizes":[]},"next_horizontal_value_mobile":{"unit":"%","size":"","sizes":[]},"prev_horizontal":"left","prev_horizontal_value":{"unit":"%","size":-16,"sizes":[]},"prev_horizontal_value_tablet":{"unit":"%","size":"","sizes":[]},"prev_horizontal_value_mobile":{"unit":"%","size":"","sizes":[]},"_element_width":"initial","_element_custom_width":{"unit":"px","size":850,"sizes":[]},"_element_width_tablet":"inherit","column_mobile":"1","content_typography_typography":"custom","content_typography_font_size":{"unit":"px","size":30,"sizes":[]},"content_typography_font_weight":"500","content_typography_line_height":{"unit":"px","size":40,"sizes":[]},"content_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"content_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"custom_css":"selector .slick-arrow{\n    height: 50px;\n    width: 50px;\n}","column_tablet":"1"},"elements":[],"widgetType":"triply-testimonials"}],"isInner":false}],"isInner":false},{"id":"617af02","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"3cdc08a","elType":"column","settings":{"_column_size":100,"_inline_size":null,"margin":{"unit":"px","top":"0","right":"55","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"453b60e","elType":"widget","settings":{"title":"Latest Travel Guides","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_weight":"700","typography_line_height":{"unit":"px","size":54,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"60876c3","elType":"widget","settings":{"editor":"<p>View our travel guides giving you travel insights, ideas, and tips across the world.<\/p>","__globals__":{"text_color":"globals\/colors?id=lighter"},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"4d5a2b2","elType":"widget","settings":{"posts_per_page":4,"column":"2","pagination_page_limit":"5","pagination_prev_label":"&laquo; Previous","pagination_next_label":"Next &raquo;","post_style_special_yes":"yes"},"elements":[],"widgetType":"triply-post-grid"}],"isInner":false}],"isInner":false}],"home-7":[{"id":"d3aa6d2","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":640,"sizes":[]},"custom_height_tablet":{"unit":"px","size":500,"sizes":[]},"custom_height_mobile":{"unit":"px","size":500,"sizes":[]},"stretch_section":"section-stretched","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_bg01.jpg","id":10852,"alt":"","source":"library"},"background_position":"top center","background_repeat":"no-repeat","background_motion_fx_motion_fx_scrolling":"yes","background_motion_fx_translateY_effect":"yes","background_motion_fx_mouseTrack_effect":"yes","background_overlay_background":"classic","background_overlay_opacity":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"__globals__":{"background_overlay_color":"globals\/colors?id=accent"},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"background_motion_fx_translateY_speed":{"unit":"px","size":10,"sizes":[]},"html_tag":"div"},"elements":[{"id":"f416eca","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"04b06ad","elType":"widget","settings":{"title":"Discover the Worlds<br> most Amazing Places","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":50,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":42,"sizes":[]},"typography_font_weight":"700","typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":42,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_element_custom_width":{"unit":"px","size":680,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"58eb387","elType":"widget","settings":{"editor":"<p>Search, compare and book 15,000+ multiday tours all over the world.<\/p>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":28,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"c8b524a","elType":"widget","settings":{"text":"explore our tours","align":"left","size":"md","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"_element_custom_width":{"unit":"px","size":150,"sizes":[]},"_element_custom_width_mobile":{"unit":"px","size":145,"sizes":[]},"__globals__":{"background_color":"globals\/colors?id=primary","button_background_hover_color":"globals\/colors?id=primary_hover","border_color":"globals\/colors?id=primary","button_hover_border_color":"globals\/colors?id=primary_hover"},"border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"animation_duration":"fast","__dynamic__":[],"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/tours-list-sidebar\/","is_external":"","nofollow":"","custom_attributes":""},"text_padding":{"unit":"px","top":"19","right":"28","bottom":"19","left":"28","isLinked":false}},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false},{"id":"bfc4c66","elType":"section","settings":{"gap":"no","structure":"20","border_border":"solid","border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"border_color":"#E8E0DA","margin":{"unit":"px","top":"0","right":0,"bottom":"85","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"100","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"65","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"80","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"60","left":"0","isLinked":false},"html_tag":"div"},"elements":[{"id":"d19f919","elType":"column","settings":{"_column_size":50,"_inline_size":48,"space_between_widgets":0,"padding":{"unit":"px","top":"90","right":"15","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"38","left":"0","isLinked":false},"_inline_size_tablet":50},"elements":[{"id":"2663c6f","elType":"widget","settings":{"title":"Welcome","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"8ed551d","elType":"widget","settings":{"title":"It\'s time to travel again","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":54,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"35","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":440,"sizes":[]},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"5546006","elType":"widget","settings":{"editor":"<p>Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Lorem ipsum dolor sit amet, consectetur adipisicing elit.<\/p>","_element_width":"initial","_element_custom_width":{"unit":"px","size":510,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"45","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_element_width_mobile":"inherit","_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"949bdf5","elType":"section","settings":{"layout":"full_width","gap":"no","structure":"20","html_tag":"div"},"elements":[{"id":"1c7d28e","elType":"column","settings":{"_column_size":50,"_inline_size":43,"space_between_widgets":0,"_inline_size_tablet":100},"elements":[{"id":"1c0f451","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_img3.png","id":8306,"alt":"","source":"library"},"image_size":"full","align":"left","_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"9e22856","elType":"column","settings":{"_column_size":50,"_inline_size":57,"space_between_widgets":0,"_inline_size_tablet":100},"elements":[{"id":"40a732a","elType":"widget","settings":{"title":"Not a Member Yet?","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_line_height":{"unit":"px","size":28,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"c5109c0","elType":"widget","settings":{"editor":"Join us! Our members can access<br> savings of up to 50% booking.","_padding":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"9a89b97","elType":"widget","settings":{"text":"Sign In","align":"justify","size":"md","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"6","bottom":"10","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"5","bottom":"0","left":"0","isLinked":false},"_element_width":"initial","_element_width_mobile":"initial","_element_custom_width":{"unit":"px","size":146,"sizes":[]},"_element_custom_width_mobile":{"unit":"px","size":145,"sizes":[]},"__globals__":{"background_color":"globals\/colors?id=primary","button_background_hover_color":"globals\/colors?id=primary_hover","border_color":"globals\/colors?id=primary","button_hover_border_color":"globals\/colors?id=primary_hover"},"border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"animation_duration":"fast","__dynamic__":{"link":"[elementor-tag id=\"052d385\" name=\"internal-url\" settings=\"%7B%22type%22%3A%22post%22%2C%22post_id%22%3A%229%22%7D\"]"},"_margin_tablet":{"unit":"px","top":"0","right":"6","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"button"},{"id":"b0fbdd4","elType":"widget","settings":{"text":"Register","align":"justify","size":"md","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"background_color":"#DC834E00","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"border_color":"#202F59","_element_width":"initial","_element_custom_width":{"unit":"px","size":140,"sizes":[]},"__globals__":{"background_color":"","border_color":"globals\/colors?id=secondary","button_text_color":"globals\/colors?id=secondary","button_hover_border_color":"globals\/colors?id=primary","hover_color":"globals\/colors?id=primary","button_icon_color":"globals\/colors?id=primary","button_background_hover_color":""},"animation_duration":"fast","__dynamic__":{"link":"[elementor-tag id=\"fd0471a\" name=\"internal-url\" settings=\"%7B%22type%22%3A%22post%22%2C%22post_id%22%3A%229%22%7D\"]"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"button_text_color":"#202F59","hover_color":"#dc834e","button_hover_border_color":"#dc834e","button_icon_color":"#dc834e"},"elements":[],"widgetType":"button"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"2865b35","elType":"column","settings":{"_column_size":50,"_inline_size":52,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"content_position_tablet":"center","padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"margin":{"unit":"px","top":"-70","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true}},"elements":[{"id":"47670d3","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_img2.jpg","id":8357,"alt":"","source":"library"},"image_size":"full","align":"right","image_border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"align_mobile":"left","width_mobile":{"unit":"px","size":767,"sizes":[]}},"elements":[],"widgetType":"image"},{"id":"af813c8","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_img1.jpg","id":8358,"alt":"","source":"library"},"image_size":"full","align":"left","image_border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"_element_width":"auto","_offset_y":{"unit":"px","size":230,"sizes":[]},"_margin":{"unit":"px","top":"-475","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"hide_tablet":"hidden-tablet","hide_mobile":"hidden-mobile","width_tablet":{"unit":"%","size":0,"sizes":[]},"width_mobile":{"unit":"%","size":0,"sizes":[]}},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"1315657","elType":"section","settings":{"gap":"no","structure":"20","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"83fb12f","elType":"column","settings":{"_column_size":50,"_inline_size":24.5,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_deco1.png","id":8497,"alt":"","source":"library"},"background_position":"top right","background_repeat":"no-repeat","border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"margin":{"unit":"px","top":"15","right":"15","bottom":"45","left":"0","isLinked":false},"padding":{"unit":"px","top":"30","right":"40","bottom":"30","left":"40","isLinked":false},"__globals__":{"background_color":"globals\/colors?id=primary"},"_inline_size_tablet":45,"margin_tablet":{"unit":"px","top":"15","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"30","right":"15","bottom":"30","left":"15","isLinked":false},"padding_mobile":{"unit":"px","top":"50","right":"30","bottom":"60","left":"30","isLinked":false}},"elements":[{"id":"769ff31","elType":"widget","settings":{"title":"today\u2019s best deals","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":28,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"b1f55f1","elType":"widget","settings":{"title":"Get 10% off your next booking","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_line_height":{"unit":"px","size":46,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":40,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"35","left":"0","isLinked":false},"typography_font_size_mobile":{"unit":"px","size":35,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"5d93bc3","elType":"widget","settings":{"text":"View More","align":"left","size":"md","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"background_color":"#DC834E00","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"border_color":"#FFFFFF","_element_custom_width":{"unit":"px","size":140,"sizes":[]},"__globals__":{"background_color":"","border_color":"","button_text_color":"","button_hover_border_color":"globals\/colors?id=secondary_hover","hover_color":"","button_icon_color":"","button_background_hover_color":"globals\/colors?id=secondary_hover"},"animation_duration":"fast","__dynamic__":[],"button_text_color":"#FFFFFF","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/tours-list-top-search\/","is_external":"","nofollow":"","custom_attributes":""}},"elements":[],"widgetType":"button"}],"isInner":false},{"id":"af88366","elType":"column","settings":{"_column_size":50,"_inline_size":75.5,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":55,"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true}},"elements":[{"id":"430c849","elType":"widget","settings":{"per_page":"5","column":"3","style":"8","enable_carousel":"yes","_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"next_horizontal":"right","next_horizontal_value_tablet":{"unit":"px","size":0,"sizes":[]},"next_horizontal_value_mobile":{"unit":"px","size":15,"sizes":[]},"prev_horizontal":"left","prev_horizontal_value_tablet":{"unit":"px","size":0,"sizes":[]},"prev_horizontal_value_mobile":{"unit":"px","size":15,"sizes":[]},"next_horizontal_value":{"unit":"px","size":"","sizes":[]},"prev_horizontal_value":{"unit":"px","size":"","sizes":[]},"column_tablet":"1","visibility":"","custom_css":"selector .slick-dots{\n    left: -165px;\n}"},"elements":[],"widgetType":"babe-all-items"}],"isInner":false}],"isInner":false},{"id":"352bd8b","elType":"section","settings":{"gap":"no","structure":"40","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"6e7c6a5","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"30","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[{"id":"1a54e41","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/medal-star.svg","id":7882},"library":"svg"},"title_text":"25 Years of Excellence ","description_text":"Deliver the\nmost convenient and efficient\nof travel services.","position":"left","icon_space":{"unit":"px","size":20,"sizes":[]},"title_bottom_space":{"unit":"px","size":10,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_typography_line_height":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"__globals__":{"primary_color":"","title_color":"globals\/colors?id=accent"},"position_mobile":"left","_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"px","size":300,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"2a91503","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[{"id":"284370d","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/24-support.svg","id":7880},"library":"svg"},"title_text":"24\/7 Customer Support","description_text":"Our skilled travel\nagents ready to\nassist you any time of the day.","position":"left","icon_space":{"unit":"px","size":20,"sizes":[]},"title_bottom_space":{"unit":"px","size":10,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_typography_line_height":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"__globals__":{"primary_color":"","title_color":"globals\/colors?id=accent"},"position_mobile":"left","_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"px","size":300,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"8e46d43","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[{"id":"5838e30","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/global-search.svg","id":7881},"library":"svg"},"title_text":"117+ Locations","description_text":"Pproviding you the most\nefficient and\nreliable services.","position":"left","icon_space":{"unit":"px","size":20,"sizes":[]},"title_bottom_space":{"unit":"px","size":10,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_typography_line_height":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"__globals__":{"primary_color":"","title_color":"globals\/colors?id=accent"},"position_mobile":"left","_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"px","size":300,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"486bdd3","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true}},"elements":[{"id":"bad6861","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/verify.svg","id":7883},"library":"svg"},"title_text":"Exclusive Promo Deals","description_text":"Best deals on tour\npackages, and\nother travel services.","position":"left","icon_space":{"unit":"px","size":20,"sizes":[]},"title_bottom_space":{"unit":"px","size":10,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_typography_line_height":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"__globals__":{"primary_color":"","title_color":"globals\/colors?id=accent"},"position_mobile":"left","_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"px","size":300,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":false}],"isInner":false},{"id":"31c91aa","elType":"section","settings":{"gap":"no","html_tag":"div"},"elements":[{"id":"3d53625","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"641f9d9","elType":"widget","settings":{"title":"Places to go","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"align":"center","_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"5ebf1bd","elType":"widget","settings":{"title":"Top Destinations","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":54,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"align":"center","typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"}],"isInner":false}],"isInner":false},{"id":"d275365","elType":"section","settings":{"layout":"full_width","gap":"no","stretch_section":"section-stretched","structure":"40","html_tag":"div"},"elements":[{"id":"caa6255","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_img4.jpg","id":8657,"alt":"","source":"library"},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_overlay_background":"classic","background_overlay_opacity":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"css_classes":"card-container","custom_css":".card-container:hover .overlay{\r\n  opacity: 1;\r\n}\r\n\r\n.overlay{\r\n  position: absolute;\r\n  width: 100%;\r\n  height: 100%;\r\n  top: 0;\r\n  opacity: 0;\r\n  transition: all 0.35s ease;\r\n}\r\n\r\n    \r\n    ","__globals__":{"background_overlay_color":"globals\/colors?id=accent"}},"elements":[{"id":"0f22a52","elType":"widget","settings":{"title":"Europe","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":40,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"0","left":"40","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"184ce4c","elType":"widget","settings":{"space":{"unit":"px","size":280,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"084de17","elType":"section","settings":{"layout":"full_width","gap":"no","background_overlay_background":"classic","background_overlay_opacity":{"unit":"px","size":0.6999999999999999555910790149937383830547332763671875,"sizes":[]},"css_classes":"overlay","__globals__":{"background_overlay_color":"globals\/colors?id=accent"},"html_tag":"div"},"elements":[{"id":"1495531","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"81a6f87","elType":"widget","settings":{"title":"Europe","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":40,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"10","left":"40","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"c2da5e8","elType":"widget","settings":{"taxonomy_slug":"locations","per_page":"6","column":"1","Typography_typography":"custom","Typography_font_size":{"unit":"px","size":14,"sizes":[]},"title_color":"#FFFFFF","_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"__globals__":{"color_hover":"globals\/colors?id=primary"},"column_tablet":"1"},"elements":[],"widgetType":"babe-taxonomies-list"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"2a43d3e","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_img5.jpg","id":8658,"alt":"","source":"library"},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_overlay_background":"classic","background_overlay_opacity":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"css_classes":"card-container","custom_css":".card-container:hover .overlay{\r\n  opacity: 1;\r\n}\r\n\r\n.overlay{\r\n  position: absolute;\r\n  width: 100%;\r\n  height: 100%;\r\n  top: 0;\r\n  opacity: 0;\r\n}\r\n\r\n    \r\n    ","__globals__":{"background_overlay_color":"globals\/colors?id=accent"}},"elements":[{"id":"342dc42","elType":"widget","settings":{"title":"North America","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":40,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"0","left":"40","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"7eb7dcc","elType":"widget","settings":{"space":{"unit":"px","size":280,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"200316d","elType":"section","settings":{"layout":"full_width","gap":"no","background_overlay_background":"classic","background_overlay_opacity":{"unit":"px","size":0.6999999999999999555910790149937383830547332763671875,"sizes":[]},"css_classes":"overlay","__globals__":{"background_overlay_color":"globals\/colors?id=accent"},"html_tag":"div"},"elements":[{"id":"e115f97","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"5acf413","elType":"widget","settings":{"title":"North America","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":40,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"10","left":"40","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"1c94734","elType":"widget","settings":{"taxonomy_slug":"locations","per_page":"6","column":"1","Typography_typography":"custom","Typography_font_size":{"unit":"px","size":14,"sizes":[]},"title_color":"#FFFFFF","_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"__globals__":{"color_hover":"globals\/colors?id=primary"},"column_tablet":"1"},"elements":[],"widgetType":"babe-taxonomies-list"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"eb1fb26","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_img6.jpg","id":8661,"alt":"","source":"library"},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_overlay_background":"classic","background_overlay_opacity":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"css_classes":"card-container","custom_css":".card-container:hover .overlay{\r\n  opacity: 1;\r\n}\r\n\r\n.overlay{\r\n  position: absolute;\r\n  width: 100%;\r\n  height: 100%;\r\n  top: 0;\r\n  opacity: 0;\r\n}\r\n\r\n    \r\n    ","__globals__":{"background_overlay_color":"globals\/colors?id=accent"}},"elements":[{"id":"ed3d9d8","elType":"widget","settings":{"title":"Africa ","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":40,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"0","left":"40","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"1f62383","elType":"widget","settings":{"space":{"unit":"px","size":280,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"34e0438","elType":"section","settings":{"layout":"full_width","gap":"no","background_overlay_background":"classic","background_overlay_opacity":{"unit":"px","size":0.6999999999999999555910790149937383830547332763671875,"sizes":[]},"css_classes":"overlay","__globals__":{"background_overlay_color":"globals\/colors?id=accent"},"html_tag":"div"},"elements":[{"id":"a60c311","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"631b4fe","elType":"widget","settings":{"title":"Africa ","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":40,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"10","left":"40","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"d8dd043","elType":"widget","settings":{"taxonomy_slug":"locations","per_page":"6","column":"1","Typography_typography":"custom","Typography_font_size":{"unit":"px","size":14,"sizes":[]},"title_color":"#FFFFFF","_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"__globals__":{"color_hover":"globals\/colors?id=primary"},"column_tablet":"1"},"elements":[],"widgetType":"babe-taxonomies-list"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"3b52a11","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_img7.jpg","id":8663,"alt":"","source":"library"},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_overlay_background":"classic","background_overlay_opacity":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"css_classes":"card-container","custom_css":".card-container:hover .overlay{\r\n  opacity: 1;\r\n}\r\n\r\n.overlay{\r\n  position: absolute;\r\n  width: 100%;\r\n  height: 100%;\r\n  top: 0;\r\n  opacity: 0;\r\n}\r\n\r\n    \r\n    ","__globals__":{"background_overlay_color":"globals\/colors?id=accent"}},"elements":[{"id":"96f5098","elType":"widget","settings":{"title":"Middle East","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":40,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"0","left":"40","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"70a839b","elType":"widget","settings":{"space":{"unit":"px","size":280,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"21519b8","elType":"section","settings":{"layout":"full_width","gap":"no","background_overlay_background":"classic","background_overlay_opacity":{"unit":"px","size":0.6999999999999999555910790149937383830547332763671875,"sizes":[]},"css_classes":"overlay","__globals__":{"background_overlay_color":"globals\/colors?id=accent"},"html_tag":"div"},"elements":[{"id":"364216c","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"fcd7b1d","elType":"widget","settings":{"title":"Middle East","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":40,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"10","left":"40","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"caa3840","elType":"widget","settings":{"taxonomy_slug":"locations","per_page":"6","column":"1","Typography_typography":"custom","Typography_font_size":{"unit":"px","size":14,"sizes":[]},"title_color":"#FFFFFF","_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"__globals__":{"color_hover":"globals\/colors?id=primary"},"column_tablet":"1"},"elements":[],"widgetType":"babe-taxonomies-list"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"1967d8b","elType":"section","settings":{"layout":"full_width","gap":"no","stretch_section":"section-stretched","structure":"20","html_tag":"div"},"elements":[{"id":"18365eb","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_img8.jpg","id":8664,"alt":"","source":"library"},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_overlay_background":"classic","background_overlay_opacity":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"css_classes":"card-container","custom_css":".card-container:hover .overlay{\r\n  opacity: 1;\r\n}\r\n\r\n.overlay{\r\n  position: absolute;\r\n  width: 100%;\r\n  height: 100%;\r\n  top: 0;\r\n  opacity: 0;\r\n}\r\n\r\n    \r\n    ","__globals__":{"background_overlay_color":"globals\/colors?id=accent"}},"elements":[{"id":"b033ff6","elType":"widget","settings":{"title":"Balkans","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":40,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"0","left":"40","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"7dbaf9a","elType":"widget","settings":{"space":{"unit":"px","size":280,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"d9238e2","elType":"section","settings":{"layout":"full_width","gap":"no","background_overlay_background":"classic","background_overlay_opacity":{"unit":"px","size":0.6999999999999999555910790149937383830547332763671875,"sizes":[]},"css_classes":"overlay","__globals__":{"background_overlay_color":"globals\/colors?id=accent"},"html_tag":"div"},"elements":[{"id":"9408886","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"7aa1cc6","elType":"widget","settings":{"title":"Balkans","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":40,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"10","left":"40","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"8da05ac","elType":"widget","settings":{"taxonomy_slug":"locations","per_page":"6","column":"1","Typography_typography":"custom","Typography_font_size":{"unit":"px","size":14,"sizes":[]},"title_color":"#FFFFFF","_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"__globals__":{"color_hover":"globals\/colors?id=primary"},"column_tablet":"1"},"elements":[],"widgetType":"babe-taxonomies-list"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"07ed61e","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_img9.jpg","id":8656,"alt":"","source":"library"},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_overlay_background":"classic","background_overlay_opacity":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"css_classes":"card-container","custom_css":".card-container:hover .overlay{\r\n  opacity: 1;\r\n}\r\n\r\n.overlay{\r\n  position: absolute;\r\n  width: 100%;\r\n  height: 100%;\r\n  top: 0;\r\n  opacity: 0;\r\n}\r\n\r\n    \r\n    ","__globals__":{"background_overlay_color":"globals\/colors?id=accent"}},"elements":[{"id":"314ff77","elType":"widget","settings":{"title":"Polar","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":40,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"0","left":"40","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"3361040","elType":"widget","settings":{"space":{"unit":"px","size":280,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"ee0b0bd","elType":"section","settings":{"layout":"full_width","gap":"no","background_overlay_background":"classic","background_overlay_opacity":{"unit":"px","size":0.6999999999999999555910790149937383830547332763671875,"sizes":[]},"css_classes":"overlay","__globals__":{"background_overlay_color":"globals\/colors?id=accent"},"html_tag":"div"},"elements":[{"id":"5e13670","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"f4fe168","elType":"widget","settings":{"title":"Polar","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":40,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"10","left":"40","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"39fe332","elType":"widget","settings":{"taxonomy_slug":"locations","per_page":"6","column":"1","Typography_typography":"custom","Typography_font_size":{"unit":"px","size":14,"sizes":[]},"title_color":"#FFFFFF","_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"__globals__":{"color_hover":"globals\/colors?id=primary"},"column_tablet":"1"},"elements":[],"widgetType":"babe-taxonomies-list"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"8ac1f82","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color":"#F9F4F0","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_deco2.png","id":8582,"alt":"","source":"library"},"background_position":"top right","background_repeat":"no-repeat","padding":{"unit":"px","top":"100","right":"30","bottom":"100","left":"30","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"80","right":"30","bottom":"80","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"15","bottom":"60","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"c1f8df1","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"617fe32","elType":"widget","settings":{"title":"Traveller reviews","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"align":"center","_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"f2e6201","elType":"widget","settings":{"title":"Over 70k happy <br>customers globally","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":54,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"align":"center","typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"1fca1bb","elType":"widget","settings":{"testimonials":[{"_id":"0fb5e55","testimonial_content":"\u201cSix days of cycling on and off road, tough but super enjoyable and interesting. Lucky to have a great group and tour guide, Alfonso.\u201d","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-5-2.jpg","id":2731,"alt":"","source":"library"},"testimonial_name":"Catherine Bannatyne","testimonial_job":"New York, USA"},{"testimonial_content":"\u201cMy first visit to Croatia and I wasn\u2019t disappointed. The coastline are beautiful, lovely blue clear waters and great weather.\u201d","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-4-2.jpg","id":2730,"alt":"","source":"library"},"testimonial_name":"Sean Pearson","testimonial_job":"Cycle the Baltics ","_id":"1680f97"},{"testimonial_content":"\u201cWe had an absolutely amazing trip and I can\'t wait to come back! Everyone was helpful and patiently answered all of my questions.\u201d","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-3-2.jpg","id":2729,"alt":"","source":"library"},"testimonial_name":"Amy Woods","testimonial_job":"United States","_id":"dbabb12"}],"column":"3","enable_carousel":"yes","layout_style":"4","padding_estimonial_wrapper":{"unit":"px","top":"50","right":"50","bottom":"50","left":"50","isLinked":true},"color_testimonial_wrapper":"#FFFFFF","wrapper_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"content_typography_typography":"custom","content_typography_font_size":{"unit":"px","size":20,"sizes":[]},"content_typography_font_weight":"500","content_typography_line_height":{"unit":"px","size":28,"sizes":[]},"content_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"content_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"name_typography_typography":"custom","name_typography_font_size":{"unit":"px","size":16,"sizes":[]},"name_typography_font_weight":"700","name_typography_line_height":{"unit":"px","size":26,"sizes":[]},"name_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"name_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"job_typography_typography":"custom","job_typography_font_weight":"500","_padding":{"unit":"px","top":"0","right":"0","bottom":"35","left":"0","isLinked":false},"column_tablet":"2","column_mobile":"1","padding_estimonial_wrapper_mobile":{"unit":"px","top":"30","right":"30","bottom":"30","left":"30","isLinked":true},"navigation":"none"},"elements":[],"widgetType":"triply-testimonials"},{"id":"b3aa616","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_deco3.png","id":8866,"alt":"","source":"library"},"_padding":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"f461a18","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_deco4.png","id":8865,"alt":"","source":"library"},"_padding":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"00a82d3","elType":"widget","settings":{"editor":"<p>1000+ reviews on TripAdvisor. Certificate of Excellence<\/p>","align":"center"},"elements":[],"widgetType":"text-editor"},{"id":"76d100c","elType":"widget","settings":{"text":"see all reviews","align":"center","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"typography_font_weight":"700","background_color":"#02010100","text_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"__globals__":{"button_text_color":"globals\/colors?id=secondary","button_icon_color":"globals\/colors?id=primary","hover_color":"globals\/colors?id=primary"}},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false},{"id":"47d4e88","elType":"section","settings":{"gap":"no","html_tag":"div"},"elements":[{"id":"1d6ecee","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"3ba339b","elType":"widget","settings":{"title":"Types of tours","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"align":"center","_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"fa0a456","elType":"widget","settings":{"title":"Adventure your way","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":54,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"align":"center","typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"}],"isInner":false}],"isInner":false},{"id":"b25968f","elType":"section","settings":{"gap":"no","structure":"30","margin":{"unit":"px","top":"0","right":0,"bottom":"40","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"373b24a","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"10","left":"0","isLinked":false}},"elements":[{"id":"f337e8d","elType":"section","settings":{"layout":"full_width","gap":"no","height_inner":"min-height","custom_height_inner":{"unit":"px","size":240,"sizes":[]},"content_position":"middle","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_img10.jpg","id":8926,"alt":"","source":"library"},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_overlay_background":"classic","background_overlay_opacity":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"margin":{"unit":"px","top":"0","right":0,"bottom":"10","left":0,"isLinked":false},"__globals__":{"background_overlay_color":"globals\/colors?id=accent"},"html_tag":"div"},"elements":[{"id":"631bb7d","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"ab69180","elType":"widget","settings":{"title_text":"City Tours","description_text":"","selected_icon":{"value":"triply-icon- triply-icon-citytours","library":"triply-icon"},"view":"stacked","primary_color":"#FFFFFF","secondary_color":"#dc834e","icon_space":{"unit":"px","size":10,"sizes":[]},"icon_size":{"unit":"px","size":47,"sizes":[]},"icon_padding":{"unit":"px","size":16,"sizes":[]},"title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_color":"#FFFFFF","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":28,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_background_background":"classic","_background_color":"#02010100","__globals__":{"secondary_color":"globals\/colors?id=primary","hover_secondary_color":"","hover_primary_color":""}},"elements":[],"widgetType":"icon-box"}],"isInner":true}],"isInner":true},{"id":"5be2a1b","elType":"widget","settings":{"ids":[],"per_page":"3","column":"1","style":"6","column_tablet":"1"},"elements":[],"widgetType":"babe-all-items"}],"isInner":false},{"id":"f1460cd","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"_inline_size_tablet":50,"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[{"id":"3179341","elType":"section","settings":{"layout":"full_width","gap":"no","height_inner":"min-height","custom_height_inner":{"unit":"px","size":240,"sizes":[]},"content_position":"middle","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_img11.jpg","id":8927,"alt":"","source":"library"},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_overlay_background":"classic","background_overlay_opacity":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"margin":{"unit":"px","top":"0","right":0,"bottom":"10","left":0,"isLinked":false},"__globals__":{"background_overlay_color":"globals\/colors?id=accent"},"html_tag":"div"},"elements":[{"id":"9655dea","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"a490560","elType":"widget","settings":{"title_text":"Beaches","description_text":"","selected_icon":{"value":"triply-icon- triply-icon-beaches","library":"triply-icon"},"view":"stacked","primary_color":"#FFFFFF","secondary_color":"#dc834e","icon_space":{"unit":"px","size":10,"sizes":[]},"icon_size":{"unit":"px","size":47,"sizes":[]},"icon_padding":{"unit":"px","size":16,"sizes":[]},"title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_color":"#FFFFFF","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":28,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_background_background":"classic","_background_color":"#02010100","__globals__":{"secondary_color":"globals\/colors?id=primary","hover_secondary_color":"","hover_primary_color":""}},"elements":[],"widgetType":"icon-box"}],"isInner":true}],"isInner":true},{"id":"398bb4f","elType":"widget","settings":{"per_page":"3","sort":"price_from","column":"1","style":"6","column_tablet":"1"},"elements":[],"widgetType":"babe-all-items"}],"isInner":false},{"id":"fe07a3b","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"_inline_size_tablet":50,"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true}},"elements":[{"id":"56e6e55","elType":"section","settings":{"layout":"full_width","gap":"no","height_inner":"min-height","custom_height_inner":{"unit":"px","size":240,"sizes":[]},"content_position":"middle","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_img12.jpg","id":8925,"alt":"","source":"library"},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_overlay_background":"classic","background_overlay_opacity":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"margin":{"unit":"px","top":"0","right":0,"bottom":"10","left":0,"isLinked":false},"__globals__":{"background_overlay_color":"globals\/colors?id=accent"},"html_tag":"div"},"elements":[{"id":"5a022de","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"0e39ce0","elType":"widget","settings":{"title_text":"Hiking","description_text":"","selected_icon":{"value":"triply-icon- triply-icon-hiking","library":"triply-icon"},"view":"stacked","primary_color":"#FFFFFF","secondary_color":"#dc834e","icon_space":{"unit":"px","size":10,"sizes":[]},"icon_size":{"unit":"px","size":47,"sizes":[]},"icon_padding":{"unit":"px","size":16,"sizes":[]},"title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_color":"#FFFFFF","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":28,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_background_background":"classic","_background_color":"#02010100","__globals__":{"secondary_color":"globals\/colors?id=primary","hover_secondary_color":"","hover_primary_color":""}},"elements":[],"widgetType":"icon-box"}],"isInner":true}],"isInner":true},{"id":"f961e2f","elType":"widget","settings":{"per_page":"3","sortby":"ASC","column":"1","style":"6","column_tablet":"1"},"elements":[],"widgetType":"babe-all-items"}],"isInner":false}],"isInner":false},{"id":"9345a67","elType":"section","settings":{"gap":"no","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"209d9ab","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"6f2c8d3","elType":"widget","settings":{"text":"browse categories","align":"center","size":"md","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"background_color":"#DC834E00","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"border_color":"#202F59","_element_custom_width":{"unit":"px","size":140,"sizes":[]},"__globals__":{"background_color":"","border_color":"globals\/colors?id=secondary","button_text_color":"globals\/colors?id=secondary","button_hover_border_color":"globals\/colors?id=primary","hover_color":"globals\/colors?id=primary","button_icon_color":"globals\/colors?id=primary"},"animation_duration":"fast","__dynamic__":[],"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/tours-list-view\/","is_external":"","nofollow":"","custom_attributes":""}},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false},{"id":"ed1d6c4","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color":"#F9F4F0","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_deco5.png","id":9078,"alt":"","source":"library"},"background_position":"top left","background_repeat":"no-repeat","padding":{"unit":"px","top":"100","right":"30","bottom":"100","left":"30","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"background_overlay_background":"classic","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_deco6.png","id":9077,"alt":"","source":"library"},"background_overlay_position":"bottom right","background_overlay_repeat":"no-repeat","background_overlay_opacity":{"unit":"px","size":"","sizes":[]},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"80","right":"30","bottom":"80","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"15","bottom":"60","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"e7755ba","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"88a6710","elType":"widget","settings":{"title":"Why choose us","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"align":"center","_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"552ace7","elType":"widget","settings":{"title":"Travel with confidence<br> with Triply","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":54,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"align":"center","typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"ccccaa2","elType":"section","settings":{"gap":"no","structure":"40","custom_css":"selector .elementor-image-box-img{\n    position: relative\n}\nselector .elementor-image-box-img:before{\n    content: \"\";\n    width: 100%;\n    height: 100%;\n    transition: all ease 0.3s;\n    position: absolute;\n    margin: auto;\n    z-index: 1;\n    left: 0;\n    top: 0;\n    border-radius: 100%;\n    box-shadow: 0 0 0 30px #f9f4f0;\n}\nselector .elementor-widget-image-box:hover .elementor-image-box-img:before{\n    transform: scale(0.9);\n}","html_tag":"div"},"elements":[{"id":"b75e153","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"_inline_size_tablet":50,"align_mobile":"center","padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"e805513","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_img13.png","id":9106,"alt":"","source":"library"},"title_text":"Flexible bookings","description_text":"Avoid fees and frustration with cancellations up to 56 days before departure on eligible trips and easy deposit transfer.","image_space":{"unit":"px","size":25,"sizes":[]},"image_size":{"unit":"%","size":"","sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":28,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":24,"sizes":[]},"description_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"description_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"0","right":"20","bottom":"0","left":"20","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":400,"sizes":[]}},"elements":[],"widgetType":"image-box"}],"isInner":true},{"id":"8c3815a","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"_inline_size_tablet":50,"align_mobile":"center","padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"b40d251","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_img14.png","id":9107,"alt":"","source":"library"},"title_text":"Safe travels","description_text":"Your health and wellbeing are our number one priority \u2013 we\u2019ve got the latest COVID-19 Health & Safety Guidelines.","image_space":{"unit":"px","size":25,"sizes":[]},"image_size":{"unit":"%","size":"","sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":28,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":24,"sizes":[]},"description_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"description_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"0","right":"20","bottom":"0","left":"20","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":400,"sizes":[]}},"elements":[],"widgetType":"image-box"}],"isInner":true},{"id":"fdcf6b4","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"_inline_size_tablet":50,"align_mobile":"center","padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"e9bb7ff","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_img15.png","id":9108,"alt":"","source":"library"},"title_text":"The right trip for you","description_text":"Whether near or far from home, your trip will be local led and full of unforgettable experiences, with everything taken care of.","image_space":{"unit":"px","size":25,"sizes":[]},"image_size":{"unit":"%","size":"","sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":28,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":24,"sizes":[]},"description_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"description_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"0","right":"20","bottom":"0","left":"20","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":400,"sizes":[]}},"elements":[],"widgetType":"image-box"}],"isInner":true},{"id":"04108d7","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"_inline_size_tablet":50,"align_mobile":"center"},"elements":[{"id":"cc1cd38","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h7_img16.png","id":9105,"alt":"","source":"library"},"title_text":"Locally based guides","description_text":"Our Chief Experience Officers are all locally based, meaning they know the area you\u2019re exploring.","image_space":{"unit":"px","size":25,"sizes":[]},"image_size":{"unit":"%","size":"","sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":28,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":24,"sizes":[]},"description_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"description_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"0","right":"20","bottom":"0","left":"20","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":400,"sizes":[]}},"elements":[],"widgetType":"image-box"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"94413b4","elType":"section","settings":{"gap":"no","margin":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"40","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"20","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"638fa4a","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"fb080a9","elType":"widget","settings":{"title":"Recent post","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"align":"center","_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"37658f8","elType":"widget","settings":{"title":"Latest Travel Guides","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":54,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"align":"center","typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"63f91ba","elType":"widget","settings":{"posts_per_page":5,"post_style":"post-style-2","pagination_page_limit":"5","pagination_prev_label":"&laquo; Previous","pagination_next_label":"Next &raquo;","enable_carousel":"yes","navigation":"none","column_tablet":"2","column_mobile":"1"},"elements":[],"widgetType":"triply-post-grid"}],"isInner":false}],"isInner":false}],"home-6":[{"id":"eec7d8c","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"280","left":"30","isLinked":false},"background_background":"classic","background_color":"#F9F4F0","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h6_banner.png","id":9033,"alt":"","source":"library"},"background_position":"bottom center","background_repeat":"no-repeat","background_size":"auto","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":5,"sizes":[]},"padding_mobile":{"unit":"px","top":"100","right":"15","bottom":"220","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"height":"min-height","custom_height":{"unit":"px","size":700,"sizes":[]},"custom_height_tablet":{"unit":"px","size":700,"sizes":[]},"custom_height_mobile":{"unit":"px","size":500,"sizes":[]},"html_tag":"div"},"elements":[{"id":"6526ed4","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"align":"center"},"elements":[{"id":"14c36f3","elType":"widget","settings":{"title":"Tours and Trip packages, Globally","header_size":"h1","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_font_weight":"700","typography_line_height":{"unit":"px","size":62,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"em","size":1,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":710,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":42,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"f0288f3","elType":"widget","settings":{"title":"Search, compare and book 15,000+ multiday tours all over the world.","header_size":"h6","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":28,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"title_color":"globals\/colors?id=text"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"8a58048","elType":"widget","settings":{"destinations_title":"Destinations","destinations_subtitle":"Where are you going?","activity_title":"Activity","activity_subtitle":"All Activity","date_title":"When","guests_title":"Guests","search_title":"Search","taxonomy_search":[{"_id":"667a46b","taxonomy_slug":"locations","taxonomy_title":"Destinations","taxonomy_subtitle":"Where are you going?","taxonomy_icon":{"value":"triply-icon- triply-icon-map-marker-rounded","library":"triply-icon"}},{"_id":"202a807","taxonomy_slug":"types","taxonomy_title":"Activity","taxonomy_subtitle":"All Activity","taxonomy_icon":{"value":"triply-icon- triply-icon-activity","library":"triply-icon"}}],"search":"","search_icon":{"value":"triply-icon- triply-icon-search","library":"triply-icon"},"sort":"price"},"elements":[],"widgetType":"babe-search-form"}],"isInner":false}],"isInner":false},{"id":"da544fb","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"60","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"40aa242","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"border_border":"solid","border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"border_color":"globals\/colors?id=border"},"padding":{"unit":"px","top":"0","right":"0","bottom":"60","left":"0","isLinked":false}},"elements":[{"id":"00af917","elType":"widget","settings":{"title":"Trusted by all the largest travel brands","header_size":"h5","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":34,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"em","size":1,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"35","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"03e5f39","elType":"widget","settings":{"carousel":[{"id":8560,"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_brand5.jpg"},{"id":8561,"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_brand4.jpg"},{"id":8562,"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_brand3.jpg"},{"id":8563,"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_brand2.jpg"},{"id":8564,"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_brand1.jpg"},{"id":8565,"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h8_brand.jpg"}],"navigation":"arrows","thumbnail_size":"full","slides_to_show":"6","arrows_position":"outside","__globals__":{"arrows_color":"globals\/colors?id=border"},"slides_to_show_tablet":"3","slides_to_show_mobile":"2","image_spacing_custom":{"unit":"px","size":"","sizes":[]},"gallery_vertical_align":"center","custom_css":"selector .elementor-swiper-button-prev{\n    left: -30px;\n}\nselector .elementor-swiper-button-next{\n    right: -30px;\n}"},"elements":[],"widgetType":"image-carousel"}],"isInner":false}],"isInner":false},{"id":"8b2c354","elType":"section","settings":{"content_width":{"unit":"px","size":1320,"sizes":[]},"gap":"no","stretch_section":"section-stretched","structure":"40","margin":{"unit":"px","top":"50","right":0,"bottom":"100","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"margin_mobile":{"unit":"px","top":"60","right":0,"bottom":"60","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"7a9cca8","elType":"column","settings":{"_column_size":25,"_inline_size":null,"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50},"elements":[{"id":"327e579","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/medal-star.svg","id":7882},"library":"svg"},"title_text":"25 Years of Excellence ","description_text":"Deliver the\nmost convenient and efficient\nof travel services.","position":"left","title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_typography_line_height":{"unit":"px","size":26,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":24,"sizes":[]},"description_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"description_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"primary_color":"","title_color":"globals\/colors?id=accent"},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"0353516","elType":"column","settings":{"_column_size":25,"_inline_size":null,"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50},"elements":[{"id":"852973d","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/24-support.svg","id":7880},"library":"svg"},"title_text":"24\/7 Customer Support","description_text":"Our skilled travel\nagents ready to\nassist you any time of the day.","position":"left","title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_typography_line_height":{"unit":"px","size":26,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":24,"sizes":[]},"description_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"description_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"primary_color":"","title_color":"globals\/colors?id=accent"},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"959a51a","elType":"column","settings":{"_column_size":25,"_inline_size":null,"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50},"elements":[{"id":"5055d2a","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/global-search.svg","id":7881},"library":"svg"},"title_text":"117+ Locations","description_text":"Pproviding you the most\nefficient and\nreliable services.","position":"left","title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_typography_line_height":{"unit":"px","size":26,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":24,"sizes":[]},"description_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"description_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"primary_color":"","title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"a92ac77","elType":"column","settings":{"_column_size":25,"_inline_size":null,"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50},"elements":[{"id":"c036b66","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/verify.svg","id":7883},"library":"svg"},"title_text":"Exclusive Promo Deals","description_text":"Best deals on tour\npackages, and\nother travel services.","position":"left","title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_typography_line_height":{"unit":"px","size":26,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":24,"sizes":[]},"description_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"description_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"primary_color":"","title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"icon-box"}],"isInner":false}],"isInner":false},{"id":"49d199a","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"8453e79","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"52b2223","elType":"widget","settings":{"title":"Top Destinations","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":54,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"em","size":1,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"7","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":36,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"0bdc674","elType":"widget","settings":{"editor":"<p>Our top destinations. See them by continent.<\/p>","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"f211dce","elType":"widget","settings":{"taxonomy_slug":"locations","locations_ids":[],"per_page":"5","column":"4","enable_carousel":"yes","navigation":"arrows","visibility":"","column_tablet":"3","column_mobile":"1","next_horizontal":"right","next_horizontal_value":{"unit":"%","size":1,"sizes":[]},"next_horizontal_value_mobile":{"unit":"px","size":0,"sizes":[]},"prev_horizontal":"left","prev_horizontal_value":{"unit":"%","size":89,"sizes":[]},"prev_horizontal_value_mobile":{"unit":"px","size":0,"sizes":[]},"enable_all_taxonomy":"yes","_margin_mobile":{"unit":"px","top":"10","right":"0","bottom":"0","left":"0","isLinked":false},"item_height":{"unit":"px","size":400,"sizes":[]},"next_vertical":"top","next_vertical_value":{"unit":"%","size":-20,"sizes":[]},"next_horizontal_value_tablet":{"unit":"%","size":"","sizes":[]},"prev_vertical":"top","prev_vertical_value":{"unit":"%","size":-20,"sizes":[]},"prev_horizontal_value_tablet":{"unit":"%","size":85,"sizes":[]},"next_vertical_value_mobile":{"unit":"%","size":50,"sizes":[]},"prev_vertical_value_mobile":{"unit":"%","size":50,"sizes":[]},"style_layout_carousel":"2","autoplay":"","orderby":"count"},"elements":[],"widgetType":"babe-taxonomies"}],"isInner":false}],"isInner":false},{"id":"dfae92b","elType":"section","settings":{"gap":"no","background_background":"classic","background_color":"#F9F4F0","background_overlay_background":"classic","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h6_decor.png","id":8021,"alt":"","source":"library"},"background_overlay_position":"top left","background_overlay_repeat":"no-repeat","background_overlay_size":"auto","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"structure":"20","margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"c882dac","elType":"column","settings":{"_column_size":50,"_inline_size":42,"_inline_size_tablet":100,"space_between_widgets":0,"padding":{"unit":"px","top":"70","right":"0","bottom":"80","left":"80","isLinked":false},"padding_tablet":{"unit":"px","top":"70","right":"30","bottom":"70","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"15","bottom":"30","left":"15","isLinked":false}},"elements":[{"id":"6512569","elType":"widget","settings":{"title":"We make world<br>travel easy","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":54,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"em","size":1,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_font_size_mobile":{"unit":"px","size":36,"sizes":[]},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"5f76d69","elType":"widget","settings":{"editor":"<div>Traveling under your own power and at your own pace, you\'ll connect more meaningfully with your destination and have more fun!<\/div>","_margin":{"unit":"px","top":"0","right":"0","bottom":"25","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":1119},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"5a34605","elType":"widget","settings":{"icon_list":[{"text":"Giving you a Best Price Guarantee.","selected_icon":{"value":"triply-icon- triply-icon-tick-circle","library":"triply-icon"},"_id":"f1537be"},{"text":"Tours delivered by qualified and licensed operators.","selected_icon":{"value":"triply-icon- triply-icon-tick-circle","library":"triply-icon"},"_id":"57de2a4"},{"text":"Supported by genuine customer reviews.","selected_icon":{"value":"triply-icon- triply-icon-tick-circle","library":"triply-icon"},"_id":"cd0274d"},{"text":"Connecting you directly with a local travel expert.","selected_icon":{"value":"triply-icon- triply-icon-tick-circle","library":"triply-icon"},"_id":"1587a90"}],"space_between":{"unit":"px","size":12,"sizes":[]},"icon_size":{"unit":"px","size":24,"sizes":[]},"text_indent":{"unit":"px","size":10,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_font_weight":"500","icon_typography_line_height":{"unit":"px","size":"","sizes":[]},"icon_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"icon_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=accent"},"icon_align_mobile":"left"},"elements":[],"widgetType":"icon-list"},{"id":"aebf906","elType":"widget","settings":{"text":"explore our tours","selected_icon":{"value":"triply-icon- triply-icon-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"button"}],"isInner":false},{"id":"b4ff377","elType":"column","settings":{"_column_size":50,"_inline_size":58,"_inline_size_tablet":50,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"","id":"","alt":"","source":"library"},"background_position":"center center","background_repeat":"no-repeat","hide_mobile":"hidden-mobile","hide_tablet":"hidden-tablet"},"elements":[{"id":"aa44c7d","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h6_about_pic.png","id":8072,"alt":"","source":"library"},"image_size":"full","align":"center","width_tablet":{"unit":"px","size":"","sizes":[]},"width_mobile":{"unit":"px","size":"","sizes":[]},"height":{"unit":"px","size":580,"sizes":[]},"image_border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"_offset_x":{"size":0,"unit":"%"},"_offset_x_tablet":{"size":-13.1089999999999999857891452847979962825775146484375,"unit":"%"},"_offset_x_mobile":{"unit":"%","size":"","sizes":[]},"_offset_y":{"size":0,"unit":"%"},"_offset_y_tablet":{"size":3.459000000000000074606987254810519516468048095703125,"unit":"%"},"_offset_y_mobile":{"unit":"%","size":"","sizes":[]}},"elements":[],"widgetType":"image"},{"id":"316927b","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h6_icons.png","id":8079,"alt":"","source":"library"},"image_size":"full","align":"center","_position":"absolute","_offset_x":{"size":8,"unit":"%"},"_offset_y":{"size":8,"unit":"%"},"_offset_x_tablet":{"size":4,"unit":"%"},"_offset_x_mobile":{"unit":"%","size":"","sizes":[]},"_offset_y_tablet":{"size":10,"unit":"%"},"_offset_y_mobile":{"unit":"%","size":"","sizes":[]}},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"53f5f36","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"c4fb2be","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"fa36a08","elType":"widget","settings":{"title":"Featured Trips","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":54,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"em","size":1,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"7","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":36,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"de878c0","elType":"widget","settings":{"editor":"The best tours and trip deals, globally.","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"d70a383","elType":"widget","settings":{"per_page":"6","column":"2","style":"7","column_tablet":"2","custom_css":"@media (max-width: 1024px){\n    selector .item_img{\nwidth: 100%;       \n}\n}"},"elements":[],"widgetType":"babe-all-items"}],"isInner":false}],"isInner":false},{"id":"009ec00","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h6_para_bg.jpg","id":8931,"alt":"","source":"library"},"background_repeat":"no-repeat","background_overlay_background":"classic","padding":{"unit":"px","top":"100","right":"30","bottom":"215","left":"30","isLinked":false},"__globals__":{"background_overlay_color":"globals\/colors?id=accent"},"background_motion_fx_motion_fx_scrolling":"yes","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":10,"sizes":[]},"background_size":"cover","background_position":"top center","padding_mobile":{"unit":"px","top":"100","right":"15","bottom":"210","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"e8309c2","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"463e85d","elType":"widget","settings":{"title":"Simply the best and most<br>relevant way to travel","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":54,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"em","size":1,"sizes":[]},"align_mobile":"center","_margin":{"unit":"px","top":"0","right":"0","bottom":"45","left":"0","isLinked":false},"typography_font_size_mobile":{"unit":"px","size":36,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":""}},"elements":[],"widgetType":"heading"},{"id":"1045ff8","elType":"section","settings":{"layout":"full_width","gap":"no","structure":"50","html_tag":"div"},"elements":[{"id":"a234929","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_tablet":35,"content_position":"center","align_mobile":"center","space_between_widgets":0,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[{"id":"9efc172","elType":"widget","settings":{"ending_number":2154,"suffix":"<sup>+<\/sup>","thousand_separator":"","title":"","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":60,"sizes":[]},"typography_number_line_height":{"unit":"px","size":54,"sizes":[]},"typography_number_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_number_line_height_mobile":{"unit":"px","size":"","sizes":[]},"title_color":"#FFFFFF","_element_width":"auto","_element_width_tablet":"auto","typography_number_font_size_tablet":{"unit":"px","size":40,"sizes":[]}},"elements":[],"widgetType":"counter"},{"id":"21d51be","elType":"widget","settings":{"title":"Locations","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_line_height":{"unit":"px","size":28,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"}],"isInner":true},{"id":"dec1dda","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_tablet":65,"content_position":"center","align_mobile":"center","space_between_widgets":0,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[{"id":"479cf5c","elType":"widget","settings":{"ending_number":109,"suffix":"<sup>+<\/sup>","thousand_separator":"","title":"","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":60,"sizes":[]},"typography_number_line_height":{"unit":"px","size":54,"sizes":[]},"typography_number_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_number_line_height_mobile":{"unit":"px","size":"","sizes":[]},"title_color":"#FFFFFF","_element_width":"auto","_element_width_tablet":"auto","typography_number_font_size_tablet":{"unit":"px","size":40,"sizes":[]}},"elements":[],"widgetType":"counter"},{"id":"da26fdf","elType":"widget","settings":{"title":"Countries","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_line_height":{"unit":"px","size":28,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"}],"isInner":true},{"id":"941b691","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_tablet":35,"content_position":"center","align_mobile":"center","space_between_widgets":0,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[{"id":"1d10863","elType":"widget","settings":{"ending_number":720,"suffix":"<sup>+<\/sup>","thousand_separator":"","title":"","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":60,"sizes":[]},"typography_number_line_height":{"unit":"px","size":54,"sizes":[]},"typography_number_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_number_line_height_mobile":{"unit":"px","size":"","sizes":[]},"title_color":"#FFFFFF","_element_width":"auto","_element_width_tablet":"auto","typography_number_font_size_tablet":{"unit":"px","size":40,"sizes":[]}},"elements":[],"widgetType":"counter"},{"id":"bc108b6","elType":"widget","settings":{"title":"Guides","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_line_height":{"unit":"px","size":28,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"}],"isInner":true},{"id":"af2bfcc","elType":"column","settings":{"_column_size":20,"_inline_size":25,"_inline_size_tablet":40,"content_position":"center","align_mobile":"center","space_between_widgets":0,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"80","left":"0","isLinked":false}},"elements":[{"id":"cf5f5db","elType":"widget","settings":{"ending_number":25214,"suffix":"<sup>+<\/sup>","title":"","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":60,"sizes":[]},"typography_number_line_height":{"unit":"px","size":54,"sizes":[]},"typography_number_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_number_line_height_mobile":{"unit":"px","size":"","sizes":[]},"title_color":"#FFFFFF","_element_width":"auto","_element_width_tablet":"auto","typography_number_font_size_tablet":{"unit":"px","size":40,"sizes":[]}},"elements":[],"widgetType":"counter"},{"id":"6587a65","elType":"widget","settings":{"title":"Reviews","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_line_height":{"unit":"px","size":28,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"}],"isInner":true},{"id":"210c4af","elType":"column","settings":{"_column_size":20,"_inline_size":15,"_inline_size_tablet":25,"content_position":"center","align":"center","space_between_widgets":0},"elements":[{"id":"ca340fb","elType":"widget","settings":{"title":"average rating","align":"center","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_font_weight":"700","typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":28,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_z_index":2},"elements":[],"widgetType":"heading"},{"id":"90d9a43","elType":"widget","settings":{"title":"4.8","align":"center","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_line_height":{"unit":"px","size":54,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_z_index":2},"elements":[],"widgetType":"heading"},{"id":"16fb97d","elType":"widget","settings":{"star_style":"star_unicode","align":"center","icon_size":{"unit":"px","size":20,"sizes":[]},"stars_color":"#FFFFFF","_z_index":2},"elements":[],"widgetType":"star-rating"},{"id":"c0c479b","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h6_circle.png","id":9650,"alt":"","source":"library"},"image_size":"full","align":"center","_position":"absolute","_offset_x":{"size":0,"unit":"%"},"_offset_x_tablet":{"size":0,"unit":"%"},"_offset_x_mobile":{"size":0,"unit":"%"},"_offset_y":{"size":-40,"unit":"%"},"_offset_y_tablet":{"size":-35,"unit":"%"},"_offset_y_mobile":{"size":-35,"unit":"%"}},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"3d935ef","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"-150","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"-100","right":0,"bottom":"0","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"14f311b","elType":"column","settings":{"_column_size":100,"_inline_size":null,"content_position":"center","align":"center","space_between_widgets":0,"background_background":"classic","background_color":"#F9F4F0","background_overlay_background":"classic","background_overlay_image":{"url":"","id":"","alt":"","source":"library"},"background_overlay_repeat":"no-repeat","background_overlay_size":"auto","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"padding":{"unit":"px","top":"100","right":"0","bottom":"100","left":"0","isLinked":false},"background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h6_decor2.png","id":9861,"alt":"","source":"library"},"background_position":"center center","background_repeat":"no-repeat","background_size":"contain","background_size_tablet":"cover","padding_tablet":{"unit":"px","top":"80","right":"0","bottom":"80","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"0","bottom":"60","left":"0","isLinked":false}},"elements":[{"id":"9f27a32","elType":"widget","settings":{"testimonials":[{"testimonial_content":"\u201cThis was an amazing trip! There were so many highlights... our outstanding, kind, patient, amazing leader Gustavo!! What an absolute saint. He was so organized and insightful!\u201d ","testimonial_name":"Melisa Joan H. - New York, USA","testimonial_job":"","_id":"87f87d2","testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"}},{"testimonial_content":"\"Needless to say we are extremely satisfied with the results. Booking tour was the best investment I ever made. Nice work on your booking tour. Booking tour impressed.\"","testimonial_name":"Roselin D. -  New York, USA","testimonial_job":"","testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"},"_id":"cadac67"},{"testimonial_content":"\"Great job, I will definitely be ordering again! After using booking tour my business skyrocketed! Man, this thing is getting better and better as I learn more about it. \"","testimonial_name":"Cleveland A. -  New York, USA","testimonial_job":"","testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"},"_id":"3d47fe4"}],"column":"1","content_typography_line_height":{"unit":"px","size":35,"sizes":[]},"enable_carousel":"yes","_element_width":"initial","_element_custom_width":{"unit":"px","size":850,"sizes":[]},"content_typography_typography":"custom","content_typography_font_size_tablet":{"unit":"px","size":22,"sizes":[]},"content_typography_line_height_tablet":{"unit":"px","size":30,"sizes":[]},"_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"%","size":68,"sizes":[]},"layout_style":"5","navigation":"both","_element_custom_width_mobile":{"unit":"%","size":80,"sizes":[]},"content_typography_font_size":{"unit":"px","size":30,"sizes":[]},"content_typography_font_weight":"500","column_mobile":"1","content_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"next_vertical":"top","next_vertical_value_mobile":{"unit":"%","size":"","sizes":[]},"next_horizontal":"right","next_horizontal_value_mobile":{"unit":"%","size":"","sizes":[]},"prev_vertical":"top","prev_vertical_value_mobile":{"unit":"%","size":"","sizes":[]},"prev_horizontal":"left","prev_horizontal_value_mobile":{"unit":"%","size":"","sizes":[]},"content_typography_font_size_mobile":{"unit":"px","size":19,"sizes":[]},"next_horizontal_value":{"unit":"%","size":-17,"sizes":[]},"next_horizontal_value_tablet":{"unit":"%","size":"","sizes":[]},"prev_horizontal_value":{"unit":"%","size":-17,"sizes":[]},"prev_horizontal_value_tablet":{"unit":"%","size":"","sizes":[]},"column_tablet":"1"},"elements":[],"widgetType":"triply-testimonials"}],"isInner":false}],"isInner":false},{"id":"e6dfc3d","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin":{"unit":"px","top":"100","right":0,"bottom":"100","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"60","right":0,"bottom":"30","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"1ac9eda","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"8f4048e","elType":"widget","settings":{"title":"Last minute deals","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":54,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"em","size":1,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":30,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"71c1ddc","elType":"widget","settings":{"editor":"<p>Book now and save 10% on worldwide trips.<\/p>","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color":"globals\/colors?id=lighter"},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"33d0279","elType":"widget","settings":{"per_page":"5","column":"3","style":"1","column_tablet":"2","enable_carousel":"yes","navigation":"none"},"elements":[],"widgetType":"babe-all-items"}],"isInner":false}],"isInner":false},{"id":"0531bc6","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin_mobile":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"b1d9603","elType":"column","settings":{"_column_size":100,"_inline_size":null,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h6_faq_bg.jpg","id":8938,"alt":"","source":"library"},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_overlay_background":"classic","background_overlay_opacity":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"__globals__":{"background_overlay_color":"globals\/colors?id=accent"},"border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true}},"elements":[{"id":"6736e69","elType":"widget","settings":{"text":"FAQ\u2019s about travelling now","align":"center","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/faq\/","is_external":"","nofollow":"","custom_attributes":""},"typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_text_transform":"none","typography_line_height":{"unit":"px","size":34,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"background_color":"#00000000","text_padding":{"unit":"px","top":"40","right":"30","bottom":"40","left":"30","isLinked":false},"_background_background":"classic","_background_image":{"url":"","id":"","alt":"","source":"library"},"_background_position":"center center","_background_repeat":"no-repeat","_background_size":"cover"},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false},{"id":"263bb8b","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin":{"unit":"px","top":"100","right":0,"bottom":"100","left":0,"isLinked":false},"border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"border_color":"globals\/colors?id=border"},"margin_mobile":{"unit":"px","top":"60","right":0,"bottom":"30","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"c773637","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"00df0dc","elType":"widget","settings":{"title":"Latest Travel Guides","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":54,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"em","size":1,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":30,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"2798e41","elType":"widget","settings":{"editor":"<p>View our travel guides giving you travel insights, ideas, and tips across the world.<\/p>","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"45","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"6bdeb73","elType":"widget","settings":{"posts_per_page":4,"column":"1","post_style_special_yes":"yes","pagination_page_limit":"5","pagination_prev_label":"&laquo; Previous","pagination_next_label":"Next &raquo;"},"elements":[],"widgetType":"triply-post-grid"}],"isInner":false}],"isInner":false}],"home-5":[{"id":"dc2ac83","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":780,"sizes":[]},"stretch_section":"section-stretched","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h5_bg-4.jpg","id":9437,"alt":"","source":"library"},"background_position":"center center","background_size":"cover","background_overlay_background":"classic","background_overlay_color":"#000000","background_overlay_opacity":{"unit":"px","size":0.299999999999999988897769753748434595763683319091796875,"sizes":[]},"padding":{"unit":"px","top":"170","right":"30","bottom":"0","left":"30","isLinked":false},"background_motion_fx_translateY_direction":"negative","background_motion_fx_translateY_speed":{"unit":"px","size":5,"sizes":[]},"html_tag":"div"},"elements":[{"id":"160d785","elType":"column","settings":{"_column_size":100,"_inline_size":null,"content_position":"center","align":"center"},"elements":[{"id":"7b7daaf","elType":"widget","settings":{"title":"Unforgettable","header_size":"h1","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":120,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":80,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":45,"sizes":[]},"typography_line_height":{"unit":"em","size":1.0800000000000000710542735760100185871124267578125,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":-3,"sizes":[]},"typography_letter_spacing_tablet":{"unit":"px","size":-2,"sizes":[]},"typography_letter_spacing_mobile":{"unit":"px","size":-1,"sizes":[]},"motion_fx_motion_fx_scrolling":"yes","motion_fx_translateX_effect":"yes","motion_fx_translateX_speed":{"unit":"px","size":2,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-60","isLinked":false},"motion_fx_translateX_direction":"negative"},"elements":[],"widgetType":"heading"},{"id":"97ee116","elType":"widget","settings":{"title":"travel","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":48,"sizes":[]},"typography_font_weight":"400","_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-100","isLinked":false},"_element_width":"auto","_element_vertical_align":"center","motion_fx_motion_fx_scrolling":"yes","motion_fx_translateX_effect":"yes","motion_fx_translateX_direction":"negative","motion_fx_translateX_speed":{"unit":"px","size":2,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"fa87de3","elType":"widget","settings":{"title":"Experiences ","header_size":"h1","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":120,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":80,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":45,"sizes":[]},"typography_line_height":{"unit":"em","size":1.0800000000000000710542735760100185871124267578125,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":-3,"sizes":[]},"typography_letter_spacing_tablet":{"unit":"px","size":-2,"sizes":[]},"typography_letter_spacing_mobile":{"unit":"px","size":-1,"sizes":[]},"_element_width":"auto","_element_vertical_align":"center","motion_fx_motion_fx_scrolling":"yes","motion_fx_translateX_effect":"yes","motion_fx_translateX_speed":{"unit":"px","size":2,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"150","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"2b64a52","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h5_img-1.png","id":7584,"alt":"","source":"library"},"image_size":"full","_margin":{"unit":"px","top":"-170","right":"0","bottom":"0","left":"0","isLinked":false},"_element_width":"auto","motion_fx_motion_fx_scrolling":"yes","motion_fx_translateY_effect":"yes","motion_fx_translateY_direction":"negative","motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"motion_fx_devices":["desktop","tablet"]},"elements":[],"widgetType":"image"},{"id":"d3b9067","elType":"widget","settings":{"skin":"cover","bg_image":{"url":"","id":""},"title":"Find amazing things to do. ","description":"Anytime, anywhere.","button":"Explore our tours &nbsp; <i class=\"triply-icon-long-arrow-right\"><\/i>","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"min-height":{"unit":"px","size":0,"sizes":[]},"alignment":"left","padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_spacing":{"unit":"px","size":0,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":20,"sizes":[]},"description_typography_font_weight":"700","button_border_width":{"unit":"px","size":0,"sizes":[]},"content_animation":"","_element_width":"initial","_element_custom_width":{"unit":"px","size":310,"sizes":[]},"_position":"absolute","_offset_orientation_h":"end","_offset_x_end":{"unit":"px","size":60,"sizes":[]},"_offset_y":{"unit":"px","size":"","sizes":[]},"__globals__":{"button_background_color":"globals\/colors?id=primary","button_hover_background_color":"globals\/colors?id=primary_hover"},"overlay_color_hover":"#02010100"},"elements":[],"widgetType":"call-to-action"}],"isInner":false}],"isInner":false},{"id":"469357b","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","padding":{"unit":"px","top":"80","right":"30","bottom":"50","left":"30","isLinked":false},"background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h5_deco-1.png","id":8036,"alt":"","source":"library"},"background_position":"top right","background_repeat":"no-repeat","background_overlay_background":"classic","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h5_deco-2.png","id":8037,"alt":"","source":"library"},"background_overlay_position":"initial","background_overlay_ypos":{"unit":"%","size":70,"sizes":[]},"background_overlay_ypos_tablet":{"unit":"%","size":0,"sizes":[]},"background_overlay_ypos_mobile":{"unit":"%","size":0,"sizes":[]},"background_overlay_repeat":"no-repeat","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"margin":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"background_size_mobile":"initial","background_bg_width_mobile":{"unit":"px","size":120,"sizes":[]},"background_overlay_size_tablet":"initial","background_overlay_bg_width_tablet":{"unit":"px","size":0,"sizes":[]},"padding_tablet":{"unit":"px","top":"60","right":"30","bottom":"60","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"40","right":"15","bottom":"40","left":"15","isLinked":false},"__globals__":{"background_color":""},"background_color":"#F9F4F0","background_size_tablet":"initial","background_bg_width_tablet":{"unit":"px","size":120,"sizes":[]},"html_tag":"div"},"elements":[{"id":"ab3c0a8","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"align_mobile":"center"},"elements":[{"id":"6ab726f","elType":"widget","settings":{"editor":"Plan your trip ","__globals__":{"text_color":"globals\/colors?id=primary"},"typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":24,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":22,"sizes":[]},"typography_line_height":{"unit":"em","size":1.1999999999999999555910790149937383830547332763671875,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"3c91eed","elType":"widget","settings":{"title":"Let us plan you a\nperfect Holiday","_element_width":"initial","_element_custom_width":{"unit":"px","size":440,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"em","size":1.0800000000000000710542735760100185871124267578125,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"43be1e4","elType":"widget","settings":{"text":"browse categories","_element_width":"auto","_element_vertical_align":"flex-end","custom_css":"@media (min-width: 768px){\nselector{\n    margin-left: auto;\n}}\n","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","background_color":"#02010100","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"__globals__":{"button_text_color":"globals\/colors?id=secondary","border_color":"globals\/colors?id=secondary","button_icon_color":"globals\/colors?id=primary","button_background_hover_color":"globals\/colors?id=secondary","button_hover_border_color":"","hover_color":"globals\/colors?id=primary"},"button_text_color":"#202F59","button_background_hover_color":"#202F59","border_color":"#202F59","button_icon_color":"#dc834e","align_mobile":"left","_animation":"opal-move-left"},"elements":[],"widgetType":"button"},{"id":"e4dc23a","elType":"widget","settings":{"space":{"unit":"px","size":60,"sizes":[]},"space_tablet":{"unit":"px","size":30,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"87d31e6","elType":"widget","settings":{"style":"3","taxonomy_slug":"types","locations_id":"americas","types_id":"city-tours","count_tour":"yes","enable_text":"yes","custom_text":"From <strong>550$<\/strong>","_margin":{"unit":"px","top":"0","right":"30","bottom":"30","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"%","size":20,"sizes":[]},"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h5_tour1.jpg","id":10136,"alt":"","source":"library"},"_margin_mobile":{"unit":"px","top":"0","right":"15","bottom":"30","left":"0","isLinked":false},"_element_custom_width_tablet":{"unit":"px","size":190,"sizes":[]},"_element_custom_width_mobile":{"unit":"px","size":155,"sizes":[]}},"elements":[],"widgetType":"taxonomy-item"},{"id":"aed6554","elType":"widget","settings":{"style":"3","taxonomy_slug":"types","locations_id":"americas","types_id":"museum-tours","count_tour":"yes","enable_text":"yes","custom_text":"From <strong>450$<\/strong>","_margin":{"unit":"px","top":"0","right":"30","bottom":"30","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"%","size":20,"sizes":[]},"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h5_tour2.jpg","id":10132,"alt":"","source":"library"},"_margin_mobile":{"unit":"px","top":"0","right":"15","bottom":"30","left":"0","isLinked":false},"_element_custom_width_tablet":{"unit":"px","size":190,"sizes":[]},"_element_custom_width_mobile":{"unit":"px","size":155,"sizes":[]}},"elements":[],"widgetType":"taxonomy-item"},{"id":"f22d593","elType":"widget","settings":{"style":"3","taxonomy_slug":"types","locations_id":"americas","types_id":"beaches","count_tour":"yes","enable_text":"yes","custom_text":"From <strong>100$<\/strong>","_margin":{"unit":"px","top":"0","right":"30","bottom":"30","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"%","size":20,"sizes":[]},"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h5_tour3.jpg","id":10135,"alt":"","source":"library"},"_margin_mobile":{"unit":"px","top":"0","right":"15","bottom":"30","left":"0","isLinked":false},"_element_custom_width_tablet":{"unit":"px","size":190,"sizes":[]},"_element_custom_width_mobile":{"unit":"px","size":155,"sizes":[]}},"elements":[],"widgetType":"taxonomy-item"},{"id":"342db50","elType":"widget","settings":{"style":"3","taxonomy_slug":"types","locations_id":"americas","types_id":"hiking","count_tour":"yes","enable_text":"yes","custom_text":"From <strong>250$<\/strong>","_margin":{"unit":"px","top":"0","right":"30","bottom":"30","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"%","size":20,"sizes":[]},"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h5_tour4.jpg","id":10134,"alt":"","source":"library"},"_margin_mobile":{"unit":"px","top":"0","right":"15","bottom":"30","left":"0","isLinked":false},"_element_custom_width_tablet":{"unit":"px","size":190,"sizes":[]},"_element_custom_width_mobile":{"unit":"px","size":155,"sizes":[]}},"elements":[],"widgetType":"taxonomy-item"},{"id":"2fc7b6f","elType":"widget","settings":{"style":"3","taxonomy_slug":"types","locations_id":"americas","types_id":"cruises","count_tour":"yes","enable_text":"yes","custom_text":"From <strong>100$<\/strong>","_element_width":"initial","_element_custom_width":{"unit":"%","size":20,"sizes":[]},"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h5_tour5.jpg","id":10133,"alt":"","source":"library"},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_element_custom_width_mobile":{"unit":"px","size":140,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"30","bottom":"30","left":"0","isLinked":false},"_element_custom_width_tablet":{"unit":"px","size":160,"sizes":[]}},"elements":[],"widgetType":"taxonomy-item"}],"isInner":false}],"isInner":false},{"id":"4737cad","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","content_position":"middle","margin":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"fa998a6","elType":"column","settings":{"_column_size":50,"_inline_size":60,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"90","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"bdb1940","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h5_img-2.png","id":8078,"alt":"","source":"library"},"image_size":"full","align":"left","align_tablet":"center","_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-53","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"b072c4a","elType":"widget","settings":{"ending_number":125,"suffix":"<sup>+<\/sup>","title":"Destination","_element_width":"initial","_position":"absolute","_offset_orientation_h":"end","_offset_x_end":{"unit":"px","size":130,"sizes":[]},"_offset_orientation_v":"end","number_color":"#FFFFFF","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":50,"sizes":[]},"typography_number_line_height":{"unit":"px","size":54,"sizes":[]},"typography_number_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_number_line_height_mobile":{"unit":"px","size":"","sizes":[]},"title_color":"#FFFFFF","typography_title_typography":"custom","typography_title_font_size":{"unit":"px","size":18,"sizes":[]},"typography_title_line_height":{"unit":"px","size":26,"sizes":[]},"typography_title_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_title_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"55","right":"44","bottom":"55","left":"44","isLinked":false},"_element_custom_width":{"unit":"px","size":190,"sizes":[]},"_background_background":"classic","_border_radius":{"unit":"px","top":"100","right":"100","bottom":"100","left":"100","isLinked":true},"__globals__":{"_background_color":"globals\/colors?id=primary"},"_offset_x_end_tablet":{"unit":"px","size":0,"sizes":[]},"_offset_y_end":{"unit":"px","size":30,"sizes":[]},"_animation":"opal-scale-up"},"elements":[],"widgetType":"counter"}],"isInner":false},{"id":"1b22e4a","elType":"column","settings":{"_column_size":50,"_inline_size":40,"space_between_widgets":0,"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"d4638dc","elType":"widget","settings":{"editor":"Make it memorable","__globals__":{"text_color":"globals\/colors?id=primary"},"typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":24,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":22,"sizes":[]},"typography_line_height":{"unit":"em","size":1.1999999999999999555910790149937383830547332763671875,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"589c21a","elType":"widget","settings":{"title":"We create the trips you love","_element_width":"initial","_element_custom_width":{"unit":"px","size":440,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"em","size":1.0800000000000000710542735760100185871124267578125,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_element_width_tablet":"inherit"},"elements":[],"widgetType":"heading"},{"id":"810134a","elType":"widget","settings":{"editor":"We take the best of what we\u2019ve learned over our 25 years of experience as luxury travel agents and bring it all together to create bespoke luxury travel experiences.","_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"e4ea980","elType":"widget","settings":{"title_text":"Best Tours","description_text":"A strict screening process ensures that we only offer the best tours and trip packages.","position":"left","title_bottom_space":{"unit":"px","size":5,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":18,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"em","size":1.439999999999999946709294817992486059665679931640625,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"icon_space":{"unit":"px","size":34,"sizes":[]},"icon_size":{"unit":"px","size":64,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_padding":{"unit":"px","top":"35","right":"35","bottom":"35","left":"35","isLinked":true},"_border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"_box_shadow_box_shadow_type":"yes","_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":50,"spread":10,"color":"rgba(0, 0, 0, 0.05)"},"_border_radius_hover":{"unit":"px","top":"10","right":"10","bottom":"10","left":"10","isLinked":true},"_box_shadow_hover_box_shadow_type":"yes","_box_shadow_hover_box_shadow":{"horizontal":0,"vertical":0,"blur":10,"spread":0,"color":"rgba(0, 0, 0, 0.1)"},"selected_icon":{"value":"triply-icon- triply-icon-best-tours","library":"triply-icon"},"icon_space_mobile":{"unit":"px","size":10,"sizes":[]},"content_vertical_alignment":"middle"},"elements":[],"widgetType":"icon-box"},{"id":"bf78911","elType":"widget","settings":{"title_text":"Best Price","description_text":"We guarantee you the best price. Found a lower price? We will match it.","position":"left","title_bottom_space":{"unit":"px","size":5,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":18,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"em","size":1.439999999999999946709294817992486059665679931640625,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"icon_space":{"unit":"px","size":50,"sizes":[]},"icon_size":{"unit":"px","size":42,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_padding":{"unit":"px","top":"35","right":"35","bottom":"35","left":"43.5","isLinked":false},"_border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"_box_shadow_box_shadow_type":"yes","_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":50,"spread":10,"color":"rgba(0, 0, 0, 0.05)"},"_border_radius_hover":{"unit":"px","top":"10","right":"10","bottom":"10","left":"10","isLinked":true},"_box_shadow_hover_box_shadow_type":"yes","_box_shadow_hover_box_shadow":{"horizontal":0,"vertical":0,"blur":10,"spread":0,"color":"rgba(0, 0, 0, 0.1)"},"selected_icon":{"value":"triply-icon- triply-icon-price-1","library":"triply-icon"},"content_vertical_alignment":"middle","icon_space_mobile":{"unit":"px","size":10,"sizes":[]}},"elements":[],"widgetType":"icon-box"},{"id":"496e205","elType":"widget","settings":{"title_text":"Free Cancellation ","description_text":"We understand how important flexibility is right now, just one click and it\'s done!","position":"left","title_bottom_space":{"unit":"px","size":5,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":18,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"em","size":1.439999999999999946709294817992486059665679931640625,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"icon_space":{"unit":"px","size":34,"sizes":[]},"icon_size":{"unit":"px","size":64,"sizes":[]},"_padding":{"unit":"px","top":"35","right":"35","bottom":"35","left":"35","isLinked":true},"_border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"_box_shadow_box_shadow_type":"yes","_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":50,"spread":10,"color":"rgba(0, 0, 0, 0.05)"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_border_radius_hover":{"unit":"px","top":"10","right":"10","bottom":"10","left":"10","isLinked":true},"_box_shadow_hover_box_shadow_type":"yes","_box_shadow_hover_box_shadow":{"horizontal":0,"vertical":0,"blur":10,"spread":0,"color":"rgba(0, 0, 0, 0.1)"},"selected_icon":{"value":"triply-icon- triply-icon-cancellation","library":"triply-icon"},"icon_space_mobile":{"unit":"px","size":10,"sizes":[]},"content_vertical_alignment":"middle"},"elements":[],"widgetType":"icon-box"}],"isInner":false}],"isInner":false},{"id":"e755e60","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"255","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"b03837a","elType":"column","settings":{"_column_size":100,"_inline_size":null,"align":"center","space_between_widgets":0},"elements":[{"id":"633deea","elType":"widget","settings":{"editor":"Make it memorable","__globals__":{"text_color":"globals\/colors?id=primary"},"typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":24,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":22,"sizes":[]},"typography_line_height":{"unit":"em","size":1.1999999999999999555910790149937383830547332763671875,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"align":"center"},"elements":[],"widgetType":"text-editor"},{"id":"70a5652","elType":"widget","settings":{"title":"Featured Trips","_element_custom_width":{"unit":"px","size":440,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"em","size":1.0800000000000000710542735760100185871124267578125,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"align":"center"},"elements":[],"widgetType":"heading"},{"id":"11bab77","elType":"widget","settings":{"per_page":"6","column":"3","style":"1","enable_carousel":"yes","visibility":"","style_layout_carousel":"2"},"elements":[],"widgetType":"babe-all-items"}],"isInner":false}],"isInner":false},{"id":"cb8189b","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color":"#F9F4F0","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h1_deco-3.png","id":8484,"alt":"","source":"library"},"background_position":"top left","background_repeat":"no-repeat","margin":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"50","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"30","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"cd8c9a0","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"70a804d","elType":"section","settings":{"content_width":{"unit":"px","size":1070,"sizes":[]},"gap":"no","height_inner":"min-height","custom_height_inner":{"unit":"px","size":350,"sizes":[]},"content_position":"middle","structure":"20","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h5_bg-2.jpg","id":8555,"alt":"","source":"library"},"background_position":"center center","background_overlay_background":"gradient","background_overlay_color":"#000000","background_overlay_color_b":"#00000000","background_overlay_color_b_stop":{"unit":"%","size":68,"sizes":[]},"background_overlay_gradient_angle":{"unit":"deg","size":90,"sizes":[]},"background_overlay_opacity":{"unit":"px","size":0.8000000000000000444089209850062616169452667236328125,"sizes":[]},"border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"margin":{"unit":"px","top":"-175","right":0,"bottom":"90","left":0,"isLinked":false},"_title":"Inner Section","padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"15","bottom":"60","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"345b48e","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"7366963","elType":"widget","settings":{"editor":"Explore the best of","__globals__":{"text_color":""},"typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":24,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":22,"sizes":[]},"typography_line_height":{"unit":"em","size":1.1999999999999999555910790149937383830547332763671875,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"text_color":"#FFDE2E"},"elements":[],"widgetType":"text-editor"},{"id":"95c212d","elType":"widget","settings":{"title":"Trekking Tour\nwith Experts","_element_width":"initial","_element_custom_width":{"unit":"px","size":440,"sizes":[]},"__globals__":{"title_color":""},"typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"em","size":1.0800000000000000710542735760100185871124267578125,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"title_color":"#FFFFFF"},"elements":[],"widgetType":"heading"}],"isInner":true},{"id":"ef1fc81","elType":"column","settings":{"_column_size":50,"_inline_size":null,"align":"flex-end","space_between_widgets":0,"align_mobile":"flex-start"},"elements":[{"id":"18383c1","elType":"widget","settings":{"bg_image":{"url":"","id":""},"title":"03 to 10 nights ","description":"packages","button":"","min-height":{"unit":"px","size":172,"sizes":[]},"vertical_position":"top","padding":{"unit":"px","top":"48","right":"0","bottom":"0","left":"0","isLinked":false},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":14,"sizes":[]},"title_typography_font_weight":"500","title_typography_text_transform":"uppercase","title_spacing":{"unit":"px","size":0,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":24,"sizes":[]},"description_typography_font_weight":"700","description_typography_text_transform":"uppercase","content_bg_color":"#FFDE2E","_margin":{"unit":"px","top":"0","right":"10","bottom":"-50","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":182,"sizes":[]},"_border_radius":{"unit":"%","top":"50","right":"50","bottom":"50","left":"50","isLinked":true},"_border_radius_tablet":{"unit":"%","top":"","right":"","bottom":"","left":"","isLinked":true},"_border_radius_mobile":{"unit":"%","top":"","right":"","bottom":"","left":"","isLinked":true},"__globals__":{"content_bg_color":"","title_color":"globals\/colors?id=accent","description_color":"globals\/colors?id=accent"},"_animation":"opal-scale-up"},"elements":[],"widgetType":"call-to-action"},{"id":"fcbde6f","elType":"widget","settings":{"text":"start from $450","_element_vertical_align":"flex-end","custom_css":"selector{\n    margin-left: auto;\n}","align":"right","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","_z_index":4,"align_mobile":"left","_animation":"opal-move-up"},"elements":[],"widgetType":"button"}],"isInner":true}],"isInner":true},{"id":"876a6b2","elType":"section","settings":{"gap":"no","structure":"20","html_tag":"div"},"elements":[{"id":"edd8194","elType":"column","settings":{"_column_size":50,"_inline_size":37,"space_between_widgets":0,"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"align_mobile":"center"},"elements":[{"id":"da8b2c1","elType":"widget","settings":{"editor":"Destination","__globals__":{"text_color":"globals\/colors?id=primary"},"typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":24,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":22,"sizes":[]},"typography_line_height":{"unit":"em","size":1.1999999999999999555910790149937383830547332763671875,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"94e7461","elType":"widget","settings":{"title":"Top Attractions","_element_custom_width":{"unit":"px","size":440,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"em","size":1.0800000000000000710542735760100185871124267578125,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"51cd11f","elType":"widget","settings":{"editor":"Book your trip when it is perfectly designed and customized, just for you.","_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"b181f0c","elType":"widget","settings":{"text":"all destination","_element_vertical_align":"flex-end","custom_css":"selector{\n    margin-left: auto;\n}","align":"left","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","_z_index":4,"align_mobile":"center","_animation":"opal-move-right"},"elements":[],"widgetType":"button"}],"isInner":true},{"id":"d2cdd77","elType":"column","settings":{"_column_size":50,"_inline_size":63,"space_between_widgets":0,"custom_css":"selector .elementor-widget-image-box .elementor-image-box-title a:hover{\n    color: var(--primary);\n}","_inline_size_tablet":100},"elements":[{"id":"fd21ee1","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h5_destination-6.jpg","id":8879,"alt":"","source":"library"},"thumbnail_size":"custom","thumbnail_custom_dimension":{"width":"90","height":"90"},"title_text":"Eiffel Tower","description_text":"8 Tours and Activities","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"position":"left","title_size":"h5","image_space":{"unit":"px","size":20,"sizes":[]},"image_size":{"unit":"%","size":35,"sizes":[]},"image_border_radius":{"unit":"px","size":10,"sizes":[]},"content_vertical_alignment":"middle","title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_font_weight":"500","_margin":{"unit":"px","top":"0","right":"30","bottom":"30","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"%","size":50,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent","description_color":"globals\/colors?id=lighter"},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"image_space_mobile":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"image-box"},{"id":"a51714f","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h5_destination-3.jpg","id":8876,"alt":"","source":"library"},"thumbnail_size":"custom","thumbnail_custom_dimension":{"width":"90","height":"90"},"title_text":"Niagara Falls","description_text":"19 Tours and Activities","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"position":"left","title_size":"h5","image_space":{"unit":"px","size":20,"sizes":[]},"image_size":{"unit":"%","size":35,"sizes":[]},"image_border_radius":{"unit":"px","size":10,"sizes":[]},"content_vertical_alignment":"middle","title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_font_weight":"500","_margin":{"unit":"px","top":"0","right":"30","bottom":"30","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"%","size":50,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent","description_color":"globals\/colors?id=lighter"},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"image_space_mobile":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"image-box"},{"id":"ea92517","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h5_destination-1.jpg","id":8874,"alt":"","source":"library"},"thumbnail_size":"custom","thumbnail_custom_dimension":{"width":"90","height":"90"},"title_text":"Colosseum","description_text":"6 Tours and Activities","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"position":"left","title_size":"h5","image_space":{"unit":"px","size":20,"sizes":[]},"image_size":{"unit":"%","size":35,"sizes":[]},"image_border_radius":{"unit":"px","size":10,"sizes":[]},"content_vertical_alignment":"middle","title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_font_weight":"500","_margin":{"unit":"px","top":"0","right":"30","bottom":"30","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"%","size":50,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent","description_color":"globals\/colors?id=lighter"},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"image_space_mobile":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"image-box"},{"id":"9870926","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h5_destination-4.jpg","id":8877,"alt":"","source":"library"},"thumbnail_size":"custom","thumbnail_custom_dimension":{"width":"90","height":"90"},"title_text":"National Park","description_text":"16 Tours and Activities","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"position":"left","title_size":"h5","image_space":{"unit":"px","size":20,"sizes":[]},"image_size":{"unit":"%","size":35,"sizes":[]},"image_border_radius":{"unit":"px","size":10,"sizes":[]},"content_vertical_alignment":"middle","title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_font_weight":"500","_margin":{"unit":"px","top":"0","right":"30","bottom":"30","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"%","size":50,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent","description_color":"globals\/colors?id=lighter"},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"image_space_mobile":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"image-box"},{"id":"c122e03","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h5_destination-2.jpg","id":8875,"alt":"","source":"library"},"thumbnail_size":"custom","thumbnail_custom_dimension":{"width":"90","height":"90"},"title_text":"Statue of Liberty","description_text":"7 Tours and Activities","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"position":"left","title_size":"h5","image_space":{"unit":"px","size":20,"sizes":[]},"image_size":{"unit":"%","size":35,"sizes":[]},"image_border_radius":{"unit":"px","size":10,"sizes":[]},"content_vertical_alignment":"middle","title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_font_weight":"500","_margin":{"unit":"px","top":"0","right":"30","bottom":"30","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"%","size":50,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent","description_color":"globals\/colors?id=lighter"},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"image_space_mobile":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"image-box"},{"id":"325a689","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h5_destination-5.jpg","id":8878,"alt":"","source":"library"},"thumbnail_size":"custom","thumbnail_custom_dimension":{"width":"90","height":"90"},"title_text":"Antelope Canyon","description_text":"18 Tours and Activities","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"position":"left","title_size":"h5","image_space":{"unit":"px","size":20,"sizes":[]},"image_size":{"unit":"%","size":35,"sizes":[]},"image_border_radius":{"unit":"px","size":10,"sizes":[]},"content_vertical_alignment":"middle","title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_font_weight":"500","_margin":{"unit":"px","top":"0","right":"30","bottom":"30","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"%","size":50,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent","description_color":"globals\/colors?id=lighter"},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"image_space_mobile":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"image-box"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"c2174b0","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"e785adf","elType":"column","settings":{"_column_size":100,"_inline_size":null,"align":"center","space_between_widgets":0},"elements":[{"id":"e695ff1","elType":"widget","settings":{"editor":"Hot right now ","__globals__":{"text_color":"globals\/colors?id=primary"},"typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":24,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":22,"sizes":[]},"typography_line_height":{"unit":"em","size":1.1999999999999999555910790149937383830547332763671875,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"align":"center"},"elements":[],"widgetType":"text-editor"},{"id":"0f7ddc1","elType":"widget","settings":{"title":"Top Trending","_element_custom_width":{"unit":"px","size":440,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"em","size":1.0800000000000000710542735760100185871124267578125,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"align":"center"},"elements":[],"widgetType":"heading"},{"id":"2589999","elType":"widget","settings":{"per_page":"8","column":"4","style":"8","enable_carousel":"yes"},"elements":[],"widgetType":"babe-all-items"}],"isInner":false}],"isInner":false},{"id":"6ab4a49","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/h5_bg-3.jpg","id":8973,"alt":"","source":"library"},"background_position":"bottom left","margin":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"padding":{"unit":"px","top":"80","right":"30","bottom":"80","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"15","bottom":"45","left":"15","isLinked":false},"background_repeat":"no-repeat","background_size":"cover","html_tag":"div"},"elements":[{"id":"3832d59","elType":"column","settings":{"_column_size":50,"_inline_size":35,"space_between_widgets":0,"_inline_size_tablet":45},"elements":[{"id":"3ead5a5","elType":"widget","settings":{"editor":"Testimonials","__globals__":{"text_color":"globals\/colors?id=primary"},"typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":24,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":22,"sizes":[]},"typography_line_height":{"unit":"em","size":1.1999999999999999555910790149937383830547332763671875,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"2606abc","elType":"widget","settings":{"title":"What our Travelers are saying","_element_width":"initial","_element_custom_width":{"unit":"px","size":440,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"em","size":1.0800000000000000710542735760100185871124267578125,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"}],"isInner":false},{"id":"49a1d02","elType":"column","settings":{"_column_size":50,"_inline_size":65,"space_between_widgets":0,"_inline_size_tablet":55},"elements":[{"id":"d876159","elType":"widget","settings":{"testimonials":[{"_id":"e5f7744","testimonial_content":"\u201cSix days of cycling on and off road, tough but super enjoyable and interesting. Lucky to have a great group and tour guide, Alfonso.\u201d","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-5-2.jpg","id":2731,"alt":"","source":"library"},"testimonial_name":"Catherine Bannatyne","testimonial_job":"New York, USA"},{"_id":"6de87f8","testimonial_content":"\u201cMy first visit to Croatia and I wasn\u2019t disappointed. The coastline are beautiful, lovely blue clear waters and great weather.\u201d","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-2-2.jpg","id":2728,"alt":"","source":"library"},"testimonial_name":"Sean Pearson","testimonial_job":"Cycle the Baltics "}],"padding_estimonial_wrapper":{"unit":"px","top":"50","right":"50","bottom":"40","left":"50","isLinked":false},"color_testimonial_wrapper":"#FFFFFF","wrapper_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"content_typography_typography":"custom","content_typography_font_size":{"unit":"px","size":20,"sizes":[]},"content_typography_font_weight":"500","content_typography_line_height":{"unit":"px","size":28,"sizes":[]},"content_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"content_typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"layout_style":"4","column_tablet":"1","enable_carousel":"yes","navigation":"none"},"elements":[],"widgetType":"triply-testimonials"}],"isInner":false}],"isInner":false},{"id":"89f9e2d","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"60","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"border_border":"solid","border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"border_color":"globals\/colors?id=border"},"html_tag":"div"},"elements":[{"id":"58cefbf","elType":"column","settings":{"_column_size":100,"_inline_size":null,"align":"center","space_between_widgets":0},"elements":[{"id":"4aeb953","elType":"widget","settings":{"editor":"Recent post","__globals__":{"text_color":"globals\/colors?id=primary"},"typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":24,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":22,"sizes":[]},"typography_line_height":{"unit":"em","size":1.1999999999999999555910790149937383830547332763671875,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"align":"center"},"elements":[],"widgetType":"text-editor"},{"id":"303d024","elType":"widget","settings":{"title":"Latest Travel Guides","_element_custom_width":{"unit":"px","size":440,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"em","size":1.0800000000000000710542735760100185871124267578125,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"align":"center"},"elements":[],"widgetType":"heading"},{"id":"96fc489","elType":"widget","settings":{"posts_per_page":3,"post_style":"post-style-2","pagination_page_limit":"5","pagination_prev_label":"&laquo; Previous","pagination_next_label":"Next &raquo;","enable_carousel":"yes","navigation":"none","column_tablet":"2"},"elements":[],"widgetType":"triply-post-grid"}],"isInner":false}],"isInner":false}],"tour-sidebar-grid-3-column":[{"id":"521a069d","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","margin":{"unit":"px","top":"60","right":0,"bottom":"110","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"60","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"reverse_order_mobile":"reverse-mobile","html_tag":"div"},"elements":[{"id":"6cf91b85","elType":"column","settings":{"_column_size":50,"_inline_size":25,"_inline_size_tablet":30,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"2bdfb9bd","elType":"section","settings":{"layout":"full_width","gap":"no","border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"box_shadow_box_shadow_type":"yes","box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"margin":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"20","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div","margin_tablet":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true}},"elements":[{"id":"6d435a11","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"_element_id":"booking_form_mobile"},"elements":[{"id":"5fe989a1","elType":"widget","settings":{"title":"Search Tours","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_font_weight":"700","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"30","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"heading"},{"id":"31c0881d","elType":"widget","settings":{"style_arrow":"style-2","taxonomy_search":[{"_id":"7a1b0dc","taxonomy_slug":"locations","taxonomy_title":"Title Item","taxonomy_subtitle":"Booking Locations","taxonomy_icon":{"value":"triply-icon- triply-icon-map-marker-alt","library":"triply-icon"}},{"taxonomy_slug":"types","taxonomy_title":"Title Item","taxonomy_subtitle":"Booking Types","taxonomy_icon":{"value":"triply-icon- triply-icon-fan","library":"triply-icon"},"_id":"0e121f2"}],"date_title":"When","guests_title":"Guests","search_title":"Search","_margin":{"unit":"px","top":"30","right":"0","bottom":"50","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-search-form"}],"isInner":true}],"isInner":true},{"id":"6c9c0317","elType":"section","settings":{"layout":"full_width","gap":"no","border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"box_shadow_box_shadow_type":"yes","box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"html_tag":"div"},"elements":[{"id":"13b0c5b0","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"30","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"30","left":"30","isLinked":false}},"elements":[{"id":"414ce21a","elType":"widget","settings":{"title":"Filter","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_font_weight":"700","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"30","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"heading"},{"id":"35805e2c","elType":"widget","settings":{"title":"Price","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"30","right":"0","bottom":"20","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"429ad4a7","elType":"widget","settings":{"_element_id":""},"elements":[],"widgetType":"babe-price-filter"},{"id":"5c4fc65b","elType":"widget","settings":{"title":"Reviews","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"30","right":"0","bottom":"10","left":"0","isLinked":false},"_padding":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"heading"},{"id":"1ec0f6ed","elType":"widget","settings":[],"elements":[],"widgetType":"babe-rating-filter"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"697c9898","elType":"column","settings":{"_column_size":50,"_inline_size":75,"_inline_size_tablet":70,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"889799c","elType":"widget","settings":{"per_page":"12","column":"3","style":"1","column_tablet":"2"},"elements":[],"widgetType":"babe-search-results"}],"isInner":false}],"isInner":false},{"id":"5c099e75","elType":"section","settings":{"html_tag":"div"},"elements":[{"id":"35f974a9","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"6148a24e","elType":"widget","settings":{"text":"Search Now","link":{"url":"#booking_form_mobile","is_external":"","nofollow":"","custom_attributes":""},"align":"center","motion_fx_motion_fx_scrolling":"yes","_offset_x_tablet":{"unit":"px","size":269,"sizes":[]},"_offset_y_tablet":{"unit":"px","size":60,"sizes":[]},"hide_desktop":"hidden-desktop","__dynamic__":[],"icon_indent":{"unit":"px","size":0,"sizes":[]},"typography_typography":"custom","background_color":"#FFFFFF","button_background_hover_color":"#FFFFFF","border_radius":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"button_icon_color":"#FFFFFF","_z_index":99999,"_element_width":"inherit","_position":"fixed","_offset_orientation_h":"end","_offset_x_end":{"unit":"px","size":0,"sizes":[]},"_offset_orientation_v":"end","_offset_y_end":{"unit":"px","size":0,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":18,"sizes":[]},"button_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":"","spread":0,"color":""},"size":"md","button_text_color":"#000000","hover_color":"#DC834E","_background_background":"classic","_background_color":"#FFFFFF","_box_shadow_box_shadow_type":"yes","_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false}],"tour-sidebar-grid-2-column":[{"id":"17b67121","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","margin":{"unit":"px","top":"60","right":0,"bottom":"110","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"60","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"reverse_order_mobile":"reverse-mobile","html_tag":"div"},"elements":[{"id":"1b0d33b","elType":"column","settings":{"_column_size":50,"_inline_size":31,"_inline_size_tablet":37,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"40","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"1a75398d","elType":"section","settings":{"layout":"full_width","gap":"no","border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"box_shadow_box_shadow_type":"yes","box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"margin":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"20","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"26a27875","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"40","bottom":"0","left":"40","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"_element_id":"booking_form_mobile"},"elements":[{"id":"70c43ca6","elType":"widget","settings":{"title":"Search Tours","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_font_weight":"700","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"30","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"heading"},{"id":"2ba3bb33","elType":"widget","settings":{"style_arrow":"style-2","taxonomy_search":[{"_id":"7a1b0dc","taxonomy_slug":"locations","taxonomy_title":"Title Item","taxonomy_subtitle":"Booking Locations","taxonomy_icon":{"value":"triply-icon- triply-icon-map-marker-alt","library":"triply-icon"}},{"taxonomy_slug":"types","taxonomy_title":"Title Item","taxonomy_subtitle":"Booking Types","taxonomy_icon":{"value":"triply-icon- triply-icon-fan","library":"triply-icon"},"_id":"0e121f2"}],"date_title":"When","guests_title":"Guests","search_title":"Search","_margin":{"unit":"px","top":"30","right":"0","bottom":"50","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-search-form"}],"isInner":true}],"isInner":true},{"id":"589229b3","elType":"section","settings":{"layout":"full_width","gap":"no","border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"box_shadow_box_shadow_type":"yes","box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"html_tag":"div"},"elements":[{"id":"5c848135","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"40","bottom":"30","left":"40","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"30","left":"30","isLinked":false}},"elements":[{"id":"3bf08d8b","elType":"widget","settings":{"title":"Filter","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_font_weight":"700","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"30","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"heading"},{"id":"44dab935","elType":"widget","settings":{"title":"Price","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"30","right":"0","bottom":"20","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"60a981ef","elType":"widget","settings":{"_element_id":""},"elements":[],"widgetType":"babe-price-filter"},{"id":"1a3a9c9d","elType":"widget","settings":{"title":"Reviews","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"30","right":"0","bottom":"10","left":"0","isLinked":false},"_padding":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"heading"},{"id":"2b68213","elType":"widget","settings":[],"elements":[],"widgetType":"babe-rating-filter"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"6702a022","elType":"column","settings":{"_column_size":50,"_inline_size":69,"_inline_size_tablet":63,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"4a9cc84c","elType":"widget","settings":{"per_page":"6","column":"2","style":"1","column_tablet":"1"},"elements":[],"widgetType":"babe-search-results"}],"isInner":false}],"isInner":false},{"id":"371cfadb","elType":"section","settings":{"html_tag":"div"},"elements":[{"id":"3da6a926","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"30493a8","elType":"widget","settings":{"text":"Search Now","link":{"url":"#booking_form_mobile","is_external":"","nofollow":"","custom_attributes":""},"align":"center","motion_fx_motion_fx_scrolling":"yes","_offset_x_tablet":{"unit":"px","size":269,"sizes":[]},"_offset_y_tablet":{"unit":"px","size":60,"sizes":[]},"hide_desktop":"hidden-desktop","__dynamic__":[],"icon_indent":{"unit":"px","size":0,"sizes":[]},"typography_typography":"custom","background_color":"#FFFFFF","button_background_hover_color":"#FFFFFF","border_radius":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"button_icon_color":"#FFFFFF","_z_index":99999,"_element_width":"inherit","_position":"fixed","_offset_orientation_h":"end","_offset_x_end":{"unit":"px","size":0,"sizes":[]},"_offset_orientation_v":"end","_offset_y_end":{"unit":"px","size":0,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":18,"sizes":[]},"button_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":"","spread":0,"color":""},"size":"md","button_text_color":"#000000","hover_color":"#DC834E","_background_background":"classic","_background_color":"#FFFFFF","_box_shadow_box_shadow_type":"yes","_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false}],"booking-types":[{"id":"039dd7e","elType":"section","settings":{"margin":{"unit":"px","top":"50","right":0,"bottom":"50","left":0,"isLinked":true},"gap":"no","html_tag":"div"},"elements":[{"id":"47b6259","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"b0b99e1","elType":"widget","settings":{"column":"3","style":"1"},"elements":[],"widgetType":"babe-archive-items"}],"isInner":false}],"isInner":false}],"tours-list-view":[{"id":"2bb7fae","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","margin":{"unit":"px","top":"60","right":0,"bottom":"110","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"60","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"reverse_order_mobile":"reverse-mobile","html_tag":"div"},"elements":[{"id":"17e50f2","elType":"column","settings":{"_column_size":50,"_inline_size":69,"_inline_size_tablet":63,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"40","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"0afa9eb","elType":"widget","settings":{"per_page":"6","column":"1","search_view":"list","style":"5"},"elements":[],"widgetType":"babe-search-results"}],"isInner":false},{"id":"ea1161a","elType":"column","settings":{"_column_size":50,"_inline_size":31,"_inline_size_tablet":37,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"b552fc9","elType":"section","settings":{"layout":"full_width","gap":"no","border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"box_shadow_box_shadow_type":"yes","box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"margin":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"ae2b67e","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"40","bottom":"0","left":"40","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false}},"elements":[{"id":"d8bed4b","elType":"widget","settings":{"title":"Search Tours","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_font_weight":"700","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"30","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"heading"},{"id":"2a39555","elType":"widget","settings":{"style_arrow":"style-2","taxonomy_search":[{"_id":"7a1b0dc","taxonomy_slug":"locations","taxonomy_title":"Title Item","taxonomy_subtitle":"Booking Locations","taxonomy_icon":{"value":"triply-icon- triply-icon-map-marker-rounded","library":"triply-icon"}},{"taxonomy_slug":"types","taxonomy_title":"Title Item","taxonomy_subtitle":"Booking Types","taxonomy_icon":{"value":"triply-icon- triply-icon-activity","library":"triply-icon"},"_id":"0e121f2"}],"date_title":"When","guests_title":"Guests","search_title":"Search","_margin":{"unit":"px","top":"30","right":"0","bottom":"50","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-search-form"}],"isInner":true}],"isInner":true},{"id":"4b0efaa","elType":"section","settings":{"layout":"full_width","gap":"no","border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"box_shadow_box_shadow_type":"yes","box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"html_tag":"div"},"elements":[{"id":"6499f90","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"40","bottom":"30","left":"40","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"30","left":"30","isLinked":false}},"elements":[{"id":"479a2c3","elType":"widget","settings":{"title":"Filter","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_font_weight":"700","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"30","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"heading"},{"id":"46fc585","elType":"widget","settings":{"title":"Price","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"30","right":"0","bottom":"20","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"6097bb7","elType":"widget","settings":{"_element_id":""},"elements":[],"widgetType":"babe-price-filter"},{"id":"e1cfe18","elType":"widget","settings":{"title":"Destinations","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"30","right":"0","bottom":"15","left":"0","isLinked":false},"_padding":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"heading"},{"id":"4b44a7b","elType":"widget","settings":{"taxonomy_id":"54"},"elements":[],"widgetType":"babe-taxonomy-filter"},{"id":"b47e3e0","elType":"widget","settings":{"title":"Activity","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"30","right":"0","bottom":"15","left":"0","isLinked":false},"_padding":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"heading"},{"id":"9523e54","elType":"widget","settings":{"taxonomy_id":"55"},"elements":[],"widgetType":"babe-taxonomy-filter"},{"id":"a8a87e9","elType":"widget","settings":{"title":"Attractions","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"30","right":"0","bottom":"15","left":"0","isLinked":false},"_padding":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"heading"},{"id":"881a115","elType":"widget","settings":{"taxonomy_id":"87"},"elements":[],"widgetType":"babe-taxonomy-filter"},{"id":"01f80ab","elType":"widget","settings":{"title":"Reviews","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"30","right":"0","bottom":"10","left":"0","isLinked":false},"_padding":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"heading"},{"id":"c27668c","elType":"widget","settings":[],"elements":[],"widgetType":"babe-rating-filter"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false}],"tours-list-top-search":[{"id":"ecadff2","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"-40.5","right":0,"bottom":"0","left":0,"isLinked":false},"z_index":5,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"margin_mobile":{"unit":"px","top":"60","right":0,"bottom":"60","left":0,"isLinked":true},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"017fcab","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"755578f","elType":"widget","settings":{"destinations_title":"Destinations","destinations_subtitle":"Where are you going?","activity_title":"Activity","activity_subtitle":"All Activity","date_title":"When","guests_title":"Guests","search_title":"Search","taxonomy_search":[{"_id":"667a46b","taxonomy_slug":"locations","taxonomy_title":"Destinations","taxonomy_subtitle":"Where are you going?","taxonomy_icon":{"value":"triply-icon- triply-icon-map-marker-rounded","library":"triply-icon"}},{"_id":"202a807","taxonomy_slug":"types","taxonomy_title":"Activity","taxonomy_subtitle":"All Activity","taxonomy_icon":{"value":"triply-icon- triply-icon-activity","library":"triply-icon"}}],"search":"","search_icon":{"value":"triply-icon- triply-icon-search","library":"triply-icon"}},"elements":[],"widgetType":"babe-search-form"}],"isInner":false}],"isInner":false},{"id":"44cee6d","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin":{"unit":"px","top":"20","right":0,"bottom":"110","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"20","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"b866541","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"aa7395a","elType":"widget","settings":{"per_page":"9","column":"3"},"elements":[],"widgetType":"babe-search-results"}],"isInner":false}],"isInner":false}],"tours-list-sidebar":[{"id":"dc5a90c","elType":"section","settings":{"html_tag":"div"},"elements":[{"id":"cf3dec2","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"d7eb367","elType":"widget","settings":{"text":"Search Now","link":{"url":"#booking_form_mobile","is_external":"","nofollow":"","custom_attributes":""},"align":"center","motion_fx_motion_fx_scrolling":"yes","_offset_x_tablet":{"unit":"px","size":269,"sizes":[]},"_offset_y_tablet":{"unit":"px","size":60,"sizes":[]},"hide_desktop":"hidden-desktop","__dynamic__":[],"icon_indent":{"unit":"px","size":0,"sizes":[]},"typography_typography":"custom","background_color":"#FFFFFF","button_background_hover_color":"#FFFFFF","border_radius":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"button_icon_color":"#FFFFFF","_z_index":99999,"_element_width":"inherit","_position":"fixed","_offset_orientation_h":"end","_offset_x_end":{"unit":"px","size":0,"sizes":[]},"_offset_orientation_v":"end","_offset_y_end":{"unit":"px","size":0,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":18,"sizes":[]},"button_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":"","spread":0,"color":""},"size":"md","button_text_color":"#000000","hover_color":"#DC834E","_background_background":"classic","_background_color":"#FFFFFF","_box_shadow_box_shadow_type":"yes","_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false},{"id":"72cc56c6","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","margin":{"unit":"px","top":"60","right":0,"bottom":"110","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"60","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"reverse_order_mobile":"reverse-mobile","html_tag":"div"},"elements":[{"id":"1260abbe","elType":"column","settings":{"_column_size":50,"_inline_size":31,"_inline_size_tablet":37,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"40","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"314015fd","elType":"section","settings":{"layout":"full_width","gap":"no","border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"box_shadow_box_shadow_type":"yes","box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"margin":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"20","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"71bd74d0","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"40","bottom":"0","left":"40","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"_element_id":"booking_form_mobile"},"elements":[{"id":"9b0f828","elType":"widget","settings":{"title":"Search Tours","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_font_weight":"700","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"30","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"heading"},{"id":"29c4df75","elType":"widget","settings":{"style_arrow":"style-2","taxonomy_search":[{"_id":"7a1b0dc","taxonomy_slug":"locations","taxonomy_title":"Title Item","taxonomy_subtitle":"Booking Locations","taxonomy_icon":{"value":"triply-icon- triply-icon-map-marker-rounded","library":"triply-icon"}},{"taxonomy_slug":"types","taxonomy_title":"Title Item","taxonomy_subtitle":"Booking Types","taxonomy_icon":{"value":"triply-icon- triply-icon-activity","library":"triply-icon"},"_id":"0e121f2"}],"date_title":"When","guests_title":"Guests","search_title":"Search","_margin":{"unit":"px","top":"30","right":"0","bottom":"50","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-search-form"}],"isInner":true}],"isInner":true},{"id":"645c3f09","elType":"section","settings":{"layout":"full_width","gap":"no","border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"box_shadow_box_shadow_type":"yes","box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"html_tag":"div"},"elements":[{"id":"286f789e","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"40","bottom":"30","left":"40","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"30","left":"30","isLinked":false}},"elements":[{"id":"62c2f4a1","elType":"widget","settings":{"title":"Filter","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_font_weight":"700","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"30","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"heading"},{"id":"76497cd9","elType":"widget","settings":{"title":"Price","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"30","right":"0","bottom":"20","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"ca1aa6f","elType":"widget","settings":{"_element_id":""},"elements":[],"widgetType":"babe-price-filter"},{"id":"11253a17","elType":"widget","settings":{"title":"Destinations","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"30","right":"0","bottom":"15","left":"0","isLinked":false},"_padding":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"heading"},{"id":"84f7b8c","elType":"widget","settings":{"taxonomy_id":"54"},"elements":[],"widgetType":"babe-taxonomy-filter"},{"id":"7d0016d","elType":"widget","settings":{"title":"Activity","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"30","right":"0","bottom":"15","left":"0","isLinked":false},"_padding":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"heading"},{"id":"ad098cb","elType":"widget","settings":{"taxonomy_id":"55"},"elements":[],"widgetType":"babe-taxonomy-filter"},{"id":"28fe505","elType":"widget","settings":{"title":"Attractions","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"30","right":"0","bottom":"15","left":"0","isLinked":false},"_padding":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"heading"},{"id":"02626fa","elType":"widget","settings":{"taxonomy_id":"87"},"elements":[],"widgetType":"babe-taxonomy-filter"},{"id":"b8ce67a","elType":"widget","settings":{"title":"Reviews","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"30","right":"0","bottom":"10","left":"0","isLinked":false},"_padding":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"heading"},{"id":"449e181a","elType":"widget","settings":[],"elements":[],"widgetType":"babe-rating-filter"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"5b2aeca8","elType":"column","settings":{"_column_size":50,"_inline_size":69,"_inline_size_tablet":63,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"54986ce5","elType":"widget","settings":{"per_page":"8","column":"2","style":"1","column_tablet":"1"},"elements":[],"widgetType":"babe-search-results"}],"isInner":false}],"isInner":false},{"id":"439e2315","elType":"section","settings":{"html_tag":"div"},"elements":[{"id":"52a498d1","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"387db0c4","elType":"widget","settings":{"text":"Search Now","link":{"url":"#booking_form_mobile","is_external":"","nofollow":"","custom_attributes":""},"align":"center","motion_fx_motion_fx_scrolling":"yes","_offset_x_tablet":{"unit":"px","size":269,"sizes":[]},"_offset_y_tablet":{"unit":"px","size":60,"sizes":[]},"hide_desktop":"hidden-desktop","__dynamic__":[],"icon_indent":{"unit":"px","size":0,"sizes":[]},"typography_typography":"custom","background_color":"#FFFFFF","button_background_hover_color":"#FFFFFF","border_radius":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"button_icon_color":"#FFFFFF","_z_index":99999,"_element_width":"inherit","_position":"fixed","_offset_orientation_h":"end","_offset_x_end":{"unit":"px","size":0,"sizes":[]},"_offset_orientation_v":"end","_offset_y_end":{"unit":"px","size":0,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":18,"sizes":[]},"button_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":"","spread":0,"color":""},"size":"md","button_text_color":"#000000","hover_color":"#DC834E","_background_background":"classic","_background_color":"#FFFFFF","_box_shadow_box_shadow_type":"yes","_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false}],"tour-detail-3":[{"id":"15645027","elType":"section","settings":{"stretch_section":"section-stretched","gap":"no","content_position":"middle","background_background":"classic","background_color":"#F6F7FB","border_border":"solid","border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"border_color":"#E5E5E6","padding":{"unit":"px","top":"60","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"15","bottom":"0","left":"15","isLinked":false},"margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"64481f40","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"32d03572","elType":"widget","settings":{"__dynamic__":{"title":"[elementor-tag id=\"\" name=\"page-title\" settings=\"%7B%22include_context%22%3A%22%22%2C%22show_home_title%22%3A%22%22%2C%22before%22%3A%22%22%2C%22after%22%3A%22%22%2C%22fallback%22%3A%22%22%7D\"]"},"title":"Add Your Heading Text Here","align":"left","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_text_transform":"capitalize","_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"typography_font_size_mobile":{"unit":"px","size":30,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_z_index":2,"_offset_x":{"unit":"px","size":"","sizes":[]},"_offset_y":{"unit":"px","size":"","sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"250","bottom":"0","left":"0","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true}},"elements":[],"widgetType":"theme-page-title"},{"id":"8e7f200","elType":"widget","settings":{"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"__globals__":{"text_color":"globals\/colors?id=lighter"},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_z_index":2},"elements":[],"widgetType":"babe-item-address"},{"id":"31c10be2","elType":"widget","settings":{"slideshow_style":"style-3","margin_tab_wrapper":{"unit":"px","top":"0","right":"-15","bottom":"90","left":"0","isLinked":false},"tab_title_typography_typography":"custom","tab_title_typography_font_weight":"500","tab_title_typography_letter_spacing":{"unit":"px","size":1,"sizes":[]},"margin_tab_wrapper_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"-30","isLinked":false},"margin_tab_wrapper_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"-15","isLinked":false},"tab_title_align":"flex-end","tab_title_align_tablet":"flex-start","_margin":{"unit":"px","top":"-85","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":1},"elements":[],"widgetType":"babe-item-slideshow"}],"isInner":false}],"isInner":false},{"id":"7a317ef","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color":"#F6F7FB","margin":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"10","right":"30","bottom":"5","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"10","right":"15","bottom":"5","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"de687ac","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"custom_css":"selector .item_info_price {\n    margin-bottom: 0;\n}"},"elements":[{"id":"020e614","elType":"widget","settings":{"title":"Pricerr","custom_css":"selector .item_info_price {\n    margin-bottom: 0;\n}","_padding":{"unit":"px","top":"0","right":"50","bottom":"30","left":"0","isLinked":false},"_border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"_border_width_mobile":{"unit":"px","top":"0","right":"1","bottom":"0","left":"0","isLinked":false},"_border_color":"#E0E0E0","_element_width":"auto","_element_custom_width_mobile":{"unit":"%","size":33,"sizes":[]},"_element_width_mobile":"initial","_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-price-from"},{"id":"536c431","elType":"widget","settings":{"title":"Duration","duration_icon":{"value":"triply-icon- triply-icon-clock-time","library":"triply-icon"},"_padding":{"unit":"px","top":"0","right":"50","bottom":"30","left":"0","isLinked":false},"_element_width":"auto","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"%","size":33,"sizes":[]},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-duration"},{"id":"1362fe8","elType":"widget","settings":{"title":"Max People","duration_icon":{"value":"triply-icon- triply-icon-users","library":"triply-icon"},"_padding":{"unit":"px","top":"0","right":"50","bottom":"30","left":"0","isLinked":false},"_element_width":"auto","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"%","size":33,"sizes":[]},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-max-guests"},{"id":"3e8326f","elType":"widget","settings":{"duration_icon":{"value":"triply-icon- triply-icon-user","library":"triply-icon"},"title":"Min Age","_padding":{"unit":"px","top":"0","right":"50","bottom":"30","left":"0","isLinked":false},"_element_width":"auto","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"%","size":33,"sizes":[]},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-min-age"},{"id":"4142c4d","elType":"widget","settings":{"title":"Tour Type","duration_icon":{"value":"triply-icon- triply-icon-location-circle","library":"triply-icon"},"_padding":{"unit":"px","top":"0","right":"50","bottom":"30","left":"0","isLinked":false},"_element_width":"auto","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"%","size":33,"sizes":[]},"taxonomy_slug":"types","_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-tour-type"},{"id":"d982c14","elType":"widget","settings":{"title":"Reviews","_padding":{"unit":"px","top":"0","right":"50","bottom":"30","left":"0","isLinked":false},"_element_width":"auto","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"%","size":33,"sizes":[]},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-stars"}],"isInner":false}],"isInner":false},{"id":"2aa8b192","elType":"section","settings":{"structure":"20","gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color_stop":{"unit":"%","size":11,"sizes":[]},"background_color_b":"#FFFFFF00","background_color_b_stop":{"unit":"%","size":11,"sizes":[]},"margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"5594b696","elType":"column","settings":{"_column_size":50,"_inline_size":68.992199999999996862243278883397579193115234375,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"40","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"64ce9bb4","elType":"widget","settings":{"title":"Overview","header_size":"h3","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"fdd090e","elType":"widget","settings":{"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-content"},{"id":"2ae20add","elType":"widget","settings":{"text":"Divider","color":"#E8E8E8","gap":{"unit":"px","size":10,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"divider"},{"id":"75bb169f","elType":"widget","settings":{"title":"Included\/Excluded ","header_size":"h3","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"384dfe7b","elType":"widget","settings":{"icon":{"value":"far fa-check-circle","library":"fa-regular"},"icon_size":{"unit":"px","size":15,"sizes":[]},"icon_color":"#2EA452","_margin":{"unit":"px","top":"0","right":"30","bottom":"10","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":440,"sizes":[]},"item_space":{"unit":"px","size":10,"sizes":[]}},"elements":[],"widgetType":"babe-item-included"},{"id":"7ab6709f","elType":"widget","settings":{"select":"excluded","icon":{"value":"far fa-times-circle","library":"fa-regular"},"icon_color":"#EF2A38","_element_width":"auto","item_space":{"unit":"px","size":10,"sizes":[]}},"elements":[],"widgetType":"babe-item-included"},{"id":"65d80137","elType":"widget","settings":{"text":"Divider","color":"#E8E8E8","gap":{"unit":"px","size":50,"sizes":[]}},"elements":[],"widgetType":"divider"},{"id":"1161d3fd","elType":"widget","settings":{"enable_title":"yes","title":"Tour Plan","title_margin":{"unit":"px","size":30,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"babe-item-steps"},{"id":"1ebdf2cb","elType":"widget","settings":{"text":"Divider","color":"#E8E8E8","gap":{"unit":"px","size":50,"sizes":[]}},"elements":[],"widgetType":"divider"},{"id":"5c6f519f","elType":"widget","settings":{"map_height":{"unit":"px","size":500,"sizes":[]},"map_height_mobile":{"unit":"px","size":400,"sizes":[]},"enable_title":"yes","title":"Tour Map","title_margin":{"unit":"px","size":30,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"babe-item-address-map"},{"id":"451ff281","elType":"widget","settings":{"text":"Divider","color":"#E8E8E8","gap":{"unit":"px","size":50,"sizes":[]}},"elements":[],"widgetType":"divider"},{"id":"6a55f95a","elType":"widget","settings":{"enable_title":"yes","title":"Calendar & Prices","title_margin":{"unit":"px","size":30,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"babe-item-calendar"},{"id":"4364b6ba","elType":"widget","settings":{"text":"Divider","color":"#E8E8E8","gap":{"unit":"px","size":50,"sizes":[]}},"elements":[],"widgetType":"divider"},{"id":"42f9454d","elType":"widget","settings":{"enable_carousel":"yes","column":"2","enable_title":"yes","title":"You may like","__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"babe-item-related"},{"id":"711a75a8","elType":"widget","settings":{"text":"Divider","color":"#E8E8E8","gap":{"unit":"px","size":50,"sizes":[]}},"elements":[],"widgetType":"divider"},{"id":"57966d4b","elType":"widget","settings":{"title":"Reviews","header_size":"h3","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"b6f0e51","elType":"widget","settings":[],"elements":[],"widgetType":"babe-item-stars-criteria"},{"id":"1ee63cc6","elType":"widget","settings":{"_skin":"theme_comments"},"elements":[],"widgetType":"post-comments"}],"isInner":false},{"id":"136780cc","elType":"column","settings":{"_column_size":50,"_inline_size":30.815000000000001278976924368180334568023681640625,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"_inline_size_tablet":100,"align_tablet":"center","padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"47f95e6f","elType":"widget","settings":{"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"px","size":500,"sizes":[]},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"wrapper_box_shadow_box_shadow_type":"yes","wrapper_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":30,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"_element_id":"booking_form_mobile"},"elements":[],"widgetType":"babe-booking-form"},{"id":"55695dab","elType":"section","settings":{"gap":"no","border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"box_shadow_box_shadow_type":"yes","box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":30,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"padding":{"unit":"px","top":"30","right":"0","bottom":"20","left":"0","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"6f9ca016","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"3a30cca","elType":"widget","settings":{"title":"Last Minute Deals","header_size":"h3","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"40","bottom":"10","left":"40","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"6e23cb94","elType":"widget","settings":{"text":"Divider","color":"#E8E8E8","gap":{"unit":"px","size":10,"sizes":[]}},"elements":[],"widgetType":"divider"},{"id":"28945404","elType":"widget","settings":{"posts_per_page":4,"column":"1","_margin":{"unit":"px","top":"0","right":"40","bottom":"0","left":"40","isLinked":false},"column_tablet":"2"},"elements":[],"widgetType":"babe-item-other"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"251745e","elType":"section","settings":{"html_tag":"div"},"elements":[{"id":"64911a0","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"cbda8ef","elType":"widget","settings":{"text":"Book Now","link":{"url":"#booking_form_mobile","is_external":"","nofollow":"","custom_attributes":""},"align":"center","motion_fx_motion_fx_scrolling":"yes","_offset_x_tablet":{"unit":"px","size":269,"sizes":[]},"_offset_y_tablet":{"unit":"px","size":60,"sizes":[]},"hide_desktop":"hidden-desktop","__dynamic__":[],"icon_indent":{"unit":"px","size":0,"sizes":[]},"typography_typography":"custom","background_color":"#FFFFFF","button_background_hover_color":"#FFFFFF","border_radius":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"button_icon_color":"#FFFFFF","_z_index":99999,"_element_width":"inherit","_position":"fixed","_offset_orientation_h":"end","_offset_x_end":{"unit":"px","size":0,"sizes":[]},"_offset_orientation_v":"end","_offset_y_end":{"unit":"px","size":0,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":18,"sizes":[]},"button_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":"","spread":0,"color":""},"size":"md","button_text_color":"#000000","hover_color":"#DC834E","_background_background":"classic","_background_color":"#FFFFFF","_box_shadow_box_shadow_type":"yes","_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false}],"tour-detail-2":[{"id":"11fb8d60","elType":"section","settings":{"layout":"full_width","stretch_section":"section-stretched","gap":"no","content_position":"middle","background_background":"classic","background_color":"#F6F7FB","border_border":"solid","border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"border_color":"#E5E5E6","padding":{"unit":"px","top":"60","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"648fface","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"0d3c37a","elType":"section","settings":{"gap":"no","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"96020bb","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"250","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true}},"elements":[{"id":"5179d977","elType":"widget","settings":{"__dynamic__":{"title":"[elementor-tag id=\"\" name=\"page-title\" settings=\"%7B%22include_context%22%3A%22%22%2C%22show_home_title%22%3A%22%22%2C%22before%22%3A%22%22%2C%22after%22%3A%22%22%2C%22fallback%22%3A%22%22%7D\"]"},"title":"Add Your Heading Text Here","align":"left","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_text_transform":"capitalize","_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"typography_font_size_mobile":{"unit":"px","size":30,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_z_index":2,"_offset_x":{"unit":"px","size":"","sizes":[]},"_offset_y":{"unit":"px","size":"","sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]}},"elements":[],"widgetType":"theme-page-title"},{"id":"75a0719","elType":"widget","settings":{"__globals__":{"text_color":"globals\/colors?id=lighter"},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_z_index":2},"elements":[],"widgetType":"babe-item-address"}],"isInner":true}],"isInner":true},{"id":"171e86bb","elType":"widget","settings":{"slideshow_style":"style-2","margin_tab_wrapper":{"unit":"px","top":"0","right":"0","bottom":"90","left":"0","isLinked":false},"tab_title_typography_typography":"custom","tab_title_typography_font_weight":"500","tab_title_typography_letter_spacing":{"unit":"px","size":1,"sizes":[]},"margin_tab_wrapper_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"tab_title_align":"flex-end","tab_title_align_tablet":"flex-start","_margin":{"unit":"px","top":"-85","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-slideshow"}],"isInner":false}],"isInner":false},{"id":"3045e5f","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color":"#F6F7FB","margin":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"10","right":"30","bottom":"5","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"10","right":"15","bottom":"5","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"13be74c","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"custom_css":"selector .item_info_price {\n    margin-bottom: 0;\n}"},"elements":[{"id":"581b8af","elType":"widget","settings":{"title":"Price","custom_css":"selector .item_info_price {\n    margin-bottom: 0;\n}","_padding":{"unit":"px","top":"0","right":"50","bottom":"30","left":"0","isLinked":false},"_border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"_border_width_mobile":{"unit":"px","top":"0","right":"1","bottom":"0","left":"0","isLinked":false},"_border_color":"#E0E0E0","_element_width":"auto","_element_custom_width_mobile":{"unit":"%","size":33,"sizes":[]},"_element_width_mobile":"initial","_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-price-from"},{"id":"60b1f85","elType":"widget","settings":{"title":"Duration","duration_icon":{"value":"triply-icon- triply-icon-clock-time","library":"triply-icon"},"_padding":{"unit":"px","top":"0","right":"50","bottom":"30","left":"0","isLinked":false},"_element_width":"auto","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"%","size":33,"sizes":[]},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-duration"},{"id":"98ac434","elType":"widget","settings":{"title":"Max People","duration_icon":{"value":"triply-icon- triply-icon-users","library":"triply-icon"},"_padding":{"unit":"px","top":"0","right":"50","bottom":"30","left":"0","isLinked":false},"_element_width":"auto","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"%","size":33,"sizes":[]},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-max-guests"},{"id":"8cd48ee","elType":"widget","settings":{"duration_icon":{"value":"triply-icon- triply-icon-user","library":"triply-icon"},"title":"Min Age","_padding":{"unit":"px","top":"0","right":"50","bottom":"30","left":"0","isLinked":false},"_element_width":"auto","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"%","size":33,"sizes":[]},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-min-age"},{"id":"c5435fa","elType":"widget","settings":{"title":"Tour Type","duration_icon":{"value":"triply-icon- triply-icon-location-circle","library":"triply-icon"},"_padding":{"unit":"px","top":"0","right":"50","bottom":"30","left":"0","isLinked":false},"_element_width":"auto","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"%","size":33,"sizes":[]},"taxonomy_slug":"types","_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-tour-type"},{"id":"a30263d","elType":"widget","settings":{"title":"Reviews","_padding":{"unit":"px","top":"0","right":"50","bottom":"30","left":"0","isLinked":false},"_element_width":"auto","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"%","size":33,"sizes":[]},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-stars"}],"isInner":false}],"isInner":false},{"id":"48f784af","elType":"section","settings":{"structure":"20","gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color_stop":{"unit":"%","size":11,"sizes":[]},"background_color_b":"#FFFFFF00","background_color_b_stop":{"unit":"%","size":11,"sizes":[]},"margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"19069f00","elType":"column","settings":{"_column_size":50,"_inline_size":68.992199999999996862243278883397579193115234375,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"40","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"874f5e4","elType":"widget","settings":{"title":"Overview","header_size":"h3","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"7f29806","elType":"widget","settings":{"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-content"},{"id":"6b46125","elType":"widget","settings":{"text":"Divider","color":"#E8E8E8","gap":{"unit":"px","size":10,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"divider"},{"id":"ff848c2","elType":"widget","settings":{"title":"Included\/Excluded ","header_size":"h3","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"e4a358e","elType":"widget","settings":{"icon":{"value":"far fa-check-circle","library":"fa-regular"},"icon_size":{"unit":"px","size":15,"sizes":[]},"icon_color":"#2EA452","_margin":{"unit":"px","top":"0","right":"30","bottom":"8","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":440,"sizes":[]},"item_space":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"babe-item-included"},{"id":"750d03f","elType":"widget","settings":{"select":"excluded","icon":{"value":"far fa-times-circle","library":"fa-regular"},"icon_color":"#EF2A38","_element_width":"auto","item_space":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"babe-item-included"},{"id":"30eb8b3b","elType":"widget","settings":{"text":"Divider","color":"#E8E8E8","gap":{"unit":"px","size":50,"sizes":[]}},"elements":[],"widgetType":"divider"},{"id":"46b7719","elType":"widget","settings":{"enable_title":"yes","title":"Tour Plan","title_margin":{"unit":"px","size":30,"sizes":[]},"__globals__":{"title_color":""},"title_color":"#dc834e","icon_step":{"value":"fas fa-map-marker-alt","library":"fa-solid"},"icon_step_color":"#150000"},"elements":[],"widgetType":"babe-item-steps"},{"id":"4bfce25","elType":"widget","settings":{"text":"Divider","color":"#E8E8E8","gap":{"unit":"px","size":50,"sizes":[]}},"elements":[],"widgetType":"divider"},{"id":"b27efe5","elType":"widget","settings":{"map_height":{"unit":"px","size":500,"sizes":[]},"map_height_mobile":{"unit":"px","size":400,"sizes":[]},"enable_title":"yes","title":"Tour Map","title_margin":{"unit":"px","size":30,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"babe-item-address-map"},{"id":"1f8238b","elType":"widget","settings":{"text":"Divider","color":"#E8E8E8","gap":{"unit":"px","size":50,"sizes":[]}},"elements":[],"widgetType":"divider"},{"id":"758372e5","elType":"widget","settings":{"enable_title":"yes","title":"Calendar & Prices","title_margin":{"unit":"px","size":30,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"babe-item-calendar"},{"id":"1c65fe2b","elType":"widget","settings":{"text":"Divider","color":"#E8E8E8","gap":{"unit":"px","size":50,"sizes":[]}},"elements":[],"widgetType":"divider"},{"id":"4e65f301","elType":"widget","settings":{"enable_carousel":"yes","column":"2","enable_title":"yes","title":"You may like","__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"babe-item-related"},{"id":"12e0278","elType":"widget","settings":{"text":"Divider","color":"#E8E8E8","gap":{"unit":"px","size":50,"sizes":[]}},"elements":[],"widgetType":"divider"},{"id":"32eac16","elType":"widget","settings":{"title":"Reviews","header_size":"h3","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"cc48f05","elType":"widget","settings":[],"elements":[],"widgetType":"babe-item-stars-criteria"},{"id":"13f9860","elType":"widget","settings":{"_skin":"theme_comments"},"elements":[],"widgetType":"post-comments"}],"isInner":false},{"id":"53e35f1d","elType":"column","settings":{"_column_size":50,"_inline_size":30.815000000000001278976924368180334568023681640625,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"_inline_size_tablet":100,"align_tablet":"center","padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"3d730972","elType":"widget","settings":{"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"px","size":500,"sizes":[]},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"wrapper_box_shadow_box_shadow_type":"yes","wrapper_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":30,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"_element_id":"booking_form_mobile"},"elements":[],"widgetType":"babe-booking-form"},{"id":"63cc3df9","elType":"section","settings":{"gap":"no","border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"box_shadow_box_shadow_type":"yes","box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":30,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"padding":{"unit":"px","top":"30","right":"0","bottom":"20","left":"0","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"3e2db5cd","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"5fecb539","elType":"widget","settings":{"title":"Last Minute Deals","header_size":"h3","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"40","bottom":"10","left":"40","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"138b8998","elType":"widget","settings":{"text":"Divider","color":"#E8E8E8","gap":{"unit":"px","size":10,"sizes":[]}},"elements":[],"widgetType":"divider"},{"id":"6038147d","elType":"widget","settings":{"posts_per_page":4,"column":"1","_margin":{"unit":"px","top":"0","right":"40","bottom":"0","left":"40","isLinked":false},"column_tablet":"2"},"elements":[],"widgetType":"babe-item-other"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"b3efe90","elType":"section","settings":{"html_tag":"div"},"elements":[{"id":"ca343b8","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"8202ecd","elType":"widget","settings":{"text":"Book Now","link":{"url":"#booking_form_mobile","is_external":"","nofollow":"","custom_attributes":""},"align":"center","motion_fx_motion_fx_scrolling":"yes","_offset_x_tablet":{"unit":"px","size":269,"sizes":[]},"_offset_y_tablet":{"unit":"px","size":60,"sizes":[]},"hide_desktop":"hidden-desktop","__dynamic__":[],"icon_indent":{"unit":"px","size":0,"sizes":[]},"typography_typography":"custom","background_color":"#FFFFFF","button_background_hover_color":"#FFFFFF","border_radius":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"button_icon_color":"#FFFFFF","_z_index":99999,"_element_width":"inherit","_position":"fixed","_offset_orientation_h":"end","_offset_x_end":{"unit":"px","size":0,"sizes":[]},"_offset_orientation_v":"end","_offset_y_end":{"unit":"px","size":0,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":18,"sizes":[]},"button_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":"","spread":0,"color":""},"size":"md","button_text_color":"#000000","hover_color":"#DC834E","_background_background":"classic","_background_color":"#FFFFFF","_box_shadow_box_shadow_type":"yes","_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false}],"home1":[{"id":"4c896944","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":620,"sizes":[]},"custom_height_tablet":{"unit":"px","size":420,"sizes":[]},"custom_height_mobile":{"unit":"px","size":300,"sizes":[]},"overflow":"hidden","stretch_section":"section-stretched","background_background":"classic","background_color":"#F9F4F0","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape.png","id":1048},"background_position":"center left","background_repeat":"no-repeat","background_motion_fx_motion_fx_scrolling":"yes","background_motion_fx_translateY_effect":"yes","background_motion_fx_devices":["desktop","tablet"],"background_overlay_background":"classic","background_overlay_position":"center right","background_overlay_repeat":"no-repeat","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding":{"unit":"px","top":"60","right":"30","bottom":"100","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"80","right":"15","bottom":"80","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"333d9c30","elType":"column","settings":{"_column_size":100,"_inline_size":null,"align_mobile":"center","space_between_widgets":0},"elements":[{"id":"4eef4dc2","elType":"widget","settings":{"editor":"Natural beauty","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_z_index":2,"hide_mobile":"hidden-phone","__globals__":{"text_color":"globals\/colors?id=primary"}},"elements":[],"widgetType":"text-editor"},{"id":"4c7c0707","elType":"widget","settings":{"editor":"Natural beauty","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":24,"sizes":[]},"typography_font_weight":"600","_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_z_index":2,"hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet","__globals__":{"text_color":"globals\/colors?id=secondary"}},"elements":[],"widgetType":"text-editor"},{"id":"7f8f43ed","elType":"widget","settings":{"title":"Discover the most engaging places","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":80,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":60,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":42,"sizes":[]},"typography_line_height":{"unit":"px","size":80,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":60,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":42,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_z_index":2,"_element_width":"initial","_element_width_tablet":"initial","_element_custom_width":{"unit":"px","size":580,"sizes":[]},"_element_custom_width_tablet":{"unit":"px","size":500,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"604b3a3e","elType":"widget","settings":{"text":"Explore Now","align_mobile":"center","size":"lg","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"_z_index":2,"__globals__":{"background_color":"globals\/colors?id=secondary","button_background_hover_color":"globals\/colors?id=secondary_hover"},"background_color":"#202F59"},"elements":[],"widgetType":"button"},{"id":"1261fb99","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_bg-1.jpg","id":1011},"image_size":"full","_element_width":"initial","_element_custom_width":{"unit":"px","size":1275,"sizes":[]},"_position":"absolute","_offset_x":{"size":329,"unit":"px"},"_offset_x_mobile":{"unit":"%","size":50,"sizes":[]},"_offset_x_end":{"unit":"px","size":-315,"sizes":[]},"_offset_y":{"size":-175,"unit":"px"}},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"3ebbfed1","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"-40.5","right":0,"bottom":"0","left":0,"isLinked":false},"z_index":5,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"html_tag":"div"},"elements":[{"id":"6caccb36","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[],"isInner":false}],"isInner":false},{"id":"65fd7916","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"70","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"6ea23465","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"5b285a00","elType":"widget","settings":{"editor":"Don\u2019t miss ","align":"center","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"2ba59516","elType":"widget","settings":{"title":"Special Offers","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"4ff72c9a","elType":"section","settings":{"gap":"no","structure":"30","html_tag":"div"},"elements":[{"id":"2c25ebde","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[{"id":"68d18b1e","elType":"widget","settings":{"skin":"cover","bg_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_banner-1.jpg","id":1281},"bg_image_size":"full","title":"Weekly <br> Flash Deals","description":"Up to 30% off","button":"View Deals","min-height":{"unit":"px","size":300,"sizes":[]},"alignment":"left","padding":{"unit":"px","top":"60","right":"50","bottom":"45","left":"50","isLinked":false},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":30,"sizes":[]},"title_typography_line_height":{"unit":"px","size":30,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"description_typography_font_weight":"500","button_background_color":"#FFFFFF","button_border_width":{"unit":"px","size":0,"sizes":[]},"content_animation":"","content_animation_duration":{"unit":"px","size":400,"sizes":[]},"overlay_color_hover":"#02010100","effect_duration":{"unit":"px","size":400,"sizes":[]},"custom_css":"selector .elementor-widget-container { border-radius: 20px;}","__globals__":{"description_color":"globals\/colors?id=accent","button_color":"globals\/colors?id=secondary"},"min-height_tablet":{"unit":"px","size":250,"sizes":[]},"vertical_position":"top","padding_tablet":{"unit":"px","top":"40","right":"15","bottom":"30","left":"15","isLinked":false},"title_typography_font_size_tablet":{"unit":"px","size":24,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":24,"sizes":[]},"title_spacing":{"unit":"px","size":5,"sizes":[]},"description_spacing":{"unit":"px","size":20,"sizes":[]}},"elements":[],"widgetType":"call-to-action"}],"isInner":true},{"id":"4e4f8fe0","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[{"id":"44413de2","elType":"widget","settings":{"skin":"cover","bg_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_banner-2.jpg","id":1408},"bg_image_size":"full","title":"Summer <br> Escapes","description":"Plan your next trip","button":"View Deals","min-height":{"unit":"px","size":300,"sizes":[]},"alignment":"left","padding":{"unit":"px","top":"60","right":"50","bottom":"45","left":"50","isLinked":false},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":30,"sizes":[]},"title_typography_line_height":{"unit":"px","size":30,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"description_typography_font_weight":"500","button_background_color":"#44AAF5","button_border_width":{"unit":"px","size":0,"sizes":[]},"content_animation":"","content_animation_duration":{"unit":"px","size":400,"sizes":[]},"overlay_color_hover":"#02010100","effect_duration":{"unit":"px","size":400,"sizes":[]},"custom_css":"selector .elementor-widget-container { border-radius: 20px;}","__globals__":{"description_color":"globals\/colors?id=accent","button_color":"globals\/colors?id=secondary"},"min-height_tablet":{"unit":"px","size":250,"sizes":[]},"vertical_position":"top","padding_tablet":{"unit":"px","top":"40","right":"15","bottom":"30","left":"15","isLinked":false},"title_typography_font_size_tablet":{"unit":"px","size":24,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":24,"sizes":[]},"title_spacing":{"unit":"px","size":5,"sizes":[]},"description_spacing":{"unit":"px","size":20,"sizes":[]},"button_text_color":"#FFFFFF"},"elements":[],"widgetType":"call-to-action"}],"isInner":true},{"id":"64a9e148","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"3a962972","elType":"widget","settings":{"skin":"cover","bg_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_banner-3.jpg","id":1409},"bg_image_size":"full","title":"Exclusive <br> Deals","description":"Want to save up to 50%","button":"View Deals","min-height":{"unit":"px","size":300,"sizes":[]},"alignment":"left","padding":{"unit":"px","top":"60","right":"50","bottom":"45","left":"50","isLinked":false},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":30,"sizes":[]},"title_typography_line_height":{"unit":"px","size":30,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"description_typography_font_weight":"500","button_background_color":"#FFD77A","button_border_width":{"unit":"px","size":0,"sizes":[]},"content_animation":"","content_animation_duration":{"unit":"px","size":400,"sizes":[]},"overlay_color_hover":"#02010100","effect_duration":{"unit":"px","size":400,"sizes":[]},"custom_css":"selector .elementor-widget-container { border-radius: 20px;}","__globals__":{"description_color":"globals\/colors?id=accent","button_color":"globals\/colors?id=secondary"},"min-height_tablet":{"unit":"px","size":250,"sizes":[]},"vertical_position":"top","padding_tablet":{"unit":"px","top":"40","right":"15","bottom":"30","left":"15","isLinked":false},"title_typography_font_size_tablet":{"unit":"px","size":24,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":24,"sizes":[]},"title_spacing":{"unit":"px","size":5,"sizes":[]},"description_spacing":{"unit":"px","size":20,"sizes":[]}},"elements":[],"widgetType":"call-to-action"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"6a21adbc","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"content_position":"middle","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"42bf8766","elType":"column","settings":{"_column_size":50,"_inline_size":42.6355999999999966121322358958423137664794921875,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[{"id":"47556241","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-2.png","id":1452},"image_size":"full","align":"right","align_mobile":"center"},"elements":[],"widgetType":"image"}],"isInner":false},{"id":"1c403cf6","elType":"column","settings":{"_column_size":50,"_inline_size":57.36399999999999721467247582040727138519287109375,"space_between_widgets":0,"align_mobile":"center","padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"629e762","elType":"widget","settings":{"title":"Not a Member Yet?","header_size":"h4","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"1a9c6854","elType":"widget","settings":{"editor":"Join us! Our members can access savings of up to 50% and earn Trip Coins while booking.","align_mobile":"center","_element_width":"initial","_element_custom_width":{"unit":"px","size":395,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"2eac7772","elType":"widget","settings":{"space":{"unit":"px","size":15,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"143263cd","elType":"widget","settings":{"text":"Sign In","align":"justify","size":"md","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"10","bottom":"0","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"5","bottom":"0","left":"0","isLinked":false},"_element_width":"initial","_element_width_mobile":"initial","_element_custom_width":{"unit":"px","size":150,"sizes":[]},"_element_custom_width_mobile":{"unit":"px","size":145,"sizes":[]},"__globals__":{"background_color":"globals\/colors?id=primary","button_background_hover_color":"globals\/colors?id=primary_hover","border_color":"globals\/colors?id=primary","button_hover_border_color":"globals\/colors?id=primary_hover"},"border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true}},"elements":[],"widgetType":"button"},{"id":"1a7db9ea","elType":"widget","settings":{"text":"Register","align":"justify","size":"md","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"background_color":"#DC834E00","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"border_color":"#202F59","_element_width":"initial","_element_custom_width":{"unit":"px","size":140,"sizes":[]},"__globals__":{"background_color":"","border_color":"globals\/colors?id=secondary","button_text_color":"globals\/colors?id=secondary","button_hover_border_color":"globals\/colors?id=primary","hover_color":"globals\/colors?id=primary"}},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false},{"id":"14775d3d","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color":"#F9F4F0","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-3.png","id":1509},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":3,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"100","right":"30","bottom":"70","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"80","right":"30","bottom":"50","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"30","bottom":"30","left":"30","isLinked":false},"html_tag":"div"},"elements":[{"id":"5eb5b216","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"6df2ca80","elType":"widget","settings":{"editor":"What\u2019s new","align":"center","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"460f18c9","elType":"widget","settings":{"title":"Popular Tours ","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"59bb92f4","elType":"widget","settings":{"per_page":"5","column":"3","style":"3"},"elements":[],"widgetType":"babe-all-items"}],"isInner":false}],"isInner":false},{"id":"63844234","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"html_tag":"div"},"elements":[{"id":"774201d7","elType":"column","settings":{"_column_size":50,"_inline_size":31.782900000000001483613232267089188098907470703125,"space_between_widgets":0},"elements":[{"id":"5398294c","elType":"widget","settings":{"editor":"Places to go","align":"left","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"77cb8315","elType":"widget","settings":{"title":"Perfect Destinations","align":"left","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"_z_index":2},"elements":[],"widgetType":"heading"},{"id":"529916e6","elType":"widget","settings":{"editor":"Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. ","_element_width":"initial","_element_custom_width":{"unit":"px","size":330,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"_z_index":2},"elements":[],"widgetType":"text-editor"},{"id":"4a7c0b4f","elType":"widget","settings":{"taxonomy_slug":"locations","enable_all_taxonomy":"yes","per_page":"8","count_tour":"yes","Typography_typography":"custom","Typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_color":"#020101","count_color":"#9C9898","location_list_padding":{"unit":"px","size":5,"sizes":[]}},"elements":[],"widgetType":"babe-taxonomies-list"},{"id":"14a813fb","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-map.png","id":2005},"image_size":"full","opacity":{"unit":"px","size":0.1000000000000000055511151231257827021181583404541015625,"sizes":[]},"_position":"absolute","_offset_x":{"size":1,"unit":"px"},"_offset_y":{"size":-1,"unit":"px"}},"elements":[],"widgetType":"image"}],"isInner":false},{"id":"22180a17","elType":"column","settings":{"_column_size":50,"_inline_size":68.2169999999999987494447850622236728668212890625,"space_between_widgets":0},"elements":[],"isInner":false}],"isInner":false},{"id":"888bb78","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-4.png","id":1794},"background_position":"initial","background_xpos":{"unit":"%","size":100,"sizes":[]},"background_ypos":{"unit":"%","size":55,"sizes":[]},"background_repeat":"no-repeat","background_size_tablet":"initial","background_bg_width_tablet":{"unit":"px","size":0,"sizes":[]},"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"padding_tablet":{"unit":"%","top":"","right":"","bottom":"","left":"","isLinked":true},"html_tag":"div"},"elements":[{"id":"7c33cd39","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"e1ccbfb","elType":"widget","settings":{"editor":"Brilliant reasons","align":"center","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"56da64be","elType":"widget","settings":{"title":"Why Choose Us","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"80","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"485fbba7","elType":"section","settings":{"gap":"no","structure":"40","html_tag":"div"},"elements":[{"id":"7afb5a08","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"align":"center","align_tablet":"flex-end","align_mobile":"center","space_between_widgets":0,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"584083a3","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/price.svg","id":1887},"library":"svg"},"title_text":"Competitive Pricing","description_text":"Lorem ipsum dolor sit amet, consectetur adipisicing elit.","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_space_tablet":{"unit":"px","size":20,"sizes":[]},"icon_size":{"unit":"px","size":60,"sizes":[]},"title_bottom_space_tablet":{"unit":"px","size":5,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":30,"sizes":[]},"_padding":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":2,"_background_background":"classic","_background_color":"#FFFFFF00","_background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-5.png","id":1726},"_background_position":"top center","_background_repeat":"no-repeat","_element_width":"initial","_element_custom_width":{"unit":"px","size":360,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"13038909","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"align":"center","align_tablet":"flex-start","align_mobile":"center","space_between_widgets":0,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"3dac8c09","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/worldwide.svg","id":1888},"library":"svg"},"title_text":"Worldwide Coverage","description_text":"Lorem ipsum dolor sit amet, consectetur adipisicing elit.","primary_color":"#DC834E","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_space_tablet":{"unit":"px","size":20,"sizes":[]},"icon_size":{"unit":"px","size":60,"sizes":[]},"title_bottom_space_tablet":{"unit":"px","size":5,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":30,"sizes":[]},"_padding":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":2,"_background_background":"classic","_background_color":"#FFFFFF00","_background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-6.png","id":1784},"_background_position":"top center","_background_repeat":"no-repeat","_element_width":"initial","_element_custom_width":{"unit":"px","size":360,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"4eaceeca","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"align":"center","align_tablet":"flex-end","align_mobile":"center","space_between_widgets":0,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"4c75b46c","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/booking.svg","id":3796},"library":"svg"},"title_text":"Fast Booking","description_text":"Lorem ipsum dolor sit amet, consectetur adipisicing elit.","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_space_tablet":{"unit":"px","size":20,"sizes":[]},"icon_size":{"unit":"px","size":60,"sizes":[]},"title_bottom_space_tablet":{"unit":"px","size":5,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":30,"sizes":[]},"_padding":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":2,"_background_background":"classic","_background_color":"#FFFFFF00","_background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-7.png","id":1786},"_background_position":"top center","_background_repeat":"no-repeat","_element_width":"initial","_element_custom_width":{"unit":"px","size":360,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"63750c0d","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"align":"center","align_tablet":"flex-start","align_mobile":"center","space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"da1a7d3","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/guide.svg","id":3797},"library":"svg"},"title_text":"Guided Tours","description_text":"Lorem ipsum dolor sit amet, consectetur adipisicing elit.","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_space_tablet":{"unit":"px","size":20,"sizes":[]},"icon_size":{"unit":"px","size":60,"sizes":[]},"title_bottom_space_tablet":{"unit":"px","size":5,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":30,"sizes":[]},"_padding":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":2,"_background_background":"classic","_background_color":"#FFFFFF00","_background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-8.png","id":1787},"_background_position":"top center","_background_repeat":"no-repeat","_element_width":"initial","_element_custom_width":{"unit":"px","size":360,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"icon-box"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"54d2d466","elType":"section","settings":{"layout":"full_width","gap":"no","stretch_section":"section-stretched","structure":"20","html_tag":"div"},"elements":[{"id":"2fd11c01","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_bg-2.jpg","id":1902},"background_position":"center center","background_repeat":"no-repeat","background_motion_fx_motion_fx_scrolling":"yes","background_motion_fx_translateY_effect":"yes"},"elements":[{"id":"16dd632f","elType":"widget","settings":{"space":{"unit":"px","size":300,"sizes":[]}},"elements":[],"widgetType":"spacer"}],"isInner":false},{"id":"7814c94e","elType":"column","settings":{"_column_size":50,"_inline_size":null,"align":"center","space_between_widgets":0,"background_background":"classic","background_color":"#202F59","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-9.png","id":1964},"padding":{"unit":"px","top":"140","right":"30","bottom":"0","left":"30","isLinked":false},"background_position":"center right","background_repeat":"no-repeat","background_motion_fx_motion_fx_scrolling":"yes","background_motion_fx_devices":["desktop","tablet"],"padding_tablet":{"unit":"px","top":"80","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"3c353f1f","elType":"widget","settings":{"editor":"Latest deal","align":"center","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"3574ead0","elType":"widget","settings":{"title":"Save an Extra $500 on Cyprus Holidays","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"100","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"60","left":"0","isLinked":false},"__globals__":{"title_color":""},"title_color":"#FFFFFF","_element_width":"initial","_element_custom_width":{"unit":"px","size":550,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"5495ac7","elType":"widget","settings":{"editor":"It\u2019s limited seating! Hurry up","align":"center","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"40047e14","elType":"widget","settings":{"due_date":"2021-11-20 06:20","custom_labels":"yes","label_days":"Days","label_hours":"Hours","label_minutes":"Mins","label_seconds":"Secs","container_width":{"unit":"px","size":350,"sizes":[]},"box_background_color":"#DC834E00","box_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"digits_typography_typography":"custom","digits_typography_font_size":{"unit":"px","size":50,"sizes":[]},"digits_typography_font_weight":"700","digits_typography_line_height":{"unit":"px","size":60,"sizes":[]},"label_typography_typography":"custom","label_typography_font_size":{"unit":"px","size":12,"sizes":[]},"label_typography_font_weight":"500","label_typography_text_transform":"uppercase","label_typography_line_height":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"__globals__":{"digits_color":"globals\/colors?id=primary"},"digits_typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"digits_typography_line_height_tablet":{"unit":"px","size":40,"sizes":[]}},"elements":[],"widgetType":"countdown"},{"id":"1252dd2f","elType":"widget","settings":{"width":{"unit":"px","size":340,"sizes":[]},"align":"center","text":"Divider","weight":{"unit":"px","size":7,"sizes":[]},"gap":{"unit":"px","size":0,"sizes":[]},"custom_css":"selector .elementor-divider-separator {\n    border-radius: 5px 5px 0 0;\n}","__globals__":{"color":"globals\/colors?id=primary"}},"elements":[],"widgetType":"divider"}],"isInner":false}],"isInner":false},{"id":"7ac258f0","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color":"#F9F4F0","padding":{"unit":"px","top":"100","right":"30","bottom":"100","left":"30","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"80","right":"30","bottom":"80","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"15","bottom":"60","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"5f290595","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"align":"space-between"},"elements":[{"id":"476ecdf9","elType":"widget","settings":{"editor":"Testimonials ","align":"center","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"1ed1495f","elType":"widget","settings":{"title":"Customer Reviews","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"48836b9a","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_quote-1.png","id":2016},"image_size":"full","align":"left","_element_width":"initial","_element_custom_width":{"unit":"%","size":17,"sizes":[]},"_element_custom_width_tablet":{"unit":"%","size":14,"sizes":[]},"_element_width_tablet":"initial","hide_mobile":"hidden-phone"},"elements":[],"widgetType":"image"},{"id":"4a538e83","elType":"widget","settings":{"testimonials":[{"testimonial_rating":5,"testimonial_content":"\u201cThis was an amazing trip! There were so many highlights... our outstanding, kind, patient, amazing leader Gustavo!! What an absolute saint. He was so organized and insightful!\u201d ","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h3-img-box-1.png","id":2117},"testimonial_name":"Melisa Joan H.","testimonial_job":" New York, USA","_id":"87f87d2","testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"}},{"testimonial_rating":5,"testimonial_content":"\"Needless to say we are extremely satisfied with the results. Booking tour was the best investment I ever made. Nice work on your booking tour. Booking tour impressed.\"","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-4-2.jpg","id":2730},"testimonial_name":"Roselin D.","testimonial_job":" New York, USA","testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"},"_id":"cadac67"},{"testimonial_rating":5,"testimonial_content":"\"Great job, I will definitely be ordering again! After using booking tour my business skyrocketed! Man, this thing is getting better and better as I learn more about it. \"","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-5-2.jpg","id":2731},"testimonial_name":"Cleveland A.","testimonial_job":" New York, USA","testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"},"_id":"3d47fe4"}],"column":"1","layout_style":"style-2","content_typography_line_height":{"unit":"px","size":"","sizes":[]},"enable_carousel":"yes","_element_width":"initial","_element_custom_width":{"unit":"%","size":66,"sizes":[]},"content_typography_typography":"custom","content_typography_font_size_tablet":{"unit":"px","size":22,"sizes":[]},"content_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"_element_width_tablet":"initial","_element_width_mobile":"inherit","_element_custom_width_tablet":{"unit":"%","size":68,"sizes":[]}},"elements":[],"widgetType":"triply-testimonials"},{"id":"9058459","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_quote-2.png","id":2017},"image_size":"full","align":"right","_element_width":"initial","_element_custom_width":{"unit":"%","size":17,"sizes":[]},"_element_custom_width_tablet":{"unit":"%","size":14,"sizes":[]},"_element_width_tablet":"initial","hide_mobile":"hidden-phone"},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"578ba730","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"28f32852","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"3db731a5","elType":"widget","settings":{"editor":"Our blog","align":"center","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"62359ba8","elType":"widget","settings":{"title":"Travel Tips and Advice","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"66fd7df6","elType":"widget","settings":{"column":"2","item_spacing":{"unit":"px","size":50,"sizes":[]},"pagination_page_limit":"5","pagination_prev_label":"&laquo; Previous","pagination_next_label":"Next &raquo;","enable_carousel":"yes","column_tablet":"1"},"elements":[],"widgetType":"triply-post-grid"}],"isInner":false}],"isInner":false}],"destination-list-2":[{"id":"40f94fb","elType":"section","settings":{"gap":"no","custom_height":{"unit":"px","size":"","sizes":[]},"stretch_section":"section-stretched","structure":"50","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h3-icon-box.png","id":3597},"background_position":"center center","background_repeat":"no-repeat","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin":{"unit":"px","top":"100","right":0,"bottom":"0","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"60","right":0,"bottom":"0","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"40","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"58ac33f","elType":"column","settings":{"_column_size":20,"_inline_size":20,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"space_between_widgets":0,"_inline_size_tablet":33,"space_between_widgets_tablet":0,"margin_tablet":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"70","right":"25","bottom":"0","left":"25","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"20","right":"40","bottom":"20","left":"40","isLinked":false}},"elements":[{"id":"79a03f8","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"africa","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-02.jpg","id":3489},"count_tour":"yes","custom_text":"From <span>100$<\/span>","img_location_radius":{"unit":"%","top":"50","right":"50","bottom":"50","left":"50","isLinked":true},"img_overflow":"","Typography_typography":"custom","Typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_space":{"unit":"px","size":0,"sizes":[]},"count_background_color":"#02010100","count_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"image_opacity":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"image_opacity_hover":{"unit":"px","size":0.5,"sizes":[]},"image_background_overlay":"#202F59"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":false},{"id":"870fffc","elType":"column","settings":{"_column_size":20,"_inline_size":20,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":33.3299999999999982946974341757595539093017578125,"margin_tablet":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"space_between_widgets_tablet":0,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"50","right":"25","bottom":"0","left":"25","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"padding_mobile":{"unit":"px","top":"20","right":"40","bottom":"20","left":"40","isLinked":false}},"elements":[{"id":"7dbc275","elType":"widget","settings":{"taxonomy_slug":"types","locations_id":"africa","types_id":"beaches","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/Destination_image-2.jpg","id":4236},"count_tour":"yes","custom_text":"From <span>100$<\/span>","img_location_radius":{"unit":"%","top":"50","right":"50","bottom":"50","left":"50","isLinked":true},"img_overflow":"","Typography_typography":"custom","Typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_space":{"unit":"px","size":0,"sizes":[]},"count_background_color":"#02010100","count_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"image_opacity":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"image_opacity_hover":{"unit":"px","size":0.5,"sizes":[]},"image_background_overlay":"#202F59"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":false},{"id":"3593c7b","elType":"column","settings":{"_column_size":20,"_inline_size":20,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":33.3299999999999982946974341757595539093017578125,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"25","bottom":"0","left":"25","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"space_between_widgets_tablet":0,"padding_mobile":{"unit":"px","top":"20","right":"40","bottom":"20","left":"40","isLinked":false}},"elements":[{"id":"1ebd871","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"japan","types_id":"historical","features_id":"wine-tasting","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-03.jpg","id":3493},"count_tour":"yes","custom_text":"From <span>100$<\/span>","img_location_radius":{"unit":"%","top":"50","right":"50","bottom":"50","left":"50","isLinked":true},"img_overflow":"","Typography_typography":"custom","Typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_space":{"unit":"px","size":0,"sizes":[]},"count_background_color":"#02010100","count_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"image_background_overlay":"#202F59","image_opacity":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"image_opacity_hover":{"unit":"px","size":0.5,"sizes":[]}},"elements":[],"widgetType":"taxonomy-item"}],"isInner":false},{"id":"b29759c","elType":"column","settings":{"_column_size":20,"_inline_size":19.95400000000000062527760746888816356658935546875,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"30","right":"30","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"50","right":"25","bottom":"0","left":"25","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"space_between_widgets_tablet":0,"padding_mobile":{"unit":"px","top":"20","right":"40","bottom":"20","left":"40","isLinked":false},"align_tablet":"flex-end","align_mobile":"center"},"elements":[{"id":"fa827a1","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"iceland","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-04.jpg","id":3494},"count_tour":"yes","custom_text":"From <span>100$<\/span>","img_location_radius":{"unit":"%","top":"50","right":"50","bottom":"50","left":"50","isLinked":true},"img_overflow":"","Typography_typography":"custom","Typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_space":{"unit":"px","size":0,"sizes":[]},"count_background_color":"#02010100","count_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_element_width_tablet":"initial","_element_width_mobile":"initial","_element_custom_width_tablet":{"unit":"%","size":62,"sizes":[]},"image_opacity":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"image_opacity_hover":{"unit":"px","size":0.5,"sizes":[]},"image_background_overlay":"#202F59"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":false},{"id":"d8d274a","elType":"column","settings":{"_column_size":20,"_inline_size":20,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"space_between_widgets":0,"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"30","right":"0","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"70","right":"25","bottom":"0","left":"25","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"space_between_widgets_tablet":0,"padding_mobile":{"unit":"px","top":"20","right":"40","bottom":"20","left":"40","isLinked":false},"align_tablet":"flex-start","align_mobile":"center"},"elements":[{"id":"7bafdeb","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"europe","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-05.jpg","id":3495},"count_tour":"yes","custom_text":"From <span>100$<\/span>","img_location_radius":{"unit":"%","top":"50","right":"50","bottom":"50","left":"50","isLinked":true},"img_overflow":"","Typography_typography":"custom","Typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_space":{"unit":"px","size":0,"sizes":[]},"count_background_color":"#02010100","count_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_element_width_tablet":"initial","_element_width_mobile":"initial","_element_custom_width_tablet":{"unit":"%","size":62,"sizes":[]},"image_opacity":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"image_opacity_hover":{"unit":"px","size":0.5,"sizes":[]},"image_background_overlay":"#202F59"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":false}],"isInner":false},{"id":"dbb6469","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"70","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"35","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"ab79265","elType":"column","settings":{"_column_size":100,"_inline_size":null,"align":"center","space_between_widgets":0},"elements":[{"id":"55d5797","elType":"widget","settings":{"editor":"<div>Places to go<\/div>","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"2928e8b","elType":"widget","settings":{"title":"Perfect Destinations","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"35","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"ff0246f","elType":"widget","settings":{"editor":"<div>Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<\/div>","align":"center","typography_typography":"custom","_element_width":"initial","_element_custom_width":{"unit":"px","size":570,"sizes":[]}},"elements":[],"widgetType":"text-editor"}],"isInner":false}],"isInner":false},{"id":"247b422","elType":"section","settings":{"content_width":{"unit":"px","size":1320,"sizes":[]},"gap":"no","stretch_section":"section-stretched","structure":"30","background_repeat":"no-repeat","background_overlay_background":"classic","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-map.png","id":2005},"background_overlay_position":"top center","background_overlay_repeat":"no-repeat","background_overlay_opacity":{"unit":"px","size":0.1000000000000000055511151231257827021181583404541015625,"sizes":[]},"margin":{"unit":"px","top":"0","right":0,"bottom":"40","left":0,"isLinked":false},"padding":{"unit":"px","top":"70","right":"30","bottom":"65","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"15","bottom":"30","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"40","right":"30","bottom":"40","left":"30","isLinked":false},"html_tag":"div"},"elements":[{"id":"f49c3b3","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"align_mobile":"center","margin_tablet":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"c17bb90","elType":"widget","settings":{"title":"Continents","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"23d41b4","elType":"widget","settings":{"taxonomy_slug":"locations","enable_all_taxonomy":"yes","per_page":"8","count_tour":"yes","Typography_typography":"custom","Typography_font_size":{"unit":"px","size":16,"sizes":[]},"Typography_font_weight":"500","__globals__":{"title_color":"globals\/colors?id=accent","count_color":"globals\/colors?id=lighter","color_hover":"globals\/colors?id=primary_hover"},"column_tablet":"1","column_mobile":"2","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":250,"sizes":[]}},"elements":[],"widgetType":"babe-taxonomies-list"}],"isInner":false},{"id":"6eedaf7","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"align_mobile":"center","margin_tablet":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"margin_mobile":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"25f585c","elType":"widget","settings":{"title":"Asia & The Pacific","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"e15c4a0","elType":"widget","settings":{"taxonomy_slug":"locations","enable_all_taxonomy":"yes","per_page":"8","count_tour":"yes","Typography_typography":"custom","Typography_font_size":{"unit":"px","size":16,"sizes":[]},"Typography_font_weight":"500","__globals__":{"title_color":"globals\/colors?id=accent","count_color":"globals\/colors?id=lighter","color_hover":"globals\/colors?id=primary_hover"},"column_tablet":"1","column_mobile":"2","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":250,"sizes":[]}},"elements":[],"widgetType":"babe-taxonomies-list"}],"isInner":false},{"id":"7a4799c","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"align_mobile":"center","margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"margin_mobile":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"28fbe3e","elType":"widget","settings":{"title":"Countries","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"45c9b3b","elType":"widget","settings":{"taxonomy_slug":"locations","enable_all_taxonomy":"yes","per_page":"8","count_tour":"yes","Typography_typography":"custom","Typography_font_size":{"unit":"px","size":16,"sizes":[]},"Typography_font_weight":"500","__globals__":{"title_color":"globals\/colors?id=accent","count_color":"globals\/colors?id=lighter","color_hover":"globals\/colors?id=primary_hover"},"column_tablet":"1","column_mobile":"2","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":250,"sizes":[]}},"elements":[],"widgetType":"babe-taxonomies-list"}],"isInner":false}],"isInner":false}],"destination-list":[{"id":"0a6b0f3","elType":"section","settings":{"content_width":{"unit":"px","size":1320,"sizes":[]},"gap":"no","stretch_section":"section-stretched","structure":"20","margin_tablet":{"unit":"px","top":"80","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"60","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"25","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"25","left":"15","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin":{"unit":"px","top":"100","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"390a158","elType":"column","settings":{"_column_size":50,"_inline_size":66.7999999999999971578290569595992565155029296875,"space_between_widgets":0,"space_between_widgets_tablet":0,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[{"id":"6d8f00e","elType":"widget","settings":{"taxonomy_slug":"locations","types_id":"city-tours","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-01.jpg","id":3488},"count_tour":"yes","custom_text":"From <span>100$<\/span>","locations_id":"united-states"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":false},{"id":"e098281","elType":"column","settings":{"_column_size":50,"_inline_size":33.2000000000000028421709430404007434844970703125,"space_between_widgets":0,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[{"id":"2574a0a","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"canada","types_id":"beaches","features_id":"feature-3","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-02.jpg","id":3489},"count_tour":"yes","custom_text":"From <span>100$<\/span>","img_location_radius":{"unit":"%","top":"50","right":"50","bottom":"50","left":"50","isLinked":true}},"elements":[],"widgetType":"taxonomy-item"}],"isInner":false}],"isInner":false},{"id":"91310c8","elType":"section","settings":{"content_width":{"unit":"px","size":1320,"sizes":[]},"gap":"no","stretch_section":"section-stretched","structure":"30","padding":{"unit":"px","top":"0","right":"30","bottom":"25","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"20","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"ae6a6a9","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets_tablet":0,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[{"id":"0a8a78c","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"asia","features_id":"feature-1","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-03.jpg","id":3493},"count_tour":"yes","custom_text":"From <span>100$<\/span>"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":false},{"id":"5fdd7ca","elType":"column","settings":{"_column_size":33,"_inline_size":null,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[{"id":"61c9cf1","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"africa","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-04.jpg","id":3494},"count_tour":"yes","custom_text":"From <span>100$<\/span>","img_location_radius":{"unit":"%","top":"50","right":"50","bottom":"50","left":"50","isLinked":true}},"elements":[],"widgetType":"taxonomy-item"}],"isInner":false},{"id":"381608a","elType":"column","settings":{"_column_size":33,"_inline_size":null,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"df073aa","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"cambodia","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-06.jpg","id":3496},"count_tour":"yes","custom_text":"From <span>100$<\/span>"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":false}],"isInner":false},{"id":"05216be","elType":"section","settings":{"content_width":{"unit":"px","size":1320,"sizes":[]},"gap":"no","stretch_section":"section-stretched","structure":"30","margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"80f358d","elType":"column","settings":{"_column_size":33,"_inline_size":null,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[{"id":"528493b","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"europe","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-06.jpg","id":3496},"count_tour":"yes","custom_text":"From <span>100$<\/span>"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":false},{"id":"d7f71b5","elType":"column","settings":{"_column_size":33,"_inline_size":null,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[{"id":"2bccfe6","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"colombia","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-07.jpg","id":3497},"count_tour":"yes","custom_text":"From <span>100$<\/span>"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":false},{"id":"651d97f","elType":"column","settings":{"_column_size":33,"_inline_size":null,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"9225f94","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"tanzania","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-08.jpg","id":3498},"count_tour":"yes","custom_text":"From <span>100$<\/span>"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":false}],"isInner":false}],"landingpage":[{"id":"2d03b83","elType":"section","settings":{"layout":"full_width","gap":"no","stretch_section":"section-stretched","html_tag":"div"},"elements":[{"id":"c94ec5d","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"8cca3c1","elType":"widget","settings":{"revslidertitle":"Slider 1","shortcode":"[rev_slider alias=\"slider-1\" slidertitle=\"Slider 1\"][\/rev_slider]"},"elements":[],"widgetType":"slider_revolution"}],"isInner":false}],"isInner":false},{"id":"afd7bbd","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","margin":{"unit":"px","top":"-140","right":0,"bottom":"60","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"80","right":0,"bottom":"60","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"60","right":0,"bottom":"40","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"z_index":2,"html_tag":"div"},"elements":[{"id":"6f29bf1","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"animation":"opal-move-up","animation_duration":"fast"},"elements":[{"id":"6bc4615","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/ldp_home-5.jpg","id":10763,"alt":"","source":"library"},"image_size":"full","align":"left","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/home-5\/","is_external":"on","nofollow":"","custom_attributes":""},"hover_animation":"float","image_border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"image_box_shadow_box_shadow_type":"yes","image_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"163a722","elType":"widget","settings":{"title":"<span style=\"color:#000;\">Home<\/span> 05","header_size":"h4","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_line_height":{"unit":"px","size":20,"sizes":[]}},"elements":[],"widgetType":"heading"}],"isInner":false},{"id":"4c722a6","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"animation":"opal-move-up","animation_duration":"fast","animation_delay":100},"elements":[{"id":"831285b","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/ldp_home-6.jpg","id":10764,"alt":"","source":"library"},"image_size":"full","align":"right","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/home-6\/","is_external":"on","nofollow":"","custom_attributes":""},"hover_animation":"float","image_border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"image_box_shadow_box_shadow_type":"yes","image_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"01df3f9","elType":"widget","settings":{"title":"<span style=\"color:#000;\">Home<\/span> 06","header_size":"h4","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_line_height":{"unit":"px","size":20,"sizes":[]}},"elements":[],"widgetType":"heading"}],"isInner":false}],"isInner":false},{"id":"eebb5b2","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"z_index":2,"html_tag":"div"},"elements":[{"id":"097f3d3","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"animation":"opal-move-up","animation_duration":"fast"},"elements":[{"id":"74b83b2","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/ldp_home-7.jpg","id":10765,"alt":"","source":"library"},"image_size":"full","align":"left","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/home-7\/","is_external":"on","nofollow":"","custom_attributes":""},"hover_animation":"float","image_border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"image_box_shadow_box_shadow_type":"yes","image_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"6e8ecc2","elType":"widget","settings":{"title":"<span style=\"color:#000;\">Home<\/span> 07","header_size":"h4","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_line_height":{"unit":"px","size":20,"sizes":[]}},"elements":[],"widgetType":"heading"}],"isInner":false},{"id":"c5e639b","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"animation":"opal-move-up","animation_duration":"fast","animation_delay":100},"elements":[{"id":"02dd975","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2022\/09\/ldp_home-8.jpg","id":10766,"alt":"","source":"library"},"image_size":"full","align":"right","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/home-8\/","is_external":"on","nofollow":"","custom_attributes":""},"hover_animation":"float","image_border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"image_box_shadow_box_shadow_type":"yes","image_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"41b4570","elType":"widget","settings":{"title":"<span style=\"color:#000;\">Home<\/span> 08","header_size":"h4","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_line_height":{"unit":"px","size":20,"sizes":[]}},"elements":[],"widgetType":"heading"}],"isInner":false}],"isInner":false},{"id":"d7e6139","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"z_index":2,"html_tag":"div"},"elements":[{"id":"a0a3392","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"animation":"opal-move-up","animation_duration":"fast"},"elements":[{"id":"5ad7607","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/ldp_home-1.jpg","id":4584},"image_size":"full","align":"left","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/home-1\/","is_external":"on","nofollow":"","custom_attributes":""},"hover_animation":"float","image_border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"image_box_shadow_box_shadow_type":"yes","image_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"2bb2a65","elType":"widget","settings":{"title":"<span style=\"color:#000;\">Home<\/span> 01","header_size":"h4","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_line_height":{"unit":"px","size":20,"sizes":[]}},"elements":[],"widgetType":"heading"}],"isInner":false},{"id":"a5aa49b","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"animation":"opal-move-up","animation_duration":"fast","animation_delay":100},"elements":[{"id":"2cb6ee3","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/ldp_home-2.jpg","id":4585},"image_size":"full","align":"right","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/home-2\/","is_external":"on","nofollow":"","custom_attributes":""},"hover_animation":"float","image_border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"image_box_shadow_box_shadow_type":"yes","image_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"b0ea6c8","elType":"widget","settings":{"title":"<span style=\"color:#000;\">Home<\/span> 02","header_size":"h4","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_line_height":{"unit":"px","size":20,"sizes":[]}},"elements":[],"widgetType":"heading"}],"isInner":false}],"isInner":false},{"id":"20a39ed","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"z_index":2,"html_tag":"div"},"elements":[{"id":"31a2e06","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"animation":"opal-move-up","animation_duration":"fast"},"elements":[{"id":"6230d6e","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/ldp_home-3.jpg","id":4586},"image_size":"full","align":"left","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/home-3\/","is_external":"on","nofollow":"","custom_attributes":""},"hover_animation":"float","image_border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"image_box_shadow_box_shadow_type":"yes","image_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"2231e2e","elType":"widget","settings":{"title":"<span style=\"color:#000;\">Home<\/span> 03","header_size":"h4","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_line_height":{"unit":"px","size":20,"sizes":[]}},"elements":[],"widgetType":"heading"}],"isInner":false},{"id":"7a81367","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"animation":"opal-move-up","animation_duration":"fast","animation_delay":100},"elements":[{"id":"a5bc35f","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/ldp_home-4.jpg","id":4587},"image_size":"full","align":"right","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/home-4\/","is_external":"on","nofollow":"","custom_attributes":""},"hover_animation":"float","image_border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"image_box_shadow_box_shadow_type":"yes","image_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"2db50be","elType":"widget","settings":{"title":"<span style=\"color:#000;\">Home<\/span> 04","header_size":"h4","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_line_height":{"unit":"px","size":20,"sizes":[]}},"elements":[],"widgetType":"heading"}],"isInner":false}],"isInner":false},{"id":"dafdb6d","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"gradient","background_color":"#F9F4F0","padding":{"unit":"px","top":"100","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"80","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"15","bottom":"0","left":"15","isLinked":false},"layout":"full_width","background_color_stop":{"unit":"%","size":89,"sizes":[]},"background_color_b":"#F2295B00","background_color_b_stop":{"unit":"%","size":11,"sizes":[]},"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"c9bd5af","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"9c828ae","elType":"widget","settings":{"editor":"Tour features","align":"center","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"text-editor"},{"id":"20829af","elType":"widget","settings":{"title":"Perfect for all <br> Travel Booking Website","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"_element_custom_width":{"unit":"px","size":468,"sizes":[]},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"heading"},{"id":"d390de5","elType":"widget","settings":{"revslidertitle":"Slider 2","shortcode":"[rev_slider alias=\"slider-2\" slidertitle=\"Slider 2\"][\/rev_slider]"},"elements":[],"widgetType":"slider_revolution"}],"isInner":false}],"isInner":false},{"id":"def777f","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"30","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"e929525","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"animation":"opal-move-right","animation_duration":"fast"},"elements":[{"id":"f657f8a","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/ldp_one-click.png","id":4684},"title_text":"One Click Import","description_text":"","image_space_mobile":{"unit":"px","size":10,"sizes":[]},"image_size":{"unit":"%","size":"","sizes":[]},"title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"400","title_typography_line_height":{"unit":"px","size":24,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"_animation_mobile":"opal-move-up"},"elements":[],"widgetType":"image-box"}],"isInner":false},{"id":"8ed947f","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"animation":"opal-move-up","animation_duration":"fast"},"elements":[{"id":"3a17320","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/ldp_speed.png","id":4685},"title_text":"High-performance Speed ","description_text":"","image_space_mobile":{"unit":"px","size":10,"sizes":[]},"image_size":{"unit":"%","size":"","sizes":[]},"title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"400","title_typography_line_height":{"unit":"px","size":24,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"image-box"}],"isInner":false},{"id":"52c9d4d","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"animation":"opal-move-left","animation_duration":"fast"},"elements":[{"id":"c681b39","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/ldp_support.png","id":4686},"title_text":"RTL Language Support ","description_text":"","image_space_mobile":{"unit":"px","size":0,"sizes":[]},"image_size":{"unit":"%","size":"","sizes":[]},"title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"400","title_typography_line_height":{"unit":"px","size":24,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"_animation_mobile":"opal-move-up"},"elements":[],"widgetType":"image-box"}],"isInner":false}],"isInner":false},{"id":"288121a","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","height":"min-height","custom_height":{"unit":"px","size":1100,"sizes":[]},"custom_height_tablet":{"unit":"px","size":700,"sizes":[]},"column_position":"top","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/ldp_footer.jpg","id":4737},"background_position":"bottom center","background_repeat":"no-repeat","background_size":"cover","background_overlay_background":"gradient","background_overlay_color":"#FFFFFF","background_overlay_color_stop":{"unit":"%","size":30,"sizes":[]},"background_overlay_color_b":"#F2295B00","background_overlay_color_b_stop":{"unit":"%","size":52,"sizes":[]},"background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"background_overlay_hover_background":"classic","background_overlay_hover_opacity":{"unit":"px","size":1,"sizes":[]},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"28fb590","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"align":"center"},"elements":[{"id":"c6d5cb8","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/ldp_title.png","id":4711},"image_size":"full","width_tablet":{"unit":"px","size":300,"sizes":[]},"width_mobile":{"unit":"px","size":220,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_animation":"rubberBand"},"elements":[],"widgetType":"image"},{"id":"15183ff","elType":"widget","settings":{"text":"Purchase Theme","align":"justify","align_mobile":"center","_margin":{"unit":"px","top":"0","right":"5","bottom":"0","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_element_width":"initial","_element_width_mobile":"inherit","_element_custom_width":{"unit":"px","size":196,"sizes":[]},"_animation":"opal-move-left","link":{"url":"https:\/\/themeforest.net\/item\/triply-tour-booking-wordpress-theme\/29875995","is_external":"","nofollow":"","custom_attributes":""}},"elements":[],"widgetType":"button"},{"id":"5661550","elType":"widget","settings":{"text":"Live Demo","align":"justify","align_mobile":"justify","background_color":"#F5F5F5","hover_color":"#FFFFFF","_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"5","isLinked":false},"_margin_mobile":{"unit":"px","top":"10","right":"0","bottom":"0","left":"0","isLinked":false},"_element_width":"initial","_element_width_mobile":"initial","_element_custom_width":{"unit":"px","size":180,"sizes":[]},"_element_custom_width_mobile":{"unit":"px","size":170,"sizes":[]},"__globals__":{"button_text_color":"globals\/colors?id=accent","button_background_hover_color":"globals\/colors?id=primary_hover"},"_animation":"opal-move-right","animation_duration":"fast","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/home-1\/","is_external":"","nofollow":"","custom_attributes":""}},"elements":[],"widgetType":"button"},{"id":"5fa2e63","elType":"widget","settings":{"editor":"Copyright \u00a9 2022 Triply. Designed by <a href=\"https:\/\/themeforest.net\/user\/opal_wp\" target=\"_blank\" rel=\"noopener\">Pavothemes.<\/a>","align":"center","_margin":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=accent"},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"text-editor"}],"isInner":false}],"isInner":false}],"breadcrumb":[{"id":"ed4a604","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/breadcrumb-bg.jpg","id":2725},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","padding":{"unit":"px","top":"30","right":"30","bottom":"30","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"15","bottom":"30","left":"15","isLinked":false},"height":"min-height","custom_height":{"unit":"px","size":200,"sizes":[]},"css_classes":"triply-breadcrumb-build","margin":{"unit":"px","top":"120","right":0,"bottom":"0","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"dddd361","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"0e000b0","elType":"widget","settings":{"title":"Blog","align":"center","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":42,"sizes":[]},"typography_font_weight":"700","_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"5340852","elType":"widget","settings":{"__dynamic__":{"title":"[elementor-tag id=\"\" name=\"page-title\" settings=\"%7B%22include_context%22%3A%22%22%2C%22show_home_title%22%3A%22%22%2C%22before%22%3A%22%22%2C%22after%22%3A%22%22%2C%22fallback%22%3A%22%22%7D\"]"},"title":"Add Your Heading Text Here","align":"center","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_font_weight":"700","typography_text_transform":"capitalize","_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"typography_font_size_mobile":{"unit":"px","size":42,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"theme-page-title"},{"id":"0fe6204","elType":"widget","settings":{"align":"center","typography_link_typography":"custom","typography_link_font_size":{"unit":"px","size":12,"sizes":[]},"typography_link_font_weight":"500","typography_link_text_transform":"uppercase","breadcrumb_last_text":"#CCCCCC","breadcrumb_last_icon":"#FFFFFF","typography_typography":"custom","typography_font_weight":"500","typography_text_transform":"uppercase","link_color":"#FFFFFF","__globals__":{"link_hover_color":"globals\/colors?id=primary"},"typography_font_size":{"unit":"px","size":12,"sizes":[]}},"elements":[],"widgetType":"breadcrumbs"}],"isInner":false}],"isInner":false}],"h3-banner":[{"id":"80c5ae8","elType":"section","settings":{"content_width":{"unit":"px","size":410,"sizes":[]},"gap":"no","html_tag":"div"},"elements":[{"id":"ab7ec96","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_color":"#E4EBF1","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h3-img-6.png","id":1160},"background_position":"top center","background_repeat":"no-repeat","background_size":"auto","background_overlay_background":"classic","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h3-img-5.png","id":1153},"background_overlay_position":"initial","background_overlay_xpos":{"unit":"px","size":-300,"sizes":[]},"background_overlay_ypos":{"unit":"px","size":350,"sizes":[]},"background_overlay_repeat":"no-repeat","background_overlay_size":"auto","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"border_border":"solid","border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"80","right":"75","bottom":"45","left":"80","isLinked":false},"_inline_size_tablet":80,"padding_tablet":{"unit":"px","top":"50","right":"40","bottom":"050","left":"50","isLinked":false},"space_between_widgets_tablet":0,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"background_repeat_mobile":"no-repeat","background_size_mobile":"contain","background_overlay_position_mobile":"initial","background_overlay_xpos_mobile":{"unit":"px","size":-370,"sizes":[]},"background_overlay_ypos_mobile":{"unit":"px","size":210,"sizes":[]},"background_overlay_size_mobile":"auto"},"elements":[{"id":"bf02a9a","elType":"widget","settings":{"editor":"<div>Discount<\/div>","align":"left","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":60,"sizes":[]},"__globals__":{"text_color":""},"align_mobile":"center","text_color":"#FFFFFF","typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"16f1460","elType":"widget","settings":{"editor":"<p>50<\/p>","align":"left","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":180,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":20,"sizes":[]},"_padding":{"unit":"px","top":"60","right":"0","bottom":"120","left":"0","isLinked":false},"_element_width":"auto","typography_font_size_mobile":{"unit":"px","size":170,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":170,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-10","isLinked":false},"_padding_tablet":{"unit":"px","top":"60","right":"0","bottom":"160","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"60","right":"0","bottom":"50","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"0c56754","elType":"widget","settings":{"editor":"<p>%<\/p>","align":"center","text_color":"#FFFFFF","typography_typography":"custom","typography_font_family":"Popins","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":20,"sizes":[]},"_element_width":"auto","_position":"absolute","_offset_x":{"size":228,"unit":"px"},"_offset_y":{"size":62,"unit":"px"},"typography_font_size_mobile":{"unit":"px","size":40,"sizes":[]},"_offset_x_mobile":{"size":196,"unit":"px"},"_offset_y_mobile":{"size":50,"unit":"px"},"_offset_x_tablet":{"size":196,"unit":"px"},"_offset_y_tablet":{"size":69,"unit":"px"}},"elements":[],"widgetType":"text-editor"},{"id":"484e6de","elType":"widget","settings":{"editor":"<p>off<\/p>","align":"center","text_color":"#FFFFFF","typography_typography":"custom","typography_font_family":"Popins","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":20,"sizes":[]},"_element_width":"auto","_position":"absolute","_offset_x":{"size":200,"unit":"px"},"_offset_y":{"size":118,"unit":"px"},"typography_font_size_mobile":{"unit":"px","size":15,"sizes":[]},"_offset_x_mobile":{"size":168,"unit":"px"},"_offset_y_mobile":{"size":95,"unit":"px"},"typography_font_size_tablet":{"unit":"px","size":15,"sizes":[]},"typography_text_transform":"uppercase","_background_background":"classic","_background_color":"#E4EBF1","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":32},"_offset_x_tablet":{"size":169,"unit":"px"},"_offset_y_tablet":{"size":116,"unit":"px"}},"elements":[],"widgetType":"text-editor"},{"id":"fcb015c","elType":"widget","settings":{"title":"Book Early to Save","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"_z_index":1,"typography_font_size_mobile":{"unit":"px","size":20,"sizes":[]},"_margin_tablet":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"46ae0d6","elType":"widget","settings":{"editor":"<p>Enjoy 15% or more off stays between now and January 4, 2021<\/p>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":24,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"4fb895e","elType":"widget","settings":{"text":"Book Now","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":15,"sizes":[]},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":24,"sizes":[]},"background_color":"#FFFFFF","border_border":"solid","border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"border_radius":{"unit":"px","top":"5","right":"5","bottom":"5","left":"5","isLinked":true},"__globals__":{"button_text_color":"globals\/colors?id=accent","button_background_hover_color":"","hover_color":"","button_hover_border_color":""},"button_text_color":"#000000","text_padding":{"unit":"px","top":"13","right":"35","bottom":"13","left":"35","isLinked":false}},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false}],"menu-canvas-contact":[{"id":"6b92144","elType":"section","settings":{"layout":"full_width","gap":"no","z_index":9999,"html_tag":"div"},"elements":[{"id":"0bda5c7","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"bd78281","elType":"widget","settings":{"__dynamic__":{"image":"[elementor-tag id=\"\" name=\"site-logo\" settings=\"%7B%7D\"]","link":"[elementor-tag id=\"\" name=\"site-url\" settings=\"%7B%7D\"]"},"align":"center","width":{"unit":"px","size":130,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"35","left":"0","isLinked":false}},"elements":[],"widgetType":"theme-site-logo"},{"id":"abea76a","elType":"widget","settings":{"typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"25","left":"0","isLinked":false},"editor":"<p>Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in<\/p>","typography_font_weight":"400","typography_line_height":{"unit":"px","size":24,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"aea0fac","elType":"widget","settings":{"title":"Address\n","__globals__":{"title_color":"globals\/colors?id=accent"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":24,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"60d5a94","elType":"widget","settings":{"editor":"184 Mayfield St. Hopewell<br>Junction, NY 12533","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"59eac6e","elType":"widget","settings":{"title":"Phone\n","__globals__":{"title_color":"globals\/colors?id=accent"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":24,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"dc1f561","elType":"widget","settings":{"editor":"<p><a href=\"844-1755-44411\">+ 844 1755 - 444 11<\/a><\/p>","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"__globals__":{"text_color_link":"globals\/colors?id=text"}},"elements":[],"widgetType":"text-editor"},{"id":"46ae3c7","elType":"widget","settings":{"title":"Email","__globals__":{"title_color":"globals\/colors?id=accent"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":24,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"28d333b","elType":"widget","settings":{"editor":"<p><a href=\"mailto:contact@example.com\">contact@example.com<\/a><\/p>","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"25","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=primary"}},"elements":[],"widgetType":"text-editor"},{"id":"dd0007d","elType":"widget","settings":{"social_icon_list":[{"social_icon":{"value":"fab fa-facebook","library":"fa-brands"},"_id":"303fdf6","link":{"url":"http:\/\/facebook.com\/","is_external":"true","nofollow":"","custom_attributes":""}},{"social_icon":{"value":"fab fa-youtube","library":"fa-brands"},"_id":"670f76c","link":{"url":"http:\/\/Youtobe.com\/","is_external":"true","nofollow":"","custom_attributes":""}},{"social_icon":{"value":"fab fa-twitter","library":"fa-brands"},"_id":"30c653b","link":{"url":"http:\/\/Twitter.com\/","is_external":"true","nofollow":"","custom_attributes":""}},{"_id":"fb3ae22","social_icon":{"value":"fab fa-instagram","library":"fa-brands"},"link":{"url":"https:\/\/www.instagram.com\/","is_external":"true","nofollow":"","custom_attributes":""}}],"align":"left","icon_color":"custom","icon_primary_color":"#FFFFFF","icon_size":{"unit":"px","size":14,"sizes":[]},"icon_padding":{"unit":"em","size":1,"sizes":[]},"icon_spacing":{"unit":"px","size":8,"sizes":[]},"image_border_border":"solid","image_border_width":{"unit":"px","top":"2","right":"2","bottom":"2","left":"2","isLinked":true},"image_border_color":"#E3DCD7","border_radius":{"unit":"px","top":"25","right":"25","bottom":"25","left":"25","isLinked":true},"hover_primary_color":"#dc834e","__globals__":{"hover_primary_color":"globals\/colors?id=primary","icon_primary_color":"","icon_secondary_color":"globals\/colors?id=secondary","hover_border_color":"globals\/colors?id=primary"},"hover_secondary_color":"#FFFFFF"},"elements":[],"widgetType":"social-icons"}],"isInner":false}],"isInner":false}],"menu-canvas-handheld":[{"id":"00d23d9","elType":"section","settings":{"layout":"full_width","gap":"no","html_tag":"div"},"elements":[{"id":"fa82b26","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"5ed5f74","elType":"widget","settings":{"menu-style-content":"handheld"},"elements":[],"widgetType":"triply-nav-menu"}],"isInner":false}],"isInner":false}],"faq":[{"id":"12b7704","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/contact-img-1.png","id":897},"background_position":"top left","background_repeat":"no-repeat","background_size":"auto","background_motion_fx_motion_fx_scrolling":"yes","background_motion_fx_translateY_effect":"yes","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"60","right":0,"bottom":"60","left":0,"isLinked":false},"background_size_mobile":"initial","background_bg_width_mobile":{"unit":"px","size":0,"sizes":[]},"html_tag":"div"},"elements":[{"id":"bd24b47","elType":"column","settings":{"_column_size":50,"_inline_size":36,"space_between_widgets":0,"margin":{"unit":"px","top":"90","right":"30","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"70","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"0fd8c09","elType":"widget","settings":{"title":"Find Answers","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":-0.59999999999999997779553950749686919152736663818359375,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_font_size_tablet":{"unit":"px","size":40,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"11ce8bc","elType":"widget","settings":{"editor":"<p>Lorem ipsum dolor sit amet, consectetur adipiicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\/p>","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":30,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":-0.5,"sizes":[]}},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"ff966aa","elType":"column","settings":{"_column_size":50,"_inline_size":64,"space_between_widgets":0,"margin":{"unit":"px","top":"80","right":"50","bottom":"0","left":"50","isLinked":false},"margin_tablet":{"unit":"px","top":"70","right":"0","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"e786413","elType":"widget","settings":{"title":"Payment","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":60,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"6351e7b","elType":"widget","settings":{"tabs":[{"tab_title":"Are there any extra fees that I will have to pay on top of the listed price?","tab_content":"<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<\/p>","_id":"bc85e16"},{"tab_title":"Should I print a receipt to show the tour guide?","tab_content":"<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<\/p>","_id":"38fe25c"},{"tab_title":"How much does it cost to do a private tour?","tab_content":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.<\/p>","_id":"f3fcd8e"},{"tab_title":"What do I need to bring?","tab_content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.","_id":"5984d0f"}],"selected_icon":{"value":"far fa-question-circle","library":"fa-regular"},"selected_active_icon":{"value":"far fa-question-circle","library":"fa-regular"},"__globals__":{"title_color":"globals\/colors?id=accent","tab_active_color":"globals\/colors?id=accent","icon_active_color":"globals\/colors?id=primary","icon_color":"globals\/colors?id=primary"},"content_color":"#666666","style_theme":"yes","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":"","sizes":[]}},"elements":[],"widgetType":"accordion"},{"id":"e305e54","elType":"widget","settings":{"title":"Reservation","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":60,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"_margin":{"unit":"px","top":"10","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"46f431d","elType":"widget","settings":{"tabs":[{"tab_title":"Are there any extra fees that I will have to pay on top of the listed price?","tab_content":"<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<\/p>","_id":"bc85e16"},{"tab_title":"Should I print a receipt to show the tour guide?","tab_content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.","_id":"38fe25c"},{"tab_title":"How much does it cost to do a private tour?","tab_content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.","_id":"f3fcd8e"},{"tab_title":"What do I need to bring?","tab_content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.","_id":"5984d0f"}],"selected_icon":{"value":"far fa-question-circle","library":"fa-regular"},"selected_active_icon":{"value":"far fa-question-circle","library":"fa-regular"},"__globals__":{"title_color":"globals\/colors?id=accent","icon_active_color":"","icon_color":"globals\/colors?id=primary","content_typography_typography":"globals\/typography?id=primary"},"content_color":"#666666","style_theme":"yes","title_color":"#000000","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","icon_color":"#dc834e"},"elements":[],"widgetType":"accordion"},{"id":"8942d70","elType":"widget","settings":{"title":"Weather","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":60,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"_margin":{"unit":"px","top":"10","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"7e98683","elType":"widget","settings":{"tabs":[{"tab_title":"Are there any extra fees that I will have to pay on top of the listed price?","tab_content":"<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<\/p>","_id":"bc85e16"},{"tab_title":"Should I print a receipt to show the tour guide?","tab_content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.","_id":"38fe25c"},{"tab_title":"How much does it cost to do a private tour?","tab_content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.","_id":"f3fcd8e"},{"tab_title":"What do I need to bring?","tab_content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.","_id":"5984d0f"}],"selected_icon":{"value":"far fa-question-circle","library":"fa-regular"},"selected_active_icon":{"value":"far fa-question-circle","library":"fa-regular"},"__globals__":{"title_color":"globals\/colors?id=accent","icon_active_color":"","icon_color":"globals\/colors?id=primary"},"content_color":"#666666","style_theme":"yes","title_color":"#000000","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","icon_color":"#dc834e"},"elements":[],"widgetType":"accordion"}],"isInner":false}],"isInner":false}],"contact":[{"id":"ba60d02","elType":"section","settings":{"gap":"no","custom_height":{"unit":"px","size":640,"sizes":[]},"stretch_section":"section-stretched","structure":"20","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/contact-img-1.png","id":897},"background_position":"initial","background_repeat":"no-repeat","background_size":"auto","background_position_tablet":"bottom left","background_size_tablet":"contain","background_size_mobile":"initial","background_bg_width_mobile":{"unit":"px","size":0,"sizes":[]},"margin":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"40","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"40","right":0,"bottom":"20","left":0,"isLinked":false},"background_ypos":{"unit":"px","size":-120,"sizes":[]},"html_tag":"div"},"elements":[{"id":"f6ce288","elType":"column","settings":{"_column_size":50,"_inline_size":32.01599999999999823785401531495153903961181640625,"space_between_widgets":0,"_inline_size_tablet":50,"space_between_widgets_tablet":0,"background_background":"classic","background_color":"#FFFFFF","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"border_color":"#FFFFFF","border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"box_shadow_box_shadow_type":"yes","box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999999, 30.00000000000004, 98.00000000000004, 0.08)"},"margin":{"unit":"px","top":"100","right":"0","bottom":"140","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"80","right":"0","bottom":"150","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"padding":{"unit":"px","top":"50","right":"40","bottom":"40","left":"40","isLinked":false},"padding_tablet":{"unit":"px","top":"30","right":"30","bottom":"30","left":"30","isLinked":true},"__globals__":{"border_color":""}},"elements":[{"id":"31a400b","elType":"widget","settings":{"title_text":"Address","description_text":"184 Mayfield St. Hopewell <br>Junction, NY 12533","position":"left","icon_space":{"unit":"px","size":35,"sizes":[]},"title_bottom_space":{"unit":"px","size":10,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":12,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"description_typography_font_weight":"400","description_typography_line_height":{"unit":"px","size":24,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"_border_color":"#E5E5E5","__globals__":{"title_color":"globals\/colors?id=accent"},"selected_icon":{"value":"triply-icon- triply-icon-location-circle","library":"triply-icon"},"icon_space_mobile":{"unit":"px","size":20,"sizes":[]},"icon_size":{"unit":"px","size":30,"sizes":[]}},"elements":[],"widgetType":"icon-box"},{"id":"67a9c7a","elType":"widget","settings":{"title_text":"<a href=\"844180033355\" >+ 844 1800 - 333 55<\/a>","description_text":"<a href=\"844175544411\"  style=\"color:#000\"> + 844 1755 - 444 11<\/a>","position":"left","icon_space":{"unit":"px","size":35,"sizes":[]},"title_bottom_space":{"unit":"px","size":5,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"description_typography_font_weight":"500","description_typography_line_height":{"unit":"px","size":24,"sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"15","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"_border_color":"#E5E5E5","__globals__":{"title_color":"globals\/colors?id=accent","description_color":"globals\/colors?id=accent"},"selected_icon":{"value":"triply-icon- triply-icon-phone-rotary","library":"triply-icon"},"icon_space_mobile":{"unit":"px","size":20,"sizes":[]},"icon_size":{"unit":"px","size":30,"sizes":[]},"link":{"url":"844180033355","is_external":"","nofollow":"","custom_attributes":""},"title_color":"#000000"},"elements":[],"widgetType":"icon-box"},{"id":"50b3438","elType":"widget","settings":{"title_text":"Email","description_text":"<a href=\"mailto:contact@example.com\">contact@example.com<\/a>","position":"left","selected_icon":{"value":"triply-icon- triply-icon-envelope-open","library":"triply-icon"},"icon_space":{"unit":"px","size":35,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":18,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"description_typography_font_weight":"400","description_typography_line_height":{"unit":"px","size":24,"sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"30","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"_border_color":"#E5E5E5","__globals__":{"title_color":"globals\/colors?id=accent","description_color":"globals\/colors?id=primary"},"icon_space_mobile":{"unit":"px","size":20,"sizes":[]},"icon_size":{"unit":"px","size":30,"sizes":[]},"link":{"url":"mailto:contact@example.com","is_external":"","nofollow":"","custom_attributes":""}},"elements":[],"widgetType":"icon-box"},{"id":"5e98565","elType":"widget","settings":{"title_text":"Business Hours","description_text":"Mon- Sat: 10:00 AM - 20:00 PM","position":"left","icon_space":{"unit":"px","size":35,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":24,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"description_typography_font_weight":"400","description_typography_line_height":{"unit":"px","size":24,"sizes":[]},"_padding":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"_border_color":"#E5E5E5","__globals__":{"title_color":"globals\/colors?id=accent"},"selected_icon":{"value":"triply-icon- triply-icon-clock-time","library":"triply-icon"},"icon_space_mobile":{"unit":"px","size":20,"sizes":[]},"icon_size":{"unit":"px","size":30,"sizes":[]},"title_bottom_space":{"unit":"px","size":5,"sizes":[]},"description_typography_letter_spacing":{"unit":"px","size":-0.1000000000000000055511151231257827021181583404541015625,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"4c2fee1","elType":"column","settings":{"_column_size":50,"_inline_size":67.9839999999999946567186270840466022491455078125,"space_between_widgets":0,"_inline_size_tablet":50,"space_between_widgets_tablet":0,"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"70","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin":{"unit":"px","top":"100","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"80","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"align_tablet":"center"},"elements":[{"id":"bbf83b1","elType":"widget","settings":{"title":"Send us a message","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":30,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"68540e9","elType":"widget","settings":{"editor":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed\ndo eiusmod tempor incididunt.","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":24,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":450,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"ea152d8","elType":"widget","settings":{"form_name":"New Form","form_fields":[{"custom_id":"name","placeholder":"Your name *","_id":"f876f08"},{"custom_id":"email","field_type":"email","required":"true","placeholder":"Your email *","_id":"a8be177"},{"custom_id":"message","field_type":"textarea","placeholder":"Message","_id":"9913ef9","rows":6}],"button_align":"start","button_align_mobile":"center","step_next_label":"Next","step_previous_label":"Previous","button_text":"Submit","email_to":"admin@admin.com","email_subject":"New message from \"Triply\"","email_content":"[all-fields]","email_from":"email@dev.wpopal.com","email_from_name":"Triply","email_to_2":"admin@admin.com","email_subject_2":"New message from \"Triply\"","email_content_2":"[all-fields]","email_from_2":"email@dev.wpopal.com","email_from_name_2":"Triply","email_reply_to_2":"admin@admin.com","mailchimp_fields_map":[],"drip_fields_map":[],"activecampaign_fields_map":[],"getresponse_fields_map":[],"convertkit_fields_map":[],"mailerlite_fields_map":[],"success_message":"The form was sent successfully.","error_message":"An error occurred.","required_field_message":"This field is required.","invalid_message":"There\'s something wrong. The form is invalid.","row_gap":{"unit":"px","size":20,"sizes":[]},"field_typography_typography":"custom","field_typography_font_family":"Popins","field_typography_font_size":{"unit":"px","size":14,"sizes":[]},"field_typography_font_weight":"400","field_typography_line_height":{"unit":"px","size":30,"sizes":[]},"field_border_color":"#E6E6E6","field_border_width":{"unit":"px","top":"2","right":"2","bottom":"2","left":"2","isLinked":true},"field_border_radius":{"unit":"px","top":"3","right":"3","bottom":"3","left":"3","isLinked":true},"button_typography_typography":"custom","button_typography_font_family":"Popins","button_typography_font_size":{"unit":"px","size":14,"sizes":[]},"button_typography_font_weight":"bold","button_typography_line_height":{"unit":"px","size":18,"sizes":[]},"button_typography_letter_spacing":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"button_border_radius":{"unit":"px","top":"3","right":"3","bottom":"3","left":"3","isLinked":true},"button_text_padding":{"unit":"px","top":"16","right":"56","bottom":"16","left":"50","isLinked":false},"__globals__":{"label_color":"globals\/colors?id=accent","html_color":"globals\/colors?id=accent","button_background_color":"globals\/colors?id=primary","field_text_color":"globals\/colors?id=accent","button_background_hover_color":"globals\/colors?id=primary_hover","field_border_color_focus":"globals\/colors?id=primary"},"field_text_padding":{"unit":"px","top":"8","right":"0","bottom":"8","left":"15","isLinked":false},"button_background_color_style_2":{"unit":"px","top":"15","right":"55","bottom":"15","left":"55","isLinked":false},"column_gap":{"unit":"px","size":"","sizes":[]}},"elements":[],"widgetType":"form"}],"isInner":false}],"isInner":false},{"id":"6c39a1f","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"40","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"572432e","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"bfb0610","elType":"widget","settings":{"address":"London Eye, London, United Kingdom","height":{"unit":"px","size":500,"sizes":[]},"height_mobile":{"unit":"px","size":400,"sizes":[]}},"elements":[],"widgetType":"google_maps"}],"isInner":false}],"isInner":false}],"tourdetail_reviews":[{"id":"3132684","elType":"section","settings":{"gap":"no","html_tag":"div"},"elements":[{"id":"96c6c97","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"ba6175b","elType":"widget","settings":{"title":"Reviews","header_size":"h3","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"011b90d","elType":"widget","settings":[],"elements":[],"widgetType":"babe-item-stars-criteria"},{"id":"db4c641","elType":"widget","settings":{"_skin":"theme_comments"},"elements":[],"widgetType":"post-comments"}],"isInner":false}],"isInner":false}],"tourdetail_tourmap":[{"id":"1749214","elType":"section","settings":{"gap":"no","html_tag":"div"},"elements":[{"id":"4991115","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"e6cd0d7","elType":"widget","settings":{"map_height":{"unit":"px","size":500,"sizes":[]}},"elements":[],"widgetType":"babe-item-address-map"}],"isInner":false}],"isInner":false}],"about-us":[{"id":"0a9a6f3","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","padding":{"unit":"px","top":"0","right":"30","bottom":"95","left":"30","isLinked":false},"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_deco-1.png","id":776},"background_position":"top right","background_repeat":"no-repeat","padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin":{"unit":"px","top":"100","right":0,"bottom":"0","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"080","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"60","right":0,"bottom":"0","left":0,"isLinked":false},"background_size_mobile":"initial","background_bg_width_mobile":{"unit":"px","size":0,"sizes":[]},"padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"html_tag":"div"},"elements":[{"id":"8ac8314","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-1.1.png","id":736},"background_repeat":"no-repeat","background_position":"center left","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-2.png","id":724},"background_overlay_position":"bottom right","background_overlay_repeat":"no-repeat","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"background_position_tablet":"center center","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"background_xpos_mobile":{"unit":"%","size":18,"sizes":[]},"background_ypos_mobile":{"unit":"%","size":"","sizes":[]},"hide_mobile":"hidden-phone"},"elements":[{"id":"636f8b6","elType":"widget","settings":{"space":{"unit":"px","size":650,"sizes":[]},"space_tablet":{"unit":"px","size":600,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"0c250bd","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-2.png","id":724},"image_size":"full","motion_fx_motion_fx_scrolling":"yes","motion_fx_translateY_effect":"yes","motion_fx_translateY_direction":"negative","motion_fx_translateY_speed":{"unit":"px","size":0.5,"sizes":[]},"_element_width":"auto","_position":"absolute","_offset_orientation_h":"end","_offset_x":{"size":"","unit":"%"},"_offset_x_end":{"size":0,"unit":"%"},"_offset_orientation_v":"end","_offset_y":{"size":"","unit":"%"},"_offset_y_end":{"size":3.254000000000000003552713678800500929355621337890625,"unit":"%"},"motion_fx_devices":["desktop","tablet"],"align_mobile":"center","_offset_y_end_tablet":{"unit":"%","size":"","sizes":[]},"_offset_y_end_mobile":{"unit":"%","size":"","sizes":[]}},"elements":[],"widgetType":"image"}],"isInner":false},{"id":"208b2bf","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"80","isLinked":false},"align_mobile":"center","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"1ae440c","elType":"widget","settings":{"editor":"<div>About<\/div>","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"},"align_mobile":"center","_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"text-editor"},{"id":"c67547a","elType":"widget","settings":{"title":"We Help You\nPlanning Your\nJourney","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":-0.5,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"25","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":340,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center","typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"heading"},{"id":"a123a2f","elType":"widget","settings":{"editor":"<div>Lorem ipsum dolor sit amet, consectetur adipiicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\/div>\n<div style=\"height: 10px;\"><\/div>\n<div>Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"35","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":415,"sizes":[]},"align_mobile":"center","__globals__":{"text_color":"globals\/colors?id=text"},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"text-editor"},{"id":"221219a","elType":"widget","settings":{"text":"Learn More","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"button_text_color":"#202F59","background_color":"#00000000","hover_color":"#FFFFFF","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"border_radius":{"unit":"px","top":"5","right":"5","bottom":"5","left":"5","isLinked":true},"text_padding":{"unit":"px","top":"15","right":"30","bottom":"15","left":"30","isLinked":false},"__globals__":{"border_color":"globals\/colors?id=accent","button_background_hover_color":"globals\/colors?id=primary","button_hover_border_color":"globals\/colors?id=primary"},"align_mobile":"center","_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false},{"id":"bb4666f","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color":"#F9F4F0","padding":{"unit":"px","top":"110","right":"30","bottom":"140","left":"30","isLinked":false},"background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_deco-2.png","id":1218},"background_position":"bottom left","background_repeat":"no-repeat","margin_mobile":{"unit":"px","top":"60","right":0,"bottom":"0","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"80","right":"30","bottom":"80","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"15","bottom":"60","left":"15","isLinked":false},"background_size_mobile":"initial","background_bg_width_mobile":{"unit":"px","size":0,"sizes":[]},"html_tag":"div"},"elements":[{"id":"9e21387","elType":"column","settings":{"_column_size":100,"_inline_size":null,"align":"center","space_between_widgets":0},"elements":[{"id":"69a7e83","elType":"widget","settings":{"editor":"<div>Why us<\/div>","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0.5,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"},"align_mobile":"center","_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"text-editor"},{"id":"b8cc704","elType":"widget","settings":{"title":"We Make All The\nProcess Easy","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":-0.5,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":410,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center","typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"heading"},{"id":"c659ab9","elType":"section","settings":{"gap":"no","structure":"30","content_width":{"unit":"px","size":1320,"sizes":[]},"html_tag":"div"},"elements":[{"id":"b9dd08f","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"animation":"opal-move-up","animation_duration":"fast","animation_delay":250,"align_mobile":"center"},"elements":[{"id":"2677ccf","elType":"widget","settings":{"title_text":"Best Travel Agent","description_text":"The generated Lorem Ipsum is therefore always free from repetition available","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"position":"left","_background_background":"classic","_background_color":"#02010100","selected_icon":{"value":"triply-icon- triply-icon-best-travel","library":"triply-icon"},"view":"stacked","primary_color":"#FFFFFF","hover_secondary_color":"#FFFFFF","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_size":{"unit":"px","size":40,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"__globals__":{"secondary_color":"globals\/colors?id=primary","title_color":"globals\/colors?id=accent","hover_primary_color":"globals\/colors?id=primary"},"icon_space_mobile":{"unit":"px","size":5,"sizes":[]},"text_align_mobile":"center","_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"35","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"65","left":"0","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":385,"sizes":[]}},"elements":[],"widgetType":"icon-box"},{"id":"51b1b87","elType":"widget","settings":{"title_text":"Beautiful Places","description_text":"The generated Lorem Ipsum is therefore always free from repetition","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"position":"left","_background_background":"classic","_background_color":"#02010100","selected_icon":{"value":"triply-icon- triply-icon-places","library":"triply-icon"},"view":"stacked","primary_color":"#FFFFFF","hover_secondary_color":"#FFFFFF","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_size":{"unit":"px","size":40,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"__globals__":{"secondary_color":"globals\/colors?id=primary","title_color":"globals\/colors?id=accent","hover_primary_color":"globals\/colors?id=primary"},"icon_space_mobile":{"unit":"px","size":5,"sizes":[]},"text_align_mobile":"center","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":385,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"6258897","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"35","right":"0","bottom":"0","left":"0","isLinked":false},"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"animation":"opal-move-up","animation_duration":"fast","animation_delay":350,"align_mobile":"center"},"elements":[{"id":"fee6783","elType":"widget","settings":{"title_text":"Trust & Safety","description_text":"There are many variations of passages of Lorem Ipsum available you available","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"position":"left","_background_background":"classic","_background_color":"#02010100","selected_icon":{"value":"triply-icon- triply-icon-safety","library":"triply-icon"},"view":"stacked","primary_color":"#FFFFFF","hover_secondary_color":"#FFFFFF","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_size":{"unit":"px","size":40,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"__globals__":{"secondary_color":"globals\/colors?id=primary","title_color":"globals\/colors?id=accent","hover_primary_color":"globals\/colors?id=primary"},"icon_space_mobile":{"unit":"px","size":5,"sizes":[]},"text_align_mobile":"center","_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"35","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"65","left":"0","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":385,"sizes":[]}},"elements":[],"widgetType":"icon-box"},{"id":"ee5d6e9","elType":"widget","settings":{"title_text":"Passionate Travel","description_text":"There are many variations of passages of Lorem Ipsum available","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"position":"left","_background_background":"classic","_background_color":"#02010100","selected_icon":{"value":"triply-icon- triply-icon-passionate-travel","library":"triply-icon"},"view":"stacked","primary_color":"#FFFFFF","hover_secondary_color":"#FFFFFF","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_size":{"unit":"px","size":40,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"__globals__":{"secondary_color":"globals\/colors?id=primary","title_color":"globals\/colors?id=accent","hover_primary_color":"globals\/colors?id=primary"},"icon_space_mobile":{"unit":"px","size":5,"sizes":[]},"text_align_mobile":"center","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":385,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"e0cf493","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"35","right":"0","bottom":"0","left":"0","isLinked":false},"align_mobile":"center","margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"animation":"opal-move-up","animation_duration":"fast","animation_delay":450},"elements":[{"id":"91e272d","elType":"widget","settings":{"title_text":"Best Price Guarantee","description_text":"All the Lorem Ipsum generators on the\nInternet  need ","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"position":"left","_background_background":"classic","_background_color":"#02010100","selected_icon":{"value":"triply-icon- triply-icon-best-price","library":"triply-icon"},"view":"stacked","primary_color":"#FFFFFF","hover_secondary_color":"#FFFFFF","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_size":{"unit":"px","size":40,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"__globals__":{"secondary_color":"globals\/colors?id=primary","title_color":"globals\/colors?id=accent","hover_primary_color":"globals\/colors?id=primary"},"icon_space_mobile":{"unit":"px","size":5,"sizes":[]},"text_align_mobile":"center","_margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_element_width_tablet":"initial","_element_width_mobile":"initial","_element_custom_width_tablet":{"unit":"%","size":50,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"65","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_element_custom_width_mobile":{"unit":"px","size":385,"sizes":[]}},"elements":[],"widgetType":"icon-box"},{"id":"bb2ad0a","elType":"widget","settings":{"title_text":"Fast Booking","description_text":"If you are going to use a passage of Lorem Ipsum, you need ","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"position":"left","_background_background":"classic","_background_color":"#02010100","selected_icon":{"value":"triply-icon- triply-icon-fast-booking","library":"triply-icon"},"view":"stacked","primary_color":"#FFFFFF","hover_secondary_color":"#FFFFFF","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_size":{"unit":"px","size":40,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"__globals__":{"secondary_color":"globals\/colors?id=primary","title_color":"globals\/colors?id=accent","hover_primary_color":"globals\/colors?id=primary"},"icon_space_mobile":{"unit":"px","size":5,"sizes":[]},"text_align_mobile":"center","_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"_margin_mobile":{"unit":"px","top":"35","right":"0","bottom":"0","left":"0","isLinked":false},"_element_width_tablet":"initial","_element_width_mobile":"initial","_element_custom_width_tablet":{"unit":"%","size":50,"sizes":[]},"_element_custom_width_mobile":{"unit":"px","size":385,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"d34eb72","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":340,"sizes":[]},"stretch_section":"section-stretched","structure":"40","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h2_bg-1.jpg","id":2135},"background_position":"center center","background_size":"cover","background_motion_fx_motion_fx_scrolling":"yes","background_motion_fx_translateY_effect":"yes","background_motion_fx_devices":["desktop","tablet"],"background_overlay_background":"classic","background_overlay_color":"#202F59","background_overlay_opacity":{"unit":"px","size":0.59999999999999997779553950749686919152736663818359375,"sizes":[]},"margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"margin_tablet":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding":{"unit":"px","top":"80","right":"30","bottom":"80","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"0","bottom":"60","left":"0","isLinked":false},"content_width":{"unit":"px","size":1320,"sizes":[]},"html_tag":"div"},"elements":[{"id":"4ec4321","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"space_between_widgets":0,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"animation":"opal-move-up","animation_duration":"fast","animation_delay":250},"elements":[{"id":"7437d1d","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-destination","library":"triply-icon"},"primary_color":"#FFFFFF","size":{"unit":"px","size":80,"sizes":[]},"size_mobile":{"unit":"px","size":60,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"animation_duration":"fast"},"elements":[],"widgetType":"icon"},{"id":"a234b53","elType":"widget","settings":{"starting_number":100,"ending_number":154,"title":"","number_color":"#FFFFFF","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":60,"sizes":[]},"typography_number_font_size_tablet":{"unit":"px","size":56,"sizes":[]},"animation_duration":"fast"},"elements":[],"widgetType":"counter"},{"id":"c8413a3","elType":"widget","settings":{"editor":"Destinations","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"},"animation_duration":"fast"},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"4629a25","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"space_between_widgets":0,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"animation":"opal-move-up","animation_duration":"fast","animation_delay":350},"elements":[{"id":"e53f16d","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-tours","library":"triply-icon"},"primary_color":"#FFFFFF","size":{"unit":"px","size":80,"sizes":[]},"size_mobile":{"unit":"px","size":60,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"icon"},{"id":"3032992","elType":"widget","settings":{"starting_number":2100,"ending_number":2165,"title":"","number_color":"#FFFFFF","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":60,"sizes":[]},"typography_number_font_size_tablet":{"unit":"px","size":56,"sizes":[]}},"elements":[],"widgetType":"counter"},{"id":"7fc1dd5","elType":"widget","settings":{"editor":"Amazing tours","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"}},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"f8b5796","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"space_between_widgets":0,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"animation":"opal-move-up","animation_duration":"fast","animation_delay":450},"elements":[{"id":"4d2fc59","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-types","library":"triply-icon"},"primary_color":"#FFFFFF","size":{"unit":"px","size":80,"sizes":[]},"size_mobile":{"unit":"px","size":60,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"icon"},{"id":"16f26f4","elType":"widget","settings":{"starting_number":"","ending_number":98,"title":"","number_color":"#FFFFFF","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":60,"sizes":[]},"typography_number_font_size_tablet":{"unit":"px","size":56,"sizes":[]}},"elements":[],"widgetType":"counter"},{"id":"b4a12fd","elType":"widget","settings":{"editor":"Tour types","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"}},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"c27972c","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"animation":"opal-move-up","animation_duration":"fast","animation_delay":550},"elements":[{"id":"e65e932","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-happy","library":"triply-icon"},"primary_color":"#FFFFFF","size":{"unit":"px","size":80,"sizes":[]},"size_mobile":{"unit":"px","size":60,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"icon"},{"id":"8aa9855","elType":"widget","settings":{"starting_number":117200,"ending_number":117259,"title":"","number_color":"#FFFFFF","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":60,"sizes":[]},"typography_number_font_size_tablet":{"unit":"px","size":56,"sizes":[]}},"elements":[],"widgetType":"counter"},{"id":"744e9a3","elType":"widget","settings":{"editor":"Happy customers","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"}},"elements":[],"widgetType":"text-editor"}],"isInner":false}],"isInner":false},{"id":"90cdf4a","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"60","right":0,"bottom":"0","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin":{"unit":"px","top":"100","right":0,"bottom":"0","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"80","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"2146f77","elType":"column","settings":{"_column_size":100,"_inline_size":null,"align":"center","space_between_widgets":0},"elements":[{"id":"081732e","elType":"widget","settings":{"editor":"<div>Our team<\/div>","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"},"align_mobile":"center","_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"text-editor"},{"id":"baba6a0","elType":"widget","settings":{"title":"Meet The Team","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":-0.5,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_element_custom_width":{"unit":"px","size":410,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center","typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"heading"}],"isInner":false}],"isInner":false},{"id":"4c0e699","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"40","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"content_width":{"unit":"px","size":1320,"sizes":[]},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"ab8f7bb","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"align_mobile":"center"},"elements":[{"id":"80c2656","elType":"widget","settings":{"name":"Adam Johnson","job":"CEO, Founder","instagram":"https:\/\/plus.google.com\/u\/0\/+WPOpal","twitter":"https:\/\/twitter.com\/opalwordpress","facebook":"https:\/\/www.facebook.com\/opalwordpress","youtube":"https:\/\/www.youtube.com\/user\/WPOpalTheme","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-2-2.jpg","id":2728},"_element_width_mobile":"initial","_element_custom_width_tablet":{"unit":"px","size":327,"sizes":[]},"_element_custom_width_mobile":{"unit":"px","size":315,"sizes":[]},"_animation":"opal-move-up","animation_duration":"fast","_animation_delay":250},"elements":[],"widgetType":"triply-team-box"}],"isInner":false},{"id":"c2c8d84","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"align_mobile":"center"},"elements":[{"id":"993fa32","elType":"widget","settings":{"name":"Kevin D.","job":"Marketing","instagram":"https:\/\/plus.google.com\/u\/0\/+WPOpal","twitter":"https:\/\/twitter.com\/opalwordpress","facebook":"https:\/\/www.facebook.com\/opalwordpress","youtube":"https:\/\/www.youtube.com\/user\/WPOpalTheme","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-3-2.jpg","id":2729},"_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":315,"sizes":[]},"_animation":"opal-move-up","animation_duration":"fast","_animation_delay":350},"elements":[],"widgetType":"triply-team-box"}],"isInner":false},{"id":"6d29ba0","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"40","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"align_mobile":"center"},"elements":[{"id":"58210c4","elType":"widget","settings":{"name":"Frank L.","job":"Designer","instagram":"https:\/\/plus.google.com\/u\/0\/+WPOpal","twitter":"https:\/\/twitter.com\/opalwordpress","facebook":"https:\/\/www.facebook.com\/opalwordpress","youtube":"https:\/\/www.youtube.com\/user\/WPOpalTheme","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-4-2.jpg","id":2730},"_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":315,"sizes":[]},"_animation":"opal-move-up","animation_duration":"fast","_animation_delay":450},"elements":[],"widgetType":"triply-team-box"}],"isInner":false},{"id":"9f4e7c6","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"40","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"align_mobile":"center"},"elements":[{"id":"ecf5f76","elType":"widget","settings":{"name":"Alena Doe","job":"Support","instagram":"https:\/\/plus.google.com\/u\/0\/+WPOpal","twitter":"https:\/\/twitter.com\/opalwordpress","facebook":"https:\/\/www.facebook.com\/opalwordpress","youtube":"https:\/\/www.youtube.com\/user\/WPOpalTheme","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-5-2.jpg","id":2731},"_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":315,"sizes":[]},"_animation":"opal-move-up","animation_duration":"fast","_animation_delay":550},"elements":[],"widgetType":"triply-team-box"}],"isInner":false}],"isInner":false},{"id":"5ec7d07","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin":{"unit":"px","top":"50","right":0,"bottom":"145","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"80","right":0,"bottom":"100","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"60","right":0,"bottom":"65","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"830cef8","elType":"column","settings":{"_column_size":100,"_inline_size":null,"align":"center","space_between_widgets":0,"space_between_widgets_tablet":0},"elements":[{"id":"bd6236c","elType":"widget","settings":{"editor":"<div>Testimonials<\/div>","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":-0.5,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"},"align_mobile":"center","_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"text-editor"},{"id":"fd53318","elType":"widget","settings":{"title":"Customer Reviews","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":-0.5,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"35","left":"0","isLinked":false},"_element_custom_width":{"unit":"px","size":410,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center","typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"heading"},{"id":"d14dc93","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_quote-1.png","id":2016},"image_size":"full","align":"left","_element_width":"initial","_element_custom_width":{"unit":"%","size":17,"sizes":[]},"_element_custom_width_tablet":{"unit":"%","size":14,"sizes":[]},"_element_width_tablet":"initial","hide_mobile":"hidden-phone","_animation":"opal-move-right","animation_duration":"fast"},"elements":[],"widgetType":"image"},{"id":"ddb3ca6","elType":"widget","settings":{"testimonials":[{"testimonial_rating":5,"testimonial_content":"\u201cThis was an amazing trip! There were so many highlights... our outstanding, kind, patient, amazing leader Gustavo!! What an absolute saint. He was so organized and\u201d ","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h3-img-box-1.png","id":2117},"testimonial_name":"Melisa Joan H.","testimonial_job":" New York, USA","_id":"87f87d2","testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"}},{"testimonial_rating":5,"testimonial_content":"\"Needless to say we are extremely satisfied with the results. Booking tour was the best investment I ever made. Nice work on your booking tour. Booking tour impressed.\"","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-4-2.jpg","id":2730},"testimonial_name":"Roselin D.","testimonial_job":" New York, USA","testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"},"_id":"cadac67"},{"testimonial_rating":5,"testimonial_content":"\"Great job, I will definitely be ordering again! After using booking tour my business skyrocketed! Man, this thing is getting better and better as I learn more about it. \"","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-5-2.jpg","id":2731},"testimonial_name":"Cleveland A.","testimonial_job":" New York, USA","testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"},"_id":"3d47fe4"}],"column":"1","content_typography_line_height":{"unit":"px","size":"","sizes":[]},"enable_carousel":"yes","_element_width":"initial","_element_custom_width":{"unit":"%","size":66,"sizes":[]},"content_typography_typography":"custom","content_typography_font_size_tablet":{"unit":"px","size":22,"sizes":[]},"content_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"_element_width_tablet":"initial","_element_width_mobile":"inherit","_element_custom_width_tablet":{"unit":"%","size":69,"sizes":[]},"testimonial_rating_spacing":{"unit":"px","size":15,"sizes":[]},"dots_vertical_value":{"unit":"%","size":-29,"sizes":[]},"dots_vertical_value_mobile":{"unit":"%","size":-18,"sizes":[]},"_margin":{"unit":"px","top":"15","right":"0","bottom":"0","left":"0","isLinked":false},"dots_vertical_value_tablet":{"unit":"%","size":-20,"sizes":[]},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"triply-testimonials"},{"id":"05be521","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_quote-2.png","id":2017},"image_size":"full","align":"right","_element_width":"initial","_element_custom_width":{"unit":"%","size":17,"sizes":[]},"_element_custom_width_tablet":{"unit":"%","size":14,"sizes":[]},"_element_width_tablet":"initial","hide_mobile":"hidden-phone","_animation":"opal-move-left","animation_duration":"fast"},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false}],"tourdetail_tourplan":[{"id":"655bfba","elType":"section","settings":{"gap":"no","html_tag":"div"},"elements":[{"id":"183fe21","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"15e36a9","elType":"widget","settings":{"enable_title":"","title":"Add Your Heading Text Here"},"elements":[],"widgetType":"babe-item-steps"}],"isInner":false}],"isInner":false}],"tourdetail_description":[{"id":"b7e6318","elType":"section","settings":{"gap":"no","html_tag":"div"},"elements":[{"id":"57886e3","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"04d825c","elType":"widget","settings":{"title":"Overview","header_size":"h3","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"ec487b1","elType":"widget","settings":{"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-content"},{"id":"bb99b69","elType":"widget","settings":{"text":"Divider","color":"#E8E8E8","gap":{"unit":"px","size":10,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"divider"},{"id":"8092094","elType":"widget","settings":{"title":"Included\/Excluded ","header_size":"h3","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"be83ef1","elType":"widget","settings":{"icon":{"value":"far fa-check-circle","library":"fa-regular"},"icon_size":{"unit":"px","size":15,"sizes":[]},"icon_color":"#2EA452","_margin":{"unit":"px","top":"0","right":"30","bottom":"8","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":440,"sizes":[]},"item_space":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"babe-item-included"},{"id":"9415adb","elType":"widget","settings":{"select":"excluded","icon":{"value":"far fa-times-circle","library":"fa-regular"},"icon_color":"#EF2A38","_element_width":"auto","item_space":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"babe-item-included"}],"isInner":false}],"isInner":false}],"footerbuilder-1":[{"id":"1f3d631","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":200,"sizes":[]},"stretch_section":"section-stretched","structure":"20","background_background":"classic","background_color":"#F9F4F0","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/footer-1.png","id":1422},"background_position":"center center","background_repeat":"no-repeat","background_size":"auto","border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"8edfdfa","elType":"column","settings":{"_column_size":50,"_inline_size":78,"space_between_widgets":0,"_inline_size_tablet":65,"content_position":"center","padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"440c3f0","elType":"widget","settings":{"editor":"<p>Don\u2019t wait any longer. Contact us!<\/p>","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":"","sizes":[]},"align_mobile":"center","__globals__":{"text_color":"globals\/colors?id=lighter"}},"elements":[],"widgetType":"text-editor"},{"id":"90403aa","elType":"section","settings":{"gap":"no","structure":"20","html_tag":"div"},"elements":[{"id":"08ad1c6","elType":"column","settings":{"_column_size":50,"_inline_size":50,"space_between_widgets":0,"_inline_size_tablet":100,"space_between_widgets_tablet":0,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"content_position":"center"},"elements":[{"id":"3332712","elType":"widget","settings":{"icon_list":[{"text":"+(84) 1800 - 333 5578","selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/12\/phone_2.svg","id":5675},"library":"svg"},"_id":"da8c54e","link":{"url":"tel:1800 - 333 5578","is_external":"","nofollow":"","custom_attributes":""}}],"icon_size":{"unit":"px","size":35,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":30,"sizes":[]},"icon_typography_font_weight":"bold","icon_typography_line_height":{"unit":"px","size":20,"sizes":[]},"__globals__":{"text_color_hover":"globals\/colors?id=primary"},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"icon_typography_font_size_mobile":{"unit":"px","size":20,"sizes":[]},"text_indent":{"unit":"px","size":10,"sizes":[]},"icon_align_mobile":"center","space_between_mobile":{"unit":"px","size":0,"sizes":[]},"icon_size_tablet":{"unit":"px","size":20,"sizes":[]},"icon_typography_font_size_tablet":{"unit":"px","size":20,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"icon-list"}],"isInner":true},{"id":"01218b3","elType":"column","settings":{"_column_size":50,"_inline_size":50.0030000000000001136868377216160297393798828125,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"content_position":"center"},"elements":[{"id":"a614651","elType":"widget","settings":{"icon_list":[{"text":"support@example.com","selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/12\/email.svg","id":5673},"library":"svg"},"_id":"da8c54e","link":{"url":"support@example.com","is_external":"","nofollow":"","custom_attributes":""}}],"icon_size":{"unit":"px","size":35,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":30,"sizes":[]},"icon_typography_font_weight":"bold","icon_typography_line_height":{"unit":"px","size":20,"sizes":[]},"__globals__":{"text_color_hover":"globals\/colors?id=primary"},"icon_typography_font_size_mobile":{"unit":"px","size":20,"sizes":[]},"text_indent":{"unit":"px","size":10,"sizes":[]},"icon_align_mobile":"center","space_between_mobile":{"unit":"px","size":0,"sizes":[]},"icon_size_tablet":{"unit":"px","size":20,"sizes":[]},"icon_typography_font_size_tablet":{"unit":"px","size":20,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"icon-list"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"38bbddd","elType":"column","settings":{"_column_size":50,"_inline_size":21.9609999999999985220711096189916133880615234375,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"25","isLinked":false},"_inline_size_tablet":35,"content_position":"center","content_position_tablet":"top","space_between_widgets_tablet":0,"padding_mobile":{"unit":"px","top":"20","right":"0","bottom":"30","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"169422b","elType":"widget","settings":{"editor":"<p>Follow us<\/p>","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":"","sizes":[]},"align_mobile":"center","__globals__":{"text_color":"globals\/colors?id=lighter"}},"elements":[],"widgetType":"text-editor"},{"id":"f31eebe","elType":"widget","settings":{"social_icon_list":[{"social_icon":{"value":"fab fa-facebook","library":"fa-brands"},"_id":"b01496a","link":{"url":"https:\/\/www.facebook.com\/","is_external":"true","nofollow":"","custom_attributes":""}},{"social_icon":{"value":"fab fa-youtube","library":"fa-brands"},"_id":"0a6b8cf","link":{"url":"https:\/\/www.youtobe.com\/","is_external":"true","nofollow":"","custom_attributes":""}},{"social_icon":{"value":"fab fa-twitter","library":"fa-brands"},"_id":"c449f90","link":{"url":"https:\/\/www.twitter.com\/","is_external":"true","nofollow":"","custom_attributes":""}},{"_id":"405df7a","social_icon":{"value":"fab fa-instagram","library":"fa-brands"},"link":{"url":"https:\/\/www.Instagram.com\/","is_external":"true","nofollow":"","custom_attributes":""}}],"align":"left","icon_color":"custom","icon_primary_color":"#FFFFFF","icon_secondary_color":"#186367","icon_size":{"unit":"px","size":15,"sizes":[]},"icon_padding":{"unit":"em","size":0.8000000000000000444089209850062616169452667236328125,"sizes":[]},"icon_spacing":{"unit":"px","size":10,"sizes":[]},"image_border_border":"solid","image_border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"image_border_color":"#E3DCD7","border_radius":{"unit":"px","top":"25","right":"25","bottom":"25","left":"25","isLinked":true},"__globals__":{"icon_primary_color":"","icon_secondary_color":"globals\/colors?id=secondary","image_border_color":"","hover_secondary_color":"","hover_border_color":"","hover_primary_color":"globals\/colors?id=primary"},"hover_primary_color":"#F36E3E","align_mobile":"center","row_gap":{"unit":"px","size":10,"sizes":[]},"hover_secondary_color":"#FFFFFF"},"elements":[],"widgetType":"social-icons"}],"isInner":false}],"isInner":false},{"id":"a79a172","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":450,"sizes":[]},"structure":"40","background_background":"classic","background_color":"#202F59","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"padding_tablet":{"unit":"px","top":"10","right":"30","bottom":"10","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"5d41d57","elType":"column","settings":{"_column_size":25,"_inline_size":30,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"015","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"padding":{"unit":"px","top":"0","right":"50","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"20","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"20","left":"0","isLinked":false}},"elements":[{"id":"167b519","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/logo-white.svg","id":1414},"image_size":"full","align":"left","_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/","is_external":"","nofollow":"","custom_attributes":""},"width":{"unit":"px","size":130,"sizes":[]},"align_tablet":"center","_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"__dynamic__":{"link":"[elementor-tag id=\"7714d8a\" name=\"site-url\" settings=\"%7B%7D\"]"}},"elements":[],"widgetType":"image"},{"id":"c57d268","elType":"widget","settings":{"editor":"<p>Nisi ut aliquip ex ea commodo consequatute irure dolor in reprehenderit in voluptatevelit esse cillum dolore eu fugiat nulla\u00a0 excepteur pariatur.<\/p>","text_color":"#9CA2B1","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":24,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"cde6e0c","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-map-marker-alt","library":"triply-icon"},"title_text":"754 West Gartner Street","description_text":"Encino, CA 91316","position":"left","primary_color":"#4D597A","icon_size":{"unit":"px","size":40,"sizes":[]},"title_bottom_space":{"unit":"px","size":4,"sizes":[]},"title_color":"#FFFFFF","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_typography_font_weight":"400","title_typography_line_height":{"unit":"px","size":15,"sizes":[]},"description_color":"#FFFFFF","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"description_typography_font_weight":"400","description_typography_line_height":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"-5","isLinked":false},"_background_background":"classic","_background_color":"#02010100","__globals__":{"primary_color":"","hover_primary_color":""},"text_align_mobile":"center","_element_width_tablet":"initial","_element_width_mobile":"inherit","_element_custom_width_tablet":{"unit":"%","size":50,"sizes":[]}},"elements":[],"widgetType":"icon-box"},{"id":"74793d4","elType":"widget","settings":{"text":"View Map","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":20,"sizes":[]},"background_color":"#FFFFFF","text_padding":{"unit":"px","top":"10","right":"15","bottom":"10","left":"15","isLinked":false},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"50","isLinked":false},"__globals__":{"button_text_color":"globals\/colors?id=accent","hover_color":"","button_background_hover_color":"globals\/colors?id=primary"},"button_text_color":"#000000","hover_color":"#FFFFFF","button_background_hover_color":"#F36E3E","border_radius":{"unit":"px","top":"5","right":"5","bottom":"5","left":"5","isLinked":true},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_element_width_tablet":"initial","_element_width_mobile":"inherit","_element_custom_width_tablet":{"unit":"%","size":50,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":false},{"id":"b078745","elType":"column","settings":{"_column_size":25,"_inline_size":25,"space_between_widgets":0,"_inline_size_tablet":30,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"44","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_mobile":50},"elements":[{"id":"fe05c11","elType":"widget","settings":{"title":"Our Services","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":20,"sizes":[]},"_margin":{"unit":"px","top":"15","right":"0","bottom":"40","left":"0","isLinked":false},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"20","right":"0","bottom":"10","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"587ada8","elType":"widget","settings":{"icon_list":[{"text":"Booking","selected_icon":{"value":"","library":""},"_id":"f6ed13c","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/to_book\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"RentalCar","selected_icon":{"value":"","library":""},"_id":"b04db6a","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/categories\/car\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"HostelWorld","selected_icon":{"value":"","library":""},"_id":"66087f5","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/categories\/hostel\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Trivago","selected_icon":{"value":"","library":""},"_id":"8670e99","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/categories\/hostel\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"TripAdvisor","selected_icon":{"value":"","library":""},"_id":"4d11ce5","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/categories\/hotel\/","is_external":"","nofollow":"","custom_attributes":""}}],"space_between":{"unit":"px","size":16,"sizes":[]},"text_color":"#9CA2B1","icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_font_weight":"400","icon_typography_line_height":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color":"","text_color_hover":"globals\/colors?id=primary"},"view":"","icon_align_mobile":"center","space_between_mobile":{"unit":"px","size":10,"sizes":[]},"space_between_tablet":{"unit":"px","size":5,"sizes":[]},"text_indent":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"615b567","elType":"column","settings":{"_column_size":25,"_inline_size":19.7530000000000001136868377216160297393798828125,"space_between_widgets":0,"_inline_size_tablet":30,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_inline_size_mobile":50},"elements":[{"id":"adc26a4","elType":"widget","settings":{"title":"Explore","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":20,"sizes":[]},"_margin":{"unit":"px","top":"15","right":"0","bottom":"40","left":"0","isLinked":false},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"20","right":"0","bottom":"10","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"fca3346","elType":"widget","settings":{"icon_list":[{"text":"Madrid Tour","selected_icon":{"value":"","library":""},"_id":"f6ed13c","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/categories\/one-time-event\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Stockholm City","selected_icon":{"value":"","library":""},"_id":"b04db6a","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/categories\/tour\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Roma City","selected_icon":{"value":"","library":""},"_id":"66087f5","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/categories\/one-time-event\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Shanghai City","selected_icon":{"value":"","library":""},"_id":"8670e99","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/categories\/tour\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Tokyo","selected_icon":{"value":"","library":""},"_id":"4d11ce5","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/categories\/one-time-event\/","is_external":"","nofollow":"","custom_attributes":""}}],"space_between":{"unit":"px","size":16,"sizes":[]},"text_color":"#9CA2B1","icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_font_weight":"400","icon_typography_line_height":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color":"","text_color_hover":"globals\/colors?id=primary"},"icon_align_mobile":"center","space_between_mobile":{"unit":"px","size":10,"sizes":[]},"space_between_tablet":{"unit":"px","size":5,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"4da2fe6","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"_inline_size_tablet":40,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"20","right":"0","bottom":"20","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"015","isLinked":false}},"elements":[{"id":"b3c86b6","elType":"widget","settings":{"title":"Get Updates & More","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":20,"sizes":[]},"_margin":{"unit":"px","top":"15","right":"0","bottom":"40","left":"0","isLinked":false},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"10","right":"0","bottom":"20","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"c4a1cfc","elType":"widget","settings":{"editor":"<p>Subscribe to the free newsletter and stay up to date<\/p>","text_color":"#9CA2B1","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":24,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"fff09f5","elType":"widget","settings":{"form_name":"New Form","form_fields":[{"custom_id":"email","field_type":"email","required":"true","placeholder":"Your email","_id":"0d9a192","width_tablet":"60","width_mobile":"60"}],"step_next_label":"Next","step_previous_label":"Previous","button_text":"Subscribe","selected_button_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"button_icon_align":"right","button_icon_indent":{"unit":"px","size":10,"sizes":[]},"email_to":"admin@admin.com","email_subject":"New message from \"Triply\"","email_content":"[all-fields]","email_from":"email@dev.wpopal.com","email_from_name":"Triply","email_to_2":"admin@admin.com","email_subject_2":"New message from \"Triply\"","email_content_2":"[all-fields]","email_from_2":"email@dev.wpopal.com","email_from_name_2":"Triply","email_reply_to_2":"admin@admin.com","mailchimp_fields_map":[],"drip_fields_map":[],"activecampaign_fields_map":[],"getresponse_fields_map":[],"convertkit_fields_map":[],"mailerlite_fields_map":[],"success_message":"The form was sent successfully.","error_message":"An error occurred.","required_field_message":"This field is required.","invalid_message":"There\'s something wrong. The form is invalid.","field_text_color":"#9CA2B1","field_typography_typography":"custom","field_typography_font_size":{"unit":"px","size":16,"sizes":[]},"field_typography_font_weight":"400","field_typography_line_height":{"unit":"px","size":24,"sizes":[]},"field_background_color":"#FFFFFF00","field_border_width":{"unit":"px","top":"2","right":"2","bottom":"2","left":"2","isLinked":true},"field_border_radius":{"unit":"px","top":"5","right":"5","bottom":"5","left":"5","isLinked":true},"button_typography_typography":"custom","button_typography_font_size":{"unit":"px","size":14,"sizes":[]},"button_typography_font_weight":"bold","button_typography_line_height":{"unit":"px","size":20,"sizes":[]},"button_border_radius":{"unit":"px","top":"5","right":"5","bottom":"5","left":"5","isLinked":true},"__globals__":{"field_text_color":"","button_background_color":"","field_border_color_focus":"globals\/colors?id=primary"},"row_gap":{"unit":"px","size":20,"sizes":[]},"button_text_padding":{"unit":"px","top":"15","right":"0","bottom":"15","left":"0","isLinked":false},"field_text_padding":{"unit":"px","top":"12","right":"20","bottom":"12","left":"20","isLinked":false},"button_typography_letter_spacing":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"button_background_color_style_2":{"unit":"px","top":"15","right":"35","bottom":"15","left":"35","isLinked":false},"field_aligrment":"center","field_border_color":"#37446A","button_width_tablet":"40","button_width_mobile":"40","button_background_color_style_2_tablet":{"unit":"px","top":"15","right":"10","bottom":"15","left":"10","isLinked":false}},"elements":[],"widgetType":"form"}],"isInner":false}],"isInner":false},{"id":"f0fc65f","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":130,"sizes":[]},"stretch_section":"section-stretched","structure":"20","background_background":"classic","background_color":"#1B2951","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"b0112f8","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center","space_between_widgets":0,"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[{"id":"7a1ac5c","elType":"widget","settings":{"editor":"<div>Copyright \u00a9 2022 <a href=\"http:\/\/https:\/\/demo2wpopal.b-cdn.net\/triply\/\">Triply<\/a>. All Rights Reserved.<\/div>","text_color":"#9CA2B1","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":24,"sizes":[]},"align_mobile":"center","align_tablet":"center","typography_font_size_mobile":{"unit":"px","size":14,"sizes":[]}},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"1cb766f","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center","space_between_widgets":0,"_inline_size_tablet":100,"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[{"id":"e886530","elType":"widget","settings":{"icon_list":[{"text":"Privacy  ","selected_icon":{"value":"","library":""},"_id":"f6ed13c","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"  Policy  ","selected_icon":{"value":"","library":""},"_id":"b04db6a","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/home-2\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"About Us   ","selected_icon":{"value":"","library":""},"_id":"66087f5","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/about-us\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Support ","selected_icon":{"value":"","library":""},"_id":"8670e99","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"  FAQ   ","selected_icon":{"value":"","library":""},"_id":"4d11ce5","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/faq\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"  Blog","selected_icon":{"value":"","library":""},"_id":"29a1808","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/blog\/","is_external":"","nofollow":"","custom_attributes":""}}],"space_between":{"unit":"px","size":25,"sizes":[]},"text_color":"#FFFFFF","icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_font_weight":"400","icon_typography_line_height":{"unit":"px","size":24,"sizes":[]},"__globals__":{"text_color":"","text_color_hover":"globals\/colors?id=primary"},"view":"inline","icon_align":"right","icon_align_mobile":"center","icon_align_tablet":"center","space_between_mobile":{"unit":"px","size":10,"sizes":[]},"icon_typography_font_size_mobile":{"unit":"px","size":14,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":false}],"isInner":false}],"footerbuilder-2":[{"id":"46789c7","elType":"section","settings":{"structure":"30","background_background":"classic","background_color":"#202F59","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/home4_deco-2.png","id":520},"background_position":"bottom left","background_repeat":"no-repeat","background_size":"contain","background_overlay_background":"classic","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/home4_deco-3.png","id":524},"background_overlay_position":"top right","background_overlay_repeat":"no-repeat","padding":{"unit":"px","top":"85","right":"15","bottom":"60","left":"15","isLinked":false},"content_width":{"unit":"px","size":1320,"sizes":[]},"padding_mobile":{"unit":"px","top":"40","right":"15","bottom":"40","left":"15","isLinked":false},"padding_tablet":{"unit":"px","top":"40","right":"30","bottom":"40","left":"30","isLinked":false},"html_tag":"div"},"elements":[{"id":"7a6fdae","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"align_mobile":"center"},"elements":[{"id":"14525c8","elType":"widget","settings":{"editor":"<div>Get Updates &amp; More<\/div>","text_color":"#8990A2","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_font_weight":"500","typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":20,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":2.399999999999999911182158029987476766109466552734375,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"42e0eaa","elType":"widget","settings":{"editor":"<div>Subscribe to the free newsletter and get 20% discount on your next booking<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":15,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"d85f797","elType":"widget","settings":{"form_name":"New Form","form_fields":[{"custom_id":"email","field_type":"email","required":"true","field_label":"Email","placeholder":"Your email","width":"60","_id":"6f021ad","width_mobile":"60"}],"show_labels":"","button_width":"40","step_next_label":"Next","step_previous_label":"Previous","button_text":"Subscribe","email_to":"admin@admin.com","email_subject":"New message from \"Triply\"","email_content":"[all-fields]","email_from":"email@dev.wpopal.com","email_from_name":"Triply","email_to_2":"admin@admin.com","email_subject_2":"New message from \"Triply\"","email_content_2":"[all-fields]","email_from_2":"email@dev.wpopal.com","email_from_name_2":"Triply","email_reply_to_2":"admin@admin.com","mailchimp_fields_map":[],"drip_fields_map":[],"activecampaign_fields_map":[],"getresponse_fields_map":[],"convertkit_fields_map":[],"mailerlite_fields_map":[],"success_message":"The form was sent successfully.","error_message":"An error occurred.","required_field_message":"This field is required.","invalid_message":"There\'s something wrong. The form is invalid.","field_typography_typography":"custom","field_typography_line_height":{"unit":"px","size":24,"sizes":[]},"field_background_color":"#FFFFFF00","field_border_width":{"unit":"px","top":"2","right":"2","bottom":"2","left":"2","isLinked":true},"field_border_radius":{"unit":"px","top":"5","right":"5","bottom":"5","left":"5","isLinked":true},"__globals__":{"field_border_color":"","button_background_color":"","field_border_color_focus":"globals\/colors?id=primary"},"field_text_color":"#9CA2B1","field_typography_font_size":{"unit":"px","size":16,"sizes":[]},"field_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"button_typography_typography":"custom","button_typography_font_size":{"unit":"px","size":14,"sizes":[]},"button_typography_line_height":{"unit":"px","size":20,"sizes":[]},"button_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"button_border_radius":{"unit":"px","top":"5","right":"5","bottom":"5","left":"5","isLinked":true},"button_width_mobile":"40","field_border_color":"#E5E5E51F","field_text_padding":{"unit":"px","top":"11","right":"20","bottom":"11","left":"20","isLinked":false},"button_background_color_style_2_tablet":{"unit":"px","top":"15","right":"15","bottom":"15","left":"15","isLinked":false},"button_background_color_style_2_mobile":{"unit":"px","top":"15","right":"10","bottom":"15","left":"10","isLinked":false},"_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":550,"sizes":[]},"selected_button_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"button_icon_align":"right","button_icon_indent":{"unit":"px","size":10,"sizes":[]},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"form"}],"isInner":false},{"id":"ad7bfae","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"110","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"15","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"62f4e5a","elType":"widget","settings":{"editor":"<div>customer support<\/div>","text_color":"#8990A2","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_font_weight":"500","typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":20,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":2.399999999999999911182158029987476766109466552734375,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"6096415","elType":"widget","settings":{"editor":"<div>Get in touch with your accommodation provider.<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"25","left":"0","isLinked":false},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"e973d9d","elType":"widget","settings":{"icon_list":[{"text":"+ 1800 - 333 5578","selected_icon":{"value":"triply-icon- triply-icon-phone-3","library":"triply-icon"},"_id":"dd7a117","link":{"url":"tel:1800 - 333 5578","is_external":"","nofollow":"","custom_attributes":""}}],"icon_size":{"unit":"px","size":25,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":24,"sizes":[]},"icon_typography_font_weight":"bold","icon_typography_line_height":{"unit":"px","size":30,"sizes":[]},"icon_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary","text_color_hover":"globals\/colors?id=primary_hover","icon_color_hover":"globals\/colors?id=primary_hover"},"icon_align_mobile":"center","icon_self_align":"center","rotate":{"unit":"deg","size":90,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"8bcaed7","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"110","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"1ece540","elType":"widget","settings":{"editor":"<div>follow us<\/div>","align":"right","text_color":"#8990A2","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_font_weight":"500","typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":20,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":2.399999999999999911182158029987476766109466552734375,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"align_tablet":"center","align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"fafcea8","elType":"widget","settings":{"social_icon_list":[{"social_icon":{"value":"fab fa-facebook","library":"fa-brands"},"_id":"c06e564","link":{"url":"#","is_external":"true","nofollow":"","custom_attributes":""}},{"social_icon":{"value":"fab fa-youtube","library":"fa-brands"},"_id":"802d303","link":{"url":"#","is_external":"true","nofollow":"","custom_attributes":""}},{"social_icon":{"value":"fab fa-twitter","library":"fa-brands"},"_id":"5c5380c","link":{"url":"#","is_external":"true","nofollow":"","custom_attributes":""}},{"_id":"0fd8b71","link":{"url":"#","is_external":"true","nofollow":"","custom_attributes":""},"social_icon":{"value":"fab fa-instagram","library":"fa-brands"}}],"shape":"circle","columns":"4","align":"right","icon_color":"custom","icon_primary_color":"#17254D","icon_spacing":{"unit":"px","size":10,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"35","left":"0","isLinked":false},"__globals__":{"hover_primary_color":"globals\/colors?id=primary"},"icon_size":{"unit":"px","size":16,"sizes":[]},"align_tablet":"center","align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"icon_padding":{"unit":"em","size":0.8000000000000000444089209850062616169452667236328125,"sizes":[]},"row_gap":{"unit":"px","size":10,"sizes":[]}},"elements":[],"widgetType":"social-icons"},{"id":"94d2c3d","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/footer_2-image-1.png","id":504},"image_size":"full","align":"right","align_tablet":"center","align_mobile":"center"},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"286116d","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","background_background":"classic","background_color":"#1B2951","padding":{"unit":"px","top":"50","right":"30","bottom":"50","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"15","bottom":"30","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"bde3b2a","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"fc71d8e","elType":"widget","settings":{"editor":"<div>Copyright \u00a9 2022 <a href=\"https:\/\/demo2wpopal.b-cdn.net\/triply\/\">Triply<\/a>. All Rights Reserved.<\/div>","text_color":"#9CA2B1","align_mobile":"center","typography_typography":"custom","typography_font_size_tablet":{"unit":"px","size":15,"sizes":[]}},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"60bda3e","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50,"margin_mobile":{"unit":"px","top":"15","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"e6155d0","elType":"widget","settings":{"view":"inline","icon_list":[{"text":"Privacy  ","selected_icon":{"value":"","library":""},"_id":"a5deab7","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/home-2\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Policy ","selected_icon":{"value":"","library":""},"_id":"8bbe439","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/home-3\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"About Us  ","selected_icon":{"value":"","library":""},"_id":"906e7f7","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/about-us\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Support  ","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"b97b0f1"},{"text":"FAQ","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/faq\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"6c5f1c7"},{"text":"Blog","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/blog\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"7aa46d5"}],"space_between":{"unit":"px","size":25,"sizes":[]},"icon_align":"right","text_color":"#FFFFFF","icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_line_height":{"unit":"px","size":24,"sizes":[]},"__globals__":{"text_color_hover":"globals\/colors?id=primary"},"icon_align_mobile":"center","space_between_tablet":{"unit":"px","size":10,"sizes":[]},"icon_typography_font_size_tablet":{"unit":"px","size":15,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":false}],"isInner":false}],"tour-detail-1":[{"id":"a8ad57c","elType":"section","settings":{"layout":"full_width","stretch_section":"section-stretched","gap":"no","content_position":"middle","background_background":"classic","background_color":"#F6F7FB","border_border":"solid","border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"border_color":"#E5E5E6","padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"margin_tablet":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"html_tag":"div"},"elements":[{"id":"d909c32","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"align":"center"},"elements":[{"id":"9b0cbfe","elType":"widget","settings":{"__dynamic__":{"title":"[elementor-tag id=\"\" name=\"page-title\" settings=\"%7B%22include_context%22%3A%22%22%2C%22show_home_title%22%3A%22%22%2C%22before%22%3A%22%22%2C%22after%22%3A%22%22%2C%22fallback%22%3A%22%22%7D\"]"},"title":"Add Your Heading Text Here","align":"left","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_text_transform":"capitalize","_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"typography_font_size_mobile":{"unit":"px","size":30,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_offset_x":{"unit":"px","size":"","sizes":[]},"_offset_y":{"unit":"px","size":"","sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"_padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"theme-page-title"},{"id":"c6ba1ba","elType":"widget","settings":{"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"},"_padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"babe-item-address"},{"id":"dcb4135","elType":"widget","settings":{"__globals__":{"title_bg_color_normal":"","title_bg_color_active":""},"margin_tab_wrapper":{"unit":"px","top":"-100","right":"0","bottom":"0","left":"0","isLinked":false},"tab_position":"bottom","tab_title_align":"flex-end","tab_title_typography_typography":"custom","tab_title_typography_font_weight":"500","tab_title_typography_letter_spacing":{"unit":"px","size":1,"sizes":[]},"margin_tab_wrapper_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"tab_title_align_mobile":"flex-start"},"elements":[],"widgetType":"babe-item-slideshow"},{"id":"a2a6c9f","elType":"widget","settings":{"__dynamic__":{"title":"[elementor-tag id=\"\" name=\"page-title\" settings=\"%7B%22include_context%22%3A%22%22%2C%22show_home_title%22%3A%22%22%2C%22before%22%3A%22%22%2C%22after%22%3A%22%22%2C%22fallback%22%3A%22%22%7D\"]"},"title":"Add Your Heading Text Here","align":"center","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_text_transform":"capitalize","_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"typography_font_size_mobile":{"unit":"px","size":30,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_z_index":2,"_position":"absolute","_offset_x":{"unit":"px","size":"","sizes":[]},"_offset_y":{"unit":"px","size":"","sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_element_width":"auto","_element_custom_width":{"unit":"%","size":"","sizes":[]},"hide_mobile":"hidden-phone"},"elements":[],"widgetType":"theme-page-title"},{"id":"1668ffa","elType":"widget","settings":{"text_color":"#FFFFFF","_margin":{"unit":"px","top":"80","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":98,"_element_width":"auto","_position":"absolute","_offset_x":{"unit":"px","size":"","sizes":[]},"_offset_y":{"unit":"px","size":"","sizes":[]},"_padding":{"unit":"px","top":"0","right":"60","bottom":"0","left":"60","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"hide_mobile":"hidden-phone"},"elements":[],"widgetType":"babe-item-address"}],"isInner":false}],"isInner":false},{"id":"5b95883","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color":"#F6F7FB","margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding":{"unit":"px","top":"10","right":"30","bottom":"80","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"10","right":"15","bottom":"80","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"3328521","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"custom_css":"selector .item_info_price {\n    margin-bottom: 0;\n}"},"elements":[{"id":"a257aa5","elType":"widget","settings":{"title":"Price","custom_css":"selector .item_info_price {\n    margin-bottom: 0;\n}","_padding":{"unit":"px","top":"0","right":"50","bottom":"30","left":"0","isLinked":false},"_border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"_border_width_mobile":{"unit":"px","top":"0","right":"1","bottom":"0","left":"0","isLinked":false},"_border_color":"#E0E0E0","_element_width":"auto","_element_custom_width_mobile":{"unit":"%","size":33,"sizes":[]},"_element_width_mobile":"initial","_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-price-from"},{"id":"b7ceedf","elType":"widget","settings":{"title":"Duration","duration_icon":{"value":"triply-icon- triply-icon-clock-time","library":"triply-icon"},"_padding":{"unit":"px","top":"0","right":"50","bottom":"30","left":"0","isLinked":false},"_element_width":"auto","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"%","size":33,"sizes":[]},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-duration"},{"id":"111a0ea","elType":"widget","settings":{"title":"Max People","duration_icon":{"value":"triply-icon- triply-icon-users","library":"triply-icon"},"_padding":{"unit":"px","top":"0","right":"50","bottom":"30","left":"0","isLinked":false},"_element_width":"auto","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"%","size":33,"sizes":[]},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-max-guests"},{"id":"4ab895d","elType":"widget","settings":{"duration_icon":{"value":"triply-icon- triply-icon-user","library":"triply-icon"},"title":"Min Age","_padding":{"unit":"px","top":"0","right":"50","bottom":"30","left":"0","isLinked":false},"_element_width":"auto","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"%","size":33,"sizes":[]},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-min-age"},{"id":"396124a","elType":"widget","settings":{"title":"Tour Type","duration_icon":{"value":"triply-icon- triply-icon-location-circle","library":"triply-icon"},"_padding":{"unit":"px","top":"0","right":"50","bottom":"30","left":"0","isLinked":false},"_element_width":"auto","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"%","size":33,"sizes":[]},"taxonomy_slug":"types","_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-tour-type"},{"id":"154c0bd","elType":"widget","settings":{"title":"Reviews","_padding":{"unit":"px","top":"0","right":"50","bottom":"30","left":"0","isLinked":false},"_element_width":"auto","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"%","size":33,"sizes":[]},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-item-stars"}],"isInner":false}],"isInner":false},{"id":"9edd8ef","elType":"section","settings":{"structure":"20","gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color_stop":{"unit":"%","size":11,"sizes":[]},"background_color_b":"#FFFFFF00","background_color_b_stop":{"unit":"%","size":11,"sizes":[]},"margin":{"unit":"px","top":"-70","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"-54","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"1d62d92","elType":"column","settings":{"_column_size":50,"_inline_size":68.992199999999996862243278883397579193115234375,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"40","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"4299b38","elType":"widget","settings":{"tabs":[{"tab_title":"Description","tab_content":"[elementor-template id=\"516\"]","_id":"a10df3f"},{"tab_title":"Tour Plan","tab_content":"[elementor-template id=\"542\"]","_id":"3279fba"},{"tab_title":"Tour Map","tab_content":"[elementor-template id=\"813\"]","_id":"595670a"},{"tab_title":"Reviews","tab_content":"[elementor-template id=\"820\"]","_id":"334d366"}],"border_width":{"unit":"px","size":"","sizes":[]},"content_color":"#666666","__globals__":{"tab_color":"globals\/colors?id=accent","background_color_title":"","title_tab_color":"globals\/colors?id=accent","background_color":""},"tabs_style_theme":"yes","tab_color":"#000000","background_color_title":"#E6E7ED","background_color_title_active":"#FFFFFF","title_padding_tablet":{"unit":"px","top":"27","right":"30","bottom":"27","left":"30","isLinked":false},"tab_typography_typography":"custom","tab_typography_text_transform":"uppercase","content_padding":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false},"title_padding":{"unit":"px","top":"27","right":"45","bottom":"27","left":"45","isLinked":false},"title_margin":{"unit":"px","top":"0","right":"10","bottom":"10","left":"0","isLinked":false},"content_padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"40","left":"0","isLinked":false},"title_padding_mobile":{"unit":"px","top":"15","right":"20","bottom":"15","left":"20","isLinked":false},"title_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"title_tab_color":"#000000"},"elements":[],"widgetType":"tabs"},{"id":"a0b1c2c","elType":"widget","settings":{"text":"Divider","color":"#E8E8E8","gap":{"unit":"px","size":50,"sizes":[]}},"elements":[],"widgetType":"divider"},{"id":"582d510","elType":"widget","settings":{"enable_title":"yes","title":"Calendar & Prices","title_margin":{"unit":"px","size":30,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"babe-item-calendar"},{"id":"1515db4","elType":"widget","settings":{"text":"Divider","color":"#E8E8E8","gap":{"unit":"px","size":50,"sizes":[]}},"elements":[],"widgetType":"divider"},{"id":"e720228","elType":"widget","settings":{"enable_carousel":"yes","column":"3","hide_desktop":"hidden-desktop","title":"You may like","enable_title":"yes","__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"babe-item-related"},{"id":"9451119","elType":"widget","settings":{"text":"Book Now","link":{"url":"#booking_form_mobile","is_external":"","nofollow":"","custom_attributes":""},"align":"center","motion_fx_motion_fx_scrolling":"yes","_offset_x_tablet":{"unit":"px","size":269,"sizes":[]},"_offset_y_tablet":{"unit":"px","size":60,"sizes":[]},"hide_desktop":"hidden-desktop","__dynamic__":[],"icon_indent":{"unit":"px","size":0,"sizes":[]},"typography_typography":"custom","background_color":"#FFFFFF","button_background_hover_color":"#FFFFFF","border_radius":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"button_icon_color":"#FFFFFF","_z_index":99999,"_element_width":"inherit","_position":"fixed","_offset_orientation_h":"end","_offset_x_end":{"unit":"px","size":0,"sizes":[]},"_offset_orientation_v":"end","_offset_y_end":{"unit":"px","size":0,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":18,"sizes":[]},"button_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":"","spread":0,"color":""},"size":"md","button_text_color":"#000000","hover_color":"#DC834E","_background_background":"classic","_background_color":"#FFFFFF","_box_shadow_box_shadow_type":"yes","_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":60,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"button"}],"isInner":false},{"id":"b74c121","elType":"column","settings":{"_column_size":50,"_inline_size":30.815000000000001278976924368180334568023681640625,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"_inline_size_tablet":100,"align_tablet":"center","padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"8a5dcbb","elType":"widget","settings":{"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"px","size":500,"sizes":[]},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"45","left":"0","isLinked":false},"wrapper_box_shadow_box_shadow_type":"yes","wrapper_box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":30,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"_element_width":"initial","_offset_orientation_h":"end","_element_id":"booking_form_mobile"},"elements":[],"widgetType":"babe-booking-form"},{"id":"ead7afa","elType":"section","settings":{"gap":"no","border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"box_shadow_box_shadow_type":"yes","box_shadow_box_shadow":{"horizontal":0,"vertical":0,"blur":30,"spread":0,"color":"rgba(5.999999999999997, 30.00000000000003, 98.00000000000001, 0.08)"},"padding":{"unit":"px","top":"30","right":"0","bottom":"20","left":"0","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"45da812","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"842fb21","elType":"widget","settings":{"title":"Last Minute Deals","header_size":"h3","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"40","bottom":"10","left":"40","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"af64742","elType":"widget","settings":{"text":"Divider","color":"#E8E8E8","gap":{"unit":"px","size":10,"sizes":[]}},"elements":[],"widgetType":"divider"},{"id":"8c7f00b","elType":"widget","settings":{"posts_per_page":4,"column":"1","_margin":{"unit":"px","top":"0","right":"40","bottom":"0","left":"40","isLinked":false},"column_tablet":"2"},"elements":[],"widgetType":"babe-item-other"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"c96960d","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone","margin":{"unit":"px","top":"0","right":0,"bottom":"90","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"b756127","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"0047b2c","elType":"widget","settings":{"enable_carousel":"yes","column":"3","title":"You may like","enable_title":"yes","__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"babe-item-related"}],"isInner":false}],"isInner":false}],"home-2":[{"id":"aa1acc1","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":480,"sizes":[]},"stretch_section":"section-stretched","background_background":"slideshow","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h2_bg.jpg","id":2068},"background_motion_fx_motion_fx_scrolling":"yes","background_motion_fx_translateY_effect":"yes","background_motion_fx_devices":["desktop","tablet"],"padding":{"unit":"px","top":"60","right":"30","bottom":"60","left":"30","isLinked":false},"background_slideshow_gallery":[{"id":2068,"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h2_bg.jpg"},{"id":1341,"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/home4_image-4.jpg"},{"id":1349,"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/home4_image-5.jpg"}],"background_slideshow_transition_duration":400,"background_slideshow_ken_burns":"yes","padding_mobile":{"unit":"px","top":"60","right":"15","bottom":"60","left":"15","isLinked":false},"margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"background_overlay_background":"classic","background_overlay_color":"#000000","background_overlay_opacity":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"html_tag":"div"},"elements":[{"id":"fb4c3ba","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"a944013","elType":"widget","settings":{"title":"Your jouney start here","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":80,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":60,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":42,"sizes":[]},"typography_line_height":{"unit":"px","size":80,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":60,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":42,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"_z_index":2,"_element_custom_width":{"unit":"px","size":580,"sizes":[]},"_element_custom_width_tablet":{"unit":"px","size":500,"sizes":[]},"__globals__":{"title_color":""},"align":"center","title_color":"#FFFFFF","text_shadow_text_shadow_type":"yes","text_shadow_text_shadow":{"horizontal":0,"vertical":1,"blur":5,"color":"rgba(0,0,0,0.3)"}},"elements":[],"widgetType":"heading"},{"id":"034d1d2","elType":"widget","settings":{"editor":"Discover amazing places at exclusive deals","align":"center","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"typography_font_size_tablet":{"unit":"px","size":20,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":18,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":24,"sizes":[]},"texteditor_shadow_text_shadow_type":"yes","texteditor_shadow_text_shadow":{"horizontal":0,"vertical":1,"blur":5,"color":"rgba(0,0,0,0.3)"}},"elements":[],"widgetType":"text-editor"},{"id":"3af4ec6","elType":"widget","settings":{"destinations_title":"Destinations","destinations_subtitle":"Where are you going?","activity_title":"Activity","activity_subtitle":"All Activity","date_title":"When","guests_title":"Guests","search_title":"Search","taxonomy_search":[{"_id":"667a46b","taxonomy_slug":"locations","taxonomy_title":"Destinations","taxonomy_subtitle":"Where are you going?","taxonomy_icon":{"value":"triply-icon- triply-icon-map-marker-rounded","library":"triply-icon"}},{"_id":"202a807","taxonomy_slug":"types","taxonomy_title":"Activity","taxonomy_subtitle":"All Activity","taxonomy_icon":{"value":"triply-icon- triply-icon-activity","library":"triply-icon"}}],"search":""},"elements":[],"widgetType":"babe-search-form"}],"isInner":false}],"isInner":false},{"id":"39a12c4","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"40","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h2_shape-1.png","id":2092},"background_position":"bottom center","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"padding":{"unit":"px","top":"100","right":"15","bottom":"100","left":"15","isLinked":false},"padding_tablet":{"unit":"px","top":"50","right":"0","bottom":"50","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"40","right":"0","bottom":"40","left":"0","isLinked":false},"background_position_tablet":"top left","background_repeat":"no-repeat","background_size_tablet":"contain","background_size_mobile":"initial","background_bg_width_mobile":{"unit":"%","size":220,"sizes":[]},"html_tag":"div"},"elements":[{"id":"1fe262c","elType":"column","settings":{"_column_size":25,"_inline_size":null,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"align_mobile":"center","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"142748a","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/12\/price.svg","id":5676},"library":"svg"},"title_text":"Competitive Pricing","description_text":"Lorem ipsum dolor sit amet, consectetur adipisicing elit.","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_space_tablet":{"unit":"px","size":20,"sizes":[]},"icon_size":{"unit":"px","size":60,"sizes":[]},"title_bottom_space_tablet":{"unit":"px","size":5,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":30,"sizes":[]},"_padding":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":2,"_background_background":"classic","_background_color":"#FFFFFF00","_background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-5.png","id":1726},"_background_position":"top center","_background_repeat":"no-repeat","_element_width":"initial","_element_custom_width":{"unit":"px","size":360,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"hover_animation":"float"},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"4e9082b","elType":"column","settings":{"_column_size":25,"_inline_size":null,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"align_mobile":"center","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"47268f3","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/12\/worldwide.svg","id":5669},"library":"svg"},"title_text":"Worldwide Coverage","description_text":"Lorem ipsum dolor sit amet, consectetur adipisicing elit.","primary_color":"#DC834E","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_space_tablet":{"unit":"px","size":20,"sizes":[]},"icon_size":{"unit":"px","size":60,"sizes":[]},"title_bottom_space_tablet":{"unit":"px","size":5,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":30,"sizes":[]},"_padding":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":2,"_background_background":"classic","_background_color":"#FFFFFF00","_background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-6.png","id":1784},"_background_position":"top center","_background_repeat":"no-repeat","_element_width":"initial","_element_custom_width":{"unit":"px","size":360,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"hover_animation":"float"},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"8892914","elType":"column","settings":{"_column_size":25,"_inline_size":null,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"align_mobile":"center","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"e6915d1","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/12\/booking.svg","id":5665},"library":"svg"},"title_text":"Fast Booking","description_text":"Lorem ipsum dolor sit amet, consectetur adipisicing elit.","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_space_tablet":{"unit":"px","size":20,"sizes":[]},"icon_size":{"unit":"px","size":60,"sizes":[]},"title_bottom_space_tablet":{"unit":"px","size":5,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":30,"sizes":[]},"_padding":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":2,"_background_background":"classic","_background_color":"#FFFFFF00","_background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-7.png","id":1786},"_background_position":"top center","_background_repeat":"no-repeat","_element_width":"initial","_element_custom_width":{"unit":"px","size":360,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"hover_animation":"float"},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"f5dd8fd","elType":"column","settings":{"_column_size":25,"_inline_size":null,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"align_mobile":"center"},"elements":[{"id":"f274b76","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/12\/guide.svg","id":5674},"library":"svg"},"title_text":"Guided Tours","description_text":"Lorem ipsum dolor sit amet, consectetur adipisicing elit.","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_space_tablet":{"unit":"px","size":20,"sizes":[]},"icon_size":{"unit":"px","size":60,"sizes":[]},"title_bottom_space_tablet":{"unit":"px","size":5,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":30,"sizes":[]},"_padding":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":2,"_background_background":"classic","_background_color":"#FFFFFF00","_background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-8.png","id":1787},"_background_position":"top center","_background_repeat":"no-repeat","_element_width":"initial","_element_custom_width":{"unit":"px","size":360,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"primary_color":"#B31E1E","hover_animation":"float"},"elements":[],"widgetType":"icon-box"}],"isInner":false}],"isInner":false},{"id":"6f98885","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"40","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"eef664d","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"4705518","elType":"widget","settings":{"editor":"Places to go","align":"center","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"3e6e9f2","elType":"widget","settings":{"title":"Perfect Destinations","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"4db0e83","elType":"section","settings":{"gap":"no","structure":"20","margin":{"unit":"px","top":"0","right":0,"bottom":"20","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"10","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"fe1a614","elType":"column","settings":{"_column_size":50,"_inline_size":65.891469999999998208295437507331371307373046875,"space_between_widgets":0,"align_mobile":"center","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[{"id":"7b95e22","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"argentina","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-01.jpg","id":3488},"count_tour":"yes","custom_text":"From <span>100$<\/span>","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":410,"sizes":[]}},"elements":[],"widgetType":"taxonomy-item"}],"isInner":true},{"id":"1ec4915","elType":"column","settings":{"_column_size":50,"_inline_size":34.10900000000000176214598468504846096038818359375,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"252fce8","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"viet-nam","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-02.jpg","id":3489},"count_tour":"yes","custom_text":"From <span>100$<\/span>","img_location_radius":{"unit":"%","top":"50","right":"50","bottom":"50","left":"50","isLinked":true}},"elements":[],"widgetType":"taxonomy-item"}],"isInner":true}],"isInner":true},{"id":"b5d5576","elType":"section","settings":{"gap":"no","structure":"30","html_tag":"div"},"elements":[{"id":"a0cc452","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[{"id":"1cc58ec","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"costa-rica","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-03.jpg","id":3493},"count_tour":"yes","custom_text":"From <span>100$<\/span>"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":true},{"id":"606e73e","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[{"id":"9640205","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"morocco","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-04.jpg","id":3494},"count_tour":"yes","custom_text":"From <span>100$<\/span>","img_location_radius":{"unit":"%","top":"50","right":"50","bottom":"50","left":"50","isLinked":true}},"elements":[],"widgetType":"taxonomy-item"}],"isInner":true},{"id":"34a812d","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"b9e8079","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"colombia","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-05.jpg","id":3495},"count_tour":"yes","custom_text":"From <span>100$<\/span>"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"18e0026","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"40","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"dd00082","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"65bad54","elType":"widget","settings":{"editor":"What\u2019s new","align":"center","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"8630787","elType":"widget","settings":{"title":"Popular Tours","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"6c8da11","elType":"widget","settings":{"per_page":"12","column":"3","style":"1","enable_carousel":"yes","navigation":"arrows","_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"next_horizontal":"right","next_horizontal_value_tablet":{"unit":"px","size":0,"sizes":[]},"next_horizontal_value_mobile":{"unit":"px","size":15,"sizes":[]},"prev_horizontal":"left","prev_horizontal_value_tablet":{"unit":"px","size":0,"sizes":[]},"prev_horizontal_value_mobile":{"unit":"px","size":15,"sizes":[]},"next_horizontal_value":{"unit":"px","size":"","sizes":[]},"prev_horizontal_value":{"unit":"px","size":"","sizes":[]}},"elements":[],"widgetType":"babe-all-items"},{"id":"2b935d1","elType":"widget","settings":{"text":"View All Popular Tours","align":"center","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false},{"id":"90b55f2","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":340,"sizes":[]},"stretch_section":"section-stretched","structure":"40","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h2_bg-1.jpg","id":2135},"background_position":"center center","background_size":"cover","background_motion_fx_motion_fx_scrolling":"yes","background_motion_fx_translateY_effect":"yes","background_motion_fx_devices":["desktop","tablet"],"background_overlay_background":"classic","background_overlay_color":"#202F59","background_overlay_opacity":{"unit":"px","size":0.59999999999999997779553950749686919152736663818359375,"sizes":[]},"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"padding":{"unit":"px","top":"80","right":"15","bottom":"80","left":"15","isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"0","bottom":"60","left":"0","isLinked":false},"html_tag":"div"},"elements":[{"id":"4662d55","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"space_between_widgets":0,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"51912d4","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-destination","library":"triply-icon"},"primary_color":"#FFFFFF","size":{"unit":"px","size":80,"sizes":[]},"size_mobile":{"unit":"px","size":60,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"icon"},{"id":"61770c5","elType":"widget","settings":{"starting_number":100,"ending_number":154,"title":"","number_color":"#FFFFFF","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":60,"sizes":[]},"typography_number_font_size_tablet":{"unit":"px","size":56,"sizes":[]},"typography_number_font_size_mobile":{"unit":"px","size":45,"sizes":[]}},"elements":[],"widgetType":"counter"},{"id":"de92ea4","elType":"widget","settings":{"editor":"Destinations","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"}},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"549a28b","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"space_between_widgets":0,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"75644d4","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-tours","library":"triply-icon"},"primary_color":"#FFFFFF","size":{"unit":"px","size":80,"sizes":[]},"size_mobile":{"unit":"px","size":60,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"icon"},{"id":"66c96e8","elType":"widget","settings":{"starting_number":2100,"ending_number":2165,"title":"","number_color":"#FFFFFF","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":60,"sizes":[]},"typography_number_font_size_tablet":{"unit":"px","size":56,"sizes":[]},"typography_number_font_size_mobile":{"unit":"px","size":45,"sizes":[]}},"elements":[],"widgetType":"counter"},{"id":"8597012","elType":"widget","settings":{"editor":"Amazing tours","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"}},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"cec81bf","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"space_between_widgets":0,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"bfc9fef","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-types","library":"triply-icon"},"primary_color":"#FFFFFF","size":{"unit":"px","size":80,"sizes":[]},"size_mobile":{"unit":"px","size":60,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"icon"},{"id":"248dfaa","elType":"widget","settings":{"starting_number":"","ending_number":98,"title":"","number_color":"#FFFFFF","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":60,"sizes":[]},"typography_number_font_size_tablet":{"unit":"px","size":56,"sizes":[]},"typography_number_font_size_mobile":{"unit":"px","size":45,"sizes":[]}},"elements":[],"widgetType":"counter"},{"id":"384c6f4","elType":"widget","settings":{"editor":"Tour types","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"}},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"5bfa53e","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"5bb3afd","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-happy","library":"triply-icon"},"primary_color":"#FFFFFF","size":{"unit":"px","size":80,"sizes":[]},"size_mobile":{"unit":"px","size":60,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"icon"},{"id":"bd09717","elType":"widget","settings":{"starting_number":117200,"ending_number":117259,"title":"","number_color":"#FFFFFF","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":60,"sizes":[]},"typography_number_font_size_tablet":{"unit":"px","size":56,"sizes":[]},"typography_number_font_size_mobile":{"unit":"px","size":45,"sizes":[]}},"elements":[],"widgetType":"counter"},{"id":"28e94b9","elType":"widget","settings":{"editor":"Happy customers","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"}},"elements":[],"widgetType":"text-editor"}],"isInner":false}],"isInner":false},{"id":"e60962f","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"40","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"3ece8b9","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"123d1f9","elType":"widget","settings":{"editor":"Don\u2019t miss","align":"center","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"0156b65","elType":"widget","settings":{"title":"Deals & Discounts","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"21fe471","elType":"widget","settings":{"per_page":"12","column":"3","style":"1","enable_carousel":"yes","navigation":"arrows","next_horizontal":"right","next_horizontal_value_tablet":{"unit":"px","size":0,"sizes":[]},"next_horizontal_value_mobile":{"unit":"px","size":15,"sizes":[]},"prev_horizontal":"left","prev_horizontal_value_tablet":{"unit":"px","size":0,"sizes":[]},"prev_horizontal_value_mobile":{"unit":"px","size":15,"sizes":[]},"next_horizontal_value":{"unit":"px","size":"","sizes":[]},"prev_horizontal_value":{"unit":"px","size":"","sizes":[]}},"elements":[],"widgetType":"babe-all-items"}],"isInner":false}],"isInner":false},{"id":"411dd87","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"html_tag":"div"},"elements":[{"id":"a479f87","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h2_bg-3.jpg","id":2301},"background_position":"center center","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"background_size":"cover","background_color":"#DC834E","background_position_mobile":"center left","background_size_mobile":"initial","background_bg_width_mobile":{"unit":"px","size":0,"sizes":[]},"border_radius_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"background_overlay_background":"classic","background_overlay_color":"#000000","background_overlay_opacity":{"unit":"px","size":0.1000000000000000055511151231257827021181583404541015625,"sizes":[]}},"elements":[{"id":"ec8c129","elType":"section","settings":{"gap":"no","structure":"30","content_width":{"unit":"px","size":1070,"sizes":[]},"custom_height_inner":{"unit":"px","size":500,"sizes":[]},"content_position":"middle","overflow":"hidden","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"6c94cc3","elType":"column","settings":{"_column_size":33,"_inline_size":28.03699999999999903366187936626374721527099609375,"space_between_widgets":0,"padding":{"unit":"px","top":"120","right":"30","bottom":"120","left":"0","isLinked":false},"_inline_size_tablet":38,"align_mobile":"center","padding_tablet":{"unit":"px","top":"100","right":"20","bottom":"100","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[{"id":"47b9b9c","elType":"widget","settings":{"title":"Explore the Queens of the Aegean Sea  ","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_line_height":{"unit":"px","size":40,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_element_custom_width":{"unit":"px","size":270,"sizes":[]},"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_z_index":2,"_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":400,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"dc2a81d","elType":"widget","settings":{"editor":"Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.","text_color":"#FFFFFF","align_mobile":"center","_z_index":2,"_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":420,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"c07c1eb","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h2_shape-2.png","id":2543},"image_size":"full","motion_fx_motion_fx_scrolling":"yes","motion_fx_translateY_effect":"yes","_element_width":"initial","_element_custom_width":{"unit":"px","size":463,"sizes":[]},"_position":"absolute","_offset_x_end":{"unit":"px","size":15,"sizes":[]},"_offset_y":{"unit":"px","size":70,"sizes":[]},"_offset_y_end":{"unit":"px","size":120,"sizes":[]},"_offset_x":{"unit":"px","size":-212,"sizes":[]},"_offset_x_mobile":{"unit":"px","size":-80,"sizes":[]},"_offset_x_end_mobile":{"unit":"%","size":9,"sizes":[]},"_offset_y_mobile":{"unit":"%","size":180,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"1a015d5","elType":"column","settings":{"_column_size":33,"_inline_size":35.78099999999999880628820392303168773651123046875,"space_between_widgets":0,"content_position":"bottom","padding":{"unit":"px","top":"0","right":"0","bottom":"120","left":"0","isLinked":false},"_inline_size_tablet":26,"align_mobile":"center","padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"100","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"839f9d9","elType":"widget","settings":{"editor":"From ","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"500","align_mobile":"center","_z_index":2},"elements":[],"widgetType":"text-editor"},{"id":"8b7af93","elType":"widget","settings":{"editor":"$462","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":40,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"10","bottom":"0","left":"0","isLinked":false},"_element_width":"auto","_z_index":2},"elements":[],"widgetType":"text-editor"},{"id":"df5402a","elType":"widget","settings":{"editor":"<del>$1150<\/del> ","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":36,"sizes":[]},"_element_width":"auto","_z_index":2},"elements":[],"widgetType":"text-editor"},{"id":"ca08bb3","elType":"widget","settings":{"text":"View Deals","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"background_color":"#FFFFFF","_margin":{"unit":"px","top":"10","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"button_text_color":"globals\/colors?id=secondary","button_background_hover_color":"globals\/colors?id=secondary_hover","hover_color":"globals\/colors?id=primary"},"align_mobile":"center","_z_index":2},"elements":[],"widgetType":"button"}],"isInner":true},{"id":"9f44d96","elType":"column","settings":{"_column_size":33,"_inline_size":35.51400000000000289901436190120875835418701171875,"space_between_widgets":0,"padding":{"unit":"px","top":"60","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"aae5eeb","elType":"widget","settings":{"editor":"Discount","align":"center","text_color":"#FFFFFF","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"-64","left":"0","isLinked":false},"_z_index":2,"texteditor_shadow_text_shadow_type":"yes","texteditor_shadow_text_shadow":{"horizontal":0,"vertical":1,"blur":5,"color":"rgba(0,0,0,0.3)"}},"elements":[],"widgetType":"text-editor"},{"id":"e28d25d","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h2_50off.png","id":2317},"image_size":"full"},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"bc727a6","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"90","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"bd9908c","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"align":"center"},"elements":[{"id":"eab20dd","elType":"widget","settings":{"editor":"Categories","align":"center","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"d619810","elType":"widget","settings":{"title":"Tour Types","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"688a4e4","elType":"widget","settings":{"taxonomy_slug":"types","locations_id":"argentina","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-01.jpg","id":3488},"count_tour":"yes","custom_text":"From <strong>550$<\/strong>","style":"2","types_id":"city-tours","enable_text":"yes","_margin":{"unit":"px","top":"0","right":"5","bottom":"10","left":"5","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":210,"sizes":[]},"__globals__":{"count_color":""},"wrap_padding":{"unit":"px","top":"25","right":"10","bottom":"30","left":"10","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_element_width_mobile":"auto","_element_custom_width_mobile":{"unit":"%","size":50,"sizes":[]},"_element_vertical_align_mobile":"center"},"elements":[],"widgetType":"taxonomy-item"},{"id":"b703cbd","elType":"widget","settings":{"taxonomy_slug":"types","locations_id":"argentina","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-01.jpg","id":3488},"count_tour":"yes","custom_text":"From <strong>250$<\/strong>","style":"2","types_id":"beaches","enable_text":"yes","_margin":{"unit":"px","top":"0","right":"5","bottom":"10","left":"5","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":210,"sizes":[]},"__globals__":{"count_background_color":"","count_color":""},"wrap_padding":{"unit":"px","top":"25","right":"10","bottom":"30","left":"10","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_element_width_mobile":"auto","_element_custom_width_mobile":{"unit":"%","size":"","sizes":[]}},"elements":[],"widgetType":"taxonomy-item"},{"id":"4a86f5e","elType":"widget","settings":{"taxonomy_slug":"types","locations_id":"argentina","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-01.jpg","id":3488},"count_tour":"yes","custom_text":"From <strong>399$<\/strong>","style":"2","types_id":"museum-tours","enable_text":"yes","_margin":{"unit":"px","top":"0","right":"5","bottom":"10","left":"5","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":210,"sizes":[]},"__globals__":{"count_color":""},"wrap_padding":{"unit":"px","top":"25","right":"10","bottom":"30","left":"10","isLinked":false},"_element_width_mobile":"auto"},"elements":[],"widgetType":"taxonomy-item"},{"id":"85041a6","elType":"widget","settings":{"taxonomy_slug":"types","locations_id":"argentina","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-01.jpg","id":3488},"count_tour":"yes","custom_text":"From <strong>850$<\/strong>","style":"2","types_id":"cruises","enable_text":"yes","_margin":{"unit":"px","top":"0","right":"5","bottom":"10","left":"5","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":210,"sizes":[]},"__globals__":{"count_color":""},"wrap_padding":{"unit":"px","top":"25","right":"10","bottom":"30","left":"10","isLinked":false},"_element_width_mobile":"auto"},"elements":[],"widgetType":"taxonomy-item"},{"id":"1dca9eb","elType":"widget","settings":{"taxonomy_slug":"types","locations_id":"argentina","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-01.jpg","id":3488},"count_tour":"yes","custom_text":"From <strong>780$<\/strong>","style":"2","types_id":"historical","enable_text":"yes","_margin":{"unit":"px","top":"0","right":"5","bottom":"10","left":"5","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":210,"sizes":[]},"__globals__":{"count_color":""},"wrap_padding":{"unit":"px","top":"25","right":"10","bottom":"30","left":"10","isLinked":false},"_element_width_mobile":"auto"},"elements":[],"widgetType":"taxonomy-item"},{"id":"ff6d118","elType":"widget","settings":{"taxonomy_slug":"types","locations_id":"argentina","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-01.jpg","id":3488},"count_tour":"yes","custom_text":"From <strong>350$<\/strong>","style":"2","types_id":"hiking","enable_text":"yes","_margin":{"unit":"px","top":"0","right":"5","bottom":"10","left":"5","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":210,"sizes":[]},"__globals__":{"count_color":""},"wrap_padding":{"unit":"px","top":"25","right":"10","bottom":"30","left":"10","isLinked":false},"_element_width_mobile":"auto"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":false}],"isInner":false},{"id":"1d7ada4","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","background_background":"classic","background_color":"#F9F4F0","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"120","right":"30","bottom":"120","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"15","bottom":"60","left":"15","isLinked":false},"background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h2_shape-3.png","id":3677},"background_position":"center center","background_motion_fx_motion_fx_scrolling":"yes","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":3,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"html_tag":"div"},"elements":[{"id":"3edd85e","elType":"column","settings":{"_column_size":50,"_inline_size":68.2169999999999987494447850622236728668212890625,"space_between_widgets":10,"_inline_size_tablet":100,"align_mobile":"center"},"elements":[{"id":"d52ba4e","elType":"widget","settings":{"editor":"About","align":"left","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"dd787fc","elType":"widget","settings":{"title":"We Are Travel Agency","align":"left","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"_element_width":"initial","_element_custom_width":{"unit":"px","size":360,"sizes":[]},"align_mobile":"center","_element_width_tablet":"inherit"},"elements":[],"widgetType":"heading"},{"id":"0d8caab","elType":"section","settings":{"gap":"no","structure":"20","html_tag":"div"},"elements":[{"id":"d86e0be","elType":"column","settings":{"_column_size":50,"_inline_size":37.5,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h2_bg-4.jpg","id":2615},"background_position":"center center","background_size":"cover","border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"_inline_size_tablet":50},"elements":[{"id":"b0d74de","elType":"widget","settings":{"space":{"unit":"px","size":200,"sizes":[]}},"elements":[],"widgetType":"spacer"}],"isInner":true},{"id":"a0d4fae","elType":"column","settings":{"_column_size":50,"_inline_size":62.49799999999999755573298898525536060333251953125,"align":"space-between","space_between_widgets":10,"padding":{"unit":"px","top":"0","right":"50","bottom":"0","left":"50","isLinked":false},"_inline_size_tablet":50,"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"e753432","elType":"widget","settings":{"editor":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=lighter"}},"elements":[],"widgetType":"text-editor"},{"id":"7c8c252","elType":"widget","settings":{"editor":"Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.","typography_line_height":{"unit":"px","size":24,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"6de2d84","elType":"widget","settings":{"title":"we help you planning your journey","header_size":"h5","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"700","typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":24,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"2c8374d","elType":"widget","settings":{"icon_list":[{"text":"Trust and Safety","selected_icon":{"value":"far fa-check-circle","library":"fa-regular"},"_id":"827f4aa"},{"text":"Best Travel Agent","selected_icon":{"value":"far fa-check-circle","library":"fa-regular"},"_id":"5f5ccde"},{"text":"Best Price Guarantee","selected_icon":{"value":"far fa-check-circle","library":"fa-regular"},"_id":"4789eb3"}],"space_between":{"unit":"px","size":5,"sizes":[]},"_element_width":"initial","_element_custom_width":{"unit":"px","size":210,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"_element_width_mobile":"inherit"},"elements":[],"widgetType":"icon-list"},{"id":"ca81dcd","elType":"widget","settings":{"icon_list":[{"text":"Beautiful Places","selected_icon":{"value":"far fa-check-circle","library":"fa-regular"},"_id":"827f4aa"},{"text":"Passionate Travel","selected_icon":{"value":"far fa-check-circle","library":"fa-regular"},"_id":"5f5ccde"},{"text":"Fast Booking","selected_icon":{"value":"far fa-check-circle","library":"fa-regular"},"_id":"4789eb3"}],"space_between":{"unit":"px","size":5,"sizes":[]},"_element_width":"initial","_element_custom_width":{"unit":"px","size":210,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"_element_width_mobile":"inherit"},"elements":[],"widgetType":"icon-list"},{"id":"75f6876","elType":"widget","settings":{"text":"Learn More","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"background_color":"#02010100","hover_color":"#FFFFFF","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"_margin":{"unit":"px","top":"30","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"border_color":"globals\/colors?id=accent","button_text_color":"globals\/colors?id=secondary","button_background_hover_color":"globals\/colors?id=secondary_hover","button_hover_border_color":"globals\/colors?id=secondary_hover"},"_margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"button"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"b9d698c","elType":"column","settings":{"_column_size":50,"_inline_size":31.782900000000001483613232267089188098907470703125,"space_between_widgets":0,"background_background":"classic","background_color":"#FFFFFF","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_quote-2.png","id":2017},"background_position":"initial","background_xpos":{"unit":"%","size":115,"sizes":[]},"background_ypos":{"unit":"px","size":-4,"sizes":[]},"background_repeat":"no-repeat","border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"margin":{"unit":"px","top":"80","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"70","right":"40","bottom":"40","left":"40","isLinked":false},"_inline_size_tablet":100,"margin_mobile":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"40","right":"40","bottom":"40","left":"40","isLinked":true},"padding_mobile":{"unit":"px","top":"30","right":"15","bottom":"30","left":"15","isLinked":false}},"elements":[{"id":"a12db6f","elType":"widget","settings":{"testimonials":[{"testimonial_content":"\u201cThis was an amazing trip! There were so many highlights... our outstanding, kind, patient, amazing leader Gustavo!! What an absolute saint. He was so organized and insightful!\u201d ","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h3-img-box-1.png","id":2117},"testimonial_name":"Melisa Joan H.","testimonial_job":" New York, USA","_id":"87f87d2","testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"}},{"testimonial_content":"\"Needless to say we are extremely satisfied with the results. Booking Booking tour was the best investment I ever made. Nice work on your booking tour..mpressed.\"","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-4-2.jpg","id":2730},"testimonial_name":"Roselin D.","testimonial_job":" New York, USA","testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"},"_id":"cadac67"},{"testimonial_content":"\"Great job, I will definitely be ordering again! After using booking Booking tour my business skyrocketed! Man, this thing is getting better and better as I learn more about it. \"","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-5-2.jpg","id":2731},"testimonial_name":"Cleveland A.","testimonial_job":" New York, USA","testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"},"_id":"3d47fe4"}],"column":"1","layout_style":"2","content_typography_typography":"custom","content_typography_font_size":{"unit":"px","size":20,"sizes":[]},"content_typography_line_height":{"unit":"px","size":30,"sizes":[]},"enable_carousel":"yes","column_tablet":"1","_element_custom_width_tablet":{"unit":"px","size":680,"sizes":[]},"dots_vertical_value":{"unit":"px","size":-50,"sizes":[]},"column_mobile":"1","content_spacing":{"unit":"px","size":40,"sizes":[]}},"elements":[],"widgetType":"triply-testimonials"}],"isInner":false}],"isInner":false},{"id":"3cd1da1","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"337fe25","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"434de49","elType":"widget","settings":{"editor":"Our blog","align":"center","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"45601e6","elType":"widget","settings":{"title":"Travel Tips and Advice","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"56603ca","elType":"widget","settings":{"column":"2","item_spacing":{"unit":"px","size":50,"sizes":[]},"pagination_page_limit":"5","pagination_prev_label":"&laquo; Previous","pagination_next_label":"Next &raquo;","enable_carousel":"yes","column_tablet":"2","column_mobile":"1","item_spacing_tablet":{"unit":"px","size":20,"sizes":[]}},"elements":[],"widgetType":"triply-post-grid"}],"isInner":false}],"isInner":false}],"home-4":[{"id":"f8540db","elType":"section","settings":{"gap":"no","custom_height":{"unit":"px","size":600,"sizes":[]},"stretch_section":"section-stretched","background_background":"slideshow","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h2_bg.jpg","id":2068},"background_motion_fx_motion_fx_scrolling":"yes","background_motion_fx_translateY_effect":"yes","background_motion_fx_devices":["desktop","tablet"],"padding":{"unit":"px","top":"210","right":"30","bottom":"0","left":"30","isLinked":false},"background_slideshow_gallery":[{"id":2068,"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h2_bg.jpg"},{"id":1341,"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/home4_image-4.jpg"},{"id":1349,"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/home4_image-5.jpg"}],"background_slideshow_transition_duration":400,"background_slideshow_ken_burns":"yes","column_position":"stretch","padding_mobile":{"unit":"px","top":"120","right":"15","bottom":"0","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"150","right":"30","bottom":"0","left":"30","isLinked":false},"margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"background_overlay_background":"classic","background_overlay_color":"#000000","background_overlay_opacity":{"unit":"px","size":0.1000000000000000055511151231257827021181583404541015625,"sizes":[]},"html_tag":"div"},"elements":[{"id":"be11fe4","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"89f11d9","elType":"widget","settings":{"title":"Best travel experience","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":80,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":60,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":42,"sizes":[]},"typography_line_height":{"unit":"px","size":80,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":60,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":42,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"_z_index":2,"_element_custom_width":{"unit":"px","size":580,"sizes":[]},"_element_custom_width_tablet":{"unit":"px","size":500,"sizes":[]},"__globals__":{"title_color":""},"align":"center","title_color":"#FFFFFF","typography_letter_spacing":{"unit":"px","size":-1,"sizes":[]},"_animation":"opal-move-up","animation_duration":"fast","text_shadow_text_shadow_type":"yes","text_shadow_text_shadow":{"horizontal":0,"vertical":1,"blur":5,"color":"rgba(0,0,0,0.3)"}},"elements":[],"widgetType":"heading"},{"id":"e7d7b5a","elType":"widget","settings":{"editor":"Discover amazing places at exclusive deals","align":"center","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"225","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"150","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"120","left":"0","isLinked":false},"_animation":"opal-move-up","animation_duration":"fast","texteditor_shadow_text_shadow_type":"yes","texteditor_shadow_text_shadow":{"horizontal":0,"vertical":1,"blur":5,"color":"rgba(0,0,0,0.3)"}},"elements":[],"widgetType":"text-editor"},{"id":"8a81233","elType":"widget","settings":{"destinations_title":"Destinations","destinations_subtitle":"Where are you going?","activity_title":"Activity","activity_subtitle":"All Activity","date_title":"When","guests_title":"Guests","search_title":"Search","taxonomy_search":[{"_id":"667a46b","taxonomy_slug":"locations","taxonomy_title":"Destinations","taxonomy_subtitle":"Where are you going?","taxonomy_icon":{"value":"triply-icon- triply-icon-map-marker-rounded","library":"triply-icon"}},{"_id":"202a807","taxonomy_slug":"types","taxonomy_title":"Activity","taxonomy_subtitle":"All activity","taxonomy_icon":{"value":"triply-icon- triply-icon-activity","library":"triply-icon"}}],"_margin":{"unit":"px","top":"0","right":"0","bottom":"-40","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"-70","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"-170","left":"0","isLinked":false},"_z_index":1,"custom_css":".babe-search-box form {\n    margin-bottom: 0\n}","_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"babe-search-form"}],"isInner":false}],"isInner":false},{"id":"897aab6","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"30","content_width":{"unit":"px","size":1320,"sizes":[]},"padding":{"unit":"px","top":"145","right":"30","bottom":"120","left":"30","isLinked":false},"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/home4_deco-4.png","id":1330},"background_position":"top left","background_repeat":"no-repeat","background_overlay_background":"classic","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/home4_deco-5.png","id":1334},"background_overlay_position":"top right","background_overlay_repeat":"no-repeat","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"margin_mobile":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding_mobile":{"unit":"px","top":"215","right":"15","bottom":"0","left":"15","isLinked":false},"padding_tablet":{"unit":"px","top":"150","right":"30","bottom":"65","left":"30","isLinked":false},"margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"background_xpos_mobile":{"unit":"px","size":41,"sizes":[]},"background_size_mobile":"initial","background_bg_width_mobile":{"unit":"px","size":0,"sizes":[]},"background_overlay_size_mobile":"initial","background_overlay_bg_width_mobile":{"unit":"px","size":0,"sizes":[]},"html_tag":"div"},"elements":[{"id":"7c88d77","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/home4_image-3.jpg","id":1052},"background_repeat":"no-repeat","background_size":"cover","margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"padding":{"unit":"px","top":"50","right":"50","bottom":"170","left":"0","isLinked":false},"background_overlay_hover_opacity":{"unit":"px","size":0.320000000000000006661338147750939242541790008544921875,"sizes":[]},"_inline_size_tablet":100,"background_position_tablet":"bottom center","margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"50","right":"30","bottom":"170","left":"30","isLinked":false},"background_overlay_background":"classic","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/home4_deco-1-1.png","id":3065},"background_overlay_position":"bottom left","background_overlay_repeat":"no-repeat","background_overlay_size":"initial","background_overlay_bg_width":{"unit":"%","size":65,"sizes":[]},"background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"animation":"opal-move-up","animation_duration":"fast","animation_delay":250},"elements":[{"id":"aff5bc6","elType":"widget","settings":{"editor":"<div>Happy Holiday<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":40,"sizes":[]},"align":"right","align_mobile":"center","texteditor_shadow_text_shadow_type":"yes","texteditor_shadow_text_shadow":{"horizontal":0,"vertical":1,"blur":5,"color":"rgba(0,0,0,0.3)"}},"elements":[],"widgetType":"text-editor"},{"id":"d4159bc","elType":"widget","settings":{"title":"Stay & Enjoy","align":"right","title_color":"#FFE329","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_line_height":{"unit":"px","size":35,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"align_mobile":"center","text_shadow_text_shadow_type":"yes","text_shadow_text_shadow":{"horizontal":0,"vertical":1,"blur":5,"color":"rgba(0,0,0,0.3)"}},"elements":[],"widgetType":"heading"},{"id":"229608b","elType":"widget","settings":{"editor":"<div>5% bonus on all booking<\/div>","align":"right","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":30,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"70f8910","elType":"widget","settings":{"text":"Book Now","align":"right","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"background_color":"#FFFFFF","hover_color":"#FFFFFF","__globals__":{"button_text_color":"globals\/colors?id=accent","button_background_hover_color":"globals\/colors?id=primary"},"icon_indent":{"unit":"px","size":15,"sizes":[]},"border_radius":{"unit":"px","top":"5","right":"5","bottom":"5","left":"5","isLinked":true},"text_padding":{"unit":"px","top":"18","right":"30","bottom":"18","left":"30","isLinked":false},"button_text_color":"#000000","align_mobile":"center"},"elements":[],"widgetType":"button"}],"isInner":false},{"id":"560c9b4","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50,"padding":{"unit":"px","top":"0","right":"40","bottom":"0","left":"35","isLinked":false},"margin_tablet":{"unit":"px","top":"40","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"animation":"opal-move-up","animation_duration":"fast","animation_delay":350},"elements":[{"id":"f52d662","elType":"widget","settings":{"title":"Last Minute Deals","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"_border_color":"#E5E5E5","__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center","_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"13","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"db446f8","elType":"widget","settings":{"per_page":"3","column":"1","column_tablet":"1","style":"5"},"elements":[],"widgetType":"babe-all-items"}],"isInner":false},{"id":"b0f5533","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50,"padding":{"unit":"px","top":"0","right":"80","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"40","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"animation":"opal-move-up","animation_duration":"fast","animation_delay":450},"elements":[{"id":"e75457a","elType":"widget","settings":{"title":"Best Price","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"_border_color":"#E5E5E5","__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center","_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"13","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"5bb279b","elType":"widget","settings":{"per_page":"3","column":"1","column_tablet":"1","style":"5","sort":"price_from","sortby":"ASC"},"elements":[],"widgetType":"babe-all-items"}],"isInner":false}],"isInner":false},{"id":"6bf87eb","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"40","background_background":"classic","background_color":"#F9F4F0","padding":{"unit":"px","top":"50","right":"30","bottom":"40","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"40","right":"15","bottom":"40","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":0,"bottom":"0","left":0,"isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"84c9426","elType":"column","settings":{"_column_size":25,"_inline_size":25,"space_between_widgets":0,"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"align":"center","align_tablet":"flex-start","align_mobile":"center","animation_duration":"fast","animation_delay":250,"_inline_size_mobile":50},"elements":[{"id":"d22f76b","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-credit-card","library":"triply-icon"},"title_text":"No Credit Card <br> Require","description_text":"","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"position":"left","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_size":{"unit":"px","size":30,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"_background_background":"classic","_background_color":"#02010100","__globals__":{"title_color":"globals\/colors?id=accent"},"hover_animation":"grow","icon_space_mobile":{"unit":"px","size":5,"sizes":[]},"title_typography_font_weight":"400","_element_width":"auto","_animation":"opal-move-up","animation_duration":"fast","_animation_delay":250},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"7e06655","elType":"column","settings":{"_column_size":25,"_inline_size":25,"space_between_widgets":0,"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"align":"center","align_tablet":"flex-start","align_mobile":"center","_inline_size_mobile":50},"elements":[{"id":"4f9e9a1","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-money-bill","library":"triply-icon"},"title_text":"Payment When <br> Check Out","description_text":"","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"position":"left","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_size":{"unit":"px","size":30,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"_background_background":"classic","_background_color":"#02010100","__globals__":{"title_color":"globals\/colors?id=accent"},"hover_animation":"grow","icon_space_mobile":{"unit":"px","size":5,"sizes":[]},"title_typography_font_weight":"400","_element_width":"auto","_animation":"opal-move-up","animation_duration":"fast","_animation_delay":350},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"6461faa","elType":"column","settings":{"_column_size":25,"_inline_size":25,"space_between_widgets":0,"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"30","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"align":"center","align_tablet":"flex-start","align_mobile":"center","_inline_size_mobile":50},"elements":[{"id":"1eda165","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-tag-left","library":"triply-icon"},"title_text":"Best Price <br> Guarantee","description_text":"","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"position":"left","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_size":{"unit":"px","size":30,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"_background_background":"classic","_background_color":"#02010100","__globals__":{"title_color":"globals\/colors?id=accent"},"hover_animation":"grow","icon_space_mobile":{"unit":"px","size":5,"sizes":[]},"title_typography_font_weight":"400","_element_width":"auto","_animation":"opal-move-up","animation_duration":"fast","_animation_delay":450},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"b17300b","elType":"column","settings":{"_column_size":25,"_inline_size":25,"space_between_widgets":0,"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"30","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"align":"center","align_tablet":"flex-start","align_mobile":"center","_inline_size_mobile":50},"elements":[{"id":"b4ce341","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-user-headset","library":"triply-icon"},"title_text":"Customer Care <br> 24\/7","description_text":"","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"position":"left","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_size":{"unit":"px","size":30,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"_background_background":"classic","_background_color":"#02010100","__globals__":{"title_color":"globals\/colors?id=accent"},"hover_animation":"grow","icon_space_mobile":{"unit":"px","size":5,"sizes":[]},"title_typography_font_weight":"400","_element_width":"auto","_animation":"opal-move-up","animation_duration":"fast","_animation_delay":550},"elements":[],"widgetType":"icon-box"}],"isInner":false}],"isInner":false},{"id":"07cbcad","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"padding_tablet":{"unit":"px","top":"50","right":"30","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"128f435","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"42ba898","elType":"widget","settings":{"title":"Popular Tours","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":60,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":30,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"heading"},{"id":"a22d8a9","elType":"widget","settings":{"per_page":"4","column":"3","style":"1","navigation":"arrows","enable_carousel":"yes","style_arrow":"style-2","next_vertical":"top","next_vertical_value":{"unit":"%","size":-5.5,"sizes":[]},"next_horizontal":"right","next_horizontal_value":{"unit":"%","size":0,"sizes":[]},"prev_vertical":"top","prev_vertical_value":{"unit":"%","size":-5.5,"sizes":[]},"prev_horizontal":"right","prev_horizontal_value":{"unit":"%","size":3,"sizes":[]},"visibility":"yes","prev_horizontal_value_tablet":{"unit":"%","size":4,"sizes":[]},"prev_horizontal_value_mobile":{"unit":"%","size":7,"sizes":[]},"next_vertical_value_mobile":{"unit":"%","size":-1.5,"sizes":[]},"prev_vertical_value_mobile":{"unit":"%","size":-1.5,"sizes":[]},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"babe-all-items"}],"isInner":false}],"isInner":false},{"id":"585f090","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"75","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"50","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"20","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"e0b6a7e","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"4fc8f1e","elType":"widget","settings":{"text":"Divider","color":"#E1E1E1"},"elements":[],"widgetType":"divider"}],"isInner":false}],"isInner":false},{"id":"a982f37","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin":{"unit":"px","top":"50","right":0,"bottom":"0","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"10","right":0,"bottom":"0","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"html_tag":"div"},"elements":[{"id":"81cc32e","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"a0cb851","elType":"widget","settings":{"title":"Recommended","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":60,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":30,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"heading"},{"id":"9a1ac37","elType":"widget","settings":{"per_page":"4","column":"3","style":"1","navigation":"arrows","enable_carousel":"yes","style_arrow":"style-2","next_vertical":"top","next_vertical_value":{"unit":"%","size":-6,"sizes":[]},"next_horizontal":"right","next_horizontal_value":{"unit":"%","size":0,"sizes":[]},"prev_vertical":"top","prev_vertical_value":{"unit":"%","size":-6,"sizes":[]},"prev_horizontal":"right","prev_horizontal_value":{"unit":"%","size":3,"sizes":[]},"visibility":"yes","prev_horizontal_value_tablet":{"unit":"%","size":4,"sizes":[]},"prev_horizontal_value_mobile":{"unit":"%","size":7,"sizes":[]},"next_vertical_value_mobile":{"unit":"%","size":-1.5,"sizes":[]},"prev_vertical_value_mobile":{"unit":"%","size":-1.5,"sizes":[]},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"babe-all-items"}],"isInner":false}],"isInner":false},{"id":"8eac901","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":340,"sizes":[]},"stretch_section":"section-stretched","structure":"40","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h2_bg-1.jpg","id":2135},"background_position":"center center","background_size":"cover","background_motion_fx_motion_fx_scrolling":"yes","background_motion_fx_translateY_effect":"yes","background_motion_fx_devices":["desktop","tablet"],"background_overlay_background":"classic","background_overlay_color":"#202F59","background_overlay_opacity":{"unit":"px","size":0.59999999999999997779553950749686919152736663818359375,"sizes":[]},"margin":{"unit":"px","top":"100","right":0,"bottom":"0","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding":{"unit":"px","top":"80","right":"30","bottom":"80","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"0","bottom":"60","left":"0","isLinked":false},"content_width":{"unit":"px","size":1320,"sizes":[]},"margin_mobile":{"unit":"px","top":"35","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"07ade75","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"space_between_widgets":0,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"animation":"opal-move-up","animation_duration":"fast","animation_delay":250},"elements":[{"id":"8ed3400","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-destination","library":"triply-icon"},"primary_color":"#FFFFFF","size":{"unit":"px","size":80,"sizes":[]},"size_mobile":{"unit":"px","size":60,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"icon"},{"id":"31c9017","elType":"widget","settings":{"starting_number":100,"ending_number":154,"title":"","number_color":"#FFFFFF","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":60,"sizes":[]},"typography_number_font_size_tablet":{"unit":"px","size":56,"sizes":[]},"typography_number_font_size_mobile":{"unit":"px","size":45,"sizes":[]}},"elements":[],"widgetType":"counter"},{"id":"9a3c104","elType":"widget","settings":{"editor":"Destinations","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"}},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"3d1e132","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"space_between_widgets":0,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"animation":"opal-move-up","animation_duration":"fast","animation_delay":350},"elements":[{"id":"683df59","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-tours","library":"triply-icon"},"primary_color":"#FFFFFF","size":{"unit":"px","size":80,"sizes":[]},"size_mobile":{"unit":"px","size":60,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"icon"},{"id":"4659ce2","elType":"widget","settings":{"starting_number":2100,"ending_number":2165,"title":"","number_color":"#FFFFFF","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":60,"sizes":[]},"typography_number_font_size_tablet":{"unit":"px","size":56,"sizes":[]},"typography_number_font_size_mobile":{"unit":"px","size":45,"sizes":[]}},"elements":[],"widgetType":"counter"},{"id":"545f94f","elType":"widget","settings":{"editor":"Amazing tours","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"}},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"1055aa0","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"space_between_widgets":0,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"animation":"opal-move-up","animation_duration":"fast","animation_delay":450},"elements":[{"id":"7244d46","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-types","library":"triply-icon"},"primary_color":"#FFFFFF","size":{"unit":"px","size":80,"sizes":[]},"size_mobile":{"unit":"px","size":60,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"icon"},{"id":"b5e5bba","elType":"widget","settings":{"starting_number":"","ending_number":98,"title":"","number_color":"#FFFFFF","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":60,"sizes":[]},"typography_number_font_size_tablet":{"unit":"px","size":56,"sizes":[]},"typography_number_font_size_mobile":{"unit":"px","size":45,"sizes":[]}},"elements":[],"widgetType":"counter"},{"id":"942288a","elType":"widget","settings":{"editor":"Tour types","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"}},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"a74cb10","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"animation":"opal-move-up","animation_duration":"fast","animation_delay":550},"elements":[{"id":"8ec3ed7","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-happy","library":"triply-icon"},"primary_color":"#FFFFFF","size":{"unit":"px","size":80,"sizes":[]},"size_mobile":{"unit":"px","size":60,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"icon"},{"id":"3a634e2","elType":"widget","settings":{"starting_number":117200,"ending_number":117259,"title":"","number_color":"#FFFFFF","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":60,"sizes":[]},"typography_number_font_size_tablet":{"unit":"px","size":56,"sizes":[]},"typography_number_font_size_mobile":{"unit":"px","size":45,"sizes":[]}},"elements":[],"widgetType":"counter"},{"id":"66125ba","elType":"widget","settings":{"editor":"Happy customers","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"}},"elements":[],"widgetType":"text-editor"}],"isInner":false}],"isInner":false},{"id":"32fd4b9","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"100","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"40","right":"15","bottom":"0","left":"15","isLinked":false},"padding_tablet":{"unit":"px","top":"75","right":"30","bottom":"0","left":"30","isLinked":false},"html_tag":"div"},"elements":[{"id":"c0cc858","elType":"column","settings":{"_column_size":100,"_inline_size":null,"align":"center","space_between_widgets":0},"elements":[{"id":"a6126ca","elType":"widget","settings":{"editor":"<div>Testimonials<\/div>","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":-0.5,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"text-editor"},{"id":"3525e2a","elType":"widget","settings":{"title":"Customer Reviews","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":-0.5,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_element_custom_width":{"unit":"px","size":410,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"heading"}],"isInner":false}],"isInner":false},{"id":"b1fc631","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"150","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"45","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"9ab77d4","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"662991c","elType":"widget","settings":{"testimonials":[{"testimonial_content":"\u201cThis was an amazing trip! There were so many highlights our outstanding, kind, patient, amazing leader!! What an absolute saint. He was so organized and insightful!\u201d ","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h3-img-box-1.png","id":2117},"testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"},"testimonial_name":"Melisa Joan H.","testimonial_job":"New York, USA","_id":"bc13047"},{"testimonial_content":"\"Thank you for a truly amazing stay. Your hospitality is quite outstanding. The sports centre is also very good with excellent quality tennis courts. Hope to be organized\u201d","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-5-2.jpg","id":2731},"testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"},"testimonial_name":"Chris Lee","testimonial_job":"New York, USA","_id":"fc129a4"},{"testimonial_content":"\u201cI am impressed with Royal Wing Suites & Spa. They are actually newer than some new hotels as they are continuously improving their product and adding new facilities.\u201d","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-4-2.jpg","id":2730},"testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"},"testimonial_name":"Sean Pearson","testimonial_job":"New York, USA","_id":"b0bbdde"},{"testimonial_content":"\"Thank you for a truly amazing stay. Your hospitality is quite outstanding. The sports centre is also very good with excellent quality tennis courts. Hope to be organized\u201d","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-3-2.jpg","id":2729},"testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"},"testimonial_name":"Roselin D.","testimonial_job":"New York, USA","_id":"b076b16"}],"column":"3","layout_style":"3","content_typography_typography":"custom","content_typography_font_size":{"unit":"px","size":18,"sizes":[]},"content_typography_line_height":{"unit":"px","size":30,"sizes":[]},"enable_carousel":"yes","content_spacing_mobile":{"unit":"px","size":20,"sizes":[]},"dots_vertical_value":{"unit":"%","size":-19,"sizes":[]},"__globals__":{"job_text_color":"globals\/colors?id=lighter"},"dots_vertical_value_tablet":{"unit":"px","size":-50,"sizes":[]},"dots_vertical_value_mobile":{"unit":"px","size":-30,"sizes":[]},"padding_estimonial_wrapper":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"padding_estimonial_wrapper_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"triply-testimonials"}],"isInner":false}],"isInner":false}],"home-3":[{"id":"aadfd63","elType":"section","settings":{"gap":"no","margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"margin_mobile":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"custom_height":{"unit":"px","size":600,"sizes":[]},"stretch_section":"section-stretched","background_background":"slideshow","background_motion_fx_motion_fx_scrolling":"yes","background_motion_fx_translateY_effect":"yes","background_slideshow_gallery":[{"id":1341,"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/home4_image-4.jpg"},{"id":1349,"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/home4_image-5.jpg"},{"id":2068,"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h2_bg.jpg"}],"background_slideshow_ken_burns":"yes","padding":{"unit":"px","top":"210","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"150","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"120","right":"15","bottom":"0","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"background_overlay_background":"classic","background_overlay_color":"#000000","background_overlay_opacity":{"unit":"px","size":0.1000000000000000055511151231257827021181583404541015625,"sizes":[]},"html_tag":"div"},"elements":[{"id":"f27f082","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"ac201e5","elType":"widget","settings":{"title":"Enjoy your stay","align":"center","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":80,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":60,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":42,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":80,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":60,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":42,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"text_shadow_text_shadow_type":"yes","text_shadow_text_shadow":{"horizontal":0,"vertical":1,"blur":5,"color":"rgba(0,0,0,0.3)"}},"elements":[],"widgetType":"heading"},{"id":"4dfc131","elType":"widget","settings":{"editor":"<p>Discover amazing places at exclusive deals<\/p>","align":"center","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"%","top":"0","right":"0","bottom":"17","left":"0","isLinked":false},"_margin_tablet":{"unit":"%","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"_margin_mobile":{"unit":"%","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"texteditor_shadow_text_shadow_type":"yes","texteditor_shadow_text_shadow":{"horizontal":0,"vertical":1,"blur":5,"color":"rgba(0,0,0,0.3)"}},"elements":[],"widgetType":"text-editor"},{"id":"972d4b1","elType":"widget","settings":{"taxonomy_search":[{"_id":"0ebeadf","taxonomy_slug":"locations","taxonomy_title":"Destinations","taxonomy_subtitle":"Where are you going?","taxonomy_icon":{"value":"triply-icon- triply-icon-map-marker-rounded","library":"triply-icon"}},{"_id":"2fddb76","taxonomy_slug":"types","taxonomy_title":"Activity","taxonomy_subtitle":"All Activity","taxonomy_icon":{"value":"triply-icon- triply-icon-activity","library":"triply-icon"}}],"date_title":"When","guests_title":"Guests","search_title":"Search","_margin":{"unit":"px","top":"0","right":"0","bottom":"-65","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"-95","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"-150","left":"0","isLinked":false},"_z_index":1},"elements":[],"widgetType":"babe-search-form"}],"isInner":false}],"isInner":false},{"id":"6454c2f","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"padding":{"unit":"px","top":"100","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/home4_deco-4.png","id":1330},"background_position":"top left","background_repeat":"no-repeat","background_repeat_tablet":"no-repeat","background_size":"auto","background_size_tablet":"initial","background_bg_width_tablet":{"unit":"%","size":50,"sizes":[]},"background_overlay_background":"classic","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/home4_deco-5.png","id":1334},"background_overlay_position":"top right","background_overlay_position_tablet":"top right","background_overlay_repeat":"no-repeat","background_overlay_repeat_tablet":"no-repeat","background_overlay_size":"auto","background_overlay_size_tablet":"initial","background_overlay_bg_width_tablet":{"unit":"%","size":50,"sizes":[]},"background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"margin_mobile":{"unit":"px","top":"150","right":0,"bottom":"60","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"80","right":"30","bottom":"0","left":"30","isLinked":false},"background_size_mobile":"initial","background_bg_width_mobile":{"unit":"px","size":0,"sizes":[]},"html_tag":"div"},"elements":[{"id":"7e100d7","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"motion_fx_translateY_effect":"yes"},"elements":[{"id":"45afadc","elType":"widget","settings":{"editor":"<div>What\u2019s new<\/div>","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"},"align_mobile":"center","_margin_tablet":{"unit":"px","top":"60","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"63bdbbf","elType":"widget","settings":{"title":"Recommended","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":60,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"67a22c2","elType":"widget","settings":{"per_page":"6","column":"3","_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-all-items"},{"id":"9adb88c","elType":"widget","settings":{"text":"View All  Tours","align":"center","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"typography_typography":"custom","typography_font_family":"Popins","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":20,"sizes":[]},"text_padding":{"unit":"px","top":"16","right":"36","bottom":"16","left":"36","isLinked":false},"__globals__":{"background_color":"globals\/colors?id=primary","button_background_hover_color":"globals\/colors?id=primary_hover"}},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false},{"id":"9d9562a","elType":"section","settings":{"content_width":{"unit":"px","size":1320,"sizes":[]},"gap":"no","custom_height":{"unit":"px","size":820,"sizes":[]},"stretch_section":"section-stretched","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h3-img-1_optimized-1.png","id":472},"background_position":"initial","background_repeat":"no-repeat","background_size":"cover","background_motion_fx_motion_fx_scrolling":"yes","background_motion_fx_translateY_effect":"yes","background_motion_fx_mouseTrack_effect":"yes","background_repeat_mobile":"no-repeat","background_size_mobile":"cover","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"background_color":"#F9F4F0","background_position_tablet":"top center","background_xpos":{"unit":"%","size":86,"sizes":[]},"background_ypos":{"unit":"px","size":300,"sizes":[]},"background_repeat_tablet":"no-repeat","background_size_tablet":"cover","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"f8b00d4","elType":"column","settings":{"_column_size":100,"_inline_size":null,"align":"center","space_between_widgets":0,"padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"margin":{"unit":"px","top":"100","right":"0","bottom":"70","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"80","right":"0","bottom":"50","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"60","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[{"id":"894e73f","elType":"widget","settings":{"editor":"<div>Why us<\/div>","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"}},"elements":[],"widgetType":"text-editor"},{"id":"f6245bf","elType":"widget","settings":{"title":"We Make All The\nProcess Easy","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":60,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"70","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":460,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"1463ccc","elType":"section","settings":{"layout":"full_width","gap":"no","structure":"30","animation":"opal-move-up","html_tag":"div"},"elements":[{"id":"f9be983","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"ddedb6e","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-best-travel","library":"triply-icon"},"view":"stacked","title_text":"Best Travel Agent","description_text":"The generated Lorem Ipsum is therefore always free from repetition","position":"left","primary_color":"#FFFFFF91","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_size":{"unit":"px","size":40,"sizes":[]},"title_bottom_space":{"unit":"px","size":15,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"description_typography_font_weight":"400","description_typography_line_height":{"unit":"px","size":26,"sizes":[]},"_background_background":"classic","_background_color":"#02010100","__globals__":{"secondary_color":"globals\/colors?id=primary","title_color":"globals\/colors?id=accent","hover_primary_color":"globals\/colors?id=primary"},"_padding":{"unit":"px","top":"0","right":"0","bottom":"60","left":"0","isLinked":false},"hover_secondary_color":"#FFFFFF","_padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"icon_space_mobile":{"unit":"px","size":10,"sizes":[]},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"_element_width_tablet":"initial","_element_width_mobile":"inherit","_element_custom_width_tablet":{"unit":"%","size":50,"sizes":[]}},"elements":[],"widgetType":"icon-box"},{"id":"704d92d","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-places","library":"triply-icon"},"view":"stacked","title_text":"Beautiful Places","description_text":"The generated Lorem Ipsum is therefore always free from repetition","position":"left","primary_color":"#FFFFFF91","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_size":{"unit":"px","size":40,"sizes":[]},"title_bottom_space":{"unit":"px","size":15,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"description_typography_font_weight":"400","description_typography_line_height":{"unit":"px","size":26,"sizes":[]},"_background_background":"classic","_background_color":"#02010100","__globals__":{"secondary_color":"globals\/colors?id=primary","title_color":"globals\/colors?id=accent","hover_primary_color":"globals\/colors?id=primary"},"_padding":{"unit":"px","top":"0","right":"0","bottom":"60","left":"0","isLinked":false},"hover_secondary_color":"#FFFFFF","_padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"icon_space_mobile":{"unit":"px","size":10,"sizes":[]},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"_element_width_tablet":"initial","_element_width_mobile":"inherit","_element_custom_width_tablet":{"unit":"%","size":50,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"ee41224","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"2a250f4","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-safety","library":"triply-icon"},"view":"stacked","title_text":"Trust & Safety","description_text":"There are many variations of passages of Lorem Ipsum available majority ","position":"left","primary_color":"#FFFFFF91","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_size":{"unit":"px","size":40,"sizes":[]},"title_bottom_space":{"unit":"px","size":15,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"description_typography_font_weight":"400","description_typography_line_height":{"unit":"px","size":26,"sizes":[]},"_background_background":"classic","_background_color":"#02010100","__globals__":{"secondary_color":"globals\/colors?id=primary","title_color":"globals\/colors?id=accent","hover_primary_color":"globals\/colors?id=primary"},"_padding":{"unit":"px","top":"0","right":"0","bottom":"60","left":"0","isLinked":false},"hover_secondary_color":"#FFFFFF","_padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"icon_space_mobile":{"unit":"px","size":10,"sizes":[]},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"_element_width_tablet":"initial","_element_width_mobile":"inherit","_element_custom_width_tablet":{"unit":"%","size":50,"sizes":[]}},"elements":[],"widgetType":"icon-box"},{"id":"713a7ea","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-passionate-travel","library":"triply-icon"},"view":"stacked","title_text":"Passionate Travel","description_text":"There are many variations of passages of Lorem Ipsum available","position":"left","primary_color":"#FFFFFF91","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_size":{"unit":"px","size":40,"sizes":[]},"title_bottom_space":{"unit":"px","size":15,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"description_typography_font_weight":"400","description_typography_line_height":{"unit":"px","size":26,"sizes":[]},"_background_background":"classic","_background_color":"#02010100","__globals__":{"secondary_color":"globals\/colors?id=primary","title_color":"globals\/colors?id=accent","hover_primary_color":"globals\/colors?id=primary"},"_padding":{"unit":"px","top":"0","right":"0","bottom":"60","left":"0","isLinked":false},"hover_secondary_color":"#FFFFFF","_padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"icon_space_mobile":{"unit":"px","size":10,"sizes":[]},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"_element_width_tablet":"initial","_element_width_mobile":"inherit","_element_custom_width_tablet":{"unit":"%","size":50,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"de49a26","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":100,"space_between_widgets_tablet":0,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"2301f4a","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-best-price","library":"triply-icon"},"view":"stacked","title_text":"Best Price Guarantee","description_text":"All the Lorem Ipsum generators on the\nInternet tend to repeat but majority ","position":"left","primary_color":"#FFFFFF91","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_size":{"unit":"px","size":40,"sizes":[]},"title_bottom_space":{"unit":"px","size":15,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"description_typography_font_weight":"400","description_typography_line_height":{"unit":"px","size":26,"sizes":[]},"_background_background":"classic","_background_color":"#02010100","__globals__":{"secondary_color":"globals\/colors?id=primary","title_color":"globals\/colors?id=accent","hover_primary_color":"globals\/colors?id=primary"},"_padding":{"unit":"px","top":"0","right":"0","bottom":"60","left":"0","isLinked":false},"hover_secondary_color":"#FFFFFF","_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"_padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_element_width_tablet":"initial","_element_width_mobile":"inherit","_element_custom_width_tablet":{"unit":"%","size":50,"sizes":[]},"icon_space_mobile":{"unit":"px","size":10,"sizes":[]}},"elements":[],"widgetType":"icon-box"},{"id":"19c3555","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-fast-booking","library":"triply-icon"},"view":"stacked","title_text":"Fast Booking","description_text":"If you are going to use a passage of Lorem Ipsum, you need to be sure","position":"left","primary_color":"#FFFFFF91","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_size":{"unit":"px","size":40,"sizes":[]},"title_bottom_space":{"unit":"px","size":15,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"description_typography_font_weight":"400","description_typography_line_height":{"unit":"px","size":26,"sizes":[]},"_background_background":"classic","_background_color":"#02010100","__globals__":{"secondary_color":"globals\/colors?id=primary","title_color":"globals\/colors?id=accent","hover_primary_color":"globals\/colors?id=primary"},"_padding":{"unit":"px","top":"0","right":"0","bottom":"60","left":"0","isLinked":false},"hover_secondary_color":"#FFFFFF","_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_element_width_tablet":"initial","_element_width_mobile":"inherit","_element_custom_width_tablet":{"unit":"%","size":50,"sizes":[]},"icon_space_mobile":{"unit":"px","size":10,"sizes":[]},"_padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"icon-box"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"1d1c883","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"1ef6230","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"6ec40f7","elType":"widget","settings":{"editor":"<div>Don\u2019t miss<\/div>","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"},"align_mobile":"center","_padding":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"e1c1ebc","elType":"widget","settings":{"title":"Deals & Discounts","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":50,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"60","left":"0","isLinked":false},"_element_custom_width":{"unit":"px","size":460,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":-0.5,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"29767df","elType":"section","settings":{"gap":"no","structure":"20","margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"c49fe18","elType":"column","settings":{"_column_size":50,"_inline_size":32.86800000000000210320649784989655017852783203125,"space_between_widgets":0,"background_background":"classic","background_color":"#E4EBF1","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h3-img-11_optimized.png","id":2740},"background_position":"center center","background_repeat":"no-repeat","background_size":"auto","background_overlay_background":"classic","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h3-layout-2.png","id":4982},"background_overlay_position":"bottom right","background_overlay_xpos":{"unit":"px","size":-300,"sizes":[]},"background_overlay_ypos":{"unit":"px","size":350,"sizes":[]},"background_overlay_repeat":"no-repeat","background_overlay_size":"auto","background_overlay_opacity":{"unit":"px","size":"","sizes":[]},"border_border":"solid","border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"margin":{"unit":"px","top":"0","right":"15","bottom":"30","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_inline_size_tablet":100,"space_between_widgets_tablet":0,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"030","left":"0","isLinked":false},"background_overlay_position_mobile":"bottom right","background_overlay_xpos_mobile":{"unit":"%","size":0,"sizes":[]},"background_overlay_ypos_mobile":{"unit":"%","size":200,"sizes":[]},"align_tablet":"center","background_overlay_position_tablet":"initial","background_overlay_xpos_tablet":{"unit":"%","size":0,"sizes":[]},"background_overlay_ypos_tablet":{"unit":"%","size":100,"sizes":[]},"background_overlay_repeat_tablet":"no-repeat","background_overlay_size_tablet":"contain","background_overlay_size_mobile":"auto","background_overlay_bg_width_tablet":{"unit":"%","size":100,"sizes":[]},"background_position_mobile":"center center","background_ypos_tablet":{"unit":"px","size":-381,"sizes":[]},"background_repeat_tablet":"no-repeat","background_size_tablet":"cover","background_overlay_bg_width_mobile":{"unit":"%","size":5,"sizes":[]}},"elements":[{"id":"fd0a402","elType":"widget","settings":{"editor":"<div>Discount<\/div>","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":60,"sizes":[]},"__globals__":{"text_color":""},"align_mobile":"center","text_color":"#FFFFFF","typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"align_tablet":"center","_margin":{"unit":"px","top":"80","right":"0","bottom":"-65","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"80","right":"0","bottom":"-65","left":"0","isLinked":false},"align":"center","texteditor_shadow_text_shadow_type":"yes","texteditor_shadow_text_shadow":{"horizontal":0,"vertical":1,"blur":5,"color":"rgba(0,0,0,0.3)"}},"elements":[],"widgetType":"text-editor"},{"id":"2695de3","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h2_50off.png","id":2317},"image_size":"full","align_mobile":"center","_margin":{"unit":"px","top":"0","right":"0","bottom":"160","left":"0","isLinked":false},"_z_index":0},"elements":[],"widgetType":"image"},{"id":"1b49b78","elType":"widget","settings":{"title":"Book Early to Save","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":30,"sizes":[]},"_z_index":1,"typography_font_size_mobile":{"unit":"px","size":20,"sizes":[]},"align_tablet":"center","_padding":{"unit":"px","top":"0","right":"0","bottom":"05","left":"80","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"9c67334","elType":"widget","settings":{"editor":"Enjoy 15% or more off stays between <br>nowand January 4, 2021","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":24,"sizes":[]},"align_tablet":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"010","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"10","left":"80","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"78457df","elType":"widget","settings":{"text":"Book Now","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":24,"sizes":[]},"background_color":"#FFFFFF","border_border":"solid","border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"border_radius":{"unit":"px","top":"5","right":"5","bottom":"5","left":"5","isLinked":true},"__globals__":{"button_text_color":"globals\/colors?id=accent","button_background_hover_color":"globals\/colors?id=secondary","hover_color":"","button_hover_border_color":"","button_icon_color":"globals\/colors?id=primary"},"button_text_color":"#000000","align_tablet":"center","button_icon_color":"#dc834e","_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"80","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"hover_color":"#FFFFFF"},"elements":[],"widgetType":"button"}],"isInner":true},{"id":"7b65413","elType":"column","settings":{"_column_size":50,"_inline_size":67.13200000000000500222085975110530853271484375,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":100,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"space_between_widgets_tablet":0,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"space_between_widgets":0},"elements":[{"id":"e46341c","elType":"widget","settings":{"per_page":"4","column_tablet":"2","style":"2","_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-all-items"}],"isInner":true}],"isInner":true},{"id":"9830abb","elType":"widget","settings":{"editor":"<div>Need inspiration for your next post-isolation trip? Explore <a style=\"color:#dc834e;border-bottom: 1px solid #dc834e;\"> unique tours<\/a><\/div>","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":26,"sizes":[]}},"elements":[],"widgetType":"text-editor"}],"isInner":false}],"isInner":false},{"id":"3fbd78f","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color":"#F9F4F0","padding":{"unit":"px","top":"100","right":"30","bottom":"100","left":"30","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"80","right":"30","bottom":"80","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"15","bottom":"60","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"1d79d5a","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"align":"space-between"},"elements":[{"id":"6b010a9","elType":"widget","settings":{"editor":"Testimonials ","align":"center","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"5c52945","elType":"widget","settings":{"title":"Customer Reviews","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"99008f5","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_quote-1.png","id":2016},"image_size":"full","align":"left","_element_width":"initial","_element_custom_width":{"unit":"%","size":17,"sizes":[]},"_element_custom_width_tablet":{"unit":"%","size":14,"sizes":[]},"_element_width_tablet":"initial","hide_mobile":"hidden-phone","_animation":"swing","_padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"360b73e","elType":"widget","settings":{"testimonials":[{"testimonial_content":"\u201cThis was an amazing trip! There were so many highlights... our outstanding, kind, patient, amazing leader Gustavo!! What an absolute saint. He was so organized and insightful!\u201d ","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h3-img-box-1.png","id":2117},"testimonial_name":"Melisa Joan H.","testimonial_job":" New York, USA","_id":"87f87d2","testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"}},{"testimonial_content":"\"Needless to say we are extremely satisfied with the results. Booking tour was the best investment I ever made. Nice work on your booking tour. Booking tour impressed.\"","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-4-2.jpg","id":2730},"testimonial_name":"Roselin D.","testimonial_job":" New York, USA","testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"},"_id":"cadac67"},{"testimonial_content":"\"Great job, I will definitely be ordering again! After using booking tour my business skyrocketed! Man, this thing is getting better and better as I learn more about it. \"","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-5-2.jpg","id":2731},"testimonial_name":"Cleveland A.","testimonial_job":" New York, USA","testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"},"_id":"3d47fe4"}],"column":"1","content_typography_line_height":{"unit":"px","size":"","sizes":[]},"enable_carousel":"yes","_element_width":"initial","_element_custom_width":{"unit":"%","size":66,"sizes":[]},"content_typography_typography":"custom","content_typography_font_size_tablet":{"unit":"px","size":22,"sizes":[]},"content_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"_element_width_tablet":"initial","_element_width_mobile":"inherit","_element_custom_width_tablet":{"unit":"%","size":68,"sizes":[]}},"elements":[],"widgetType":"triply-testimonials"},{"id":"6260499","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_quote-2.png","id":2017},"image_size":"full","align":"right","_element_width":"initial","_element_custom_width":{"unit":"%","size":17,"sizes":[]},"_element_custom_width_tablet":{"unit":"%","size":14,"sizes":[]},"_element_width_tablet":"initial","hide_mobile":"hidden-phone","_animation":"swing","_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false}},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"a8c8b3e","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"html_tag":"div"},"elements":[{"id":"1b6d00b","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"24ef83f","elType":"widget","settings":{"editor":"<div>Choose your<\/div>","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"},"align_mobile":"center","_padding":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"8121b3d","elType":"widget","settings":{"title":"Destinations","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":50,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"60","left":"0","isLinked":false},"_element_custom_width":{"unit":"px","size":460,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":-0.5,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]}},"elements":[],"widgetType":"heading"}],"isInner":false}],"isInner":false},{"id":"5b237fe","elType":"section","settings":{"gap":"no","custom_height":{"unit":"px","size":"","sizes":[]},"stretch_section":"section-stretched","structure":"50","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h3-icon-box.png","id":3597},"background_position":"center left","background_repeat":"no-repeat","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"20","bottom":"0","left":"20","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"background_size_mobile":"initial","background_bg_width_mobile":{"unit":"px","size":0,"sizes":[]},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"40","left":0,"isLinked":false},"animation":"opal-move-up","html_tag":"div"},"elements":[{"id":"08e687b","elType":"column","settings":{"_column_size":20,"_inline_size":20,"margin":{"unit":"px","top":"90","right":"40","bottom":"0","left":"40","isLinked":false},"space_between_widgets":0,"_inline_size_tablet":33,"space_between_widgets_tablet":0,"margin_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"60","bottom":"30","left":"60","isLinked":false}},"elements":[{"id":"7fa3102","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"americas","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-02.jpg","id":3489},"count_tour":"yes","custom_text":"From <span>100$<\/span>","img_location_radius":{"unit":"%","top":"50","right":"50","bottom":"50","left":"50","isLinked":true},"img_overflow":"","Typography_typography":"custom","Typography_font_size":{"unit":"px","size":20,"sizes":[]},"Typography_line_height":{"unit":"px","size":25,"sizes":[]},"count_background_color":"#02010100","count_typography_typography":"custom","count_typography_font_size":{"unit":"px","size":14,"sizes":[]},"count_typography_font_weight":"500","count_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"title_space":{"unit":"px","size":0,"sizes":[]},"image_opacity":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"image_opacity_hover":{"unit":"px","size":0.5,"sizes":[]},"image_background_overlay":"#202F59"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":false},{"id":"e5fd2ef","elType":"column","settings":{"_column_size":20,"_inline_size":20,"space_between_widgets":0,"margin":{"unit":"px","top":"50","right":"40","bottom":"0","left":"40","isLinked":false},"_inline_size_tablet":33,"margin_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"space_between_widgets_tablet":0,"margin_mobile":{"unit":"px","top":"0","right":"60","bottom":"30","left":"60","isLinked":false}},"elements":[{"id":"24e1058","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"nepal","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/Destination_image-2.jpg","id":4236},"count_tour":"yes","custom_text":"From <span>100$<\/span>","img_location_radius":{"unit":"%","top":"50","right":"50","bottom":"50","left":"50","isLinked":true},"img_overflow":"","Typography_typography":"custom","Typography_font_size":{"unit":"px","size":20,"sizes":[]},"Typography_line_height":{"unit":"px","size":25,"sizes":[]},"count_background_color":"#02010100","count_typography_typography":"custom","count_typography_font_size":{"unit":"px","size":14,"sizes":[]},"count_typography_font_weight":"500","count_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"title_space":{"unit":"px","size":0,"sizes":[]},"image_opacity":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"image_opacity_hover":{"unit":"px","size":0.5,"sizes":[]},"image_background_overlay":"#202F59"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":false},{"id":"4722b68","elType":"column","settings":{"_column_size":20,"_inline_size":20,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"40","bottom":"0","left":"40","isLinked":false},"_inline_size_tablet":33,"margin_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"55","bottom":"20","left":"55","isLinked":false}},"elements":[{"id":"4dbebd3","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"morocco","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-03.jpg","id":3493},"count_tour":"yes","custom_text":"From <span>100$<\/span>","img_location_radius":{"unit":"%","top":"50","right":"50","bottom":"50","left":"50","isLinked":true},"img_overflow":"","Typography_typography":"custom","Typography_font_size":{"unit":"px","size":20,"sizes":[]},"Typography_line_height":{"unit":"px","size":25,"sizes":[]},"count_background_color":"#02010100","count_typography_typography":"custom","count_typography_font_size":{"unit":"px","size":14,"sizes":[]},"count_typography_font_weight":"500","count_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"title_space":{"unit":"px","size":0,"sizes":[]},"image_opacity":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"image_opacity_hover":{"unit":"px","size":0.5,"sizes":[]},"image_background_overlay":"#202F59"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":false},{"id":"45b161c","elType":"column","settings":{"_column_size":20,"_inline_size":19.95400000000000062527760746888816356658935546875,"space_between_widgets":0,"margin":{"unit":"px","top":"50","right":"40","bottom":"0","left":"40","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"30","right":"90","bottom":"0","left":"90","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"55","bottom":"20","left":"55","isLinked":false}},"elements":[{"id":"6f920c1","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"tanzania","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-04.jpg","id":3494},"count_tour":"yes","custom_text":"From <span>100$<\/span>","img_location_radius":{"unit":"%","top":"50","right":"50","bottom":"50","left":"50","isLinked":true},"img_overflow":"","Typography_typography":"custom","Typography_font_size":{"unit":"px","size":20,"sizes":[]},"Typography_line_height":{"unit":"px","size":25,"sizes":[]},"count_background_color":"#02010100","count_typography_typography":"custom","count_typography_font_size":{"unit":"px","size":14,"sizes":[]},"count_typography_font_weight":"500","count_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"title_space":{"unit":"px","size":0,"sizes":[]},"image_opacity":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"image_opacity_hover":{"unit":"px","size":0.5,"sizes":[]},"image_background_overlay":"#202F59"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":false},{"id":"c3fb41a","elType":"column","settings":{"_column_size":20,"_inline_size":20,"margin":{"unit":"px","top":"90","right":"40","bottom":"0","left":"40","isLinked":false},"space_between_widgets":0,"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"30","right":"90","bottom":"0","left":"90","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"50","bottom":"20","left":"50","isLinked":false}},"elements":[{"id":"f5f984f","elType":"widget","settings":{"taxonomy_slug":"locations","locations_id":"thailand","image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/destination-05.jpg","id":3495},"count_tour":"yes","custom_text":"From <span>100$<\/span>","img_location_radius":{"unit":"%","top":"50","right":"50","bottom":"50","left":"50","isLinked":true},"img_overflow":"","Typography_typography":"custom","Typography_font_size":{"unit":"px","size":20,"sizes":[]},"Typography_line_height":{"unit":"px","size":25,"sizes":[]},"count_background_color":"#02010100","count_typography_typography":"custom","count_typography_font_size":{"unit":"px","size":14,"sizes":[]},"count_typography_font_weight":"500","count_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"title_space":{"unit":"px","size":0,"sizes":[]},"image_opacity":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"image_opacity_hover":{"unit":"px","size":0.5,"sizes":[]},"image_background_overlay":"#202F59"},"elements":[],"widgetType":"taxonomy-item"}],"isInner":false}],"isInner":false},{"id":"2a14cf6","elType":"section","settings":{"gap":"no","custom_height":{"unit":"px","size":700,"sizes":[]},"stretch_section":"section-stretched","structure":"20","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h3-img-layout-3.png","id":780},"background_position":"center right","background_position_tablet":"bottom right","background_repeat":"no-repeat","background_size":"auto","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":6,"sizes":[]},"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"background_size_mobile":"initial","background_bg_width_mobile":{"unit":"px","size":0,"sizes":[]},"padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"e3d6b4c","elType":"column","settings":{"_column_size":50,"_inline_size":55,"_inline_size_tablet":50,"space_between_widgets":0,"background_position":"center center","background_repeat":"no-repeat","background_size":"auto","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-2.png","id":724},"background_overlay_position":"top right","background_overlay_repeat":"no-repeat","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"css_filters_brightness":{"unit":"px","size":103,"sizes":[]},"css_filters_contrast":{"unit":"px","size":110,"sizes":[]},"background_background":"classic","space_between_widgets_tablet":0},"elements":[{"id":"49d3571","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-1.1.png","id":736},"image_size":"full","align_tablet":"center","align_mobile":"center"},"elements":[],"widgetType":"image"},{"id":"68abc00","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-2.png","id":724},"image_size":"full","_element_width":"auto","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"%","size":80,"sizes":[]},"_position":"absolute","_offset_orientation_h":"end","_offset_x_end":{"size":2.5,"unit":"px"},"_offset_x_end_mobile":{"unit":"px","size":0,"sizes":[]},"_offset_orientation_v":"end","_offset_y_end":{"size":20,"unit":"px"},"_offset_y_end_mobile":{"unit":"px","size":0,"sizes":[]},"motion_fx_mouseTrack_effect":"yes","_offset_x_end_tablet":{"size":1,"unit":"px"},"_offset_y_end_tablet":{"size":60,"unit":"px"}},"elements":[],"widgetType":"image"}],"isInner":false},{"id":"40eed71","elType":"column","settings":{"_column_size":50,"_inline_size":45,"_inline_size_tablet":50,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"80","bottom":"0","left":"80","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"align_mobile":"center","space_between_widgets_tablet":0,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"873507f","elType":"widget","settings":{"editor":"<div>About<\/div>","align":"left","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"},"align_mobile":"center","_padding":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"4661902","elType":"widget","settings":{"title":"We Help You\nPlanning Your\nJourney","align":"left","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":50,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":460,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":-0.5,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"c65333c","elType":"widget","settings":{"editor":"<div>Lorem ipsum dolor sit amet, consectetur adipiicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\/div>","align_mobile":"center","text_color":"#999999","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":30,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"px","size":330,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"638afbe","elType":"widget","settings":{"editor":"<p>Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.<\/p>","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":24,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"px","size":330,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"09100c8","elType":"widget","settings":{"text":"Learn More","align":"left","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"typography_typography":"custom","typography_font_family":"Popins","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":20,"sizes":[]},"text_padding":{"unit":"px","top":"15","right":"32","bottom":"15","left":"32","isLinked":false},"__globals__":{"background_color":"","button_text_color":"globals\/colors?id=secondary","border_color":"globals\/colors?id=secondary","button_hover_border_color":""},"align_mobile":"center","button_text_color":"#202F59","background_color":"#FFFFFF","button_hover_border_color":"#dc834e","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"border_color":"#202F59","border_radius":{"unit":"px","top":"5","right":"5","bottom":"5","left":"5","isLinked":true},"_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"px","size":330,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false},{"id":"d552e24","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"bf64d23","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"f781e09","elType":"widget","settings":{"editor":"<div>Our blog<\/div>","align":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":"","sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"},"align_mobile":"center","_padding":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"a82e787","elType":"widget","settings":{"title":"Travel Tips and Advice","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":50,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"_element_custom_width":{"unit":"px","size":460,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":-0.5,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"8a2e078","elType":"widget","settings":{"categories":["uncategorized"],"column":"2","pagination_page_limit":"5","pagination_prev_label":"&laquo; Previous","pagination_next_label":"Next &raquo;","enable_carousel":"yes","column_tablet":"1","posts_per_page":3},"elements":[],"widgetType":"triply-post-grid"}],"isInner":false}],"isInner":false}],"headerbuilder":[{"id":"69072552","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","content_position":"middle","stretch_section":"section-stretched","structure":"30","margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"height":"min-height","custom_height":{"unit":"px","size":100,"sizes":[]},"custom_height_tablet":{"unit":"px","size":80,"sizes":[]},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"css_classes":"sticky-header","sticky":"top","sticky_effects_offset":120,"html_tag":"div","background_background":"classic","background_color":"#FFFFFF","custom_css":"header.sticky-header {\r\n    --header-height: 100px;\r\n    \/*--opacity: 0.90;*\/\r\n    --shrink-me: 0.80;\r\n    --sticky-background-color: #fff;\r\n    --transition: .3s ease-in-out;\r\n\r\n    transition: background-color var(--transition),\r\n                background-image var(--transition),\r\n                backdrop-filter var(--transition),\r\n                opacity var(--transition);\r\n}\r\nheader.sticky-header.elementor-sticky--effects {\r\n    background-color: var(--sticky-background-color) !important;\r\n    background-image: none !important;\r\n    opacity: var(--opacity) !important;\r\n    -webkit-backdrop-filter: blur(10px);\r\n    backdrop-filter: blur(10px);\r\n    box-shadow: 0 8px 20px 0 rgba(0,0,0,.1);\r\n}\r\nheader.sticky-header > .elementor-container {\r\n    transition: min-height var(--transition);\r\n}\r\nheader.sticky-header.elementor-sticky--effects > .elementor-container {\r\n    min-height: calc(var(--header-height) * var(--shrink-me))!important;\r\n    height: calc(var(--header-height) * var(--shrink-me));\r\n}\r\nheader.sticky-header .elementor-nav-menu .elementor-item {\r\n    transition: padding var(--transition);\r\n}\r\nheader.sticky-header.elementor-sticky--effects .elementor-nav-menu .elementor-item {\r\n    padding-bottom: 10px!important;\r\n    padding-top: 10px!important;\r\n}\r\nheader.sticky-header > .elementor-container .logo img {\r\n    transition: max-width var(--transition);\r\n}\r\nheader.sticky-header.elementor-sticky--effects .logo img {\r\n    max-width: calc(100% * var(--shrink-me));\r\n}"},"elements":[{"id":"6733616b","elType":"column","settings":{"_column_size":33,"_inline_size":13.6111109999999992936636772355996072292327880859375,"space_between_widgets":0,"_inline_size_tablet":50,"align_tablet":"flex-start","margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_mobile":60},"elements":[{"id":"66f99ff","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-bars","library":"triply-icon"},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"size":{"unit":"px","size":20,"sizes":[]},"_element_width":"auto","hide_desktop":"hidden-desktop","__globals__":{"primary_color":"globals\/colors?id=accent","hover_primary_color":"globals\/colors?id=primary"},"__dynamic__":{"link":"[elementor-tag id=\"f8c3747\" name=\"popup\" settings=\"%7B%22popup%22%3A%221209%22%7D\"]"},"_padding":{"unit":"px","top":"6","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"10","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"icon"},{"id":"75d5909a","elType":"widget","settings":{"__dynamic__":{"image":"[elementor-tag id=\"\" name=\"site-logo\" settings=\"%7B%7D\"]","link":"[elementor-tag id=\"\" name=\"site-url\" settings=\"%7B%7D\"]"},"align":"left","width":{"unit":"px","size":130,"sizes":[]},"_element_width":"auto","_css_classes":"logo"},"elements":[],"widgetType":"theme-site-logo"}],"isInner":false},{"id":"a87471b","elType":"column","settings":{"_column_size":33,"_inline_size":66,"space_between_widgets":0,"content_position":"center","_inline_size_tablet":100,"hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone"},"elements":[{"id":"32a3ceff","elType":"widget","settings":{"nav_menu_aligrment":"left"},"elements":[],"widgetType":"triply-nav-menu"}],"isInner":false},{"id":"f3d336e","elType":"column","settings":{"_column_size":33,"_inline_size":20.053999999999998493649400188587605953216552734375,"align":"flex-end","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"_inline_size_tablet":50,"_inline_size_mobile":40},"elements":[{"id":"36fefbb8","elType":"widget","settings":{"icon_list":[{"text":"1800 - 333 5578","selected_icon":{"value":"triply-icon- triply-icon-phone-1","library":"triply-icon"},"_id":"566c539","link":{"url":"tel:1800 - 333 5578","is_external":"","nofollow":"","custom_attributes":""}}],"icon_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_font_weight":"700","_element_width":"auto","__globals__":{"text_color":"globals\/colors?id=accent","text_color_hover":"globals\/colors?id=primary"},"hide_mobile":"hidden-phone"},"elements":[],"widgetType":"icon-list"},{"id":"3f99baa2","elType":"widget","settings":{"width":{"unit":"px","size":1,"sizes":[]},"text":"Divider","color":"#00000030","weight":{"unit":"px","size":20,"sizes":[]},"gap":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"_element_width":"auto","hide_mobile":"hidden-phone"},"elements":[],"widgetType":"divider"},{"id":"7bf2274","elType":"widget","settings":{"size":{"unit":"px","size":18,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"_element_width":"auto","login_title":"Log In","separator":"\/","register_title":"Register"},"elements":[],"widgetType":"triply-login"},{"id":"151299dd","elType":"widget","settings":{"selected_icon":{"value":"triply-icon- triply-icon-menu","library":"triply-icon"},"size":{"unit":"px","size":18,"sizes":[]},"_element_width":"auto","__dynamic__":{"link":"[elementor-tag id=\"99d614e\" name=\"popup\" settings=\"%7B%22popup%22%3A%221589%22%7D\"]"},"__globals__":{"primary_color":"globals\/colors?id=accent","hover_primary_color":"globals\/colors?id=primary"},"_padding":{"unit":"px","top":"6","right":"0","bottom":"0","left":"0","isLinked":false},"primary_color":"#000000","_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"10","isLinked":false}},"elements":[],"widgetType":"icon"}],"isInner":false}],"isInner":false},{"id":"4a39b113","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_position":"center center","background_repeat":"no-repeat","background_size":"cover","padding":{"unit":"px","top":"30","right":"30","bottom":"30","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"15","bottom":"30","left":"15","isLinked":false},"height":"min-height","custom_height":{"unit":"px","size":200,"sizes":[]},"css_classes":"triply-breadcrumb-build","background_color":"#000000","background_overlay_background":"classic","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/breadcrumb-bg.jpg","id":2725},"background_overlay_position":"center center","background_overlay_repeat":"no-repeat","background_overlay_size":"auto","background_overlay_opacity":{"unit":"px","size":0.6999999999999999555910790149937383830547332763671875,"sizes":[]},"margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"margin_tablet":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"html_tag":"div"},"elements":[{"id":"411ddc6d","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"4f8e45e3","elType":"widget","settings":{"title":"Blog","align":"center","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":42,"sizes":[]},"typography_font_weight":"700","_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"3c6b8263","elType":"widget","settings":{"__dynamic__":{"title":"[elementor-tag id=\"\" name=\"page-title\" settings=\"%7B%22include_context%22%3A%22%22%2C%22show_home_title%22%3A%22%22%2C%22before%22%3A%22%22%2C%22after%22%3A%22%22%2C%22fallback%22%3A%22%22%7D\"]"},"title":"Add Your Heading Text Here","align":"center","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_font_weight":"700","typography_text_transform":"capitalize","_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"typography_font_size_mobile":{"unit":"px","size":42,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"theme-page-title"}],"isInner":false}],"isInner":false}],"ba-wishlist":[{"id":"b6104a0","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"0d64af5","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"75e0ad9","elType":"widget","settings":{"per_page":"5"},"elements":[],"widgetType":"ba-wishlist"}],"isInner":false}],"isInner":false}],"booking-locations":[{"id":"829be05","elType":"section","settings":{"margin":{"unit":"px","top":"80","right":0,"bottom":"50","left":0,"isLinked":false},"gap":"no","structure":"20","border_border":"solid","border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"border_color":"#E5E5E5","padding":{"unit":"px","top":"0","right":"0","bottom":"90","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"50","right":0,"bottom":"50","left":0,"isLinked":true},"html_tag":"div"},"elements":[{"id":"7c62f2c","elType":"column","settings":{"_column_size":50,"_inline_size":null,"padding":{"unit":"px","top":"0","right":"50","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"2662cac","elType":"widget","settings":{"title":"Overview","header_size":"h3","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_line_height":{"unit":"em","size":1,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"9ea18f5","elType":"widget","settings":{"__dynamic__":{"editor":"[elementor-tag id=\"b666967\" name=\"archive-description\" settings=\"%7B%7D\"]"}},"elements":[],"widgetType":"text-editor"},{"id":"b58e24b","elType":"widget","settings":{"content_spacing_tablet":{"unit":"px","size":150,"sizes":[]}},"elements":[],"widgetType":"babe-archive-info"}],"isInner":false},{"id":"50c15de","elType":"column","settings":{"_column_size":50,"_inline_size":null,"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true}},"elements":[{"id":"15359e4","elType":"widget","settings":{"image_size":"triply-item","width":{"unit":"%","size":100,"sizes":[]},"image_border_radius":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true}},"elements":[],"widgetType":"babe-featured-image"}],"isInner":false}],"isInner":false},{"id":"fbb33fd","elType":"section","settings":{"margin":{"unit":"px","top":"50","right":0,"bottom":"90","left":0,"isLinked":false},"gap":"no","margin_tablet":{"unit":"px","top":"50","right":0,"bottom":"50","left":0,"isLinked":true},"html_tag":"div"},"elements":[{"id":"03cdef0","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"fe903bf","elType":"widget","settings":{"title":"Explore","header_size":"h3","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_line_height":{"unit":"em","size":1,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"aa9d26a","elType":"widget","settings":{"column":"3","style":"1"},"elements":[],"widgetType":"babe-archive-items"}],"isInner":false}],"isInner":false}],"home-1":[{"id":"faa0393","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":620,"sizes":[]},"custom_height_tablet":{"unit":"px","size":420,"sizes":[]},"custom_height_mobile":{"unit":"px","size":300,"sizes":[]},"overflow":"hidden","stretch_section":"section-stretched","background_background":"classic","background_color":"#F9F4F0","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape.png","id":1048},"background_position":"center left","background_repeat":"no-repeat","background_motion_fx_motion_fx_scrolling":"yes","background_motion_fx_translateY_effect":"yes","background_motion_fx_devices":["desktop","tablet"],"background_overlay_background":"classic","background_overlay_position":"center right","background_overlay_repeat":"no-repeat","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding":{"unit":"px","top":"60","right":"30","bottom":"100","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"80","right":"15","bottom":"80","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"3cabfda","elType":"column","settings":{"_column_size":100,"_inline_size":null,"align_mobile":"center","space_between_widgets":0},"elements":[{"id":"a70db89","elType":"widget","settings":{"editor":"Natural beauty","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_z_index":2,"hide_mobile":"hidden-phone","__globals__":{"text_color":"globals\/colors?id=primary"},"_animation":"opal-move-right","animation_duration":"fast"},"elements":[],"widgetType":"text-editor"},{"id":"91bd637","elType":"widget","settings":{"editor":"Natural beauty","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":24,"sizes":[]},"typography_font_weight":"600","_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_z_index":2,"hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet","__globals__":{"text_color":"globals\/colors?id=secondary"},"_animation_mobile":"opal-move-up"},"elements":[],"widgetType":"text-editor"},{"id":"cbcda7d","elType":"widget","settings":{"title":"Discover the most engaging places","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":75,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":60,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":42,"sizes":[]},"typography_line_height":{"unit":"px","size":75,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":60,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":42,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_z_index":2,"_element_width":"initial","_element_width_tablet":"initial","_element_custom_width":{"unit":"px","size":602},"_element_custom_width_tablet":{"unit":"px","size":500,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"_animation":"opal-move-right","animation_duration":"fast","_animation_mobile":"opal-move-up","text_shadow_text_shadow_type":"yes","text_shadow_text_shadow":{"horizontal":0,"vertical":1,"blur":5,"color":"rgba(255, 255, 255, 0.5)"}},"elements":[],"widgetType":"heading"},{"id":"f429362","elType":"widget","settings":{"text":"Explore Now","align_mobile":"center","size":"lg","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"_z_index":2,"__globals__":{"background_color":"globals\/colors?id=secondary","button_background_hover_color":"globals\/colors?id=secondary_hover"},"background_color":"#202F59","_animation":"opal-move-up","animation_duration":"fast","_animation_mobile":"opal-move-up"},"elements":[],"widgetType":"button"},{"id":"fb67f8f","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_bg-1.jpg","id":1011},"image_size":"full","_element_width":"initial","_element_custom_width":{"unit":"px","size":1275,"sizes":[]},"_position":"absolute","_offset_x":{"size":329,"unit":"px"},"_offset_x_mobile":{"unit":"%","size":50,"sizes":[]},"_offset_x_end":{"unit":"px","size":-315,"sizes":[]},"_offset_y":{"size":-180,"unit":"px"},"_animation":"opal-move-left","animation_duration":"fast","opacity":{"unit":"px","size":0.90000000000000002220446049250313080847263336181640625,"sizes":[]},"opacity_hover":{"unit":"px","size":0.90000000000000002220446049250313080847263336181640625,"sizes":[]},"_background_background":"classic","_background_color":"#000000"},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"cc94e56","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"-40.5","right":0,"bottom":"0","left":0,"isLinked":false},"z_index":5,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"20","right":0,"bottom":"40","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"f67ecd5","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"58412ac","elType":"widget","settings":{"destinations_title":"Destinations","destinations_subtitle":"Where are you going?","activity_title":"Activity","activity_subtitle":"All Activity","date_title":"When","guests_title":"Guests","search_title":"Search","taxonomy_search":[{"_id":"667a46b","taxonomy_slug":"locations","taxonomy_title":"Destinations","taxonomy_subtitle":"Where are you going?","taxonomy_icon":{"value":"triply-icon- triply-icon-map-marker-rounded","library":"triply-icon"}},{"_id":"202a807","taxonomy_slug":"types","taxonomy_title":"Activity","taxonomy_subtitle":"All Activity","taxonomy_icon":{"value":"triply-icon- triply-icon-activity","library":"triply-icon"}}],"search":"","search_icon":{"value":"triply-icon- triply-icon-search","library":"triply-icon"},"sort":"price"},"elements":[],"widgetType":"babe-search-form"}],"isInner":false}],"isInner":false},{"id":"ca3859b","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"60","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"0986ab4","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"ced249f","elType":"widget","settings":{"editor":"Don\u2019t miss ","align":"center","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"text-editor"},{"id":"f30a1fb","elType":"widget","settings":{"title":"Special Offers","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"heading"},{"id":"345ffb1","elType":"section","settings":{"gap":"no","structure":"30","html_tag":"div"},"elements":[{"id":"9590474","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"animation":"opal-move-right","animation_duration":"fast"},"elements":[{"id":"8266e82","elType":"widget","settings":{"skin":"cover","bg_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_banner-1.jpg","id":1281},"bg_image_size":"full","title":"Weekly <br> Flash Deals","description":"Up to 30% off","button":"View Deals &nbsp; <i class=\"triply-icon- triply-icon-long-arrow-right\" style=\"     margin-bottom: 2px; \"><\/i>","min-height":{"unit":"px","size":300,"sizes":[]},"alignment":"left","padding":{"unit":"px","top":"60","right":"50","bottom":"45","left":"50","isLinked":false},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":30,"sizes":[]},"title_typography_line_height":{"unit":"px","size":30,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"description_typography_font_weight":"500","button_background_color":"#FFFFFF","button_border_width":{"unit":"px","size":0,"sizes":[]},"content_animation":"","content_animation_duration":{"unit":"px","size":400,"sizes":[]},"overlay_color_hover":"#02010100","effect_duration":{"unit":"px","size":400,"sizes":[]},"custom_css":"selector .elementor-widget-container { border-radius: 20px;}\nselector .elementor-cta__title {\n    text-shadow: 0 1px 5px rgba(0,0,0,.3);\n}","__globals__":{"description_color":"globals\/colors?id=accent","button_color":"globals\/colors?id=secondary","button_hover_background_color":"globals\/colors?id=primary_hover"},"min-height_tablet":{"unit":"px","size":250,"sizes":[]},"vertical_position":"top","padding_tablet":{"unit":"px","top":"40","right":"15","bottom":"30","left":"15","isLinked":false},"title_typography_font_size_tablet":{"unit":"px","size":24,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":24,"sizes":[]},"title_spacing":{"unit":"px","size":5,"sizes":[]},"description_spacing":{"unit":"px","size":20,"sizes":[]},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/to_book\/","is_external":"on","nofollow":"","custom_attributes":""},"button_hover_text_color":"#FFFFFF"},"elements":[],"widgetType":"call-to-action"}],"isInner":true},{"id":"445b290","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"animation":"opal-move-up","animation_duration":"fast"},"elements":[{"id":"605e827","elType":"widget","settings":{"skin":"cover","bg_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/12\/h1_banner-2.jpg","id":6039},"bg_image_size":"full","title":"Summer <br> Escapes","description":"Plan your next trip","button":"Learn More &nbsp; <i class=\"triply-icon- triply-icon-long-arrow-right\" style=\"     margin-bottom: 2px; \"><\/i>","min-height":{"unit":"px","size":300,"sizes":[]},"alignment":"left","padding":{"unit":"px","top":"60","right":"50","bottom":"45","left":"50","isLinked":false},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":30,"sizes":[]},"title_typography_line_height":{"unit":"px","size":30,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"description_typography_font_weight":"500","button_background_color":"#44AAF5","button_border_width":{"unit":"px","size":0,"sizes":[]},"content_animation":"","content_animation_duration":{"unit":"px","size":400,"sizes":[]},"overlay_color_hover":"#02010100","effect_duration":{"unit":"px","size":400,"sizes":[]},"custom_css":"selector .elementor-widget-container { border-radius: 20px;}\nselector .elementor-cta__title {\n    text-shadow: 0 1px 5px rgba(0,0,0,.3);\n}","__globals__":{"description_color":"globals\/colors?id=accent","button_color":"globals\/colors?id=secondary","button_hover_background_color":"globals\/colors?id=primary_hover"},"min-height_tablet":{"unit":"px","size":250,"sizes":[]},"vertical_position":"top","padding_tablet":{"unit":"px","top":"40","right":"15","bottom":"30","left":"15","isLinked":false},"title_typography_font_size_tablet":{"unit":"px","size":24,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":24,"sizes":[]},"title_spacing":{"unit":"px","size":5,"sizes":[]},"description_spacing":{"unit":"px","size":20,"sizes":[]},"button_text_color":"#FFFFFF","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/to_book\/","is_external":"on","nofollow":"","custom_attributes":""}},"elements":[],"widgetType":"call-to-action"}],"isInner":true},{"id":"a705218","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"animation":"opal-move-left","animation_duration":"fast"},"elements":[{"id":"843bcd5","elType":"widget","settings":{"skin":"cover","bg_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/12\/h1_banner-3.jpg","id":6040},"bg_image_size":"full","title":"Exclusive <br> Deals","description":"Want to save up to 50%","button":"Subscribe Us &nbsp; <i class=\"triply-icon- triply-icon-long-arrow-right\" style=\"     margin-bottom: 2px; \"><\/i>","min-height":{"unit":"px","size":300,"sizes":[]},"alignment":"left","padding":{"unit":"px","top":"60","right":"70","bottom":"45","left":"50","isLinked":false},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":30,"sizes":[]},"title_typography_line_height":{"unit":"px","size":30,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":16,"sizes":[]},"description_typography_font_weight":"500","button_background_color":"#FFD77A","button_border_width":{"unit":"px","size":0,"sizes":[]},"content_animation":"","content_animation_duration":{"unit":"px","size":400,"sizes":[]},"overlay_color_hover":"#02010100","effect_duration":{"unit":"px","size":400,"sizes":[]},"custom_css":"selector .elementor-widget-container { border-radius: 20px;}\nselector .elementor-cta__title {\n    text-shadow: 0 1px 5px rgba(0,0,0,.3);\n}","__globals__":{"description_color":"globals\/colors?id=accent","button_color":"globals\/colors?id=secondary","button_hover_background_color":"globals\/colors?id=primary_hover"},"min-height_tablet":{"unit":"px","size":250,"sizes":[]},"vertical_position":"top","padding_tablet":{"unit":"px","top":"40","right":"55","bottom":"30","left":"15","isLinked":false},"title_typography_font_size_tablet":{"unit":"px","size":24,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":24,"sizes":[]},"title_spacing":{"unit":"px","size":5,"sizes":[]},"description_spacing":{"unit":"px","size":20,"sizes":[]},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/to_book\/","is_external":"on","nofollow":"","custom_attributes":""},"button_hover_text_color":"#FFFFFF"},"elements":[],"widgetType":"call-to-action"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"0625a84","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"content_position":"middle","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"10cab26","elType":"column","settings":{"_column_size":50,"_inline_size":42.6355999999999966121322358958423137664794921875,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"50","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[{"id":"cbe4f89","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-2.png","id":1452},"image_size":"full","align":"right","align_mobile":"center","motion_fx_motion_fx_scrolling":"yes","motion_fx_translateX_effect":"yes","motion_fx_translateX_direction":"negative","motion_fx_translateX_speed":{"unit":"px","size":1,"sizes":[]},"motion_fx_devices":["desktop","tablet"]},"elements":[],"widgetType":"image"}],"isInner":false},{"id":"972290f","elType":"column","settings":{"_column_size":50,"_inline_size":57.36399999999999721467247582040727138519287109375,"space_between_widgets":0,"align_mobile":"center","padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"6b0bbb3","elType":"widget","settings":{"title":"Not a Member Yet?","header_size":"h4","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"_animation":"opal-move-left","animation_duration":"fast"},"elements":[],"widgetType":"heading"},{"id":"7bd4578","elType":"widget","settings":{"editor":"Join us! Our members can access savings of up to 50% and earn Trip Coins while booking.","align_mobile":"center","_element_width":"initial","_element_custom_width":{"unit":"px","size":395,"sizes":[]},"_animation":"opal-move-left","animation_duration":"fast"},"elements":[],"widgetType":"text-editor"},{"id":"28e5667","elType":"widget","settings":{"space":{"unit":"px","size":15,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"dc7de06","elType":"widget","settings":{"text":"Sign In","align":"justify","size":"md","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"10","bottom":"0","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"5","bottom":"0","left":"0","isLinked":false},"_element_width":"initial","_element_width_mobile":"initial","_element_custom_width":{"unit":"px","size":150,"sizes":[]},"_element_custom_width_mobile":{"unit":"px","size":145,"sizes":[]},"__globals__":{"background_color":"globals\/colors?id=primary","button_background_hover_color":"globals\/colors?id=primary_hover","border_color":"globals\/colors?id=primary","button_hover_border_color":"globals\/colors?id=primary_hover"},"border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"_animation":"opal-move-left","animation_duration":"fast","__dynamic__":{"link":"[elementor-tag id=\"052d385\" name=\"internal-url\" settings=\"%7B%22type%22%3A%22post%22%2C%22post_id%22%3A%229%22%7D\"]"}},"elements":[],"widgetType":"button"},{"id":"082237a","elType":"widget","settings":{"text":"Register","align":"justify","size":"md","selected_icon":{"value":"triply-icon- triply-icon-long-arrow-right","library":"triply-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"background_color":"#DC834E00","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"border_color":"#202F59","_element_width":"initial","_element_custom_width":{"unit":"px","size":140,"sizes":[]},"__globals__":{"background_color":"","border_color":"globals\/colors?id=secondary","button_text_color":"globals\/colors?id=secondary","button_hover_border_color":"globals\/colors?id=primary","hover_color":"globals\/colors?id=primary","button_icon_color":"globals\/colors?id=primary"},"_animation":"opal-move-right","animation_duration":"fast","__dynamic__":{"link":"[elementor-tag id=\"fd0471a\" name=\"internal-url\" settings=\"%7B%22type%22%3A%22post%22%2C%22post_id%22%3A%229%22%7D\"]"}},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false},{"id":"4b4e022","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color":"#F9F4F0","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-3.png","id":1509},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":3,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"100","right":"30","bottom":"70","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"80","right":"30","bottom":"50","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"15","bottom":"30","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"d3104c8","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"81dcc28","elType":"widget","settings":{"editor":"What\u2019s new","align":"center","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"text-editor"},{"id":"5fe0b32","elType":"widget","settings":{"title":"Popular Tours ","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"heading"},{"id":"8c1b143","elType":"widget","settings":{"per_page":"5","column":"3","style":"3","column_tablet":"2"},"elements":[],"widgetType":"babe-all-items"}],"isInner":false}],"isInner":false},{"id":"2e45e9b","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"background_background":"classic","background_overlay_background":"classic","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-map.png","id":2005},"background_overlay_position":"center left","background_overlay_repeat":"no-repeat","background_overlay_opacity":{"unit":"px","size":0.1000000000000000055511151231257827021181583404541015625,"sizes":[]},"html_tag":"div"},"elements":[{"id":"307e5de","elType":"column","settings":{"_column_size":50,"_inline_size":31.782900000000001483613232267089188098907470703125,"space_between_widgets":0,"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"13c52b1","elType":"widget","settings":{"editor":"Places to go","align":"left","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"_animation":"opal-move-right","animation_duration":"fast"},"elements":[],"widgetType":"text-editor"},{"id":"1b03e59","elType":"widget","settings":{"title":"Perfect Destinations","align":"left","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"_z_index":2,"_animation":"opal-move-right","animation_duration":"fast","header_size":"h3"},"elements":[],"widgetType":"heading"},{"id":"6ab1f74","elType":"widget","settings":{"editor":"Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. ","_element_width":"initial","_element_custom_width":{"unit":"px","size":330,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"_z_index":2,"_animation":"opal-move-right","animation_duration":"fast","_margin_tablet":{"unit":"px","top":"0","right":"50","bottom":"20","left":"0","isLinked":false},"_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"%","size":100,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"c841bc3","elType":"widget","settings":{"taxonomy_slug":"locations","enable_all_taxonomy":"yes","per_page":"8","count_tour":"yes","Typography_typography":"custom","Typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_color":"#020101","count_color":"#9C9898","location_list_padding":{"unit":"px","size":5,"sizes":[]},"_animation":"opal-move-up","animation_duration":"fast","column_mobile":"2","_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"%","size":100,"sizes":[]},"_z_index":2,"__globals__":{"color_hover":"globals\/colors?id=primary"}},"elements":[],"widgetType":"babe-taxonomies-list"}],"isInner":false},{"id":"ee29431","elType":"column","settings":{"_column_size":50,"_inline_size":68.2169999999999987494447850622236728668212890625,"space_between_widgets":0,"_inline_size_tablet":100},"elements":[{"id":"821dc2a","elType":"widget","settings":{"taxonomy_slug":"locations","locations_ids":[],"per_page":"6","column":"3","enable_carousel":"yes","navigation":"arrows","visibility":"yes","column_tablet":"2","column_mobile":"1","next_horizontal":"right","next_horizontal_value":{"unit":"px","size":-15,"sizes":[]},"next_horizontal_value_mobile":{"unit":"px","size":15,"sizes":[]},"prev_horizontal":"left","prev_horizontal_value":{"unit":"px","size":-15,"sizes":[]},"prev_horizontal_value_mobile":{"unit":"px","size":15,"sizes":[]},"infinite":"","autoplay":"","enable_all_taxonomy":"yes","count_tour":"yes","_margin_mobile":{"unit":"px","top":"10","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"babe-taxonomies"}],"isInner":false}],"isInner":false},{"id":"f138f36","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-4.png","id":1794},"background_position":"initial","background_xpos":{"unit":"%","size":100,"sizes":[]},"background_ypos":{"unit":"%","size":55,"sizes":[]},"background_repeat":"no-repeat","background_size_tablet":"initial","background_bg_width_tablet":{"unit":"px","size":0,"sizes":[]},"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"padding_tablet":{"unit":"%","top":"","right":"","bottom":"","left":"","isLinked":true},"html_tag":"div"},"elements":[{"id":"739e72b","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"93fc9ce","elType":"widget","settings":{"editor":"Brilliant reasons","align":"center","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"text-editor"},{"id":"565da9f","elType":"widget","settings":{"title":"Why Choose Us","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"80","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"_animation":"opal-move-up","animation_duration":"fast","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"23ef79a","elType":"section","settings":{"gap":"no","structure":"40","html_tag":"div"},"elements":[{"id":"6a7392a","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"align":"center","align_tablet":"flex-end","align_mobile":"center","space_between_widgets":0,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"25e03c2","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/12\/price.svg","id":5676},"library":"svg"},"title_text":"Competitive Pricing","description_text":"Lorem ipsum dolor sit amet, consectetur adipisicing elit.","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_space_tablet":{"unit":"px","size":20,"sizes":[]},"icon_size":{"unit":"px","size":60,"sizes":[]},"title_bottom_space_tablet":{"unit":"px","size":5,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":30,"sizes":[]},"_padding":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":2,"_background_background":"classic","_background_color":"#FFFFFF00","_background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-5.png","id":1726},"_background_position":"top center","_background_repeat":"no-repeat","_element_width":"initial","_element_custom_width":{"unit":"px","size":360,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"d8037a6","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"align":"center","align_tablet":"flex-start","align_mobile":"center","space_between_widgets":0,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"9a417f9","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/12\/worldwide.svg","id":5669},"library":"svg"},"title_text":"Worldwide Coverage","description_text":"Lorem ipsum dolor sit amet, consectetur adipisicing elit.","primary_color":"#DC834E","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_space_tablet":{"unit":"px","size":20,"sizes":[]},"icon_size":{"unit":"px","size":60,"sizes":[]},"title_bottom_space_tablet":{"unit":"px","size":5,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":30,"sizes":[]},"_padding":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":2,"_background_background":"classic","_background_color":"#FFFFFF00","_background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-6.png","id":1784},"_background_position":"top center","_background_repeat":"no-repeat","_element_width":"initial","_element_custom_width":{"unit":"px","size":360,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"d29e683","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"align":"center","align_tablet":"flex-end","align_mobile":"center","space_between_widgets":0,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"53171d2","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/12\/booking.svg","id":5665},"library":"svg"},"title_text":"Fast Booking","description_text":"Lorem ipsum dolor sit amet, consectetur adipisicing elit.","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_space_tablet":{"unit":"px","size":20,"sizes":[]},"icon_size":{"unit":"px","size":60,"sizes":[]},"title_bottom_space_tablet":{"unit":"px","size":5,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":30,"sizes":[]},"_padding":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":2,"_background_background":"classic","_background_color":"#FFFFFF00","_background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-7.png","id":1786},"_background_position":"top center","_background_repeat":"no-repeat","_element_width":"initial","_element_custom_width":{"unit":"px","size":360,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"df3ca8b","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"align":"center","align_tablet":"flex-start","align_mobile":"center","space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"4ce730c","elType":"widget","settings":{"selected_icon":{"value":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/12\/guide.svg","id":5674},"library":"svg"},"title_text":"Guided Tours","description_text":"Lorem ipsum dolor sit amet, consectetur adipisicing elit.","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_space_tablet":{"unit":"px","size":20,"sizes":[]},"icon_size":{"unit":"px","size":60,"sizes":[]},"title_bottom_space_tablet":{"unit":"px","size":5,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_font_weight":"500","title_typography_line_height":{"unit":"px","size":30,"sizes":[]},"_padding":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":2,"_background_background":"classic","_background_color":"#FFFFFF00","_background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-8.png","id":1787},"_background_position":"top center","_background_repeat":"no-repeat","_element_width":"initial","_element_custom_width":{"unit":"px","size":360,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"icon-box"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"de4540c","elType":"section","settings":{"layout":"full_width","gap":"no","stretch_section":"section-stretched","structure":"20","html_tag":"div"},"elements":[{"id":"d5c5d97","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_bg-2.jpg","id":1902},"background_position":"top center","background_motion_fx_motion_fx_scrolling":"yes","background_size":"cover","background_motion_fx_translateY_speed":{"unit":"px","size":1,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"background_motion_fx_scale_effect":"yes","background_motion_fx_scale_speed":{"unit":"px","size":2,"sizes":[]}},"elements":[{"id":"9586d7f","elType":"widget","settings":{"space":{"unit":"px","size":300,"sizes":[]}},"elements":[],"widgetType":"spacer"}],"isInner":false},{"id":"b7a7089","elType":"column","settings":{"_column_size":50,"_inline_size":null,"align":"center","space_between_widgets":0,"background_background":"classic","background_color":"#202F59","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_shape-9.png","id":1964},"padding":{"unit":"px","top":"140","right":"30","bottom":"0","left":"30","isLinked":false},"background_position":"center right","background_repeat":"no-repeat","background_motion_fx_motion_fx_scrolling":"yes","background_motion_fx_devices":["desktop","tablet"],"padding_tablet":{"unit":"px","top":"80","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"a88da52","elType":"widget","settings":{"editor":"Latest deal","align":"center","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"936899d","elType":"widget","settings":{"title":"Save an Extra $500 on Cyprus Holidays","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"100","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"60","left":"0","isLinked":false},"__globals__":{"title_color":""},"title_color":"#FFFFFF","_element_width":"initial","_element_custom_width":{"unit":"px","size":550,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"b0019f5","elType":"widget","settings":{"editor":"It\u2019s limited seating! Hurry up","align":"center","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_weight":"500","typography_line_height":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"b46fe50","elType":"widget","settings":{"due_date":"2023-02-28 06:20","custom_labels":"yes","label_days":"Days","label_hours":"Hours","label_minutes":"Mins","label_seconds":"Secs","container_width":{"unit":"px","size":350,"sizes":[]},"box_background_color":"#DC834E00","box_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"digits_typography_typography":"custom","digits_typography_font_size":{"unit":"px","size":50,"sizes":[]},"digits_typography_font_weight":"700","digits_typography_line_height":{"unit":"px","size":60,"sizes":[]},"label_typography_typography":"custom","label_typography_font_size":{"unit":"px","size":12,"sizes":[]},"label_typography_font_weight":"500","label_typography_text_transform":"uppercase","label_typography_line_height":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"__globals__":{"digits_color":"globals\/colors?id=primary"},"digits_typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"digits_typography_line_height_tablet":{"unit":"px","size":40,"sizes":[]},"_animation":"opal-move-up","animation_duration":"fast","digits_typography_font_size_mobile":{"unit":"px","size":30,"sizes":[]}},"elements":[],"widgetType":"countdown"},{"id":"0f143cb","elType":"widget","settings":{"width":{"unit":"px","size":340,"sizes":[]},"align":"center","text":"Divider","weight":{"unit":"px","size":7,"sizes":[]},"gap":{"unit":"px","size":0,"sizes":[]},"custom_css":"selector .elementor-divider-separator {\n    border-radius: 5px 5px 0 0;\n}","__globals__":{"color":"globals\/colors?id=primary"},"_animation":"opal-scale-up"},"elements":[],"widgetType":"divider"}],"isInner":false}],"isInner":false},{"id":"d4a107a","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color":"#F9F4F0","padding":{"unit":"px","top":"100","right":"30","bottom":"100","left":"30","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"80","right":"30","bottom":"80","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"15","bottom":"30","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"ba3c3f9","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"align":"space-between"},"elements":[{"id":"76391a3","elType":"widget","settings":{"editor":"Testimonials ","align":"center","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"5d80312","elType":"widget","settings":{"title":"Customer Reviews","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"9fbee96","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_quote-1.png","id":2016},"image_size":"full","align":"left","_element_width":"initial","_element_custom_width":{"unit":"%","size":17,"sizes":[]},"_element_custom_width_tablet":{"unit":"%","size":14,"sizes":[]},"_element_width_tablet":"initial","hide_mobile":"hidden-phone","_animation":"swing","_padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"5e52ca4","elType":"widget","settings":{"testimonials":[{"testimonial_content":"\u201cThis was an amazing trip! There were so many highlights... our outstanding, kind, patient, amazing leader Gustavo!! What an absolute saint. He was so organized and insightful!\u201d ","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h3-img-box-1.png","id":2117},"testimonial_name":"Melisa Joan H.","testimonial_job":" New York, USA","_id":"87f87d2","testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"}},{"testimonial_content":"\"Needless to say we are extremely satisfied with the results. Booking tour was the best investment I ever made. Nice work on your booking tour. Booking tour impressed.\"","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-4-2.jpg","id":2730},"testimonial_name":"Roselin D.","testimonial_job":" New York, USA","testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"},"_id":"cadac67"},{"testimonial_content":"\"Great job, I will definitely be ordering again! After using booking tour my business skyrocketed! Man, this thing is getting better and better as I learn more about it. \"","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/about_image-5-2.jpg","id":2731},"testimonial_name":"Cleveland A.","testimonial_job":" New York, USA","testimonial_icon":{"value":"triply-icon- triply-icon-quote-2","library":"triply-icon"},"_id":"3d47fe4"}],"column":"1","content_typography_line_height":{"unit":"px","size":"","sizes":[]},"enable_carousel":"yes","_element_width":"initial","_element_custom_width":{"unit":"%","size":66,"sizes":[]},"content_typography_typography":"custom","content_typography_font_size_tablet":{"unit":"px","size":22,"sizes":[]},"content_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"_element_width_tablet":"initial","_element_width_mobile":"inherit","_element_custom_width_tablet":{"unit":"%","size":68,"sizes":[]}},"elements":[],"widgetType":"triply-testimonials"},{"id":"f52480c","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/triply\/wp-content\/uploads\/2020\/11\/h1_quote-2.png","id":2017},"image_size":"full","align":"right","_element_width":"initial","_element_custom_width":{"unit":"%","size":17,"sizes":[]},"_element_custom_width_tablet":{"unit":"%","size":14,"sizes":[]},"_element_width_tablet":"initial","hide_mobile":"hidden-phone","_animation":"swing","_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false}},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"b2cb4b8","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"3e52dfa","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"a175405","elType":"widget","settings":{"editor":"Our blog","align":"center","align_mobile":"center","typography_typography":"custom","typography_font_family":"Thea Amelia","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary"},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":26,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"text-editor"},{"id":"19007f0","elType":"widget","settings":{"title":"Travel Tips and Advice","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"heading"},{"id":"a08d425","elType":"widget","settings":{"column":"2","item_spacing":{"unit":"px","size":50,"sizes":[]},"pagination_page_limit":"5","pagination_prev_label":"&laquo; Previous","pagination_next_label":"Next &raquo;","enable_carousel":"yes","column_tablet":"1"},"elements":[],"widgetType":"triply-post-grid"}],"isInner":false}],"isInner":false}],"default-kit":[]}', true);
    }

}

return new Triply_Merlin_Config();
