<?php
/*
 * Created by Artureanec
*/

$transx_customizer_default_values = array(
    # Header Settings

        #General
        'header_style' => 'type_1',
        'transparent_header' => 'off',
        'sticky_header' => 'on',
        'header_tagline' => 'off',
        'header_button' => 'off',
        'header_button_text' => esc_html__('Get a Quote', 'transx'),
        'header_button_link' => '#',
        'side_panel' => 'off',
        'header_search' => 'hide',
        'preloader' => 'hide',

        # Tag Line Content
        'tagline_font_family' => 'Inter',
        'tagline_font_size' => '14px',
        'tagline_line_height' => '1.6',
        'tagline_font_wight' => '400',
        'tagline_uppercase' => false,
        'tagline_italic' => false,
        'tagline_address' => '',
        'number_of_phones' => '2',
        'tagline_phone_1' => '',
        'tagline_phone_2' => '',
        'tagline_email' => '',
        'tagline_socials' => 'on',
        'tagline_socials_font_size' => '15px',
        'tagline_menu' => 'on',

        # Header Logo
        'logo_image' => get_template_directory_uri() . '/img/logo_black.png',
        'logo_transparent_image' => get_template_directory_uri() . '/img/logo_white.png',
        'logo_retina' => true,

        # Header Menu
        'header_menu_font_family' => 'Inter',
        'header_menu_font_size' => '14px',
        'header_menu_line_height' => '1.6',
        'header_menu_font_weight' => '500',
        'header_menu_uppercase' => true,
        'header_menu_italic' => false,
        'header_sub_menu_font_family' => 'Inter',
        'header_sub_menu_font_size' => '14px',
        'header_sub_menu_line_height' => '1.6',
        'header_sub_menu_font_weight' => '400',
        'header_sub_menu_uppercase' => false,
        'header_sub_menu_italic' => false,

        # Donate Button
        'donate_font_family' => 'Inter',
        'donate_font_size' => '14px',
        'donate_line_height' => '70px',
        'donate_font_weight' => '500',
        'donate_uppercase' => true,
        'donate_italic' => false,

        # Side Panel
        'side_menu_font_family' => 'Inter',
        'side_menu_font_size' => '14px',
        'side_menu_line_height' => '20px',
        'side_menu_font_weight' => '500',
        'side_menu_uppercase' => false,
        'side_menu_italic' => false,
        'side_panel_info' => 'show',
        'side_panel_socials' => 'show',
        'side_panel_socials_size' => '16px',
        'side_panel_button' => 'hide',
        'side_panel_instagram' => 'hide',
        'side_panel_insta_shortcode' => '',

    # Typography

        # Main Font
        'main_font_family' => 'Inter',
        'main_font_size' => '16px',
        'main_line_height' => '1.7',
        'main_font_weight' => '400',

        # Headings
        'headings_font_family' => 'Inter',
        'headings_font_weight' => '700',
        'headings_uppercase' => false,
        'headings_italic' => false,
        'h1_font_size' => '60px',
        'h1_line_height' => '1.6',
        'h2_font_size' => '45px',
        'h2_line_height' => '1.6',
        'h3_font_size' => '30px',
        'h3_line_height' => '1.6',
        'h4_font_size' => '20px',
        'h4_line_height' => '1.6',
        'h5_font_size' => '18px',
        'h5_line_height' => '1.6',
        'h6_font_size' => '16px',
        'h6_line_height' => '1.6',

        # Buttons
        'buttons_font_family' => 'Inter',
        'buttons_font_size' => '13px',
        'buttons_font_weight' => '500',
        'buttons_uppercase' => true,
        'buttons_italic' => false,

        # Page Title
        'site_title_font_family' => 'Inter',
        'site_title_font_size' => '200px',
        'page_title_font_family' => 'Inter',
        'page_title_font_size' => '60px',

    # Social Links

        'socials_target' => false,
        'socials_youtube' => '',
        'socials_facebook' => '',
        'socials_twitter' => '',
        'socials_linkedin' => '',
        'socials_instagram' => '',
        'socials_whatsapp' => '',
        'socials_pinterest' => '',
        'socials_tumbl' => '',
        'socials_flickr' => '',
        'socials_vk' => '',
        'socials_dribbble' => '',
        'socials_vimeo' => '',
        'socials_500px' => '',
        'socials_xing' => '',
        'socials_facebook_text' => '',
        'socials_twitter_text' => '',
        'socials_linkedin_text' => '',
        'socials_youtube_text' => '',
        'socials_instagram_text' => '',
        'socials_whatsapp_text' => '',
        'socials_pinterest_text' => '',
        'socials_tumbl_text' => '',
        'socials_flickr_text' => '',
        'socials_vk_text' => '',
        'socials_dribbble_text' => '',
        'socials_vimeo_text' => '',
        'socials_500px_text' => '',
        'socials_xing_text' => '',

    # Color Options

        # General
        'site_bg_color' => '#ffffff',
        'main_color' => '#1eae98',
        'main_color_2' => '#005bac',
        'main_font_color' => '#696e76',
        'headings_color' => '#414a53',
        'listing_titles_color' => '#414a53',
        'listing_titles_hover' => '#1eae98',

        # Side Panel
        'side_panel_bg' => '#31373f',
        'side_panel_close_color' => '#ffffff',
        'side_panel_close_hover' => '#ffffff',
        'side_panel_menu_color' => '#ffffff',
        'side_panel_menu_hover' => '#bfbfbf',
        'side_panel_info_color' => '#ffffff',
        'side_panel_info_hover' => '#bfbfbf',
        'side_panel_socials_color' => '#ffffff',
        'side_panel_socials_hover' => '#1eae98',

        # Tag Line
        'tadline_bg' => '#323639',
        'tagline_link_color' => '#ffffff',
        'tagline_link_hover' => '#ffffff',
        'tagline_socials_color' => '#ffffff',

        # Header
        'header_bg' => '#ffffff',
        'side_panel_trigger_color' => '#282a43',
        'side_panel_trigger_hover' => '#282a43',
        'header_menu_color' => '#282a43',
        'header_menu_hover' => '#1eae98',
        'transparent_header_menu_color' => '#ffffff',
        'transparent_header_menu_hover' => '#ffffff',
        'header_sub_menu_color' => '#ffffff',
        'header_sub_menu_hover' => '#8d9296',
        'header_sub_menu_bg' => '#31373f',
        
        # Buttons
        'header_button_color' => '#ffffff',
            'header_button_bg' => '#1eae98',
        'header_button_hover' => '#ffffff',
        'header_button_bg_hover' => '#21bb9f',
        'button_color' => '#414a53',
        'button_hover' => '#ffffff',
        'button_bg_color' => '',
        'button_bg_hover' => '#1eae98',
        'button_border_color' => '#1eae98',
        'button_border_hover' => '#1eae98',
        'post_socials_color' => '#414a53',
        'post_socials_hover' => '#1eae98',


        # Footer
        'prefooter_color' => '#ededed',
        'prefooter_hover' => '#ffffff',
        'prefooter_socials' => '#ffffff',
        'prefooter_socials_hover' => '#1eae98',
        'prefooter_widget_title_color' => '#ffffff',
        'footer_bg' => '#31373f',
        'footer_color' => '#95999e',
        'footer_hover' => '#95999e',

        # Page Title
        'site_title_color' => '#ffffff',
        'page_title_color' => '#ffffff',

        # Forms
        'form_field_color' => '#000000',
        'form_field_bg' => '#ffffff',
        'form_field_border' => '#e2e2e2',
        'active_form_field_bg' => '#ffffff',
        'active_form_field_border' => '#333333',
        'form_button_color' => '#414a53',
        'form_button_hover' => '#ffffff',
        'form_button_bg' => '',
        'form_button_bg_hover' => '#1eae98',
        'form_button_border_color' => '#1eae98',
        'form_button_border_hover' => '#1eae98',

    # Footer
        'back_to_top_button' => 'hide',
        'bottom_image_status' => 'show',
        'bottom_image' => get_template_directory_uri() . '/img/background__layout.png',
        'prefooter_status' => 'show',
        'prefooter_type' => 'type_1',
        'footer_status' => 'show',
        'footer_type' => 'type_1',
        'copyright_status' => 'show',
        'copyright' => '© 2021 TransX. All rights reserved',
        'footer_menu_status' => 'show',
        'footer_menu_2_status' => 'show',
        'footer_socials_status' => 'show',

    # Page Title
        'page_title_status' => 'show',
        'title_height' => '650',
        'site_title_status' => 'hide',
        'site_title_type' => 'default',
        'alt_site_title' => '',
        'post_title_bg' => get_template_directory_uri() . '/img/null.png',
        'post_title_bg_color' => '#000000',
        'content_bg_image_status' => 'show',
        'content_bg_image' => get_template_directory_uri() . '/img/content_bg.png',

    # Sidebars
        'sidebar_position' => 'right',

    # Single Post
        'media_output_status' => 'show',
        'post_meta_status' => 'show',
        'after_content_panel_status' => 'show',
        'comments_status' => 'show',
        'post_nav' => 'show',

    # 404 Error
        '404_bg_image' => get_template_directory_uri() . '/img/null.png',
        '404_bg_color' => '#000000',
        '404_title' => esc_html__('Transporterium', 'transx'),
        '404_text' => '',
        '404_button_text' => esc_html__('Homepage', 'transx'),

    # WooCommerce
        'woo_title_bg_image' => get_template_directory_uri() . '/img/null.png',
        'woo_prod_title' => '',
        'woo_prod_subtitle' => '',
        'header_cart_status' => 'hide'
);

function transx_sanitize_callback_with_tags($input) {
    return $input;
}

# Register Customizer
add_action('customize_register', 'transx_customizer_register');

if (!function_exists('transx_customizer_register')) {
    function transx_customizer_register($wp_customize)
    {
        global $transx_customizer_default_values;

        // ------------------------------------------- //
        // ---------- Header Settings Panel ---------- //
        // ------------------------------------------- //
        $wp_customize->add_panel('transx_header_settings',
            array(
                'title' => esc_attr__('Header Settings', 'transx'),
                'priority' => 130
            )
        );

            // ---######################--- //
            // ---### Header General ###--- //
            // ---######################--- //
            $wp_customize->add_section('transx_header_general',
                array(
                    'title' => esc_attr__('General', 'transx'),
                    'panel' => 'transx_header_settings'
                )
            );

                // ------------------- //
                // --- Header Type --- //
                // ------------------- //
                $wp_setting_name = 'header_style';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Header Style', 'transx'),
                        'section' => 'transx_header_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'type_1' => esc_html__('Style Type 1', 'transx'),
                            'type_2' => esc_html__('Style Type 2', 'transx'),
                            'type_3' => esc_html__('Style Type 3', 'transx'),
                            'type_4' => esc_html__('Style Type 4', 'transx'),
                            'type_5' => esc_html__('Style Type 5', 'transx'),
                            'type_6' => esc_html__('Style Type 6', 'transx')
                        ),
                    )
                ));

                // -------------------------- //
                // --- Transparent Header --- //
                // -------------------------- //
                $wp_setting_name = 'transparent_header';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Transparent Header', 'transx'),
                        'section' => 'transx_header_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'on' => esc_html__('On', 'transx'),
                            'off' => esc_html__('Off', 'transx')
                        )
                    )
                ));

                // --------------------- //
                // --- Sticky Header --- //
                // --------------------- //
                $wp_setting_name = 'sticky_header';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Sticky Header', 'transx'),
                        'section' => 'transx_header_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'on' => esc_html__('On', 'transx'),
                            'off' => esc_html__('Off', 'transx')
                        )
                    )
                ));

                // ---------------------- //
                // --- Header Tagline --- //
                // ---------------------- //
                $wp_setting_name = 'header_tagline';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Header Tagline', 'transx'),
                        'section' => 'transx_header_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'on' => esc_html__('On', 'transx'),
                            'off' => esc_html__('Off', 'transx')
                        )
                    )
                ));

                // --------------------- //
                // --- Header Button --- //
                // --------------------- //
                $wp_setting_name = 'header_button';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Header Button', 'transx'),
                        'section' => 'transx_header_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'on' => esc_html__('On', 'transx'),
                            'off' => esc_html__('Off', 'transx')
                        )
                    )
                ));

                // -------------------------- //
                // --- Header Button Text --- //
                // -------------------------- //
                $wp_setting_name = 'header_button_text';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Header Button Text', 'transx'),
                        'section' => 'transx_header_general',
                        'settings' => $wp_setting_name,
                        'description' => '<i class="transx_dependency_customizer" data-dependency-id="header_button" data-dependency-val="on"></i>'
                    )
                ));

                // -------------------------- //
                // --- Header Button Link --- //
                // -------------------------- //
                $wp_setting_name = 'header_button_link';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'transx_sanitize_callback_with_tags'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Header Button Link', 'transx'),
                        'section' => 'transx_header_general',
                        'settings' => $wp_setting_name,
                        'description' => '<i class="transx_dependency_customizer" data-dependency-id="header_button" data-dependency-val="on"></i>'
                    )
                ));

                // ------------------ //
                // --- Side Panel --- //
                // ------------------ //
                $wp_setting_name = 'side_panel';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Panel', 'transx'),
                        'section' => 'transx_header_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'on' => esc_html__('On', 'transx'),
                            'off' => esc_html__('Off', 'transx')
                        )
                    )
                ));

                // --------------------- //
                // --- Header Search --- //
                // --------------------- //
                $wp_setting_name = 'header_search';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Header Search', 'transx'),
                        'section' => 'transx_header_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'show' => esc_html__('Show', 'transx'),
                            'hide' => esc_html__('Hide', 'transx')
                        )
                    )
                ));

                // ---------------------- //
                // --- Site Preloader --- //
                // ---------------------- //
                $wp_setting_name = 'preloader';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Site Preloader', 'transx'),
                        'section' => 'transx_header_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'show' => esc_html__('Show', 'transx'),
                            'hide' => esc_html__('Hide', 'transx')
                        )
                    )
                ));

            // ---#########################--- //
            // ---### Tag Line Settings ###--- //
            // ---#########################--- //
            $wp_customize->add_section('transx_header_content',
                array(
                    'title' => esc_attr__('Tag Line', 'transx'),
                    'panel' => 'transx_header_settings'
                )
            );

                // ---------------------------- //
                // --- Tag Line Font Family --- //
                // ---------------------------- //
                $wp_setting_name = 'tagline_font_family';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Tag Line Font Family', 'transx'),
                        'section' => 'transx_header_content',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => transx_get_all_fonts_name(),
                    )
                ));

                // ------------------------- //
                // --- Tagline Font Size --- //
                // ------------------------- //
                $wp_setting_name = 'tagline_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Tag Line Font Size', 'transx'),
                        'section' => 'transx_header_content',
                        'settings' => $wp_setting_name,
                    )
                ));

                // --------------------------- //
                // --- Tagline Line Height --- //
                // --------------------------- //
                $wp_setting_name = 'tagline_line_height';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Tag Line Line Height', 'transx'),
                        'section' => 'transx_header_content',
                        'settings' => $wp_setting_name,
                    )
                ));

                // --------------------------- //
                // --- Tagline Font Weight --- //
                // --------------------------- //
                $wp_setting_name = 'tagline_font_wight';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Tag Line Font Weight', 'transx'),
                        'section' => 'transx_header_content',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'description' => 'Please keep in mind that most fonts do not support such exotic thicknesses as the 100. The most common values: 300, 400, 600, 700.',
                        'choices' => array(
                            '100' => '100',
                            '200' => '200',
                            '300' => '300',
                            '400' => '400',
                            '500' => '500',
                            '600' => '600',
                            '700' => '700',
                            '800' => '800',
                            '900' => '900'
                        )
                    )
                ));

                // ------------------------- //
                // --- Tagline Uppercase --- //
                // ------------------------- //
                $wp_setting_name = 'tagline_uppercase';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Tag Line Uppercase', 'transx'),
                        'section' => 'transx_header_content',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));

                // ---------------------- //
                // --- Tagline Italic --- //
                // ---------------------- //
                $wp_setting_name = 'tagline_italic';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Tag Line Italic', 'transx'),
                        'section' => 'transx_header_content',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));

                // ------------------------- //
                // --- Tagline Phone One --- //
                // ------------------------- //
                $wp_setting_name = 'tagline_address';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Tag Line Address', 'transx'),
                        'section' => 'transx_header_content',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------ //
                // --- Number of Phones --- //
                // ------------------------ //
                $wp_setting_name = 'number_of_phones';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Number of Phones', 'transx'),
                        'section' => 'transx_header_content',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            '1' => esc_html__('One', 'transx'),
                            '2' => esc_html__('Two', 'transx')
                        )
                    )
                ));

                // ------------------------- //
                // --- Tagline Phone One --- //
                // ------------------------- //
                $wp_setting_name = 'tagline_phone_1';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Tag Line Phone One', 'transx'),
                        'section' => 'transx_header_content',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------- //
                // --- Tagline Phone Two --- //
                // ------------------------- //
                $wp_setting_name = 'tagline_phone_2';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Tag Line Phone Two', 'transx'),
                        'section' => 'transx_header_content',
                        'settings' => $wp_setting_name,
                        'description' => '<i class="transx_dependency_customizer" data-dependency-id="number_of_phones" data-dependency-val="2"></i>'
                    )
                ));

                // --------------------- //
                // --- Tagline Email --- //
                // --------------------- //
                $wp_setting_name = 'tagline_email';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Tag Line Email', 'transx'),
                        'section' => 'transx_header_content',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ----------------------- //
                // --- Tagline Socials --- //
                // ----------------------- //
                $wp_setting_name = 'tagline_socials';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Tag Line Socials', 'transx'),
                        'section' => 'transx_header_content',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'on' => esc_html__('On', 'transx'),
                            'off' => esc_html__('Off', 'transx')
                        )
                    )
                ));

                // ---------------------------- //
                // --- Tagline Socials Size --- //
                // ---------------------------- //
                $wp_setting_name = 'tagline_socials_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Tag Line Socials Size', 'transx'),
                        'section' => 'transx_header_content',
                        'settings' => $wp_setting_name,
                        'description' => '<i class="transx_dependency_customizer" data-dependency-id="tagline_socials" data-dependency-val="on"></i>'
                    )
                ));

                // -------------------- //
                // --- Tagline Menu --- //
                // -------------------- //
                $wp_setting_name = 'tagline_menu';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Tag Line Menu', 'transx'),
                        'section' => 'transx_header_content',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'on' => esc_html__('On', 'transx'),
                            'off' => esc_html__('Off', 'transx')
                        )
                    )
                ));

            // ---#####################--- //
            // ---### Logo Settings ###--- //
            // ---#####################--- //
            $wp_customize->add_section('transx_header_logo',
                array(
                    'title' => esc_attr__('Logo', 'transx'),
                    'panel' => 'transx_header_settings'
                )
            );

                // ------------------- //
                // --- Header Logo --- //
                // ------------------- //
                $wp_setting_name = 'logo_image';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Image_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Logo Image', 'transx'),
                        'section' => 'transx_header_logo',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------- //
                // --- Header Logo Transparent --- //
                // ------------------------------- //
                $wp_setting_name = 'logo_transparent_image';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Image_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Transparent Header Logo Image', 'transx'),
                        'section' => 'transx_header_logo',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------- //
                // --- Logo Retina --- //
                // ------------------- //
                $wp_setting_name = 'logo_retina';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Image_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Logo Retina', 'transx'),
                        'section' => 'transx_header_logo',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));

            // ---#####################--- //
            // ---### Menu Settings ###--- //
            // ---#####################--- //
            $wp_customize->add_section('transx_header_menu',
                array(
                    'title' => esc_attr__('Menu', 'transx'),
                    'panel' => 'transx_header_settings'
                )
            );

                // ------------------------ //
                // --- Menu Font Family --- //
                // ------------------------ //
                $wp_setting_name = 'header_menu_font_family';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Menu Font Family', 'transx'),
                        'section' => 'transx_header_menu',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => transx_get_all_fonts_name(),
                    )
                ));

                // ---------------------- //
                // --- Menu Font Size --- //
                // ---------------------- //
                $wp_setting_name = 'header_menu_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Menu Font Size', 'transx'),
                        'section' => 'transx_header_menu',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------ //
                // --- Menu Line Height --- //
                // ------------------------ //
                $wp_setting_name = 'header_menu_line_height';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Menu Line Height', 'transx'),
                        'section' => 'transx_header_menu',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------ //
                // --- Menu Font Weight --- //
                // ------------------------ //
                $wp_setting_name = 'header_menu_font_weight';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Menu Font Weight', 'transx'),
                        'section' => 'transx_header_menu',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'description' => 'Please keep in mind that most fonts do not support such exotic thicknesses as the 100. The most common values: 300, 400, 600, 700.',
                        'choices' => array(
                            '100' => '100',
                            '200' => '200',
                            '300' => '300',
                            '400' => '400',
                            '500' => '500',
                            '600' => '600',
                            '700' => '700',
                            '800' => '800',
                            '900' => '900'
                        )
                    )
                ));

                // ---------------------- //
                // --- Menu Uppercase --- //
                // ---------------------- //
                $wp_setting_name = 'header_menu_uppercase';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Menu Uppercase', 'transx'),
                        'section' => 'transx_header_menu',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));

                // ------------------- //
                // --- Menu Italic --- //
                // ------------------- //
                $wp_setting_name = 'header_menu_italic';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Menu Italic', 'transx'),
                        'section' => 'transx_header_menu',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));

                // ---------------------------- //
                // --- Sub Menu Font Family --- //
                // ---------------------------- //
                $wp_setting_name = 'header_sub_menu_font_family';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Sub Menu Font Family', 'transx'),
                        'section' => 'transx_header_menu',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => transx_get_all_fonts_name(),
                    )
                ));

                // -------------------------- //
                // --- Sub Menu Font Size --- //
                // -------------------------- //
                $wp_setting_name = 'header_sub_menu_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Sub Menu Font Size', 'transx'),
                        'section' => 'transx_header_menu',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------------- //
                // --- Sub Menu Line Height --- //
                // ---------------------------- //
                $wp_setting_name = 'header_sub_menu_line_height';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Sub Menu Line Height', 'transx'),
                        'section' => 'transx_header_menu',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------------- //
                // --- Sub Menu Font Weight --- //
                // ---------------------------- //
                $wp_setting_name = 'header_sub_menu_font_weight';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Sub Menu Font Weight', 'transx'),
                        'section' => 'transx_header_menu',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'description' => 'Please keep in mind that most fonts do not support such exotic thicknesses as the 100. The most common values: 300, 400, 600, 700.',
                        'choices' => array(
                            '100' => '100',
                            '200' => '200',
                            '300' => '300',
                            '400' => '400',
                            '500' => '500',
                            '600' => '600',
                            '700' => '700',
                            '800' => '800',
                            '900' => '900'
                        )
                    )
                ));

                // -------------------------- //
                // --- Sub Menu Uppercase --- //
                // -------------------------- //
                $wp_setting_name = 'header_sub_menu_uppercase';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Sub Menu Uppercase', 'transx'),
                        'section' => 'transx_header_menu',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));

                // ----------------------- //
                // --- Sub Menu Italic --- //
                // ----------------------- //
                $wp_setting_name = 'header_sub_menu_italic';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Sub Menu Italic', 'transx'),
                        'section' => 'transx_header_menu',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));

            // ---################################--- //
            // ---### Donation Button Settings ###--- //
            // ---################################--- //
            $wp_customize->add_section('transx_donation_button',
                array(
                    'title' => esc_attr__('Header Button', 'transx'),
                    'panel' => 'transx_header_settings'
                )
            );

                // -------------------------- //
                // --- Button Font Family --- //
                // -------------------------- //
                $wp_setting_name = 'donate_font_family';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Button Font Family', 'transx'),
                        'section' => 'transx_donation_button',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => transx_get_all_fonts_name(),
                    )
                ));

                // ------------------------ //
                // --- Button Font Size --- //
                // ------------------------ //
                $wp_setting_name = 'donate_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Button Font Size', 'transx'),
                        'section' => 'transx_donation_button',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------------- //
                // --- Button Line Height --- //
                // -------------------------- //
                $wp_setting_name = 'donate_line_height';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Button Line Height', 'transx'),
                        'section' => 'transx_donation_button',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------------- //
                // --- Button Font Weight --- //
                // -------------------------- //
                $wp_setting_name = 'donate_font_weight';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Button Font Weight', 'transx'),
                        'section' => 'transx_donation_button',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'description' => 'Please keep in mind that most fonts do not support such exotic thicknesses as the 100. The most common values: 300, 400, 600, 700.',
                        'choices' => array(
                            '100' => '100',
                            '200' => '200',
                            '300' => '300',
                            '400' => '400',
                            '500' => '500',
                            '600' => '600',
                            '700' => '700',
                            '800' => '800',
                            '900' => '900'
                        )
                    )
                ));

                // ------------------------ //
                // --- Button Uppercase --- //
                // ------------------------ //
                $wp_setting_name = 'donate_uppercase';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Button Uppercase', 'transx'),
                        'section' => 'transx_donation_button',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));

                // --------------------- //
                // --- Button Italic --- //
                // --------------------- //
                $wp_setting_name = 'donate_italic';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Button Italic', 'transx'),
                        'section' => 'transx_donation_button',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));

            // ---###########################--- //
            // ---### Side Panel Settings ###--- //
            // ---###########################--- //
            $wp_customize->add_section('transx_side_panel',
                array(
                    'title' => esc_attr__('Side Panel', 'transx'),
                    'panel' => 'transx_header_settings'
                )
            );
    
                // ----------------------------- //
                // --- Side Menu Font Family --- //
                // ----------------------------- //
                $wp_setting_name = 'side_menu_font_family';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Menu Font Family', 'transx'),
                        'section' => 'transx_side_panel',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => transx_get_all_fonts_name(),
                    )
                ));
        
                // --------------------------- //
                // --- Side Menu Font Size --- //
                // --------------------------- //
                $wp_setting_name = 'side_menu_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Menu Font Size', 'transx'),
                        'section' => 'transx_side_panel',
                        'settings' => $wp_setting_name,
                    )
                ));
        
                // ----------------------------- //
                // --- Side Menu Line Height --- //
                // ----------------------------- //
                $wp_setting_name = 'side_menu_line_height';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Menu Line Height', 'transx'),
                        'section' => 'transx_side_panel',
                        'settings' => $wp_setting_name,
                    )
                ));
        
                // ----------------------------- //
                // --- Side Menu Font Weight --- //
                // ----------------------------- //
                $wp_setting_name = 'side_menu_font_weight';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Menu Font Weight', 'transx'),
                        'section' => 'transx_side_panel',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'description' => 'Please keep in mind that most fonts do not support such exotic thicknesses as the 100. The most common values: 300, 400, 600, 700.',
                        'choices' => array(
                            '100' => '100',
                            '200' => '200',
                            '300' => '300',
                            '400' => '400',
                            '500' => '500',
                            '600' => '600',
                            '700' => '700',
                            '800' => '800',
                            '900' => '900'
                        )
                    )
                ));
        
                // --------------------------- //
                // --- Side Menu Uppercase --- //
                // --------------------------- //
                $wp_setting_name = 'side_menu_uppercase';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Menu Uppercase', 'transx'),
                        'section' => 'transx_side_panel',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));
        
                // ------------------------ //
                // --- Side Menu Italic --- //
                // ------------------------ //
                $wp_setting_name = 'side_menu_italic';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Menu Italic', 'transx'),
                        'section' => 'transx_side_panel',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));
        
                // ------------------------------ //
                // --- Side Panel Information --- //
                // ------------------------------ //
                $wp_setting_name = 'side_panel_info';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Panel Information', 'transx'),
                        'section' => 'transx_side_panel',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'show' => esc_html__('Show', 'transx'),
                            'hide' => esc_html__('Hide', 'transx')
                        )
                    )
                ));
        
                // -------------------------- //
                // --- Side Panel Socials --- //
                // -------------------------- //
                $wp_setting_name = 'side_panel_socials';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Panel Socials', 'transx'),
                        'section' => 'transx_side_panel',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'show' => esc_html__('Show', 'transx'),
                            'hide' => esc_html__('Hide', 'transx')
                        )
                    )
                ));
        
                // ------------------------------- //
                // --- Side Panel Socials Size --- //
                // ------------------------------- //
                $wp_setting_name = 'side_panel_socials_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Panel Socials Size', 'transx'),
                        'section' => 'transx_side_panel',
                        'settings' => $wp_setting_name,
                        'description' => '<i class="transx_dependency_customizer" data-dependency-id="side_panel_socials" data-dependency-val="show"></i>'
                    )
                ));
        
                // ------------------------- //
                // --- Side Panel Button --- //
                // ------------------------- //
                $wp_setting_name = 'side_panel_button';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Panel Button', 'transx'),
                        'section' => 'transx_side_panel',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'show' => esc_html__('Show', 'transx'),
                            'hide' => esc_html__('Hide', 'transx')
                        )
                    )
                ));

                // ---------------------------- //
                // --- Side Panel Instagram --- //
                // ---------------------------- //
                $wp_setting_name = 'side_panel_instagram';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Panel Instagram', 'transx'),
                        'section' => 'transx_side_panel',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'show' => esc_html__('Show', 'transx'),
                            'hide' => esc_html__('Hide', 'transx')
                        )
                    )
                ));

                // -------------------------- //
                // --- Header Button Link --- //
                // -------------------------- //
                $wp_setting_name = 'side_panel_insta_shortcode';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'transx_sanitize_callback_with_tags'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Panel Instagram Shortcode', 'transx'),
                        'section' => 'transx_side_panel',
                        'settings' => $wp_setting_name,
                        'description' => '<i class="transx_dependency_customizer" data-dependency-id="side_panel_instagram" data-dependency-val="show"></i>'
                    )
                ));

        // -------------------------------- //
        // ---------- Typography ---------- //
        // -------------------------------- //
        $wp_customize->add_panel('transx_typography_settings',
            array(
                'title' => esc_attr__('Typography Settings', 'transx'),
                'priority' => 140
            )
        );

            // ---#################--- //
            // ---### Main Font ###--- //
            // ---#################--- //
            $wp_customize->add_section('transx_typography_main_font',
                array(
                    'title' => esc_attr__('Main Font', 'transx'),
                    'panel' => 'transx_typography_settings'
                )
            );

                // ------------------------ //
                // --- Main Font Family --- //
                // ------------------------ //
                $wp_setting_name = 'main_font_family';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Main Font Family', 'transx'),
                        'section' => 'transx_typography_main_font',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => transx_get_all_fonts_name(),
                    )
                ));

                // ---------------------- //
                // --- Main Font Size --- //
                // ---------------------- //
                $wp_setting_name = 'main_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Main Font Size', 'transx'),
                        'section' => 'transx_typography_main_font',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ----------------------------- //
                // --- Main Font Line Height --- //
                // ----------------------------- //
                $wp_setting_name = 'main_line_height';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Main Font Line Height', 'transx'),
                        'section' => 'transx_typography_main_font',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------ //
                // --- Main Font Weight --- //
                // ------------------------ //
                $wp_setting_name = 'main_font_weight';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Main Font Weight', 'transx'),
                        'section' => 'transx_typography_main_font',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'description' => 'Please keep in mind that most fonts do not support such exotic thicknesses as the 100. The most common values: 300, 400, 600, 700.',
                        'choices' => array(
                            '100' => '100',
                            '200' => '200',
                            '300' => '300',
                            '400' => '400',
                            '500' => '500',
                            '600' => '600',
                            '700' => '700',
                            '800' => '800',
                            '900' => '900'
                        )
                    )
                ));

            // ---################--- //
            // ---### Headings ###--- //
            // ---################--- //
            $wp_customize->add_section('transx_typography_headings',
                array(
                    'title' => esc_attr__('Headings', 'transx'),
                    'panel' => 'transx_typography_settings'
                )
            );

                // ---------------------------- //
                // --- Headings Font Family --- //
                // ---------------------------- //
                $wp_setting_name = 'headings_font_family';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Headings Font Family', 'transx'),
                        'section' => 'transx_typography_headings',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => transx_get_all_fonts_name(),
                    )
                ));

                // ---------------------------- //
                // --- Headings Font Weight --- //
                // ---------------------------- //
                $wp_setting_name = 'headings_font_weight';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Headings Font Weight', 'transx'),
                        'section' => 'transx_typography_headings',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'description' => 'Please keep in mind that most fonts do not support such exotic thicknesses as the 100. The most common values: 300, 400, 600, 700.',
                        'choices' => array(
                            '100' => '100',
                            '200' => '200',
                            '300' => '300',
                            '400' => '400',
                            '500' => '500',
                            '600' => '600',
                            '700' => '700',
                            '800' => '800',
                            '900' => '900'
                        )
                    )
                ));

                // -------------------------- //
                // --- Headings Uppercase --- //
                // -------------------------- //
                $wp_setting_name = 'headings_uppercase';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Headings Uppercase', 'transx'),
                        'section' => 'transx_typography_headings',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));

                // ----------------------- //
                // --- Headings Italic --- //
                // ----------------------- //
                $wp_setting_name = 'headings_italic';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Headings Italic', 'transx'),
                        'section' => 'transx_typography_headings',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));

                // -------------------- //
                // --- H1 Font Size --- //
                // -------------------- //
                $wp_setting_name = 'h1_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('H1 Font Size', 'transx'),
                        'section' => 'transx_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------- //
                // --- H1 Line Height --- //
                // ---------------------- //
                $wp_setting_name = 'h1_line_height';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('H1 Line Height', 'transx'),
                        'section' => 'transx_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------- //
                // --- H2 Font Size --- //
                // -------------------- //
                $wp_setting_name = 'h2_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('H2 Font Size', 'transx'),
                        'section' => 'transx_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------- //
                // --- H2 Line Height --- //
                // ---------------------- //
                $wp_setting_name = 'h2_line_height';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('H2 Line Height', 'transx'),
                        'section' => 'transx_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------- //
                // --- H3 Font Size --- //
                // -------------------- //
                $wp_setting_name = 'h3_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('H3 Font Size', 'transx'),
                        'section' => 'transx_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------- //
                // --- H3 Line Height --- //
                // ---------------------- //
                $wp_setting_name = 'h3_line_height';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('H3 Line Height', 'transx'),
                        'section' => 'transx_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------- //
                // --- H4 Font Size --- //
                // -------------------- //
                $wp_setting_name = 'h4_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('H4 Font Size', 'transx'),
                        'section' => 'transx_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------- //
                // --- H4 Line Height --- //
                // ---------------------- //
                $wp_setting_name = 'h4_line_height';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('H4 Line Height', 'transx'),
                        'section' => 'transx_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------- //
                // --- H5 Font Size --- //
                // -------------------- //
                $wp_setting_name = 'h5_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('H5 Font Size', 'transx'),
                        'section' => 'transx_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------- //
                // --- H5 Line Height --- //
                // ---------------------- //
                $wp_setting_name = 'h5_line_height';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('H5 Line Height', 'transx'),
                        'section' => 'transx_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------- //
                // --- H6 Font Size --- //
                // -------------------- //
                $wp_setting_name = 'h6_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('H6 Font Size', 'transx'),
                        'section' => 'transx_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------- //
                // --- H6 Line Height --- //
                // ---------------------- //
                $wp_setting_name = 'h6_line_height';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('H6 Line Height', 'transx'),
                        'section' => 'transx_typography_headings',
                        'settings' => $wp_setting_name,
                    )
                ));

            // ---###############--- //
            // ---### Buttons ###--- //
            // ---###############--- //
            $wp_customize->add_section('transx_typography_buttons',
                array(
                    'title' => esc_attr__('Buttons', 'transx'),
                    'panel' => 'transx_typography_settings'
                )
            );

                // --------------------------- //
                // --- Buttons Font Family --- //
                // --------------------------- //
                $wp_setting_name = 'buttons_font_family';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Buttons Font Family', 'transx'),
                        'section' => 'transx_typography_buttons',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => transx_get_all_fonts_name(),
                    )
                ));

                // ------------------------- //
                // --- Buttons Font Size --- //
                // ------------------------- //
                $wp_setting_name = 'buttons_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Buttons Font Size', 'transx'),
                        'section' => 'transx_typography_buttons',
                        'settings' => $wp_setting_name,
                    )
                ));

                // --------------------------- //
                // --- Buttons Font Weight --- //
                // --------------------------- //
                $wp_setting_name = 'buttons_font_weight';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Buttons Font Weight', 'transx'),
                        'section' => 'transx_typography_buttons',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'description' => 'Please keep in mind that most fonts do not support such exotic thicknesses as the 100. The most common values: 300, 400, 600, 700.',
                        'choices' => array(
                            '100' => '100',
                            '200' => '200',
                            '300' => '300',
                            '400' => '400',
                            '500' => '500',
                            '600' => '600',
                            '700' => '700',
                            '800' => '800',
                            '900' => '900'
                        )
                    )
                ));

                // ------------------------- //
                // --- Buttons Uppercase --- //
                // ------------------------- //
                $wp_setting_name = 'buttons_uppercase';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Buttons Uppercase', 'transx'),
                        'section' => 'transx_typography_buttons',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));

                // ---------------------- //
                // --- Buttons Italic --- //
                // ---------------------- //
                $wp_setting_name = 'buttons_italic';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Buttons Italic', 'transx'),
                        'section' => 'transx_typography_buttons',
                        'settings' => $wp_setting_name,
                        'type' => 'checkbox'
                    )
                ));

            // ---##################--- //
            // ---### Page Title ###--- //
            // ---##################--- //
            $wp_customize->add_section('transx_typography_page_title',
                array(
                    'title' => esc_attr__('Page Title', 'transx'),
                    'panel' => 'transx_typography_settings'
                )
            );

                // ------------------------------ //
                // --- Site Title Font Family --- //
                // ------------------------------ //
                $wp_setting_name = 'site_title_font_family';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Site Title Font Family', 'transx'),
                        'section' => 'transx_typography_page_title',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => transx_get_all_fonts_name(),
                    )
                ));

                // ---------------------------- //
                // --- Site Title Font Size --- //
                // ---------------------------- //
                $wp_setting_name = 'site_title_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Site Title Font Size', 'transx'),
                        'section' => 'transx_typography_page_title',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------ //
                // --- Page Title Font Family --- //
                // ------------------------------ //
                $wp_setting_name = 'page_title_font_family';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Page Title Font Family', 'transx'),
                        'section' => 'transx_typography_page_title',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => transx_get_all_fonts_name(),
                    )
                ));

                // ---------------------------- //
                // --- Page Title Font Size --- //
                // ---------------------------- //
                $wp_setting_name = 'page_title_font_size';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Page Title Font Size', 'transx'),
                        'section' => 'transx_typography_page_title',
                        'settings' => $wp_setting_name,
                    )
                ));

        // ---------------------------------- //
        // ---------- Social Links ---------- //
        // ---------------------------------- //
        $wp_customize->add_section('transx_socials_settings',
            array(
                'title' => esc_attr__('Social Links', 'transx'),
                'priority' => 145
            )
        );

            // ---------------------- //
            // --- Socials Target --- //
            // ---------------------- //
            $wp_setting_name = 'socials_target';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Open Socials in New Tab', 'transx'),
                    'section' => 'transx_socials_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'checkbox',
                )
            ));

            // --------------- //
            // --- YouTube --- //
            // --------------- //
            $wp_setting_name = 'socials_youtube';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('YouTube', 'transx'),
                    'section' => 'transx_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));

            // ---------------- //
            // --- Facebook --- //
            // ---------------- //
            $wp_setting_name = 'socials_facebook';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Facebook', 'transx'),
                    'section' => 'transx_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));

            // --------------- //
            // --- Twitter --- //
            // --------------- //
            $wp_setting_name = 'socials_twitter';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Twitter', 'transx'),
                    'section' => 'transx_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));
    
            // ---------------- //
            // --- LinkedIn --- //
            // ---------------- //
            $wp_setting_name = 'socials_linkedin';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('LinkedIn', 'transx'),
                    'section' => 'transx_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));
    
            // ----------------- //
            // --- Instagram --- //
            // ----------------- //
            $wp_setting_name = 'socials_instagram';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Instagram', 'transx'),
                    'section' => 'transx_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));

            // ---------------- //
            // --- Whatsapp --- //
            // ---------------- //
            $wp_setting_name = 'socials_whatsapp';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Whatsapp', 'transx'),
                    'section' => 'transx_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));
    
            // ----------------- //
            // --- Pinterest --- //
            // ----------------- //
            $wp_setting_name = 'socials_pinterest';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Pinterest', 'transx'),
                    'section' => 'transx_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));
    
            // -------------- //
            // --- Tumblr --- //
            // -------------- //
            $wp_setting_name = 'socials_tumbl';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Tumblr', 'transx'),
                    'section' => 'transx_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));
    
            // -------------- //
            // --- Flickr --- //
            // -------------- //
            $wp_setting_name = 'socials_flickr';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Flickr', 'transx'),
                    'section' => 'transx_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));
    
            // ---------- //
            // --- VK --- //
            // ---------- //
            $wp_setting_name = 'socials_vk';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('VK', 'transx'),
                    'section' => 'transx_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));
    
            // ---------------- //
            // --- Dribbble --- //
            // ---------------- //
            $wp_setting_name = 'socials_dribbble';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Dribbble', 'transx'),
                    'section' => 'transx_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));
    
            // ------------- //
            // --- Vimeo --- //
            // ------------- //
            $wp_setting_name = 'socials_vimeo';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Vimeo', 'transx'),
                    'section' => 'transx_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));
    
            // ------------- //
            // --- 500px --- //
            // ------------- //
            $wp_setting_name = 'socials_500px';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('500px', 'transx'),
                    'section' => 'transx_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));
    
            // ------------ //
            // --- XING --- //
            // ------------ //
            $wp_setting_name = 'socials_xing';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Xing', 'transx'),
                    'section' => 'transx_socials_settings',
                    'settings' => $wp_setting_name,
                )
            ));

        // ------------------------------------ //
        // ---------- Color Settings ---------- //
        // ------------------------------------ //
        $wp_customize->add_panel('transx_color_settings',
            array(
                'title' => esc_attr__('Color Settings', 'transx'),
                'priority' => 150
            )
        );

            // ---###############--- //
            // ---### General ###--- //
            // ---###############--- //
            $wp_customize->add_section('transx_general_colors',
                array(
                    'title' => esc_attr__('General', 'transx'),
                    'panel' => 'transx_color_settings'
                )
            );

                // ----------------------- //
                // --- Site Background --- //
                // ----------------------- //
                $wp_setting_name = 'site_bg_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Site Background', 'transx'),
                        'section' => 'transx_general_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ----------------------- //
                // --- Site Main Color --- //
                // ----------------------- //
                $wp_setting_name = 'main_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Site Main Color', 'transx'),
                        'section' => 'transx_general_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------- //
                // --- Site Main Color 2 --- //
                // ------------------------- //
                $wp_setting_name = 'main_color_2';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Second Main Color', 'transx'),
                        'section' => 'transx_general_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ----------------------- //
                // --- Main Font Color --- //
                // ----------------------- //
                $wp_setting_name = 'main_font_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Main Font Color', 'transx'),
                        'section' => 'transx_general_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------- //
                // --- Headings Color --- //
                // ---------------------- //
                $wp_setting_name = 'headings_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Headings Color', 'transx'),
                        'section' => 'transx_general_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------------- //
                // --- Listing Titles Color --- //
                // ---------------------------- //
                $wp_setting_name = 'listing_titles_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Listing Titles Color', 'transx'),
                        'section' => 'transx_general_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------------- //
                // --- Listing Titles Color --- //
                // ---------------------------- //
                $wp_setting_name = 'listing_titles_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Listing Titles Hover', 'transx'),
                        'section' => 'transx_general_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

            // ---##################--- //
            // ---### Side Panel ###--- //
            // ---##################--- //
            $wp_customize->add_section('transx_side_panel_colors',
                array(
                    'title' => esc_attr__('Side Panel', 'transx'),
                    'panel' => 'transx_color_settings'
                )
            );
    
                // ----------------------------- //
                // --- Side Panel Background --- //
                // ----------------------------- //
                $wp_setting_name = 'side_panel_bg';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Panel Background', 'transx'),
                        'section' => 'transx_side_panel_colors',
                        'settings' => $wp_setting_name,
                    )
                ));
        
                // -------------------------- //
                // --- Close Button Color --- //
                // -------------------------- //
                $wp_setting_name = 'side_panel_close_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Close Button Color', 'transx'),
                        'section' => 'transx_side_panel_colors',
                        'settings' => $wp_setting_name,
                    )
                ));
        
                // -------------------------- //
                // --- Close Button Hover --- //
                // -------------------------- //
                $wp_setting_name = 'side_panel_close_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Close Button Hover', 'transx'),
                        'section' => 'transx_side_panel_colors',
                        'settings' => $wp_setting_name,
                    )
                ));
        
                // ----------------------- //
                // --- Side Menu Color --- //
                // ----------------------- //
                $wp_setting_name = 'side_panel_menu_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Menu Color', 'transx'),
                        'section' => 'transx_side_panel_colors',
                        'settings' => $wp_setting_name,
                    )
                ));
        
                // ----------------------- //
                // --- Side Menu Hover --- //
                // ----------------------- //
                $wp_setting_name = 'side_panel_menu_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Menu Hover', 'transx'),
                        'section' => 'transx_side_panel_colors',
                        'settings' => $wp_setting_name,
                    )
                ));
        
                // ----------------------------- //
                // --- Side Panel Info Color --- //
                // ----------------------------- //
                $wp_setting_name = 'side_panel_info_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Panel Info Color', 'transx'),
                        'section' => 'transx_side_panel_colors',
                        'settings' => $wp_setting_name,
                    )
                ));
        
                // ----------------------------- //
                // --- Side Panel Info Hover --- //
                // ----------------------------- //
                $wp_setting_name = 'side_panel_info_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Panel Info Hover', 'transx'),
                        'section' => 'transx_side_panel_colors',
                        'settings' => $wp_setting_name,
                    )
                ));
        
                // -------------------------------- //
                // --- Side Panel Socials Color --- //
                // -------------------------------- //
                $wp_setting_name = 'side_panel_socials_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Panel Socials Color', 'transx'),
                        'section' => 'transx_side_panel_colors',
                        'settings' => $wp_setting_name,
                    )
                ));
        
                // -------------------------------- //
                // --- Side Panel Socials Hover --- //
                // -------------------------------- //
                $wp_setting_name = 'side_panel_socials_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Panel Socials Hover', 'transx'),
                        'section' => 'transx_side_panel_colors',
                        'settings' => $wp_setting_name,
                    )
                ));
        
            // ---################--- //
            // ---### Tag Line ###--- //
            // ---################--- //
            $wp_customize->add_section('transx_tagline_colors',
                array(
                    'title' => esc_attr__('Tag Line', 'transx'),
                    'panel' => 'transx_color_settings'
                )
            );

                // --------------------------- //
                // --- Tag Line Background --- //
                // --------------------------- //
                $wp_setting_name = 'tadline_bg';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Tag Line Background', 'transx'),
                        'section' => 'transx_tagline_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------------- //
                // --- Tag Line Links Color --- //
                // ---------------------------- //
                $wp_setting_name = 'tagline_link_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Tag Line Links Color', 'transx'),
                        'section' => 'transx_tagline_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------------- //
                // --- Tag Line Links Hover --- //
                // ---------------------------- //
                $wp_setting_name = 'tagline_link_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Tag Line Links Hover', 'transx'),
                        'section' => 'transx_tagline_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------------- //
                // --- Tag Line Links Hover --- //
                // ---------------------------- //
                $wp_setting_name = 'tagline_socials_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Tag Line Socials Hover', 'transx'),
                        'section' => 'transx_tagline_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

            // ---##############--- //
            // ---### Header ###--- //
            // ---##############--- //
            $wp_customize->add_section('transx_header_colors',
                array(
                    'title' => esc_attr__('Header', 'transx'),
                    'panel' => 'transx_color_settings'
                )
            );

                // ------------------------- //
                // --- Header Background --- //
                // ------------------------- //
                $wp_setting_name = 'header_bg';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Header Background', 'transx'),
                        'section' => 'transx_header_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------------------- //
                // --- Side Panel Trigger Color --- //
                // -------------------------------- //
                $wp_setting_name = 'side_panel_trigger_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Panel Trigger Color', 'transx'),
                        'section' => 'transx_header_colors',
                        'settings' => $wp_setting_name,
                    )
                ));
        
                // -------------------------------- //
                // --- Side Panel Trigger Hover --- //
                // -------------------------------- //
                $wp_setting_name = 'side_panel_trigger_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Side Panel Trigger Hover', 'transx'),
                        'section' => 'transx_header_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------- //
                // --- Header Menu Color --- //
                // ------------------------- //
                $wp_setting_name = 'header_menu_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Header Menu Color', 'transx'),
                        'section' => 'transx_header_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------- //
                // --- Header Menu Hover --- //
                // ------------------------- //
                $wp_setting_name = 'header_menu_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Header Menu Hover', 'transx'),
                        'section' => 'transx_header_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------------- //
                // --- Transparent Header Menu Hover --- //
                // ------------------------------------- //
                $wp_setting_name = 'transparent_header_menu_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Transparent Header Menu Hover', 'transx'),
                        'section' => 'transx_header_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ----------------------------------------- //
                // --- Transparent Header Sub Menu Color --- //
                // ----------------------------------------- //
                $wp_setting_name = 'transparent_header_menu_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Transparent Header Sub Menu Color', 'transx'),
                        'section' => 'transx_header_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ----------------------------- //
                // --- Header Sub Menu Color --- //
                // ----------------------------- //
                $wp_setting_name = 'header_sub_menu_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Header Sub Menu Color', 'transx'),
                        'section' => 'transx_header_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ----------------------------- //
                // --- Header Sub Menu Hover --- //
                // ----------------------------- //
                $wp_setting_name = 'header_sub_menu_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Header Sub Menu Hover', 'transx'),
                        'section' => 'transx_header_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ---------------------------------- //
                // --- Header Sub Menu Background --- //
                // ---------------------------------- //
                $wp_setting_name = 'header_sub_menu_bg';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Header Sub Menu Background', 'transx'),
                        'section' => 'transx_header_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

            // ---###############--- //
            // ---### Buttons ###--- //
            // ---###############--- //
            $wp_customize->add_section('transx_buttons_colors',
                array(
                    'title' => esc_attr__('Buttons', 'transx'),
                    'panel' => 'transx_color_settings'
                )
            );

                // --------------------------- //
                // --- Header Button Color --- //
                // --------------------------- //
                $wp_setting_name = 'header_button_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Header Button Color', 'transx'),
                        'section' => 'transx_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------------------- //
                // --- Header Button Background --- //
                // -------------------------------- //
                $wp_setting_name = 'header_button_bg';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Header Button Background', 'transx'),
                        'section' => 'transx_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // --------------------------- //
                // --- Header Button Hover --- //
                // --------------------------- //
                $wp_setting_name = 'header_button_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Header Button Hover', 'transx'),
                        'section' => 'transx_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------------------------- //
                // --- Header Button Background Hover --- //
                // -------------------------------------- //
                $wp_setting_name = 'header_button_bg_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Header Button Background Hover', 'transx'),
                        'section' => 'transx_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------- //
                // --- Button Color --- //
                // -------------------- //
                $wp_setting_name = 'button_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Button Color', 'transx'),
                        'section' => 'transx_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------- //
                // --- Button Hover --- //
                // -------------------- //
                $wp_setting_name = 'button_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Button Hover', 'transx'),
                        'section' => 'transx_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------- //
                // --- Button Background --- //
                // ------------------------- //
                $wp_setting_name = 'button_bg_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Button Background', 'transx'),
                        'section' => 'transx_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------- //
                // --- Button Background Hover --- //
                // ------------------------------- //
                $wp_setting_name = 'button_bg_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Button Background Hover', 'transx'),
                        'section' => 'transx_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // --------------------------- //
                // --- Button Border Color --- //
                // --------------------------- //
                $wp_setting_name = 'button_border_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Button Border Color', 'transx'),
                        'section' => 'transx_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // --------------------------- //
                // --- Button Border Hover --- //
                // --------------------------- //
                $wp_setting_name = 'button_border_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Button Border Hover', 'transx'),
                        'section' => 'transx_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // --------------------------------- //
                // --- Post Social Buttons Color --- //
                // --------------------------------- //
                $wp_setting_name = 'post_socials_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Post Social Buttons Color', 'transx'),
                        'section' => 'transx_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // --------------------------------- //
                // --- Post Social Buttons Hover --- //
                // --------------------------------- //
                $wp_setting_name = 'post_socials_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Post Social Buttons Hover', 'transx'),
                        'section' => 'transx_buttons_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

            // ---##############--- //
            // ---### Footer ###--- //
            // ---##############--- //
            $wp_customize->add_section('transx_footer_colors',
                array(
                    'title' => esc_attr__('Footer', 'transx'),
                    'panel' => 'transx_color_settings'
                )
            );

                // ----------------------- //
                // --- Prefooter Color --- //
                // ----------------------- //
                $wp_setting_name = 'prefooter_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Prefooter Text Color', 'transx'),
                        'section' => 'transx_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ----------------------------- //
                // --- Prefooter Links Hover --- //
                // ----------------------------- //
                $wp_setting_name = 'prefooter_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Prefooter Links Hover', 'transx'),
                        'section' => 'transx_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------- //
                // --- Prefooter Socials Color --- //
                // ------------------------------- //
                $wp_setting_name = 'prefooter_socials';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Prefooter Socials Color', 'transx'),
                        'section' => 'transx_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------- //
                // --- Prefooter Socials Hover --- //
                // ------------------------------- //
                $wp_setting_name = 'prefooter_socials_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Prefooter Socials Hover', 'transx'),
                        'section' => 'transx_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------------- //
                // --- Prefooter Widget Titles Color --- //
                // ------------------------------------- //
                $wp_setting_name = 'prefooter_widget_title_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Prefooter Widget Titles Color', 'transx'),
                        'section' => 'transx_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------- //
                // --- Footer Background --- //
                // ------------------------- //
                $wp_setting_name = 'footer_bg';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Footer Background', 'transx'),
                        'section' => 'transx_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------- //
                // --- Footer Color --- //
                // -------------------- //
                $wp_setting_name = 'footer_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Footer Color', 'transx'),
                        'section' => 'transx_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------------- //
                // --- Footer Links Hover --- //
                // -------------------------- //
                $wp_setting_name = 'footer_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Footer Links Hover', 'transx'),
                        'section' => 'transx_footer_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

            // ---##################--- //
            // ---### Page Title ###--- //
            // ---##################--- //
            $wp_customize->add_section('transx_page_title_colors',
                array(
                    'title' => esc_attr__('Page Title', 'transx'),
                    'panel' => 'transx_color_settings'
                )
            );

                // ------------------------ //
                // --- Site Title Color --- //
                // ------------------------ //
                $wp_setting_name = 'site_title_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Site Title Color', 'transx'),
                        'section' => 'transx_page_title_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------ //
                // --- Page Title Color --- //
                // ------------------------ //
                $wp_setting_name = 'page_title_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Page Title Color', 'transx'),
                        'section' => 'transx_page_title_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

            // ---#############--- //
            // ---### Forms ###--- //
            // ---#############--- //
            $wp_customize->add_section('transx_form_colors',
                array(
                    'title' => esc_attr__('Forms', 'transx'),
                    'panel' => 'transx_color_settings'
                )
            );

                // ------------------------ //
                // --- Form Field Color --- //
                // ------------------------ //
                $wp_setting_name = 'form_field_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Form Field Color', 'transx'),
                        'section' => 'transx_form_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ----------------------------- //
                // --- Form Field Background --- //
                // ----------------------------- //
                $wp_setting_name = 'form_field_bg';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Form Field Background', 'transx'),
                        'section' => 'transx_form_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------- //
                // --- Form Field Border --- //
                // ------------------------- //
                $wp_setting_name = 'form_field_border';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Form Field Border', 'transx'),
                        'section' => 'transx_form_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------------ //
                // --- Active Form Field Background --- //
                // ------------------------------------ //
                $wp_setting_name = 'active_form_field_bg';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Active Form Field Background', 'transx'),
                        'section' => 'transx_form_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------------------- //
                // --- Active Form Field Border --- //
                // -------------------------------- //
                $wp_setting_name = 'active_form_field_border';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Active Form Field Border', 'transx'),
                        'section' => 'transx_form_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------- //
                // --- Form Button Color --- //
                // ------------------------- //
                $wp_setting_name = 'form_button_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Form Button Color', 'transx'),
                        'section' => 'transx_form_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------- //
                // --- Form Button Hover --- //
                // ------------------------- //
                $wp_setting_name = 'form_button_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Form Button Hover', 'transx'),
                        'section' => 'transx_form_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------ //
                // --- Form Button Background --- //
                // ------------------------------ //
                $wp_setting_name = 'form_button_bg';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Form Button Background', 'transx'),
                        'section' => 'transx_form_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // ------------------------------------ //
                // --- Form Button Background Hover --- //
                // ------------------------------------ //
                $wp_setting_name = 'form_button_bg_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Form Button Background Hover', 'transx'),
                        'section' => 'transx_form_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------------------- //
                // --- Form Button Border Color --- //
                // -------------------------------- //
                $wp_setting_name = 'form_button_border_color';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Form Button Border Color', 'transx'),
                        'section' => 'transx_form_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

                // -------------------------------- //
                // --- Form Button Border Hover --- //
                // -------------------------------- //
                $wp_setting_name = 'form_button_border_hover';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Color_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Form Button Border Hover', 'transx'),
                        'section' => 'transx_form_colors',
                        'settings' => $wp_setting_name,
                    )
                ));

        // ------------------------------------------- //
        // ---------- Footer Settings Panel ---------- //
        // ------------------------------------------- //
        $wp_customize->add_panel('transx_footer_settings',
            array(
                'title' => esc_attr__('Footer Settings', 'transx'),
                'priority' => 160
            )
        );

            // ---###############--- //
            // ---### General ###--- //
            // ---###############--- //
            $wp_customize->add_section('transx_footer_general',
                array(
                    'title' => esc_attr__('General', 'transx'),
                    'panel' => 'transx_footer_settings'
                )
            );

                // -------------------------- //
                // --- Back To Top Button --- //
                // -------------------------- //
                $wp_setting_name = 'back_to_top_button';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Back To Top Button', 'transx'),
                        'section' => 'transx_footer_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'show' => esc_html__('Show', 'transx'),
                            'hide' => esc_html__('Hide', 'transx')
                        )
                    )
                ));

                // --------------------------- //
                // --- Bottom Image Status --- //
                // --------------------------- //
                $wp_setting_name = 'bottom_image_status';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Footer Background', 'transx'),
                        'section' => 'transx_footer_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'show' => esc_html__('Show', 'transx'),
                            'hide' => esc_html__('Hide', 'transx')
                        )
                    )
                ));

                // -------------------- //
                // --- Bottom Image --- //
                // -------------------- //
                $wp_setting_name = 'bottom_image';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Image_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Footer Image', 'transx'),
                        'section' => 'transx_footer_general',
                        'settings' => $wp_setting_name,
                        'description' => '<i class="transx_dependency_customizer" data-dependency-id="bottom_image_status" data-dependency-val="show"></i>'
                    )
                ));

                // ------------------------ //
                // --- Prefooter Status --- //
                // ------------------------ //
                $wp_setting_name = 'prefooter_status';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Footer Widgets Section', 'transx'),
                        'section' => 'transx_footer_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'show' => esc_html__('Show', 'transx'),
                            'hide' => esc_html__('Hide', 'transx')
                        )
                    )
                ));

                // ------------------------ //
                // --- Prefooter Status --- //
                // ------------------------ //
                $wp_setting_name = 'prefooter_type';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Footer Widgets Section Type', 'transx'),
                        'section' => 'transx_footer_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'type_1' => esc_html__('Type 1', 'transx'),
                            'type_2' => esc_html__('Type 2', 'transx'),
                            'type_3' => esc_html__('Type 3', 'transx'),
                            'type_4' => esc_html__('Type 4', 'transx')
                        ),
                        'description' => '<i class="transx_dependency_customizer" data-dependency-id="prefooter_status" data-dependency-val="show"></i>'
                    )
                ));

                // --------------------- //
                // --- Footer Status --- //
                // --------------------- //
                $wp_setting_name = 'footer_status';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Footer', 'transx'),
                        'section' => 'transx_footer_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'show' => esc_html__('Show', 'transx'),
                            'hide' => esc_html__('Hide', 'transx')
                        )
                    )
                ));

                // ------------------- //
                // --- Footer Type --- //
                // ------------------- //
                $wp_setting_name = 'footer_type';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Footer Type', 'transx'),
                        'section' => 'transx_footer_general',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'type_1' => esc_html__('Type 1', 'transx'),
                            'type_2' => esc_html__('Type 2', 'transx'),
                            'type_3' => esc_html__('Type 3', 'transx')
                        )
                    )
                ));

            // ---######################--- //
            // ---### Footer Content ###--- //
            // ---######################--- //
            $wp_customize->add_section('transx_footer_content',
                array(
                    'title' => esc_attr__('Footer Content', 'transx'),
                    'panel' => 'transx_footer_settings'
                )
            );

                // ------------------------ //
                // --- Copyright Status --- //
                // ------------------------ //
                $wp_setting_name = 'copyright_status';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Footer Copyright', 'transx'),
                        'section' => 'transx_footer_content',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'show' => esc_html__('Show', 'transx'),
                            'hide' => esc_html__('Hide', 'transx')
                        )
                    )
                ));

                // ---------------------- //
                // --- Copyright Text --- //
                // ---------------------- //
                $wp_setting_name = 'copyright';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'transx_sanitize_callback_with_tags'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Footer Copyright Text', 'transx'),
                        'section' => 'transx_footer_content',
                        'settings' => $wp_setting_name,
                        'description' => '<i class="transx_dependency_customizer" data-dependency-id="copyright_status" data-dependency-val="show"></i>'
                    )
                ));

                // ------------------- //
                // --- Footer Menu --- //
                // ------------------- //
                $wp_setting_name = 'footer_menu_status';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Footer Menu', 'transx'),
                        'section' => 'transx_footer_content',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'show' => esc_html__('Show', 'transx'),
                            'hide' => esc_html__('Hide', 'transx')
                        )
                    )
                ));

                // --------------------- //
                // --- Footer Menu 2 --- //
                // --------------------- //
                $wp_setting_name = 'footer_menu_2_status';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Footer Menu 2', 'transx'),
                        'section' => 'transx_footer_content',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'show' => esc_html__('Show', 'transx'),
                            'hide' => esc_html__('Hide', 'transx')
                        )
                    )
                ));

                // -------------------------- //
                // --- Footer Logo Status --- //
                // -------------------------- //
                $wp_setting_name = 'footer_socials_status';
                $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
                $wp_customize->add_control(new WP_Customize_Control(
                    $wp_customize,
                    $wp_setting_name,
                    array(
                        'label' => esc_attr__('Footer Socials', 'transx'),
                        'section' => 'transx_footer_content',
                        'settings' => $wp_setting_name,
                        'type' => 'select',
                        'choices' => array(
                            'show' => esc_html__('Show', 'transx'),
                            'hide' => esc_html__('Hide', 'transx')
                        )
                    )
                ));

        // -------------------------------- //
        // ---------- Page Title ---------- //
        // -------------------------------- //
        $wp_customize->add_section('transx_page_title_settings',
            array(
                'title' => esc_attr__('Page Title', 'transx'),
                'priority' => 170
            )
        );

            // ------------------- //
            // --- Page Title --- //
            // ------------------- //
            $wp_setting_name = 'page_title_status';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Page Title', 'transx'),
                    'section' => 'transx_page_title_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'show' => esc_html__('Show', 'transx'),
                        'hide' => esc_html__('Hide', 'transx')
                    )
                )
            ));

            // ------------------------------- //
            // --- Page Title Block Height --- //
            // ------------------------------- //
            $wp_setting_name = 'title_height';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Page Title Height, px', 'transx'),
                    'section' => 'transx_page_title_settings',
                    'settings' => $wp_setting_name,
                )
            ));

            // ------------------ //
            // --- Site Title --- //
            // ------------------ //
            $wp_setting_name = 'site_title_status';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Site Title', 'transx'),
                    'section' => 'transx_page_title_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'show' => esc_html__('Show', 'transx'),
                        'hide' => esc_html__('Hide', 'transx')
                    )
                )
            ));

            // ----------------------- //
            // --- Site Title Type --- //
            // ----------------------- //
            $wp_setting_name = 'site_title_type';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Site Title Type', 'transx'),
                    'section' => 'transx_page_title_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'custom' => esc_html__('Custom', 'transx'),
                        'default' => esc_html__('Default', 'transx')
                    ),
                    'description' => '<i class="transx_dependency_customizer" data-dependency-id="site_title_status" data-dependency-val="show"></i>'
                )
            ));

            // ------------------------------ //
            // --- Alternative Site Title --- //
            // ------------------------------ //
            $wp_setting_name = 'alt_site_title';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Alternative Site Title', 'transx'),
                    'section' => 'transx_page_title_settings',
                    'settings' => $wp_setting_name,
                    'description' => '<i class="transx_dependency_customizer" data-dependency-id="site_title_status" data-dependency-val="show"></i>'
                )
            ));

            // ----------------------------------------- //
            // --- Background Image (Selected Image) --- //
            // ----------------------------------------- //
            $wp_setting_name = 'post_title_bg';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Image_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Background Image', 'transx'),
                    'section' => 'transx_page_title_settings',
                    'settings' => $wp_setting_name,
                )
            ));

            // ----------------------------- //
            // --- Page Title Background --- //
            // ----------------------------- //
            $wp_setting_name = 'post_title_bg_color';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Color_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Page Title Background Color', 'transx'),
                    'section' => 'transx_page_title_settings',
                    'settings' => $wp_setting_name,
                )
            ));

        // ------------------------------ //
        // ---------- Sidebars ---------- //
        // ------------------------------ //
        $wp_customize->add_section('transx_sidebar_settings',
            array(
                'title' => esc_attr__('Sidebars', 'transx'),
                'priority' => 180
            )
        );

            // ------------------------ //
            // --- Sidebar Position --- //
            // ------------------------ //
            $wp_setting_name = 'sidebar_position';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Sidebar Position', 'transx'),
                    'section' => 'transx_sidebar_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'left' => esc_html__('Left', 'transx'),
                        'right' => esc_html__('Right', 'transx'),
                        'none' => esc_html__('None', 'transx')
                    )
                )
            ));

        // --------------------------------- //
        // ---------- Single Post ---------- //
        // --------------------------------- //
        $wp_customize->add_section('transx_single_post_settings',
            array(
                'title' => esc_attr__('Single Post', 'transx'),
                'priority' => 190
            )
        );

            // ------------------------------ //
            // --- Media Output Container --- //
            // ------------------------------ //
            $wp_setting_name = 'media_output_status';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Media Output Container', 'transx'),
                    'section' => 'transx_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'show' => esc_html__('Show', 'transx'),
                        'hide' => esc_html__('Hide', 'transx')
                    )
                )
            ));

            // ----------------- //
            // --- Post Meta --- //
            // ----------------- //
            $wp_setting_name = 'post_meta_status';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Post Meta', 'transx'),
                    'section' => 'transx_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'show' => esc_html__('Show', 'transx'),
                        'hide' => esc_html__('Hide', 'transx')
                    )
                )
            ));

            // -------------------------------- //
            // --- Panel After Post Content --- //
            // -------------------------------- //
            $wp_setting_name = 'after_content_panel_status';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Panel After Post Content', 'transx'),
                    'section' => 'transx_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'show' => esc_html__('Show', 'transx'),
                        'hide' => esc_html__('Hide', 'transx')
                    )
                )
            ));

            // --------------------- //
            // --- Post Comments --- //
            // --------------------- //
            $wp_setting_name = 'comments_status';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Post Comments', 'transx'),
                    'section' => 'transx_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'show' => esc_html__('Show', 'transx'),
                        'hide' => esc_html__('Hide', 'transx')
                    )
                )
            ));

            // ----------------------- //
            // --- Post Navigation --- //
            // ----------------------- //
            $wp_setting_name = 'post_nav';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Post Navigation', 'transx'),
                    'section' => 'transx_single_post_settings',
                    'settings' => $wp_setting_name,
                    'type' => 'select',
                    'choices' => array(
                        'show' => esc_html__('Show', 'transx'),
                        'hide' => esc_html__('Hide', 'transx')
                    )
                )
            ));

        // ------------------------------ //
        // ---------- 404 Page ---------- //
        // ------------------------------ //
        $wp_customize->add_section('transx_404_page_settings',
            array(
                'title' => esc_attr__('Error 404 Page', 'transx'),
                'priority' => 195
            )
        );

            // --------------------------- //
            // --- 404 Page Background --- //
            // --------------------------- //
            $wp_setting_name = '404_bg_image';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Image_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Background Image', 'transx'),
                    'section' => 'transx_404_page_settings',
                    'settings' => $wp_setting_name,
                )
            ));

            // --------------------------------- //
            // --- 404 Page Background Color --- //
            // --------------------------------- //
            $wp_setting_name = '404_bg_color';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Color_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Background Color', 'transx'),
                    'section' => 'transx_404_page_settings',
                    'settings' => $wp_setting_name,
                )
            ));

            // ----------------------- //
            // --- 404 Error Title --- //
            // ----------------------- //
            $wp_setting_name = '404_title';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('404 Error Title', 'transx'),
                    'section' => 'transx_404_page_settings',
                    'settings' => $wp_setting_name
                )
            ));

            // ---------------------- //
            // --- 404 Error Text --- //
            // ---------------------- //
            $wp_setting_name = '404_text';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('404 Error Info Text', 'transx'),
                    'type' => 'textarea',
                    'section' => 'transx_404_page_settings',
                    'settings' => $wp_setting_name
                )
            ));

            // ----------------------------- //
            // --- 404 Error Button Text --- //
            // ----------------------------- //
            $wp_setting_name = '404_button_text';
            $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
            $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,
                $wp_setting_name,
                array(
                    'label' => esc_attr__('Home Button Text', 'transx'),
                    'section' => 'transx_404_page_settings',
                    'settings' => $wp_setting_name
                )
            ));

        // --------------------------------- //
        // ---------- WooCommerce ---------- //
        // --------------------------------- //
        $wp_customize->add_section('transx_woo_settings',
            array(
                'title' => esc_attr__('TransX Settings for WooCommerce', 'transx'),
                'priority' => 197
            )
        );

        // ---------------------------- //
        // --- Woo Title Background --- //
        // ---------------------------- //
        $wp_setting_name = 'woo_title_bg_image';
        $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
        $wp_customize->add_control(new WP_Customize_Image_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label' => esc_attr__('Single Products Title Background Image', 'transx'),
                'section' => 'transx_woo_settings',
                'settings' => $wp_setting_name,
            )
        ));

        // ------------------------------ //
        // --- Woo Product Page Title --- //
        // ------------------------------ //
        $wp_setting_name = 'woo_prod_title';
        $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label' => esc_attr__('Product Page Title Box Text', 'transx'),
                'section' => 'transx_woo_settings',
                'settings' => $wp_setting_name
            )
        ));

        // --------------------------- //
        // --- Shop Cart In Header --- //
        // --------------------------- //
        $wp_setting_name = 'header_cart_status';
        $wp_customize->add_setting($wp_setting_name, array('default' => $transx_customizer_default_values[$wp_setting_name], 'sanitize_callback'	=> 'esc_attr'));
        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label' => esc_attr__('Header Shop Cart', 'transx'),
                'section' => 'transx_woo_settings',
                'settings' => $wp_setting_name,
                'type' => 'select',
                'choices' => array(
                    'show' => esc_html__('Show', 'transx'),
                    'hide' => esc_html__('Hide', 'transx')
                )
            )
        ));
    }
}
