<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     9.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( $related_products && GBT_Opt::getOption( 'related_products_on_product_page', true ) ) : ?>

	<div class="products_slider related_products_section">

		<div class="gbtr_items_sliders_header">
			<div class="gbtr_items_sliders_title">
				<?php esc_html_e( 'Related products', 'woocommerce' ); ?>
			</div>
		</div>

		<div class="swiper-container">

			<div class="swiper-wrapper">

				<?php foreach ( $related_products as $related_product ) : ?>

					<?php
					$post_object = get_post( $related_product->get_id() );
					setup_postdata( $GLOBALS['post'] = $post_object ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found
					?>

					<ul class="swiper-slide">
						<?php wc_get_template_part( 'content', 'product' ); ?>
					</ul>

				<?php endforeach; ?>

			</div>

		</div>

		<div class="swiper-pagination"></div>

		<div class="slider-button-prev"></div>
		<div class="slider-button-next"></div>

	</div>

	<?php
endif;

wp_reset_postdata();
