<?php
/*
Template Name: Page with Left Sidebar
*/

$page_id = getbowtied_get_current_page_id();

$page_title_option = "on";
if ( get_post_meta( $page_id, 'page_title_meta_box_check', true ) ) {
	$page_title_option = get_post_meta( $page_id, 'page_title_meta_box_check', true );
}

get_header();
?>

<div class="global_content_wrapper <?php echo ( esc_attr($page_title_option) == "off" ) ? 'hidden-title' : ''; ?>">

    <div class="page_has_sidebar page_has_sidebar_left">

		<div id="primary" class="content-area">
			<div id="content" class="site-content" role="main">

				<?php while ( have_posts() ) : the_post(); ?>

					<?php get_template_part( 'content', 'page' ); ?>

				<?php endwhile; // end of the loop. ?>

			</div><!-- #content .site-content -->
		</div><!-- #primary .content-area -->

	</div>

	<div class="page_sidebar page_sidebar_left">
		<?php get_sidebar(); ?>
    </div>

    <div class="clear"></div>

</div>

<?php if( getbowtied_has_light_footer() || getbowtied_has_dark_footer() ) { ?>
	<div class="gbtr_widgets_footer_wrapper">
		<div class="trigger-footer-widget-area">
			<i class="getbowtied-icon-more-retailer"></i>
		</div>
		<?php
		get_template_part("light_footer");
		get_template_part("dark_footer");
		?>
	</div>
<?php } ?>

<?php get_footer(); ?>
