<?php

class GBT_Icon {

	/**
	 *  We don't need a constructor
	 */
	private function __construct() {}

	/**
	 * Default svg codes for custom icons
	 *
	 * @return array
	 */
	private static function icons_defaults() {
		return [
			'arrow-down'     => 'M 7.4296875 9.5 L 5.9296875 11 L 12 17.070312 L 18.070312 11 L 16.570312 9.5 L 12 14.070312 L 7.4296875 9.5 z',
			'chat-bubble'    => 'M 4 3 C 2.9 3 2.0097656 3.9 2.0097656 5 L 2.0019531 16.998047 C 2.0019531 18.103047 2.8969531 19 4.0019531 19 L 6 19 L 6 23 L 10 19 L 20 19 C 21.1 19 22 18.1 22 17 L 22 5 C 22 3.9 21.1 3 20 3 L 4 3 z M 4 5 L 20 5 L 20 17 L 6 17 L 4.0019531 17 L 4 5 z',
			'shopping-cart'  => 'M12,4C9.5,4,7.5,6,7.5,8.5v1H4.3C4,9.5,3.8,9.7,3.8,10v14.5C3.8,24.8,4,25,4.3,25h15.4c0.3,0,0.5-0.2,0.5-0.5V10 c0-0.3-0.2-0.5-0.5-0.5h-3.2v-1C16.5,6,14.5,4,12,4z M8.5,8.5C8.5,6.6,10.1,5,12,5c1.9,0,3.5,1.6,3.5,3.5v1H8.5	C8.5,9.5,8.5,8.5,8.5,8.5z M19.2,10.5V24H4.8V10.5h2.7v1.8c0,0.3,0.2,0.5,0.5,0.5c0.3,0,0.5-0.2,0.5-0.5v-1.8h7.1v1.8 c0,0.3,0.2,0.5,0.5,0.5s0.5-0.2,0.5-0.5v-1.8H19.2z',
			'search'         => 'M 21 3 C 11.601563 3 4 10.601563 4 20 C 4 29.398438 11.601563 37 21 37 C 24.355469 37 27.460938 36.015625 30.09375 34.34375 L 42.375 46.625 L 46.625 42.375 L 34.5 30.28125 C 36.679688 27.421875 38 23.878906 38 20 C 38 10.601563 30.398438 3 21 3 Z M 21 7 C 28.199219 7 34 12.800781 34 20 C 34 27.199219 28.199219 33 21 33 C 13.800781 33 8 27.199219 8 20 C 8 12.800781 13.800781 7 21 7 Z ',
			'hamburger'      => 'M 1.582031 8.707031 L 17.417969 8.707031 L 17.417969 10.292969 L 1.582031 10.292969 Z M 1.582031 3.957031 L 17.417969 3.957031 L 17.417969 5.542969 L 1.582031 5.542969 Z M 1.582031 13.457031 L 17.417969 13.457031 L 17.417969 15.042969 L 1.582031 15.042969 Z M 1.582031 13.457031 ',
			'add-to-cart'    => 'M19.74,9.24V7A7,7,0,1,0,5.68,7V9.24H0v25H25.42v-25ZM8.68,7a4,4,0,1,1,8.06,0V9.24H8.68ZM22.42,31.2H3v-19H5.68v2.5h3v-2.5h8.06v2.5h3v-2.5h2.68ZM14.21,16.25h-3v4.14H7.08v3h4.13v4.13h3V23.39h4.14v-3H14.21Z',
			'variable'       => 'M 5.5859375 3 L 3.5859375 5 L 2 5 L 2 7 L 4.4140625 7 L 7 4.4140625 L 5.5859375 3 z M 9 5 L 9 7 L 22 7 L 22 5 L 9 5 z M 5.5859375 9 L 3.5859375 11 L 2 11 L 2 13 L 4.4140625 13 L 7 10.414062 L 5.5859375 9 z M 9 11 L 9 13 L 22 13 L 22 11 L 9 11 z M 4 16.5 A 1.5 1.5 0 0 0 2.5 18 A 1.5 1.5 0 0 0 4 19.5 A 1.5 1.5 0 0 0 5.5 18 A 1.5 1.5 0 0 0 4 16.5 z M 9 17 L 9 19 L 22 19 L 22 17 L 9 17 z',
			'not-found'      => 'M23.92,9.24v-3A6.28,6.28,0,0,0,17.64,0a6.19,6.19,0,0,0-2.78.66A6.19,6.19,0,0,0,12.08,0,6.29,6.29,0,0,0,5.8,6.28v3H0V32.7H29.32V9.24ZM14.86,2.41a4.75,4.75,0,0,1,2,3.87v3h-4v-3A4.78,4.78,0,0,1,14.86,2.41ZM7.3,6.28A4.79,4.79,0,0,1,12.08,1.5a4.51,4.51,0,0,1,1.28.2,6.26,6.26,0,0,0-2,4.58v3H7.3ZM22.42,31.2H1.5V10.74H5.8V14H7.3V10.74h9.56V14h1.5V10.74h4.06Zm0-22H18.36v-3a6.23,6.23,0,0,0-2-4.58,4.56,4.56,0,0,1,1.28-.2,4.78,4.78,0,0,1,4.78,4.78Zm5.4,22h-3.9V10.74h3.9ZM17.61,21.8a.76.76,0,0,0-.75.75V23a.75.75,0,0,0,1.5,0v-.44A.75.75,0,0,0,17.61,21.8Zm-11.06,0a.76.76,0,0,0-.75.75V23a.75.75,0,0,0,1.5,0v-.44A.75.75,0,0,0,6.55,21.8Zm5.53,2.49a3.08,3.08,0,0,0-2.65,1.54.5.5,0,1,0,.86.5,2.06,2.06,0,0,1,3.58,0,.5.5,0,0,0,.43.25.45.45,0,0,0,.25-.07.49.49,0,0,0,.18-.68A3.07,3.07,0,0,0,12.08,24.29Z',
			'arrow-right'    => 'M 10 5.9296875 L 8.5 7.4296875 L 13.070312 12 L 8.5 16.570312 L 10 18.070312 L 16.070312 12 L 10 5.9296875 z',
			'arrow-right-2'  => 'M 14 4.9296875 L 12.5 6.4296875 L 17.070312 11 L 3 11 L 3 13 L 17.070312 13 L 12.5 17.570312 L 14 19.070312 L 21.070312 12 L 14 4.9296875 z',
			'arrow-left-2'   => 'M 10 4.9296875 L 2.9296875 12 L 10 19.070312 L 11.5 17.570312 L 6.9296875 13 L 21 13 L 21 11 L 6.9296875 11 L 11.5 6.4296875 L 10 4.9296875 z',
			'check'          => 'M 20.292969 5.2929688 L 9 16.585938 L 4.7070312 12.292969 L 3.2929688 13.707031 L 9 19.414062 L 21.707031 6.7070312 L 20.292969 5.2929688 z',
			'heart'          => 'M16.5,3C13.605,3,12,5.09,12,5.09S10.395,3,7.5,3C4.462,3,2,5.462,2,8.5c0,4.171,4.912,8.213,6.281,9.49 C9.858,19.46,12,21.35,12,21.35s2.142-1.89,3.719-3.36C17.088,16.713,22,12.671,22,8.5C22,5.462,19.538,3,16.5,3z',
			'logout'         => 'M 11 2 L 11 12 L 13 12 L 13 2 L 11 2 z M 9 2.4589844 C 4.943 3.7339844 2 7.523 2 12 C 2 17.523 6.477 22 12 22 C 17.523 22 22 17.523 22 12 C 22 7.523 19.057 3.7339844 15 2.4589844 L 15 4.5878906 C 17.931 5.7748906 20 8.644 20 12 C 20 16.418 16.418 20 12 20 C 7.582 20 4 16.418 4 12 C 4 8.643 6.069 5.7748906 9 4.5878906 L 9 2.4589844 z',
			'author'         => 'M 12 2 C 6.477 2 2 6.477 2 12 C 2 17.523 6.477 22 12 22 C 17.523 22 22 17.523 22 12 C 22 6.477 17.523 2 12 2 z M 12 4 C 16.418 4 20 7.582 20 12 C 20 13.597292 19.525404 15.081108 18.71875 16.330078 L 17.949219 15.734375 C 16.397219 14.537375 13.537 14 12 14 C 10.463 14 7.6017813 14.537375 6.0507812 15.734375 L 5.28125 16.332031 C 4.4740429 15.082774 4 13.597888 4 12 C 4 7.582 7.582 4 12 4 z M 12 5.75 C 10.208 5.75 8.75 7.208 8.75 9 C 8.75 10.792 10.208 12.25 12 12.25 C 13.792 12.25 15.25 10.792 15.25 9 C 15.25 7.208 13.792 5.75 12 5.75 z M 12 7.75 C 12.689 7.75 13.25 8.311 13.25 9 C 13.25 9.689 12.689 10.25 12 10.25 C 11.311 10.25 10.75 9.689 10.75 9 C 10.75 8.311 11.311 7.75 12 7.75 z M 12 16 C 15.100714 16 16.768095 17.168477 17.548828 17.753906 C 16.109984 19.141834 14.156852 20 12 20 C 9.843148 20 7.8900164 19.141834 6.4511719 17.753906 C 7.231905 17.168477 8.899286 16 12 16 z M 6.0546875 17.339844 C 6.1756559 17.473131 6.297271 17.605851 6.4257812 17.730469 C 6.2971141 17.605286 6.1747276 17.473381 6.0546875 17.339844 z M 17.912109 17.375 C 17.802435 17.495543 17.692936 17.616825 17.576172 17.730469 C 17.692621 17.617521 17.801457 17.494978 17.912109 17.375 z',
			'date'           => 'M 6 1 L 6 3 L 5 3 C 3.9 3 3 3.9 3 5 L 3 19 C 3 20.1 3.9 21 5 21 L 19 21 C 20.1 21 21 20.1 21 19 L 21 5 C 21 3.9 20.1 3 19 3 L 18 3 L 18 1 L 16 1 L 16 3 L 8 3 L 8 1 L 6 1 z M 5 5 L 6 5 L 8 5 L 16 5 L 18 5 L 19 5 L 19 7 L 5 7 L 5 5 z M 5 9 L 19 9 L 19 19 L 5 19 L 5 9 z',
			'folder'         => 'M 4 4 C 2.9057453 4 2 4.9057453 2 6 L 2 18 C 2 19.094255 2.9057453 20 4 20 L 20 20 C 21.094255 20 22 19.094255 22 18 L 22 8 C 22 6.9057453 21.094255 6 20 6 L 12 6 L 10 4 L 4 4 z M 4 6 L 9.171875 6 L 11.171875 8 L 20 8 L 20 18 L 4 18 L 4 6 z',
			'image'          => 'M 4 4 C 2.9057453 4 2 4.9057453 2 6 L 2 18 C 2 19.094255 2.9057453 20 4 20 L 20 20 C 21.094255 20 22 19.094255 22 18 L 22 8 C 22 6.9057453 21.094255 6 20 6 L 12 6 L 10 4 L 4 4 z M 4 6 L 9.171875 6 L 11.171875 8 L 20 8 L 20 18 L 4 18 L 4 6 z',
			'tag'            => 'M 4 6 C 2.9 6 2 6.9 2 8 L 2 16 C 2 17.1 2.9 18 4 18 L 15.199219 18 C 15.699219 18 16.199609 17.800391 16.599609 17.400391 L 22 12 L 16.599609 6.5996094 C 16.199609 6.1996094 15.699219 6 15.199219 6 L 4 6 z M 4 8 L 15.199219 8 L 15.185547 8.0136719 L 19.175781 12.003906 L 15.199219 16 L 4 16 L 4 8 z M 15 11 C 14.448 11 14 11.448 14 12 C 14 12.552 14.448 13 15 13 C 15.552 13 16 12.552 16 12 C 16 11.448 15.552 11 15 11 z',
			'image-size'     => 'M 4 4 C 2.9069372 4 2 4.9069372 2 6 L 2 18 C 2 19.093063 2.9069372 20 4 20 L 20 20 C 21.093063 20 22 19.093063 22 18 L 22 6 C 22 4.9069372 21.093063 4 20 4 L 4 4 z M 4 6 L 20 6 L 20 18 L 4 18 L 4 6 z M 14.5 11 L 11 15 L 8.5 12.5 L 5.7773438 16 L 18.25 16 L 14.5 11 z',
			'comment'        => 'M 16 3 C 12.210938 3 8.765625 4.113281 6.21875 5.976563 C 3.667969 7.835938 2 10.507813 2 13.5 C 2 17.128906 4.472656 20.199219 8 22.050781 L 8 29 L 14.746094 23.9375 C 15.15625 23.96875 15.570313 24 16 24 C 19.789063 24 23.234375 22.886719 25.78125 21.027344 C 28.332031 19.164063 30 16.492188 30 13.5 C 30 10.507813 28.332031 7.835938 25.78125 5.976563 C 23.234375 4.113281 19.789063 3 16 3 Z M 16 5 C 19.390625 5 22.445313 6.015625 24.601563 7.589844 C 26.757813 9.164063 28 11.246094 28 13.5 C 28 15.753906 26.757813 17.835938 24.601563 19.410156 C 22.445313 20.984375 19.390625 22 16 22 C 15.507813 22 15.015625 21.972656 14.523438 21.925781 L 14.140625 21.894531 L 10 25 L 10 20.859375 L 9.421875 20.59375 C 6.070313 19.019531 4 16.386719 4 13.5 C 4 11.246094 5.242188 9.164063 7.398438 7.589844 C 9.554688 6.015625 12.609375 5 16 5 Z ',
		];
	}

	/**
	 * Returns the icon
	 *
	 * @param  [string] $width    [icon width]
	 * @param  [string] $height   [icon height]
	 * @param  [string] $color 	  [icon color]
	 * @param  [string] $icon 	  [icon svg code]
	 * @param  [string] $viewboxX [icon X viewox]
	 * @param  [string] $viewboxY [icon Y viewbox]
	 *
	 * @return [string]           [processed url]
	 */
	public static function getIcon( $width = '16', $height = '16', $color = 'rgba(0,0,0,1)', $icon = '', $viewboxX = '24', $viewboxY = '24' ) {

		if ( array_key_exists($icon, self::icons_defaults()) && !empty(self::icons_defaults()[$icon]) ) {
			return 'url("data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\' width=\''.$width.'\' height=\''.$height.'\' viewBox=\'0 0 '.$viewboxX.' '.$viewboxY.'\' fill=\''.$color.'\'><path d=\''.self::icons_defaults()[$icon].'\'></path></svg>")';
		}

		return '';
	}
}

?>
