<?php

include_once( get_template_directory() 	. '/inc/tgm/class-tgm-plugin-activation.php' );
include_once( get_template_directory() 	. '/inc/tgm/plugins.php' );

/**
 * Block editor layout class
 *
 * @param string $classes
 * @return string
 */
function theretailer_editor_layout_class( $classes ) {
	global $post;

	$screen = get_current_screen();
	if( ! $screen->is_block_editor() )
		return $classes;

	if ( isset( $post ) && get_post_type($post->ID) == 'page' ) {
		$pagetemplate = get_post_meta( $post->ID, '_wp_page_template', true );
		if ( !empty( $pagetemplate ) ) {
			switch ( $pagetemplate ) {
				case 'page-full.php':
					$classes .= ' page-template-full ';
					break;
				case 'page-with_left_sidebar.php':
					$classes .= ' page-template-sidebar ';
					break;
				case 'page-with_sidebar.php':
					$classes .= ' page-template-sidebar ';
					break;
				default:
					$classes .= ' page-template-default ';
					break;
			}
		} else {
			$classes .= ' page-template-default ';
		}
	}

	if ( 'boxed' === GBT_Opt::getOption( 'gb_layout', 'fullscreen' ) ) {
		$classes .= ' page-layout-boxed ';
	}

	if ( isset( $post ) && get_post_type($post->ID) == 'post' ) {
		if( GBT_Opt::getOption( 'post_sidebar', true ) ) {
			$classes .= 'post_layout_with_sidebar';
		}
	}

	return $classes;
}
add_filter( 'admin_body_class', 'theretailer_editor_layout_class' );

/**
 * Reset TGMPA Notices after 1 week
 */
function gbt_reset_tgmpa_notices() {

	$transient_name = 'reset_tgmpa_notices';

	if (false === get_transient($transient_name)) {
		delete_metadata( 'user', null, 'tgmpa_dismissed_notice_' . wp_get_current_user()->user_login, null, true ); // Reset TGMPA Notices
        set_transient($transient_name, NULL, 7 * DAY_IN_SECONDS); // Set transient for 1 week (7 days)
    }

}
add_action( 'admin_init', 'gbt_reset_tgmpa_notices' );

add_filter( 'woocommerce_prevent_automatic_wizard_redirect', '__return_true' );
add_filter( 'woocommerce_enable_setup_wizard', '__return_false' );
