<?php

function theretailer_widgets_init() {

	if ( function_exists('register_sidebar') ) {
		register_sidebar(array(
			'name' => esc_html__( 'Sidebar', 'theretailer' ),
			'id' => 'sidebar',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="widget-title">',
			'after_title' => '</h4>',
		));

		register_sidebar(array(
			'name' => esc_html__( 'Product listing', 'theretailer' ),
			'id' => 'widgets_product_listing',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="widget-title">',
			'after_title' => '</h4>',
		));

		register_sidebar(array(
			'name' => esc_html__( 'Light footer', 'theretailer' ),
			'id' => 'widgets_light_footer',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="widget-title">',
			'after_title' => '</h4>',
		));


		register_sidebar(array(
			'name' => esc_html__( 'Dark footer', 'theretailer' ),
			'id' => 'widgets_dark_footer',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="widget-title">',
			'after_title' => '</h4>',
		));
	}
}
add_action( 'widgets_init', 'theretailer_widgets_init', 99 );

function getbowtied_has_light_footer() {

	if( is_active_sidebar( 'widgets_light_footer' ) ) {

		$light_footer_active = GBT_Opt::getOption( 'light_footer_all_site', true ) ? 'on' : 'off';

		if( is_page() || is_home() || ( TR_WOOCOMMERCE_IS_ACTIVE && is_shop() && !is_search() ) ) {
			$page_id = getbowtied_get_current_page_id();

			if ( get_post_meta( $page_id, 'page_light_footer_meta_box_check', true ) ) {
				$light_footer_active = get_post_meta( $page_id, 'page_light_footer_meta_box_check', true );
			}
		}

		if( 'on' === $light_footer_active ) {
			return true;
		}
	}

	return false;
}

function getbowtied_has_dark_footer() {

	if( is_active_sidebar( 'widgets_dark_footer' ) ) {

		$dark_footer_active = GBT_Opt::getOption( 'dark_footer_all_site', true ) ? 'on' : 'off';

		if( is_page() || is_home() || ( TR_WOOCOMMERCE_IS_ACTIVE && is_shop() && !is_search() ) ) {
			$page_id = getbowtied_get_current_page_id();

			if ( get_post_meta( $page_id, 'page_dark_footer_meta_box_check', true ) ) {
				$dark_footer_active = get_post_meta( $page_id, 'page_dark_footer_meta_box_check', true );
			}
		}

		if( 'on' === $dark_footer_active ) {
			return true;
		}
	}

	return false;
}
