<?php

if ( ! function_exists( 'shiftup_load_page_mobile_header' ) ) {
	/**
	 * Function which loads page template module
	 */
	function shiftup_load_page_mobile_header() {
		// Include mobile header template
		echo apply_filters( 'shiftup_filter_mobile_header_template', shiftup_get_template_part( 'mobile-header', 'templates/mobile-header' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}

	add_action( 'shiftup_action_page_header_template', 'shiftup_load_page_mobile_header' );
}

if ( ! function_exists( 'shiftup_register_mobile_navigation_menus' ) ) {
	/**
	 * Function which registers navigation menus
	 */
	function shiftup_register_mobile_navigation_menus() {
		$navigation_menus = apply_filters( 'shiftup_filter_register_mobile_navigation_menus', array( 'mobile-navigation' => esc_html__( 'Mobile Navigation', 'shiftup' ) ) );

		if ( ! empty( $navigation_menus ) ) {
			register_nav_menus( $navigation_menus );
		}
	}

	add_action( 'shiftup_action_after_include_modules', 'shiftup_register_mobile_navigation_menus' );
}
