<?php
/**
 * Customizer settings for this theme.
 * @since Selo 1.0
 */
if (!class_exists('selo_Customize')) {
    /**
     * CUSTOMIZER SETTINGS
     */
    class selo_Customize
    {

        /**
         * Register customizer options.
         *
         * @param WP_Customize_Manager $wp_customize Theme Customizer object.
         */
        public static function register($wp_customize)
        {
            /* ========================================================================= */
            /*
             * COLORS
             */

            // Primary color
            $wp_customize->add_setting('pr_color', array(
                'default' => '#6664e4',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'pr_color', array(
                'section' => 'colors',
                'label' => esc_html__('Primary color', 'selo'),
                'description' => esc_html__('Sets main accent color.', 'selo'),
            )));


            // Primary links hover color
            $wp_customize->add_setting('pr_links_h_color', array(
                'default' => '#0f110f',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'pr_links_h_color', array(
                'section' => 'colors',
                'label' => esc_html__('Primary hover color', 'selo'),
                'description' => esc_html__('Sets link hover color.', 'selo'),
            )));


            // Primary background color
            $wp_customize->add_setting('pr_bg_color', array(
                'default' => '#e5e6f6',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'pr_bg_color', array(
                'section' => 'colors',
                'label' => esc_html__('Primary background color', 'selo'),
                'description' => esc_html__("Changes accent background color.", 'selo'),
            )));


            // Header background color
            $wp_customize->add_setting('h_bg_color', array(
                'default' => '#f5f4fe',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'h_bg_color', array(
                'section' => 'colors',
                'label' => esc_html__('Header background color', 'selo'),
                'description' => esc_html__("Changes header background color. If there is no changing of the header color that means the current page uses Elementor builder’s header instead of the site's global, so you need to change the color on the page.", 'selo'),
            )));


            // Footer background color
            $wp_customize->add_setting('f_bg_color', array(
                'default' => '#f5f5f6',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'f_bg_color', array(
                'section' => 'colors',
                'label' => esc_html__('Footer background color', 'selo'),
                'description' => esc_html__("Changes footer background color.", 'selo'),
            )));


            // Primary dark color
            $wp_customize->add_setting('pr_d_color', array(
                'default' => '#0f110f',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'pr_d_color', array(
                'section' => 'colors',
                'label' => esc_html__('Primary dark color', 'selo'),
                'description' => esc_html__('Sets text color in paragraphs.', 'selo'),
            )));


            // h1 title color
            $wp_customize->add_setting('title_color', array(
                'default' => '#0f110f',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'title_color', array(
                'section' => 'colors',
                'label' => esc_html__('Title color', 'selo'),
                'description' => esc_html__('Sets color for titles.', 'selo'),
            )));


            // Footer widget title color
            $wp_customize->add_setting('fw_title_color', array(
                'default' => '#0f110f',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'fw_title_color', array(
                'section' => 'colors',
                'label' => esc_html__('Footer widget title color', 'selo'),
            )));


            // Button background color
            $wp_customize->add_setting('btn_bg_color', array(
                'default' => '#6664e4',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'btn_bg_color', array(
                'section' => 'colors',
                'label' => esc_html__('Button background color', 'selo'),
            )));


            // Button hover color
            $wp_customize->add_setting('btn_h_color', array(
                'default' => '#0f110f',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'btn_h_color', array(
                'section' => 'colors',
                'label' => esc_html__('Button hover color', 'selo'),
            )));


            // Text selection background color
            $wp_customize->add_setting('txt_select_bg_color', array(
                'default' => '#e5e6ff',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'txt_select_bg_color', array(
                'section' => 'colors',
                'label' => esc_html__('Text selection background color', 'selo'),
                'description' => esc_html__('Changes text selection background color. Try to select text on a page.', 'selo'),
            )));
            

            /* end COLORS */
            /* ========================================================================= */
            /*
             * HEADER
             */

            $wp_customize->add_section('header', array(
                'title' => esc_html__('Header', 'selo')
            ));


            // Enable CTA button in the header
            $wp_customize->add_setting('h_cta_btn_switcher', array(
                'default' => false,
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('h_cta_btn_switcher', array(
                'section' => 'header',
                'label' => esc_html__('Enable CTA button (call-to-action)', 'selo'),
                'type' => 'checkbox'
            ));


            // Header CTA button link
            $wp_customize->add_setting('h_cta_btn_link', array(
                'default' => esc_html__('/contact-us', 'selo'),
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('h_cta_btn_link', array(
                'section' => 'header',
                'label' => esc_html__('CTA button link:', 'selo'),
                'type' => 'text'
            ));


            // Header CTA button text
            $wp_customize->add_setting('h_cta_btn_txt', array(
                'default' => esc_html__('Buy Now', 'selo'),
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('h_cta_btn_txt', array(
                'section' => 'header',
                'label' => esc_html__('CTA button text:', 'selo'),
                'type' => 'text'
            ));


            // Enable opening of CTA link in the new tab
            $wp_customize->add_setting('h_cta_link_switcher', array(
                'default' => true,
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('h_cta_link_switcher', array(
                'section' => 'header',
                'label' => esc_html__('Open CTA button link in the new tab', 'selo'),
                'type' => 'checkbox'
            ));


            // Sticky header
            $wp_customize->add_setting('sticky_header_switcher', array(
                'default' => false,
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('sticky_header_switcher', array(
                'section' => 'header',
                'label' => esc_html__('Sticky header', 'selo'),
                'type' => 'checkbox'
            ));


            // Switcher for enable Close mobile menu after click
            $wp_customize->add_setting('h_close_mobile_menu', array(
                'default' => false,
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('h_close_mobile_menu', array(
                'section' => 'header',
                'label' => esc_html__('Close mobile menu after click', 'selo'),
                'type' => 'checkbox'
            ));


            // Change logo height
            $wp_customize->add_setting('logo_height', array(
                'default' => '40',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('logo_height', array(
                'section' => 'header',
                'label' => esc_html__('Logo height:', 'selo'),
                'type' => 'number'
            ));


            /* end HEADER */
            /* ========================================================================= */
            /*
             * FOOTER
             */

            $wp_customize->add_section('footer', array(
                'title' => esc_html__('Footer', 'selo')
            ));

            // Switcher for Copyright text
            $wp_customize->add_setting('copyright_text_switcher', array(
                'default' => false,
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('copyright_text_switcher', array(
                'section' => 'footer',
                'label' => esc_html__('Disable "Copyright" text before the year', 'selo'),
                'type' => 'checkbox'
            ));

            // Custom copyright
            $wp_customize->add_setting('copyright_text', array(
                'default' => '',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('copyright_text', array(
                'section' => 'footer',
                'label' => esc_html__('Custom copyright text.', 'selo'),
                'description' => esc_html__('Leave blank to use default copyright.', 'selo'),
                'type' => 'text'
            ));


            /* end FOOTER */
            /* ========================================================================= */
            /*
             * TWEAKS
             */

            $wp_customize->add_section('tweaks', array(
                'title' => esc_html__('Tweaks', 'selo')
            ));


            // Disable post category meta text
            $wp_customize->add_setting('meta_cat_switcher', array(
                'default' => false,
                'transport' => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('meta_cat_switcher', array(
                'section' => 'tweaks',
                'label' => esc_html__('Disable post category meta text', 'selo'),
                'type' => 'checkbox'
            ));


            // Disable date meta text
            $wp_customize->add_setting('meta_date_switcher', array(
                'default' => false,
                'transport' => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('meta_date_switcher', array(
                'section' => 'tweaks',
                'label' => esc_html__('Disable date meta text', 'selo'),
                'type' => 'checkbox'
            ));


            // Disable post author meta text
            $wp_customize->add_setting('meta_author_switcher', array(
                'default' => false,
                'transport' => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('meta_author_switcher', array(
                'section' => 'tweaks',
                'label' => esc_html__('Disable post author meta text', 'selo'),
                'type' => 'checkbox'
            ));


            // Disable post comments meta text
            $wp_customize->add_setting('meta_comm_switcher', array(
                'default' => false,
                'transport' => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('meta_comm_switcher', array(
                'section' => 'tweaks',
                'label' => esc_html__('Disable post comments meta text', 'selo'),
                'type' => 'checkbox'
            ));


            // Disable icon before title
            $wp_customize->add_setting('icon_before_title_switcher', array(
                'default' => false,
                'transport' => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('icon_before_title_switcher', array(
                'section' => 'tweaks',
                'label' => esc_html__('Disable icon before title', 'selo'),
                'type' => 'checkbox'
            ));


            /* end TWEAKS */
            /* ========================================================================= */


            /* -----------------------------*/
            /* end Customize Settings */
            /* -----------------------------*/
        }
    }


    // Setup the Theme Customizer settings and controls.
    add_action('customize_register', array('selo_Customize', 'register'));

}