<?php
add_action( 'widgets_init', 'tie_categort_posts_widget' );
function tie_categort_posts_widget() {
	register_widget( 'tie_categort_posts' );
}
class tie_categort_posts extends WP_Widget {

	public function __construct(){
		$widget_ops 	= array( 'classname' => 'categort-posts' );
		$control_ops 	= array( 'width' => 250, 'height' => 350, 'id_base' => 'categort-posts-widget' );
		parent::__construct( 'categort-posts-widget', THEME_NAME .' - '.__( "Category Posts" , 'tie' ) , $widget_ops, $control_ops );
	}

	public function widget( $args, $instance ) {
		extract( $args );

		$title      = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		$no_of_posts 	= $instance['no_of_posts'];
		$cats_id 		= $instance['cats_id'];
		$thumb 			= $instance['thumb'];

		echo $before_widget;
			echo $before_title;
			echo $title ; ?>
		<?php echo $after_title; ?>
				<ul>
					<?php tie_last_posts_cat($no_of_posts , $thumb , $cats_id)?>
				</ul>
		<div class="clear"></div>
	<?php
		echo $after_widget;
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title']       = ! empty( $new_instance['title'] )       ? $new_instance['title'] : false;
		$instance['no_of_posts'] = ! empty( $new_instance['no_of_posts'] ) ? $new_instance['no_of_posts'] : false;
		$instance['cats_id']     = ! empty( $new_instance['cats_id'] )     ? implode(',' , $new_instance['cats_id'] ) : false;
		$instance['thumb']       = ! empty( $new_instance['thumb'] )       ? $new_instance['thumb'] : false;
		return $instance;
	}

	public function form( $instance ) {
		$defaults = array( 'title' =>__( 'Category Posts' , 'tie'), 'no_of_posts' => '5' , 'cats_id' => '1' , 'thumb' => 'true' );
		$instance = wp_parse_args( (array) $instance, $defaults );

		$categories_obj = get_categories();
		$categories 	= array();

		foreach ($categories_obj as $pn_cat) {
			$categories[$pn_cat->cat_ID] = $pn_cat->cat_name;
		}
		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' , 'tie') ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'no_of_posts' ); ?>"><?php _e( 'Number of posts to show:' , 'tie') ?></label>
			<input id="<?php echo $this->get_field_id( 'no_of_posts' ); ?>" name="<?php echo $this->get_field_name( 'no_of_posts' ); ?>" value="<?php echo $instance['no_of_posts']; ?>" type="text" size="3" />
		</p>
		<p>
			<?php $cats_id = explode ( ',' , $instance['cats_id'] ) ; ?>
			<label for="<?php echo $this->get_field_id( 'cats_id' ); ?>"><?php _e( 'Category:' , 'tie') ?></label>
			<select multiple="multiple" id="<?php echo $this->get_field_id( 'cats_id' ); ?>[]" name="<?php echo $this->get_field_name( 'cats_id' ); ?>[]">
				<?php foreach ($categories as $key => $option) { ?>
				<option value="<?php echo $key ?>" <?php if ( in_array( $key , $cats_id ) ) { echo ' selected="selected"' ; } ?>><?php echo $option; ?></option>
				<?php } ?>
			</select>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'thumb' ); ?>"><?php _e( 'Display Thumbnails :' , 'tie') ?></label>
			<input id="<?php echo $this->get_field_id( 'thumb' ); ?>" name="<?php echo $this->get_field_name( 'thumb' ); ?>" value="true" <?php if( $instance['thumb'] ) echo 'checked="checked"'; ?> type="checkbox" />
		</p>

	<?php
	}
}
?>
