<?php
/**
 * Load Insight Framework.
 *
 * @since 0.9.4
 */

$theme = wp_get_theme();

if ( ! empty( $theme['Template'] ) ) {
	$theme = wp_get_theme( $theme['Template'] );
}

define( 'INSIGHT_SITE_HOME', esc_url( get_home_url( '/' ) ) );
define( 'INSIGHT_THEME_NAME', $theme['Name'] );
define( 'INSIGHT_THEME_SLUG', $theme['Template'] );
define( 'INSIGHT_THEME_VERSION', $theme['Version'] );
define( 'INSIGHT_THEME_DIR', get_template_directory() );
define( 'INSIGHT_THEME_URI', get_template_directory_uri() );
define( 'INSIGHT_CHILD_THEME_URI', get_stylesheet_directory_uri() );
define( 'INSIGHT_CHILD_THEME_DIR', get_stylesheet_directory() );
define( 'INSIGHT_IS_RTL', is_rtl() ? true : false );

if ( ! defined( 'INSIGHT_DS' ) ) {
	define( 'INSIGHT_DS', DIRECTORY_SEPARATOR );
}

require_once( INSIGHT_THEME_DIR . '/framework/class-debug.php' );
require_once( INSIGHT_THEME_DIR . '/framework/class-customize.php' );
require_once( INSIGHT_THEME_DIR . '/framework/class-enqueue.php' );
require_once( INSIGHT_THEME_DIR . '/framework/class-extras.php' );
require_once( INSIGHT_THEME_DIR . '/framework/class-fonticon.php' );
require_once( INSIGHT_THEME_DIR . '/framework/class-functions.php' );
require_once( INSIGHT_THEME_DIR . '/framework/class-helper.php' );
require_once( INSIGHT_THEME_DIR . '/framework/class-import.php' );
require_once( INSIGHT_THEME_DIR . '/framework/class-init.php' );
require_once( INSIGHT_THEME_DIR . '/framework/class-kirki.php' );
require_once( INSIGHT_THEME_DIR . '/framework/class-metabox.php' );
require_once( INSIGHT_THEME_DIR . '/framework/class-plugins.php' );
require_once( INSIGHT_THEME_DIR . '/framework/class-static.php' );
require_once( INSIGHT_THEME_DIR . '/framework/class-templates.php' );
require_once( INSIGHT_THEME_DIR . '/framework/class-widget.php' );
require_once( INSIGHT_THEME_DIR . '/framework/class-posttypes.php' );
require_once( INSIGHT_THEME_DIR . '/framework/class-woo.php' );

require_once( INSIGHT_THEME_DIR . '/framework/tgm-plugin-activation.php' );
require_once( INSIGHT_THEME_DIR . '/framework/tgm-plugin-registration.php' );

require_once( INSIGHT_THEME_DIR . '/framework/wp-kses.php' );

// Extend VC
if ( class_exists( 'WPBakeryVisualComposerAbstract' ) ) {
	require_once( INSIGHT_THEME_DIR . '/vc-extend/index.php' );
}

/**
 * Init the theme
 *
 * @since 0.9.4
 */
Insight_Init::instance();

/**
 * Admin notice waning minimum plugin version required.
 *
 * @param $plugin_name
 * @param $plugin_version
 */
function organik_notice_required_plugin_version( $plugin_name, $plugin_version ) {
	if ( isset( $_GET['activate'] ) ) {
		unset( $_GET['activate'] );
	}

	$message = sprintf(
		esc_html__( '%1$s requires %2$s plugin version %3$s or greater!', 'organik' ),
		'<strong>' . INSIGHT_THEME_NAME . '</strong>',
		'<strong>' . $plugin_name . '</strong>',
		$plugin_version
	);

	printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
}

/**
 * Allow to remove method for an hook when, it's a class method used and class don't have variable, but you know the class name :)
 *
 * @see https://github.com/herewithme/wp-filters-extras/blob/master/wp-filters-extras.php
 *
 * @param string $hook_name   The action hook to which the function to be removed is hooked.
 * @param string $class_name  The class name of contain function which should be removed.
 * @param string $method_name The name of the function which should be removed.
 * @param int    $priority    Optional. The priority of the function. Default 10.
 *
 * @return bool
 */
function organik_remove_filters_for_anonymous_class( $hook_name = '', $class_name = '', $method_name = '', $priority = 10 ) {
	global $wp_filter;

	// Take only filters on right hook name and priority
	if ( ! isset( $wp_filter[ $hook_name ][ $priority ] ) || ! is_array( $wp_filter[ $hook_name ][ $priority ] ) ) {
		return false;
	}

	// Loop on filters registered
	foreach ( (array) $wp_filter[ $hook_name ][ $priority ] as $unique_id => $filter_array ) {
		// Test if filter is an array ! (always for class/method)
		if ( isset( $filter_array['function'] ) && is_array( $filter_array['function'] ) ) {
			// Test if object is a class, class and method is equal to param !
			if ( is_object( $filter_array['function'][0] ) && get_class( $filter_array['function'][0] ) && get_class( $filter_array['function'][0] ) == $class_name && $filter_array['function'][1] == $method_name ) {
				// Test for WordPress >= 4.7 WP_Hook class (https://make.wordpress.org/core/2016/09/08/wp_hook-next-generation-actions-and-filters/)
				if ( is_a( $wp_filter[ $hook_name ], 'WP_Hook' ) ) {
					unset( $wp_filter[ $hook_name ]->callbacks[ $priority ][ $unique_id ] );
				} else {
					unset( $wp_filter[ $hook_name ][ $priority ][ $unique_id ] );
				}
			}
		}

	}

	return false;
}
