<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Plugin installation and activation for WordPress themes
 *
 * @package InsightFramework
 * @since   0.9.7
 */
class Insight_Register_Plugins {

	const GOOGLE_DRIVER_API = 'AIzaSyDXOs0Bxx-uBEA4fH4fzgoHtl64g0RWv-g';

	/**
	 * Insight_Register_Plugins constructor.
	 */
	public function __construct() {
		add_filter( 'insight_core_tgm_plugins', array( $this, 'register_required_plugins' ) );
	}

	public function register_required_plugins() {
		/*
		 * Array of plugin arrays. Required keys are name and slug.
		 * If the source is NOT from the .org repo, then source is also required.
		 */
		$plugins = array(
			array(
				'name'     => esc_html__( 'Insight Core', 'tm-organik' ),
				'slug'     => 'insight-core',
				'source'   => $this->get_plugin_google_driver_url( '18Ed9yJ6c8uh70wokhdZg4rxBxFw3osKR' ),
				'version'  => '2.7.4',
				'required' => true,
			),
			array(
				'name'     => esc_html__( 'WPBakery Page Builder', 'tm-organik' ),
				'slug'     => 'js_composer',
				'source'   => $this->get_plugin_google_driver_url( '1PIn948Dv0Cfo1F0FMXFCZM9zp2g7-Aep' ),
				'version'  => '8.6.1',
				'required' => true,
			),
			array(
				'name'     => esc_html__( 'Revolution Slider', 'tm-organik' ),
				'slug'     => 'revslider',
				'source'   => $this->get_plugin_google_driver_url( '1O_lutNVt_E50b_iqWI1EuhCUpXAMNTUs' ),
				'version'  => '6.7.36',
				'required' => true,
			),
			array(
				'name'     => esc_html__( 'WPBakery Page Builder (Visual Composer) Clipboard', 'tm-organik' ),
				'slug'     => 'vc_clipboard',
				'source'   => $this->get_plugin_google_driver_url( '1Ut4Y4ZsOl9xBXp-bFzVLWTlbpuELhFKy' ),
				'version'  => '5.0.6',
				'required' => false,
			),
			array(
				'name'     => esc_html__( 'WooCommerce', 'tm-organik' ),
				'slug'     => 'woocommerce',
				'required' => true,
			),
			array(
				'name'     => esc_html__( 'WPC Smart Compare', 'tm-organik' ),
				'slug'     => 'woo-smart-compare',
				'required' => false,
			),
			array(
				'name'     => esc_html__( 'WPC Smart Wishlist', 'tm-organik' ),
				'slug'     => 'woo-smart-wishlist',
				'required' => false,
			),
			array(
				'name'     => esc_html__( 'WPC Smart Quick View', 'tm-organik' ),
				'slug'     => 'woo-smart-quick-view',
				'required' => false,
			),
			array(
				'name'     => esc_html__( 'WPC Product Bundles', 'tm-organik' ),
				'slug'     => 'woo-product-bundle',
				'required' => false,
			),
			array(
				'name'     => esc_html__( 'MailChimp for WordPress', 'tm-organik' ),
				'slug'     => 'mailchimp-for-wp',
				'required' => false,
			),
			array(
				'name'     => esc_html__( 'Contact Form 7', 'tm-organik' ),
				'slug'     => 'contact-form-7',
				'required' => false,
			),
		);

		return $plugins;
	}

	public function get_plugin_google_driver_url( $file_id ) {
		return "https://www.googleapis.com/drive/v3/files/{$file_id}?alt=media&key=" . self::GOOGLE_DRIVER_API;
	}
}
