<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Initial OneClick import for this theme
 *
 * @package   InsightFramework
 */
class Insight_Import {

	/**
	 * The constructor.
	 */
	public function __construct() {
		// Import Demo
		add_filter( 'insight_core_import_demos', array( $this, 'import_demos' ) );
		add_filter( 'insight_core_import_generate_thumb', '__return_true' );
		add_filter( 'insight_core_import_delete_exist_posts', '__return_true' );

		// Import package url
		add_filter( 'insight_core_import_package_url', array( $this, 'import_package_url' ) );
	}

	/**
	 * Import Demo
	 *
	 * @since 0.9
	 */
	public function import_demos() {
		return array(
			'organik' => array(
				'screenshot' => INSIGHT_THEME_URI . '/screenshot.jpg',
				'name'       => 'Organik',
				'url'        => 'https://www.dropbox.com/s/8rkkyhaaz88cvaa/tm-organik-insightcore01-3.0.5.zip?dl=1',
			),
		);
	}

}
