<?php
defined( 'ABSPATH' ) || exit;

/**
 * Debugging functions for developers.
 */
if ( ! class_exists( 'Insight_Debug' ) ) {
	class Insight_Debug {
		public static function clear_log() {
			if ( file_exists( WP_CONTENT_DIR . '/debug.log' ) ) {
				unlink( WP_CONTENT_DIR . '/debug.log' );
			}
		}

		/**
		 * @param mixed $log Anything to write to log.
		 *
		 * Make sure WP_DEBUG_LOG = true.
		 */
		public static function write_log( $log ) {
			if ( true === WP_DEBUG ) {
				if ( is_array( $log ) || is_object( $log ) ) {
					error_log( print_r( $log, true ) );
				} else {
					error_log( $log );
				}
			}
		}
	}

	new Insight_Debug();
}
