<?php

if ( ! function_exists( 'marra_load_page_mobile_header' ) ) {
	/**
	 * Function which loads page template module
	 */
	function marra_load_page_mobile_header() {
		// Include mobile header template
		echo apply_filters( 'marra_filter_mobile_header_template', marra_get_template_part( 'mobile-header', 'templates/mobile-header' ) );
	}
	
	add_action( 'marra_action_page_header_template', 'marra_load_page_mobile_header' );
}

if ( ! function_exists( 'marra_register_mobile_navigation_menus' ) ) {
	/**
	 * Function which registers navigation menus
	 */
	function marra_register_mobile_navigation_menus() {
		$navigation_menus = apply_filters( 'marra_filter_register_mobile_navigation_menus', array( 'mobile-navigation' => esc_html__( 'Mobile Navigation', 'marra' ) ) );
		
		if ( ! empty( $navigation_menus ) ) {
			register_nav_menus( $navigation_menus );
		}
	}
	
	add_action( 'marra_action_after_include_modules', 'marra_register_mobile_navigation_menus' );
}