<div id="qodef-page-comments">
	<?php if ( have_comments() ) {
		$comments_number = get_comments_number();
		?>
		<div id="qodef-page-comments-list" class="qodef-m">
			<h3 class="qodef-m-title"><?php echo sprintf( _n( '%s Comment', '%s Comments', $comments_number, 'marra' ), $comments_number ); ?></h3>
			<ul class="qodef-m-comments">
				<?php wp_list_comments( array_unique( array_merge( array( 'callback' => 'marra_get_comments_list_template' ), apply_filters( 'marra_filter_comments_list_template_callback', array() ) ) ) ); ?>
			</ul>

			<?php if ( get_comment_pages_count() > 1 ) { ?>
				<div class="qodef-m-pagination qodef--wp">
					<?php the_comments_pagination( array(
						'prev_text'          => marra_get_icon( 'arrow_carrot-left', 'elegant-icons', '&blacktriangleleft; '.esc_html__( 'Prev', 'marra' ) ),
						'next_text'          => marra_get_icon( 'arrow_carrot-right', 'elegant-icons', esc_html__( 'Next', 'marra' ).'  &blacktriangleright;' ),
					) ); ?>
				</div>
			<?php } ?>
		</div>
	<?php } ?>
	<?php if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) { ?>
		<p class="qodef-page-comments-not-found"><?php esc_html_e( 'Comments are closed.', 'marra' ); ?></p>
	<?php } ?>
	<div id="qodef-page-comments-form">
        <?php comment_form( marra_get_comment_form_args() ); ?>
	</div>
</div>