<?php

if ( ! function_exists( 'marra_set_404_page_inner_classes' ) ) {
	/**
	 * Function that return classes for the page inner div from header.php
	 *
	 * @param string $classes
	 *
	 * @return string
	 */
	function marra_set_404_page_inner_classes( $classes ) {
		
		if ( is_404() ) {
			$classes = 'qodef-content-full-width';
		}
		
		return $classes;
	}
	
	add_filter( 'marra_filter_page_inner_classes', 'marra_set_404_page_inner_classes' );
}

if ( ! function_exists( 'marra_get_404_page_parameters' ) ) {
	/**
	 * Function that set 404 page area content parameters
	 */
	function marra_get_404_page_parameters() {
		
		$params = array(
			'mark'        => esc_html__( '404', 'marra' ),
			'title'       => esc_html__( 'Page not found', 'marra' ),
			'text'        => esc_html__( 'Oops! The page you are looking for does not exist. It might have been moved or deleted.', 'marra' ),
			'button_text' => esc_html__( 'Back to home', 'marra' ),
		);
		
		return apply_filters( 'marra_filter_404_page_template_params', $params );
	}
}
