# PureCustomizer Changelog

## Version 1.0.0 (2025-01-31)

### Added
- Complete fork of Kirki Framework 5.1.0
- 100% backward compatibility layer
- Migration helper for seamless transition from Kirki
- PureCustomizer branding and documentation
- Enhanced error handling for PHP 8+ compatibility
- Migration notification system
- Comprehensive installation guide

### Changed
- Plugin name: "Kirki Customizer Framework" → "PureCustomizer Framework"
- Text domain: "kirki" → "pure-customizer"
- Author: "Themeum" → "Listeo Team"
- Plugin URI: Updated to Listeo domain
- Version numbering: Started fresh at 1.0.0

### Maintained
- All Kirki classes and methods (100% compatibility)
- All field types and controls
- All existing constants (KIRKI_* versions still available)
- All configuration options
- All CSS output functionality
- All PostMessage functionality
- Google Fonts integration
- All module functionality

### Technical Changes Made
- Renamed main file: `kirki.php` → `pure-customizer.php`
- Added compatibility layer: `inc/kirki-compatibility.php`
- Added migration helper: `inc/migration-helper.php`
- Updated composer.json with new package name
- Updated readme.txt with new plugin information
- Added comprehensive documentation (README.md, INSTALLATION.md)
- Modified upgrade notifications to use new branding

### Files Modified
```
pure-customizer.php (main plugin file)
readme.txt
composer.json
upgrade-notifications.php
inc/kirki-compatibility.php (new)
inc/migration-helper.php (new)
README.md (new)
INSTALLATION.md (new)
CHANGELOG.md (new)
```

### Constants Added
```php
PURE_CUSTOMIZER_PLUGIN_FILE
PURE_CUSTOMIZER_VERSION
PURE_CUSTOMIZER_PLUGIN_DIR
PURE_CUSTOMIZER_PLUGIN_URL
```

### Classes Added
```php
PureCustomizer (extends Kirki for compatibility)
PureCustomizer_Migration (handles migration from Kirki)
```

### Backward Compatibility
- All existing `Kirki::` method calls work unchanged
- All existing configuration arrays work unchanged
- All existing field definitions work unchanged
- All existing theme integration works unchanged
- All settings and customizations are preserved during migration

## Known Issues
- None at release

## Migration Notes
- Automatic migration from Kirki to PureCustomizer
- All existing customizer settings preserved
- No theme code changes required
- Safe to deactivate Kirki after installing PureCustomizer

## Future Plans
- Regular maintenance updates
- PHP 8.2+ compatibility improvements
- Security updates as needed
- Performance optimizations
- New field types as requested by community
