<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.7.0
 */

defined( 'ABSPATH' ) || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}

wp_enqueue_script( array(
	'jquery',
	'slick',
) );

global $product;

$meta = get_post_meta( get_the_ID() );
// $product_style = lifeline_get( $meta, 'product_style' );
// $product_style = $product_style[0] == 'style-1' ? 'style1' : 'style2';

$product_style = 'style2';

$columns           = apply_filters( 'woocommerce_product_thumbnails_columns', 3 );
$post_thumbnail_id = $product->get_image_id();
$wrapper_classes   = apply_filters(
	'woocommerce_single_product_image_gallery_classes',
	array(
		'woocommerce-product-gallery',
		'woocommerce-product-gallery--' . ( $product->get_image_id() ? 'with-images' : 'without-images' ),
		'woocommerce-product-gallery--columns-' . absint( $columns ),
		'images',
		$product_style,
	)
);
$gallery = array_merge( $product->get_gallery_image_ids(), [ $post_thumbnail_id ] );
?>
<div class="<?php echo esc_attr( implode( ' ', array_map( 'sanitize_html_class', $wrapper_classes ) ) ); ?>" data-columns="<?php echo esc_attr( $columns ); ?>" style="opacity: 0; transition: opacity .25s ease-in-out;">
	<?php if ( ! empty( $gallery ) && count( $gallery ) > 1 ) : ?>
		<div class="product-gallery-for-wrap">
			<div class="product-gallery-for">
			<?php foreach( $gallery as $gall ) : ?>
				<?php echo wp_get_attachment_image( $gall, 'lifeline_448x557' ); ?>
			<?php endforeach; ?>
			</div>
		</div>
		<div class="product-gallery-nav-wrap">
			<div class="product-gallery-nav">
				<?php foreach( $gallery as $gall ) : ?>
					<?php echo wp_get_attachment_image( $gall, 'lifeline_110x110' ); ?>
				<?php endforeach; ?>
			</div>
		</div>
	<?php else: ?>
		<figure class="woocommerce-product-gallery__wrapper">
			<?php echo wp_get_attachment_image( $post_thumbnail_id, 'lifeline_448x557' ); ?>
		</figure>
	<?php endif; ?>
</div>
