<?php $opt = lifeline()->options(); ?>

<div class="lif-team style1">
    <div class="row post-listing">
        <?php while ( have_posts() ) : 
            the_post();    
        ?>
            <div class="col-lg-12">
                <div class="team-item">
                    <div class="row align-items-center">
                        <div class="col-sm-12 col-md-4">
                            <div class="team-media">
                                <figure class="mb-0">
                                    <?php if (class_exists('Lifeline_Resizer')): 
										$img_obj = new lifeline_Resizer();	
									?>
                                        <?php echo wp_kses_post($img_obj->lifeline_resize(wp_get_attachment_url(get_post_thumbnail_id(get_the_ID()), 'full'), 600, 600, true)); ?>
                                    <?php else: ?>
                                        <?php the_post_thumbnail('full'); ?>
                                    <?php endif; ?>
                                </figure>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-8">
                            <div class="team-content">
							<h3><a href="<?php the_permalink(); ?>" title=""><?php echo wp_trim_words( get_the_title(), lifeline_get( $opt, 'title_character_limit', 5 ), '' ); ?></a></h3>
	                         <p><?php echo wp_trim_words( get_the_excerpt(), lifeline_get( $opt, 'character_limit', 15 ), '' ); ?></p>
								<?php
									$meta = lifeline()->meta( get_the_ID() );
									$twitter_name = lifeline_get( $meta,'twitter_name' );
									$twitter_link = lifeline_get( $meta,'twitter_url' );
                                    $phone = lifeline_get( $meta, 'phone' );
                                    $email = lifeline_get( $meta, 'email' );
                                ?>
                                <div class="team-meta">
                                    <div class="team-meat-item">
                                        <i class="fas fa-phone-volume"></i>
                                        <span> <?php echo esc_html__( $phone, 'lifeline' ) ?> </span>
                                    </div>
                                    <div class="team-meat-item">
                                        <i class="fas fa-envelope"></i>
                                        <span> <?php echo esc_html__( $email, 'lifeline' ) ?> </span>
                                    </div>
                                </div>
								<?php if ( $twitter_name != '' ) : ?>
									<span>
										<a href="<?php echo esc_url( $twitter_link ) ?>">
											<i class="fab fa-twitter"></i>
										<?php echo esc_html__( $twitter_name,'lifeline' ); ?>
										</a>
									</span>
								<?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endwhile;  ?>
    </div>
</div>
<div class="loadmore-wrap" style="margin:auto;">
    <div id="loadMore"><?php next_posts_link( 'LOAD MORE' ); ?></div>
</div>