<?php
$opt         = lifeline()->options();
$title_limit = lifeline_get( $opt, 'services_list_title_character_limit', '15' );
$desc_limit  = lifeline_get( $opt, 'services_list_character_limit', '15' );

while ( have_posts() ) {
	the_post();
	$meta = lifeline()->meta( get_the_ID() );
	?>
	<div class="col-md-12 col-sm-12 col-lg-12">
		<div class="service-wrap3 w-100">
			<div class="service-box align-items-center mb-30 rounded d-flex overflow-hidden">
				<div class="service-thumb position-relative">
					<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
						<?php the_post_thumbnail( 'lifeline_526x430', array( 'class' => 'img-fluid w-100' ) ); ?>
					</a>
					<?php if ( lifeline_get( $meta, 'icon_select_field' ) ) : ?>
						<span class="d-block text-theme position-absolute rounded-circle text-center">
							<i class="<?php echo lifeline_get( $meta, 'icon_select_field' ); ?>"></i>
						</span>
					<?php endif; ?>
				</div>
				<div class="service-info">
					<span class="text-theme d-block"><?php echo esc_html( lifeline_get( $meta, 'tag_line' ) ); ?></span>
					<h3 class="mb-0 font-weight-semibold text-dark"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php echo wp_trim_words( get_the_title(), $title_limit, '' ); ?></a></h3>
					<p class="mb-0"><?php echo wp_trim_words( get_the_content(), $desc_limit, '' ); ?></p>
				</div>
			</div>
		</div>
	</div>
	<?php
}
lifeline_the_pagination();
