<?php
$opt         = lifeline()->options();
$title_limit = lifeline_get( $opt, 'services_list_title_character_limit', '15' );
$cols        = lifeline_get( $opt, 'services_list_column', '4' );
$class       = array(
	'col-sm-12',
	"col-md-{$cols}",
	"col-md-{$cols}",
);
while ( have_posts() ) {
	the_post();
	$meta = lifeline()->meta( get_the_ID() );
	?>
	<div class="<?php echo implode( ' ', $class ); ?>">
		<div class="w-100 position-relative text-center">
			<div class="service-box3 mt-30 w-100">
				<?php the_post_thumbnail( 'lifeline_526x430', array( 'class' => 'img-fluid w-100' ) ); ?>
				<div class="service-info3 rounded position-relative">
					<?php if ( lifeline_get( $meta, 'icon_svg' ) ) : ?>
						<i class="d-inline-block position-absolute rounded-circle">
							<?php lifeline_svg_print( lifeline_get( $meta, 'icon_svg.url' ) ); ?>
						</i>
					<?php endif; ?>
					<h3 class="mb-0 font-weight-semibold text-dark"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php echo wp_trim_words( get_the_title(), $title_limit, '' ); ?></a></h3>
					<p class="mb-0"><?php echo esc_html( lifeline_get( $meta, 'tag_line' ) ); ?></p>
				</div>
			</div>
		</div>
	</div>
	<?php
}
lifeline_the_pagination();
