<?php
$opt         = lifeline()->options();
$title_limit = lifeline_get( $opt, 'services_list_title_character_limit', '15' );
$desc_limit  = lifeline_get( $opt, 'services_list_character_limit', '15' );
$cols        = lifeline_get( $opt, 'services_list_column', '4' );

$class = array(
	'col-sm-6',
	"col-md-{$cols}",
	"col-md-{$cols}",
);
while ( have_posts() ) {
	the_post();
	$meta = lifeline()->meta();
	?>
	<div class="<?php echo implode( ' ', $class ); ?>">
		<div class="service-wrap2 position-relative style2 text-center">
			<div class="service-box mt-30 w-100 rounded">
				<i class="d-inline-block <?php echo lifeline_get( $meta, 'icon_select_field' ); ?>"></i>
				<div class="service-info">
					<h3 class="mb-0 font-weight-semibold text-theme">
						<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php echo wp_trim_words( get_the_title(), $title_limit, '' ); ?></a></h3>
					<p class="mb-0"><?php echo wp_trim_words( get_the_content(), $desc_limit, '' ); ?></p>
				</div>
			</div>
		</div>
	</div>
	<?php
}
lifeline_the_pagination();
