<?php
/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       1.0.0
 */

$options = lifeline()->options();
$bg      = lifeline_get( $options, 'singup_box_bg.background-image' );
$form_id = md5( 'lifelin2' );
?>
<div id="signup" class="lifeline-forms-builder popup-wrap position-fixed modal fade" tabindex="-1" role="dialog">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-body">
				<div class="login-form popup-form position-absolute center-content overflow-hidden w-100">
					<button type="button" class="close-btn text-theme position-absolute close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true"><i class="fas fa-times bg-white d-block text-center"></i></span>
					</button>
					<?php echo ( lifeline_get( $options, 'signup_form_title' ) ) ? '<strong class="text-white font-family-poppins font-weight-bold d-block">' . lifeline_color( lifeline_get( $options, 'signup_form_title' ) ) . '</strong>' : ''; ?>
					<?php echo ( lifeline_get( $options, 'signup_form_description' ) ) ? '<p>' . wp_kses( lifeline_get( $options, 'signup_form_description' ), true ) . '</p>' : ''; ?>

					<form class="w-100">
						<input class="border-0 w-100 rounded" type="text" name="user_name" id="user_name" placeholder="<?php esc_attr_e( 'Username', 'lifeline' ); ?>">
						<input class="border-0 w-100 rounded" type="email" name="user_email" id="user_email" placeholder="<?php esc_attr_e( 'Your Email', 'lifeline' ); ?>">
						<input type="password" name="user_pass" id="user_pass" class="form-control" placeholder="<?php esc_attr_e( 'Password', 'lifeline' ); ?>">
						<?php if ( lifeline_get( $options, 'termscondition' ) ) : ?>
							<p><?php echo wp_kses_post( lifeline_get( $options, 'terms_condition_text' ) ); ?><?php echo esc_attr( ( lifeline_get( $options, 'term_condition' ) ) ) ? '<a itemprop="url" href="' . get_permalink( lifeline_get( $options, 'term_condition' ) ) . '" title="' . get_the_title( lifeline_get( $options, 'term_condition' ) ) . '">' . get_the_title( lifeline_get( $options, 'term_condition' ) ) . '</a>' : ''; ?></p>
						<?php endif; ?>
						<input type="hidden" name="form_validate" value="signup" />
						<?php wp_nonce_field( 'ajax-login-nonce', 'security' ); ?>
						<button data-form="<?php echo esc_attr( $form_id ); ?>" class="theme-btn bg-theme overflow-hidden d-inline-block text-white position-relative rounded font-weight-bold" type="submit">CREATE ACCOUNT</button>
					</form>
				</div>
			</div>
		</div>
	</div>
</div><!-- Popup Wrap -->
