<?php

/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       1.0.0
 */

use Lifeline\Plugin\Classes\WPBForms;

if ( ! class_exists( '\Lifeline\Plugin\Classes\WPBForms' ) ) {
	return;
}

$options = lifeline()->options();
if ( lifeline_get( $options, 'top_bar_auth' ) ) {
	WPBForms::enqueue();
	$user_check = is_user_logged_in();
	wp_enqueue_script( array( 'lifeline_' . 'script-authentication' ) );
	?>
	<ul class="top-list mb-0 list-unstyled d-inline-flex flex-lg-row flex-sm-column">
		<?php
		if ( ! $user_check ) :
			add_action(
				'wp_footer',
				function () {
					get_template_part( 'templates/header/topbar/login' );
				}
			);
			?>
			<li class="font-family-poppins position-relative">
				<i class="text-theme fas fa-sign-in-alt"></i><a href="javascript:void(0)" data-toggle="modal" data-target="#login" title="<?php esc_attr_e( 'LOGIN', 'lifeline' ); ?>"><?php echo esc_html( lifeline_get( $options, 'signin_text' ) ); ?></a>
			</li>
		<?php endif; ?>
		<?php
		if ( lifeline_get( $options, 'show_signup' ) && ! $user_check && get_option( 'users_can_register' ) ) :
			add_action(
				'wp_footer',
				function () {
					get_template_part( 'templates/header/topbar/signup' );
				}
			);
			?>
			<li class="font-family-poppins position-relative">
				<i class="text-theme fas fa-user"></i><a href="javascript:void(0)" data-toggle="modal" data-target="#signup" title="<?php esc_attr_e( 'SIGNUP', 'lifeline' ); ?>"><?php echo esc_html( lifeline_get( $options, 'signup_text' ) ); ?></a>
			</li>
		<?php endif; ?>
		<?php if ( lifeline_get( $options, 'my_account' ) && $user_check ) : ?>
			<li class="font-family-poppins position-relative"><i class="text-theme fas fa-folder"></i><a href="<?php echo esc_url( get_the_permalink( lifeline_get( $options, 'account_link' ) ) ); ?>" title="<?php esc_attr_e( 'MY ACCOUNT', 'lifeline' ); ?>"><?php echo esc_html( lifeline_get( $options, 'account_text' ) ); ?></a></li>
		<?php endif; ?>
		<?php if ( $user_check ) : ?>
			<li class="font-family-poppins position-relative"><i class="text-theme fas fa-user-lock"></i><a href="<?php echo esc_url( wp_logout_url( home_url( '/' ) ) ); ?>" title="<?php esc_attr_e( 'LOGOUT', 'lifeline' ); ?>"><?php esc_html_e( 'LOGOUT', 'lifeline' ); ?></a></li>
		<?php endif; ?>
	</ul>
	<?php
}
