<?php
/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       1.0.0
 */

$options = lifeline()->options();
$classes = array(
    ( lifeline_get( $options, 'header_sticky' ) ) ? 'stick sticky' : '',
    ( lifeline_get( $options, 'header_styles' ) == '2' ) ? 'style1 dark-header' : 'style1',
);
?>
<div class="header1-topbar topbar-header5">
<?php get_template_part( 'templates/header/topbar/topbar2' ); ?>
</div>
<header id="header5">
    <div class="header-1 header5">
        <div class="container">
             <div class="row justify-content-between align-items-center">
                <div class="col-md-3">
                    <?php if ( lifeline_get( $options, 'header_5_main_logo.id' ) ) : ?>
                        <div class="logo d-inline-block">
                            <h1 class="mb-0">
                                <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
                                    <?php echo wp_get_attachment_image( lifeline_get( $options, 'header_5_main_logo.id' ), 'full' ); ?>
                                </a>
                            </h1>
                        </div><!-- Logo -->
                    <?php else : ?>
                        <figure>
                            <?php get_template_part( 'templates/header/branding/logo' ); ?>
                        </figure>
                    <?php endif; ?>
                </div>
                <div class="col-md-9">
                    <nav>
                        <?php get_template_part( 'templates/header/branding/menu' ); ?>
                        <div class="menu-extra"> 
                            <?php if ( lifeline_get( $options, "header_5_cart_toggle" ) ) : ?>
                                <?php get_template_part( 'templates/header/branding/cart' ); ?>
                            <?php endif; ?>
                            <?php get_template_part( 'templates/header/branding/button' ); ?>
                        </div>
                    </nav>
                </div>              
            </div>      
        </div>
    </div>
</header>

