<?php
$meta       = lifeline()->meta( get_the_ID() );
$meta_video = lifeline_get( $meta, 'lifeline_videos' );
if ( ! $meta_video ) {
	return;
}

foreach ( $meta_video as $v ) {
	$video_id = lifeline_get( $v, 'id' );
	$link     = '';
	switch ( lifeline_get( $v, 'source' ) ) {
		case 'dailymotion':
				$link = 'http://dailymotion.com/' . $video_id;
			break;
		case 'vimeo':
				$link = 'http://vimeo.com/' . $video_id;
			break;
		case 'youtube':
				$link = 'http://youtu.be/' . $video_id;
			break;
	}
	?>
	<div class="col-md-6 col-sm-12 col-lg-4 video fltr-itm">
		<div class="gallery-box text-center position-relative mb-30 w-100 rounded overflow-hidden">
			<i class="fas fa-play-circle bg-theme text-white position-absolute rounded"></i>
			<a class="d-block position-relative" href="<?php echo esc_url( $link ); ?>" data-fancybox="gallery">
				<img class="img-fluid w-100" src="<?php echo esc_url( lifeline_get( $v, 'thumb' ) ); ?>" alt="<?php echo esc_url( lifeline_get( $v, 'title' ) ); ?>">
			</a>
		</div>
	</div>
	<?php
}
