<?php
$opt          = lifeline()->options();
$title_limit = lifeline_get( $opt, 'gallery_list_title_word_limit' );
$col           = lifeline_get( $opt, 'gallery_list_col' );

?>
<div class="gallery-wrap">
	<div class="row">
		<?php while ( have_posts() ) : ?>
			<?php the_post(); ?>
			<div class="col-sm-6 col-md-<?php echo $col ?>">
				<div class="gallery-box">
					<a  href="<?php echo esc_url( get_the_permalink() ); ?>" title="<?php the_title_attribute(); ?>">
						<?php the_post_thumbnail( 'lifeline_555x623', array( 'class' => 'img-fluid w-100' ) ); ?>
					</a>
					<div class="gallery-content" >
						<h3 >
							<?php if ( empty( $title_limit ) ) : ?>
								<a href="<?php echo esc_url( get_the_permalink() ); ?>" title="<?php the_title_attribute(); ?>"><?php echo wp_trim_words( get_the_title(), $title_limit , '' ); ?></a>
							<?php else : ?>
								<a href="<?php echo esc_url( get_the_permalink() ); ?>" title="<?php the_title_attribute(); ?>"><?php echo wp_trim_words( get_the_title(), $title_limit ); ?></a>	
							<?php endif; ?>
						</h3>
					</div>
				</div>
			</div>
		<?php endwhile; ?>
	</div>
	<?php lifeline_the_pagination(); ?>
</div>
