<?php
$opt     = lifeline()->options();
$profile = lifeline_get( $opt, 'footer_social_media' );
if ( ! $profile ) {
	return;
}
?>

<div class="col-md-12 col-sm-12 col-lg-6">
	<div class="widget-box d-flex stayin_touch_widget justify-content-lg-end w-100 justify-content-md-center justify-content-center align-items-center">
		<?php
		$title = lifeline_get( $opt, 'social_icons_title' );
		if ( $title ) :
			?>
			<h3 class="text-white mb-0 font-weight-medium"><?php echo lifeline_color( $title ); ?></h3>
		<?php endif; ?>
		<div class="social-bar d-flex">
			<?php
			foreach ( $profile as $icon ) :
				$icon = json_decode( urldecode( lifeline_get( $icon, 'data' ) ), true );
				if ( $icon['enable'] == true ) {
					?>
					<a class="rounded-circle text-white text-center" href="<?php echo esc_url( lifeline_get( $icon, 'url' ) ); ?>" title="<?php echo esc_attr( str_replace( array( 'fa-', '-' ), array( '', ' ' ), lifeline_get( $icon, 'icon' ) ) ); ?>"><i class="fab <?php echo ( lifeline_get( $icon, 'icon' ) ); ?>"></i></a>
					<?php
				}
			endforeach;
			?>
		</div>
	</div>
</div>
