<?php
$opt         = lifeline()->options();
$title_limit = lifeline_get( $opt, 'causes_list_title_character_limit', 15 );
$cols        = lifeline_get( $opt, 'causes_list_column', 4 );
$collection  = lifeline_get( $opt, 'causes_list_current_label', 'Current Collection' );

wp_enqueue_script( 'barfiller' );
while ( have_posts() ) :
	the_post();
	$meta            = lifeline()->meta( get_the_ID() );
	$cause_settings  = lifeline_get( $meta, 'causes_settings' );
	$donation_needed = ( lifeline_get( $cause_settings, 'donation' ) ) ? lifeline_get( $cause_settings, 'donation' ) : 0;
	$post            = get_post( get_the_ID() );
	$collect_amt     = \WebinaneCommerce\Classes\Orders::get_items_total( $post );
	if ( $collect_amt != 0 && $donation_needed != 0 ) { // phpcs:ignore WordPress
		$donation_percentage = ( $collect_amt / $donation_needed ) * 100;
	} else {
		$donation_percentage = 0;
	}

?>

    <div class="col-sm-12 col-md-<?php echo $cols; ?> col-lg-4">
            <div class="lif-cause-post lif-cause-style1">
                    <div class="lif-cause-media ">
                        <figure>
                            <?php
                                if ( lifeline_get( $cause_settings, 'donation_cause_gallery' ) == 'gallery' ) : // phpcs:ignore WordPress
                                    $gallery = explode( ',', lifeline_get( $cause_settings, 'donation_cause_gallery' ) );
                            ?>
                            <div class="urgentcause-thumb w-100 position-relative" data-js="urgentcause-gallery">
                            <?php
                                foreach ( $gallery as $key => $value ) {
                                    echo wp_get_attachment_image( $value, 'lifeline_290x290' );
                                }
                            ?>
                            </div>
                            <?php else : ?>
                                <?php echo get_the_post_thumbnail( get_the_ID(), 'lifeline_290x290', array( 'class' => 'img-fluid' ) ); ?>
                            <?php endif; ?>
                        </figure>
                    </div>
                    <div class="lif-cause-content">
                            <h3>
                                <a href="<?php the_permalink(); ?>">
                                    <?php
                                        echo get_the_title();
                                    ?>
                                </a>
                            </h3>
                            <?php if ( $collection ) : ?>
							<div class="cause-amount d-inline-block position-relative">
								<span class="font-family-poppins text-dark d-block font-weight-bold">
									<?php echo lifeline_cm_price_with_symble( $donation_needed ); ?>
								</span>
                                <span>Needed</span>
							</div>
						<?php endif; ?>
                    </div>
            </div>
    </div>

<?php
endwhile;
lifeline_the_pagination_blog();
?>