<?php
	get_header();
	$opt = lifeline()->options();
	
	$meta = lifeline()->meta( get_the_ID() );
	$meta = lifeline_get( $meta, 'causes_settings' );
	
	$format   = lifeline_get( $meta, 'cause_format' );
	$video    = lifeline_get( $meta, 'donation_cause_video' );
	$location = lifeline_get( $meta, 'location' );
	$donation = lifeline_get( $meta, 'donation' );
    $urgent   = lifeline_get( $opt, 'causes_detail_show_urgent' );
    $u_label  = lifeline_get( $opt, 'causes_detail_urgent_label' );
	
	$meta2   = lifeline()->page()->args;
	$layout  = ( lifeline_get( $meta2, 'sidebar_position' ) != 'full' ) ? lifeline_get( $meta2, 'sidebar_position' ) : ''; // phpcs:ignore WordPress
	$sidebar = ( lifeline_get( $meta2, 'sidebar' ) ) ? lifeline_get( $meta2, 'sidebar' ) : '';
	$col     = ( $layout != 'full' && $layout ) ? '9' : '12'; // phpcs:ignore WordPress
	$col     = apply_filters( 'lifeline/post/life_cause/content/classes', "col-md-12 col-sm-12 col-lg-{$col}" );


	if ( $layout == 'left' ) { // phpcs:ignore WordPress
		// phpcs:ignore WordPress
		do_action( 'lifeline/post/sidebar', $sidebar );
	}
	?>
	<div class="<?php echo esc_attr( $col ); ?>">
		<div class="gen-detail-wrap w-100">
			<?php
			while ( have_posts() ) {
				the_post();
				?>
				<div class="post-intro position-relative w-100">
                    <div class="cause-media">
					<?php
					if ( $format == 'video' ) { // phpcs:ignore WordPress
						echo esc_url( $video ) ? ( $wp_embed->run_shortcode( '[embed]' . $video . '[/embed]' ) ) : '';
					} else {
						get_template_part( 'templates/blog-details/default' );
					}
					?>
                    <div class="cause-info">
                        <ul>
                            <?php if ( $urgent ) : ?>
                                <li> <?php echo esc_html( $u_label ); ?> </li>
                            <?php endif; ?>
                            <?php if ( $location ) : ?>
                                <li class="font-family-poppins"><i class="fas fa-map-marker-alt text-theme"></i> <?php echo esc_html( $location ); ?></li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    </div>
					<div class="row">
						<div class="col-md-8 col-sm-12 col-lg-9">
							<ul class="pst-mta mb-0 list-unstyled d-sm-inline-flex w-100">
								<?php if ( lifeline_get( $opt, 'causes_detail_show_date' ) ) : ?>
									<li class="font-family-poppins"><i class="far fa-calendar text-theme"></i><?php echo esc_attr( get_the_date() ); ?></li>
								<?php endif; ?>
								<?php if ( lifeline_get( $opt, 'causes_detail_show_author' ) ) : ?>
									<li class="font-family-poppins"><i class="far fa-user text-theme"></i> <?php esc_html_e( 'By', 'lifeline' ); ?> <?php the_author_link(); ?></li>
								<?php endif; ?>
							</ul>
							<h2 class="mb-0 text-dark"><?php the_title(); ?></h2>
							<?php if ( lifeline_get( $opt, 'causes_detail_show_social_share' ) ) : ?>
								<?php $social_icons = lifeline_get( $opt, 'causes_detail_social_media' ); ?>
								<?php if ( ! empty( $social_icons ) ) : ?>
									<div class="share-this w-100">
										<?php echo ( lifeline_get( $opt, 'causes_detail_show_social_share_title' ) ) ? '<span class="mb-0 text-dark text-uppercase font-weight-semibold font-family-poppins d-inline-flex">' . lifeline_get( $opt, 'causes_detail_show_social_share_title' ) . '</span>' : ''; ?>
										<div class="share-this-innr d-inline-flex">
											<?php
											foreach ( $social_icons as $k => $v ) {
												if ( $v !== '' ) { // phpcs:ignore WordPress
													lifeline_social_share_output( $k );
												}
											}
											?>
										</div>
									</div><!-- Share This -->
								<?php endif; ?>
							<?php endif; ?>
						</div>
						<?php if ( $donation ) : ?>
							<div class="col-md-4 col-sm-12 col-lg-3">
								<div class="cause-detail-info text-center w-100">
									<span class="text-theme d-block font-family-poppins font-weight-bold"><?php echo lifeline_cm_price_with_symble( $donation ); ?></span>
									<strong class="bg-white text-dark d-block font-weight-bold position-relative overflow-hidden">
										<?php esc_html_e( 'Needed Donation', 'lifeline' ); ?>
										<?php
										$class = 'd-block font-family-poppins font-weight-bold text-white bg-theme';

										lifeline_donation_button_post( $class, 'DONATE NOW' );
										?>
									</strong>
								</div>
							</div>
						<?php endif; ?>
					</div>
				</div>
				<?php
				the_content();
			}
			?>
		</div>
	</div>
	<?php
	if ( $layout == 'right' ) { // phpcs:ignore WordPress
		// phpcs:ignore WordPress
		do_action( 'lifeline/post/sidebar', $sidebar );
	}
?>