<?php
$opt        = lifeline()->options();
$cat        = lifeline_get( $opt, 'blog_post_tags' );
$author     = lifeline_get( $opt, 'blog_post_author' );
$date 	  = lifeline_get( $opt, 'blog_post_date' );
$title      = lifeline_get( $opt, 'title_character_limit', 5 );
$label      = lifeline_get( $opt, 'post_read_more_label', esc_html__( 'View Article', 'lifeline' ) );
$enable_btn      = lifeline_get( $opt, 'post_read_more');
$content    = lifeline_get( $opt, 'character_limit', 15 );
$pagination = lifeline_get( $opt, 'paginstion' ) ? lifeline_get( $opt, 'paginstion' ) : 1;

if ( function_exists( 'lifeline_encrypt' ) ) {
	$load_more = lifeline_encrypt(
		array(
			'desc_limit'     => $title,
			'title_limit'    => $content,
			'paged'          => max( 1, get_query_var( 'paged' ) ),
			'posts_per_page' => get_option( 'posts_per_page' ),
		)
	);
} else {
	$load_more = '';
}

?>

<?php if ( have_posts() ) : ?>
	<div class="blog-post list-style3">
	<?php while ( have_posts() ) : ?>
		<?php the_post(); ?>
		<div class="blog-post-item">
			<div class="row align-items-center">
				<div class="col-md-12 col-lg-5">
					<div class="blog-media">
						<?php 
							if ( has_post_thumbnail() ) {
								the_post_thumbnail( 'lifeline_350x350', array( 'class' => 'img-fluid' ) );
							}
						?>
					</div>
				</div>
				<div class="col-md-12 col-lg-7">
					<div class="blog-content">
						<h3>
							<a href="<?php the_permalink(); ?>">
								<?php
									if ( ! empty(  lifeline_get( $opt, 'title_character_limit' )  )  ) {
										echo wp_trim_words( get_the_title(), lifeline_get( $opt, 'title_character_limit', 5 ), '' );
									} else {
										echo get_the_title();
									}
								?>
							</a>
						</h3>
						<p>
							<?php 
									if ( ! empty( lifeline_get( $opt, 'character_limit' )  ) ) {
										echo wp_trim_words( get_the_content(), lifeline_get( $opt, 'character_limit', 15 ), '' );
									} else {
										echo get_the_content();
									}
								?>
						</p>
						<ul>
							<?php if ( $cat ) : ?>
								<li class="blog-category">
									<?php echo get_the_category_list( "," ); ?>
								</li>
							<?php endif; ?>
							<?php if ( $date  ) : ?>
								<li>
									<?php 
										$archive_year  = get_the_time( 'Y' ); 
										$archive_month = get_the_time( 'm' ); 
										$archive_day   = get_the_time( 'd' ); 
									?>
									<a href="<?php echo get_day_link( $archive_year, $archive_month, $archive_day); ?>"><?php echo get_the_date(); ?></a>
								</li>
							<?php endif; ?>
							<?php if ( $author  ) : ?>
								<li>
									<a href="<?php echo get_the_author_meta( 'url' )  ?>" >by <?php echo get_the_author(); ?></a>
								</li>
							<?php endif; ?>
						</ul>
					</div>
				</div>
			</div>
		</div>
	<?php endwhile; ?>
	</div>
<?php endif; ?>

<?php if ( ! $pagination ) : ?>
	<a id="press_room" class="load-more d-inline-block w-100 rounded text-center font-weight-extrabold mt-30" href="javascript:void(0);" data-load="<?php echo esc_attr( $load_more ); ?>">
		<i class="fas fa-sync"></i>
		<?php esc_html_e( 'LOAD MORE', 'lifeline' ); ?>
	</a>
	<?php
else :
	lifeline_the_pagination_blog();
endif;
