<?php
$opt        = lifeline()->options();
$cat        = lifeline_get( $opt, 'blog_post_tags' );
$date 	  = lifeline_get( $opt, 'blog_post_date' );
$author     = lifeline_get( $opt, 'blog_post_author' );
$content    = lifeline_get( $opt, 'character_limit', 15 );
$label      = lifeline_get( $opt, 'post_read_more_label', esc_html__( 'READ MORE', 'lifeline' ) );
$pagination = lifeline_get( $opt, 'paginstion' ) ? lifeline_get( $opt, 'paginstion' ) : 0;
$featured_post = lifeline_get( $opt, 'blog_feature_post' );

if ( function_exists( 'lifeline_encrypt' ) ) {
	$load_more = lifeline_encrypt(
		array(
			'desc_limit'     => $title,
			'title_limit'    => $content,
			'paged'          => max( 1, get_query_var( 'paged' ) ),
			'posts_per_page' => get_option( 'posts_per_page' ),
		)
	);
} else {
	$load_more = '';
}

$args = array(
    'post_type'      => '',
    'post__in'   => array( $featured_post ),
);

$featured_post = new WP_Query( $args );

?>

<?php if ( $featured_post->have_posts() ) : ?>
	<?php while ( $featured_post->have_posts() ) : ?>
		<?php $featured_post->the_post(); ?>
        <div class="lif-blog-featured-post list-style2">
			<ul>
				<?php if ( $cat ) : ?>
					<li class="blog-category">
						<?php echo get_the_category_list( "," ); ?>
					</li>
				<?php endif; ?>
				<?php if ( $date  ) : ?>
					<li>
						<?php 
							$archive_year  = get_the_time( 'Y' ); 
							$archive_month = get_the_time( 'm' ); 
							$archive_day   = get_the_time( 'd' ); 
						?>
						<a href="<?php echo get_day_link( $archive_year, $archive_month, $archive_day); ?>"><?php echo get_the_date(); ?></a>
					</li>
				<?php endif; ?>
			</ul>
			<h3>
				<a href="<?php the_permalink(); ?>">
					<?php
						echo get_the_title();
					?>
				</a>
			</h3>
			<div class="blog-media">
				<?php 
					if ( has_post_thumbnail() ) {
						the_post_thumbnail( 'lifeline_870x470', array( 'class' => 'img-fluid w-100' ) );
					}
				?>
			</div>
			<?php 
				echo get_the_content();
			?>
			<a class="lif_donate" href="<?php the_permalink(); ?>">
				<?php echo esc_html_e( 'Donate Now', 'lifeline' ) ?>
			</a>
		</div>
	<?php endwhile; wp_reset_postdata(); ?>
<?php endif; ?>

<?php if ( have_posts() ) : ?>
	<div class="blog-post list-style2">
		<?php while ( have_posts() ) : ?>
			<?php the_post() ?>
			<div class="blog-post-item ">
				<div class="row align-items-center post-listing">
					<div class="col-md-5">
						<div class="blog-media">
							<?php 
								if ( has_post_thumbnail() ) {
									the_post_thumbnail( 'lifeline_320x310', array( 'class' => 'img-fluid w-100' ) );
								}
							?>
						</div>
					</div>
					<div class="col-md-7">
						<div class="blog-content">
							<ul>
								 <?php if ( $cat ) : ?>
       							 	<div class="blog-category">
          				 	 <ul>
                <?php
                // Get the categories for the current post
                $blog_categories = get_the_category();
                
                foreach ( $blog_categories as $category ) {
                    ?>
                    <li>
                        <a href="<?php echo esc_url( get_category_link( $category->term_id ) ) ?>"><?php echo $category->name; ?></a>
                    </li>
                    <?php
                }
                ?>
            </ul>
        </div>
    <?php endif; ?>
								<?php if ( $date  ) : ?>
									<li>
										<?php 
											$archive_year  = get_the_time( 'Y' ); 
											$archive_month = get_the_time( 'm' ); 
											$archive_day   = get_the_time( 'd' ); 
										?>
										<a href="<?php echo get_day_link( $archive_year, $archive_month, $archive_day); ?>"><?php echo get_the_date(); ?></a>
									</li>
								<?php endif; ?>
							</ul>
							<h3>
								<a href="<?php the_permalink(); ?>">
									<?php
										if ( ! empty(  lifeline_get( $opt, 'blog_title_character_limit' )  )  ) {
											echo wp_trim_words( get_the_title(), lifeline_get( $opt, 'blog_title_character_limit', 5 ), '' );
										} else {
											echo get_the_title();
										}
									?>
								</a>
							</h3>
							<p>
								<?php 
										if ( ! empty( lifeline_get( $opt, 'blog_character_limit' )  ) ) {
											echo wp_trim_words( get_the_content(), lifeline_get( $opt, 'blog_character_limit', 15 ), '' );
										} else {
											echo get_the_content();
										}
									?>
							</p>
							<a href="<?php the_permalink(); ?>">
									<?php echo esc_html_e( 'View Article', 'lifeline' ) ?>
									<i class="fa fa-arrow-right"></i>
							</a>
						</div>
					</div>
				</div>
			</div>
		<?php endwhile; ?>
	</div>
<?php endif; ?>

<div class="loadmore-wrap" style="margin:auto;">
    <div id="loadMore"><?php next_posts_link( 'LOAD MORE' ); ?></div>
</div>