<?php
$opt        = lifeline()->options();
$cat        = lifeline_get( $opt, 'blog_post_tags' );
$date 	  = lifeline_get( $opt, 'blog_post_date' );
$author     = lifeline_get( $opt, 'blog_post_author' );
$content    = lifeline_get( $opt, 'character_limit', 15 );
$label      = lifeline_get( $opt, 'post_read_more_label', esc_html__( 'READ MORE', 'lifeline' ) );
$pagination = lifeline_get( $opt, 'paginstion' ) ? lifeline_get( $opt, 'paginstion' ) : 0;

if ( function_exists( 'lifeline_encrypt' ) ) {
	$load_more = lifeline_encrypt(
		array(
			'desc_limit'     => $title,
			'title_limit'    => $content,
			'paged'          => max( 1, get_query_var( 'paged' ) ),
			'posts_per_page' => get_option( 'posts_per_page' ),
		)
	);
} else {
	$load_more = '';
}

?>

<?php if ( have_posts() ) : ?>
	<?php while ( have_posts() ) : ?>
		<?php the_post() ?>
		<div class="blog-post style1">
			<div class="blog-media">
				<?php 
					if ( has_post_thumbnail() ) {
						the_post_thumbnail( 'lifeline_870x410', array( 'class' => 'img-fluid w-100' ) );
					}
				?>
				<ul class="blog-meta">
					<?php if ( $date  ) : ?>
						<li>
							<?php 
								$archive_year  = get_the_time( 'Y' ); 
								$archive_month = get_the_time( 'm' ); 
								$archive_day   = get_the_time( 'd' ); 
							?>
							<i class="fas fa-calendar"></i>
							<a href="<?php echo get_day_link( $archive_year, $archive_month, $archive_day); ?>"><?php echo get_the_date(); ?></a>
						</li>
					<?php endif; ?>
					<?php if ( $author  ) : ?>
						<li>
							<i class="fas fa-user"></i>
							<a href="<?php echo get_the_author_meta( 'url' )  ?>" >by <?php echo get_the_author(); ?></a>
						</li>
					<?php endif; ?>
				</ul>
			</div>
			<div class="blog-content">
				<?php if ( $cat ) : ?>
					<div class="blog-category">
						<span><?php esc_html_e(  'Posted In:', 'lifeline'  ); ?></span>
						<ul>
							<?php 
								$blog_categories = get_categories() ;
								// echo '<pre>';
								// print_r( $blog_categories );
								foreach ( $blog_categories as $categories ) {
							?>
								<li>
									<a href="<?php echo esc_url( get_category_link( $categories->term_id ) ) ?>"><?php echo $categories->name; ?></a>
								</li>
							<?php
								}
							?>
						</ul>
					</div>
				<?php endif; ?>
				<h3>
					<a href="<?php the_permalink(); ?>">
						<?php
							if ( ! empty(  lifeline_get( $opt, 'blog_title_character_limit' )  )  ) {
								echo wp_trim_words( get_the_title(), lifeline_get( $opt, 'blog_title_character_limit', 5 ), '' );
							} else {
								echo get_the_title();
							}
						?>
					</a>
				</h3>
				<p>
					<?php 
							if ( ! empty( lifeline_get( $opt, 'blog_character_limit' )  ) ) {
								echo wp_trim_words( get_the_content(), lifeline_get( $opt, 'blog_character_limit', 15 ), '' );
							} else {
								echo get_the_content();
							}
						?>
				</p>
			</div>
		</div>

	<?php endwhile; ?>
<?php endif; ?>

<?php if ( ! $pagination ) : ?>
	<a id="press_room" class="load-more d-inline-block w-100 rounded text-center font-weight-extrabold mt-30" href="javascript:void(0);" data-load="<?php echo esc_attr( $load_more ); ?>">
		<i class="fas fa-sync"></i>
		<?php esc_html_e( 'LOAD MORE', 'lifeline' ); ?>
	</a>
	<?php
else :
	lifeline_the_pagination_blog();
endif;