<?php
/* Template Name: Events
*/

?>

<?php
get_header();
$current_category = get_queried_object();
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
$args = array(
	'post_type' => 'lif_event',
	'post_status' => 'publish',
	'paged' => $paged,
	'tax_query'	=>	array(
		array(
			'taxonomy'	=>	'event_category',
			'field'		=>	'slug',
			'terms'		=>	$current_category->slug
		),
	),

);
$opt         = lifeline()->options();
$title_limit = lifeline_get($opt, 'event_list_title_character_limit', '15');

$ch_limit = lifeline_get($opt, 'event_list_character_limit', '15');

$style = lifeline_get($opt, 'event_listing_style');


$query = new WP_Query($args);
if ($query->have_posts()) :


?>
	<section class="gap">
		<?php if ($style == 'event-list') {
			echo '<div class="custom-continer-fluid">';
		} else {
			'<div class="container">';
		} ?>
		<div class="container">
			<div class="row">
				<?php while ($query->have_posts()) : $query->the_post();  ?>

					<?php lifeline_template_load('templates/event/taxonomy-event-category/taxonomy-event-category-grid.php', compact('title_limit', 'ch_limit')); ?>
				<?php endwhile;
				wp_reset_postdata(); ?>
				<?php lifeline_the_pagination($query->max_num_pages); ?>
			<?php endif; ?>
			</div>
		</div>
		</div>
	</section>

	<?php
	get_footer();