<?php
get_header();
$opt = lifeline()->options();

$meta         = lifeline()->meta( get_the_ID() );
$location     = lifeline_get( $meta, 'location' );
$money_title  = lifeline_get( $meta, 'money_title' );
$project_cost = lifeline_get( $meta, 'project_cost' );

$meta    = lifeline()->page()->args;
$layout  = lifeline_get( $meta, 'sidebar_position', 'left' );
$sidebar = lifeline_get( $meta, 'sidebar', 'sidebar-1' );
$col     = ( $layout != 'full' ) ? '9' : '12'; // phpcs:ignore WordPress
$col     = apply_filters( 'lifeline/post/life_story/content/classes', "col-md-12 col-sm-12 col-lg-{$col}" );
?>
<section>
	<div id="post-<?php the_ID(); ?>" <?php post_class( 'py-80 bg-gray position-relative w-100' ); ?>>
		<div class="container">
			<div class="row">
				<?php
				if ( $layout == 'left' ) { // phpcs:ignore WordPress
					// phpcs:ignore WordPress
					do_action( 'lifeline/post/sidebar', $sidebar );
				}
				?>
				<div class="<?php echo esc_attr( $col ); ?>">
					<div class="gen-detail-wrap w-100">

						<?php
						while ( have_posts() ) {
							the_post();
							?>
							<div class="post-intro position-relative w-100">
								<?php get_template_part( 'templates/blog-details/default' ); ?>
								<div class="row">
									<div class="col-md-8 col-sm-12 col-lg-9">
										<ul class="pst-mta mb-0 list-unstyled d-sm-inline-flex w-100">
											<?php if ( lifeline_get( $opt, 'story_detail_show_date' ) ) : ?>
												<li class="font-family-poppins"><i class="far fa-calendar text-theme"></i>
													<?php echo esc_attr( get_the_date( get_option( 'date_format', get_the_ID() ) ) ); ?>
												</li>
											<?php endif; ?>
											<?php if ( $location ) : ?>
												<li class="font-family-poppins">
													<i class="fas fa-map-marker-alt text-theme"></i>
													<?php echo esc_html( $location ); ?>
												</li>
											<?php endif; ?>
											<?php if ( lifeline_get( $opt, 'story_detail_show_author' ) ) : ?>
												<li class="font-family-poppins">
													<i class="far fa-user text-theme"></i>  <?php esc_html_e( 'By', 'lifeline' ); ?> <?php the_author_link(); ?>
												</li>
											<?php endif; ?>
										</ul>
										<h2 class="mb-0 text-dark"><?php the_title(); ?></h2>
										<?php if ( lifeline_get( $opt, 'story_detail_show_social_share' ) ) { ?>
											<?php $social_icons = lifeline_get( $opt, 'story_detail_social_media' ); ?>
											<?php if ( ! empty( $social_icons ) ) { ?>
												<div class="share-this w-100">
													<?php echo ( lifeline_get( $opt, 'story_detail_show_social_share_title' ) ) ? '<span class="mb-0 text-dark text-uppercase font-weight-semibold font-family-poppins d-inline-flex">' . lifeline_get( $opt, 'story_detail_show_social_share_title' ) . '</span>' : ''; ?>
													<div class="share-this-innr d-inline-flex">
														<?php
														foreach ( $social_icons as $k => $v ) {
															if ( $v !== '' ) { // phpcs:ignore WordPress
																lifeline_social_share_output( $k );
															}
														}
														?>
													</div>
												</div><!-- Share This -->
											<?php } ?>
										<?php } ?>
									</div>
									<?php if ( $project_cost ) : ?>
										<div class="col-md-4 col-sm-12 col-lg-3">
											<div class="cause-detail-info text-center w-100">
												<span class="text-theme d-block font-family-poppins font-weight-bold"><?php echo lifeline_cm_price_with_symble( $project_cost ); ?></span>
												<strong class="bg-white text-dark d-block font-weight-bold position-relative overflow-hidden"><?php echo esc_html( $money_title ); ?></strong>
											</div>
										</div>
									<?php endif; ?>
								</div>
							</div>
							<?php the_content(); ?>
							<?php
						}
						?>
					</div>
				</div>
				<?php
				if ( $layout == 'right' ) { // phpcs:ignore WordPress
					// phpcs:ignore WordPress
					do_action( 'lifeline/post/sidebar', $sidebar );
				}
				?>
			</div>
		</div>
	</div>
</section>
<?php
get_footer();
