<?php
get_header();
$opt     = lifeline()->options();
$meta    = lifeline()->meta( get_the_ID() );
$title_1 = lifeline_get( $meta, 'feature_title' );
$title_2 = lifeline_get( $meta, 'feature_title_tag' );
$limit   = lifeline_get( $opt, 'related_service_limit' );
$number  = lifeline_get( $opt, 'related_service_num' );

while ( have_posts() ) {
	the_post();
	?>
	<section>
		<div id="post-<?php the_ID(); ?>" <?php post_class( 'py-80 bg-gray position-relative w-100' ); ?>>
			<div class="container">
				<div class="service-detail-wrap w-100">
					<h2 class="mb-0 text-dark text-center"><?php the_title(); ?></h2>
					<div class="service-detail-img w-100 position-relative">
						<?php the_post_thumbnail( '1140x455', array( 'class' => 'img-fluid w-100' ) ); ?>
						<?php if ( lifeline_get( $meta, 'icon_select_field' ) ) : ?>
							<span class="d-block text-theme position-absolute rounded-circle text-center">
								<i class="<?php echo lifeline_get( $meta, 'icon_select_field' ); ?>"></i>
							</span>
						<?php endif; ?>
					</div>
					<div class="service-detail-desc w-100">
						<div class="row">
							<div class="col-md-12 col-sm-12 col-lg-5">
								<div class="service-features-wrap w-100">
									<?php if ( $title_1 ) : ?>
										<span class="d-block"><?php echo esc_html( $title_1 ); ?></span>
									<?php endif; ?>
									<?php if ( $title_2 ) : ?>
										<h3 class="mb-0 font-weight-semibold text-dark"><?php echo lifeline_color( $title_2 ); ?></h3>
									<?php endif; ?>
									<?php
									$features = lifeline_get( $meta, 'service_features' );
									if ( $features ) {
										?>
									<div class="all-skills w-100">
										<?php
										unset( $features['redux_repeater_data'] );
										$x           = 0;
										$titles      = $features['service_title'];
										$description = $features['service_description'];
										$icon        = $features['icon_select_field'];
										if ( $titles && is_array( $titles ) ) {
											foreach ( $titles as $v ) {
												?>
												<div class="skills mt-30 d-flex align-items-center w-100">
													<i class="<?php echo esc_attr( $icon[ $x ] ); ?> rounded-circle text-theme text-center"></i>
													<div class="skills-inner">
														<?php if ( $titles && is_array( $titles ) ) { ?>
																<h3 class="mb-0 text-theme font-weight-semibold">
																	<?php echo esc_html( $titles[ $x ] ); ?>
																</h3>
														<?php } ?>
														<?php if ( $description && is_array( $description ) ) { ?>
															<p class="mb-0"><?php echo esc_html( $description[ $x ] ); ?></p>
														<?php } ?>
													</div>
												</div>
												<?php
												$x++;
											}
										}
										?>
									</div>
										<?php
									}
									?>
								</div>
							</div>
							<div class="col-md-12 col-sm-12 col-lg-7">
								<?php the_content(); ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<?php
}
if ( lifeline_get( $opt, 'related_services_section' ) ) :
	?>
	<section>
		<div class="pt-80 pb-50">
			<div class="container">
				<div class="sec-title mb-40 w-100 text-center">
					<?php
					$title1 = lifeline_get( $opt, 'related_service_title' );
					$title2 = lifeline_get( $opt, 'related_service_description' );
					?>
					<?php if ( $title1 ) : ?>
						<h2 class="mb-0"><?php echo lifeline_color( $title1 ); ?></h2>
					<?php endif; ?>
					<?php if ( $title1 ) : ?>
						<p class="mb-0"><?php echo esc_html( $title2 ); ?></p>
					<?php endif; ?>
				</div><!-- Sec Title -->
				<div class="row" data-responsive-slickCarousel data-options='{
						"arrows": false,
						"infinite": true,
						"slidesToShow": 2,
						"slidesToScroll": 1,
						"fade": false,
						"autoplay": true,
						"autoplaySpeed": 3000,
						"speed": 2000,
						"draggable": true,
						"dots": true,
						"pauseOnDotsHover": true,
						"pauseOnFocus": false,
						"pauseOnHover": true,
						"responsive": [{
						"breakpoint": 850,
						"settings": {
							"slidesToShow": 2,
							"slidesToScroll": 1,
							"infinite": true,
							"dots": true
						}
						},

						{
						"breakpoint": 480,
						"settings": {
							"slidesToShow": 1,
							"slidesToScroll": 1,
							"infinite": true,
							"dots": true
						}
						}]
					}'>

					<?php
					$post_terms = wp_get_post_terms( get_the_ID(), 'service_category' );

					if ( $post_terms ) {
						$args = array(
							'post_type'      => 'lif_service',
							'cat__in'        => array( $post_terms[0]->term_id ),
							'post__not_in'   => array( get_the_ID() ),
							'posts_per_page' => $number,
							'orderby'        => 'rand',
						);

						$my_query = new WP_Query( $args );
						if ( $my_query->have_posts() ) {
							while ( $my_query->have_posts() ) :
								$my_query->the_post();
								$meta = lifeline()->meta( get_the_ID() );
								?>
								<div class="col-md-4 col-sm-6 col-lg-4">
									<div class="skills mb-30 d-flex align-items-center w-100">
										<i class="<?php echo lifeline_get( $meta, 'icon_select_field' ); ?> rounded-circle text-theme text-center"></i>
										<div class="skills-inner">
											<h3 class="mb-0 text-theme font-weight-semibold"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
											<p class="mb-0"><?php echo esc_html( wp_trim_words( get_the_content(), $limit, '' ) ); ?></p>
										</div>
									</div>
								</div>
								<?php
							endwhile;
							wp_reset_postdata();
						}
					}
					?>
				</div><!-- Skills Wrap -->
			</div>
		</div>
	</section>
	<?php
endif;
get_footer();
