<?php
/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       5.0.0
 */
namespace Lifeline;

use Lifeline\Libraries\ClassLoader;
use Lifeline\Classes\Setup;

class Loader {

	/**
	 * init
	 *
	 * @return void
	 */
	static function init() {
		self::defines();
		self::includes();
		self::autoload();
		self::start();
		add_action( 'tgmpa_register', array( 'Lifeline\Classes\Tgmpa', 'init' ) );
	}
	/**
	 * defines
	 *
	 * @return void
	 */
	static function defines() {
		if ( ! defined( 'LIFELINE_NONCE' ) ) {
			define( 'LIFELINE_NONCE', 'lifeline_wp_theme' );
		}
	}
	/**
	 * autoload
	 *
	 * @return void
	 */
	static function autoload() {
		// autoload_psr4.php @generated by Composer
		$vendorDir1 = get_template_directory() . '/includes'; // phpcs:ignore WordPress
		$vendorDir2 = get_stylesheet_directory() . '/lifeline-plugin/includes'; // phpcs:ignore WordPress

		$psr = array(
			'Lifeline\\Child\Plugins\\' => array( $vendorDir2 ), // phpcs:ignore WordPress
			'Lifeline\\' => array( $vendorDir1 ), // phpcs:ignore WordPress
		);

		$class_loader = new ClassLoader;
		foreach ( $psr as $prefix => $paths ) {
			$class_loader->setPsr4( $prefix, $paths );
		}

		$class_loader->register();
	}

	/**
	 * includes
	 *
	 * @return void
	 */
	static function includes() {
		require_once get_template_directory() . '/includes/Libraries/ClassLoader.php';
		require_once get_template_directory() . '/includes/Functions.php';
		require_once get_template_directory() . '/includes/class-tgm-plugin-activation.php';// Merlin demo import.
	}

	/**
	 * start
	 *
	 * @return void
	 */
	static function start() {

		add_action( 'after_setup_theme', array( 'Lifeline\Classes\Setup', 'init' ) );
		// phpcs:ignore WordPress
		do_action( 'lifeline/theme/loaded' );

		Setup::other_init();

		add_action( 'wp_body_open', array( __CLASS__, 'header' ), 8 );
		add_action( 'wp_body_open', array( __CLASS__, 'banner' ), 100 );

	}

	/**
	 * header
	 *
	 * @return void
	 */
	static function header() {
		return ( new Classes\Header() )->header();
	}

	/**
	 * banner
	 *
	 * @return void
	 */
	static function banner() {
		$opt = lifeline()->options();
		return ( new \Lifeline\Classes\Header() )->banner( 'page', lifeline_get( $opt, 'page_banner_style', '1' ) );
	}
}

Loader::init();
