<?php
/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       5.0.0
 */
namespace Lifeline\Helpers;

class SocialProfile {


	private $atts;
	private $social_array;
	private $btn_css;

	function __construct( $atts, $social_array ) {
		$this->atts         = $atts;
		$this->social_array = $social_array;
		$this->btn_css      = $this->btnCss();
	}

	/**
	 * [get description]
	 * @param  [type] $key [description]
	 * @return [type]      [description]
	 */
	function get( $key ) {
		return lifeline_get( $this->social_array, $key );
	}

	function getAtt( $key ) { // phpcs:ignore WordPress
		return lifeline_get( $this->atts, $key );
	}

	/**
	 * [getPermalink description]
	 * @return [type] [description]
	 */
	private function getPermalink() { // phpcs:ignore WordPress
		if ( $this->getAtt( 'target_url' ) === 'custom_url' ) {
			$permalink = esc_url( $this->getAtt( 'custom_url' ) );
		} else {
			$permalink = esc_url( get_permalink() );
		}

		return $permalink;
	}

	/**
	 * [getType description]
	 * @return [type] [description]
	 */
	function getType() { // phpcs:ignore WordPress
		return str_replace( array( ' ', 'fab', 'fas', 'fa-', '-f', '-plus' ), '', $this->getIcon() );
	}

	function getIcon() { // phpcs:ignore WordPress
		return $this->get( 'social_icon' );
	}

	/**
	 * [output description]
	 * @return [type] [description]
	 */
	function output() { // phpcs:ignore WordPress
		if ( ! empty( $this->social_array ) && is_array( $this->social_array ) ) {
			$icon = $this->get( 'social_icon' );

			$icon_label = $this->get( 'icon_label' );

			$output = '<div class="' . lifeline_get( $atts, 'cols' ) . '">';

			$type = $this->getType();

			if ( method_exists( $this, $type ) ) {
				$output .= call_user_func( array( $this, $type ) );
			}

			$output .= '</div>';

			return $output;
		}
	}

	/**
	 * [btnCss description]
	 * @param  [type] $atts [description]
	 * @return [type]       [description]
	 */
	function btnCss() { // phpcs:ignore WordPress
		$btn_css  = '';
		$btn_css .= 'height:' . $this->getAtt( 'btn_size', '45px' ) . ';';
		$btn_css .= 'line-height:' . $this->getAtt( 'btn_size', '45px' ) . ';';
		$btn_css .= 'font-size:' . $this->getAtt( 'icon_size', '16px' ) . ';';

		$view_style = $this->getAtt( 'view_style' );
		if ( $view_style == 'icon' ) { // phpcs:ignore WordPress
			$btn_css .= 'width:' . $this->getAtt( 'btn_size', '45px' ) . ';';
		}

		return $btn_css;
	}

	/**
	 * Facebook
	 * @param  [type] $btn_css [description]
	 * @param  [type] $atts    [description]
	 * @return [type]          [description]
	 */
	function facebook() {

		return sprintf(
			'<a style="%s" href="http://www.facebook.com/sharer.php?u=%s" onClick="%s" class="%s"><i class="%s"></i><span class="font-weight-bold">%s</span></a>',
			$this->btnCss(),
			urlencode( esc_url( $this->getPermalink() ) ),
			'window.open(\'https://www.facebook.com/sharer.php?u=' . urlencode( esc_url( $this->getPermalink() ) ) . '\', \'Facebook\', \'width=600,height=300,left=\' + (screen.availWidth / 2 - 300) + \',top=\' + (screen.availHeight / 2 - 150) + \'\'); return false;',
			$this->getAtt( 'view_style' ) . ' ' . $this->getAtt( 'shape_style' ) . ' ' . $this->getType(),
			$this->getIcon(),
			$this->get( 'icon_label' )
		);
	}

	/**
	 * [twitter description]
	 * @return [type] [description]
	 */
	function twitter() {

		return sprintf(
			'<a style="%s" href="http://twitter.com/share?u=%s" onClick="%s" class="%s"><i class="%s"></i><span class="font-weight-bold">%s</span></a>',
			$this->btnCss(),
			urlencode( esc_url( $this->getPermalink() ) ),
			'window.open(\'http://twitter.com/share?u=' . urlencode( esc_url( $this->getPermalink() ) ) . '\', \'Twitter\', \'width=600,height=300,left=\' + (screen.availWidth / 2 - 300) + \',top=\' + (screen.availHeight / 2 - 150) + \'\'); return false;',
			$this->getAtt( 'view_style' ) . ' ' . $this->getAtt( 'shape_style' ) . ' ' . $this->getType(),
			$this->getIcon(),
			$this->get( 'icon_label' )
		);
	}

	/**
	 * [pinterest description]
	 * @return [type] [description]
	 */
	function pinterest() {

		return sprintf(
			'<a style="%s" href="http://twitter.com/share?u=%s" onClick="%s" class="%s"><i class="%s"></i><span class="font-weight-bold">%s</span></a>',
			$this->btnCss(),
			urlencode( esc_url( $this->getPermalink() ) ),
			'window.open(\'http://twitter.com/share?u=' . urlencode( esc_url( $this->getPermalink() ) ) . '\', \'Twitter\', \'width=600,height=300,left=\' + (screen.availWidth / 2 - 300) + \',top=\' + (screen.availHeight / 2 - 150) + \'\'); return false;',
			$this->getAtt( 'view_style' ) . ' ' . $this->getAtt( 'shape_style' ) . ' ' . $this->getType(),
			$this->getIcon(),
			$this->get( 'icon_label' )
		);
	}

	/**
	 * [reddit description]
	 * @return [type] [description]
	 */
	function reddit() {

		return sprintf(
			'<a style="%s" href="http://twitter.com/share?u=%s" onClick="%s" class="%s"><i class="%s"></i><span class="font-weight-bold">%s</span></a>',
			$this->btnCss(),
			urlencode( esc_url( $this->getPermalink() ) ),
			'window.open(\'http://twitter.com/share?u=' . urlencode( esc_url( $this->getPermalink() ) ) . '\', \'Twitter\', \'width=600,height=300,left=\' + (screen.availWidth / 2 - 300) + \',top=\' + (screen.availHeight / 2 - 150) + \'\'); return false;',
			$this->getAtt( 'view_style' ) . ' ' . $this->getAtt( 'shape_style' ) . ' ' . $this->getType(),
			$this->getIcon(),
			$this->get( 'icon_label' )
		);
	}

	/**
	 * [linkedin description]
	 * @return [type] [description]
	 */
	function linkedin() {

		return sprintf(
			'<a style="%s" href="http://twitter.com/share?u=%s" onClick="%s" class="%s"><i class="%s"></i><span class="font-weight-bold">%s</span></a>',
			$this->btnCss(),
			urlencode( esc_url( $this->getPermalink() ) ),
			'window.open(\'http://twitter.com/share?u=' . urlencode( esc_url( $this->getPermalink() ) ) . '\', \'Twitter\', \'width=600,height=300,left=\' + (screen.availWidth / 2 - 300) + \',top=\' + (screen.availHeight / 2 - 150) + \'\'); return false;',
			$this->getAtt( 'view_style' ) . ' ' . $this->getAtt( 'shape_style' ) . ' ' . $this->getType(),
			$this->getIcon(),
			$this->get( 'icon_label' )
		);
	}

	/**
	 * [dig description]
	 * @return [type] [description]
	 */
	function digg() {

		return sprintf(
			'<a style="%s" href="http://twitter.com/share?u=%s" onClick="%s" class="%s"><i class="%s"></i><span class="font-weight-bold">%s</span></a>',
			$this->btnCss(),
			urlencode( esc_url( $this->getPermalink() ) ),
			'window.open(\'http://twitter.com/share?u=' . urlencode( esc_url( $this->getPermalink() ) ) . '\', \'Twitter\', \'width=600,height=300,left=\' + (screen.availWidth / 2 - 300) + \',top=\' + (screen.availHeight / 2 - 150) + \'\'); return false;',
			$this->getAtt( 'view_style' ) . ' ' . $this->getAtt( 'shape_style' ) . ' ' . $this->getType(),
			$this->getIcon(),
			$this->get( 'icon_label' )
		);
	}

	/**
	 * [tumblr description]
	 * @return [type] [description]
	 */
	function tumblr() {

		return sprintf(
			'<a style="%s" href="http://twitter.com/share?u=%s" onClick="%s" class="%s"><i class="%s"></i><span class="font-weight-bold">%s</span></a>',
			$this->btnCss(),
			urlencode( esc_url( $this->getPermalink() ) ),
			'window.open(\'http://twitter.com/share?u=' . urlencode( esc_url( $this->getPermalink() ) ) . '\', \'Twitter\', \'width=600,height=300,left=\' + (screen.availWidth / 2 - 300) + \',top=\' + (screen.availHeight / 2 - 150) + \'\'); return false;',
			$this->getAtt( 'view_style' ) . ' ' . $this->getAtt( 'shape_style' ) . ' ' . $this->getType(),
			$this->getIcon(),
			$this->get( 'icon_label' )
		);
	}

	/**
	 * [vk description]
	 * @return [type] [description]
	 */
	function vk() {

		return sprintf(
			'<a style="%s" href="http://twitter.com/share?u=%s" onClick="%s" class="%s"><i class="%s"></i><span class="font-weight-bold">%s</span></a>',
			$this->btnCss(),
			urlencode( esc_url( $this->getPermalink() ) ),
			'window.open(\'http://twitter.com/share?u=' . urlencode( esc_url( $this->getPermalink() ) ) . '\', \'Twitter\', \'width=600,height=300,left=\' + (screen.availWidth / 2 - 300) + \',top=\' + (screen.availHeight / 2 - 150) + \'\'); return false;',
			$this->getAtt( 'view_style' ) . ' ' . $this->getAtt( 'shape_style' ) . ' ' . $this->getType(),
			$this->getIcon(),
			$this->get( 'icon_label' )
		);
	}

	/**
	 * [email description]
	 * @return [type] [description]
	 */
	function email() {

		return sprintf(
			'<a style="%s" href="http://twitter.com/share?u=%s" onClick="%s" class="%s"><i class="%s"></i><span class="font-weight-bold">%s</span></a>',
			$this->btnCss(),
			urlencode( esc_url( $this->getPermalink() ) ),
			'window.open(\'http://twitter.com/share?u=' . urlencode( esc_url( $this->getPermalink() ) ) . '\', \'Twitter\', \'width=600,height=300,left=\' + (screen.availWidth / 2 - 300) + \',top=\' + (screen.availHeight / 2 - 150) + \'\'); return false;',
			$this->getAtt( 'view_style' ) . ' ' . $this->getAtt( 'shape_style' ) . ' ' . $this->getType(),
			$this->getIcon(),
			$this->get( 'icon_label' )
		);
	}
}
