<?php
/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       5.0.0
 */
namespace Lifeline\Helpers;

trait Facade
{
	static $instance;
	/**
	 * [instance description]
	 * @return [type] [description]
	 */
	static function instance() {
		if(self::$instance == null) {
			self::$instance = new self;
		}

		return self::$instance;
	}
	/**
	 * Magic function to handle static or dynamic methods.
	 *
	 * @param  string $method     The method
	 * @param  array $parameters  Array of parameters.
	 * @return callable           Returns nothing.
	 */
	public function __call($method, $parameters = null) {

		$new = strtolower(str_replace('get', '', $method));

	    if(method_exists($this, $new)) {
	        return call_user_func([$this, $new], $parameters);
	    }
	}

	public static function __callStatic($method, $parameters) {
		$new = strtolower(str_replace('get', '', $method));

	    if(method_exists(__CLASS__, $new)) {
	        return call_user_func([self::instance(), $new], $parameters);
	    }
	}
}