<?php

/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       5.0.0
 */
if (!function_exists('lifeline')) {
	/**
	 * lifeline
	 *
	 * @return void
	 */
	function lifeline()
	{
		return Lifeline\Classes\Lifeline::instance();
	}
}

if (!function_exists('lifeline_get')) {

	/**
	 * lifeline_get
	 *
	 * @param  mixed $var
	 * @param  mixed $key
	 * @param  mixed $def
	 * @return void
	 */
	function lifeline_get($var, $key, $def = null)
	{
		if (is_object($var)) {
			$var = (array) $var;
		}
		return Lifeline\Classes\Arr::get($var, $key, $def);
	}
}

if (!function_exists('printr')) {

	/**
	 * printr
	 *
	 * @param  mixed $var
	 * @return void
	 */
	function printr($var)
	{
		echo '<pre>';
		print_r($var);
		echo '</pre>';
		exit;
	}
}

if (!function_exists('lifeline_build_social_array')) {
	function lifeline_build_social_array($array)
	{
		$found = array_map(
			function ($value) {
				$value = json_decode(urldecode($value['data']), true);
				if (lifeline_get($value, 'enable')) {
					// printr($value);
					return $value;
				}
				return false;
			},
			$array
		);

		return array_filter($found);
	}
}

if (!function_exists('lifeline2_social_share_output')) {
	/**
	 * lifeline2_social_share_output
	 *
	 * @param  mixed $icon
	 * @param  mixed $color
	 * @return void
	 */
	function lifeline2_social_share_output($icon, $color = false)
	{
		$permalink = get_permalink(get_the_ID());
		$titleget  = get_the_title();

		if ($icon == 'facebook') { // phpcs:ignore WordPress
			$fb = ($color == 1) ? 'style=color:#3b5998' : '';  // phpcs:ignore WordPress
?>
			<a class="position-relative" onClick="window.open('https://www.facebook.com/sharer.php?u=<?php echo esc_url($permalink); ?>', 'Facebook', 'width=600,height=300,left=' + (screen.availWidth / 2 - 300) + ',top=' + (screen.availHeight / 2 - 150) + '');
				return false;" href="https://www.facebook.com/sharer.php?u=<?php echo esc_url($permalink); ?>">
				<i class="fab fa-facebook-f" <?php echo esc_attr($fb); ?>></i></a>
		<?php
		}
		?>

		<?php
		if ($icon == 'twitter') { // phpcs:ignore WordPress
			$twitter = ($color == 1) ? 'style=color:#00aced' : ''; // phpcs:ignore WordPress
		?>
			<a class="position-relative" onClick='window.open("https://twitter.com/share?url=<?php echo esc_url($permalink) ?>&amp;text=<?php echo str_replace(' ', '%20', $titleget) ?>", "Twitter share", "width=600,height=300,left=" + (screen.availWidth / 2 - 300) + ' ,top=' + (screen.availHeight / 2 - 150) + "");
						return false;' href='https://twitter.com/share?url=<?php echo esc_url($permalink) ?>&amp;text=<?php echo str_replace(' ', '%20', $titleget) ?>'>
				<i class="fab fa-twitter" <?php echo esc_attr($twitter); ?>></i></a>
		<?php
		}
		?>

		<?php
		if ($icon == 'gplus') { // phpcs:ignore WordPress
			$gplus = ($color == 1) ? 'style=color:#dd4b39' : ''; // phpcs:ignore WordPress
		?>
			<a class="position-relative" onClick="window.open('https://plus.google.com/share?url=<?php echo esc_url($permalink); ?>', 'Google plus', 'width=585,height=666,left=' + (screen.availWidth / 2 - 292) + ',top=' + (screen.availHeight / 2 - 333) + '');
								return false;" href="https://plus.google.com/share?url=<?php echo esc_url($permalink); ?>">
				<i class="fab fa-google-plus" <?php echo esc_attr($gplus); ?>></i></a>
		<?php
		}
		?>

		<?php
		if ($icon == 'digg') { // phpcs:ignore WordPress
			$digg = ($color == 1) ? 'style=color:#000000' : ''; // phpcs:ignore WordPress
		?>
			<a class="position-relative" onClick="window.open('https://www.digg.com/submit?url=<?php echo esc_url($permalink); ?>', 'Digg', 'width=715,height=330,left=' + (screen.availWidth / 2 - 357) + ',top=' + (screen.availHeight / 2 - 165) + '');
										return false;" href="https://www.digg.com/submit?url=<?php echo esc_url($permalink); ?>">
				<i class="fab fa-digg" <?php echo esc_attr($digg); ?>></i> </a>
		<?php
		}
		?>

		<?php
		if ($icon == 'reddit') { // phpcs:ignore WordPress
			$reddit = ($color == 1) ? 'style=color:#ff5700' : ''; // phpcs:ignore WordPress
		?>
			<a class="position-relative" onClick='window.open("https://reddit.com/submit?url=<?php echo esc_url($permalink); ?>&amp;title=<?php echo str_replace(' ', '%20', $titleget); ?>", "Reddit", "width=617,height=514,left=" + (screen.availWidth / 2 - 308) + ",top=" + (screen.availHeight / 2 - 257) + "");
												return false;' href='https://reddit.com/submit?url=<?php echo esc_url($permalink); ?>&amp;title=<?php echo str_replace(' ', '%20', $titleget); ?>'>
				<i class="fab fa-reddit" <?php echo esc_attr($reddit); ?>></i></a>
		<?php
		}
		?>

		<?php
		if ($icon == 'linkedin') { // phpcs:ignore WordPress
			$linkeding = ($color == 1) ? 'style=color:#007bb6' : ''; // phpcs:ignore WordPress
		?>
			<a class="position-relative" onClick="window.open('https://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo esc_url($permalink); ?>', 'Linkedin', 'width=863,height=500,left=' + (screen.availWidth / 2 - 431) + ',top=' + (screen.availHeight / 2 - 250) + '');
														return false;" href="https://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo esc_url($permalink); ?>">
				<i class="fab fa-linkedin" <?php echo esc_attr($linkeding); ?>></i></a>
		<?php
		}
		?>

		<?php
		if ($icon == 'pinterest') { // phpcs:ignore WordPress
			$pinterest = ($color == 1) ? 'style=color:#cb2027' : ''; // phpcs:ignore WordPress
		?>
			<a class="position-relative" href='javascript:void((function(){var e=document.createElement(&apos;script&apos;);e.setAttribute(&apos;type&apos;,&apos;text/javascript&apos;);e.setAttribute(&apos;charset&apos;,&apos;UTF-8&apos;);e.setAttribute(&apos;src&apos;,&apos;http://assets.pinterest.com/js/pinmarklet.js?r=&apos;+Math.random()*99999999);document.body.appendChild(e)})());'>
				<i class="fab fa-pinterest-p" <?php echo esc_attr($pinterest); ?>></i></a>
		<?php
		}
		?>

		<?php
		if ($icon == 'stumbleupon') { // phpcs:ignore WordPress
			$stumbleupon = ($color == 1) ? 'style=color:#EB4823' : ''; // phpcs:ignore WordPress
		?>
			<a class="position-relative" onClick='window.open("https://www.stumbleupon.com/submit?url=<?php echo esc_url($permalink); ?>&amp;title=<?php echo str_replace(' ', '%20', $titleget); ?>", "Stumbleupon", "width=600,height=300,left=" + (screen.availWidth / 2 - 300) + ",top=" + (screen.availHeight / 2 - 150) + "" );
																		return false;' href='https://www.stumbleupon.com/submit?url=<?php echo esc_url($permalink); ?>&amp;title=<?php echo str_replace(' ', '%20', $titleget); ?>'>
				<i class="fab fa-stumbleupon" <?php echo esc_attr($stumbleupon); ?>></i></a>
		<?php
		}
		?>

		<?php
		if ($icon == 'tumblr') { // phpcs:ignore WordPress
			$tumblr = ($color == 1) ? 'style=color:#32506d' : ''; // phpcs:ignore WordPress
			$str    = $permalink;
			$str    = preg_replace('#^https?://#', '', $str);
		?>
			<a class="position-relative" onClick='window.open("https://www.tumblr.com/share/link?url=<?php echo esc_url($str); ?>&amp;name=<?php echo str_replace(' ', '%20', $titleget); ?>", "Tumblr", "width=600,height=300,left=" + (screen.availWidth / 2 - 300) + ",top=" + (screen.availHeight / 2 - 150) + "" );
																				return false;' href='https://www.tumblr.com/share/link?url=<?php echo esc_url($str); ?>&amp;name=<?php echo str_replace(' ', '%20', $titleget); ?>'>
				<i class="fab fa-tumblr" <?php echo esc_attr($tumblr); ?>></i></a>
		<?php
		}
		?>

		<?php
		if ($icon == 'email') { // phpcs:ignore WordPress
			$mail = ($color == 1) ? 'style=color:#000000' : ''; // phpcs:ignore WordPress
		?>
			<a class="position-relative" href='mailto:?Subject=<?php echo str_replace(' ', '%20', $titleget) ?>&amp;Body=<?php echo esc_url($permalink); ?>'><i class="fas fa-envelope <?php echo esc_attr($mail); ?>"></i></a>
		<?php
		}
	}
}

if (!function_exists('lifeline_get_tags')) {
	/**
	 * lifeline_get_tags
	 *
	 * @return void
	 */
	function lifeline_get_tags()
	{
		$tags = get_tags(get_the_ID());
		$html = '';
		foreach ($tags as $tag) {
			$tag_link = get_tag_link($tag->term_id);

			$html .= "<a class='d-inline-block position-relative font-weight-bold' href='{$tag_link}' title='{$tag->name}'>";
			$html .= "<span class='d-block position-relative'>{$tag->name}</span></a>";
		}
		echo wp_kses($html, true);
	}
}

if (!function_exists('lifeline_comments_list')) {
	/**
	 * lifeline_comments_list
	 *
	 * @param  mixed $comment
	 * @param  mixed $args
	 * @param  mixed $depth
	 * @return void
	 */
	function lifeline_comments_list($comment, $args, $depth)
	{
		$GLOBALS['comment'] = $comment;
		?>
		<li class="w-100">
			<div id="comment-<?php comment_ID(); ?>" class="comment comment-box mt-30 position-relative d-flex w-100">
				<span>
					<?php echo get_avatar($comment, 152, '', 'author', array('class' => 'img-fluid')); ?>
				</span>
				<div class="comment-detail">
					<?php
					if ($comment->comment_approved == '0') : // phpcs:ignore WordPress
					?>
						<span><?php esc_html_e('Your comment is awaiting moderation.', 'lifeline'); ?></span>
					<?php endif; ?>
					<h4 class="mb-0 font-weight-semibold text-dark">
						<?php echo esc_html($comment->comment_author); ?>
						<span><?php esc_html_e('Says:', 'lifeline'); ?></span>
					</h4>
					<i class="font-style-normal text-theme d-block"><?php echo get_comment_date(); ?></i>
					<p><?php echo get_comment_text(); ?></p>
					<?php
					ob_start();
					comment_reply_link(
						array_merge(
							$args,
							array(
								'depth'     => $depth,
								'max_depth' => $args['max_depth'],
							)
						)
					);
					$out = ob_get_clean();
					$out = str_replace('comment-reply-link', 'comment-reply-link comment-reply-link position-absolute font-weight-semibold', $out);
					echo wp_kses($out, wp_kses_allowed_html(true));
					?>
				</div>
			</div>
		</li>
		<?php
	}
}

if (!function_exists('lifeline_comment_form')) {
	/**
	 * lifeline_comment_form
	 *
	 * @param  mixed $args
	 * @param  mixed $post_id
	 * @return void
	 */
	function lifeline_comment_form($args = array(), $post_id = null)
	{
		if (null === $post_id) {
			$post_id = get_the_ID();
		} else {
			$id = $post_id;
		}
		$commenter     = wp_get_current_commenter();
		$user          = wp_get_current_user();
		$user_identity = $user->exists() ? $user->display_name : '';
		$args          = wp_parse_args($args);
		if (!isset($args['format'])) {
			$args['format'] = current_theme_supports('html5', 'comment-form') ? 'html5' : 'xhtml';
		}
		$req      = get_option('require_name_email');
		$aria_req = ($req ? " aria-required='true'" : '');
		$html5    = 'html5' === $args['format'];
		$fields   = array(
			'author' => '<div class="col-md-6 col-sm-12 col-lg-6"><input class="bg-white rounded w-100" id="author" placeholder="' . esc_html__('Name', 'lifeline') . '" name="author" type="text" value="' . esc_attr($commenter['comment_author']) . '" ' . $aria_req . ' /></div>',
			'email'  => '<div class="col-md-6 col-sm-12 col-lg-6"><input class="bg-white rounded w-100" id="email" name="email" ' . ($html5 ? 'type="email"' : 'type="text"') . ' value="' . esc_attr($commenter['comment_author_email']) . '" size="30"' . $aria_req . ' placeholder="' . esc_html__('Email', 'lifeline') . '" /></div>',
			'url'    => '<div class="col-md-12 col-sm-12 col-lg-12"><input class="bg-white rounded w-100" id="url" placeholder="' . esc_html__('URL', 'lifeline') . '" name="' . esc_html__('URL', 'lifeline') . '" ' . ($html5 ? 'type="url"' : 'type="text"') . ' value="' . esc_attr($commenter['comment_author_url']) . '"  /></div>',
		);

		$defaults = array(
			'fields'              => apply_filters('comment_form_default_fields', $fields),
			'comment_field'       => '<textarea class="bg-white rounded w-100" id="comment" name="comment" aria-required="true" placeholder="' . esc_attr__('Comment', 'lifeline') . '" ></textarea>',
			// phpcs:ignore WordPress
			'must_log_in'         => '<p class="must-log-in">' . sprintf(esc_html__('You must be %s to post a comment.', 'lifeline'), '<a href="' . esc_url(wp_login_url(apply_filters('the_permalink', get_permalink($post_id)))) . '">' . esc_html__('logged in', 'lifeline') . '</a>') . '</p>',
			'logged_in_as'        => '<div class="col-md-12 col-sm-12 col-lg-12"><p class="logged-in-as">' . sprintf(esc_html__('Logged in as ', 'lifeline') . '<a href="%1$s">%2$s</a>. <a href="%3$s" title="' . esc_html__('Log out of this account', 'lifeline') . '">' . esc_html__('Log out', 'lifeline') . '?</a>', get_edit_user_link(), $user_identity, wp_logout_url(apply_filters('the_permalink', get_permalink($post_id)))) . '</p></div>',
			// phpcs:ignore WordPress
			'comment_notes_after' => '<p class="form-allowed-tags">' . sprintf(esc_html__('You may use these %1$s tags and attributes: %2$s', 'lifeline'), '<abbr title="' . esc_html('HyperText Markup Language', 'dailyhealth') . '">' . esc_html__('HTML', 'lifeline') . '</abbr>', ' <code>' . allowed_tags() . '</code>') . '</p>',
			'id_form'             => 'commentform',
			'id_submit'           => 'submit',
			// phpcs:ignore WordPress
			'title_reply'         => '<h3 class="font-weight-semibold text-dark">' . esc_html__('Leave', 'lifeline') . ' <span class="text-theme">' . esc_html__('A Comment', 'lifeline') . '</span></h3>',
			// phpcs:ignore WordPress
			'title_reply_to'      => esc_html__('Leave a Reply to %s', 'lifeline'),
			'cancel_reply_link'   => esc_html__('Cancel reply', 'lifeline'),
			'label_submit'        => esc_html__('Post Comment', 'lifeline'),
			'format'              => 'xhtml',
		);
		$args     = wp_parse_args($args, apply_filters('comment_form_defaults', $defaults));
		if (comments_open($post_id)) :
			do_action('comment_form_before');
			if (get_option('comment_registration') && !is_user_logged_in()) :
				echo wp_kses($args['must_log_in'], true);
				do_action('comment_form_must_log_in_after');
			else :
		?>
				<div id="respond" class="comments reply-comments mt-50">
					<?php comment_form_title($args['title_reply'], $args['title_reply_to']); ?>
					<small><?php cancel_comment_reply_link($args['cancel_reply_link']); ?></small>
					<form class="gen-form-wrap w-100" action="<?php echo site_url('/wp-comments-post.php'); ?>" method="post" id="<?php echo esc_attr($args['id_form']); ?>" <?php echo wp_kses($html5, true) ? ' novalidate' : ''; ?>>
						<div id="result"></div>
						<div class="row mrg10">
							<?php
							do_action('comment_form_top');
							if (is_user_logged_in()) :
								echo apply_filters('comment_form_logged_in', $args['logged_in_as'], $commenter, $user_identity);
								do_action('comment_form_logged_in_after', $commenter, $user_identity);
							else :
								do_action('comment_form_before_fields');
								foreach ((array) $args['fields'] as $name => $field) {
									echo apply_filters("comment_form_field_{$name}", $field) . "\n";
								}
								do_action('comment_form_after_fields');
							endif;
							?>
							<div class="col-md-12 col-sm-12 col-lg-12">
								<?php
								echo apply_filters('comment_form_field_comment', $args['comment_field']);
								?>
								<button class="theme-btn mt-30 text-white bg-theme overflow-hidden d-inline-block commen-text position-relative rounded font-weight-bold" type="submit" name="submit" id="<?php echo esc_attr($args['id_submit']); ?>"><?php echo esc_attr($args['label_submit']); ?></button>
							</div>
							<?php comment_id_fields($post_id); ?>
						</div>
						<?php do_action('comment_form', $post_id); ?>
					</form>
				</div>
			<?php endif; ?>
			<?php do_action('comment_form_after'); ?>
		<?php else : ?>
			<?php do_action('comment_form_comments_closed'); ?>
		<?php endif; ?>
	<?php
	}
}

if (!function_exists('lifeline_the_pagination_blog')) {
	/**
	 * lifeline_the_pagination
	 *
	 * @param  mixed $cutom_query
	 * @param  mixed $args
	 * @param  mixed $echo
	 * @return void
	 */
	function lifeline_the_pagination_blog($cutom_query = '', $args = array(), $echo = 1)
	{
		global $wp_query;

		$default = array(
			'base'      => str_replace(99999, '%#%', esc_url(get_pagenum_link(99999))),
			'format'    => '?paged=%#%',
			'show_all'  => false,
			'current'   => max(1, get_query_var('paged')),
			'total'     => '',
			'mid_size'  => 4,
			'next_text' => '<i class="fas fa-angle-double-right"></i>',
			'prev_text' => '<i class="fas fa-angle-double-left"></i>',
			'type'      => 'list',
		);

		if ($cutom_query) {
			$default['total'] = $cutom_query;
		} else {
			$default['total'] = $wp_query->max_num_pages;
		}

		$args       = wp_parse_args($args, $default);
		$ul_classes = apply_filters(
			// phpcs:ignore WordPress
			'lifeline/pagination/ul_classes',
			array(
				'pagenation',
				'text-center',

			)
		);
		$a_classes = apply_filters(
			// phpcs:ignore WordPress
			'lifeline/pagination/a_classes',
			array(
				'page-numbers',

			)
		);
		$li_classes = apply_filters(
			// phpcs:ignore WordPress
			'lifeline/pagination/li_classes',
			array(
				'page-itemm',

			)
		);
		$pagination = '' . str_replace(
			array(
				'<ul class=\'page-numbers\'>',
				'<li>',
				'page-numbers',
			),
			array(
				'<ul class="' . implode(' ', $ul_classes) . '">',
				'<li class="' . implode(' ', $li_classes) . '">',
				implode(' ', $a_classes),
			),
			paginate_links($args)
		) . '';

		if (paginate_links(array_merge(array('type' => 'array'), $args))) {
			if ($echo) {
				echo '<div class="pagination-wrap d-inline-block w-100 text-center">' . wp_kses_post($pagination) . '</div>';
			}

			return '<div class="pagination-wrap d-inline-block w-100 text-center">' . $pagination . '</div>';
		}
	}
}

if (!function_exists('lifeline_color')) {
	/**
	 * lifeline_color
	 *
	 * @param  mixed $content
	 * @return void
	 */
	function lifeline_color($content)
	{
		$content = str_replace(array('%STR_COLOR%', '%ED_COLOR%'), array('<span class="text-theme">', '</span>'), $content);

		return $content;
	}
}

if (!function_exists('lifeline_enternal_style')) {
	/**
	 * lifeline_enternal_style
	 *
	 * @param  mixed $style
	 * @return void
	 */
	function lifeline_enternal_style($style)
	{
		echo '<style type="text/css">' . $style . '</style>';
	}
}

if (!function_exists('lifeline_sidebar_hook')) {

	/**
	 * sidebar
	 *
	 * @param  mixed $sidebar
	 * @return void
	 */

	add_action('lifeline/post/sidebar', 'lifeline_sidebar_hook', 10, 1);
	function lifeline_sidebar_hook($sidebar)
	{
	?>
		<div class="col-md-6 col-sm-12 col-lg-3">
			<aside class="sidebar-wrap2 w-100">
				<?php dynamic_sidebar($sidebar); ?>
			</aside>
		</div>
<?php
	}
}



if (!function_exists('lifeline_filesystem')) {
	/**
	 * lifeline_filesystem
	 *
	 * @return void
	 */
	function lifeline_filesystem()
	{
		if (!function_exists('require_filesystem_credentials')) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}

		/* you can safely run request_filesystem_credentials() without any issues and don't need to worry about passing in a URL */
		$creds = request_filesystem_credentials(esc_url(home_url('/')), '', false, false, array());

		/* initialize the API */
		if (!WP_Filesystem($creds)) {
			/* any problems and we exit */
			return false;
		}

		global $wp_filesystem;
		/* do our file manipulations below */

		return $wp_filesystem;
	}
}
if (!function_exists('lifeline_cm_price_with_symbole')) {
	function lifeline_cm_price_with_symbole($price, $class = 'font-style-normal font-weight-bold')
	{
		$settings = wpcm_get_settings();
		//print_r($settings); exit;
		$symbol   = webinane_currency_symbol();
		$position = $settings->get('currency_position', 'left');
		$sep      = $settings->get('thousand_saparator', ''); // Thousand Separator
		$d_sep    = $settings->get('decimal_separator', '.'); // Decimal separator
		$d_point  = $settings->get('number_decimals', 0); // Decimal numbers

		$price = number_format((float) $price, (int) $d_point, $d_sep, $sep); // Aplly formation on number.

		if ($position == 'right') {
			return wp_kses_post($price . ' <i class="' . $class . '">' . $symbol . '</i>');
		} else {
			return wp_kses_post('<i class="' . $class . '">' . $symbol . '</i> ' . $price);
		}
	}
}

if (!function_exists('lifeline_el_tpl')) {

	function lifeline_el_tpl($id)
	{
		if (!$id) {
			return false;
		}

		if (class_exists('\Elementor\Plugin') && $id) {
			echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display($id);
		}
	}
}



//Demo Import Files Starts Here

function ocdi_import_files()
{
	return [
		[
			'import_file_name'           => 'Demo Import 1',
			'categories'                 => ['Main Demo', 'Demo 2'],
			'import_file_url'            => 'https://webinane-themes-plugins.s3.amazonaws.com/lifeline-elementor/import-data/content.xml',
			'import_widget_file_url'     => 'https://webinane-themes-plugins.s3.amazonaws.com/lifeline-elementor/import-data/widgets.wie',
			'import_customizer_file_url' => 'https://webinane-themes-plugins.s3.amazonaws.com/lifeline-elementor/import-data/customizer.dat',
			'import_redux'               => [
				[
					'file_url'    => 'https://webinane-themes-plugins.s3.amazonaws.com/lifeline-elementor/import-data/redux_options.json',
					'option_name' => 'lifeline_theme_options',
				],
			],
			'import_preview_image_url'   => 'https://webinane-themes-plugins.s3.amazonaws.com/lifeline-elementor/import-data/demo-1.png',
			'preview_url'                => 'https://lifeline.webinane.com',
		],

	];
}
add_filter('ocdi/import_files', 'ocdi_import_files');

function ocdi_register_plugins($plugins)
{
	$theme_plugins = [
	
	];

	return array_merge($plugins, $theme_plugins);
}

function import_slider_revolution_slides($slide_path)
{

	if (class_exists('RevSlider')) {

		$rev_slider = new RevSlider();

		$import_result = $rev_slider->importSliderFromPost(true, true, $slide_path);


		if (is_array($import_result) && !empty($import_result['success'])) {
			return true;
		} else {
			return false;
		}
	} else {
		return false;
	}
}

add_filter('ocdi/register_plugins', 'ocdi_register_plugins');
function ocdi_after_import_setup()
{

	//Asdign menus to their locations
	$main_menu = get_term_by('name', 'Main Menu', 'nav_menu');
	$footer_menu = get_term_by('name', 'Footer Menu', 'nav_menu');
	set_theme_mod(
		'nav_menu_locations',
		[
			'main_menu' => $main_menu->term_id,
			'footer_menu' => $footer_menu->term_id,
		]
	);

	// Get the front page.
	// Assign front page and posts page (blog page).
	$front_page_id = get_page_by_title('NonProfit Donation Demo - Lifeline Theme');
	$blog_page_id  = get_page_by_title('Our Blog');

	update_option('show_on_front', 'page');
	update_option('page_on_front', $front_page_id->ID);
	update_option('page_for_posts', $blog_page_id->ID);

	// Import Slider Revolution slides.
	$slide_paths = [
		get_template_directory() . '/import/slides/deeds.zip',
		get_template_directory() . '/import/slides/slide2-1.zip',
		get_template_directory() . '/import/slides/slide2-11.zip',

	];

	foreach ($slide_paths as $slide_path) {
		import_slider_revolution_slides($slide_path);
	}

	echo 'Slides imported successfully.';

	// //Import color schemes
	if (class_exists('Elementor\Plugin')) {

		$kit = Elementor\Plugin::$instance->kits_manager->get_active_kit_for_frontend();
		$system_items = $kit->get_settings_for_display('system_colors');
		$system_items[0]['color'] = '#F56A01';
		$system_items[1]['color'] = '#6B195A';
		$system_items[2]['color'] = '#6B6B6B';
		$system_items[3]['color'] = '#FFFAE1';
		Elementor\Plugin::$instance->kits_manager->update_kit_settings_based_on_option(
			'system_colors',
			$system_items
		);
		// Container width
		$container_width = $kit->get_settings_for_display('container_width');
		$container_width['size'] = '1320';
		Elementor\Plugin::$instance->kits_manager->update_kit_settings_based_on_option(
			'container_width',
			$container_width
		);
		// Clear Cache: regenerate css file in upload folder
		Elementor\Plugin::$instance->files_manager->clear_cache();

		$post_types = ['post', 'page', 'product', 'lif_service', 'lif_story', 'lif_team', 'lif_event', 'lif_gallery', 'cause', 'project'];

		// update_option('elementor_allow_svg', '1');
		update_option('elementor_cpt_support', $post_types);
		update_option('elementor_disable_color_schemes', 'yes');
		update_option('elementor_disable_typography_schemes', 'yes');
	}
	//Import lifeline donation pro settings

	function import_lifeline_donation_pro_settings($url)
	{
		$response = wp_remote_get($url);

		if (is_wp_error($response)) {
			return false;
		}

		$body = wp_remote_retrieve_body($response);
		$new_settings = json_decode($body, true);

		if (json_last_error() !== JSON_ERROR_NONE) {
			return false;
		}

		$existing_settings = get_option('_wpcommerce_settings');

		if (!$existing_settings || !is_array($existing_settings)) {
			$existing_settings = [];
		}

		$updated_settings = array_merge($existing_settings, $new_settings);

		return update_option('_wpcommerce_settings', $updated_settings);
	}



	// Import Lifeline Donation Pro settings
	$settings_url = 'https://webinane-themes-plugins.s3.amazonaws.com/lifeline-elementor/import-data/lifeline-donation-pro-settings.json';
	import_lifeline_donation_pro_settings($settings_url);

	echo 'Lifeline Donation Pro settings imported successfully.';
}
add_action('ocdi/after_import', 'ocdi_after_import_setup');

function ocdi_plugin_page_setup($default_settings)
{
	$default_settings['parent_slug'] = 'themes.php';
	$default_settings['page_title']  = esc_html__('One Click Demo Import', 'one-click-demo-import');
	$default_settings['menu_title']  = esc_html__('Import Lifeline Demo Data', 'one-click-demo-import');
	$default_settings['capability']  = 'import';
	$default_settings['menu_slug']   = 'one-click-demo-import';

	return $default_settings;
}
add_filter('ocdi/plugin_page_setup', 'ocdi_plugin_page_setup');
// Enable SVG support for uploads
// function allow_svg_upload($mimes)
// {
// 	$mimes['svg'] = 'image/svg+xml';
// 	return $mimes;
// }
// add_filter('upload_mimes', 'allow_svg_upload');

// Fix SVG display in media library
// function fix_svg_display()
// {
// 	echo '<style>
//         .attachment-266x266, .thumbnail img {
//             width: 100% !important;
//             height: auto !important;
//         }
//     </style>';
// }
// add_action('admin_head', 'fix_svg_display');
