<?php

/**
 * @package     LifeLine
 * @author      webinane team <support@webinane.com>
 * @since       5.0.0
 */

namespace Lifeline\Classes;

class Tgmpa
{

	private static $plugins = array();

	static function init()
	{
		self::plugins();
		self::run();
	}

	static function plugins()
	{
		$plugins = array(

			'revslider'              => array(
				'name'               => esc_html__('Revolution Slider', 'lifeline'),
				'slug'               => 'revslider',
				'source'             => 'https://webinane-themes-plugins.s3.amazonaws.com/revslider.zip',
				'force_deactivation' => false,
				'file_path'          => ABSPATH . 'wp-content/plugins/revslider/revslider.php',
				'preselected'		=>	true,
				'required'			=>	true,
			),
			'lifeline-plugin'                => array(
				'name'               => esc_html__('Lifeline Plugin', 'lifeline'),
				'slug'               => 'lifeline-plugin',
				'source'             => 'https://webinane-themes-plugins.s3.amazonaws.com/lifeline-elementor/lifeline-plugin.zip',
				'preselected'		=>	true,
				'required'			=>	true,
				'force_deactivation' => false,
				'version'            => '2.3',
				'file_path'          => ABSPATH . 'wp-content/plugins/lifeline-plugin/lifeline-plugin.php',
			),
			'webinane-redux'         => array(
				'name'               => esc_html__('Webinane Redux', 'lifeline'),
				'slug'               => 'webinane-redux',
				'source'             => 'https://webinane-themes-plugins.s3.amazonaws.com/lifeline-elementor/webinane-redux.zip',
				'required'           => true,
				'preselected'		=>	true,
				'force_deactivation' => false,
				'version'            => '4.1.23',
				'file_path'          => ABSPATH . 'wp-content/plugins/webinane-redux/redux-framework.php',
			),
	
			'lifeline-donation-pro'   => array(
				'name'               => esc_html__('Lifeline Donation Pro', 'lifeline'),
				'slug'               => 'lifeline-donation-pro',
				'source'             => 'https://webinane-themes-plugins.s3.amazonaws.com/lifeline-donation-pro.zip',
				'required'           => false,
				'force_deactivation' => false,
				'preselected'		=>	true,
				'version'            => '2.0',
				'file_path'          => ABSPATH . 'wp-content/plugins/lifeline-donation-pro/lifeline-donation-pro.php',
			),
	
			'webinane-responsive-header' => array(
				'name'               => esc_html__('Webinane Responsive Header', 'lifeline'),
				'slug'               => 'webinane-responsive-header',
				'source'             => 'https://webinane-themes-plugins.s3.amazonaws.com/webinane-responsive-header-v1.0.4.zip',
				'force_deactivation' => false,
				'required'           => true,
				'preselected'		=>	true,
				'version'            => '1.0.4',
				'file_path'          => ABSPATH . 'wp-content/plugins/webinane-responsive-header/webinane-responsive-header.php',
			),
	
			'envato-market'                   => array(
				'name'        => esc_html__('Envato Market', 'esperto'),
				'slug'        => 'envato-market',
				'source'      => 'https://envato.github.io/wp-envato-market/dist/envato-market.zip',
				'required'    => false,
				'preselected'		=>	true,
				'recommended' => true,
			),
	
			'mailchimp-for-wp'                => array(
				'name'     => esc_html__('MC4WP', 'lifeline'),
				'slug'     => 'mailchimp-for-wp',
				'required' => true,
				'preselected'		=>	true,
			),
	
			'woocommerce'                     => array(
				'name' => esc_html__('Woocommerce', 'lifeline'),
				'slug' => 'woocommerce',
				'preselected'	=> true,
			),
	
			'elementor'                       => array(
				'name'     => esc_html__('Elementor', 'lifeline'),
				'slug'     => 'elementor',
				'required' => true,
				'preselected'	=>	true,
			),
	
			'webinane-elementor'                   => array(
				'name'        => esc_html__('Webinane Elementor', 'esperto'),
				'slug'        => 'webinane-elementor',
				'source'      => 'https://webinane-themes-plugins.s3.amazonaws.com/webinane-elementor.zip',
				'version'	=>	'1.8',
				'required'    => true,
				'preselected'		=>	true,
				'recommended' => true,
			),
	
			'contact-form-7'                  => array(
				'name'     => esc_html__('Contact Form 7', 'lifeline'),
				'slug'     => 'contact-form-7',
				'required' => true,
				'preselected'	=>	true,
			),
			'classic-editor'                  => array(
				'name' => esc_html__('Classic Editor', 'lifeline'),
				'slug' => 'classic-editor',
				'preselected'	=>	true,
			),

			'ocdi'                       => array(
				'name'     => esc_html__('One Click Demo Import', 'lifeline'),
				'slug'     => 'one-click-demo-import/',
				'required' => true,
			),

		);
		// phpcs:ignore WordPress
		$plugins = apply_filters('lifeline/tgmpa-plugins', $plugins);

		self::$plugins = $plugins;
	}

	static function run()
	{
		/*Change this to your theme text domain, used for internationalising strings.*/
		$config = array(
			'id'           => 'tgmpa',
			'default_path' => '',
			'menu'         => 'tgmpa-install-plugins',
			'parent_slug'  => 'themes.php',
			'capability'   => 'edit_theme_options',
			'has_notices'  => true,
			'dismissable'  => true,
			'dismiss_msg'  => '',
			'is_automatic' => false,
			'message'      => '',
		);
		tgmpa(self::$plugins, $config);
	}
}
